<cfif isdefined("vars.consulta")>
	<script language="javascript1.2" src="/_scripts/scripts_db.js"></script>
	<cfswitch expression="#vars.consulta#">
		<cfcase value="20">
			<cfscript>
				conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
				qrConhecimento = conn.get_conhecimento_dados(argumentCollection = vars);
			</cfscript>
			<cfif qrConhecimento.recordcount gt 0>
				<cfoutput>
                <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="#qrConhecimento.conhecimento_id#" />
                <input type="hidden" name="CNPJ_CPF_FILIAL_CONSULTA" value="#qrConhecimento.cnpj_cpf_filial#" />
                <input type="hidden" name="SERIE_CONSULTA" value="#qrConhecimento.serie#" />
                <input type="hidden" name="CANCELADO_CONSULTA" value="#qrConhecimento.cancelado#" />
                <input type="hidden" name="COMPLEMENTO_NUM_ROMANEIO" value="#qrConhecimento.NUM_ROMANEIO#" />
                <fieldset><legend>Dados do Conhecimento</legend>
                <table width="100%" border="0" cellspacing="1" cellpadding="3">
                  <tr>
                    <td width="12%" class="texto"><nobr>N&ordm; Conhecimento: </nobr> </td>
                    <td width="10%" class="texto_negrito">#qrConhecimento.num_conhecimento#/#qrConhecimento.serie#</td>
                    <td width="7%" class="texto">Emiss&atilde;o:</td>
                    <td width="25%" class="texto_negrito">#LSDateFormat(qrConhecimento.data_emissao)# #TimeFormat(qrConhecimento.data_emissao,'HH:MM')#</td>
                    <td width="7%" class="texto">&nbsp;</td>
                    <td width="39%" class="texto">&nbsp;</td>
                  </tr>
                  
                  <tr>
                    <td class="texto">Remetente:</td>
                    <td colspan="5" class="texto"><span class="texto_negrito">#qrConhecimento.rem_cnpj_cpf# - #qrConhecimento.rem_razao_social#</span></td>
                  </tr>
                  <tr>
                    <td class="texto">Endere&ccedil;o:</td>
                    <td colspan="3" class="texto_negrito"><span class="">#qrConhecimento.rem_cep# - #qrConhecimento.rem_endereco#</span></td>
                    <td class="texto">Munic&iacute;pio:</td>
                    <td class="texto"><span class="texto_negrito">#qrConhecimento.rem_municipio#/#qrConhecimento.rem_uf#</span></td>
                  </tr>
                  <tr>
                    <td class="texto">Destinat&aacute;rio:</td>
                    <td colspan="5" class="texto_negrito">#qrConhecimento.dest_cnpj_cpf# - #qrConhecimento.dest_razao_social#</td>
                  </tr>
                  <tr>
                    <td class="texto">Endere&ccedil;o:</td>
                    <td colspan="3" class="texto_negrito">#qrConhecimento.dest_cep# - #qrConhecimento.dest_endereco#</td>
                    <td class="texto">Munic&iacute;pio:</td>
                    <td class="texto"><span class="texto_negrito">#qrConhecimento.dest_municipio#/#qrConhecimento.dest_uf#</span></td>
                  </tr>
                </table>
                </fieldset>
                </cfoutput>
			<cfelse>
                <table width="100%" border="0" cellspacing="1" cellpadding="3">
                  <tr>
                    <td class="obrigatorio">Conhecimento no encontrado ou pertence a outra filial.</td>
                  </tr>
                 </table>
                <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="" />
                <input type="hidden" name="COMPLEMENTO_NUM_ROMANEIO" value="-1" />
			</cfif>
		</cfcase>
        
		<cfcase value="21">
        	<cfparam name="vars.MUNICIPAL" default="0">
            <cfparam name="vars.tipo_documento" default="">
			<cfscript>
				conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
				qrRomaneio = conn.get_romaneio_aberto(num_romaneio = vars.num_romaneio);
				qrItem = conn.get_romaneio_item(num_romaneio = vars.num_romaneio, frete_proprio=vars.FRETE_PROPRIO , tipo_documento = vars.tipo_documento);
				conn2 = CreateComponent("_transportes.consulta.cfc_controle_trafego");				
				qrPosicaoAtual = conn2.get_ultimo_itinerario(placa = qrRomaneio.PLACA_REFERENCIA);
			</cfscript>
			<cfif qrItem.recordCount eq 0>
                    <script language="javascript1.2">
                        alert('O romaneio indicado no possui itens para a emisso!');
                    </script>
                    <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                    <span class="obrigatorio">O romaneio indicado no possui itens para a emisso!</span>
                    <cfabort/>
            </cfif>	
    
            <cfif vars.MUNICIPAL eq 1 and qrItem.ORIGEM_MUNICIPIO_ID NEQ qrItem.DESTINO_MUNICIPIO_ID>
                    <script language="javascript1.2">
                        alert('O romaneio indicado no  MUNICIPAL!');
                    </script>
                    <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                    <span class="obrigatorio">O romaneio indicado no  MUNICIPAL!</span>
                    <cfabort/>
            </cfif>	
            
            <cfif qrRomaneio.recordcount>
            <cfoutput>
                <input type="hidden" name="NUM_ROMANEIO_ROMANEIO" value="#qrromaneio.num_romaneio#" />
                <input type="hidden" name="PLACA_CONTROLE_ROMANEIO" value="#qrromaneio.placa_controle#" />
                <input type="hidden" name="COMPOSICAO_ROMANEIO" value="#qrromaneio.composicao#" />
                <input type="hidden" name="PROPRIETARIO_ROMANEIO" value="#qrromaneio.veiculo_proprietario#" />
    
                <input type="hidden" name="NUM_NATUREZA_ROMANEIO" value="#qrromaneio.num_natureza#" />
                <input type="hidden" name="NUM_ESPECIE_ROMANEIO" value="#qrromaneio.num_especie#" />
                <input type="hidden" name="COD_UNIDADE_ROMANEIO" value="#qrromaneio.cod_unidade#" />
                <input type="hidden" name="NUM_ENTREGAS" value="#qrromaneio.num_entregas#" />
                <input type="hidden" name="ITEMS_ROMANEIO" value="#ValueList(qrItem.item_id)#" />
                <input type="hidden" name="MUNICIPIO_ID_ORIGEM" value="#qrPosicaoAtual.destino_municipio_id#" />
                <input type="hidden" name="MUNICIPIO_ORIGEM" value="#qrPosicaoAtual.municipio#" />
				<cfif isDefined("vars.lotacao") and vars.lotacao neq 0>
					<cfif qrRomaneio.COD_PESSOA_FILIAL neq session.COD_PESSOA and vars.FRETE_PROPRIO eq 1>
                    <script language="javascript1.2">
                        alert('O romaneio indicado pertence a outra filial!');
                    </script>
                    <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                    <span class="obrigatorio">O romaneio indicado pertence a outra filial!</span>
                    <cfabort/>
                    <cfelse>
                        <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="1" />
                    </cfif>
                <cfelse>
                        <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="1" />
                </cfif>
                    
                <cfif qrRomaneio.POSSUI_INTERNACIONAL neq 0>
                    <span class="obrigatorio">Romaneio possui itens de viagens internacionais, no  pertido emitir CTRC.</span>
                    <input type="hidden" name="ROMANEIO_INTERNACIONAL" value="1" />
                    <cfabort/>
                <cfelse>
                    <input type="hidden" name="ROMANEIO_INTERNACIONAL" value="0" />
                </cfif>
    			<!---/*(vars.FRETE_PROPRIO eq 1 and qrRomaneio.SITUACAO_ID neq 0) or*/--->
                <cfif  (vars.FRETE_PROPRIO eq 0 and qrRomaneio.SITUACAO_ID eq 2)>
                    <input type="hidden" name="ROMANEIO_SITUACAO" value="#qrRomaneio.SITUACAO_ID#" />
                    <span class="obrigatorio">Romaneio encerrado!</span>
                    <cfabort/>
                </cfif>
                
                <fieldset><legend>Dados do Romaneio</legend><table border="0" cellpadding="3" cellspacing="1">
                  <tr>
                    <td class="texto">Data In&iacute;cio: </td>
                    <td colspan="3" class="texto_negrito">#LSDateFormat(qrRomaneio.data_inicio)# #TimeFormat(qrRomaneio.data_inicio,'HH:MM')#</td>
                  </tr>
                  <tr>
                    <td class="texto">Carregamento:</td>
                    <td class="texto_negrito">#qrRomaneio.carregamento#</td>
                    <td class="texto">Destino:</td>
                    <td class="texto_negrito">#qrRomaneio.destino#</td>
                  </tr>
                  <tr>
                    <td class="texto">Cliente:</td>
                    <td colspan="3" class="texto_negrito">#qrRomaneio.cliente# </td>
                  </tr>
                  <tr>
                    <td class="texto">Remetente:</td>
                    <td colspan="3" class="texto_negrito">#qrRomaneio.remetente#</td>
                  </tr>
                  <tr>
                    <td class="texto">Destinatario:</td>
                    <td colspan="3" class="texto_negrito">#qrRomaneio.destinatario#</td>
                  </tr>
                  <tr>
                    <td class="texto">Mercadoria:</td>
                    <td colspan="3" class="texto_negrito">#qrRomaneio.natureza#</td>
                  </tr>
                </table></fieldset></cfoutput>
                <fieldset><legend>Itens do Romaneio</legend><table width="100%" border="0" cellspacing="1" cellpadding="3" class="borda">
                    <thead>
                  <tr class="titulo_1" onclick="sortColumn(event)">
                    <td type="nao_ordenar" width="1%">&nbsp;</td>
                    <td type="caseinsensitivestring" width="7%">Carga</td>
                    <td type="caseinsensitivestring" width="7%">Agendamento</td>
                    <td type="caseinsensitivestring" width="7%">Operao</td>
                    <td type="caseinsensitivestring" width="17%">Remetente</td>
                    <td type="caseinsensitivestring" width="19%">Origem</td>
                    <td type="caseinsensitivestring" width="20%">Destinat&aacute;rio</td>
                    <td type="caseinsensitivestring" width="23%">Destino</td>
                    <td type="number" width="4%">Peso</td>
                    <td type="number" width="5%">Valor</td>
                    <td style="display:none" type="caseinsensitivestring" width="9%">Rota</td>
                  </tr>
                  </thead>
                  <tbody>
                  <cfif vars.FRETE_PROPRIO eq 1>
                      <tr class="linha_2" onmouseover="this.className = 'linha_over'" onmouseout="this.className = 'linha_2'" style="display:none">
                        <td><input name="ITEM_ID_ROMANEIO" id="ITEM_ID_ROMANEIO_00" type="radio" class="check" value="00" onclick="f_vincula_item_romaneio('00')"></td>
                        <td colspan="8"><button onclick="f_vincula_item_romaneio('00')" type="button" class="botao-16x16"><img alt="Insere uma nova entrega" src="/_imagens/botoes/16x16/caminhao.gif" width="16" height="16" align="absmiddle">&nbsp;Nova Entrega</button></td>
                      </tr>
                      <input type="hidden" name="ITEM_ID_ROMANEIO_00" id="ITEM_ID_ROMANEIO_00" value="0" />
                      <input type="hidden" name="OPERACAO_ID_ROMANEIO_00" id="OPERACAO_ID_ROMANEIO_00" value="" />
                      <input type="hidden" name="NUM_PRODUTO_ROMANEIO_00" id="NUM_PRODUTO_ROMANEIO_00" value="" />
                      <input type="hidden" name="REGRA_FISCAL_ID_ROMANEIO_00" id="REGRA_FISCAL_ID_ROMANEIO_00" value="" />
                      <input type="hidden" name="PAGADOR_ROMANEIO_00" id="PAGADOR_ROMANEIO_00" value="" />
                      <input type="hidden" name="VIAGEM_CARGA_ID_ROMANEIO_00" id="VIAGEM_CARGA_ID_ROMANEIO_00" value="" />
        
                      <input type="hidden" name="COD_REMETENTE_ROMANEIO_00" id="COD_REMETENTE_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="REM_RAZAO_SOCIAL_ROMANEIO_00" id="REM_RAZAO_SOCIAL_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="REM_CNPJ_CPF_ROMANEIO_00" id="REM_CNPJ_CPF_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="REM_ENDERECO_ROMANEIO_00" id="REM_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="REM_ENDERECO_NUM_ROMANEIO_00" id="REM_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="REM_CEP_ROMANEIO_00" id="REM_CEP_ROMANEIO_00" 							value="" />
                      <input type="hidden" name="REM_MUNICIPIO_ROMANEIO_00" id="REM_MUNICIPIO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="REM_INSCRICAO_ESTADUAL_ROMANEIO_00" id="REM_INSCRICAO_ESTADUAL_ROMANEIO_00" value="" />
                      <input type="hidden" name="REM_UF_ROMANEIO_00" id="REM_UF_ROMANEIO_00" 							value="" />
                      <input type="hidden" name="REM_MUNICIPIO_ID_ROMANEIO_00" id="REM_MUNICIPIO_ID_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="REM_BAIRRO_ROMANEIO_00" id="REM_BAIRRO_ROMANEIO_00" 					value="" />
        
                      <input type="hidden" name="COD_DESTINATARIO_ROMANEIO_00" id="COD_DESTINATARIO_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="DEST_RAZAO_SOCIAL_ROMANEIO_00" id="DEST_RAZAO_SOCIAL_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="DEST_CNPJ_CPF_ROMANEIO_00" id="DEST_CNPJ_CPF_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="DEST_ENDERECO_ROMANEIO_00" id="DEST_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="DEST_ENDERECO_NUM_ROMANEIO_00" id="DEST_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="DEST_CEP_ROMANEIO_00" id="DEST_CEP_ROMANEIO_00" 						value="" />
                      <input type="hidden" name="DEST_MUNICIPIO_ROMANEIO_00" id="DEST_MUNICIPIO_ROMANEIO_00" 			value="" />
                      <input type="hidden" name="DEST_INSCRICAO_ESTADUAL_ROMANEIO_00" id="DEST_INSCRICAO_ESTADUAL_ROMANEIO_00" value="" />
                      <input type="hidden" name="DEST_UF_ROMANEIO_00" id="DEST_UF_ROMANEIO_00" 							value="" />
                      <input type="hidden" name="DEST_MUNICIPIO_ID_ROMANEIO_00" id="DEST_MUNICIPIO_ID_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="DEST_BAIRRO_ROMANEIO_00" id="DEST_BAIRRO_ROMANEIO_00" 					value="" />
        
                      <input type="hidden" name="COD_CONSIGNATARIO_ROMANEIO_00" id="COD_CONSIGNATARIO_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="CONS_RAZAO_SOCIAL_ROMANEIO_00" id="CONS_RAZAO_SOCIAL_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="CONS_CNPJ_CPF_ROMANEIO_00" id="CONS_CNPJ_CPF_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="CONS_ENDERECO_ROMANEIO_00" id="CONS_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="CONS_CEP_ROMANEIO_00" id="CONS_CEP_ROMANEIO_00" 						value="" />
                      <input type="hidden" name="CONS_MUNICIPIO_ROMANEIO_00" id="CONS_MUNICIPIO_ROMANEIO_00" 			value="" />
                      <input type="hidden" name="CONS_INSCRICAO_ESTADUAL_ROMANEIO_00" id="CONS_INSCRICAO_ESTADUAL_ROMANEIO_00" value="" />
                      <input type="hidden" name="CONS_UF_ROMANEIO_00" id="CONS_UF_ROMANEIO_00" 							value="" />
        
                      <input type="hidden" name="COD_CLIENTE_COBRANCA_ROMANEIO_00" id="COD_CLIENTE_COBRANCA_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="COB_RAZAO_SOCIAL_ROMANEIO_00" id="COB_RAZAO_SOCIAL_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="COB_CNPJ_CPF_ROMANEIO_00" id="COB_CNPJ_CPF_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="COB_ENDERECO_ROMANEIO_00" id="COB_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="COB_CEP_ROMANEIO_00" id="COB_CEP_ROMANEIO_00" 						value="" />
                      <input type="hidden" name="COB_MUNICIPIO_ROMANEIO_00" id="COB_MUNICIPIO_ROMANEIO_00" 			value="" />
                      <input type="hidden" name="COB_INSCRICAO_ESTADUAL_ROMANEIO_00" id="COB_INSCRICAO_ESTADUAL_ROMANEIO_00" value="" />
                      <input type="hidden" name="COB_UF_ROMANEIO_00" id="COB_UF_ROMANEIO_00" 							value="" />
                      <input type="hidden" name="COB_MUNICIPIO_ID_ROMANEIO_00" id="COB_MUNICIPIO_ID_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="COB_BAIRRO_ROMANEIO_00" id="COB_BAIRRO_ROMANEIO_00" 					value="" />
    
                      <input type="hidden" name="COD_NEGOCIADOR_ROMANEIO_00" id="COD_NEGOCIADOR_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="NEG_RAZAO_SOCIAL_ROMANEIO_00" id="NEG_RAZAO_SOCIAL_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="NEG_CNPJ_CPF_ROMANEIO_00" id="NEG_CNPJ_CPF_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="NEG_ENDERECO_ROMANEIO_00" id="NEG_ENDERECO_ROMANEIO_00" 				value="" />
                      <input type="hidden" name="NEG_CEP_ROMANEIO_00" id="NEG_CEP_ROMANEIO_00" 						value="" />
                      <input type="hidden" name="NEG_MUNICIPIO_ROMANEIO_00" id="NEG_MUNICIPIO_ROMANEIO_00" 			value="" />
                      <input type="hidden" name="NEG_INSCRICAO_ESTADUAL_ROMANEIO_00" id="NEG_INSCRICAO_ESTADUAL_ROMANEIO_00" value="" />
                      <input type="hidden" name="NEG_UF_ROMANEIO_00" id="NEG_UF_ROMANEIO_00" 							value="" />
                      <input type="hidden" name="NEG_MUNICIPIO_ID_ROMANEIO_00" id="NEG_MUNICIPIO_ID_ROMANEIO_00" 		value="" />
                      <input type="hidden" name="NEG_BAIRRO_ROMANEIO_00" id="NEG_BAIRRO_ROMANEIO_00" 					value="" />
        
                      <input type="hidden" name="PESO_ROMANEIO_00" id="_ROMANEIO_00" value="" />
                      <input type="hidden" name="FRETE_UNITARIO_ROMANEIO_00" id="_ROMANEIO_00" value="" />
                      <input type="hidden" name="OBSERVACAO_ROMANEIO_00" id="_ROMANEIO_00" value="" />
                      <input type="hidden" name="DATA_ENTREGA_FIM_ROMANEIO_00" id="DATA_ENTREGA_FIM_ROMANEIO_00" value="" />
                  </cfif>	  
                  <cfoutput query="qrItem">
                  <tr class="linha_2" onmouseover="this.className = 'linha_over'" onmouseout="this.className = 'linha_2'">
                    <td><input name="ITEM_ID_ROMANEIO" id="ITEM_ID_ROMANEIO_#qrItem.item_id#" type="radio" class="check" value="#qrItem.item_id#" onclick="f_vincula_item_romaneio(#qrItem.item_id#)"></td>
                    <td align="right">#qritem.solicitacao_carga_id#</td>
                    <td align="right">#qritem.viagem_id#</td>
	                <td nowrap="nowrap">#qritem.operacao#</td>
                    <td>#qritem.remetente#</td>
                    <td>#qritem.rem_municipio#-#qrItem.rem_uf#</td>
                    <td>#qritem.destinatario#</td>
                    <td>#qritem.dest_municipio#-#qrItem.dest_uf#</td>
                    <td align="right">#NumberFormat(qrItem.peso,'._')#</td>
                    <td align="right">#NumberFormat(qrItem.valor_frete,'._')#</td>
                    <td style="display:none" align="center">#qritem.rota_abreviatura#</td>
                  </tr>
                  <input type="hidden" name="ITEM_ID_ROMANEIO_#qrItem.item_id#" id="ITEM_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.item_id#" />
                  <input type="hidden" name="OPERACAO_ID_ROMANEIO_#qrItem.item_id#" id="OPERACAO_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.operacao_id#" />
                  <input type="hidden" name="NUM_PRODUTO_ROMANEIO_#qrItem.item_id#" id="NUM_PRODUTO_ROMANEIO_#qrItem.item_id#" value="#qrItem.num_produto#" />
                  <input type="hidden" name="REGRA_FISCAL_ID_ROMANEIO_#qrItem.item_id#" id="REGRA_FISCAL_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.regra_fiscal_id#" />
                  <input type="hidden" name="PAGADOR_ROMANEIO_#qrItem.item_id#" id="PAGADOR_ROMANEIO_#qrItem.item_id#" value="#qrItem.frete_por_conta#" />
                  <input type="hidden" name="VIAGEM_CARGA_ID_ROMANEIO_#qrItem.item_id#" id="VIAGEM_CARGA_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.viagem_carga_id#" />
                  
    
                  <input type="hidden" name="COD_REMETENTE_ROMANEIO_#qrItem.item_id#" id="COD_REMETENTE_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.cod_remetente#" />
                  <input type="hidden" name="REM_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" id="REM_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.remetente#" />
                  <input type="hidden" name="REM_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" id="REM_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.rem_cnpj_cpf#" />
                  <input type="hidden" name="REM_ENDERECO_ROMANEIO_#qrItem.item_id#" id="REM_ENDERECO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.rem_logradouro#" />
                  <input type="hidden" name="REM_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" id="REM_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.rem_endereco_num#" />
                  <input type="hidden" name="REM_CEP_ROMANEIO_#qrItem.item_id#" id="REM_CEP_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.rem_cep#" />
                  <input type="hidden" name="REM_MUNICIPIO_ROMANEIO_#qrItem.item_id#" id="REM_MUNICIPIO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.rem_municipio#" />
                  <input type="hidden" name="REM_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" id="REM_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" value="#qrItem.rem_inscr_estadual#" />
                  <input type="hidden" name="REM_UF_ROMANEIO_#qrItem.item_id#" id="REM_UF_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.rem_uf#" />
                  <input type="hidden" name="REM_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" id="REM_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.rem_municipio_id#" />
                  <input type="hidden" name="REM_BAIRRO_ROMANEIO_#qrItem.item_id#" id="REM_BAIRRO_ROMANEIO_#qrItem.item_id#" 						 value="#qrItem.rem_bairro#" />
    
                  <input type="hidden" name="COD_DESTINATARIO_ROMANEIO_#qrItem.item_id#" id="COD_DESTINATARIO_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.cod_destinatario#" />
                  <input type="hidden" name="DEST_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" id="DEST_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.destinatario#" />
                  <input type="hidden" name="DEST_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" id="DEST_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.dest_cnpj_cpf#" />
                  <input type="hidden" name="DEST_ENDERECO_ROMANEIO_#qrItem.item_id#" id="DEST_ENDERECO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.dest_logradouro#" />
                  <input type="hidden" name="DEST_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" id="DEST_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.dest_endereco_num#" />
                  <input type="hidden" name="DEST_CEP_ROMANEIO_#qrItem.item_id#" id="DEST_CEP_ROMANEIO_#qrItem.item_id#" 							 value="#qrItem.dest_cep#" />
                  <input type="hidden" name="DEST_MUNICIPIO_ROMANEIO_#qrItem.item_id#" id="DEST_MUNICIPIO_ROMANEIO_#qrItem.item_id#" 				 value="#qrItem.dest_municipio#" />
                  <input type="hidden" name="DEST_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" id="DEST_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" value="#qrItem.dest_inscr_estadual#" />
                  <input type="hidden" name="DEST_UF_ROMANEIO_#qrItem.item_id#" id="DEST_UF_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.dest_uf#" />
                  <input type="hidden" name="DEST_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" id="DEST_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.dest_municipio_id#" />
                  <input type="hidden" name="DEST_BAIRRO_ROMANEIO_#qrItem.item_id#" id="DEST_BAIRRO_ROMANEIO_#qrItem.item_id#" 						 value="#qrItem.dest_bairro#" />
    
                  <input type="hidden" name="COD_CONSIGNATARIO_ROMANEIO_#qrItem.item_id#" id="COD_CONSIGNATARIO_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.cod_consignatario#" />
                  <input type="hidden" name="CONS_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" id="CONS_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.cons_RAZAO_SOCIAL#" />
                  <input type="hidden" name="CONS_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" id="CONS_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.cons_cnpj_cpf#" />
                  <input type="hidden" name="CONS_ENDERECO_ROMANEIO_#qrItem.item_id#" id="CONS_ENDERECO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.cons_endereco#" />
                  <input type="hidden" name="CONS_CEP_ROMANEIO_#qrItem.item_id#" id="CONS_CEP_ROMANEIO_#qrItem.item_id#" 							 value="#qrItem.cons_cep#" />
                  <input type="hidden" name="CONS_MUNICIPIO_ROMANEIO_#qrItem.item_id#" id="CONS_MUNICIPIO_ROMANEIO_#qrItem.item_id#" 				 value="#qrItem.cons_municipio#" />
                  <input type="hidden" name="CONS_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" id="CONS_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" value="#qrItem.cons_inscricao_estadual#" />
                  <input type="hidden" name="CONS_UF_ROMANEIO_#qrItem.item_id#" id="CONS_UF_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.cons_uf#" />
    
                  <input type="hidden" name="COD_CLIENTE_COBRANCA_ROMANEIO_#qrItem.item_id#" id="COD_CLIENTE_COBRANCA_ROMANEIO_#qrItem.item_id#" 	 value="#qrItem.cod_cliente_cobranca#" />
                  <input type="hidden" name="COB_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" id="COB_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.cob_razao_social#" />
                  <input type="hidden" name="COB_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" id="COB_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.cob_cnpj_cpf#" />
                  <input type="hidden" name="COB_ENDERECO_ROMANEIO_#qrItem.item_id#" id="COB_ENDERECO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.cob_endereco#" />
                  <input type="hidden" name="COB_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" id="COB_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" 		     value="#qrItem.cob_endereco_numero#" />
                  <input type="hidden" name="COB_CEP_ROMANEIO_#qrItem.item_id#" id="COB_CEP_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.cob_cep#" />
                  <input type="hidden" name="COB_MUNICIPIO_ROMANEIO_#qrItem.item_id#" id="COB_MUNICIPIO_ROMANEIO_#qrItem.item_id#" 				 	 value="#qrItem.cob_municipio#" />
                  <input type="hidden" name="COB_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" id="COB_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" value="#qrItem.cob_inscricao_estadual#" />
                  <input type="hidden" name="COB_UF_ROMANEIO_#qrItem.item_id#" id="COB_UF_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.cob_uf#" />
                  <input type="hidden" name="COB_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" id="COB_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.cob_municipio_id#" />
                  <input type="hidden" name="COB_BAIRRO_ROMANEIO_#qrItem.item_id#" id="COB_BAIRRO_ROMANEIO_#qrItem.item_id#" 						 value="" />
    
                  <input type="hidden" name="COD_NEGOCIADOR_ROMANEIO_#qrItem.item_id#" id="COD_NEGOCIADOR_ROMANEIO_#qrItem.item_id#" 				 value="#qrItem.cod_negociador#" />
                  <input type="hidden" name="NEG_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" id="NEG_RAZAO_SOCIAL_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.neg_razao_social#" />
                  <input type="hidden" name="NEG_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" id="NEG_CNPJ_CPF_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.neg_cnpj_cpf#" />
                  <input type="hidden" name="NEG_ENDERECO_ROMANEIO_#qrItem.item_id#" id="NEG_ENDERECO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.neg_endereco#" />
                  <input type="hidden" name="NEG_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" id="NEG_ENDERECO_NUM_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.neg_endereco_num#" />
                  <input type="hidden" name="NEG_CEP_ROMANEIO_#qrItem.item_id#" id="NEG_CEP_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.neg_cep#" />
                  <input type="hidden" name="NEG_MUNICIPIO_ROMANEIO_#qrItem.item_id#" id="NEG_MUNICIPIO_ROMANEIO_#qrItem.item_id#" 					 value="#qrItem.neg_municipio#" />
                  <input type="hidden" name="NEG_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" id="NEG_INSCRICAO_ESTADUAL_ROMANEIO_#qrItem.item_id#" value="#qrItem.neg_inscricao_estadual#" />
                  <input type="hidden" name="NEG_UF_ROMANEIO_#qrItem.item_id#" id="NEG_UF_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.neg_uf#" />
                  <input type="hidden" name="NEG_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" id="NEG_MUNICIPIO_ID_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.neg_municipio_id#" />
                  <input type="hidden" name="NEG_BAIRRO_ROMANEIO_#qrItem.item_id#" id="NEG_BAIRRO_ROMANEIO_#qrItem.item_id#" 						 value="#qrItem.neg_bairro#" />
    
                  <input type="hidden" name="PESO_ROMANEIO_#qrItem.item_id#" id="_ROMANEIO_#qrItem.item_id#" 										 value="#qrItem.peso#" />
                  <input type="hidden" name="FRETE_UNITARIO_ROMANEIO_#qrItem.item_id#" id="_ROMANEIO_#qrItem.item_id#" 								 value="#qrItem.frete_valor_unitario#" />
                  <input type="hidden" name="DATA_ENTREGA_FIM_ROMANEIO_#qrItem.item_id#" id="DATA_ENTREGA_FIM_ROMANEIO_#qrItem.item_id#" 			 value="#qrItem.data_entrega_fim#" />
                  </cfoutput>
                  </tbody>
    
                </table>
                </fieldset>
                <cfelse>
                    <span class="obrigatorio">Romaneio no encontrado!</span>
                </cfif>
		</cfcase>

        <cfcase value="6">
        	<cfset v_retorno = structnew()>
        	<cftry>
				<cfscript>
                    conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
					
					if(IsDefined('vars.PLACA_REFERENCIA_INTERNA')) {
						v_placa_referencia_interna = Replace(vars.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
					}
					else {
						v_placa_referencia_interna = '';
					}
					
                    qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
																				DESTINO_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
																				COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
																				NUM_NATUREZA		 = vars.NUM_NATUREZA,
																				COMPOSICAO			 = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna);
                </cfscript>
				<cfif qrTabelaFreteRotaId.erro>
                    <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
                </cfif>
                
                <cfscript>
					conn_cons_doc = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
					qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO		   = vars.NUM_ROMANEIO,
																		  ITEM_ID 			   = vars.ITEM_ID,
																		  COD_DESTINATARIO 	   = vars.COD_DESTINATARIO,
																		  PRODUTO_ID  		   = vars.NUM_PRODUTO,
																		  PAGO_POR 			   = vars.PAGADOR,
																		  COLETA_UF 		   = vars.COLETA_UF,
																		  ENTREGA_UF 		   = vars.RED_UF,
																		  ST_ICMS_ID 		   = vars.ST_ICMS_ID,
																		  COD_REMETENTE 	   = vars.COD_REMETENTE,
																		  REGRA_FISCAL_ID 	   = vars.REGRA_FISCAL,
																		  COB_UF 			   = vars.COB_UF,
																		  COLETA_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
																		  ENTREGA_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
																		  VIAGEM_CARGA_ID 	   = vars.VIAGEM_CARGA_ID,
																		  COD_CLIENTE_COBRANCA = vars.COD_CLIENTE_COBRANCA,
																		  UF_FILIAL 		   = vars.UF_FILIAL_EMISSAO,
																		  NOTA_FISCAL 		   = 0);
				</cfscript>
                <cfif qrDadosFiscais.erro>
                    <cfthrow object="#qrDadosFiscais.mensagem#">
                </cfif>
                
                <cfscript>
					conn_cons_vei = CreateComponent("_transportes.consulta.cfc_veiculo");
					qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna);
				</cfscript>
                <cfif qrNumeroEixos.erro>
                    <cfthrow object="#qrNumeroEixos.mensagem#">
                </cfif>
                
                <cfscript>
					qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					
					vars.TABELA_FRETE_ID	  = qrTabelaFreteRota.TABELA_FRETE_ID;
					vars.TABELA_FRETE_ROTA_ID = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID;
					vars.PRODUTO_ID 		  = qrDadosFiscais.PRODUTO_ID;
					vars.DOCUMENTO_ID		  = 1; // Conhecimento de Transporte Rodovirio de Cargas
					
					// Constantes
					vars.CONSTANTE_VIAGEM_CARGA_ID		 = vars.VIAGEM_CARGA_ID;
					vars.CONSTANTE_PESO_BRUTO            = ArraySum(conn_cons_tf.ListaToArray(lista = vars, variavel = 'NOTA_PESO_KG_CONVERTIDO_NOTAS_FISCAIS'));
					vars.CONSTANTE_PESO_COBRADO          = ArraySum(conn_cons_tf.ListaToArray(lista = vars, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS'));
					vars.CONSTANTE_VOLUMES				 = ArraySum(conn_cons_tf.ListaToArray(lista = vars, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS'));
					vars.CONSTANTE_VALOR_MERCADORIA      = ArraySum(conn_cons_tf.ListaToArray(lista = vars, variavel = 'NOTA_VALOR_NOTAS_FISCAIS'));
					vars.CONSTANTE_MUNICIPIO_ID_ORIGEM   = vars.COLETA_MUNICIPIO_ID;
					vars.CONSTANTE_MUNICIPIO_ID_DESTINO  = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID));
					vars.CONSTANTE_FRETE_PROPRIO		 = qrDadosFiscais.FRETE_PROPRIO;
					vars.CONSTANTE_UF_TOMADOR			 = qrDadosFiscais.TOMADOR_UF;
					vars.CONSTANTE_COD_ATIVIDADE_TOMADOR = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
					
					if(IsDefined('vars.VAR_ST_ICMS_ID')) {
						v_st_icms_id = vars.VAR_ST_ICMS_ID;
					}
					else {
						v_st_icms_id = Trim(qrDadosFiscais.ST_ICMS_ID);
					}
					
					// Para CTRC a situao RECOLHIDO ANTECIPADAMENTE  60 E NO 81 COMO NO CTE
					if (v_st_icms_id eq '81') {
					   v_st_icms_id = '60';
					}
					
					vars.CONSTANTE_ST_ICMS_ID 	= v_st_icms_id;
					vars.CONSTANTE_PLACA_TRACAO	= vars.PLACA_CONTROLE;
					
					if(v_placa_referencia_interna eq '') {
						vars.CONSTANTE_PLACA_CARRETA = '';
					}
					else {
						vars.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
					}
					
					vars.CONSTANTE_NRO_EIXOS = qrNumeroEixos.EIXOS;
					// ----------
					
					qrCalculo = conn_cons_tf.calculo_tabela_frete(argumentCollection = vars);
				</cfscript>
                <cfif qrCalculo.erro>
                    <cfthrow object="#qrCalculo.mensagem#">
                </cfif>
                
                <script type="text/javascript">
					with(parent.document.forms[0]) {
						<cfoutput>
							NUM_PRODUTO.value = '#JSStringFormat(qrDadosFiscais.PRODUTO_ID)#';
							
							<cfif not IsDefined('vars.VAR_ST_ICMS_ID')>
								<cfif IsDefined('vars.TIPO_COMPLEMENTO_ID') and vars.TIPO_COMPLEMENTO_ID neq 1 and vars.TIPO_COMPLEMENTO_ID neq 3>
									ST_ICMS_ID.value       = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.value = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
								<cfelseif not IsDefined('vars.TIPO_COMPLEMENTO_ID')>
									ST_ICMS_ID.value          = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.value    = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.disabled = true;
									ST_ICMS_ID_COMBO.onchange = function() {};
								</cfif>
								
								parent.v_st_icms_id_calculada = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
							<cfelse>
								ST_ICMS_ID.value       	      = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
								ST_ICMS_ID_COMBO.value 		  = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
								parent.v_st_icms_id_calculada = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
							</cfif>
							
							CFOP.value 				= '#JSStringFormat(qrDadosFiscais.CFOP)#';
							CFOP_ID.value 			= '#JSStringFormat(qrDadosFiscais.CFOP_ID)#';
							NATUREZA_OPERACAO.value = '#JSStringFormat(qrDadosFiscais.NATUREZA_OPERACAO)#';
							
							<cfif not (IsDefined('vars.COMPLEMENTO') and Len(Trim(vars.COMPLEMENTO)))>
								FUNDAMENTACAO_LEGAL.value = '#JSStringFormat(qrDadosFiscais.FUNDAMENTACAO_LEGAL)#';
							<cfelse>
								<cfif vars.TIPO_COMPLEMENTO_ID eq 2>
									FUNDAMENTACAO_LEGAL.value = '#JSStringFormat(qrDadosFiscais.FUNDAMENTACAO_LEGAL)#';
								</cfif>
							</cfif>
							
							if(!FUNDAMENTACAO_LEGAL.value) {
								FUNDAMENTACAO_LEGAL.style.display = 'none';
							}
							else {
								FUNDAMENTACAO_LEGAL.style.display = '';
							}	
						</cfoutput>
					}
				</script>
                
                <div id="div_negociacao_tabela_frete" style="display: none;">
                    <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td valign="top">
                            	<table border="0">
                                    <tr>
                                        <td valign="top">
                                            <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                <tr class="titulo_1">
                                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                    <td nowrap align="left">Valor</td>
                                                    <td nowrap align="center">Tipo</td>
                                                </tr>
												<cfoutput query="qrCalculo.query">
                                                    <cfswitch expression="#qrCalculo.query.TIPO#">
                                                        <cfcase value="0">
                                                            <cfset v_imagem = 'seta_matriz'>
                                                            <cfset v_tipo   = 'Interna - No Editvel'>
                                                        </cfcase>
                                                        <cfcase value="1">
                                                            <cfset v_imagem = 'fx'>
                                                            <cfset v_tipo   = 'Frmula'>
                                                        </cfcase>
                                                        <cfcase value="2">
                                                            <cfset v_imagem = 'arquivo_detalhes'>
                                                            <cfset v_tipo   = 'Valor - Informando na Tabela'>
                                                        </cfcase>
                                                        <cfcase value="3">
                                                            <cfset v_imagem = 'editar'>
                                                            <cfset v_tipo   = 'Valor - Informando na Emisso do Documento'>
                                                        </cfcase>
                                                    </cfswitch>
                                                    <tr class="linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#';">
                                                        <td nowrap align="left">#qrCalculo.query.DESCRICAO#</td>
                                                        <td nowrap align="left"><input type="text" name="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" id="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" maxlength="15" value="<cfif IsNumeric(qrCalculo.query.VALOR)>#NumberFormat(Replace(qrCalculo.query.VALOR, ',', '.', 'all'), '_.__')#<cfelse>#qrCalculo.query.VALOR#</cfif>" <cfif qrCalculo.query.TIPO eq 3>obrigatorio="1"<cfelse>readonly</cfif> <cfif IsNumeric(qrCalculo.query.VALOR)>tipo="numerico"</cfif> display="#UCase(qrCalculo.query.DESCRICAO)#" onChange="this.value = Number(this.value); <cfif qrCalculo.query.TIPO eq 3>f_calculos();</cfif>" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px; text-align: right;" /></td>
                                                        <td nowrap align="center"><img src="/_imagens/botoes/16x16/#v_imagem#.gif" alt="#v_tipo#" title="#v_tipo#" width="16" height="16" align="absmiddle" /></td>
                                                    </tr>
                                                    <cfif qrCalculo.query.CurrentRow neq qrCalculo.query.RecordCount and qrCalculo.query.CurrentRow%10 eq 0>
														</table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                        <tr class="titulo_1">
                                                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                            <td nowrap align="left">Valor</td>
                                                            <td nowrap align="center">Tipo</td>
                                                        </tr>
                                                	</cfif>
                                            	</cfoutput>
                                                <tr class="linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#';">
                                                    <td colspan="2" nowrap align="left">&nbsp;</td>
                                                    <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="Executar C&aacute;lculos" title="Executar C&aacute;lculos" width="16" height="16" align="absmiddle" /></button></td>
                                                </tr>
                                            </table>
                                        </td>
                                	</tr>
                                </table>
                            </td>
                            <td valign="top" style="padding-left: 20px;">
                                <fieldset><legend>Dados da Tabela de Frete</legend>
                                <table border="0" cellspacing="1" cellpadding="3">
                                    <cfoutput>
                                    <tr>
                                        <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                        <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                                    </tr>
                                    <tr>
                                        <td nowrap align="left" class="texto">Rota:</td>
                                        <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                                    </tr>
                                    <tr>
                                        <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                        <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                                    </tr>
                                    <tr>
                                        <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                        <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                                    </tr>
                                    </cfoutput>
                                </table>
                                </fieldset>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <cfset v_retorno.erro = false>
                <cfcatch>
                	<cfset v_retorno.erro = true>
					<cfset v_retorno.mensagem = cfcatch>
                    
                    <div id="div_negociacao_tabela_frete" style="display: none;">
                    	<table border="0" cellspacing="1" cellpadding="3">
                            <tr class="obrigatorio">
                                <td align="left"><button type="button" class="botao-16x16" onClick="f_calculos()" style="margin-right: 5px;"><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Tentar Novamente" title="Tentar Novamente" width="16" height="16" align="absmiddle" /></button>
									<cfoutput>#JSStringFormat(Trim(fnc_format_erro(argumentCollection = v_retorno)))#</cfoutput></td>
                            </tr>
                        </table>
                    </div>
                </cfcatch>
			</cftry>
            
            <script type="text/javascript">
				parent.document.getElementById('tr_negociacao_carregando').style.display = 'none';
				parent.document.getElementById('tr_negociacao_info').style.display = 'none';
				parent.document.getElementById('tr_negociacao_tabela_frete').style.display = '';
				
				parent.document.getElementById('td_negociacao_tabela_frete').innerHTML = document.getElementById('div_negociacao_tabela_frete').innerHTML;
			</script>
            
            <cfscript>
				fnc_trata_erros(struct_erro = v_retorno, mostra_msg_ok = false);
			</cfscript>
            
            <script type="text/javascript">
				parent.f_habilitar_botao('confirmar', 'f_confirmar()');
            </script>
        </cfcase>
        
        <cfcase value="7">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
			qrVersao       = conn.get_ctrc_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID);
			qrUltimaVersao = conn.get_ctrc_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrUltimaVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
    	<fieldset><legend>Vers&otilde;es</legend>
        <table width="100%" border="0" cellspacing="1" cellpadding="3">
            <tr class="titulo_1">
                <td width="1%" nowrap align="center">&nbsp;</td>
                <td width="1%" nowrap align="center">N&ordm; Vers&atilde;o</td>
                <td width="1%" nowrap align="left">Inserido por</td>
                <td nowrap align="left">Data de Inser&ccedil;&atilde;o</td>
            </tr>
            <cfoutput query="qrVersao">
                <tr class="titulo_4">
                    <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_mostrar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow eq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Tarifas" title="Mostrar Tarifas" width="16" height="16" align="absmiddle" /></button>
                        <button type="button" id="BTN_OCULTAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_ocultar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow neq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Tarifas" title="Ocultar Tarifas" width="16" height="16" align="absmiddle" /></button></td>
                    <td nowrap align="center">#qrVersao.NUM_VERSAO#</td>
                    <td nowrap align="left">#qrVersao.USER_INSERT#</td>
                    <td nowrap align="left">#qrVersao.DATE_INSERT#</td>
                </tr>
                <cfif qrVersao.CurrentRow eq 1>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4">
                        <table border="0" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="top">
                                    <table border="0">
                                        <tr>
                                            <td valign="top">
                                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                    <tr class="titulo_1">
                                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                        <td nowrap align="right">Valor</td>
                                                    </tr>
                                                    <cfloop query="qrVersaoTarifa">
                                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                                        </tr>
                                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                            <tr class="titulo_1">
                                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                                <td nowrap align="right">Valor</td>
                                                            </tr>
                                                        </cfif>
                                                    </cfloop>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td valign="top" style="padding-left: 20px;">
                                    <fieldset><legend>Dados da Tabela de Frete</legend>
                                    <table border="0" cellspacing="1" cellpadding="3">
                                        <tr>
                                            <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Rota:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                                        </tr>
                                        <tr>
                                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                                        </tr>
                                    </table>
                                    </fieldset>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <cfelse>
                <tr id="tr_versao_#qrVersao.VERSAO_ID#" style="display: none;">
                    <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4"></td>
                </tr>
                </cfif>
            </cfoutput>
        </table>
        </fieldset>
    </cfcase>
    
    <cfcase value="8">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
			qrVersao       = conn.get_ctrc_comercial_versao(versao_id = vars.VERSAO_ID);
			qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = vars.VERSAO_ID);
			
			conn = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
			qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrVersao.TABELA_FRETE_ROTA_ID);
		</cfscript>
        <table border="0" cellpadding="0" cellspacing="0">
            <tr>
                <td valign="top">
                    <table border="0">
                        <tr>
                            <td valign="top">
                                <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                    <tr class="titulo_1">
                                        <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                        <td nowrap align="right">Valor</td>
                                    </tr>
                                    <cfoutput query="qrVersaoTarifa">
                                        <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                            <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                            <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                        </tr>
                                        <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                            </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                            <tr class="titulo_1">
                                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                <td nowrap align="right">Valor</td>
                                            </tr>
                                        </cfif>
                                    </cfoutput>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
                <td valign="top" style="padding-left: 20px;">
                    <fieldset><legend>Dados da Tabela de Frete</legend>
                    <table border="0" cellspacing="1" cellpadding="3">
                    	<cfoutput>
                        <tr>
                            <td nowrap align="left" class="texto">Tabela de Frete:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Rota:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                        </tr>
                        <tr>
                            <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                            <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                        </tr>
                        </cfoutput>
                    </table>
                    </fieldset>
                </td>
            </tr>
        </table>
    </cfcase>
    <cfcase value="9">
			<cfscript>
                conn = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
                qrOperacao= conn.get_operacao(argumentCollection = vars, cod_organograma = session.cod_organograma, internacional = 0, somente_ativas = 1);
            </cfscript>
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="texto">
                        <table width="100%" border="0" cellspacing="1" cellpadding="1">
                            <tr class="titulo_2">
                                <td nowrap align="left">C&oacute;d. Opera&ccedil;&atilde;o</td>
                                <td nowrap align="left">Descri&ccedil;&atilde;o</td>                  
                            </tr>
                            <cfoutput query="qrOperacao">
                            	<cfif not qrOperacao.POSSUI_FILHOS>                            
                                    <tr class="linha_#(qrOperacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrOperacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrOperacao.OPERACAO_ID)#', '#JSStringFormat(qrOperacao.DESCRICAO)#')">
                                        <td nowrap align="left">#qrOperacao.OPERACAO_ID#</td>
                                        <td nowrap align="left">#qrOperacao.operacao_completa#</td>
                                    </tr>
                                </cfif>
                            </cfoutput>
                            <cfif qrOperacao.RecordCount eq 0>
                            <tr>
                                <td colspan="3" align="center" valign="middle" class="obrigatorio">Nenhuma opera&ccedil;&atilde;o foi encontrada.</td>
                            </tr>
                            </cfif>
                        </table>
                    </td>
                </tr>
            </table>
        </cfcase>
                
		<cfdefaultcase>
			<script>
				alert('Valor "<cfoutput>#vars.consulta#</cfoutput>" no implementado para a variavel CONSULTA!');
			</script>
		</cfdefaultcase>
	</cfswitch>
<cfelse>
<script>
alert('Variavel CONSULTA no definida!');
</script>
</cfif>
<cfset requestEnd = 0>