<cfparam name="vars.AVULSA" default="0"> 
<cfparam name="vars.CTF" default="0"> 
<html>
<cfif not Len(Trim(session.cod_setor)) >
  <script>
  	alert('Problemas com a lotao do usurio.');
	window.history.go(-1);
  </script>
</cfif>
<cfinclude template="/_scripts/scripts.cfm"/>
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_contrato_transporte");
	qrUsuario = conn.get_alcada_liberacao_controle(operacao = 'CT');
	
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrUnidade = conn.get_unidade();
	qrSerie   = conn.get_serie(cod_pessoa_filial = session.cod_pessoa, 
							   cod_setor = session.cod_setor,
							   cod_departamento = session.cod_departamento, 
							   cod_centro_custo = session.cod_centro_custo,
							   cod_modelo = "X2");	
	qrOrganizacional = conn.get_organizacional();
	qrTipoDocto = conn.get_tipo_docto();
	if (vars.CTF eq 1) 
		qrItensCartaFrete = conn.get_carta_frete_item(ctf_frete=1);
	else 
		qrItensCartaFrete = conn.get_carta_frete_item(contrato_transporte=1);
	conn = CreateComponent("_transportes.consulta.cfc_logistico");
	qrFreteEm = conn.get_cg_ref_codes(dominio = 'LOTE.FRETE_EM');
	conn = CreateComponent("_transportes.consulta.cfc_global");
	v_percentual_combustivel = conn.get_parametro_num(11,'OPERACIONAL',306);
</cfscript>

<script language="javascript1.2"> 

	// Configura botoes // 
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_incluir');

//	parent.f_hidden('barra_botoes_top');
	<cfset vars.funcao_end = 'f_incluir()'>
	
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle Log&iacute;stico</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Emiss&atilde;o de Carta Frete</cf_language>' );

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 

//	f_cria_botao('localizar','Localizar',"f_localizar()", parent.document.getElementById('barra_botoes_top'));

	// -------------------- // 

	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'confirma.cfm';		
			f_habilita_todos_campos( );
			TIPO_CARGA.disabled = false;
			if(TIPO_CARGA.value == 3 && AVULSA.value == 0) {
				if(f_valor_campo('CARGA_ID_COLETA',document.forms[0])+f_valor_campo('CARGA_ID_ENTREGA',document.forms[0]) == '') {
					alert(' necessario indicar as cargas vinculadas a viagem!');
					return;
				}
			}
		
			if (f_verifica_form(document.forms[0])) 			   
			   submit();		
			TIPO_CARGA.disabled = true;
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;

	function f_excluir() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // excluir
			OPERACAO.disabled     = false; 
			GRUPO_ID.disabled = false; 
			try { ATUALIZA_COMBO.disabled = false; } catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';		
			if ( confirm('<cf_language>Para confirmar a excluso do registro clique em OK.</cf_language>') ) {
			   submit();
			}   
		}
	}	
	parent.f_excluir = f_excluir;
	
	function f_localizar() {
		NewWindow('localizar.cfm','Localizar','500','300','yes');
	}
	parent.f_localizar = f_localizar;	

	function f_muda_tipo_carga() {
		return;
		with(document.forms[0]) {
			document.getElementById('tr_carga_normal').style.display = (TIPO_CARGA.value == 1)?'':'none';
			document.getElementById('tr_carga_fracionada').style.display = (TIPO_CARGA.value == 2)?'':'none';
			document.getElementById('td_cargas_vinculadas').style.display = (TIPO_CARGA.value == 3)?'':'none';;
			document.getElementById('td_manifestos').style.display = (TIPO_CARGA.value == 2)?'':'none';;
			switch (Number(TIPO_CARGA.value)) {
				case 2 : 
							if(NUM_ROMANEIO.value != '') {
								NUM_ROMANEIO.value = '';
								NUM_ROMANEIO.onchange();
							}
							NUM_MANIFESTO.obrigatorio = 1;
							NUM_ROMANEIO.obrigatorio = 0;
							break;
				case 1 :
							if(NUM_MANIFESTO.value != '') {
								NUM_MANIFESTO.value = '';
								NUM_MANIFESTO.onchange();
							}
							NUM_ROMANEIO.obrigatorio = 1;
							NUM_MANIFESTO.obrigatorio = 0;
							break;
				case 3 : 
							NUM_ROMANEIO.obrigatorio = 0;
							NUM_MANIFESTO.obrigatorio = 0;
							PESO.value = 0;
							PESO.readOnly = true;
							TOLERANCIA_FALTA.readOnly = true;
							COD_UNIDADE_COMBO.value = 'Kg';
							COD_UNIDADE.value = 'Kg';
							COD_UNIDADE_COMBO.disabled = true;
							M3.value = 0;
							M3.disabled = true;
							VOLUME.value = 0;
							VOLUME.disabled = true;
							FRETE_EM.value = 'LOTACAO';
							FRETE_EM.disabled = true;
							OPERACAO_ID.disabled = true;
							PESO.disabled = true;
							PLACA_CONTROLE.readOnly = false;
							break;
				case 4 : 
							NUM_ROMANEIO.obrigatorio = 0;
							NUM_MANIFESTO.obrigatorio = 0;
							PLACA_CONTROLE.readOnly = false;
							break;	
			   
			}
		}
	}
	
	function f_busca_viagem_carga_dados() {
		with(document.forms[0]) {
			if(VIAGEM_CARGA_ID.value == '' || VIAGEM_CARGA_ID.value == 'undefined') {
				FRETE_EM.value = '';
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_solicitacao_carga_dados'
						,'viagem_carga_id='+VIAGEM_CARGA_ID.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									FRETE_EM.value = obj.struct.frete_em[0];
									if(obj.struct.fracionado == 1) {
										TIPO_CARGA.value = 2;
									} else {
										TIPO_CARGA.value = 1;
									}
									TIPO_CARGA.onchange();
									OPERACAO_LOGISTICA.value = obj.struct.operacao[0];
									OPERACAO_ID.value = obj.struct.operacao_id[0];
								}
							}
						});
		}
	}
	
	v_calculando = false;
	function f_busca_manifesto() {
		return;
		with(document.forms[0]) {
			v_calculando = true;
			MANIFESTO_ID.value = '';
			PESO.value = '';
			VOLUME.value = '';
			M3.value = '';
			COD_UNIDADE.value = '';
			COD_UNIDADE_COMBO.value = '';
			PESO_TON.value = '';
			PLACA_CONTROLE.value = '';
			PLACA_CONTROLE.onchange();
			
			f_calculos();
			if(NUM_MANIFESTO.value == '') {
				v_calculando = false;
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_manifesto_ct'
						,'cod_pessoa_filial=<cfoutput>#session.cod_pessoa#</cfoutput>&num_manifesto='+NUM_MANIFESTO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									if(obj.struct.manifesto_id.length >= 1) {
										if ((obj.struct.veiculo_proprietario[0] != 3) && (obj.struct.veiculo_proprietario[0] != 2)) {
											alert('Somente veiculos de Terceiros podem gerar Carta Frete!');
											NUM_MANIFESTO.select();
											return;
										}
										if(obj.struct.vinculado_ct[0] == 1) {
											alert('Este manifesto j est vinculado a uma Carta Frete!');
											NUM_MANIFESTO.select();
											return;
										}
										if(obj.struct.vinculado_roo[0] == 1) {
											alert('Este manifesto est num romaneio que j est vinculado a uma Carta Frete!');
											NUM_MANIFESTO.select();
											return;
										}
										MANIFESTO_ID.value = obj.struct.manifesto_id[0];
										NUM_MANIFESTO.value = obj.struct.num_manifesto[0];
										PESO.value = obj.struct.peso[0];
										VOLUME.value = obj.struct.volume[0];
										M3.value = obj.struct.m3[0];
										COD_UNIDADE.value = 'Kg';
										COD_UNIDADE_COMBO.value = 'Kg';
										PESO_TON.value = obj.struct.peso_ton[0];
										f_calculos();
										PLACA_CONTROLE.value = obj.struct.placa_tracao[0];
										PLACA_CONTROLE.onchange();
										PLACA_REFERENCIA.value = obj.struct.placa_reboque[0];
										OPERACAO_ID.value = obj.struct.operacao_id[0];
										f_busca_manifestos_romaneio();
//										f_busca_conhecimentos_manifesto();
									} else {
										alert('Nao foi possvel localizar o manifesto!');
										return;
									}
								}
							}
						});
		}
	}
	var v_clr_opt;
	function f_busca_conhecimentos_manifesto() {
		return;
		with(document.forms[0]) {
			f_limpa_select(CONHECIMENTO_ID);
			v_clr_opt = f_cria_option('','Aguarde, buscando os conhecimentos...',CONHECIMENTO_ID);
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_manifesto_conhecimento'
						,'manifesto_id='+MANIFESTO_ID.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									v_clr_opt.text = '-- Gerar Conhecimento --';
									v_clr_opt.setAttribute('data_emissao','<cfoutput>#LSDateFormat(Now())#</cfoutput>');
									if(obj.struct.manifesto_id.length == 1) {
										v_clr_opt = null;
									}
									for (var i=0;i<obj.struct.manifesto_id.length;i++) {
										v_opt = f_cria_option(obj.struct.conhecimento_id[i],obj.struct.num_conhecimento[i],CONHECIMENTO_ID);
										v_opt.setAttribute('data_emissao',obj.struct.data_emissao[i]);
									}
								}
							}
						});
		}
	}
	
	function f_calculos() {
		with(document.forms[0]) {
			ACRESCIMOS.value = toCurrency(ACRESCIMOS.value);
			DESCONTOS.value = toCurrency(DESCONTOS.value);
			switch (FRETE_EM.value)  {
				case 'PESO' : 
					if(!(PESO.value == "" || VALOR_UNITARIO.value == "")){
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(PESO_TON.value) * Number(VALOR_UNITARIO.value));
					}
					break;
				case 'VOLUME' :
					if(!(VOLUME.value == "" || VALOR_UNITARIO.value == "")){
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(VOLUME.value) * Number(VALOR_UNITARIO.value));
					}	  
					break;
				case 'LOTACAO' :
					if(VALOR_UNITARIO.value != ""){
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(VALOR_UNITARIO.value));
					}
					break;
				case 'M3' :
					if(!(M3.value == "" || VALOR_UNITARIO.value == "")){ 
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(M3.value) * Number(VALOR_UNITARIO.value));
					}
					break;
			}
			if(!(VALOR_FRETE_LIQUIDO.value == "" || ACRESCIMOS.value == "")){	
				VALOR_FRETE_BRUTO.value = toCurrency(Number(VALOR_FRETE_LIQUIDO.value) + Number(ACRESCIMOS.value));
			}
			if(!(VALOR_FRETE_BRUTO.value == "" || DESCONTOS.value == "")){
				VALOR_FRETE.value =  toCurrency(Number(VALOR_FRETE_BRUTO.value) - Number(DESCONTOS.value));
			}
			if(VALOR_FRETE.value != ""){
				FRETE_COMBINADO.value =  toCurrency(Number(VALOR_FRETE.value));
			}
			
			TOLERANCIA_FALTA.value = Number(TOLERANCIA_FALTA.value);
			f_calculo_rpa();
			
			if (Number(TOTAL_RECEITA_ROMANEIO.value) > 0) {
				document.getElementById('percentual_receita').innerHTML = toCurrency((Number(VALOR_FRETE_LIQUIDO.value)/Number(TOTAL_RECEITA_ROMANEIO.value))*100) + '%';
			} else {
				document.getElementById('percentual_receita').innerHTML = '0.00';
			}
			<cfif vars.CTF eq 1>
				if ((Number(VALOR_FRETE_LIQUIDO.value)/Number(TOTAL_RECEITA_ROMANEIO.value))*100 > Number(MARGEM_RECEITA.value)) {
					document.getElementById('tr_liberacao').style.display = '';	
				} else {
					USUARIO_LIBERACAO.value = '';
					SENHA_LIBERACAO.value = '';
					document.getElementById('tr_liberacao').style.display = 'none';	
				}
			</cfif>
		}
	}
	
	function f_busca_dado_veiculo(){ 
		with(document.forms[0]) {
			if(PLACA_CONTROLE.value == '' || PLACA_CONTROLE.value == 'undefined') {
				PROPRIETARIO_COD_PESSOA.value  	= '';
				PROPRIETARIO_CNPJ_CPF.value 	= '';
				PROPRIETARIO.value 				= '';
				PROPRIETARIO_ENDERECO.value     = '';
				PROPRIETARIO_MUNICIPIO.value 	= '';
				PROPRIETARIO_UF.value 			= '';
				MOTORISTA_COD_PESSOA.value 		= '';
				MOTORISTA_CPF.value 			= '';
				MOTORISTA.value 				= '';
				MOTORISTA_CNH.value				= '';
				MOTORISTA_CNH_VALIDADE.value	= '';
				PROPRIETARIO_NIT.value 			= '';
				PROPRIETARIO_MUNICIPIO_ID.value = '';
				return;
			}
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_motorista_proprietario"
						,'PLACA_CONTROLE='+PLACA_CONTROLE.value+'&DATA_EMISSAO='+DATA_EMISSAO.value+':00'
						,function (obj){ //callback functions always take one argument. This is the result passed back from the server.
							if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
								if ( (obj.struct.veiculo_proprietario != 3) && (obj.struct.veiculo_proprietario != 2) && (Number(document.forms[0].INTERNACIONAL.value) == 0) ) {
									alert('O veiculo vinculado (' + PLACA_CONTROLE.value + ') no pertence a um terceiro/agregado!');
									NUM_MANIFESTO.value
									PLACA_CONTROLE.value = '';
									PLACA_CONTROLE.onchange();
									PLACA_REFERENCIA.value = '';
									return;
								}
								with(document.forms[0]) {
									PROPRIETARIO_COD_PESSOA.value  	= obj.struct.cod_pessoa_proprietario;
									PROPRIETARIO_CNPJ_CPF.value 	= obj.struct.cnpj_prop;
									PROPRIETARIO.value 				= obj.struct.proprietario;
									PROPRIETARIO_ENDERECO.value     = obj.struct.endereco;
									PROPRIETARIO_MUNICIPIO.value 	= obj.struct.cidade;
									PROPRIETARIO_UF.value 			= obj.struct.uf;
									MOTORISTA_COD_PESSOA.value 		= obj.struct.cod_pessoa_motorista;
									MOTORISTA_CPF.value 			= obj.struct.cpf_motorista;
									MOTORISTA.value 				= obj.struct.nome_motorista;				
									MOTORISTA_CNH.value				= obj.struct.cnh_numero;
									MOTORISTA_CNH_VALIDADE.value	= (obj.struct.cnh_validade != '')?f_format_date(obj.struct.cnh_validade):'';
									PROPRIETARIO_NIT.value 			= obj.struct.pis_pasep_nit;
									PROPRIETARIO_MUNICIPIO_ID.value = obj.struct.proprietario_municipio_id;
									<cfif vars.CTF eq 1>
										if (!obj.struct.tag_ctf.length) {
											alert('Ateno! Para fretes CTF  obrigatrio que o veculo possua TAG vinculada. Verifique os dados do veculo antes de continuar.');
											parent.f_desabilitar_botao('confirmar');
											return false;
										} else {
											parent.f_habilitar_botao('confirmar','f_confirmar()');
										}
									</cfif>
									document.getElementById('tag_ctf').innerHTML = obj.struct.tag_ctf;
									f_busca_composicao();
									f_calculos();
									return true;
								}	
							}	
						});
		}
	}	
	
	function f_calcula_peso_ton() {
		with(document.forms[0]) {
			PESO_TON.value = '';
			if(PESO.value == '' || COD_UNIDADE.value == '') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_logistico.cfc</cf_url>?method=converte_unidade'
						,'valor='+PESO.value+'&unidade_origem='+COD_UNIDADE.value+'&unidade_destino=Ton'
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									PESO_TON.value = obj.struct;
									f_calculos();
								}
							}
						})	
		}
	}
	
	function f_on_incluir() {
		with(document.forms[0]) {
		//	TIPO_CARGA.value = 1;
		//	TIPO_CARGA.onchange();
		<cfif isdefined("vars.num_romaneio")>
			<cfoutput>
				TIPO_CARGA.disabled = true;
				NUM_ROMANEIO.value = '#NumberFOrmat(vars.num_romaneio,'0')#';
				NUM_ROMANEIO.onchange();
				NUM_ROMANEIO.readOnly = true;
				OPERACAO_ID.value = '#vars.operacao_id#';
				VIAGEM_CARGA_ID.value = '#vars.viagem_carga_id#';
				VIAGEM_CARGA_ID.onchange();
				//NUM_FORMULARIO.focus();
				PLACA_REFERENCIA.value = '#vars.placa_referencia#';
				VOLTAR_MENU.value = 1;
			</cfoutput>
		</cfif>
		}
	}
	
	function f_muda_conhecimento_manifesto() {
		return;
		with(document.forms[0]) {
			if(CONHECIMENTO_ID.value == '') {
				NUM_FORMULARIO.value = '';
				NUM_FORMULARIO.readOnly = false;
			} else {
				if(CONHECIMENTO_ID.options[CONHECIMENTO_ID.selectedIndex].getAttribute('conhecimento_id_complementado') == '' && APENAS_COMPLEMENTOS.value == 1) {
				}
				NUM_FORMULARIO.value = CONHECIMENTO_ID.options[CONHECIMENTO_ID.selectedIndex].text;
				NUM_FORMULARIO.readOnly = true;
			}
		}
	}
	
	function f_busca_romaneio() {		
		with(document.forms[0]) {
			APENAS_COMPLEMENTOS.value = 0;
			if (!NUM_ROMANEIO.value) {
				return false;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_romaneio_ct'
						,'num_romaneio='+NUM_ROMANEIO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									if (!obj.struct.operacao[0]) {
										alert('Dados do romaneio no encontrados!');
										return false;	 
									}
									if(obj.struct.vinculado_ct[0] == 1) {
									}
									OPERACAO_ID.value    = obj.struct.operacao_id[0];
									OPERACAO_LOGISTICA.value    = obj.struct.operacao[0];
									VIAGEM_CARGA_ID.value = obj.struct.viagem_carga_id[0];
									PESO.value	      = obj.struct.peso[0];
									M3.value	      = obj.struct.m3[0];
									VOLUME.value      = obj.struct.volume[0];
									COD_UNIDADE_COMBO.value = obj.struct.cod_unidade[0];
									COD_UNIDADE_COMBO.onchange();
									PLACA_CONTROLE.value = obj.struct.placa_controle[0];
									PLACA_CONTROLE.onchange();
									INTERNACIONAL.value = obj.struct.internacional[0];
									MARGEM_RECEITA.value = obj.struct.margem_receita[0];
									if (Number(obj.struct.internacional[0]) == 1) {
									 /*  v_opt = f_cria_option(32,'Adiantamento em dinheiro',ACR_ITEM_ID);
									   v_opt.setAttribute('desconto','1');
									   v_opt.setAttribute('compoe_frete','1');
									   v_opt.setAttribute('deb_cre_motorista','0');
									   v_opt.setAttribute('tipo','Desconto');
									   v_opt.setAttribute('desconto',1);
									  */
									   <cfif vars.CTF eq 0>
									   	   document.getElementById('tr_intc_conhecimento').style.display = '';									  
									   </cfif>
									   f_busca_divisao_crt();
									} else {
									   	   document.getElementById('tr_intc_conhecimento').style.display = 'none';
										   document.getElementById('td_divisao_crt').style.display = 'none';
									}
								}
							}
						});
		}
	}
	
	function f_busca_composicao(p_busca_item) {
		with(document.forms[0]) {
			if(!PLACA_CONTROLE.value) {
				PLACA_REFERENCIA.value 		= '';
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_composicao'
						,'cod_veiculo='+PLACA_CONTROLE.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									PLACA_CONTROLE.value = obj.struct.placa[0];
									PLACA_REFERENCIA.value = (obj.struct.placa.length == 1)?obj.struct.placa[0]:obj.struct.placa[1];
								}
							}
						});			
		}
	}
	
	
	function f_busca_ctrc_romaneio() {
		return;
		with(document.forms[0]) {
			f_limpa_select(CONHECIMENTO_ID_ROMANEIO);
			f_limpa_select(CONHECIMENTO_ID);
			f_cria_option('','Aguarde, buscando conhecimentos...',CONHECIMENTO_ID_ROMANEIO);
			f_cria_option('','Aguarde, buscando conhecimentos...',CONHECIMENTO_ID);
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_ctrc_romaneio'
						,'num_romaneio='+NUM_ROMANEIO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									f_limpa_select(CONHECIMENTO_ID_ROMANEIO);
									f_limpa_select(CONHECIMENTO_ID);
									
									for(var i=0;i<obj.struct.conhecimento_id.length;i++) {
//										alert(obj.struct.conhecimento_id[i]);									
										if((Number(APENAS_COMPLEMENTOS.value) == 0 || obj.struct.conhecimento_id_complementado[i] != '') && (obj.struct.ct_vinculado[i] == 0)) {
											v_opt = f_cria_option(obj.struct.conhecimento_id[i],obj.struct.num_conhecimento[i],CONHECIMENTO_ID_ROMANEIO);
											v_opt.setAttribute('data_emissao',obj.struct.data_emissao[i]);
											v_opt.setAttribute('conhecimento_id_complementado',obj.struct.conhecimento_id_complementado[i]);
											<cfif isdefined("vars.conhecimento_id")>
											if(String(obj.struct.conhecimento_id[i]) == '<cfoutput>#vars.conhecimento_id#</cfoutput>') {
												v_opt.selected = true;
											}
											</cfif>

											v_opt2 = f_cria_option(obj.struct.conhecimento_id[i],obj.struct.num_conhecimento[i],CONHECIMENTO_ID);
											v_opt2.setAttribute('data_emissao',obj.struct.data_emissao[i]);
											v_opt2.setAttribute('conhecimento_id_complementado',obj.struct.conhecimento_id_complementado[i]);
										}
									}

									if(APENAS_COMPLEMENTOS.value != 1 && false ) {
										v_opt = f_cria_option('','-- Gerar Conhecimento --',CONHECIMENTO_ID_ROMANEIO);
										v_opt.setAttribute('data_emissao','<cfoutput>#LSDateFormat(Now())#</cfoutput>');
										v_opt = f_cria_option('','-- Gerar Conhecimento --',CONHECIMENTO_ID);
										v_opt.setAttribute('data_emissao','<cfoutput>#LSDateFormat(Now())#</cfoutput>');
									}

									CONHECIMENTO_ID_ROMANEIO.onchange();
								}
							}
						});
		}
	}
	
	function f_calculo_abast() {
		with(document.forms[0]) {
			POSTO_QUANTIDADE.value = toCurrency(Number(POSTO_QUANTIDADE.value));
			POSTO_VALOR_UNITARIO.value = toCurrency(Number(POSTO_VALOR_UNITARIO.value));
			POSTO_VALOR_TOTAL.value = toCurrency(Number(POSTO_QUANTIDADE.value)*Number(POSTO_VALOR_UNITARIO.value));
			ACR_VALOR.value = POSTO_VALOR_TOTAL.value;
		}
	}
	
	function f_muda_produto() {
		with(document.forms[0]) {
			if(ACR_ITEM_ID.value == -2) {
				document.getElementById('tb_posto').style.display = '';
				document.getElementById('sp_valor_item').style.display = 'none';
				POSTO_COD_PESSOA.obrigatorio = 1;
				POSTO_VALOR_UNITARIO.obrigatorio = 1;
				POSTO_QUANTIDADE.obrigatorio = 1;
			} else {
				document.getElementById('tb_posto').style.display = 'none';
				document.getElementById('sp_valor_item').style.display = '';
				POSTO_COD_PESSOA.obrigatorio = 0;
				POSTO_VALOR_UNITARIO.obrigatorio = 0;
				POSTO_QUANTIDADE.obrigatorio = 0;
			}
		}
	}
	

	function f_limpa_POSTO() {
	with(document.forms[0]) {
		POSTO_COD_PESSOA.value = '';
		POSTO.value = '';
		POSTO_CNPJ_CPF.value = '';
		POSTO_VALOR_UNITARIO.value = '';
	}
	}
	
	function f_busca_pessoa_POSTO() {
	with(document.forms[0]) {
		v_cnpj = POSTO_CNPJ_CPF.value;
		f_limpa_POSTO();
		POSTO_CNPJ_CPF.value = v_cnpj;
		if (true || POSTO_CNPJ_CPF.value.length > 4) {
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'rapida=1&posto=1&num_modalidade=12&cnpj_cpf='+POSTO_CNPJ_CPF.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									POSTO_CNPJ_CPF.value = obj.struct.cnpj_cpf[0];
									POSTO_COD_PESSOA.value = obj.struct.cod_pessoa[0];
									POSTO.value = (obj.struct.razao_social[0] == '')?obj.struct.cliente[0]:obj.struct.razao_social[0];
									if(Number(obj.struct.preco_diesel[0]) == 0) {
	//										POSTO_VALOR_UNITARIO.value = '';
									} else {	
										POSTO_VALOR_UNITARIO.value = toCurrency(obj.struct.preco_diesel[0]);
									}
								}
								else {
									v_cnpj = POSTO_CNPJ_CPF.value;
									f_limpa_POSTO();
									POSTO_CNPJ_CPF.value = v_cnpj;
									alert('Nenhum posto encontrado!')
								}
							}
						});
			}
	}
	}

	function f_calculo_rpa() {
		with(document.forms[0]) {
			if(DATA_EMISSAO.value == '') {
				return;
			}
			if(VALOR_FRETE_LIQUIDO.value == '') {
				return;
			}
			if(PROPRIETARIO_COD_PESSOA.value == '') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=calculo_rpa'
						, 'cod_pessoa=' + PROPRIETARIO_COD_PESSOA.value
						+ '&data=' + DATA_EMISSAO.value
						+ '&valor_servico=' + VALOR_FRETE.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								VALOR_INSS.value = toCurrency(Number(obj.struct.valor_inss));
								VALOR_SEST.value = toCurrency(Number(obj.struct.valor_sest));
								VALOR_SENAT.value = toCurrency(Number(obj.struct.valor_senat));
								VALOR_IRRF.value = toCurrency(Number(obj.struct.valor_irrf));
								BASE_CALC_INSS.value = toCurrency(Number(obj.struct.base_calc_inss));
								BASE_CALC_SEST_SENAT.value = toCurrency(Number(obj.struct.base_calc_sest_senat));
								BASE_CALC_IRRF.value = toCurrency(Number(obj.struct.base_calc_irrf));
							}
						});
		}
	}

	function f_seleciona_centro_custo() {
		with(document.forms[0]) {
			for(var i = 0; i < ORGANIZACIONAL_ID_GERENCIAL.options.length; i++) {
				if(ORGANIZACIONAL_ID_GERENCIAL.options[i].codigo == COD_ORGANIZACIONAL.value) {
					ORGANIZACIONAL_ID_GERENCIAL.value = ORGANIZACIONAL_ID_GERENCIAL.options[i].value;
				}
			}
		}
	}
	
	function f_busca_receita() {
		with(document.forms[0]) {
			if (!NUM_ROMANEIO.value) return false;
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_receita_romaneio'
						 ,'num_romaneio='+NUM_ROMANEIO.value
						 ,function(obj) {
							 if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								TOTAL_RECEITA_ROMANEIO.value =  toCurrency(obj.struct.valor_receita[0]);
							 }
						 });
		}
	}
	
	function f_busca_divisao_crt() {
		with(document.forms[0]) {
			f_query_ajax('/ouroverde/aplicacoes/controle_documentos/contrato_transporte/emitir/forms/divisao_crt.cfm?num_romaneio='+NUM_ROMANEIO.value + '&INTC_CONHECIMENTO_ID='+INTC_CONHECIMENTO_ID.value
						,f_divisao_result);
		}
	}
	
	function f_divisao_result(obj) {
		with(document.forms[0]) {
			document.getElementById('td_divisao_crt').innerHTML = obj;
		}
	}

	function f_busca_crt() {
		with(document.forms[0]) {
			if (!NUM_CRT.value) return false;
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_conhecimento'
						 ,'numero='+NUM_CRT.value
						 ,function(obj) {
							 if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if (obj.struct.conhecimento_id.length > 0) {
									INTC_CONHECIMENTO_ID.value =  obj.struct.conhecimento_id[0];
									NUM_ROMANEIO.obrigatorio = 0;
									NUM_MANIFESTO.obrigatorio = 0;
									PLACA_CONTROLE.readOnly = false;
									f_busca_divisao_crt();
								}
								else {
									NUM_ROMANEIO.obrigatorio = 0;
									NUM_MANIFESTO.obrigatorio = 0;
									PESO.value = 0;
									PESO.readOnly = true;
									TOLERANCIA_FALTA.readOnly = true;
									COD_UNIDADE_COMBO.value = 'Kg';
									COD_UNIDADE.value = 'Kg';
									COD_UNIDADE_COMBO.disabled = true;
									M3.value = 0;
									M3.disabled = true;
									VOLUME.value = 0;
									VOLUME.disabled = true;
									FRETE_EM.value = 'LOTACAO';
									FRETE_EM.disabled = true;
									OPERACAO_ID.disabled = true;
									PESO.disabled = true;
									PLACA_CONTROLE.readOnly = false;
									alert('CRT no encontrado. Favor verificar.');
								}
							 }
						 });
		}
	}
	
	var v_cod_pessoa = 0;
	function f_ajusta_valor(obj, p_cod_pessoa, p_placa_controle) {
		with(document.forms[0]) {
			v_cod_pessoa = p_cod_pessoa;
			f_soma_divisao();
			PLACA_CONTROLE.value = p_placa_controle;
			f_busca_dado_veiculo();
		}
	}
	
	function f_soma_divisao() {
		with(document.forms[0]) {
			TOTAL_RECEITA_ROMANEIO.value = 0;
			v_marcado = 0;
			
			// Verifica se pelo menos um est marcado
			for (var i=0; i<document.forms[0].elements.length; i++) {
				if (document.forms[0].elements[i].tipo == 'divisao' && document.forms[0].elements[i].checked) {
					v_marcado = 1;
				}
			}
			
			for (var i=0; i<document.forms[0].elements.length; i++) {
				if (document.forms[0].elements[i].tipo == 'divisao' && document.forms[0].elements[i].checked) {
					TOTAL_RECEITA_ROMANEIO.value = (Number(TOTAL_RECEITA_ROMANEIO.value) + Number(document.forms[0].elements[i].valor)).toFixed(2);
				}
				if (document.forms[0].elements[i].tipo == 'divisao') {
				  if (Number(document.forms[0].elements[i].cod_motorista) == Number(v_cod_pessoa) || v_marcado == 0)
	  				 document.forms[0].elements[i].disabled = false;
				  else 
					 document.forms[0].elements[i].disabled = true;
				}
			}
		}
	}
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<title>..: KM&amp;M Transporte e Log&iacute;stica :..</title>

<link href="<cf_url>/_estilos/abas.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height:100%; overflow:auto">
<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0">
   <form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
      <input name="OPERACAO" type="hidden" value="" sempre_ativo="1">
      <input name="CONSULTA" type="hidden" value="" sempre_ativo="1">
      <input name="MANIFESTO_ID" type="hidden" value="" sempre_ativo="1">
      <input name="VOLTAR_MENU" type="hidden" value="0" sempre_ativo="1">
      <input name="INTERNACIONAL" type="hidden" value="0" fixo="1" sempre_ativo="1">
      <input name="APENAS_COMPLEMENTOS" type="hidden" value="0" sempre_ativo="1">
      <input name="MARGEM_RECEITA" type="hidden" value="" sempre_ativo="1">
      <input name="CTF" type="hidden" value="<cfoutput>#vars.CTF#</cfoutput>" sempre_ativo="1" fixo="1">
      <input name="AVULSA" id="AVULSA" type="hidden" value="<cfif IsDefined("vars.AVULSA")><cfoutput>#vars.AVULSA#</cfoutput><cfelse>0</cfif>" sempre_ativo="1" fixo="1">
      <tr>
         <td><table width="100%" height="100%" border="0" cellpadding="0" cellspacing="0" id="tbl_ct">
           <tr>
             <td height="1" width="2"><nobr>Dados da Carta Frete </nobr> </td>
             <td width="1"><nobr>Servi&ccedil;o Contratado </nobr> </td>
             <td width="1" style="<cfif vars.AVULSA neq 1>display:none</cfif>"><nobr>Remetente/Destinatrio</nobr></td>             
             <td width="1" id="td_manifestos" style="display:none"><nobr>Outros Manifestos </nobr></td>
             <td width="1500">&nbsp;</td>
           </tr>
           <tr>
             <td colspan="4" valign="top"><table width="100%" border="0" cellspacing="1" cellpadding="3">
               <tr>
                 <td colspan="4" class="texto"><fieldset>
                   <legend>Gerencial</legend>
                   <table width="100%" border="0" cellpadding="3" cellspacing="1">
                     <tr>
                       <td width="8%" nowrap class="texto">Centro Custo:</td>
                       <td width="92%" colspan="3" nowrap class="texto"><input name="COD_ORGANIZACIONAL" type="text" id="COD_ORGANIZACIONAL" onKeyPress="return f_formata(this,event,'AAAAAAAAA')" onKeyUp="f_seleciona_centro_custo()" size="10" maxlength="10">
                         <select name="ORGANIZACIONAL_ID_GERENCIAL" id="ORGANIZACIONAL_ID_GERENCIAL" obrigatorio="1" display="CENTRO DE CUSTO" onChange="document.forms[0].COD_ORGANIZACIONAL.value=document.forms[0].ORGANIZACIONAL_ID_GERENCIAL.options[document.forms[0].ORGANIZACIONAL_ID_GERENCIAL.selectedIndex].codigo">
                           <option value="" codigo="">-- Selecione --</option>
                           <cfoutput query="qrOrganizacional">
                             <cfif qrOrganizacional.FOLHA eq 1>
                               <option value="#qrOrganizacional.ORGANIZACIONAL_ID#" codigo="#qrOrganizacional.COD_ORGANIZACIONAL#">#qrOrganizacional.DESCRICAO_COMPLETA#</option>
                             </cfif>
                           </cfoutput>
                         </select></td>
                     </tr>
                   </table>
                 </fieldset></td>
               </tr>
               <tr>
                 <td class="texto">Tipo de Carga:</td>
                 <td class="texto" colspan="3"><select name="TIPO_CARGA" id="TIPO_CARGA" onChange="f_muda_tipo_carga()" fixo="1">
                   <cfif not IsDefined("vars.AVULSA")>
                   <option value="1" selected>Carga Normal</option>
                   </cfif>
                   <!---<option value="3">Carga Coleta/Entrega</option>--->
                   <cfif IsDefined("vars.AVULSA")>
                   <option value="4" selected><cfif vars.CTF eq 1>CTF<cfelse>Avulsa</cfif></option>
                   </cfif>
                 </select><cfif vars.CTF eq 1>
                  &nbsp;<span class="obrigatorio">Aten&ccedil;&atilde;o! Frete ser&aacute; pago pelo sistema CTF Frete.</span></cfif></td>
               </tr>
               <cfif vars.AVULSA eq 0>
                   <tr id="tr_carga_normal" >
                     <td class="texto">N&ordm; Romaneio:</td>
                     <td class="texto"><input name="NUM_ROMANEIO" type="text" id="NUM_ROMANEIO" onChange="f_busca_romaneio();f_busca_receita()" onKeyPress="return f_formata(this,event,'000000000000')" obrigatorio="1" display="NUMERO DO ROMANEIO"></td>
                     <td class="texto" style="display:none ">Conhecimento:</td>
                     <td class="texto" style="display:none "><select name="CONHECIMENTO_ID_ROMANEIO" id="CONHECIMENTO_ID_ROMANEIO" onChange="this.form.CONHECIMENTO_ID.value = this.value; <!---this.form.DATA_EMISSAO.value = this.options[this.selectedIndex].data_emissao; --->f_muda_conhecimento_manifesto()" obrigatorio="0" display="CONHECIMENTO" ativo="1"> 
                        <option value="" data_emissao="#LSDateFormat(Now())#">-- Selecione o Romaneio --</option> 
                     </select></td>
                   </tr>
                   <tr style="display:none" id="tr_intc_conhecimento">
                     <td class="texto">N&ordm; CRT:</td>
                     <td class="texto"><input name="NUM_CRT" type="text" id="NUM_CRT" onKeyPress="return f_formata(this,event,'AA.000.000000')" size="15" maxlength="15" onChange="f_busca_crt()">
                      <input type="hidden" name="INTC_CONHECIMENTO_ID" id="INTC_CONHECIMENTO_ID"></td>
                     <td class="texto">&nbsp;</td>
                     <td class="texto">&nbsp;</td>
                   </tr>
               </cfif>
               <tr id="tr_carga_fracionada" style="display:none ">
                 <td class="texto">N&ordm; Manifesto:</td>
                 <td class="texto"><input name="NUM_MANIFESTO" type="text" id="NUM_MANIFESTO" onKeyPress="return f_formata(this,event,'000000000000')" onChange="f_busca_manifesto()" display="NUMERO DO MANIFESTO"></td>
                 <td class="texto">Conhecimento:</td>
                 <td class="texto"><select name="CONHECIMENTO_ID" id="CONHECIMENTO_ID" onChange="<!---this.form.DATA_EMISSAO.value = this.options[this.selectedIndex].data_emissao;--->f_muda_conhecimento_manifesto()" obrigatorio="0" display="CONHECIMENTO" ativo="1"> 
					<option value="" data_emissao="#LSDateFormat(Now())#">-- Selecione o Manifesto --</option>
                 </select></td>
               </tr>
               <cfif vars.CTF eq 0>
               <tr>
                 <td width="10%" class="texto"><nobr>N&ordm; Formul&aacute;rio:</nobr></td>
                 <td width="14%" class="texto"><input name="NUM_FORMULARIO" type="text" id="NUM_FORMULARIO" onKeyPress="return f_formata(this,event,'00000000000000')" obrigatorio="1" display="NUMERO DO FORMULARIO">
                   <select name="SERIE_FORMULARIO" id="SERIE_FORMULARIO" fixo="1">
                     <cfoutput query="qrSerie">
                     	<option value="#qrSerie.SERIE#" selected>#qrSerie.SERIE#</option>
                     </cfoutput>
                  </select></td>
                 <td width="4%" class="texto">&nbsp;</td>
                 <td class="texto">&nbsp;</td>
                </tr>
               <cfelse>
               	  <input name="NUM_FORMULARIO" type="hidden" value="" sempre_ativo="1" fixo="1">
               	  <input name="SERIE_FORMULARIO" type="hidden" value="CTF" sempre_ativo="1" fixo="1">
               </cfif> 
               <tr>
                 <td colspan="4" class="texto" id="td_divisao_crt">&nbsp;</td>
                </tr>
               <tr>
                 <td width="10%" class="texto">Emiss&atilde;o:</td>
                 <td width="14%" class="texto"><nobr>
                   <input name="DATA_EMISSAO" type="text" id="DATA_EMISSAO" style="width: 110px" onKeyPress="return f_formata(this,event,'00/00/0000')" value="<cfoutput>#LSDateFormat(now())# #LSTimeFormat(now())#</cfoutput>" readonly="readonly" fixo="1">
                   <button type="button" id="btn_data_emissao" class="botao-16x16" style="display: none"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button>
                   </nobr></td>
				   <script>
				     Calendar.setup(
									{
									  inputField  : "DATA_EMISSAO",      // ID of the input field
									  ifFormat    :    "%d/%m/%Y",    // the date format
									  button      : "btn_data_emissao",    // ID of the button
									  range       : [2001,2050]
									}
								  );
				   </script>
                 <td width="4%" class="texto">Operacao: </td>
                 <td width="99%" class="texto"><input name="OPERACAO_LOGISTICA" type="text" id="OPERACAO_LOGISTICA" onKeyPress="return f_formata(this,event,'000000000000')" readonly="true">
				 <input type="hidden" name="OPERACAO_ID" id="OPERACAO_ID">
				 <input type="hidden" name="VIAGEM_CARGA_ID" id="VIAGEM_CARGA_ID" onChange="f_busca_viagem_carga_dados()" ></td>
               </tr>
               
               <tr>
                 <td class="texto">Peso:</td>
                 <td class="texto"><nobr><input name="PESO" type="text" id="PESO" onChange="f_calcula_peso_ton()" style="width: 70px" onKeyPress="return f_formata_numero_decimal(this,event)" >
                   <select name="COD_UNIDADE_COMBO" id="COD_UNIDADE_COMBO" onChange="this.value = this.form.COD_UNIDADE.value = this.value; f_calcula_peso_ton();" >
				   		<option value="">-- Selecione --</option>
						<cfoutput query="qrunidade">
						<option value="#qrUnidade.cod_unidade#">#qrUnidade.unidade#</option>
						</cfoutput>
                   </select>
				 <input type="hidden" name="PESO_TON">
                 <input type="hidden" name="COD_UNIDADE">
                 </nobr>                  </td>
                 <td class="texto">M<sup>3</sup>:<nobr></nobr> </td>
                 <td class="texto"><input name="M3" type="text" id="M3" onChange="f_calculos()" onKeyPress="return f_formata_numero_decimal(this,event)" value="0" obrigatorio="1" display="M3" fixo="1"></td>
                </tr>
               <tr>
                 <td class="texto">Volume:</td>
                 <td class="texto"><input name="VOLUME" type="text" id="VOLUME" obrigatorio="1" display="VOLUME" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calculos()"></td>
                 <td class="texto">Frete em: </td>
                 <td class="texto"><select name="FRETE_EM" id="FRETE_EM" onChange="f_calculos()" obrigatorio="1" display="FRETE EM">
                     <option value="">-- Selecione --</option>
                     <cfoutput query="qrFreteEm">
                       <option value="#qrFreteEm.id#">#qrFreteEm.id#</option>
                     </cfoutput>
                  </select></td>
               </tr>
               <tr>
                 <td class="texto">Valor Unit&aacute;rio: </td>
                 <td class="texto"><input name="VALOR_UNITARIO" type="text" id="VALOR_UNITARIO" style="width: 80px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calculos()" obrigatorio="1" display="VALOR UNITARIO"></td>
                 <td class="texto"><nobr>Valor do Servi&ccedil;o: </nobr> </td>
                 <td class="texto"><input name="VALOR_FRETE_LIQUIDO" readonly="true" type="text" id="VALOR_FRETE_LIQUIDO" onKeyPress="return f_formata_numero_decimal(this,event)" ></td>
               </tr>
               <tr>
                 <td class="texto">Acr&eacute;scimos:</td>
                 <td class="texto"><input name="ACRESCIMOS" type="text" id="ACRESCIMOS" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)">
                  <button id="btn_" type="button" class="botao-16x16" onClick="f_verifica_adiantamento()"></button></td>
                 <td class="texto">Descontos:</td>
                 <td class="texto"><input name="DESCONTOS" type="text" id="DESCONTOS" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
               </tr>
               <tr>
                 <td class="texto"><nobr>Total do Servi&ccedil;o: </nobr> </td>
                 <td class="texto"><input name="VALOR_FRETE_BRUTO" type="text" id="VALOR_FRETE_BRUTO" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
                 <td class="texto"><nobr>L&iacute;quido do Servi&ccedil;o: </nobr> </td>
                 <td class="texto"><input name="VALOR_FRETE" type="text" id="VALOR_FRETE" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
               </tr>
               <tr>
                 <td class="texto"><nobr>L&iacute;quido a Pagar: </nobr> </td>
                 <td class="texto"><input name="FRETE_COMBINADO" type="text" id="FRETE_COMBINADO" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
                 <td class="texto">Toler&acirc;ncia de Faltas: </td>
                 <td class="texto"><input name="TOLERANCIA_FALTA" type="text" id="TOLERANCIA_FALTA" onKeyPress="return f_formata_numero_decimal(this,event)" obrigatorio="1" display="TOLERANCIA DE FALTAS">
                   %
                     <button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="" width="16" height="16" align="absmiddle"></button>                   </td>
               </tr>
               <tr >
                 <td class="texto">Total da Receita:</td>
                 <td colspan="3" class="texto"><input name="TOTAL_RECEITA_ROMANEIO" type="text" disabled id="TOTAL_RECEITA_ROMANEIO" size="18" maxlength="18" readonly="readonly">
                  &nbsp;Percentual servi&ccedil;o:&nbsp;<span class="obrigatorio" id="percentual_receita">&nbsp;</span></td>
               </tr>
               <tr id="tr_liberacao">
                 <td nowrap class="texto">Usu&aacute;rio Libera&ccedil;&atilde;o:</td>
                 <td nowrap class="texto"><select name="USUARIO_LIBERACAO" id="USUARIO_LIBERACAO">
                 <cfoutput query="qrUsuario">
                 	<option value="#qrUsuario.USUARIO#">#qrUsuario.NOME#</option>
                 </cfoutput>
                 </select></td>
                 <td nowrap class="texto">Senha autoriza&ccedil;&atilde;o:</td>
                 <td nowrap class="texto"><input name="SENHA_LIBERACAO" type="text" id="SENHA_LIBERACAO" size="30" maxlength="30"></td>
               </tr>
               <tr style="display:none">
                 <td class="texto">Adiantamento:</td>
                 <td colspan="3" class="texto"><input type="text" name="VALOR_ADIANTAMENTO" id="VALOR_ADIANTAMENTO" style="width:60px" readonly>
                   <input type="checkbox" name="PARCELADO" id="PARCELADO" class="check" disabled ativo="0" onClick="this.form.TOTAL_PARCELA.disabled = !this.checked" />
                   Parcelamento
                   <select name="TOTAL_PARCELA" id="TOTAL_PARCELA" disabled ativo="0" >
                     <option value="2">2x</option>
                     <option value="3">3x</option>
                     <option value="4">4x</option>
                     <option value="5">5x</option>
                   </select>                  </td>
               </tr>
               <tr>
                 <td nowrap class="texto">Valor INSS:</td>
                 <td nowrap class="texto"><input type="text" name="VALOR_INSS" id="VALOR_INSS" readonly="yes" /></td>
                 <td nowrap class="texto">Base Calc. INSS:</td>
                 <td nowrap class="texto"><input type="text" name="BASE_CALC_INSS" id="BASE_CALC_INSS" readonly="yes" /></td>
               </tr>
               <tr>
                 <td nowrap class="texto">Valor SEST:</td>
                 <td nowrap class="texto"><input type="text" name="VALOR_SEST" id="VALOR_SEST" readonly="yes" /></td>
                 <td nowrap class="texto">Base Calc. SEST/SENAT:</td>
                 <td nowrap class="texto"><input type="text" name="BASE_CALC_SEST_SENAT" id="BASE_CALC_SEST_SENAT" readonly="yes" /></td>
               </tr>
               <tr>
                 <td nowrap class="texto">Valor SENAT:</td>
                 <td colspan="3" nowrap class="texto"><input type="text" name="VALOR_SENAT" id="VALOR_SENAT" readonly="yes" /></td>
               </tr>
               <tr>
                 <td nowrap class="texto">Valor IRRF:</td>
                 <td nowrap class="texto"><input type="text" name="VALOR_IRRF" id="VALOR_IRRF" readonly="yes" /></td>
                 <td nowrap class="texto">Base Calc. IRRF:</td>
                 <td nowrap class="texto"><input type="text" name="BASE_CALC_IRRF" id="BASE_CALC_IRRF" readonly="yes" /></td>
               </tr>
             </table>
			 <input type="hidden" name="ACR_COMPOE_FRETE">
			 <input type="hidden" name="ACR_DEB_CRED_MOTORISTA">
			 <input type="hidden" name="ACR_ACRESCIMO">
			 <input type="hidden" name="ACR_DESCONTO">
			 <input type="hidden" name="ACR_ACRESCIMO_REAL">
			 <input type="hidden" name="ACR_DESCONTO_REAL">
			 <input type="hidden" name="ACR_DESCRICAO">
			 <input type="hidden" name="ACR_DESCONTO_COD">
               <fieldset>
               <legend>Acrscimos/Descontos</legend>
               <table width="100%" border="0" cellspacing="1" cellpadding="3">
                 <tr>
                   <td width="8%" class="texto">Descri&ccedil;&atilde;o:</td>
                   <td colspan="3" class="texto"><select name="ACR_ITEM_ID" id="ACR_ITEM_ID" obrigatorio="1" display="DESCRICAO" secao="ACRESCIMOS"
				   									onchange="this.form.ACR_VALOR.value = 0.00;
                                                              if(this.value != '') {
																  with(this.form) {
																	ACR_TIPO.value = this.options[this.selectedIndex].tipo;
																	ACR_COMPOE_FRETE.value = this.options[this.selectedIndex].compoe_frete;
																	ACR_DEB_CRED_MOTORISTA.value = this.options[this.selectedIndex].deb_cred_motorista;
																	ACR_DESCONTO_COD.value = this.options[this.selectedIndex].desconto;
																  }
															  } else {
																	ACR_TIPO.value = '';
																	ACR_COMPOE_FRETE.value = '';
																	ACR_DEB_CRED_MOTORISTA.value = '';
																	ACR_DESCONTO_COD.value = '';
															  }
															  ">
						<option value="">-- Selecione --</option>
						<cfoutput query="qrItensCartaFrete">
						   <option 	value="#qrItensCartaFrete.ITEM_ID#" 
						   			tipo="#qrItensCartaFrete.TIPO#" 
									desconto="#qrItensCartaFrete.DESCONTO#" 
									compoe_frete="#qrItensCartaFrete.COMPOE_FRETE#" 
									deb_cred_motorista="#qrItensCartaFrete.DEB_CRED_MOTORISTA#">#qrItensCartaFrete.DESCRICAO#</option>
						</cfoutput>				   
                   </select>
                     <input name="ACR_TIPO" type="text" id="ACR_TIPO" readonly="true">
                     <span id="sp_valor_item">Valor:
                     <input name="ACR_VALOR" type="text" id="ACR_VALOR" onKeyPress="return f_formata_numero_decimal(this,event)" obrigatorio="1" display="VALOR" secao="ACRESCIMOS"></span></td>
                 </tr>
				 <tbody id="tb_posto" style="display:none">
                 <tr>
                   <td class="texto">Posto:
                    <input name="POSTO_COD_PESSOA" type="hidden" id="POSTO_COD_PESSOA" obrigatorio="0" display="POSTO" secao="ACRESCIMOS"></td>
                   <td colspan="3" class="texto"><input name="POSTO_CNPJ_CPF" type="text" id="POSTO_CNPJ_CPF" style="width: 110px" onChange="f_busca_pessoa_POSTO()">
                   <input name="POSTO" type="text" id="POSTO" style="width: 350px" readonly="true">
                   <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?modalidade_id=12&campo=POSTO_CNPJ_CPF&funcao=f_busca_pessoa_POSTO()','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button>                   </td>
                 </tr>
                 <tr>
                   <td class="texto">Litros:</td>
                   <td colspan="3" class="texto"><input name="POSTO_QUANTIDADE" type="text" id="POSTO_QUANTIDADE" style="width: 70px" obrigatorio="0" display="QUANTIDADE" secao="ACRESCIMOS" onChange="f_calculo_abast()" onKeyPress="return f_formata_numero_decimal(this,event)"> 
                     Valor Unit&aacute;rio: 
                     <input name="POSTO_VALOR_UNITARIO" type="text" id="POSTO_VALOR_UNITARIO" style="width: 70px" obrigatorio="0" display="VALOR UNITARIO" secao="ACRESCIMOS" onChange="f_calculo_abast()" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
                 </tr>
                 <tr>
                   <td class="texto"><nobr>Valor Total: </nobr></td>
                   <td colspan="3" class="texto"><input name="POSTO_VALOR_TOTAL" type="text" readonly="true" id="POSTO_VALOR_TOTAL" style="width: 70px"></td>
                 </tr>
                 </tbody>
                 <tr>
                   <td colspan="4" class="texto">
				   <cfset lista_id 					= 'ACRESCIMOS'>
					<cfset lista_campos 			= 'ACR_ITEM_ID,ACR_COMPOE_FRETE,ACR_DEB_CRED_MOTORISTA,ACR_ACRESCIMO,ACR_DESCONTO,ACR_TIPO,ACR_ACRESCIMO_REAL,ACR_DESCONTO_REAL,ACR_VALOR,ACR_DESCRICAO,POSTO_COD_PESSOA,POSTO_CNPJ_CPF,POSTO,POSTO_QUANTIDADE,POSTO_VALOR_UNITARIO,POSTO_VALOR_TOTAL,ACR_DESCONTO_COD'>
					<cfset lista_titulos 			= 'Descri&ccedil;&atilde;o,Acr&eacute;scimo,Desconto'>
					<cfset lista_titulos_campos 	= "'+ACR_ITEM_ID.options[ACR_ITEM_ID.selectedIndex].text+',ACR_ACRESCIMO,ACR_DESCONTO">
					<cfset lista_titulos_tamanho 	= '200,50,50'>
					<cfset lista_campo_id 			= 'ACR_ITEM_ID'>
					<cfset lista_default 			= 0>
					<cfset lista_campos_unique		= 'ACR_ITEM_ID'>
					<cfset lista_width	 			= '700'>
					<cfset lista_heigth	 			= '150'>
					<cfinclude template	="/_include/lista.cfm">
					<script>
					//  necessrio setar este flag para buscar os dados do banco de dados
					// Motivo: No  possvel inserir diretamente os dados de impostos
					v_insercao_interna = false;
					function f_before_salvar_ACRESCIMOS() {
						with(document.forms[0]) {
							if(!v_insercao_interna && Number(ACR_VALOR.value) < 0) {
								alert('O valor do item deve ser maior que zero!');
								return false;
							}
							//Incluir Teste para impedir a insero de dados de SEST/SENAT, INSS e IRRF
							if (!v_insercao_interna && 
								(ACR_ITEM_ID.value == 20 /* IRRF */ || 
								 ACR_ITEM_ID.value == 21 /* INSS */ || 
								 ACR_ITEM_ID.value == 23 /* SEST */ ||
								 ACR_ITEM_ID.value == 24 /* SENAT */)) {
								alert('Os valores de IRRF, INSS, SEST e SENAT so calculados automaticamente pelo sistema ao confirmar a Carta Frete!');
								return false;
							}
							ACR_VALOR.value = toCurrency(ACR_VALOR.value);
							ACR_DESCRICAO.value = ACR_ITEM_ID.options[ACR_ITEM_ID.selectedIndex].text;
							if(ACR_DEB_CRED_MOTORISTA.value == 1) {
								ACR_ACRESCIMO.value = '0.00';
								ACR_DESCONTO.value = toCurrency(ACR_VALOR.value);
								ACR_ACRESCIMO_REAL.value = '0.00';
								ACR_DESCONTO_REAL.value = (ACR_COMPOE_FRETE.value == 1)?toCurrency(ACR_VALOR.value):'0.00';
							} else {
								ACR_ACRESCIMO.value = toCurrency(ACR_VALOR.value);
								ACR_DESCONTO.value = '0.00';
								ACR_ACRESCIMO_REAL.value = (ACR_COMPOE_FRETE.value == 1)?toCurrency(ACR_VALOR.value):'0.00';
								ACR_DESCONTO_REAL.value = '0.00';
							}
							return true;
						}
					}
					function f_on_salva_lista_ACRESCIMOS() {
						with(document.forms[0]) {
							v_lista = f_listagem_ACRESCIMOS();
							ACRESCIMOS.value = toCurrency(f_total_campo_ACRESCIMOS('ACR_ACRESCIMO_REAL'));
							DESCONTOS.value = toCurrency(f_total_campo_ACRESCIMOS('ACR_DESCONTO_REAL'));
							f_calculos();
							f_muda_produto();
							v_soma = 0;							
							for(var i=0;i<v_lista.length;i++) {
								if(v_lista[i].ACR_ITEM_ID == 7) {
									v_soma += Number(v_lista[i].ACR_DESCONTO_REAL);
								}
							}							
							VALOR_ADIANTAMENTO.value = toCurrency(v_soma);
							PARCELADO.disabled = (v_soma <= 0);
							if(v_soma <= 0)
								PARCELADO.checked = false;
							TOTAL_PARCELA.disabled = !PARCELADO.checked || PARCELADO.disabled;
						}
					}
					
					function f_on_seleciona_ACRESCIMOS() {
						f_muda_produto();
					}
					function f_on_incluir_ACRESCIMOS() {
						f_muda_produto();
					}
					</script>					</td>
                 </tr>
               </table>
               </fieldset>
               <fieldset><legend>Observaes</legend><table width="100%" border="0" cellspacing="1" cellpadding="3">
                 <tr>
                   <td colspan="2"><textarea name="OBSERVACAO" id="OBSERVACAO" style="width: 100%; height: 60px"></textarea></td>
                 </tr>
               </table></fieldset></td>
           </tr>
           
           <tr>
             <td colspan="4" valign="top"><cfinclude template="forms/veiculo.cfm"></td>
           </tr>
		   <cfif vars.AVULSA eq 1>
           <tr>
             <td colspan="4" valign="top"><cfinclude template="forms/remetente_destinatario.cfm"></td>
           </tr>
           </cfif>
           <tr>
             <td colspan="4" valign="top"><cfinclude template="forms/manifestos.cfm"></td>
           </tr>
        </table></td>
      </tr>
	  <script>
	  initAbas('tbl_ct',0,true);
	  </script>
   </form>
</table>
</body>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display:none"></iframe>
<cfif IsDefined("vars.AVULSA") and vars.AVULSA eq 1>
	<script>
		document.forms[0].NUM_ROMANEIO.obrigatorio = 0;
	</script>
</cfif>
<cfif vars.CTF eq 1>
	<script>
		document.getElementById('tr_liberacao').style.display = 'none';
	</script>	
</cfif>
<cfif vars.AVULSA eq 1>
	<script>
		document.getElementById('tr_intc_conhecimento').style.display = '';
	</script>	
</cfif>