 <cfcomponent extends="_transportes.consulta.cfc_logistico">
	<!--- 
	-- PROPSITO 
	-- Busca os Lotes para o localizar
	-- CRISTOFER  28/11/2006
	--->		
	<cffunction name="get_operacao_localizar" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
		<cfargument name="solicitacao_carga_id" required="no" default="">
		<cfargument name="viagem_carga_id" required="no" default="">
		<cfargument name="remetente" required="no" default="">
		<cfargument name="num_produto" required="no" default="">
		<cfargument name="org_municipio" required="no" default="">
		<cfargument name="fracionado" required="no" default="">
		<cfargument name="internacional" required="no" default="">
		<cfargument name="frete_proprio" required="no" default="">
		<cfargument name="filial_atual" required="no" default="0">
		<cfargument name="dedicado" required="no" default="">
		<cfargument name="modalidade" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct o.operacao_id, o.descricao as operacao, vc.viagem_carga_id, 
                            rem.cod_pessoa cod_remetente,
                   			rem.cliente remetente,
                           	rmun.municipio_id org_municipio_id,
                           	dest.cod_pessoa cod_destinatario,
                           	dmun.municipio_id dest_municipio_id,
                            rmun.municipio||'-'||rmun.uf_id rem_municipio_uf,
                            nvl(dest.cliente ,'-- Aberto --') destinatario,
                            nvl(decode(sc.destino_municipio_id,'','',dmun.municipio||'-'||dmun.uf_id),'-- Aberto --') dest_municipio_uf,
                            o.fracionado, sc.solicitacao_carga_id, v.viagem_id,
                            o.frete_proprio, logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,sysdate,' > ', 1) as composicao,
                            logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,sysdate,' > ') as composicao_frota,
                            logistica.pkg_agendamento.fnc_viagem_motorista(vc.viagem_id) as motorista,
                            (select pm.cliente from kss.v$pessoa pm where pm.cod_pessoa = logistica.pkg_agendamento.fnc_viagem_motorista(vc.viagem_id)) as motorista_nome,
                            kss.fnc_ref_code('LOGISTICA', 'SOLICITACAO_CARGA.SITUACAO_ID', sc.situacao_id) as situacao,
                            v.num_romaneio as num_romaneio
                from logistica.v$viagem v
		       inner join logistica.v$viagem_carga vc
                       on vc.viagem_id = v.viagem_id
               inner join logistica.v$solicitacao_carga sc
                       on sc.solicitacao_carga_id = vc.solicitacao_carga_id       
               inner join logistica.v$operacao o
                       on o.operacao_id = sc.operacao_id
               inner join kss.v$pessoa rem
                   on rem.cod_pessoa = sc.cod_remetente
               inner join cep.municipio rmun
                   on rmun.municipio_id = sc.origem_municipio_id
                left join kss.v$pessoa dest
                   on dest.cod_pessoa = sc.cod_destinatario
                left join cep.municipio dmun
                   on dmun.municipio_id = sc.destino_municipio_id
               inner join kss.v$organograma org
                  on org.cod_organograma = sc.cod_organograma
               where sc.date_insert >= '01/07/2009'
                 and sc.situacao_id <> 5
                 and v.situacao_id <> 0
                 and o.tipo_documento = 0
               <cfif len(trim(arguments.operacao_id))>
                 and o.operacao_id in (#arguments.operacao_id#)
               </cfif>
               <cfif len(trim(arguments.fracionado))>
                 and o.fracionado in (#arguments.fracionado#)
               </cfif>
               <cfif len(trim(arguments.internacional))>
                 and o.internacional = #arguments.internacional#
               </cfif>
               <cfif len(trim(arguments.dedicado))>
                 and o.dedicado = #arguments.dedicado#
               </cfif>
               <cfif len(trim(arguments.frete_proprio))>
                 and o.frete_proprio = #arguments.frete_proprio#
               </cfif>
               <cfif len(trim(arguments.remetente))>
                  and upper(kss.pkg_string.fnc_string_clean(rem.cliente)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.remetente#'))||'%'
               </cfif>
               <cfif len(trim(arguments.org_municipio))>
                 and upper(kss.pkg_string.fnc_string_clean(dmun.municipio||'-'||dmun.uf_id)) like '%'||upper(kss.pkg_string.fnc_string_clean('#arguments.org_municipio#'))||'%'
               </cfif>
               <cfif arguments.filial_atual eq 1>
                 and sc.operacao_id in (select ofe.operacao_id
                                          from logistica.v$operacao_filial_emissao ofe
                                         where ofe.cod_organograma = '#session.cod_organograma#'
                                       )
               </cfif>
               <cfif len(trim(arguments.modalidade))>
                 and v.modalidade in (#ListQualify(arguments.modalidade,"'",',')#)
               </cfif>
               <cfif len(trim(arguments.sem_ctrc))>
                 and not exists (select 1 
                                   from fiscal.v$conhecimento c 
                                  inner join oper.v$romaneio_item rit
                                          on rit.item_id = c.item_id
                                  where rit.viagem_carga_id = vc.viagem_carga_id)
                 and not exists (select 1 
                                   from fiscal.v$nf_es_frete c 
                                  inner join oper.v$romaneio_item rit
                                          on rit.item_id = c.item_id
                                  where rit.viagem_carga_id = vc.viagem_carga_id)
               </cfif>
               <cfif len(trim(arguments.cod_pessoa))>
                 and org.cod_pessoa = #arguments.cod_pessoa#                 
               </cfif>
               <cfif len(trim(arguments.cod_centro_custo))>
                 and org.cod_centro_custo = #arguments.cod_centro_custo#
               </cfif>
               <cfif len(trim(arguments.placa))>
                 and (logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,sysdate,' > ', 1) like upper('%#arguments.placa#%')
                   or logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,sysdate,' > ') like upper('%#arguments.placa#%'))
               </cfif>               
               order by o.operacao_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Converte entre unidades de medida
	-- CRISTOFER  14/11/2006
	--->		
	<cffunction name="converte_unidade" access="remote" returntype="numeric" output="true">
		<cfargument name="valor" required="yes">
		<cfargument name="unidade_origem" required="yes">
		<cfargument name="unidade_destino" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fiscal.pkg_fiscal.fnc_converte_peso(#arguments.valor#, '#arguments.unidade_origem#', '#arguments.unidade_destino#') valor
			  from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os conhecimentos nos grupos logisticos para o periodo
	-- CRISTOFER  05/12/2006
	--->		
	<cffunction name="get_conhecimentos_grupo" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="cod_remetente" required="no" default="">
		<cfargument name="cod_destinatario" required="no" default="">
		<cfargument name="nf_numero" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="ordem_compra" required="no" default="">
		<cfargument name="num_pedido" required="no" default="">
		<cfif len(trim(arguments.nf_numero))>
			<cfquery name="qr_nf" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where numero in (#arguments.nf_numero#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.ordem_compra))>
			<cfquery name="qr_ordem_compra" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from fiscal.v$conhecimento_nota_fiscal
				 where ordem_compra_cliente in (#ListQualify(arguments.ordem_compra,"'",",")#)
			</cfquery>
		</cfif>
		<cfif len(trim(arguments.num_pedido))>
			<cfquery name="qr_pedido" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select conhecimento_id
				  from oper.v$carga c
				 inner join oper.v$carga_ctrc cc
				         on cc.carga_id = c.carga_id
				 where c.num_pedido in (#ListQualify(arguments.num_pedido,"'",",")#)
			</cfquery>
		</cfif>

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.data_emissao,
				   con.rem_razao_social remetente,
				   con.rem_cnpj_cpf,
				   con.dest_razao_social destinatario,
				   con.dest_cnpj_cpf,
				   mc.municipio||'-'||mc.uf_id coleta_municipio_uf,
				   me.municipio||'-'||me.uf_id entrega_municipio_uf,
				   (select kss.fnc_concat_all(kss.to_concat_expr(to_char(numero),' / '))
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) notas_fiscais,
				   (select sum(cn.valor_total)
				      from fiscal.v$conhecimento_nota_fiscal cn
					 where cn.conhecimento_id = con.conhecimento_id) valor_fiscal,
				   con.frete_peso,
				   con.pagador,
				   case con.pagador
				      when 0 then 'CIF'
					  when 1 then 'FOB'
					  else ''
				   end cif_fob,
				   con.frete_valor,
				   con.total_conhecimento,
				   con.pedagio,
				   con.valor_icms,
				   con.coleta_entrega,
				   con.DESPACHO,
				   con.peso, 
           		   c.num_pedido,
				   (select kss.fnc_concat_all(kss.to_concat_expr(cnf.ordem_compra_cliente,' / '))
				      from fiscal.v$conhecimento_nota_fiscal cnf
          			 where cnf.conhecimento_id = con.conhecimento_id) ordem_compra,
				   case 
					  when exists (select 'x'
									 from oper.v$coleta col
									where col.carga_id = c.carga_id) then 'Coletada'
					  else 'Entregue'
				   end coletada,
				   
				   con.prazo_entrega,
				   con.data_entrega,
				   nvl(r.data_termino_carga,con.data_emissao) as data_termino_carga,
	               r.situacao_id romaneio_situacao_id,
				   rf.latitude,
	               rf.longitude,
				   r.placa_controle,
				   decode(cd.descricao,'',cep.fnc_municipio_uf(c.municipio_id),'CD: '||cd.descricao) ultima_posicao,
				   rf.landmark,
                   (select crc.rv_meaning
                      from oper.cg_ref_codes crc
                     where crc.rv_domain = 'SITUACAO CARGA'
                       and crc.rv_low_value = c.situacao_id) situacao_carga,
                   ct.transferencia_id,
                   to_char(coalesce(ct.data_destino,ct.data_origem,c.date_insert),'dd/mm/yyyy hh24:mi:ss') data_situacao

				   
			  from fiscal.v$conhecimento con
			 inner join oper.v$grupo_logistico_usuario glu
					 on glu.usuario = user
	          left join oper.v$carga_ctrc cc
    	             on cc.conhecimento_id = con.conhecimento_id
       		  left join oper.v$carga c
                     on c.carga_id = cc.carga_id
			  left join oper.v$grupo_logistico_carga glc
					 on glc.cod_pessoa_carga = con.cod_remetente
					and glu.grupo_id = glc.grupo_id
			  left join oper.v$grupo_logistico_descarga gld
					 on gld.cod_pessoa_descarga = con.cod_destinatario
					and glu.grupo_id = gld.grupo_id
			 inner join cep.municipio mc
					 on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
					 on me.municipio_id = con.entrega_municipio_id

			   left join oper.v$romaneio r
					  on r.num_romaneio = con.NUM_ROMANEIO
			   left join oper.v$rank_frota rf
					  on rf.num_romaneio = r.num_romaneio

		      left join oper.v$centro_distribuicao cd
			         on cd.cod_pessoa_filial = c.cod_filial_atual
              left join oper.v$carga_transferencia ct
                     on ct.carga_id = c.carga_id
                    and ct.transferencia_id_posterior is null

			 where ( con.cod_remetente = glc.cod_pessoa_carga or 
					 con.cod_destinatario = gld.cod_pessoa_descarga)
               and con.cancelado is null
			 <cfif len(trim(arguments.cod_remetente)) or len(trim(arguments.cod_destinatario))>
			 	and ( 1=0
				<cfif len(trim(arguments.cod_remetente))>
				   or con.cod_remetente in (#arguments.cod_remetente#)
				</cfif>
				<cfif len(trim(arguments.cod_destinatario))>
				   or con.cod_destinatario in (#arguments.cod_destinatario#)
				</cfif>
					)
			 </cfif>
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif>
			 <cfif len(trim(arguments.data_inicial))>
			   and trunc(con.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.data_final))>
			   and trunc(con.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			<cfif len(trim(arguments.nf_numero))>
				<cfif not qr_nf.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_nf.conhecimento_id)#)
				</cfif>				
			</cfif>
			<cfif len(trim(arguments.ordem_compra))>
				<cfif not qr_ordem_compra.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_ordem_compra.conhecimento_id)#)
				</cfif>				
			</cfif>
			<cfif len(trim(arguments.num_pedido))>
				<cfif not qr_pedido.recordcount>
					and 1=0
				<cfelse>
					and con.conhecimento_id in (#Valuelist(qr_pedido.conhecimento_id)#)
				</cfif>				
			</cfif>
			 
			 order by con.data_emissao desc, con.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
</cfcomponent>
