<cfcomponent extends="_transportes.manipulacao.cfc_veiculo">
	<!--- 
    -- PROPSITO
    -- Insere veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:31:08 - CRIADO
    --->
    <cffunction name='ins_veiculo' displayname='Insere veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
        <cfargument name='TAG_SEM_PARAR' required='no' default="">
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default="">
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default="">
        <cfargument name='DATA_INICIO_RASTREADOR' required='no' default="">
        <cfargument name='NUM_NOTA_ID' required='no' default="">
        <cfargument name='NUM_CONTRATO' required='no' default="">
        <cfargument name='DATA_COMPRA' required='no' default="">
        <cfargument name='TIPO_COMPRA' required='no' default="">
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#UCase(REReplace(arguments.PLACA,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#UCase(REReplace(arguments.PLACA,'-',''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RASTREADOR'  value='#arguments.DATA_INICIO_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO'  value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPRA'  value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_COMPRA'  value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  null="yes" variable='retorno.ROWID' >
                </cfstoredproc>

				<cfscript>
					conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				</cfscript>
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
													  data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>

				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                 cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO,
													     data_inicio = LSDateFormat(Now()));
					</cfscript>
                </cfif>

				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>
					<!---Insere novo registro--->
                    <cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                        insert into oper.v$veiculo_motorista
                          (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
                        values
                          ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, null)
                    </cfquery>		
				</cfif>

				<cfif len(trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					   
					    this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
							   						    data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>
                
                <!---Insere situao--->
                <cfscript>
					this.ins_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
					                          situacao_id = 1,
											  data = LSDateFormat(Now()));
				</cfscript>
                
				<cfscript>
                   this.ins_veiculo_modalidade(placa = #UCase(REReplace(arguments.PLACA,'-',''))#,
                                               modalidade = 'TERCEIRO',
                                               data = LSDateFormat(Now()));
                </cfscript>                

                <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <cfif len(trim(arguments.TARA))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>

                <cfif len(trim(arguments.TAG_CTF))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TAG_CTF">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TAG_CTF#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                <cfif len(trim(arguments.CAPACIDADE_TRACAO))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:31:52 - CRIADO
    --->
    <cffunction name='upd_veiculo' displayname='Altera veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='no' default="">
        <cfargument name='TAG_SEM_PARAR' required='no' default="">
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default="">
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default="">
        <cfargument name='RASTREADOR_COM_PROBLEMAS' required='no' default="">
        <cfargument name='DATA_TROCA_RASTREADOR' required='no' default="">
        <cfargument name='NUM_NOTA_ID' required='no' default="">
        <cfargument name='NUM_CONTRATO' required='no' default="">
        <cfargument name='DATA_COMPRA' required='no' default="">
        <cfargument name='TIPO_COMPRA' required='no' default="">
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#arguments.COD_VEICULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_COM_PROBLEMAS'  value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TROCA_RASTREADOR'  value='#arguments.DATA_TROCA_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO'  value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPRA'  value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_COMPRA'  value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>


				<cfscript>
					conn = CreateObject("component", "_transportes.manipulacao.cfc_pessoa");
				</cfscript>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_proprietario
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#' 
				</cfquery>					
				<cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO,
													  data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_proprietario_doc
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO
													,num_modalidade = 3);
						
						this.ins_veiculo_proprietario_doc(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                              	  cod_pessoa = arguments.COD_PESSOA_PROPRIETARIO_DOCUMENTACAO,
													      data_inicio = LSDateFormat(Now()));
					</cfscript>
                </cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_motorista
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif len(trim(arguments.COD_PESSOA_MOTORISTA))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_MOTORISTA
													,num_modalidade = 8);
					</cfscript>

					<!---Insere novo registro--->
                    <cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                        insert into oper.v$veiculo_motorista
                          (placa, cod_pessoa, km_inicio, data_inicio, evo_id_recebimento)
                        values
                          ('#UCase(REReplace(arguments.PLACA,'-',''))#', #arguments.COD_PESSOA_MOTORISTA#, 1, sysdate, null)
                    </cfquery>		
				</cfif>

				<!---Limpa itens anteriores--->
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_permissionario
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>			
				<cfif len(trim(arguments.COD_PESSOA_PERMISSIONARIO))>
					<cfscript>
						conn.ins_pessoa_modalidade(cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO
													,num_modalidade = 20);
					   
					    this.ins_veiculo_permissionario(placa = UCase(REReplace(arguments.PLACA,'-','')),
						                                cod_pessoa = arguments.COD_PESSOA_PERMISSIONARIO,
							   						    data_inicio = LSDateFormat(Now()));
					</cfscript>
				</cfif>
                
				<!---Busca Modaliade Atual--->
                <cfquery name="qrModalidade" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
                     select max(modalidade) keep(dense_rank last order by data) modalidade
                       from oper.v$veiculo_modalidade
                      where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'                       
                </cfquery>			

                <cfscript>
                   if (qrModalidade.MODALIDADE neq 'TERCEIRO') {
                       this.ins_veiculo_modalidade(placa = #UCase(REReplace(arguments.PLACA,'-',''))#,
                                                   modalidade = 'TERCEIRO',
                                                   data = LSDateFormat(Now()) );
                    }
                </cfscript>
                                    
				<cfquery datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					delete oper.v$veiculo_hist_situacao
					 where placa = '#UCase(REReplace(arguments.PLACA,'-',''))#'
				</cfquery>	  
                              
                <!---Insere situao--->
				<cfscript>
					this.ins_veiculo_situacao(placa = UCase(REReplace(arguments.PLACA,'-','')),
					                          situacao_id = 1,
											  data = LSDateFormat(Now()));
				</cfscript>

                <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="MODALIDADE">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="TERCEIRO">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>

                <cfif len(trim(arguments.TAG_CTF))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TAG_CTF">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TAG_CTF#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                                
                <cfif len(trim(arguments.TARA))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="TARA">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.TARA#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                
                <cfif len(trim(arguments.CAPACIDADE_TRACAO))>
                    <cfstoredproc procedure="oper.pkg_frota_dml.prc_alt_veiculo_atributo" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam dbvarname="p_placa" 	    type="in"	cfsqltype="cf_sql_varchar" value="#UCase(REReplace(arguments.PLACA,'-',''))#">
                        <cfprocparam dbvarname="p_cod_atributo"	type="in"	cfsqltype="cf_sql_varchar" value="CAPACIDADE_TRACAO">
                        <cfprocparam dbvarname="p_valor"		type="in"	cfsqltype="cf_sql_varchar" value="#arguments.CAPACIDADE_TRACAO#">
	                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfif>
                                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere nova modalidade
    -- guto 09/04/2008 09:24:21 - CRIADO
    --->
    <cffunction name='ins_veiculo_modalidade' displayname='Insere nova modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA' required='yes'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODALIDADE'  value='#arguments.MODALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_MODALIDADE_ID'  variable='retorno.VEICULO_MODALIDADE_ID'  null='yes'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
        
	<!--- 
    -- PROPSITO
    -- Exclui veculo (ESTRUTURA NOVA)
    -- guto 17/07/2007 16:32:44 - CRIADO
    --->
    <cffunction name='del_veiculo' displayname='Exclui veculo (ESTRUTURA NOVA)' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#arguments.COD_VEICULO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula proprietrio ao veculo 
    -- guto 17/07/2007 16:34:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_proprietario' displayname='Vincula proprietrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula permissionrio ao veculo 
    -- guto 17/07/2007 16:46:28 - CRIADO
    --->
    <cffunction name='ins_veiculo_permissionario' displayname='Vincula permissionrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Vincula proprietrio ao veculo docto
    -- guto 17/07/2007 16:34:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_proprietario_doc' displayname='Vincula proprietrio ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='no' default="">
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>      

	<!--- 
    -- PROPSITO
    -- Vincula situao ao veculo 
    -- guto 17/07/2007 17:10:43 - CRIADO
    --->
    <cffunction name='ins_veiculo_situacao' displayname='Vincula situao ao veculo ' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_SITUACAO_ID'  null="yes" variable='retorno.VEICULO_SITUACAO_ID'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Insere um veculo
    -- ANDERSONC 18/03/2009 17:27:12 - CRIADO
    --->
    <cffunction name='ins_veiculo_geral' displayname='Insere um veculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='yes'>
        <cfargument name='TAG_SEM_PARAR' required='no' default='0'>
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default=''>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default=''>
        <cfargument name='DATA_INICIO_RASTREADOR' required='no' default=''>
        <cfargument name='NUM_NOTA_ID' required='no' default=''>
        <cfargument name='NUM_CONTRATO' required='no' default=''>
        <cfargument name='DATA_COMPRA' required='no' default=''>
        <cfargument name='TIPO_COMPRA' required='no' default=''>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cfargument name='ROWID' required='no' default=''>
        <cfdump var="#arguments#">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_ins_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#UCase(REReplace(arguments.COD_VEICULO, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#UCase(REReplace(arguments.PLACA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RASTREADOR'  value='#arguments.DATA_INICIO_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO'  value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPRA'  value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_COMPRA'  value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insere as situaes --->
                <cfscript>
					v_historicos_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_SITUACAO_SITUACAO');
					v_historicos_data_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_SITUACAO_SITUACAO');
					v_historicos_horario_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_SITUACAO_SITUACAO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_situacao(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
														SITUACAO_ID = v_historicos_situacao[count],
														DATA        = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere as modalidades --->
                <cfscript>
					v_historicos_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_MODALIDADE_MODALIDADE');
					v_historicos_data_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_MODALIDADE_MODALIDADE');
					v_historicos_horario_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_MODALIDADE_MODALIDADE');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_modalidade(PLACA      = UCase(REReplace(arguments.PLACA, '-', '')),
														  MODALIDADE = v_historicos_modalidade[count],
														  DATA       = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os proprietrios --->
                <cfscript>
					v_proprietario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_COD_PESSOA_PROPRIETARIO');
					v_proprietario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_PROPRIETARIO');
					v_proprietario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_INICIO_PROPRIETARIO');
					v_proprietario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_TERMINO_PROPRIETARIO');
					v_proprietario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_TERMINO_PROPRIETARIO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_proprietario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															COD_PESSOA  = v_proprietario_cod_pessoa[count],
															DATA_INICIO = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
															DATA_FIM    = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os laudos --->
				<cfscript>
					v_laudos_liberados_verificacao = ListToArray(arguments.LAUDOS_LIBERADOS_VERIFICACAO, ';');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                	<cfscript>
                        ret = this.ins_veiculo_laudo_excecao(PLACA    = UCase(REReplace(arguments.PLACA, '-', '')),
                                                             LAUDO_ID = v_laudos_liberados_verificacao[count]);
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Insere as classificaes ---> 
                <cfscript>
					v_classificacao_atributo = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_ATRIBUTO_CLASSIFICACAO');
					v_classificacao_valor = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_VALOR_CLASSIFICACAO');
					v_classificacao_tipo_dado = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_TIPO_DADO_CLASSIFICACAO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
					<cfscript>
						if(v_classificacao_tipo_dado[count] eq 'FLAG') {
							if(v_classificacao_valor[count] eq 'Sim') {
								v_classificacao_valor[count] = '1';
							}
							else if(v_classificacao_valor[count] eq 'No') {
								v_classificacao_valor[count] = '0';
							}
						}
						
						ret = this.upd_veiculo_atributo(PLACA        = UCase(REReplace(arguments.PLACA, '-', '')),
														COD_ATRIBUTO = v_classificacao_atributo[count],
														VALOR        = v_classificacao_valor[count]);
                    </cfscript>
                </cfloop>                              
                <!--- Fim --->
                
                <!--- Insere os permissionrios --->
                <cfscript>
					v_permissionario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_COD_PESSOA_PERMISSIONARIO');
					v_permissionario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_PERMISSIONARIO');
					v_permissionario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_INICIO_PERMISSIONARIO');
					v_permissionario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_TERMINO_PERMISSIONARIO');
					v_permissionario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_TERMINO_PERMISSIONARIO');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_permissionario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															  COD_PESSOA  = v_permissionario_cod_pessoa[count],
															  DATA_INICIO = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
															  DATA_FIM    = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Insere os proprietrios de documentos --->
                <cfscript>
					v_proprietario_doc_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_COD_PESSOA_PROPRIETARIO_DOC');
					v_proprietario_doc_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_TERMINO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_TERMINO_PROPRIETARIO_DOC');
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
					<cfscript>
						ret = this.ins_veiculo_proprietario_doc(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															    COD_PESSOA  = v_proprietario_doc_cod_pessoa[count],
															    DATA_INICIO = v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
															    DATA_FIM    = v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count]);
                    </cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Processa os dados do veculo --->
				<cfscript>
                    ret = this.processa_dados_veiculo(PLACA         = UCase(REReplace(arguments.PLACA, '-', '')),
													  TIPO_OPERACAO = 'I');
                </cfscript>
                <!--- Fim --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
    -- PROPSITO
    -- Insere um laudo
    -- ANDERSONC 20/03/2009 14:54:38 - CRIADO
    --->
    <cffunction name='ins_veiculo_laudo_excecao' displayname='Insere um laudo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='LAUDO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_ins_veiculo_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAUDO_ID'  value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um atributo
    -- ANDERSONC 20/03/2009 11:28:39 - CRIADO
    --->
    <cffunction name='upd_veiculo_atributo' displayname='Altera um atributo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_ATRIBUTO' required='yes'>
        <cfargument name='VALOR' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ATRIBUTO'  value='#arguments.COD_ATRIBUTO#' >
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' variable='retorno.VALOR' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Processa os dados de um veculo inserido ou alterado
    -- ANDERSONC 19/03/2009 09:37:47 - CRIADO
    --->
    <cffunction name='processa_dados_veiculo' displayname='Processa os dados de um veculo inserido ou alterado' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='TIPO_OPERACAO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_processa_dados_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_OPERACAO'  value='#arguments.TIPO_OPERACAO#' >
            </cfstoredproc>
		<cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um veculo
    -- ANDERSONC 19/03/2009 16:08:54 - CRIADO
    --->
    <cffunction name='upd_veiculo_geral' displayname='Altera um veculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_VEICULO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MARCA_ID' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='UF' required='yes'>
        <cfargument name='ANO' required='yes'>
        <cfargument name='CHASSIS' required='yes'>
        <cfargument name='RENAVAN' required='yes'>
        <cfargument name='COR_PREDOMINANTE' required='yes'>
        <cfargument name='CAPACIDADE_TANQUE' required='yes'>
        <cfargument name='TAG_SEM_PARAR' required='no' default='0'>
        <cfargument name='DATA_INICIO_SEM_PARAR' required='no' default=''>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='RASTREADOR_ID' required='no' default=''>
        <cfargument name='RASTREADOR_COM_PROBLEMAS' required='no' default=''>
        <cfargument name='DATA_TROCA_RASTREADOR' required='no' default=''>
        <cfargument name='NUM_NOTA_ID' required='no' default=''>
        <cfargument name='NUM_CONTRATO' required='no' default=''>
        <cfargument name='DATA_COMPRA' required='no' default=''>
        <cfargument name='TIPO_COMPRA' required='no' default=''>
        <cfargument name='TIPO_CARROCERIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_VEICULO'  value='#UCase(REReplace(arguments.COD_VEICULO, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#UCase(REReplace(arguments.PLACA, '-', ''))#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO'  value='#arguments.ANO#'  null='#iif(len(trim(arguments.ANO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CHASSIS'  value='#arguments.CHASSIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RENAVAN'  value='#arguments.RENAVAN#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COR_PREDOMINANTE'  value='#arguments.COR_PREDOMINANTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE_TANQUE'  value='#arguments.CAPACIDADE_TANQUE#'  null='#iif(len(trim(arguments.CAPACIDADE_TANQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TAG_SEM_PARAR'  value='#arguments.TAG_SEM_PARAR#'  null='#iif(len(trim(arguments.TAG_SEM_PARAR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_SEM_PARAR'  value='#arguments.DATA_INICIO_SEM_PARAR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_ID'  value='#arguments.RASTREADOR_ID#' variable='retorno.RASTREADOR_ID'  null='#iif(len(trim(arguments.RASTREADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RASTREADOR_COM_PROBLEMAS'  value='#arguments.RASTREADOR_COM_PROBLEMAS#'  null='#iif(len(trim(arguments.RASTREADOR_COM_PROBLEMAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TROCA_RASTREADOR'  value='#arguments.DATA_TROCA_RASTREADOR#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_CONTRATO'  value='#arguments.NUM_CONTRATO#'  null='#iif(len(trim(arguments.NUM_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_COMPRA'  value='#arguments.DATA_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_COMPRA'  value='#arguments.TIPO_COMPRA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CARROCERIA_ID'  value='#arguments.TIPO_CARROCERIA_ID#'  null='#iif(len(trim(arguments.TIPO_CARROCERIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_veiculo");
				</cfscript>
                
                <!--- Altera as situaes --->
                <cfscript>
					v_historicos_veiculo_situacao_id = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_VEICULO_SITUACAO_ID_SITUACAO');
					v_historicos_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_SITUACAO_SITUACAO');
					v_historicos_data_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_SITUACAO_SITUACAO');
					v_historicos_horario_situacao = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_SITUACAO_SITUACAO');
					
					qrSituacao = conn.get_veiculo_hist_situacao(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrSituacao">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
                    	<cfscript>
							if(qrSituacao.VEICULO_SITUACAO_ID eq v_historicos_veiculo_situacao_id[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_situacao(VEICULO_SITUACAO_ID = qrSituacao.VEICULO_SITUACAO_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_historicos_situacao)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_historicos_veiculo_situacao_id[count]))) {
							ret = this.ins_veiculo_situacao(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
															SITUACAO_ID = v_historicos_situacao[count],
															DATA        = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
						}
						else {
							ret = this.upd_veiculo_situacao(VEICULO_SITUACAO_ID = v_historicos_veiculo_situacao_id[count],
															PLACA               = UCase(REReplace(arguments.PLACA, '-', '')),
															SITUACAO_ID         = v_historicos_situacao[count],
															DATA                = v_historicos_data_situacao[count] & ' ' & v_historicos_horario_situacao[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera as modalidades --->
                <cfscript>
					v_historicos_veiculo_modalidade_id = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_VEICULO_MODALIDADE_ID_MODALIDADE');
					v_historicos_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_MODALIDADE_MODALIDADE');
					v_historicos_data_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_DATA_MODALIDADE_MODALIDADE');
					v_historicos_horario_modalidade = this.ListaToArray(lista = arguments, variavel = 'HISTORICOS_HORARIO_MODALIDADE_MODALIDADE');
					
					qrModalidade = conn.get_veiculo_modalidade(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrModalidade">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
                    	<cfscript>
							if(qrModalidade.VEICULO_MODALIDADE_ID eq v_historicos_veiculo_modalidade_id[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_modalidade(VEICULO_MODALIDADE_ID = qrModalidade.VEICULO_MODALIDADE_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_historicos_modalidade)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_historicos_veiculo_modalidade_id[count]))) {
							ret = this.ins_veiculo_modalidade(PLACA      = UCase(REReplace(arguments.PLACA, '-', '')),
														      MODALIDADE = v_historicos_modalidade[count],
														      DATA       = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
						}
						else {
							ret = this.upd_veiculo_modalidade(VEICULO_MODALIDADE_ID = v_historicos_veiculo_modalidade_id[count],
															  PLACA                 = UCase(REReplace(arguments.PLACA, '-', '')),
														      MODALIDADE            = v_historicos_modalidade[count],
														      DATA                  = v_historicos_data_modalidade[count] & ' ' & v_historicos_horario_modalidade[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera os proprietrios --->
                <cfscript>
					v_proprietario_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_OLD_PROPRIETARIO');
					v_proprietario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_COD_PESSOA_PROPRIETARIO');
					v_proprietario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_INICIO_PROPRIETARIO');
					v_proprietario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_INICIO_PROPRIETARIO');
					v_proprietario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DATA_TERMINO_PROPRIETARIO');
					v_proprietario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_HORARIO_TERMINO_PROPRIETARIO');
					
					qrProprietario = conn.get_veiculo_proprietario_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrProprietario">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrProprietario.OLD_DATA_INICIO eq v_proprietario_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_proprietario(PLACA       = qrProprietario.PLACA,
																COD_PESSOA  = qrProprietario.COD_PESSOA,
																DATA_INICIO = qrProprietario.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_proprietario_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_proprietario_data_inicio_old[count]))) {
							ret = this.ins_veiculo_proprietario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																COD_PESSOA  = v_proprietario_cod_pessoa[count],
																DATA_INICIO = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
																DATA_FIM    = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_proprietario(PLACA           = UCase(REReplace(arguments.PLACA, '-', '')),
																COD_PESSOA      = v_proprietario_cod_pessoa[count],
																DATA_INICIO     = v_proprietario_data_inicio[count] & ' ' & v_proprietario_horario_inicio[count],
																DATA_FIM        = v_proprietario_data_termino[count] & ' ' & v_proprietario_horario_termino[count],
																OLD_DATA_INICIO = v_proprietario_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>				
                <!--- Fim --->
                
                <!--- Altera os laudos --->
                <cfscript>
					v_laudos_liberados_verificacao = ListToArray(arguments.LAUDOS_LIBERADOS_VERIFICACAO, ';');
					
					qrLaudoLiberado = conn.get_laudos_liberados(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrLaudoLiberado">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                    	<cfscript>
							if(qrLaudoLiberado.LAUDO_ID eq v_laudos_liberados_verificacao[count]) {
								v_flag = 1;
								break;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_laudo_excecao(PLACA    = qrLaudoLiberado.PLACA,
                                                             	 LAUDO_ID = qrLaudoLiberado.LAUDO_ID);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_laudos_liberados_verificacao)#" index="count">
                	<cfscript>
						v_flag = 0;
					</cfscript>
					
					<cfloop query="qrLaudoLiberado">
						<cfscript>
							if(v_laudos_liberados_verificacao[count] eq qrLaudoLiberado.LAUDO_ID) {
								v_flag = 1;
								break;
							}
						</cfscript>
					</cfloop>
					
					<cfscript>
						if(v_flag eq 0) {
							ret = this.ins_veiculo_laudo_excecao(PLACA    = UCase(REReplace(arguments.PLACA, '-', '')),
																 LAUDO_ID = v_laudos_liberados_verificacao[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera as classificaes --->
                <cfscript>
					v_classificacao_flag = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_FLAG_CLASSIFICACAO');
					v_classificacao_atributo = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_ATRIBUTO_CLASSIFICACAO');
					v_classificacao_valor = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_VALOR_CLASSIFICACAO');
					v_classificacao_tipo_dado = this.ListaToArray(lista = arguments, variavel = 'CLASSIFICACAO_TIPO_DADO_CLASSIFICACAO');
					
					qrClassificacao = conn.get_veiculo_atributo(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrClassificacao">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
                    	<cfscript>
							if(qrClassificacao.COD_ATRIBUTO eq v_classificacao_atributo[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_atributo(PLACA        = qrClassificacao.PLACA,
                                                            COD_ATRIBUTO = qrClassificacao.COD_ATRIBUTO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_classificacao_atributo)#" index="count">
					<cfscript>
						if(v_classificacao_tipo_dado[count] eq 'FLAG') {
							if(v_classificacao_valor[count] eq 'Sim') {
								v_classificacao_valor[count] = '1';
							}
							else if(v_classificacao_valor[count] eq 'No') {
								v_classificacao_valor[count] = '0';
							}
						}
						
						ret = this.upd_veiculo_atributo(PLACA        = UCase(REReplace(arguments.PLACA, '-', '')),
														COD_ATRIBUTO = v_classificacao_atributo[count],
														VALOR        = v_classificacao_valor[count]);
                    </cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera os permissionrios --->
                <cfscript>
					v_permissionario_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_OLD_PERMISSIONARIO');
					v_permissionario_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_COD_PESSOA_PERMISSIONARIO');
					v_permissionario_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_INICIO_PERMISSIONARIO');
					v_permissionario_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_INICIO_PERMISSIONARIO');
					v_permissionario_data_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_DATA_TERMINO_PERMISSIONARIO');
					v_permissionario_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PERMISSIONARIO_HORARIO_TERMINO_PERMISSIONARIO');
					
					qrPermissionario = conn.get_veiculo_permissionario_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrPermissionario">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrPermissionario.OLD_DATA_INICIO eq v_permissionario_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_permissionario(PLACA       = qrPermissionario.PLACA,
																  COD_PESSOA  = qrPermissionario.COD_PESSOA,
																  DATA_INICIO = qrPermissionario.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_permissionario_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_permissionario_data_inicio_old[count]))) {
							ret = this.ins_veiculo_permissionario(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																  COD_PESSOA  = v_permissionario_cod_pessoa[count],
																  DATA_INICIO = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
																  DATA_FIM    = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_permissionario(PLACA       	  = UCase(REReplace(arguments.PLACA, '-', '')),
																  COD_PESSOA  	  = v_permissionario_cod_pessoa[count],
																  DATA_INICIO 	  = v_permissionario_data_inicio[count] & ' ' & v_permissionario_horario_inicio[count],
																  DATA_FIM        = v_permissionario_data_termino[count] & ' ' & v_permissionario_horario_termino[count],
																  OLD_DATA_INICIO = v_permissionario_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Altera os proprietrios de documentos --->
                <cfscript>
					v_proprietario_doc_data_inicio_old = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_OLD_PROPRIETARIO_DOC');
					v_proprietario_doc_cod_pessoa = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_COD_PESSOA_PROPRIETARIO_DOC');
					v_proprietario_doc_data_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_inicio = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_INICIO_PROPRIETARIO_DOC');
					v_proprietario_doc_data_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_DATA_TERMINO_PROPRIETARIO_DOC');
					v_proprietario_doc_horario_termino = this.ListaToArray(lista = arguments, variavel = 'PROPRIETARIO_DOC_HORARIO_TERMINO_PROPRIETARIO_DOC');
					
					qrProprietarioDoc = conn.get_veiculo_proprietario_doc_geral(placa = UCase(REReplace(arguments.PLACA, '-', '')));
				</cfscript>
                <cfloop query="qrProprietarioDoc">
                	<cfscript>
						v_flag = 0;
					</cfscript>
                    
                    <cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
                    	<cfscript>
							if(qrProprietarioDoc.OLD_DATA_INICIO eq v_proprietario_doc_data_inicio_old[count]) {
								v_flag = 1;
								break;
							}
							else {
								v_flag = 0;
							}
						</cfscript>
                    </cfloop>
                    
                    <cfscript>
						if(v_flag eq 0) {
							ret = this.del_veiculo_proprietario_doc(PLACA       = qrProprietarioDoc.PLACA,
																    COD_PESSOA  = qrProprietarioDoc.COD_PESSOA,
																    DATA_INICIO = qrProprietarioDoc.DATA_INICIO);
						}
					</cfscript>
                </cfloop>
				<cfloop from="1" to="#ArrayLen(v_proprietario_doc_cod_pessoa)#" index="count">
					<cfscript>
						if(Not Len(Trim(v_proprietario_doc_data_inicio_old[count]))) {
							ret = this.ins_veiculo_proprietario_doc(PLACA       = UCase(REReplace(arguments.PLACA, '-', '')),
																	COD_PESSOA  = v_proprietario_doc_cod_pessoa[count],
																	DATA_INICIO = v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
																	DATA_FIM    = v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count]);
						}
						else {
							ret = this.upd_veiculo_proprietario_doc(PLACA           = UCase(REReplace(arguments.PLACA, '-', '')),
																	COD_PESSOA      = v_proprietario_doc_cod_pessoa[count],
																	DATA_INICIO 	= v_proprietario_doc_data_inicio[count] & ' ' & v_proprietario_doc_horario_inicio[count],
																	DATA_FIM    	= v_proprietario_doc_data_termino[count] & ' ' & v_proprietario_doc_horario_termino[count],
																	OLD_DATA_INICIO = v_proprietario_doc_data_inicio_old[count]);
						}
					</cfscript>
                </cfloop>
                <!--- Fim --->
                
                <!--- Processa os dados do veculo --->
				<cfscript>
                    ret = this.processa_dados_veiculo(PLACA         = UCase(REReplace(arguments.PLACA, '-', '')),
													  TIPO_OPERACAO = 'U');
                </cfscript>
                <!--- Fim --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Veculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera uma situao
    -- ANDERSONC 23/03/2009 15:26:28 - CRIADO
    --->
    <cffunction name='upd_veiculo_situacao' displayname='Altera uma situao' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_SITUACAO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_SITUACAO_ID'  value='#arguments.VEICULO_SITUACAO_ID#'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera uma modalidade
    -- ANDERSONC 23/03/2009 15:25:00 - CRIADO
    --->
    <cffunction name='upd_veiculo_modalidade' displayname='Altera uma modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_MODALIDADE_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='MODALIDADE' required='yes'>
        <cfargument name='DATA' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_MODALIDADE_ID'  value='#arguments.VEICULO_MODALIDADE_ID#'  null='#iif(len(trim(arguments.VEICULO_MODALIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODALIDADE'  value='#arguments.MODALIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
	-- PROPSITO
	-- Altera um proprietrio
	-- ANDERSONC 23/03/2009 15:31:38 - CRIADO
	--->
	<cffunction name='upd_veiculo_proprietario' displayname='Altera um proprietrio' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cfargument name='OLD_DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OLD_DATA_INICIO'  value='#arguments.OLD_DATA_INICIO#' >
            </cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um permissionrio
    -- ANDERSONC 23/03/2009 15:49:03 - CRIADO
    --->
    <cffunction name='upd_veiculo_permissionario' displayname='Altera um permissionrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='OLD_DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OLD_DATA_INICIO'  value='#arguments.OLD_DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera um proprietrio de documentos
    -- ANDERSONC 23/03/2009 16:00:11 - CRIADO
    --->
    <cffunction name='upd_veiculo_proprietario_doc' displayname='Altera um proprietrio de documentos' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_FIM' required='yes'>
        <cfargument name='OLD_DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_alt_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_FIM'  value='#arguments.DATA_FIM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OLD_DATA_INICIO'  value='#arguments.OLD_DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui uma situao
    -- ANDERSONC 23/03/2009 16:17:28 - CRIADO
    --->
    <cffunction name='del_veiculo_situacao' displayname='Exclui uma situao' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_SITUACAO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_hist_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_SITUACAO_ID'  value='#arguments.VEICULO_SITUACAO_ID#'  null='#iif(len(trim(arguments.VEICULO_SITUACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui uma modalidade
    -- ANDERSONC 23/03/2009 16:39:43 - CRIADO
    --->
    <cffunction name='del_veiculo_modalidade' displayname='Exclui uma modalidade' access='remote' returntype='Struct' output='true'>
        <cfargument name='VEICULO_MODALIDADE_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_modalidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VEICULO_MODALIDADE_ID'  value='#arguments.VEICULO_MODALIDADE_ID#'  null='#iif(len(trim(arguments.VEICULO_MODALIDADE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um proprietrio
    -- ANDERSONC 24/03/2009 10:25:37 - CRIADO
    --->
    <cffunction name='del_veiculo_proprietario' displayname='Exclui um proprietrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_proprietario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um permissionrio
    -- ANDERSONC 24/03/2009 10:59:28 - CRIADO
    --->
    <cffunction name='del_veiculo_permissionario' displayname='Exclui um permissionrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_permissionario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um proprietrio de documentos
    -- ANDERSONC 24/03/2009 11:01:02 - CRIADO
    --->
    <cffunction name='del_veiculo_proprietario_doc' displayname='Exclui um proprietrio de documentos' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_prop_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um laudo
    -- ANDERSONC 24/03/2009 17:49:34 - CRIADO
    --->
    <cffunction name='del_veiculo_laudo_excecao' displayname='Exclui um laudo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='LAUDO_ID' required='yes'>
            <cfstoredproc procedure='oper.pkg_veiculo_laudos.prc_del_veiculo_laudo_excecao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LAUDO_ID'  value='#arguments.LAUDO_ID#'  null='#iif(len(trim(arguments.LAUDO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Exclui um atributo
    -- ANDERSONC 24/03/2009 17:55:34 - CRIADO
    --->
    <cffunction name='del_veiculo_atributo' displayname='Exclui um atributo' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_ATRIBUTO' required='yes'>
            <cfstoredproc procedure='oper.pkg_frota_dml.prc_del_veiculo_atributo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ATRIBUTO'  value='#arguments.COD_ATRIBUTO#' >
            </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>
</cfcomponent>