<cfcomponent extends="_transportes.manipulacao.cfc_transp_internacional">
    <!--- 
	-- PROPSITO
	-- Insere um conhecimento internacional
	-- 06/12/2005 - criado
	--->
    <cffunction name="ins_intc_conhecimento" displayname="Insere um tipo de objeto" access="remote" returntype="Struct" output="true">
        <cfargument name="numero" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="#session.cod_pessoa#" >
        <cfargument name="cod_organograma" required="yes">
        <cfargument name="emissao_local" required="no" default="">
        <cfargument name="emissao_municipio_id" required="yes" default="">
        <cfargument name="emissao_data" required="no" default="#DateFormat(now(), 'DD/MM/YYYY')#">
        <cfargument name="resp_local" required="yes">
        <cfargument name="resp_municipio_id" required="yes">
        <cfargument name="resp_data" required="yes">
        <cfargument name="entrega_local" required="yes">
        <cfargument name="entrega_municipio_id" required="yes">
        <cfargument name="entrega_data" required="yes">
        <cfargument name="transp_sucessivos" required="no" default="N.I.H.I.L">
        <cfargument name="cod_remetente" required="yes">
        <cfargument name="rem_endereco" required="yes">
        <cfargument name="rem_municipio" required="yes">
        <cfargument name="rem_uf" required="yes">
        <cfargument name="rem_pais" required="yes">
        <cfargument name="rem_cnpj_cpf" required="yes">
        <cfargument name="cod_destinatario" required="yes">
        <cfargument name="dest_nome" required="yes">
        <cfargument name="dest_endereco" required="yes">
        <cfargument name="dest_municipio" required="yes">
        <cfargument name="dest_uf" required="yes">
        <cfargument name="dest_pais" required="yes">
        <cfargument name="dest_cnpj_cpf" required="yes">
        <cfargument name="cod_consignatario" required="yes">
        <cfargument name="cons_nome" required="yes">
        <cfargument name="cons_endereco" required="yes">
        <cfargument name="cons_municipio" required="yes">
        <cfargument name="cons_uf" required="yes">
        <cfargument name="cons_pais" required="yes">
        <cfargument name="cons_cnpj_cpf" required="yes">
        <cfargument name="cod_notificar" required="yes">
        <cfargument name="not_nome" required="yes">
        <cfargument name="not_endereco" required="yes">
        <cfargument name="not_municipio" required="yes">
        <cfargument name="not_uf" required="yes">
        <cfargument name="not_pais" required="yes">
        <cfargument name="not_cnpj_cpf" required="yes">
        <cfargument name="mercadorias" required="no" default="">
        <cfargument name="num_especie" required="yes">
        <cfargument name="quantidade_total" required="yes">
        <cfargument name="peso_bruto" required="yes">
        <cfargument name="peso_liquido" required="yes">
        <cfargument name="unidade_id" required="yes">
        <cfargument name="m3" required="yes">
        <cfargument name="valor_total" required="yes">
        <cfargument name="valor_total_incoterm_id" required="yes">
        <cfargument name="valor_total_cod_moeda" required="yes">
        <cfargument name="total_custo_origem" required="yes">
        <cfargument name="total_custo_origem_cod_moeda" required="no" default="220">
        <cfargument name="total_custo_destino" required="yes">
        <cfargument name="total_custo_destino_cod_moeda" required="no" default="220">
        <cfargument name="valor_frt_externo" required="yes">
        <cfargument name="valor_frt_externo_cod_moeda" required="no" default="220">
        <cfargument name="valor_reembolso" required="yes">
        <cfargument name="valor_reembolso_cod_moeda" required="no" default="220">
        <cfargument name="valor_mercadorias" required="yes">
        <cfargument name="valor_mercadorias_incoterm" required="yes">
        <cfargument name="valor_mercadorias_cod_moeda" required="no" default="220">
        <cfargument name="alfandega_origem_id" required="yes">
        <cfargument name="alfandega_destino_id" required="yes">
        <cfargument name="pais_id_origem" required="yes">
        
        <cfargument name="pago_por" required="no" default="1">
        <cfargument name="declaracao_observacao" required="yes">
        <cfargument name="OBS_PAGO_POR" required="no">
        <cfargument name="ADICIONAIS_MERCADORIA" required="yes" >
        <cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
        <cfargument name="QTDE_VEICULOS" required="no" default="1" >
        
        <cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
        <cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
    
        <cfargument name='COD_PAGADOR_ORIGEM' required='yes'>
        <cfargument name='PAG_ORIGEM_NOME' required='yes'>
        <cfargument name='PAG_ORIGEM_ENDERECO' required='yes'>
        <cfargument name='PAG_ORIGEM_CIDADE' required='yes'>
        <cfargument name='PAG_ORIGEM_UF' required='yes'>
        <cfargument name='PAG_ORIGEM_PAIS' required='yes'>
        <cfargument name='PAG_ORIGEM_CNPJ_CPF' required='yes'>
        <cfargument name='COD_PAGADOR_DESTINO' required='yes'>
        <cfargument name='PAG_DESTINO_NOME' required='yes'>
        <cfargument name='PAG_DESTINO_ENDERECO' required='yes'>
        <cfargument name='PAG_DESTINO_CIDADE' required='yes'>
        <cfargument name='PAG_DESTINO_UF' required='yes'>
        <cfargument name='PAG_DESTINO_PAIS' required='yes'>
        <cfargument name='PAG_DESTINO_CNPJ_CPF' required='yes'>    
        <cfargument name='PRE_CONHECIMENTO' required='yes' default="0">    
        <cfargument name='COTACAO' required='yes'>
        <cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">  
        <cfargument name='PRAZO_ENTREGA' required='yes'>
        <cfargument name='COD_NEGOCIADOR' required='yes'>  
        <cfargument name='NF_FATURA' required='yes'>
        <cfargument name='TIPO_CRT' required='no' default="0">
        <cfargument name='OPERACAO_ID_CRT' required='no' default="">
        <cfargument name='CRT_COD_PAIS' required='no' default="">
        <cfargument name='CRT_NUM_PERMISSO' required='no' default="">
        <cfargument name='CRT_NUMERO' required='no' default="">
        <cfargument name='CRT_SERIE' required='no' default="">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
        <cftry>
            <cfscript>
                v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                v_mercadorias = "";
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
                <cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
            </cfloop>
                <cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>			
            <cftransaction action="begin"> 
                <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_ins_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam dbvarname="P_NUMERO_COD_PAIS" 				type="in"  cfsqltype="cf_sql_varchar" value="#UCase(arguments.CRT_COD_PAIS)#">
                    <cfprocparam dbvarname="P_NUMERO_CERTIFICADO" 			type="in"  cfsqltype="cf_sql_varchar" value="#arguments.CRT_NUM_PERMISSO#">
                    <cfprocparam dbvarname="P_NUMERO_SEQUENCIAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.CRT_NUMERO#" null="#iif(len(trim(arguments.CRT_NUMERO)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_COD_PESSOA_FILIAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_pessoa_filial#" null="#iif(len(trim(arguments.cod_pessoa_filial)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_COD_ORGANOGRAMA" 			   type="in"  cfsqltype="cf_sql_varchar" value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_EMISSAO_LOCAL" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_local#">
                    <cfprocparam dbvarname="P_EMISSAO_MUNICIPIO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.emissao_municipio_id#" null="#iif(len(trim(arguments.emissao_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_EMISSAO_DATA" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data#">
                    <cfprocparam dbvarname="P_RESP_LOCAL" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_local#">
                    <cfprocparam dbvarname="P_RESP_MUNICIPIO_ID" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.resp_municipio_id#" null="#iif(len(trim(arguments.resp_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_RESP_DATA" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.resp_data#">
                    <cfprocparam dbvarname="P_ENTREGA_LOCAL" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_local#">
                    <cfprocparam dbvarname="P_ENTREGA_MUNICIPIO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.entrega_municipio_id#" null="#iif(len(trim(arguments.entrega_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_ENTREGA_DATA" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.entrega_data#">
                    <cfprocparam dbvarname="P_TRANSP_SUCESSIVOS"			type="in"  cfsqltype="cf_sql_varchar" value="#arguments.transp_sucessivos#">
                    <cfprocparam dbvarname="P_COD_REMETENTE" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_remetente#">
                    <cfprocparam dbvarname="P_REM_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_nome#">
                    <cfprocparam dbvarname="P_REM_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_endereco#">
                    <cfprocparam dbvarname="P_REM_MUNICIPIO_ID"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.rem_municipio_id#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_REM_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_municipio#">
    
                    <cfprocparam dbvarname="P_REM_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_uf#">
                    <cfprocparam dbvarname="P_REM_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_pais#">
                    <cfprocparam dbvarname="P_REM_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.rem_cnpj_cpf#">
                    <cfprocparam dbvarname="P_COD_DESTINATARIO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_destinatario#">
                    <cfprocparam dbvarname="P_DEST_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_nome#">
                    <cfprocparam dbvarname="P_DEST_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_endereco#">
                    <cfprocparam dbvarname="P_DEST_MUNICIPIO_ID"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.dest_municipio_id#" null="#iif(len(trim(arguments.dest_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_DEST_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_municipio#">
    
                    <cfprocparam dbvarname="P_DEST_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_uf#">
                    <cfprocparam dbvarname="P_DEST_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_pais#">
                    <cfprocparam dbvarname="P_DEST_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.dest_cnpj_cpf#">
                    <cfprocparam dbvarname="P_COD_CONSIGNATARIO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_consignatario#">
                    <cfprocparam dbvarname="P_CONS_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_nome#">
                    <cfprocparam dbvarname="P_CONS_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_endereco#">
                    <cfprocparam dbvarname="P_CONS_MUNICIPIO_ID"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cons_municipio_id#" null="#iif(len(trim(arguments.cons_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_CONS_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_municipio#">
    
                    <cfprocparam dbvarname="P_CONS_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_uf#">
                    <cfprocparam dbvarname="P_CONS_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_pais#">
                    <cfprocparam dbvarname="P_CONS_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.cons_cnpj_cpf#">
                    <cfprocparam dbvarname="P_COD_NOTIFICAR" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.cod_notificar#" null="#iif(len(trim(arguments.cod_notificar)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_NOT_NOME" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_nome#">
                    <cfprocparam dbvarname="P_NOT_ENDERECO" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_endereco#">
                    <cfprocparam dbvarname="P_NOT_MUNICIPIO_ID"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.not_municipio_id#" null="#iif(len(trim(arguments.not_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_NOT_CIDADE" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_municipio#">
    
                    <cfprocparam dbvarname="P_NOT_UF" 						type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_uf#">
                    <cfprocparam dbvarname="P_NOT_PAIS" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_pais#">
                    <cfprocparam dbvarname="P_NOT_CNPJ_CPF" 				type="in"  cfsqltype="cf_sql_varchar" value="#arguments.not_cnpj_cpf#">
                    <cfprocparam dbvarname="P_MERCADORIAS" 					type="in"  cfsqltype="cf_sql_varchar" value="#v_mercadorias#">
                    <cfprocparam dbvarname="P_NUM_ESPECIE" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.num_especie#" null="#iif(len(trim(arguments.num_especie)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
                    <cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#"  null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_total, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_cod_moeda#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM_COD_MOEDA" type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO_COD_MOED" type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_FRT_EXTERNO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_frt_externo, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_FRT_EXTERNO_COD_MOEDA"	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#Replace(arguments.valor_mercadorias, ',', '.', 'all')#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_cod_moeda#" null="#iif(len(trim(arguments.valor_mercadorias_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_MERCADORIAS_INCOTERM" 	type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias_incoterm#" null="#iif(len(trim(arguments.valor_mercadorias_incoterm)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_ALFANDEGA_ORIGEM_ID" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_origem_id#"  null="#iif(len(trim(arguments.alfandega_origem_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_ALFANDEGA_DESTINO_ID" 		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.alfandega_destino_id#"  null="#iif(len(trim(arguments.alfandega_destino_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PAGO_POR" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.pago_por#" null="#iif(len(trim(arguments.pago_por)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_DECLARACAO_OBSERVACAO" 		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.declaracao_observacao#">
                    <cfprocparam dbvarname="P_OBS_PAGO_POR" 				type="in"  cfsqltype="cf_sql_varchar"  value="#arguments.OBS_PAGO_POR#">
                    <cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_CONHECIMENTO_ID" 				type="inout" cfsqltype="cf_sql_numeric" scale="5" null="yes" variable="retorno.conhecimento_id">
                    <cfprocparam dbvarname="P_ROWID" 						type="out" cfsqltype="cf_sql_varchar" variable="retorno.rowid">			
                    <cfprocparam dbvarname="P_EMISSAO_DATA_IMPRESSAO"		type="in"  cfsqltype="cf_sql_varchar" value="#arguments.emissao_data_impressao#">
                    <cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_ORIGEM'  value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_NOME'  value='#arguments.PAG_ORIGEM_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_ENDERECO'  value='#arguments.PAG_ORIGEM_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CIDADE'  value='#arguments.PAG_ORIGEM_CIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_UF'  value='#arguments.PAG_ORIGEM_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_PAIS'  value='#arguments.PAG_ORIGEM_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CNPJ_CPF'  value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_DESTINO'  value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_NOME'  value='#arguments.PAG_DESTINO_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_ENDERECO'  value='#arguments.PAG_DESTINO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CIDADE'  value='#arguments.PAG_DESTINO_CIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_UF'  value='#arguments.PAG_DESTINO_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_PAIS'  value='#arguments.PAG_DESTINO_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CNPJ_CPF'  value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
                    <cfprocparam dbvarname="P_PRE_CONHECIMENTO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO' value='#arguments.COTACAO#' null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PRAZO_ENTREGA" value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_FATURA'  value='#arguments.NF_FATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_CRT'  value='#arguments.TIPO_CRT#'  null='#iif(len(trim(arguments.TIPO_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OPERACAO_ID_CRT'  value='#arguments.OPERACAO_ID_CRT#'  null='#iif(len(trim(arguments.OPERACAO_ID_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERIE'  value='#arguments.CRT_SERIE#'  null='#iif(len(trim(arguments.CRT_SERIE)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PEDIDO_SHIPMENT" value="#arguments.pedido_shipment#" >
                </cfstoredproc>
                
                <!--- Insercao de Mercadorias Transportadas --->
                <cfscript>
                    v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
                    v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
                    v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
                    v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
                    v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
                    v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
                    v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_item_crt(	conhecimento_id = retorno.conhecimento_id,
                                            produto_id = v_produto_id[count],
                                            num_especie = v_num_especie[count],
                                            quantidade = v_quantidade[count],
                                            peso_bruto = v_peso_bruto[count],
                                            peso_liquido = v_peso_liquido[count],
                                            m3 = v_m3[count],
                                            descricao = v_descricao[count]);
                    </cfscript>
                </cfloop>
                <!--- Insercao de Custos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
                    v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
                    v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
                    v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
                    v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_custo_crt(	conhecimento_id = retorno.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
                    </cfscript>
                </cfloop>
                <!--- Insercao de anexos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                        this.ins_anexo_crt(	conhecimento_id = retorno.conhecimento_id,
                                            descricao = v_descricao[count]);
                    </cfscript>
                </cfloop>	
                    
                <!--- Alteraes dos Complementados --->
                <cfscript>
                    v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
                    v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
                    v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
                                                            conhecimento_id_complemento   = l_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
    
                <!--- Insercao de FRONTEIRAS --->
                <cfscript>
                    v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_fronteira_id)#" index="count">
                    <cfscript>
                        this.ins_crt_fronteira(	conhecimento_id = retorno.conhecimento_id,
                                                fronteira_id	= v_fronteira_id[count]);
                    </cfscript>
                </cfloop>	            

                <!---Diviso--->
                <cfscript>
					v_divisao_controle_id = this.ListaToArray(lista = arguments, variavel = "DIVISAO_CONTROLE_ID_DIVISAO");
					v_num_embarque        = this.ListaToArray(lista = arguments, variavel = "NUM_EMBARQUE_DIVISAO");
					v_divisao_embarque_id = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_ID_DIVISAO");
					v_divisao_id          = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ID_DIVISAO");
					v_embarque_data       = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_DATA_DIVISAO");
					v_placa_controle      = this.ListaToArray(lista = arguments, variavel = "PLACA_CONTROLE_DIVISAO");
					v_placa_referencia_composicao = this.ListaToArray(lista = arguments, variavel = "PLACA_REFERENCIA_COMPOSICAO_DIVISAO");
					v_divisao_cod_motorista       = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOTORISTA_DIVISAO");
					v_divisao_motorista           = this.ListaToArray(lista = arguments, variavel = "DIVISAO_MOTORISTA_DIVISAO");
					v_divisao_cod_pessoa_motorista = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_PESSOA_MOTORISTA_DIVISAO");
					v_divisao_rota_abreviatura     = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ABREVIATURA_DIVISAO");
					v_divisao_rota_id    = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ID_DIVISAO");
					v_divisao_km         = this.ListaToArray(lista = arguments, variavel = "DIVISAO_KM_DIVISAO");
					v_divisao_percentual = this.ListaToArray(lista = arguments, variavel = "DIVISAO_PERCENTUAL_DIVISAO");
					v_divisao_cod_moeda  = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOEDA_DIVISAO");
					v_divisao_valor      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_VALOR_DIVISAO");
					v_divisao_data      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_DATA_DIVISAO");
                    v_embarque_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_embarque_id));
					v_divisao_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_id));
                 </cfscript>
		
                <!--- Excluir os itens --->
                <!---<cfloop list="#v_embarque_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_embarque = this.del_intc_crt_embarque(embarque_id = l_item_id);
                    </cfscript>

					<cfif set_embarque.erro>
                        <cfthrow object="#set_embarque.MENSAGEM#"/>
                    </cfif>    
                </cfloop>---> 
                
                <cfloop list="#v_divisao_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_divisao = this.del_embarque_divisao(divisao_id = l_item_id);
                    </cfscript>

					<cfif set_divisao.erro>
                        <cfthrow object="#set_divisao.MENSAGEM#"/>
                    </cfif>    
                </cfloop>            
				
				<cfset v_embarque = 0>
				<cfset v_embarque_id = 0>
                <cfloop from="1" to="#ArrayLen(v_num_embarque)#" index="count">
                     <cfscript>
					 	if (v_embarque neq v_num_embarque[count])  {
							// Registra embarque
							v_embarque = v_num_embarque[count];
							
							if(not len(trim(v_divisao_embarque_id[count]))) {
								//caso o item_id seja nulo insere
								set_embarque = this.ins_intc_crt_embarque( conhecimento_id = retorno.conhecimento_id,
																		  data_embarque = v_embarque_data[count]);
								
								v_embarque_id = set_embarque.embarque_id;
							} else {
								//senao altera
								set_embarque = this.upd_intc_crt_embarque( conhecimento_id = retorno.conhecimento_id,
																		  embarque_id     = v_divisao_embarque_id[count],
																		  data_embarque   = v_embarque_data[count]);
								v_embarque_id = v_divisao_embarque_id[count];
							}
						}
                     </cfscript>

                     <cfif IsDefined("set_embarque") and set_embarque.erro>
                     	<cfthrow object="#set_embarque.Mensagem#">
                     </cfif>
                     
					<cfscript>
					 	if(not len(trim(v_divisao_id[count]))) {
					 		//caso o item_id seja nulo insere
							set_divisao = this.ins_embarque_divisao( valor                = v_divisao_valor[count]
																	,cod_moeda            = v_divisao_cod_moeda[count] 
																	,percentual_crt       = v_divisao_percentual[count] 
																	,rota_id              = v_divisao_rota_id[count] 
																	,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
																	,embarque_id          = v_embarque_id
																	,data_divisao 		  = v_divisao_data[count] 
																   );
							
							if (not set_divisao.erro) {
							   v_divisao_id[count] = set_divisao.divisao_id;
							}
						} 
// AGORA DEVE-SE EXCLUIR E DEPOIS INSERIR PARA EDITAR						
//                      else {
//							//senao altera
//							set_divisao = this.upd_embarque_divisao( divisao_id			  = v_divisao_id[count]
//																	,valor                = v_divisao_valor[count]
//																	,cod_moeda            = v_divisao_cod_moeda[count] 
//																	,percentual_crt       = v_divisao_percentual[count] 
//																	,rota_id              = v_divisao_rota_id[count] 
//																	,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
//																	,embarque_id          = v_embarque_id
//																   );
//						}
                     </cfscript>            
                              
                     <cfif isDefined("set_divisao") and  set_divisao.erro>
                     	<cfthrow object="#set_divisao.Mensagem#">
                     </cfif>

					<!---Exclui composicao--->
					<cfscript>
						set_divisao_comp = this.del_embarque_divisao_comp(divisao_id = v_divisao_id[count]);
					</cfscript>
                    <cfif set_divisao_comp.erro>
                    	<cfthrow object="#set_divisao_comp.Mensagem#">
                    </cfif>
                    
                    <!---Insere todas as composies--->
                    <cfscript>	
					    // Insere cavalo
						if(len(trim(v_placa_controle[count]))) {
						set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = 0
																		  ,placa                = v_placa_controle[count]
																		  ,divisao_id           = v_divisao_id[count] 
																		 );
						}
                     </cfscript>            
                              
                     <cfif set_divisao_comp.erro>
                     	<cfthrow object="#set_divisao_comp.Mensagem#">
                     </cfif>

                     <cfset v_ordem = 1>
                     <cfloop list="#v_placa_referencia_composicao[count]#" index="l_placa" delimiters=",">
							<cfscript>	
                                // Insere cavalo
								if(len(trim(v_placa_controle[count]))) {
                                set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = v_ordem
                                                                                  ,placa                = l_placa
                                                                                  ,divisao_id           = v_divisao_id[count] 
                                                                                 );
								}
                             </cfscript>            
		                     <cfset v_ordem = v_ordem + 1>

							 <cfif set_divisao_comp.erro>
                                <cfthrow object="#set_divisao_comp.Mensagem#">
                             </cfif>
                     </cfloop>
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
                    <cfscript>
                        ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
                                                                    conhecimento_id_complemento = v_conhecimento_id_complemento[count],
                                                            tipo_id = v_tipo_id_complemento[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>	
               
               	<!--- Gera conhecimento FORM --->
                <cfscript>
					set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = retorno.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
				</cfscript>                
                
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1 and ArrayLen(v_conhecimento_id_complemento) eq 0>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                <!--- /// --->
				
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("C.R.T. inserido com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />		
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um conhecimento internacional
    -- 06/12/2005 - criado
    --->
    <cffunction name="upd_intc_conhecimento" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
        <cfargument name="CONHECIMENTO_ID" required="yes">
        <cfargument name="NUMERO" required="yes">
        <cfargument name="COD_PESSOA_FILIAL" required="yes">
        <cfargument name="COD_ORGANOGRAMA" required="yes">
        <cfargument name="EMISSAO_LOCAL" required="yes">
        <cfargument name="EMISSAO_MUNICIPIO_ID" required="yes">
        <cfargument name="RESP_LOCAL" required="yes">
        <cfargument name="RESP_MUNICIPIO_ID" required="yes">
        <cfargument name="RESP_DATA" required="yes">
        <cfargument name="ENTREGA_LOCAL" required="yes">
        <cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
        <cfargument name="ENTREGA_DATA" required="yes">
        <cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
        <cfargument name="COD_REMETENTE" required="yes">
        <cfargument name="REM_NOME" required="yes">
        <cfargument name="REM_ENDERECO" required="yes">
        <cfargument name="REM_MUNICIPIO" required="yes">
        <cfargument name="REM_UF" required="yes">
        <cfargument name="REM_PAIS" required="yes">
        <cfargument name="REM_CNPJ_CPF" required="yes">
        <cfargument name="COD_DESTINATARIO" required="yes">
        <cfargument name="DEST_NOME" required="yes">
        <cfargument name="DEST_ENDERECO" required="yes">
        <cfargument name="DEST_MUNICIPIO" required="yes">
        <cfargument name="DEST_UF" required="yes">
        <cfargument name="DEST_PAIS" required="yes">
        <cfargument name="DEST_CNPJ_CPF" required="yes">
        <cfargument name="COD_CONSIGNATARIO" required="yes">
        <cfargument name="CONS_NOME" required="yes">
        <cfargument name="CONS_ENDERECO" required="yes">
        <cfargument name="CONS_MUNICIPIO" required="yes">
        <cfargument name="CONS_UF" required="yes">
        <cfargument name="CONS_PAIS" required="yes">
        <cfargument name="CONS_CNPJ_CPF" required="yes">
        <cfargument name="COD_NOTIFICAR" required="yes">
        <cfargument name="NOT_NOME" required="yes">
        <cfargument name="NOT_ENDERECO" required="yes">
        <cfargument name="NOT_MUNICIPIO" required="yes">
        <cfargument name="NOT_UF" required="yes">
        <cfargument name="NOT_PAIS" required="yes">
        <cfargument name="NOT_CNPJ_CPF" required="yes">
        <cfargument name="MERCADORIAS" required="no" default="">
        <cfargument name="NUM_ESPECIE" required="yes">
        <cfargument name="QUANTIDADE_TOTAL" required="yes">
        <cfargument name="PESO_BRUTO" required="yes">
        <cfargument name="PESO_LIQUIDO" required="yes">
        <cfargument name="UNIDADE_ID" required="yes">
        <cfargument name="M3" required="yes">
        <cfargument name="VALOR_TOTAL" required="yes">
        <cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
        <cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
        
        <cfargument name="TOTAL_CUSTO_ORIGEM" required="yes">
        <cfargument name="TOTAL_CUSTO_ORIGEM_COD_MOEDA" required="yes">
        <cfargument name="TOTAL_CUSTO_DESTINO" required="yes">
        <cfargument name="TOTAL_CUSTO_DESTINO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_FRT_EXTERNO" required="yes">
        <cfargument name="VALOR_FRT_EXTERNO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_REEMBOLSO" required="yes">
        <cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
        <cfargument name="VALOR_MERCADORIAS" required="yes">
        <cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
        <cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
        <cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
        <cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
        <cfargument name="PAGO_POR" required="yes">
        <cfargument name="DECLARACAO_OBSERVACAO" required="yes">
        <cfargument name="OBS_PAGO_POR" required="no">
        <cfargument name="ADICIONAIS_MERCADORIA" required="yes">
        <cfargument name="pais_id_origem" required="yes">
    
        <cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
        <cfargument name="QTDE_VEICULOS" required="no" default="1" >
        <cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
        <cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
    
        <cfargument name='COD_PAGADOR_ORIGEM' required='yes'>
        <cfargument name='PAG_ORIGEM_NOME' required='yes'>
        <cfargument name='PAG_ORIGEM_ENDERECO' required='yes'>
        <cfargument name='PAG_ORIGEM_CIDADE' required='yes'>
        <cfargument name='PAG_ORIGEM_UF' required='yes'>
        <cfargument name='PAG_ORIGEM_PAIS' required='yes'>
        <cfargument name='PAG_ORIGEM_CNPJ_CPF' required='yes'>
        <cfargument name='COD_PAGADOR_DESTINO' required='yes'>
        <cfargument name='PAG_DESTINO_NOME' required='yes'>
        <cfargument name='PAG_DESTINO_ENDERECO' required='yes'>
        <cfargument name='PAG_DESTINO_CIDADE' required='yes'>
        <cfargument name='PAG_DESTINO_UF' required='yes'>
        <cfargument name='PAG_DESTINO_PAIS' required='yes'>
        <cfargument name='PAG_DESTINO_CNPJ_CPF' required='yes'>    
        <cfargument name='PRE_CONHECIMENTO' required='yes' default="0"> 
        <cfargument name='COTACAO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">
        <cfargument name='PRAZO_ENTREGA' required='yes'>
        <cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
        <cfargument name='COD_NEGOCIADOR' required='yes'>  
        <cfargument name='NF_FATURA' required='yes'>
        <cfargument name='OPERACAO_ID_CRT' required='no' default="">
        <cfargument name='CRT_COD_PAIS' required='no' default="">
        <cfargument name='CRT_NUM_PERMISSO' required='no' default="">
        <cfargument name='CRT_NUMERO' required='no' default="">
        <cfargument name='CRT_SERIE' required='no' default="">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
        <cftry>
            <cfscript>
                v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                v_mercadorias = "";
            </cfscript>
            <cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
                <cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
            </cfloop>
            <cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
            <cftransaction action="begin">
                <cfstoredproc procedure="fiscal.pkg_transp_internacional.prc_alt_conhecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NUMERO_COD_PAIS" value="#UCase(arguments.CRT_COD_PAIS)#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NUMERO_CERTIFICADO" value="#arguments.CRT_NUM_PERMISSO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUMERO_SEQUENCIAL" value="#arguments.CRT_NUMERO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_PESSOA_FILIAL" value="#arguments.COD_PESSOA_FILIAL#" null="#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_COD_ORGANOGRAMA" value="#arguments.COD_ORGANOGRAMA#" null="#iif(len(trim(arguments.COD_ORGANOGRAMA)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_LOCAL" value="#arguments.EMISSAO_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_EMISSAO_MUNICIPIO_ID" value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA" value="#arguments.EMISSAO_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_LOCAL" value="#arguments.RESP_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RESP_MUNICIPIO_ID" value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_DATA" value="#arguments.RESP_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_LOCAL" value="#arguments.ENTREGA_LOCAL#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ENTREGA_MUNICIPIO_ID" value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_DATA" value="#arguments.ENTREGA_DATA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_TRANSP_SUCESSIVOS" value="#arguments.TRANSP_SUCESSIVOS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_REMETENTE" value="#arguments.COD_REMETENTE#" null="#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_NOME" value="#arguments.REM_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_ENDERECO" value="#arguments.REM_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_MUNICIPIO_ID" value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CIDADE" value="#arguments.REM_MUNICIPIO#">
                    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_UF" value="#arguments.REM_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_PAIS" value="#arguments.REM_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CNPJ_CPF" value="#arguments.REM_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_DESTINATARIO" value="#arguments.COD_DESTINATARIO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_NOME" value="#arguments.DEST_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_ENDERECO" value="#arguments.DEST_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_MUNICIPIO_ID" value="#arguments.DEST_MUNICIPIO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CIDADE" value="#arguments.DEST_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_UF" value="#arguments.DEST_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_PAIS" value="#arguments.DEST_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CNPJ_CPF" value="#arguments.DEST_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_CONSIGNATARIO" value="#arguments.COD_CONSIGNATARIO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_NOME" value="#arguments.CONS_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_ENDERECO" value="#arguments.CONS_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_MUNICIPIO_ID" value="#arguments.CONS_MUNICIPIO_ID#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CIDADE" value="#arguments.CONS_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_UF" value="#arguments.CONS_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_PAIS" value="#arguments.CONS_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CNPJ_CPF" value="#arguments.CONS_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_COD_NOTIFICAR" value="#arguments.COD_NOTIFICAR#" null="#iif(len(trim(arguments.COD_NOTIFICAR)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_NOME" value="#arguments.NOT_NOME#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_ENDERECO" value="#arguments.NOT_ENDERECO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_MUNICIPIO_ID" value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CIDADE" value="#arguments.NOT_MUNICIPIO#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_UF" value="#arguments.NOT_UF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_PAIS" value="#arguments.NOT_PAIS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CNPJ_CPF" value="#arguments.NOT_CNPJ_CPF#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MERCADORIAS" value="#v_MERCADORIAS#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
                    <cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_origem#" null="#iif(len(trim(arguments.total_custo_origem)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_ORIGEM_COD_MOEDA" type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_origem_cod_moeda#" null="#iif(len(trim(arguments.total_custo_origem_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.total_custo_destino#" null="#iif(len(trim(arguments.total_custo_destino)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_TOTAL_CUSTO_DESTINO_COD_MOED" type="in"  cfsqltype="cf_sql_integer" value="#arguments.total_custo_destino_cod_moeda#" null="#iif(len(trim(arguments.total_custo_destino_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_FRT_EXTERNO" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_frt_externo#" null="#iif(len(trim(arguments.valor_frt_externo)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_FRT_EXTERNO_COD_MOEDA"	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_frt_externo_cod_moeda#" null="#iif(len(trim(arguments.valor_frt_externo_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
                
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_INCOTERM" value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_ORIGEM_ID" value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_DESTINO_ID" value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
    
                    <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_PAGO_POR" value="#arguments.PAGO_POR#"  null="#iif(len(trim(arguments.PAGO_POR)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DECLARACAO_OBSERVACAO" value="#arguments.DECLARACAO_OBSERVACAO#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_OBS_PAGO_POR" value="#arguments.OBS_PAGO_POR#">
                    <cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
                    <cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA_IMPRESSAO" value="#arguments.EMISSAO_DATA_IMPRESSAO#">
                    <cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_ORIGEM'  value='#arguments.COD_PAGADOR_ORIGEM#'  null='#iif(len(trim(arguments.COD_PAGADOR_ORIGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_NOME'  value='#arguments.PAG_ORIGEM_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_ENDERECO'  value='#arguments.PAG_ORIGEM_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CIDADE'  value='#arguments.PAG_ORIGEM_CIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_UF'  value='#arguments.PAG_ORIGEM_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_PAIS'  value='#arguments.PAG_ORIGEM_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_ORIGEM_CNPJ_CPF'  value='#arguments.PAG_ORIGEM_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PAGADOR_DESTINO'  value='#arguments.COD_PAGADOR_DESTINO#'  null='#iif(len(trim(arguments.COD_PAGADOR_DESTINO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_NOME'  value='#arguments.PAG_DESTINO_NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_ENDERECO'  value='#arguments.PAG_DESTINO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CIDADE'  value='#arguments.PAG_DESTINO_CIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_UF'  value='#arguments.PAG_DESTINO_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_PAIS'  value='#arguments.PAG_DESTINO_PAIS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PAG_DESTINO_CNPJ_CPF'  value='#arguments.PAG_DESTINO_CNPJ_CPF#' >
                    <cfprocparam dbvarname="P_PRE_CONHECIMENTO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.PRE_CONHECIMENTO#" null="#iif(len(trim(arguments.PRE_CONHECIMENTO)), de('no'), de('yes'))#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COTACAO' value='#arguments.COTACAO#' null='#iif(len(trim(arguments.COTACAO)), de('no'), de('yes'))#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PRAZO_ENTREGA" value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NF_FATURA'  value='#arguments.NF_FATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OPERACAO_ID_CRT'  value='#arguments.OPERACAO_ID_CRT#'  null='#iif(len(trim(arguments.OPERACAO_ID_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERIE'  value='#arguments.CRT_SERIE#'  null='#iif(len(trim(arguments.CRT_SERIE)), de('no'), de('yes'))#'>
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PEDIDO_SHIPMENT" value="#arguments.pedido_shipment#" >
                </cfstoredproc>
                
                <cfset retorno.conhecimento_id = arguments.conhecimento_id>
                
                <!--- Alteraes das Mercadorias --->
                <cfscript>
                    v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
                    v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
                    v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
                    v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
                    v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
                    v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
                    v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
                    v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
                                            item_id   = l_item_id);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                    if(not len(trim(v_item_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
                                            produto_id = v_produto_id[count],
                                            num_especie = v_num_especie[count],
                                            quantidade = v_quantidade[count],
                                            peso_bruto = v_peso_bruto[count],
                                            peso_liquido = v_peso_liquido[count],
                                            m3 = v_m3[count],
                                            descricao = v_descricao[count]);
                    } else {
                        //senao altera
                        this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
                                            produto_id = v_produto_id[count],
                                            num_especie = v_num_especie[count],
                                            quantidade = v_quantidade[count],
                                            peso_bruto = v_peso_bruto[count],
                                            peso_liquido = v_peso_liquido[count],
                                            m3 = v_m3[count],
                                            descricao = v_descricao[count],
                                            item_id = v_item_id[count]);
                    }
                    </cfscript>
                </cfloop>			
                <!--- Alteraes dos custos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "CUST_DESCRICAO_CUSTOS");
                    v_valor_origem = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_CUSTOS");
                    v_valor_origem_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_ORIGEM_COD_MOEDA_CUSTOS");
                    v_valor_destino = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_CUSTOS");
                    v_valor_destino_cod_moeda = this.ListaToArray (lista = arguments, variavel = "CUST_VALOR_DESTINO_COD_MOEDA_CUSTOS");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "CUST_ITEM_ID_CUSTOS");
                    v_cust_excluir = this.ListDiff(lista1 = arguments.lista_deleted_CUSTOS, lista2 = ArrayToList(v_item_id));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_cust_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_custo_crt (conhecimento_id = arguments.conhecimento_id,
                                            item_id   = l_item_id);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                    if(not len(trim(v_item_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_custo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count]);
                    } else {
                        //senao altera
                        this.upd_custo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            valor_origem = v_valor_origem[count],
                                            valor_origem_cod_moeda = v_valor_origem_cod_moeda[count],
                                            valor_destino = v_valor_destino[count],
                                            valor_destino_cod_moeda = v_valor_destino_cod_moeda[count],
                                            item_id = v_item_id[count]);
                    }
                    </cfscript>
                </cfloop>				
                <!--- Alteraes dos Anexos --->
                <cfscript>
                    v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
                    v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
                    v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
                                            anexo_id   = l_item_id);
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
                    <cfscript>
                    if(not len(trim(v_item_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count]);
                    } else {
                        //senao altera
                        this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
                                            descricao = v_descricao[count],
                                            anexo_id = v_item_id[count]);
                    }
                    </cfscript>
                </cfloop>			
                
                <!--- Alteraes dos Complementados --->
                <cfscript>
                    retorno.conhecimento_id = arguments.conhecimento_id;
                    v_tipo_id_complemento = this.ListaToArray (lista = arguments, variavel = "TIPO_COMPLEMENTO_COMPLEMENTO");
                    v_conhecimento_id_complemento = this.ListaToArray (lista = arguments, variavel = "CONHECIMENTO_COMPLEMENTO_ID_COMPLEMENTO");
                    v_numero_compl = this.ListaToArray (lista = arguments, variavel = "CRT_COMPLEMENTO_COMPLEMENTO");
                    v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_COMPLEMENTO, lista2 = ArrayToList(v_conhecimento_id_complemento));
                </cfscript>
                    <!--- Excluir os itens --->
                <cfloop list="#v_excluir#" delimiters="," index="l_id">
                    <cfscript>
                        ret = this.del_conhecimento_complemento (conhecimento_id = retorno.conhecimento_id,
                                                            conhecimento_id_complemento   = l_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_conhecimento_id_complemento)#" index="count">
                    <cfscript>
                        ret = this.ins_conhecimento_complemento(	conhecimento_id = retorno.conhecimento_id,
                                                                    conhecimento_id_complemento = v_conhecimento_id_complemento[count],
                                                            tipo_id = v_tipo_id_complemento[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>	
                
                <!--- Insercao de FRONTEIRAS --->
                <cfscript>
                    v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
                    v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
                    v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_controle_id));
                </cfscript>
                <!--- Excluir os itens --->
                <cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        this.del_crt_fronteira (controle_id = l_item_id);						
                    </cfscript>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                    <cfscript>
                    if(not len(trim(v_controle_id[count]))) {
                        //caso o item_id seja nulo insere
                        this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
                                                fronteira_id = v_fronteira_id[count]);
                    } else {
                        //senao altera
                        this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
                                                fronteira_id    = v_fronteira_id[count],
                                                controle_id     = v_controle_id[count]);
                    }
                    </cfscript>
                </cfloop>		
                
                <!---Diviso--->
                <cfscript>
					v_divisao_controle_id = this.ListaToArray(lista = arguments, variavel = "DIVISAO_CONTROLE_ID_DIVISAO");
					v_num_embarque        = this.ListaToArray(lista = arguments, variavel = "NUM_EMBARQUE_DIVISAO");
					v_divisao_embarque_id = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_ID_DIVISAO");
					v_divisao_id          = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ID_DIVISAO");
					v_embarque_data       = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_DATA_DIVISAO");
					v_placa_controle      = this.ListaToArray(lista = arguments, variavel = "PLACA_CONTROLE_DIVISAO");
					v_placa_referencia_composicao = this.ListaToArray(lista = arguments, variavel = "PLACA_REFERENCIA_COMPOSICAO_DIVISAO");
					v_divisao_cod_motorista       = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOTORISTA_DIVISAO");
					v_divisao_motorista           = this.ListaToArray(lista = arguments, variavel = "DIVISAO_MOTORISTA_DIVISAO");
					v_divisao_cod_pessoa_motorista = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_PESSOA_MOTORISTA_DIVISAO");
					v_divisao_rota_abreviatura     = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ABREVIATURA_DIVISAO");
					v_divisao_rota_id    = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ID_DIVISAO");
					v_divisao_km         = this.ListaToArray(lista = arguments, variavel = "DIVISAO_KM_DIVISAO");
					v_divisao_percentual = this.ListaToArray(lista = arguments, variavel = "DIVISAO_PERCENTUAL_DIVISAO");
					v_divisao_cod_moeda  = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOEDA_DIVISAO");
					v_divisao_valor      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_VALOR_DIVISAO");
					v_divisao_data      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_DATA_DIVISAO");
                    v_embarque_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_embarque_id));
					v_divisao_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_id));
                 </cfscript>
				
                <!--- Excluir os itens --->
                <!---<cfloop list="#v_embarque_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_embarque = this.del_intc_crt_embarque(embarque_id = l_item_id);
                    </cfscript>

					<cfif set_embarque.erro>
                        <cfthrow object="#set_embarque.MENSAGEM#"/>
                    </cfif>    
                </cfloop>--->
                <!--- Excluir os itens --->
                <cfloop list="#v_divisao_excluir#" delimiters="," index="l_item_id">
                <cfdump var="#l_item_id#">
                    <cfscript>
                        set_divisao = this.del_embarque_divisao(divisao_id = l_item_id);
                    </cfscript>

					<cfif set_divisao.erro>
                        <cfthrow object="#set_divisao.MENSAGEM#"/>
                    </cfif>    
                </cfloop>             
				
				<cfset v_embarque = 0>
				<cfset v_embarque_id = 0>
                <cfloop from="1" to="#ArrayLen(v_num_embarque)#" index="count">
                     <cfscript>
					 	if (v_embarque neq v_num_embarque[count])  {
							// Registra embarque
							v_embarque = v_num_embarque[count];
							
							if(not len(trim(v_divisao_embarque_id[count]))) {
								//caso o item_id seja nulo insere
								set_embarque = this.ins_intc_crt_embarque( conhecimento_id = arguments.conhecimento_id,
																		  data_embarque    = v_embarque_data[count]);
								
								v_embarque_id = set_embarque.embarque_id;
							}else{
								v_embarque_id = v_divisao_embarque_id[count];
							}
						}
                     </cfscript>

                     <cfif IsDefined("set_embarque") and set_embarque.erro>
                     	<cfthrow object="#set_embarque.Mensagem#">
                     </cfif>
                     
					<cfscript>
					 	if(not len(trim(v_divisao_id[count]))) {
					 		//caso o item_id seja nulo insere
							set_divisao = this.ins_embarque_divisao( valor                = v_divisao_valor[count]
																	,cod_moeda            = v_divisao_cod_moeda[count] 
																	,percentual_crt       = v_divisao_percentual[count] 
																	,rota_id              = v_divisao_rota_id[count] 
																	,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
																	,embarque_id          = v_embarque_id
																	,data_divisao 		  = v_divisao_data[count] 
																   );
							
							if (not set_divisao.erro) {							
								v_divisao_id[count] = set_divisao.divisao_id;
							}
						} 
// agora tem que excluir e inserir novamente						
//						  else {
//							//senao altera
//							set_divisao = this.upd_embarque_divisao( divisao_id			  = v_divisao_id[count]
//																	,valor                = v_divisao_valor[count]
//																	,cod_moeda            = v_divisao_cod_moeda[count] 
//																	,percentual_crt       = v_divisao_percentual[count] 
//																	,rota_id              = v_divisao_rota_id[count] 
//																	,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
//																	,embarque_id          = v_embarque_id
//																   );
//						}
                     </cfscript>            
                              
                     <cfif isDefined("set_divisao") and  set_divisao.erro>
                     	<cfthrow object="#set_divisao.Mensagem#">
                     </cfif>

					<!---Exclui composicao--->
					<cfscript>
						set_divisao_comp = this.del_embarque_divisao_comp(divisao_id = v_divisao_id[count]);
					</cfscript>
                    <cfif set_divisao_comp.erro>
                    	<cfthrow object="#set_divisao_comp.Mensagem#">
                    </cfif>
                    
                    <!---Insere todas as composies--->
                    <cfscript>	
					    // Insere cavalo
						if(len(trim(v_placa_controle[count]))) {
						set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = 0
																		  ,placa                = v_placa_controle[count]
																		  ,divisao_id           = v_divisao_id[count] 
																		 );
						}
                     </cfscript>            
                              
                     <cfif set_divisao_comp.erro>
                     	<cfthrow object="#set_divisao_comp.Mensagem#">
                     </cfif>

                     <cfset v_ordem = 1>
                     <cfloop list="#v_placa_referencia_composicao[count]#" index="l_placa" delimiters=",">
							<cfscript>	
                                // Insere cavalo
								if(len(trim(v_placa_controle[count]))) {
                                set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = v_ordem
                                                                                  ,placa                = l_placa
                                                                                  ,divisao_id           = v_divisao_id[count] 
                                                                                 );
								}
                             </cfscript>            
		                     <cfset v_ordem = v_ordem + 1>

							 <cfif set_divisao_comp.erro>
                                <cfthrow object="#set_divisao_comp.Mensagem#">
                             </cfif>
                     </cfloop>
                </cfloop>
               
                <!--- Gera conhecimento FORM --->
                <cfscript>
					if(arguments.regerar_impressao eq 1) {
                		set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
					}
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = arguments.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
				
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
				</cfscript>                
                
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                
                <cfscript>
					ret_valid_tf = this.valida_crt_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_valid_tf.erro>
					<cfthrow object="#ret_valid_tf.mensagem#">
				</cfif>
                <!--- /// --->
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
            </cftransaction>
            <cfcatch>
                <cftransaction action="rollback"/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um conhecimento internacional
	-- Rafael Costa 05/06/2009 - alterado
	--->
	<cffunction name="upd_intc_conhecimento_lib_fatura" displayname="Altera um conhecimento internacional" access="remote" returntype="Struct" output="true">
		<cfargument name="CONHECIMENTO_ID" required="yes">
		<cfargument name="RESP_LOCAL" required="yes">
		<cfargument name="RESP_MUNICIPIO_ID" required="yes">
		<cfargument name="RESP_DATA" required="yes">
		<cfargument name="ENTREGA_LOCAL" required="yes">
		<cfargument name="ENTREGA_MUNICIPIO_ID" required="yes">
		<cfargument name="ENTREGA_DATA" required="yes">
		<cfargument name="TRANSP_SUCESSIVOS" required="no" default="N.I.H.I.L">
		<cfargument name="REM_ENDERECO" required="yes">
		<cfargument name="REM_MUNICIPIO" required="yes">
		<cfargument name="REM_UF" required="yes">
		<cfargument name="REM_PAIS" required="yes">
		<cfargument name="DEST_ENDERECO" required="yes">
		<cfargument name="DEST_MUNICIPIO" required="yes">
		<cfargument name="DEST_UF" required="yes">
		<cfargument name="DEST_PAIS" required="yes">
		<cfargument name="CONS_ENDERECO" required="yes">
		<cfargument name="CONS_MUNICIPIO" required="yes">
		<cfargument name="CONS_UF" required="yes">
		<cfargument name="CONS_PAIS" required="yes">
		<cfargument name="NOT_ENDERECO" required="yes">
		<cfargument name="NOT_MUNICIPIO" required="yes">
		<cfargument name="NOT_UF" required="yes">
		<cfargument name="NOT_PAIS" required="yes">
		<cfargument name="MERCADORIAS" required="no" default="">
		<cfargument name="NUM_ESPECIE" required="yes">
		<cfargument name="QUANTIDADE_TOTAL" required="yes">
		<cfargument name="PESO_BRUTO" required="yes">
		<cfargument name="PESO_LIQUIDO" required="yes">
		<cfargument name="UNIDADE_ID" required="yes">
		<cfargument name="M3" required="yes">
		<cfargument name="VALOR_TOTAL" required="yes">
		<cfargument name="VALOR_TOTAL_COD_MOEDA" required="yes">
		<cfargument name="VALOR_TOTAL_INCOTERM_ID" required="yes">
		
		<cfargument name="VALOR_REEMBOLSO" required="yes">
		<cfargument name="VALOR_REEMBOLSO_COD_MOEDA" required="yes">
		<cfargument name="VALOR_MERCADORIAS" required="yes">
		<cfargument name="VALOR_MERCADORIAS_COD_MOEDA" required="yes">
		<cfargument name="VALOR_MERCADORIAS_INCOTERM" required="yes">
		<cfargument name="ALFANDEGA_ORIGEM_ID" required="yes">
		<cfargument name="ALFANDEGA_DESTINO_ID" required="yes">
		<cfargument name="DECLARACAO_OBSERVACAO" required="yes">
		<cfargument name="ADICIONAIS_MERCADORIA" required="yes">
		<cfargument name="pais_id_origem" required="yes">
	
		<cfargument name="SEGURO_PAGO_EMPRESA" required="no" default="0" >
		<cfargument name="QTDE_VEICULOS" required="no" default="1" >
		<cfargument name="EMISSAO_DATA_IMPRESSAO" required="no" default="" >
		<cfargument name="EMISSAO_DATA" required="yes" >
		<cfargument name="TAXA_MERCADORIA_SEGURO" required="no" default="0" >
		
		<cfargument name='ORGANIZACIONAL_ID_GERENCIAL' required='no' default="">
		<cfargument name='PRAZO_ENTREGA' required='yes'> 
		<cfargument name="REGERAR_IMPRESSAO" required="no" default="0">
        <cfargument name='PEDIDO_SHIPMENT' required='no' default="">
		<cftry>
			<cfscript>
				v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
				v_mercadorias = "";
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_descricao)#" index="v_index">
				<cfset v_mercadorias = v_mercadorias&v_descricao[v_index]&chr(10)>			
			</cfloop>
			<cfset v_mercadorias = v_mercadorias&arguments.adicionais_mercadoria>				
			<cftransaction action="begin">
				<cfstoredproc procedure="fiscal.pkg_transp_internacional.PRC_ALT_CRT_LIB_FATURA" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONHECIMENTO_ID" value="#arguments.CONHECIMENTO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA" value="#arguments.EMISSAO_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_LOCAL" value="#arguments.EMISSAO_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_EMISSAO_MUNICIPIO_ID" value="#arguments.EMISSAO_MUNICIPIO_ID#" null="#iif(len(trim(arguments.EMISSAO_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_LOCAL" value="#arguments.RESP_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_RESP_MUNICIPIO_ID" value="#arguments.RESP_MUNICIPIO_ID#" null="#iif(len(trim(arguments.RESP_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_RESP_DATA" value="#arguments.RESP_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_LOCAL" value="#arguments.ENTREGA_LOCAL#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ENTREGA_MUNICIPIO_ID" value="#arguments.ENTREGA_MUNICIPIO_ID#" null="#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_ENTREGA_DATA" value="#arguments.ENTREGA_DATA#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_TRANSP_SUCESSIVOS" value="#arguments.TRANSP_SUCESSIVOS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_ENDERECO" value="#arguments.REM_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_MUNICIPIO_ID" value="#arguments.REM_MUNICIPIO_ID#" null="#iif(len(trim(arguments.rem_municipio_id)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_CIDADE" value="#arguments.REM_MUNICIPIO#">
					
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_UF" value="#arguments.REM_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_REM_PAIS" value="#arguments.REM_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_ENDERECO" value="#arguments.DEST_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_MUNICIPIO_ID" value="#arguments.DEST_MUNICIPIO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_CIDADE" value="#arguments.DEST_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_UF" value="#arguments.DEST_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DEST_PAIS" value="#arguments.DEST_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_ENDERECO" value="#arguments.CONS_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_MUNICIPIO_ID" value="#arguments.CONS_MUNICIPIO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_CIDADE" value="#arguments.CONS_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_UF" value="#arguments.CONS_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_CONS_PAIS" value="#arguments.CONS_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_ENDERECO" value="#arguments.NOT_ENDERECO#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_MUNICIPIO_ID" value="#arguments.NOT_MUNICIPIO_ID#" null="#iif(len(trim(arguments.NOT_MUNICIPIO_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_CIDADE" value="#arguments.NOT_MUNICIPIO#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_UF" value="#arguments.NOT_UF#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_NOT_PAIS" value="#arguments.NOT_PAIS#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MERCADORIAS" value="#v_MERCADORIAS#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_NUM_ESPECIE" value="#arguments.NUM_ESPECIE#"  null="#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_QUANTIDADE_TOTAL" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.quantidade_total#" null="#iif(len(trim(arguments.quantidade_total)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_PESO_BRUTO" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_bruto#" null="#iif(len(trim(arguments.peso_bruto)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_PESO_LIQUIDO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.peso_liquido#" null="#iif(len(trim(arguments.peso_liquido)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_UNIDADE_ID" 					type="in"  cfsqltype="cf_sql_varchar" value="#arguments.unidade_id#">
					<cfprocparam dbvarname="P_M3" 							type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.m3#" null="#iif(len(trim(arguments.m3)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_VALOR_TOTAL" 					type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_total#" null="#iif(len(trim(arguments.valor_total)), de('no'), de('yes'))#">


					<cfprocparam dbvarname="P_VALOR_TOTAL_COD_MOEDA"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_cod_moeda#" null="#iif(len(trim(arguments.valor_total_cod_moeda)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_VALOR_TOTAL_INCOTERM_ID"		type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_total_incoterm_id#" null="#iif(len(trim(arguments.valor_total_incoterm_id)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_VALOR_REEMBOLSO" 				type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_reembolso#"  null="#iif(len(trim(arguments.valor_reembolso)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_VALOR_REEMBOLSO_COD_MOEDA" 	type="in"  cfsqltype="cf_sql_integer" value="#arguments.valor_reembolso_cod_moeda#" null="#iif(len(trim(arguments.valor_reembolso_cod_moeda)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_VALOR_MERCADORIAS" 			type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_mercadorias#" null="#iif(len(trim(arguments.valor_mercadorias)), de('no'), de('yes'))#">
				
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_COD_MOEDA" value="#arguments.VALOR_MERCADORIAS_COD_MOEDA#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_COD_MOEDA)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_VALOR_MERCADORIAS_INCOTERM" value="#arguments.VALOR_MERCADORIAS_INCOTERM#" null="#iif(len(trim(arguments.VALOR_MERCADORIAS_INCOTERM)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_ORIGEM_ID" value="#arguments.ALFANDEGA_ORIGEM_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_ALFANDEGA_DESTINO_ID" value="#arguments.ALFANDEGA_DESTINO_ID#"  null="#iif(len(trim(arguments.ALFANDEGA_DESTINO_ID)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_PAIS_ID_ORIGEM" 				type="in"  cfsqltype="cf_sql_integer" value="#arguments.pais_id_origem#"  null="#iif(len(trim(arguments.pais_id_origem)), de('no'), de('yes'))#">
	
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_DECLARACAO_OBSERVACAO" value="#arguments.DECLARACAO_OBSERVACAO#">
					<cfprocparam dbvarname="P_QTDE_VEICULOS"				type="in"  cfsqltype="cf_sql_integer" value="#arguments.qtde_veiculos#" null="#iif(len(trim(arguments.qtde_veiculos)), de('no'), de('yes'))#">
					<cfprocparam dbvarname="P_SEGURO_PAGO_EMPRESA"			type="in"  cfsqltype="cf_sql_integer" value="#arguments.seguro_pago_empresa#" null="#iif(len(trim(arguments.seguro_pago_empresa)), de('no'), de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_EMISSAO_DATA_IMPRESSAO" value="#arguments.EMISSAO_DATA_IMPRESSAO#">
					<cfprocparam dbvarname="P_TAXA_MERCADORIA_SEGURO"		type="in"  cfsqltype="cf_sql_numeric" scale="5" value="#arguments.TAXA_MERCADORIA_SEGURO#" null="#iif(len(trim(arguments.TAXA_MERCADORIA_SEGURO)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORGANIZACIONAL_ID_GERENCIAL'  value='#arguments.ORGANIZACIONAL_ID_GERENCIAL#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_GERENCIAL)), de('no'), de('yes'))#'>
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PRAZO_ENTREGA" value="#arguments.PRAZO_ENTREGA#">
                    <cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_PEDIDO_SHIPMENT" value="#arguments.pedido_shipment#" >
				</cfstoredproc>
				
				<cfset retorno.conhecimento_id = arguments.conhecimento_id>
				
				<!--- Alteraes das Mercadorias --->
				<cfscript>
					v_produto_id = this.ListaToArray (lista = arguments, variavel = "MERC_PRODUTO_ID_MERCADORIAS");
					v_num_especie = this.ListaToArray (lista = arguments, variavel = "MERC_NUM_ESPECIE_MERCADORIAS");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "MERC_QUANTIDADE_MERCADORIAS");
					v_peso_bruto = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_BRUTO_MERCADORIAS");
					v_peso_liquido = this.ListaToArray (lista = arguments, variavel = "MERC_PESO_LIQUIDO_MERCADORIAS");
					v_m3 = this.ListaToArray (lista = arguments, variavel = "MERC_VOLUME_MERCADORIAS");
					v_unidade_id = this.ListaToArray (lista = arguments, variavel = "MERC_UNIDADE_ID_MERCADORIAS");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "MERC_DESCRICAO_MERCADORIAS");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "MERC_ITEM_ID_MERCADORIAS");
					v_merc_excluir = this.ListDiff(lista1 = arguments.lista_deleted_MERCADORIAS, lista2 = ArrayToList(v_item_id));
				</cfscript>
	
				<!--- Excluir os itens --->
				<cfloop list="#v_merc_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_item_crt (	conhecimento_id = arguments.conhecimento_id,
											item_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_item_crt(	conhecimento_id = arguments.conhecimento_id,
											produto_id = v_produto_id[count],
											num_especie = v_num_especie[count],
											quantidade = v_quantidade[count],
											peso_bruto = v_peso_bruto[count],
											peso_liquido = v_peso_liquido[count],
											m3 = v_m3[count],
											descricao = v_descricao[count]);
					} else {
						//senao altera
						this.upd_item_crt(	conhecimento_id = arguments.conhecimento_id,
											produto_id = v_produto_id[count],
											num_especie = v_num_especie[count],
											quantidade = v_quantidade[count],
											peso_bruto = v_peso_bruto[count],
											peso_liquido = v_peso_liquido[count],
											m3 = v_m3[count],
											descricao = v_descricao[count],
											item_id = v_item_id[count]);
					}
					</cfscript>
				</cfloop>			
	
				<!--- Alteraes dos Anexos --->
				<cfscript>
					v_descricao = this.ListaToArray (lista = arguments, variavel = "ANEXO_DESCRICAO_ANEXOS");
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ANEXO_ID_ANEXOS");
					v_anexos_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_anexos_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_anexo_crt (conhecimento_id = arguments.conhecimento_id,
											anexo_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
											descricao = v_descricao[count]);
					} else {
						//senao altera
						this.upd_anexo_crt(	conhecimento_id = arguments.conhecimento_id,
											descricao = v_descricao[count],
											anexo_id = v_item_id[count]);
					}
					</cfscript>
				</cfloop>		
	
				
				<!--- Insercao de FRONTEIRAS --->
				<cfscript>
					v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_FRONTEIRAS");
					v_fronteira_id = this.ListaToArray (lista = arguments, variavel = "FRONTEIRA_ID_FRONTEIRAS");
					v_fronteira_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FRONTEIRAS, lista2 = ArrayToList(v_fronteira_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_fronteira_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_crt_fronteira (controle_id = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
					<cfscript>
					if(not len(trim(v_controle_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
												fronteira_id = v_fronteira_id[count]);
					} else {
						//senao altera
						this.upd_crt_fronteira(	conhecimento_id = arguments.conhecimento_id,
												fronteira_id    = v_fronteira_id[count],
												controle_id     = v_controle_id[count]);
					}
					</cfscript>
				</cfloop>		
	
				<!---Diviso--->
                <cfscript>
                    v_divisao_controle_id = this.ListaToArray(lista = arguments, variavel = "DIVISAO_CONTROLE_ID_DIVISAO");
                    v_num_embarque        = this.ListaToArray(lista = arguments, variavel = "NUM_EMBARQUE_DIVISAO");
                    v_divisao_embarque_id = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_ID_DIVISAO");
                    v_divisao_id          = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ID_DIVISAO");
                    v_embarque_data       = this.ListaToArray(lista = arguments, variavel = "EMBARQUE_DATA_DIVISAO");
                    v_placa_controle      = this.ListaToArray(lista = arguments, variavel = "PLACA_CONTROLE_DIVISAO");
                    v_placa_referencia_composicao = this.ListaToArray(lista = arguments, variavel = "PLACA_REFERENCIA_COMPOSICAO_DIVISAO");
                    v_divisao_cod_motorista       = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOTORISTA_DIVISAO");
                    v_divisao_motorista           = this.ListaToArray(lista = arguments, variavel = "DIVISAO_MOTORISTA_DIVISAO");
                    v_divisao_cod_pessoa_motorista = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_PESSOA_MOTORISTA_DIVISAO");
                    v_divisao_rota_abreviatura     = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ABREVIATURA_DIVISAO");
                    v_divisao_rota_id    = this.ListaToArray(lista = arguments, variavel = "DIVISAO_ROTA_ID_DIVISAO");
                    v_divisao_km         = this.ListaToArray(lista = arguments, variavel = "DIVISAO_KM_DIVISAO");
                    v_divisao_percentual = this.ListaToArray(lista = arguments, variavel = "DIVISAO_PERCENTUAL_DIVISAO");
                    v_divisao_cod_moeda  = this.ListaToArray(lista = arguments, variavel = "DIVISAO_COD_MOEDA_DIVISAO");
                    v_divisao_valor      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_VALOR_DIVISAO");				
                    v_divisao_data      = this.ListaToArray(lista = arguments, variavel = "DIVISAO_DATA_DIVISAO");
					v_embarque_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_embarque_id));
					v_divisao_excluir   = this.ListDiff(lista1 = arguments.lista_deleted_DIVISAO, lista2 = ArrayToList(v_divisao_id));
                 </cfscript>
        
                <!--- Excluir os itens --->
               <!--- <cfloop list="#v_embarque_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_embarque = this.del_intc_crt_embarque(embarque_id = l_item_id);
                    </cfscript>

                    <cfif set_embarque.erro>
                        <cfthrow object="#set_embarque.MENSAGEM#"/>
                    </cfif>    
                </cfloop>--->  
                
                <cfloop list="#v_divisao_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        set_divisao = this.del_embarque_divisao(divisao_id = l_item_id);
                    </cfscript>

					<cfif set_divisao.erro>
                        <cfthrow object="#set_divisao.MENSAGEM#"/>
                    </cfif>    
                </cfloop>               
                
                <cfset v_embarque = 0>
                <cfset v_embarque_id = 0>
                <cfloop from="1" to="#ArrayLen(v_num_embarque)#" index="count">
                     <cfscript>
                        if (v_embarque neq v_num_embarque[count])  {
                            // Registra embarque
                            v_embarque = v_num_embarque[count];
                            
                            if(not len(trim(v_divisao_embarque_id[count]))) {
                                //caso o item_id seja nulo insere
                                set_embarque = this.ins_intc_crt_embarque( conhecimento_id = arguments.conhecimento_id,
                                                                          data_embarque = v_embarque_data[count]);
                                
								if (not set_embarque.erro) 
                                     v_embarque_id = set_embarque.embarque_id;
                            }else{
								v_embarque_id = v_divisao_embarque_id[count];
							}
                        }
                     </cfscript>

                     <cfif IsDefined("set_embarque") and set_embarque.erro>
                        <cfthrow object="#set_embarque.Mensagem#">
                     </cfif>
                     
                    <cfscript>
                        if(not len(trim(v_divisao_id[count]))) {
                            //caso o item_id seja nulo insere
                            set_divisao = this.ins_embarque_divisao( valor                = v_divisao_valor[count]
                                                                    ,cod_moeda            = v_divisao_cod_moeda[count] 
                                                                    ,percentual_crt       = v_divisao_percentual[count] 
                                                                    ,rota_id              = v_divisao_rota_id[count] 
                                                                    ,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
                                                                    ,embarque_id          = v_embarque_id
																	,data_divisao 		  = v_divisao_data[count] 
                                                                   );
                            
							if (not set_divisao.erro) 
	                           v_divisao_id[count] = set_divisao.divisao_id;
                        } 
						
//						else {
//                            //senao altera
//                            set_divisao = this.upd_embarque_divisao( divisao_id			  = v_divisao_id[count]
//                                                                    ,valor                = v_divisao_valor[count]
//                                                                    ,cod_moeda            = v_divisao_cod_moeda[count] 
//                                                                    ,percentual_crt       = v_divisao_percentual[count] 
//                                                                    ,rota_id              = v_divisao_rota_id[count] 
//                                                                    ,cod_pessoa_motorista = v_divisao_cod_pessoa_motorista[count] 
//                                                                    ,embarque_id          = v_embarque_id
//                                                                   );
//                        }
                     </cfscript>            
                              
                     <cfif isDefined("set_divisao") and set_divisao.erro>
                        <cfthrow object="#set_divisao.Mensagem#">
                     </cfif>

                    <!---Exclui composicao--->
                    <cfscript>
                        set_divisao_comp = this.del_embarque_divisao_comp(divisao_id = v_divisao_id[count]);
                    </cfscript>
                    <cfif set_divisao_comp.erro>
                        <cfthrow object="#set_divisao_comp.Mensagem#">
                    </cfif>
                    
                    <!---Insere todas as composies--->
                    <cfscript>	
                        // Insere cavalo
						if(len(trim(v_placa_controle[count]))) {
                        set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = 0
                                                                          ,placa                = v_placa_controle[count]
                                                                          ,divisao_id           = v_divisao_id[count] 
                                                                         );
						}
                     </cfscript>            
                              
                     <cfif set_divisao_comp.erro>
                        <cfthrow object="#set_divisao_comp.Mensagem#">
                     </cfif>

                     <cfset v_ordem = 1>
                     <cfloop list="#v_placa_referencia_composicao[count]#" index="l_placa" delimiters=",">
                            <cfscript>	
                                // Insere cavalo
								if(len(trim(v_placa_controle[count]))) {
                                set_divisao_comp = this.ins_embarque_divisao_comp( ordem                = v_ordem
                                                                                  ,placa                = l_placa
                                                                                  ,divisao_id           = v_divisao_id[count] 
                                                                                 );
								}
                             </cfscript>            
                             <cfset v_ordem = v_ordem + 1>

                             <cfif set_divisao_comp.erro>
                                <cfthrow object="#set_divisao_comp.Mensagem#">
                             </cfif>
                     </cfloop>
				</cfloop>
                   
                <!--- Gera conhecimento FORM --->
                <cfscript>
					if(arguments.regerar_impressao eq 1) {
                		set_impressao = this.ins_intc_conhecimento_form(conhecimento_id = arguments.conhecimento_id);
					}
				</cfscript>
               
			    <cfif IsDefined("set_impressao") and set_impressao.erro>
					<cfthrow object="#set_impressao.mensagem#">
                </cfif>
                
                <!--- Calcula Seguro --->
				<cfscript>
                    retorno = this.calcula_seguro_crt(conhecimento_id = arguments.conhecimento_id);
                </cfscript>                   
                <cfif IsDefined("retorno") and retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfscript>
					conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
					qrGrupoNegociadorPessoa = conn_cons_tf.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
				</cfscript>                
                
                <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id_intc(ORIGEM_MUNICIPIO_ID  		= arguments.RESP_MUNICIPIO_ID,
																						 DESTINO_MUNICIPIO_ID 		= arguments.ENTREGA_MUNICIPIO_ID,
																						 COD_NEGOCIADOR       		= arguments.COD_NEGOCIADOR,
																						 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																						 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
                    <cfscript>
						// Constantes
						
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_crt_tabela_frete(CONHECIMENTO_ID			= retorno.CONHECIMENTO_ID,
																 CLASSIFICACAO_NATUREZA_ID	= arguments.CLASSIFICACAO_NATUREZA_ID,
																 CLASSIFICACAO_COMERCIAL_ID = arguments.CLASSIFICACAO_COMERCIAL_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                
                <cfscript>
					ret_valid_tf = this.valida_crt_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_valid_tf.erro>
					<cfthrow object="#ret_valid_tf.mensagem#">
				</cfif>
                <!--- /// --->
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("C.R.T. alterado com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere embarque
    -- guto 23/06/2009 10:09:06 - CRIADO
    --->
    <cffunction name='ins_intc_crt_embarque' displayname='Insere embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_EMBARQUE' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARQUE_ID' variable='retorno.EMBARQUE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMBARQUE'  value='#arguments.DATA_EMBARQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque inserido com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.embarque_id = ''>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera embarque
    -- guto 23/06/2009 10:10:46 - CRIADO
    --->
    <cffunction name='upd_intc_crt_embarque' displayname='Altera embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='DATA_EMBARQUE' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMBARQUE'  value='#arguments.DATA_EMBARQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Excluir embarque
    -- guto 23/06/2009 10:11:45 - CRIADO
    --->
    <cffunction name='del_intc_crt_embarque' displayname='Excluir embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_intc_crt_embarque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Embarque excludo com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere diviso no embarque
    -- guto 23/06/2009 10:21:20 - CRIADO
    --->
    <cffunction name='ins_embarque_divisao' displayname='Insere diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='PERCENTUAL_CRT' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cfargument name='DATA_DIVISAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID' variable='retorno.DIVISAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERCENTUAL_CRT'  value='#arguments.PERCENTUAL_CRT#'  null='#iif(len(trim(arguments.PERCENTUAL_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  dbvarname='P_DATA_DIVISAO'  value='#arguments.DATA_DIVISAO#'  null='#iif(len(trim(arguments.DATA_DIVISAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera diviso no embarque
    -- guto 23/06/2009 10:22:41 - CRIADO
    --->
    <cffunction name='upd_embarque_divisao' displayname='Altera diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='PERCENTUAL_CRT' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='EMBARQUE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERCENTUAL_CRT'  value='#arguments.PERCENTUAL_CRT#'  null='#iif(len(trim(arguments.PERCENTUAL_CRT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARQUE_ID'  value='#arguments.EMBARQUE_ID#'  null='#iif(len(trim(arguments.EMBARQUE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso alterado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui diviso no embarque
    -- guto 23/06/2009 10:23:32 - CRIADO
    --->
    <cffunction name='del_embarque_divisao' displayname='Exclui diviso no embarque' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_embarque_divisao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Diviso excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Vincula diviso ao contrato de transporte
    -- guto 23/06/2009 10:23:32 - CRIADO
    --->
    <cffunction name='embarque_divisao_contrato' displayname='Vincula diviso ao contrato de transporte' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_embarque_divisao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato vinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere composio na diviso
    -- guto 23/06/2009 10:24:34 - CRIADO
    --->
    <cffunction name='ins_embarque_divisao_comp' displayname='Insere composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID' variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera composio na diviso
    -- guto 23/06/2009 10:25:58 - CRIADO
    --->
    <cffunction name='upd_embarque_divisao_comp' displayname='Altera composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio alterada com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui composio na diviso
    -- guto 23/06/2009 10:26:39 - CRIADO
    --->
    <cffunction name='del_embarque_divisao_comp' displayname='Exclui composio na diviso' access='remote' returntype='Struct' output='true'>
        <cfargument name='DIVISAO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_del_embarque_divisao_comp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DIVISAO_ID'  value='#arguments.DIVISAO_ID#'  null='#iif(len(trim(arguments.DIVISAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Composio excluda com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um novo manifesto internacional (MIC/DTA)
	-- ANDERSON 17/07/2009 - ALTERADO
	--->
	<cffunction name='ins_intc_manifesto' displayname='Insere um novo manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='ALFANDEGA_DESTINO_ID' required='yes'>		
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>
		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='no' default=""> 
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
        <cfargument name='ANEXO' required='no' default="">
        <cfargument name='MIC_COD_PAIS' required='no' default="">
        <cfargument name='MIC_NUM_PERMISSO' required='no' default="">
        <cfargument name='MIC_NUMERO' required='no' default="">
        <cfargument name='MIC_SERIE' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_COD_PAIS'  value='#UCase(arguments.MIC_COD_PAIS)#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_CERTIFICADO'  value='#arguments.MIC_NUM_PERMISSO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUMERO_SEQUENCIAL'  value='#arguments.MIC_NUMERO#' null="#iif(len(trim(arguments.MIC_NUMERO)), de('no'), de('yes'))#">
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSITO_ADUANEIRO'  value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_NOME'  value='#arguments.TRANSP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_ENDERECO'  value='#arguments.TRANSP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSP_MUNICIPIO_ID'  value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_DADOS_ADICIONAIS'  value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_CNPJ_CPF'  value='#arguments.TRANSP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_ORIGEM_ID'  value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_COD_PESSOA'  value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_NOME'  value='#arguments.VEIC_ORIG_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_ENDERECO'  value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_CNPJ_CPF'  value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_MARCA'  value='#arguments.VEIC_ORIG_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_CHASSIS'  value='#arguments.VEIC_ORIG_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_CAPACIDADE'  value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_ANO'  value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_TIPO'  value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_REFERENCIA'  value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_MOT_COD_PESSOA'  value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_COD_PESSOA'  value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_NOME'  value='#arguments.VEIC_SUBST_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_ENDERECO'  value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_CNPJ_CPF'  value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_MARCA'  value='#arguments.VEIC_SUBST_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_CHASSIS'  value='#arguments.VEIC_SUBST_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_CAPACIDADE'  value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_ANO'  value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_TIPO'  value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_REFERENCIA'  value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_MOT_COD_PESSOA'  value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUM_DTA_ROTA'  value='#arguments.NUM_DTA_ROTA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='inout' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  variable='retorno.MANIFESTO_ID'  null='yes'>
					<cfprocparam type='out' cfsqltype='cf_sql_varchar' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_EN_LASTRE'  value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ANEXO'  value='#arguments.ANEXO#' >
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_SERIE'  value='#arguments.MIC_SERIE#'  null='#iif(len(trim(arguments.MIC_SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset arguments.manifesto_id = retorno.manifesto_id>
				<!--- Inseres dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_pais_id_origem =  this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
						this.ins_intc_manifesto_item(	manifesto_id 	= arguments.manifesto_id,
														conhecimento_id = v_conhecimento_id[count],
														item_id 		= v_id[count],
													    alfandega_destino_id  = arguments.alfandega_destino_id,
														quantidade		= v_quantidade[count],
														peso_bruto		= v_peso_bruto[count],
														peso_liquido	= v_peso_liquido[count],
														valor_total		= v_valor_total[count],
														valor_seguro	= v_seguro[count],
														num_especie		= v_num_especie[count],
														mercadorias		= v_descricao[count],
														numero_lacres	= v_nro_lacres[count],
														valor_fot		= v_valor_fot[count],
														ncm				= v_ncm[count],
														pais_id_origem  = v_pais_id_origem[count],
														anexo			= v_anexos[count],
														cod_remetente	= v_cod_remetente[count],
														rem_nome		= v_rem_nome[count],
														rem_local		= v_rem_local[count],
														rem_municipio_id= v_rem_municipio_id[count],
														en_lastre		= arguments.en_lastre);
					</cfscript>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Altera os dados do manifesto internacional (MIC/DTA)
	-- ANDERSON 17/07/2009 - ALTERADO
	--->
	<cffunction name='upd_intc_manifesto' displayname='Altera os dados do manifesto internacional (MIC/DTA)' access='remote' returntype='Struct' output='true'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='TRANSITO_ADUANEIRO' required='no' default="0">
		<cfargument name='COD_TRANSPORTADOR' required='yes'>
		<cfargument name='TRANSP_NOME' required='yes'>
		<cfargument name='TRANSP_ENDERECO' required='yes'>
		<cfargument name='TRANSP_MUNICIPIO_ID' required='yes'>
		<cfargument name='TRANSP_DADOS_ADICIONAIS' required='yes'>
		<cfargument name='TRANSP_CNPJ_CPF' required='yes'>
		<cfargument name='ALFANDEGA_ORIGEM_ID' required='yes'>
		<cfargument name='DESTINO_LOCAL' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_NOME' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_ENDERECO' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_MUNICIPIO_ID' required='yes'>
		<cfargument name='VEIC_ORIG_PROP_CNPJ_CPF' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_CONTROLE' required='yes'>
		<cfargument name='VEIC_ORIG_MARCA' required='yes'>
		<cfargument name='VEIC_ORIG_CHASSIS' required='yes'>
		<cfargument name='VEIC_ORIG_CAPACIDADE' required='yes'>
		<cfargument name='VEIC_ORIG_ANO' required='yes'>
		<cfargument name='VEIC_ORIG_TIPO' required='yes'>
		<cfargument name='VEIC_ORIG_PLACA_REFERENCIA' required='yes'>
		<cfargument name='VEIC_ORIG_MOT_COD_PESSOA' required='yes'>
		<cfargument name='VEIC_SUBST_PROP_COD_PESSOA' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_NOME' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_ENDERECO' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_MUNICIPIO_ID' required='no' default="">
		<cfargument name='VEIC_SUBST_PROP_CNPJ_CPF' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_CONTROLE' required='no' default="">
		<cfargument name='VEIC_SUBST_MARCA' required='no' default="">
		<cfargument name='VEIC_SUBST_CHASSIS' required='no' default="">
		<cfargument name='VEIC_SUBST_CAPACIDADE' required='no' default="">
		<cfargument name='VEIC_SUBST_ANO' required='no' default="">
		<cfargument name='VEIC_SUBST_TIPO' required='no' default="">
		<cfargument name='VEIC_SUBST_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='VEIC_SUBST_MOT_COD_PESSOA' required='no' default="">
		<cfargument name='NUM_DTA_ROTA' required='yes'>
		<cfargument name='ROTA_ID' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ROMANEIO_ITEM_ID' required='no' default="">
        <cfargument name='EN_LASTRE' required='no' default="0">
        <cfargument name='ANEXO' required='no' default="">
        <cfargument name='MIC_COD_PAIS' required='no' default="">
        <cfargument name='MIC_NUM_PERMISSO' required='no' default="">
        <cfargument name='MIC_NUMERO' required='no' default="">
        <cfargument name='MIC_SERIE' required='no' default="">
        
        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_manifesto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_COD_PAIS'  value='#UCase(arguments.MIC_COD_PAIS)#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUMERO_CERTIFICADO'  value='#arguments.MIC_NUM_PERMISSO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUMERO_SEQUENCIAL'  value='#arguments.MIC_NUMERO#'   null="#iif(len(trim(arguments.MIC_NUMERO)), de('no'), de('yes'))#">
                    <cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSITO_ADUANEIRO'  value='#arguments.TRANSITO_ADUANEIRO#'  null='#iif(len(trim(arguments.TRANSITO_ADUANEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_NOME'  value='#arguments.TRANSP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_ENDERECO'  value='#arguments.TRANSP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_TRANSP_MUNICIPIO_ID'  value='#arguments.TRANSP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.TRANSP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_DADOS_ADICIONAIS'  value='#arguments.TRANSP_DADOS_ADICIONAIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_TRANSP_CNPJ_CPF'  value='#arguments.TRANSP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ALFANDEGA_ORIGEM_ID'  value='#arguments.ALFANDEGA_ORIGEM_ID#'  null='#iif(len(trim(arguments.ALFANDEGA_ORIGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_DESTINO_LOCAL'  value='#arguments.DESTINO_LOCAL#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_COD_PESSOA'  value='#arguments.VEIC_ORIG_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_NOME'  value='#arguments.VEIC_ORIG_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_ENDERECO'  value='#arguments.VEIC_ORIG_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_ORIG_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_ORIG_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PROP_CNPJ_CPF'  value='#arguments.VEIC_ORIG_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_ORIG_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_MARCA'  value='#arguments.VEIC_ORIG_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_CHASSIS'  value='#arguments.VEIC_ORIG_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'  dbvarname='P_VEIC_ORIG_CAPACIDADE'  value='#arguments.VEIC_ORIG_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_ORIG_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_ANO'  value='#arguments.VEIC_ORIG_ANO#'  null='#iif(len(trim(arguments.VEIC_ORIG_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_TIPO'  value='#arguments.VEIC_ORIG_TIPO#'  null='#iif(len(trim(arguments.VEIC_ORIG_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_ORIG_PLACA_REFERENCIA'  value='#arguments.VEIC_ORIG_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_ORIG_MOT_COD_PESSOA'  value='#arguments.VEIC_ORIG_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_ORIG_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_COD_PESSOA'  value='#arguments.VEIC_SUBST_PROP_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_NOME'  value='#arguments.VEIC_SUBST_PROP_NOME#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_ENDERECO'  value='#arguments.VEIC_SUBST_PROP_ENDERECO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_PROP_MUNICIPIO_ID'  value='#arguments.VEIC_SUBST_PROP_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.VEIC_SUBST_PROP_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PROP_CNPJ_CPF'  value='#arguments.VEIC_SUBST_PROP_CNPJ_CPF#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_CONTROLE'  value='#UCase(Replace(arguments.VEIC_SUBST_PLACA_CONTROLE,'-',''))#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_MARCA'  value='#arguments.VEIC_SUBST_MARCA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_CHASSIS'  value='#arguments.VEIC_SUBST_CHASSIS#' >
					<cfprocparam type='in' cfsqltype='cf_sql_double'  dbvarname='P_VEIC_SUBST_CAPACIDADE'  value='#arguments.VEIC_SUBST_CAPACIDADE#'  null='#iif(len(trim(arguments.VEIC_SUBST_CAPACIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_ANO'  value='#arguments.VEIC_SUBST_ANO#'  null='#iif(len(trim(arguments.VEIC_SUBST_ANO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_TIPO'  value='#arguments.VEIC_SUBST_TIPO#'  null='#iif(len(trim(arguments.VEIC_SUBST_TIPO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_VEIC_SUBST_PLACA_REFERENCIA'  value='#arguments.VEIC_SUBST_PLACA_REFERENCIA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_VEIC_SUBST_MOT_COD_PESSOA'  value='#arguments.VEIC_SUBST_MOT_COD_PESSOA#'  null='#iif(len(trim(arguments.VEIC_SUBST_MOT_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_NUM_DTA_ROTA'  value='#arguments.NUM_DTA_ROTA#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#' null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_ITEM_ID'  value='#arguments.ROMANEIO_ITEM_ID#'  null='#iif(len(trim(arguments.ROMANEIO_ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_EN_LASTRE'  value='#arguments.EN_LASTRE#'  null='#iif(len(trim(arguments.EN_LASTRE)), de('no'), de('yes'))#'>
                    <cfprocparam type='in' cfsqltype='cf_sql_varchar' dbvarname='P_ANEXO'  value='#arguments.ANEXO#' >
                    <cfprocparam type='in' cfsqltype='cf_sql_integer' dbvarname='P_SERIE'  value='#arguments.MIC_SERIE#'  null='#iif(len(trim(arguments.MIC_SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.manifesto_id = arguments.manifesto_id>
				<!--- Alteraes dos Items --->
				<cfscript>
					v_nro_crt = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NUMERO_CRT_ITEMS");
					v_conhecimento_id = this.ListaToArray (lista = arguments, variavel = "ITEM_CONHECIMENTO_ID_ITEMS");
					v_id = 				this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ITEMS");
					v_item_id =			this.ListaToArray (lista = arguments, variavel = "ITEM_IT_ID_ITEMS");
					v_quantidade = 		this.ListaToArray (lista = arguments, variavel = "ITEM_QUANTIDADE_ITEMS");
					v_peso_bruto = 		this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_BRUTO_ITEMS");
					v_peso_liquido = 	this.ListaToArray (lista = arguments, variavel = "ITEM_PESO_LIQUIDO_ITEMS");
					v_valor_total = 	this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_TOTAL_ITEMS");
					v_seguro = 			this.ListaToArray (lista = arguments, variavel = "ITEM_SEGURO_ITEMS");
					v_num_especie = 	this.ListaToArray (lista = arguments, variavel = "ITEM_NUM_ESPECIE_ITEMS");
					v_descricao = 		this.ListaToArray (lista = arguments, variavel = "ITEM_DESCRICAO_ITEMS");
					v_ncm = 			this.ListaToArray (lista = arguments, variavel = "ITEM_NCM_ITEMS");
					v_pais_id_origem  = this.ListaToArray (lista = arguments, variavel = "ITEM_PAIS_ID_ORIGEM");
					v_valor_fot = 		this.ListaToArray (lista = arguments, variavel = "ITEM_VALOR_FOT_ITEMS");
					v_nro_lacres = 		this.ListaToArray (lista = arguments, variavel = "ITEM_NRO_LACRES_ITEMS");
					v_anexos = 			this.ListaToArray (lista = arguments, variavel = "ITEM_ANEXOS_ITEMS");
					v_cod_remetente = 	this.ListaToArray (lista = arguments, variavel = "COD_REMETENTE_ITEMS");
					v_rem_nome =		this.ListaToArray (lista = arguments, variavel = "REM_NOME_ITEMS");
					v_rem_local =		this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_UF_PAIS_ITEMS");
					v_rem_municipio_id =this.ListaToArray (lista = arguments, variavel = "REM_MUNICIPIO_ID_ITEMS");
					v_item_excluir = 	this.ListDiff(lista1 = arguments.lista_deleted_ITEMS, lista2 = ArrayToList(v_id));
					
					// TOTAIS
					v_pagina              = this.ListaToArray (lista = arguments, variavel = "PAGINA");
					v_campo42             = this.ListaToArray (lista = arguments, variavel = "CAMPO42");
					v_campo43             = this.ListaToArray (lista = arguments, variavel = "CAMPO43");
					v_campo44             = this.ListaToArray (lista = arguments, variavel = "CAMPO44");
					v_campo45             = this.ListaToArray (lista = arguments, variavel = "CAMPO45");
					v_campo46             = this.ListaToArray (lista = arguments, variavel = "CAMPO46");
					v_campo47             = this.ListaToArray (lista = arguments, variavel = "CAMPO47");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_pagina)#" index="count">
					<cfscript>
					//altera
					this.upd_intc_manifesto_pagina(	manifesto_id 		= arguments.manifesto_id,
													pagina			 	= v_pagina[count],
													campo42 		 	= v_campo42[count],
													campo43 		 	= v_campo43[count],
													campo44 		 	= v_campo44[count],
													campo45 		 	= v_campo45[count],
													campo46 		 	= v_campo46[count],
													campo47 		 	= v_campo47[count]);
					</cfscript>
				</cfloop>			
				
				<!--- Excluir os itens --->
				<cfloop list="#v_item_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_intc_manifesto_item (manifesto_id = arguments.manifesto_id,
												      item_id   = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_descricao)#" index="count">
					<cfscript>
					if(not len(trim(v_item_id[count]))) {
						//caso o item_id seja nulo insere
						this.ins_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													item_id 				= v_id[count],
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
					} else {
						//senao altera
						this.upd_intc_manifesto_item(	manifesto_id 		= arguments.manifesto_id,
													conhecimento_id 		= v_conhecimento_id[count],
													item_id 				= v_id[count],
													alfandega_destino_id    = arguments.alfandega_destino_id,
													quantidade				= v_quantidade[count],
													peso_bruto				= v_peso_bruto[count],
													peso_liquido			= v_peso_liquido[count],
													valor_total				= v_valor_total[count],
													valor_seguro			= v_seguro[count],
													num_especie				= v_num_especie[count],
													mercadorias				= v_descricao[count],
													numero_lacres			= v_nro_lacres[count],
													valor_fot				= v_valor_fot[count],
													ncm						= v_ncm[count],
													pais_id_origem			= v_pais_id_origem[count],
													item_id					= v_item_id[count],
													anexo					= v_anexos[count],
													cod_remetente			= v_cod_remetente[count],
													rem_nome				= v_rem_nome[count],
													rem_local				= v_rem_local[count],
													rem_municipio_id		= v_rem_municipio_id[count],
													en_lastre				= arguments.en_lastre);
					}
					</cfscript>
				</cfloop>			
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MIC/DTA alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Calcular Seguro de um CRT
	-- RAFAEL 16/03/2010 14:07:00 - CRIADO
	--->
	<cffunction name='calcula_seguro_crt' displayname='Calcular Seguro de um CRT' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_seguro_contratado.prc_calcula_seguro_crt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Valida o vnculo das divises com carta frete
	-- ANDERSONC 15/03/2011 15:32:35 - CRIADO
	--->
	<cffunction name='validar_divisao_contrato' displayname='Valida o vnculo das divises com carta frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_validar_divisao_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Permisso
	-- rafael 12/05/2009 16:43:35 - CRIADO
	--->
	<cffunction name='ins_permisso' displayname='Inserir Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='no' default="">
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
		<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_ins_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMISSO_ID'  value='#arguments.PERMISSO_ID#' variable='retorno.PERMISSO_ID'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PAIS'  value='#arguments.COD_PAIS#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PERMISSO'  value='#arguments.NUM_PERMISSO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_SEQUENCIAL_INICIAL'  value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Permisso inserido com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Editar Permisso
	-- rafael 12/05/2009 16:46:41 - CRIADO	
	--->
	<cffunction name='upd_permisso' displayname='Editar Permisso' access='remote' returntype='Struct' output='true'>
		<cfargument name='PERMISSO_ID' required='yes'>
		<cfargument name='COD_PAIS' required='yes'>
		<cfargument name='NUM_PERMISSO' required='yes'>
		<cfargument name='NUM_SEQUENCIAL_INICIAL' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cfargument name='SERIE' required='yes'>
			<cftry>
			<cftransaction action='begin'>
			<cfstoredproc procedure='fiscal.pkg_transp_internacional.prc_alt_permisso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMISSO_ID'  value='#arguments.PERMISSO_ID#'  null='#iif(len(trim(arguments.PERMISSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PAIS'  value='#arguments.COD_PAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PERMISSO'  value='#arguments.NUM_PERMISSO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_SEQUENCIAL_INICIAL'  value='#arguments.NUM_SEQUENCIAL_INICIAL#'  null='#iif(len(trim(arguments.NUM_SEQUENCIAL_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Permisso alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>