<cfcomponent extends="_transportes.manipulacao.cfc_controle_combustivel">
	<!--- 
	-- PROPSITO
	-- Insere uma nova requisio
	-- 11/01/2006 - criado
	--->
	<cffunction name="ins_requisicao" displayname="Insere uma nova requisio" access="remote" returntype="Struct" output="true">
		<cfargument name="CONTROLE_ID" required="yes">
		<cfargument name="NUM_REQUISICAO" required="yes">
		<cfargument name="ESTOQUE_ID" required="yes">
		<cfargument name="PLACA" required="yes">
		<cfargument name="KM" required="yes">
		<cfargument name="DATA_HORA" required="yes">
		<cfargument name="QUANTIDADE" required="yes">
		<cfargument name="BOMBA_ID" required="yes">
		<cfargument name="PRODUTO_ID" required="yes">
		<cfargument name="CONTADOR_INICIAL" required="yes">
		<cfargument name="CONTADOR_FINAL" required="yes">
		<cftry>
				<cftransaction action="begin">
					<cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value="#arguments.CONTROLE_ID#" variable="retorno.CONTROLE_ID" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value='#session.cod_pessoa#'  null="#iif(len(trim(session.cod_pessoa)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null='yes'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value='#UCase(replace(arguments.placa, '-', '', 'ALL'))#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.KM#"  null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			value="#arguments.PRODUTO_ID#" null="#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_FLOAT' 				dbvarname='P_QUANTIDADE'  			value='#arguments.QUANTIDADE#' null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null='yes'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null="yes">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		value="#arguments.NUM_REQUISICAO#" null="#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			value="#arguments.ESTOQUE_ID#" null="#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			value="#arguments.BOMBA_ID#" null="#iif(len(trim(arguments.BOMBA_ID)), de('no'), de('yes'))#" >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value='2'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_INICIAL'  	value="#arguments.CONTADOR_INICIAL#" null="#iif(len(trim(arguments.CONTADOR_INICIAL)), de('no'), de('yes'))#">
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_FINAL'  		value="#arguments.CONTADOR_FINAL#" null="#iif(len(trim(arguments.CONTADOR_FINAL)), de('no'), de('yes'))#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento inserida com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera dados de uma nova requisio
	-- 11/01/2006 - criado
	--->
	<cffunction name="upd_requisicao" displayname="Altera dados de uma nova requisio" access="remote" returntype="Struct" output="true">
		<cfargument name="LANCTO_ID" required="no" default="">
		<cfargument name="CONTROLE_ID" required="yes">
		<cfargument name="NUM_REQUISICAO" required="yes">
		<cfargument name="ESTOQUE_ID" required="yes">
		<cfargument name="NUM_SAIDA" required="yes">
		<cfargument name="PLACA" required="yes">
		<cfargument name="KM" required="yes">
		<cfargument name="DATA_HORA" required="yes">
		<cfargument name="QUANTIDADE" required="yes">
		<cfargument name="BOMBA_ID" required="yes">
		<cftry>
		
			<cftransaction action="begin">
				<cfstoredproc procedure='oper.pkg_abastecimento.prc_confirma_abastecimento' datasource='#session.dsn#' username="#session.usuario#" password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTROLE_ID'  			value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" variable="retorno.controle_id">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_POSTO'  	value="#session.cod_pessoa#" null="#iif(len(trim(session.cod_pessoa)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_COD_PESSOA_MOTORISTA'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_DATA_HORA'  			value='#arguments.DATA_HORA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_CUPOM_FISCAL'  	null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_NOTA_ID'  			null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' 				dbvarname='P_PLACA'  				value="#UCase(replace(arguments.placa, '-', '', 'ALL'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_KM'  					value="#arguments.km#" null="#iif(len(trim(arguments.KM)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_PRODUTO_ID'  			null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_QUANTIDADE'  			value="#arguments.QUANTIDADE#"  null="#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_LANCTO_CRT_ID'  		null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_UNITARIO'  		null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_VALOR_TOTAL'  			null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ALIQUOTA_ICMS'  		null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_NUM_REQUISICAO'  		value="#arguments.NUM_REQUISICAO#" null="#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ESTOQUE_ID'  			value="#arguments.ESTOQUE_ID#" null="#iif(len(trim(arguments.ESTOQUE_ID)), de('no'), de('yes'))#" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONFERIDO'  			null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_BOMBA_ID'  			value="#arguments.BOMBA_ID#" null="#iif(len(trim(arguments.BOMBA_ID)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_ENCHEU'  				null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_SUPLEMENTAR'  			value="0">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_TIPO_ENTRADA'  		value="2">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_INICIAL'  	value="#arguments.CONTADOR_INICIAL#" null="#iif(len(trim(arguments.CONTADOR_INICIAL)), de('no'), de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' 	dbvarname='P_CONTADOR_FINAL'  		value="#arguments.CONTADOR_FINAL#" null="#iif(len(trim(arguments.CONTADOR_FINAL)), de('no'), de('yes'))#">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento alterada com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui requisio
	-- 11/01/2006 - criado
	--->
	<cffunction name="del_requisicao" displayname="Exclui requisio" access="remote" returntype="Struct" output="true">
		<cfargument name="CONTROLE_ID" required="yes">
		<cfargument name="MOTIVO_ID" required="yes">
		<cfargument name="TIPO_ENTRADA_ID" required="yes">
		<cftry>
			<cftransaction action="begin">
				<cfstoredproc procedure="oper.pkg_abastecimento.prc_del_abastecimento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_CONTROLE_ID" value="#arguments.CONTROLE_ID#" null="#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#" >
					<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="P_MOTIVO_ID" value="#arguments.MOTIVO_ID#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="P_TIPO_ENTRADA_ID" value="#arguments.TIPO_ENTRADA_ID#" null="#iif(len(trim(arguments.TIPO_ENTRADA_ID)), de('no'), de('yes'))#" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat("Requisio de abastecimento excluda com sucesso!")>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere o registro de cancelamento de uma requisio
	-- guto 12/03/2007 16:09:55 - CRIADO
	--->
	<cffunction name='ins_requisicao_cancelada' displayname='Insere o registro de cancelamento de uma requisio' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='NUM_REQUISICAO' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_abastecimento.prc_ins_requisicao_cancelada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_REQUISICAO'  value='#arguments.NUM_REQUISICAO#'  null='#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CANCELAMENTO'  value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO_CANCELAMENTO'  value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Requisio cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui o registro de cancelamento de uma requisio
	-- guto 12/03/2007 16:11:02 - CRIADO
	--->
	<cffunction name='del_requisicao_cancelada' displayname='Exclui o registro de cancelamento de uma requisio' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='NUM_REQUISICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_abastecimento.prc_del_requisicao_cancelada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_REQUISICAO'  value='#arguments.NUM_REQUISICAO#'  null='#iif(len(trim(arguments.NUM_REQUISICAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
</cfcomponent>