<cfcomponent extends="_transportes.manipulacao.cfc_contrato_transporte">	
	<!--- 
	-- PROPSITO
	-- Gera um romaneio para terceiros
	-- cristofer 15/12/2006 11:24:28 - CRIADO
	--->
	<cffunction name='gera_romaneio_terceiro' displayname='Gera um romaneio para terceiros' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COMPOSICAO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='VIAGEM_CARGA_ID' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_romaneio.prc_gera_romaneio_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID' variable='retorno.ITEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPOSICAO'  value='#arguments.COMPOSICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO'  value='#arguments.DATA_INICIO#' variable='retorno.DATA_INICIO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VIAGEM_CARGA_ID'  value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL' value='#session.COD_PESSOA#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Romaneio gerado com sucesso')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Vincula contrato ao CTRC
    -- guto 12/12/2008 15:19:26 - CRIADO
    --->
    <cffunction name='ins_vinculo_contrato_conhecimento' displayname='Vincula contrato ao CTRC' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_vincula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo executado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Desvincula contrato ao CTRC
    -- guto 12/12/2008 15:19:26 - CRIADO
    --->
    <cffunction name='del_vinculo_contrato_conhecimento' displayname='Vincula contrato ao CTRC' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_desvincula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Conhecimento desvinculado com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
	-- PROPSITO
	-- Insere um item vinculado a carta frete
	-- 11/01/2006 - criado
	--->
	<cffunction name="ins_item_contrato" displayname="Insere um item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="lancto_id" 	required="YES">
		<cfargument name="item_id" 		required="YES">
		<cfargument name="descricao" 	required="YES">
		<cfargument name="valor" 		required="YES">
		<cfargument name="desconto" 	required="YES">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_ins_contrato_transp_item" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#arguments.lancto_id#" null="#iif(len(trim(arguments.lancto_id)),de('no'),de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_item_id" value="#arguments.item_id#" null="#iif(len(trim(arguments.item_id)),de('no'),de('yes'))#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" scale="5" dbvarname="p_valor" value="#arguments.valor#" null="#iif(len(trim(arguments.valor)),de('no'),de('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat("Item lanado com sucesso!")>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere uma carga no contrato transporte
    -- cristofer 12/05/2008 16:06:22 - CRIADO
    --->
    <cffunction name='ins_contrato_transp_carga' displayname='Insere uma carga no contrato transporte' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='TIPO_OPERACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_OPERACAO'  value='#arguments.TIPO_OPERACAO#'  null='#iif(len(trim(arguments.TIPO_OPERACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carga vinculada com sucesso!')>
           <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere contas a pagar para o contrato
	-- GUTO 12/01/2007 11:59:08 - CRIADO
	--->
	<cffunction name='ins_contrato_transp_contas_pagar' displayname='Insere contas a pagar para o contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
				<cfstoredproc procedure='oper.pkg_contrato_transp.prc_gera_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere o contrato no CTF e vinculado ao contrato emitido.
    -- guto 11/02/2009 11:37:50 - CRIADO
    --->
    <cffunction name='ins_contrato_ctf' displayname='Insere o contrato no CTF e vinculado ao contrato emitido.' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_ins_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRANSACAO_ID' variable='retorno.TRANSACAO_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTRATO_CTF' variable='retorno.COD_CONTRATO_CTF' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM_RETORNO' variable='retorno.mensagem' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um Contrato de transporte
	-- cristofer 27/11/2006 14:34:47 - CRIADO
	--->
	<cffunction name='ins_contrato_transporte' displayname='Insere um Contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default=''>
		<cfargument name='NUM_FORMULARIO' required='yes'>
		<cfargument name='SERIE_FORMULARIO' required='no' default="U">
		<cfargument name='TIPO_CONTRATO' required='no' default="0">        
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='TOLERANCIA_FALTA' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_FRETE_BRUTO' required='yes'>
		<cfargument name='VALOR_FRETE_LIQUIDO' required='yes'>
		<cfargument name='MOTORISTA_COD_PESSOA' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='PROPRIETARIO_COD_PESSOA' required='yes'>
		<cfargument name='PROPRIETARIO_ENDERECO' required='yes'>
		<cfargument name='PROPRIETARIO_COD_UF' required='no' default="" >
		<cfargument name='PROPRIETARIO_COD_MUNICIPIO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DISTRITO' required='no' default="">
		<cfargument name='PROPRIETARIO_COD_DV' required='no' default="">
		<cfargument name='PROPRIETARIO_NIT' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PROPRIETARIO_MUNICIPIO_ID' required='yes'>
		<cfargument name='MANIFESTO_ID' required='yes'>
		<cfargument name='TIPO_CARGA' required='no' default="">
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='TOTAL_PARCELA' required='no' default="0">
		<cfargument name='CARGA_ID_COLETA' required='no' default="">
		<cfargument name='CARGA_ID_ENTREGA' required='no' default="">
		<cfargument name='CTF' required='no' default="0">
        <cfargument name='COD_MODELO' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_DESTINATARIO' required='no' default="">
        <cfargument name='OPERACAO_ID' required='no' default=''>
        <cfargument name='CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CTRC_ID' required='no' default=''>
        <cfargument name='DIARIA_CRT_ID' required='no' default=''>
        <cfargument name='USUARIO_LIBERACAO' required='no' default=''>
        <cfargument name='SENHA_LIBERACAO' required='no' default=''>
        <cfargument name='VALOR_MAXIMO' required='yes'>
        <cfargument name='DIVISAO_ID' required='no' default=''>
        <cfargument name='REPOM' required='yes'>
		<cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='AVULSA' required='no' default="0">
        <cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfset retorno.num_romaneio = arguments.num_romaneio>
				<cfset retorno.conhecimento_id = arguments.conhecimento_id>
				<cfif arguments.tipo_carga eq 2>
					<!--- Gera um romaneio para o manifesto --->
					<cfscript>
						retorno_roo = this.gera_romaneio_manifesto(	NUM_LOTE             	= arguments.num_lote,
																	MANIFESTO_ID			= arguments.manifesto_id,
																	CONHECIMENTO_ID			= arguments.conhecimento_id,
																	COD_PESSOA_MOTORISTA	= arguments.motorista_cod_pessoa,
																	DATA_EMISSAO			= arguments.data_emissao,
																	OBSERVACAO				= arguments.observacao);
						retorno.num_romaneio = retorno_roo.num_romaneio;
					</cfscript>
				</cfif>
                <cfstoredproc procedure='oper.pkg_contrato_transp.prc_ins_contrato_transp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID' variable='retorno.LANCTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_FORMULARIO'  value='#arguments.NUM_FORMULARIO#'  null='#iif(len(trim(arguments.NUM_FORMULARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_FORMULARIO'  value='#arguments.SERIE_FORMULARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONTRATO'  value='#arguments.TIPO_CONTRATO#'  null='#iif(len(trim(arguments.TIPO_CONTRATO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TOLERANCIA_FALTA'  value='#arguments.TOLERANCIA_FALTA#'  null='#iif(len(trim(arguments.TOLERANCIA_FALTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE_BRUTO'  value='#arguments.VALOR_FRETE_BRUTO#'  null='#iif(len(trim(arguments.VALOR_FRETE_BRUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_FRETE_LIQUIDO'  value='#arguments.VALOR_FRETE_LIQUIDO#'  null='#iif(len(trim(arguments.VALOR_FRETE_LIQUIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTORISTA_COD_PESSOA'  value='#arguments.MOTORISTA_COD_PESSOA#'  null='#iif(len(trim(arguments.MOTORISTA_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_CONTROLE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIETARIO_COD_PESSOA'  value='#arguments.PROPRIETARIO_COD_PESSOA#'  null='#iif(len(trim(arguments.PROPRIETARIO_COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_ENDERECO'  value='#arguments.PROPRIETARIO_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIETARIO_MUNICIPIO_ID'  value='#arguments.PROPRIETARIO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.PROPRIETARIO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROPRIETARIO_NIT'  value='#arguments.PROPRIETARIO_NIT#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' null='#iif(len(trim(arguments.COD_MODELO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTRC_ID'  value='#arguments.CTRC_ID#'  null='#iif(len(trim(arguments.CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIARIA_CTRC_ID'  value='#arguments.DIARIA_CTRC_ID#'  null='#iif(len(trim(arguments.DIARIA_CTRC_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DIARIA_CRT_ID'  value='#arguments.DIARIA_CRT_ID#'  null='#iif(len(trim(arguments.DIARIA_CRT_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_LIBERACAO'  value='#arguments.USUARIO_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA_LIBERACAO'  value='#arguments.SENHA_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MAXIMO'  value='#arguments.VALOR_MAXIMO#'  null='#iif(len(trim(arguments.VALOR_MAXIMO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVULSA'  value='#arguments.AVULSA#'  null='#iif(len(trim(arguments.AVULSA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_SERVICO_COMERCIAL'  value='#arguments.TIPO_SERVICO_COMERCIAL#'  null='#iif(len(trim(arguments.TIPO_SERVICO_COMERCIAL)), de('no'), de('yes'))#'>
                </cfstoredproc>
				
                <!---Vincula ao CTRC--->
                <cfif Len(Trim(arguments.CONHECIMENTO_ID))>
					<cfscript>
                        set_vinculo = this.ins_vinculo_contrato_conhecimento(lancto_id = retorno.LANCTO_ID,
                                                                             conhecimento_id = arguments.conhecimento_id);
                    </cfscript>
                    <cfif set_vinculo.erro>
                        <cfthrow object="#set_vinculo.mensagem#">
                    </cfif>
                </cfif>
                
				<!--- Insere ITENS --->
				<cfscript>
					v_item_id 	   = this.ListaToArray (lista = arguments, variavel = "ACR_ITEM_ID");
					v_descricao    = this.ListaToArray (lista = arguments, variavel = "ACR_DESCRICAO");
					v_desconto 	   = this.ListaToArray (lista = arguments, variavel = "ACR_DESCONTO_COD");
					v_valor		   = this.ListaToArray (lista = arguments, variavel = "ACR_VALOR");
					v_cod_posto	   = this.ListaToArray (lista = arguments, variavel = "POSTO_COD_PESSOA_ACRESCIMOS");
					v_unitario	   = this.ListaToArray (lista = arguments, variavel = "POSTO_VALOR_UNITARIO_ACRESCIMOS");
					v_quantidade   = this.ListaToArray (lista = arguments, variavel = "POSTO_QUANTIDADE_ACRESCIMOS");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
					<cfscript>
						v_item_contrato = this.ins_item_contrato(lancto_id	= retorno.lancto_id,
																 item_id	= v_item_id[count],
																 descricao	= v_descricao[count],
																 desconto	= v_desconto[count],
																 valor		= v_valor[count]);
					</cfscript>
					<cfif v_item_contrato.erro>
						<cfthrow object="#v_item_contrato.mensagem#">
					</cfif>
				</cfloop>
                
                <cfif arguments.tipo_carga eq 3>
                	<cfloop list="#arguments.carga_id_coleta#" index="v_id">
                    	<cfscript>
							ret = this.ins_contrato_transp_carga(lancto_id = retorno.lancto_id,
																 carga_id  = v_id,
																 tipo_operacao = 1);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                	<cfloop list="#arguments.carga_id_entrega#" index="v_id">
                    	<cfscript>
							ret = this.ins_contrato_transp_carga(lancto_id = retorno.lancto_id,
																 carga_id  = v_id,
																 tipo_operacao = 2);
						</cfscript>
                        <cfif ret.erro>
                        	<cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>
                
                <!---Diviso do CRT--->
                <cfset v_validar_divisao = 0 />
                
                <cfloop list="#arguments.DIVISAO_ID#" index="v_divisao_id">
					<cfscript>
                        conn = CreateComponent('_transportes.manipulacao.cfc_transp_internacional');
                        set_divisao = conn.embarque_divisao_contrato(lancto_id = retorno.lancto_id, divisao_id = v_divisao_id);
                    </cfscript>
                    
                    <cfif set_divisao.erro>
                    	<cfthrow object="#set_divisao.mensagem#">
                    </cfif>
                    
                    <cfset v_validar_divisao = 1 />
                </cfloop>
                
                <cfif v_validar_divisao eq 1>
                	<cfscript>
                        set_validar_divisao = conn.validar_divisao_contrato(lancto_id = retorno.lancto_id);
                    </cfscript>
                    <cfif set_validar_divisao.erro>
                    	<cfthrow object="#set_validar_divisao.mensagem#">
                    </cfif>
                </cfif>
                
				<cfif arguments.total_parcela gt 1>
                	<!--- Efetua o parcelamento da carta frete --->
                    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_parcelar_contrato_transp" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#retorno.lancto_id#" null="#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_total_parcelas" value="#arguments.total_parcela#" null="#iif(len(trim(arguments.total_parcela)),de('no'),de('yes'))#">
                    </cfstoredproc>
                    
                <cfelse>
					<!--- Recalcula os impostos sobre a carta frete --->
                    <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_recalcula_contrato_transp" username="#session.usuario#" password="#session.senha#">
                        <cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_lancto_id" value="#retorno.lancto_id#" null="#iif(len(trim(retorno.lancto_id)),de('no'),de('yes'))#">
                    </cfstoredproc>
                    
                    <!--- Insere no contas a pagar --->
                    <cfscript>
                        this.ins_contrato_transp_contas_pagar(lancto_id = retorno.lancto_id);
                    </cfscript>
				</cfif>
                
                <!---CTF--->
                <cfif arguments.CTF eq 1>
                    <cfscript>
                        conn_ct = CreateComponent("_transportes.manipulacao.cfc_contrato_transporte");
                        set_ctf = conn_ct.ins_contrato_ctf(lancto_id = retorno.LANCTO_ID);						
                    </cfscript>
                    
                    <cfif set_ctf.erro>
                        <cfthrow object="#set_ctf.mensagem#">
                    <cfelse>
                        <cfset retorno.mensagem_ctf = set_ctf.mensagem>                   
                    </cfif>      
                </cfif> 
                
                <!--- REPOM --->
                <cfif arguments.REPOM eq 1>
					<cfscript>
						conn = CreateComponent("_transportes.manipulacao.transporte.cfc_repom");
						ret_repom = conn.emitir_contrato(LANCTO_ID     = retorno.LANCTO_ID,
												 	     ROTA_ID       = arguments.ROTA_ID,
													     CARTAO_NUMERO = arguments.CARTAO_NUMERO);
					</cfscript>
					<cfif ret_repom.erro>
						<cfthrow object="#ret_repom.mensagem#">
                    <cfelse> 
                    	<cfset retorno.contrato_id = ret_repom.contrato_id>
					</cfif>                
                </cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato de Transporte inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>