<cfcomponent extends="_transportes.consulta.financeiro.cfc_faturamento">
	<!--- 
    -- PROPSITO
    -- Busca CTRC para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_ctrc_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="FATURA_CONFERIDO" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_CONHECIMENTO" required="no" default=""/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/> 
    	<cfargument name="FATURADOS" required="no" default="0"/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct /*+LEADING(C) INDEX(RI PKC_RIT)*/
                  c.conhecimento_id
                 , c.num_conhecimento, c.cob_razao_social as pagador , c.serie
                 , to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao
                 , c.valor_icms
                 , c.total_conhecimento
                 , case
                      when c.num_romaneio is null then 1
                      when to_number(kss.pkg_global.fnc_obtem_parametro_str(25, 'FISCAL.EXE', 8, 2)) = 0 then 1
                      --else oper.pkg_fluxo_docto.fnc_verifica_doctos_fatura_2(c.num_romaneio, c.item_id, null)
                   end situacao_fluxo,
                   c.pedagio, c.rowid,
                   0 as selecionado
                 , c.valor_faturamento
                 , c.cod_organograma_gerencial, (select o.cod_unidade_negocio||' - '||o.cod_centro_custo
                                                   from kss.v$organograma o
                                                  where o.cod_organograma = c.cod_organograma_gerencial) as centro_custo_gerencial
                 , c.valor_icms_substit,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$conhecimento c
              left join fiscal.v$documento_cte d
                on d.conhecimento_id = c.conhecimento_id
              left join fiscal.v$documento_status ds
                on ds.documento_id = d.documento_id
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = '#arguments.NUM_DOCTO#'
             <cfelse>
             	left join fiscal.v$conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
             left join finan.v$faturamento_excecao_cliente fec
                            on fec.cod_pessoa = c.cod_cliente_cobranca
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and ( c.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#) or fec.cod_pessoa_filial in (#arguments.COD_PESSOA_FILIAL#) )
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
	               and c.cod_cliente_cobranca = #arguments.COD_PESSOA_PAGADOR#
               </cfif>
               and c.cancelado is null
               and c.num_conhecimento > 0
               and c.valor_faturamento > 0
               and decode(c.modelo_documento , '57', ds.emitido, 1) = 1
               <cfif Len(Trim(arguments.FATURA_CONFERIDO))>
                 and ((#arguments.FATURA_CONFERIDO# = 1 and c.conferido is not null)
                  or (#arguments.FATURA_CONFERIDO# = 0))
               </cfif>
               <cfif Len(Trim(arguments.NUM_CONHECIMENTO))>
			     and c.num_conhecimento = #arguments.NUM_CONHECIMENTO#
               </cfif>
               <cfif arguments.FATURADOS eq 0>
                   and not exists (select /*+INDEX(CR PKC_CNCR) */ 'x'
                                     from fiscal.v$conhecimento_receber cr
                                    where c.conhecimento_id = cr.conhecimento_id)
               <cfelse>
                   and exists (select /*+INDEX(CR PKC_CNCR) */ 'x'
                                     from fiscal.v$conhecimento_receber cr
                                    where c.conhecimento_id = cr.conhecimento_id)
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
            order by num_conhecimento    
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca CRT para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_nfes_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_NOTA_ID" required="no" default=""/>
    	<cfargument name="NUM_NOTA_FISCAL" required="no" default=""/>
    	<cfargument name="SEM_FATURA" required="no" default="1"/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select /*+ push_subq */
                   n.num_nota_id, n.num_nota_fiscal, n.serie, n.e_s,
                   n.cod_pessoa_filial, n.cod_departamento,
                   n.cod_setor, n.cod_centro_custo,
                   (
                      select cod_unidade_negocio
                        from kss.v$unidade_negocio
                       where cod_pessoa = cod_pessoa_filial
                   ) as cod_unidade_negocio,
                   to_char(n.data_emissao,'dd/mm/yyyy') as data_emissao, n.data_es, n.natureza_descricao, 
                   n.calc_valor_total_nota as calc_valor_bruto,
                   fiscal.pkg_nf_es.fnc_valor_retencao_impostos(n.num_nota_id) as serv_iss_valor,
                   n.calc_valor_total_nota - fiscal.pkg_nf_es.fnc_valor_retencao_impostos(n.num_nota_id) as calc_valor_total_nota,
                   n.trp_peso_liquido,
                   nvl(nef.cob_razao_social,n.dest_razao_social) as pagador,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$nf_es n
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$nf_es_receber cr
                        on cr.num_nota_id = n.num_nota_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = '#arguments.NUM_DOCTO#'
             <cfelse>
             	left join fiscal.v$nf_es_receber cr
                        on cr.num_nota_id = n.num_nota_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
              left join fiscal.v$nf_es_frete nef
                     on nef.nf_es_id = n.num_nota_id
             where cancelada = 0
               and n.emitida = 1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and n.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
	               and (nvl(nef.cod_cliente_cobranca, n.cod_destinatario) = #arguments.COD_PESSOA_PAGADOR#)
               </cfif>	
               <cfif Len(Trim(arguments.NUM_NOTA_ID))>
	               and n.num_nota_id = #arguments.NUM_NOTA_ID#
               </cfif>
               <cfif Len(Trim(arguments.NUM_NOTA_FISCAL))>
               	  and n.num_nota_fiscal = #arguments.NUM_NOTA_FISCAL#
               </cfif>
               <cfif arguments.SEM_FATURA eq 1>
                   and not exists (
                                     select /*+ push_subq */ 'x'
                                       from fiscal.v$nf_es_receber tp
                                      where tp.num_nota_id = n.num_nota_id
                                  )
               <cfelse>
                   and exists (
                                     select /*+ push_subq */ 'x'
                                       from fiscal.v$nf_es_receber tp
                                      where tp.num_nota_id = n.num_nota_id
                                  )
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
               
             order by n.num_nota_fiscal, n.serie 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca pagadores NACIONAL NFES
    -- 26/05/2009
    --->	
    <cffunction name="get_pagadores_nf_es" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ push_subq */
                   distinct 
                     nvl(nef.cob_cnpj_cpf, n.dest_cnpj_cpf) as cnpj_cpf ,
                     nvl(nef.cob_razao_social, n.dest_razao_social) as razao_social,
                     nvl(nef.cod_cliente_cobranca, n.cod_destinatario) as codigo, 
                     decode(pf.fat_forma_id,2,1,0) as fatura_com_bloqueto
              from fiscal.v$nf_es n
              left join fiscal.v$nf_es_frete nef
                     on nef.nf_es_id = n.num_nota_id
              left join kss.v$pessoa_faturamento pf 
                      on pf.cod_pessoa = nvl(nef.cod_cliente_cobranca, n.cod_destinatario)
             where cancelada = 0
               and n.emitida = 1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and n.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>             
               and not exists (
                                 select /*+ push_subq */ 'x'
                                   from fiscal.v$nf_es_receber tp
                                  where tp.num_nota_id = n.num_nota_id
                              )
             order by razao_social
        </cfquery>
        <cfreturn qr_result>
    </cffunction> 
    
    <!--- 
    -- PROPSITO
    -- Busca pagadores NACIONAL
    -- 26/05/2009
    --->	
    <cffunction name="get_pagadores" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="FATURA_CONFERIDO" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.codigo
                 , kss.pkg_pessoa.fnc_get_identificador(t.codigo) as cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(t.codigo) as razao_social
                 , t.fatura_com_bloqueto
              from (
                    select c.cod_cliente_cobranca as codigo
                         , nvl((select decode(pf.fat_forma_id, 2, 1, 0)
                                  from kss.v$pessoa_faturamento pf
                                 where pf.cod_pessoa = c.cod_cliente_cobranca
                               ), 0
                              ) as fatura_com_bloqueto
                         , case
                              when c.modelo_documento = '57' then
                                 (select ds.emitido
                                    from fiscal.v$documento_cte d
                                    left join fiscal.v$documento_status ds
                                           on ds.documento_id = d.documento_id
                                   where d.conhecimento_id = c.conhecimento_id
                                 )
                              else 1
                           end as emitido
                      from fiscal.v$conhecimento c
                     where c.cancelado is null -- no cancelado
                       and c.impresso is not null -- impresso
                       and c.num_conhecimento > 0
                       and c.total_conhecimento > 0
                       and c.cod_cliente_cobranca is not null
                       and ((#arguments.fatura_conferido# = 1 and c.conferido is not null) or (#arguments.fatura_conferido# = 0))
                       and not exists (select 1
                                         from fiscal.v$conhecimento_receber cr
                                        where c.conhecimento_id = cr.conhecimento_id
                                          and rownum = 1
                                      )
					<cfif len(trim(arguments.cod_pessoa_filial))>
	                   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
               		</cfif>
                   ) t
             where t.emitido = 1
             group by t.codigo, t.fatura_com_bloqueto
             order by razao_social, cnpj_cpf
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Busca CRT para faturar
    -- 26/05/2009
    --->	
    <cffunction name="get_crt_faturamento" displayname="" output="true" returntype="query" access="public">
    	<cfargument name="COD_PESSOA_FILIAL" required="no" default=""/>
    	<cfargument name="NUM_CONHECIMENTO" required="no" default=""/>
    	<cfargument name="COD_PESSOA_PAGADOR" required="no" default=""/>
    	<cfargument name="NUM_DOCTO" required="no" default=""/>
    	<cfargument name="FATURADOS" required="no" default="0"/>
    	<cfargument name="DATA_INICIO" required="no" default=""/>
    	<cfargument name="DATA_FIM" required="no" default=""/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ PUSH_SUBQ */
            distinct p.cnpj_cpf,
                     p.razao_social || '(' || p.cnpj_cpf || ')' as razao_social,
                     p.cod_pessoa,
                     c.numero_cod_pais || '.' || c.numero_certificado || '.' || replace(replace(to_char(c.numero_sequencial, '000,000'), ',', '.'),' ','') as num_crt,
                     (select mb.descricao_moeda
                        from finan.v$moeda_bacen mb
                       where mb.cod_moeda = t.cod_moeda) moeda,
                     c.cotacao,
                     t.cod_moeda,
                     t.valor_total,
                     round(t.valor_total * c.cotacao, 2) valor_total_convertido,
                     t.origem,
                     t.destino,
                     to_char(t.emissao_data,'dd/mm/yyyy') as emissao_data,
                     c.conhecimento_id,
                     c.pago_por,
                     c.numero_cod_pais,
                     c.cod_pessoa_filial,
                     fcr.num_docto, to_char(fcr.data_vencto,'dd/mm/yyyy') as data_vencto
              from fiscal.v$intc_doctos_fatura t
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = t.cod_pessoa_pagador
             inner join fiscal.v$intc_conhecimento c 
                     on t.conhecimento_id = c.conhecimento_id
             <cfif Len(Trim(arguments.NUM_DOCTO))>
             	inner join fiscal.v$intc_conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                inner join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
                      and fcr.num_docto = #arguments.NUM_DOCTO#
			 <cfelse>
             	left join fiscal.v$intc_conhecimento_receber cr
                        on cr.conhecimento_id = c.conhecimento_id
                left join finan.v$finan_contas_receber fcr
                       on fcr.contas_receber_id = cr.contas_receber_id
             </cfif>
             where 1=1
               <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
	               and c.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
               </cfif>
               <cfif Len(Trim(arguments.NUM_CONHECIMENTO))>
                  and upper(replace(c.num_crt_completo,'.','')) like upper(replace('%#arguments.NUM_CONHECIMENTO#%','.',''))
               </cfif>
               <cfif Len(Trim(arguments.COD_PESSOA_PAGADOR))>
                  and p.cod_pessoa = #arguments.COD_PESSOA_PAGADOR#
               </cfif>
               <cfif arguments.FATURADOS eq 0>
                   and not exists (select 'x'
                                     from fiscal.v$intc_conhecimento_receber cr
                                    inner join fiscal.v$intc_conhecimento c2 
                                            on c2.conhecimento_id = cr.conhecimento_id
                                    inner join finan.v$finan_contas_receber fcr on fcr.contas_receber_id = cr.contas_receber_id
                                    where cr.conhecimento_id = c.conhecimento_id
                                      and fcr.COD_PESSOA = t.cod_pessoa_pagador)
                   and c.quitado = 0
               <cfelse>
                   and exists (select 'x'
                                     from fiscal.v$intc_conhecimento_receber cr
                                    inner join fiscal.v$intc_conhecimento c2 
                                            on c2.conhecimento_id = cr.conhecimento_id
                                    inner join finan.v$finan_contas_receber fcr on fcr.contas_receber_id = cr.contas_receber_id
                                    where cr.conhecimento_id = c.conhecimento_id
                                      and fcr.COD_PESSOA = t.cod_pessoa_pagador)
               </cfif>
               <cfif Len(Trim(arguments.DATA_INICIO))>
                 and trunc(fcr.data_emissao) >= '#arguments.DATA_INICIO#'
               </cfif>
               <cfif Len(Trim(arguments.DATA_FIM))>
                 and trunc(fcr.data_emissao) <= '#arguments.DATA_FIM#'
               </cfif>
               and c.pre_conhecimento = 0
             order by razao_social 
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
</cfcomponent>