﻿<cfcomponent extends="_transportes.consulta.cfc_emissao_documentos">
	<!--- 
	-- PROPÓSITO
	-- Busca pessoa, enqueanto não for unificado a parte de MUNICIPIO deve ser usada essa consulta
	-- Guto 04/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_pessoa" displayname="Busca pessoa, enqueanto não for unificado a parte de MUNICIPIO deve ser usada essa consulta" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" displayname="Código pessoa" required="false">
		<cfargument name="cnpj_cpf" displayname="CNPJ ou CPF ou código da pessoa" required="false">
		<cfargument name="nome" displayname="Nome ou parte do nome da pessoa" required="false">
		<cfargument name="razao_social" displayname="Razao Social do nome da pessoa" required="false">
		<cfargument name="tipo" displayname="Tipo para  consulta, 1 - CNPJ e Estrangeiro, 2 - CPF e Estrangeiro, 3 - Sem Estrangeiro, 4 - Somente CPF" required="false">
		<cfquery datasource="#session.dsn#" name="qr_pessoa" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa, codigo, bairro, endereco, to_char(cep) as cep, 
				   complemento, logradouro, 
				   nome_fantasia, razao_social, municipio, uf, 
				   cod_atividade_fiscal, inscricao_estadual,
				   municipio || ' - ' || uf as municipio_uf, 
						ib.cod_uf as cod_uf,
						ib.cod_municipio as cod_municipio,
						ib.cod_distrito as cod_distrito, 
						ib.cod_dv as cod_dv,
	               case rd.situacao_id
				     when 0 then 'Inativo'
				     when 1 then 'Ativo'
				     when 2 then 'Em avaliação'
                   end situacao, rd.municipio_id 
 		      from oper.v$remetente_destinatario rd
			  left join cep.ibge_municipio ib
			         on ib.municipio_id_kmm = rd.municipio_id
		      where 0=0 
			 <cfif isDefined("arguments.cod_pessoa")>
				 and rd.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif isDefined("arguments.cnpj_cpf") and len(arguments.cnpj_cpf) eq 14>
				 and rd.codigo like '#arguments.cnpj_cpf#%'
			 <cfelseif isDefined("arguments.cnpj_cpf") and len(arguments.cnpj_cpf) eq 11>
				 and rd.codigo like '#arguments.cnpj_cpf#%'
			 <cfelseif isDefined("arguments.cnpj_cpf")>
				 and rd.cod_pessoa = #arguments.cnpj_cpf#
			 </cfif>
			 <cfif isDefined("arguments.nome")>
				 and upper(rd.nome_fantasia) like upper('%#arguments.nome#%')
			 </cfif>
			 <cfif isDefined("arguments.razao_social")>
				 and upper(rd.razao_social) like upper('%#arguments.razao_social#%')
			 </cfif>			
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 1>
				 and rd.cpf is null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 2>
				 and rd.cnpj_basico is null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 3>
				 and rd.cpf is not null
				 or rd.cnpj_basico is not null
			</cfif>
			<cfif isDefined("arguments.tipo") and arguments.tipo eq 4>
				 and rd.cpf is not null
				 and rd.cnpj_basico is null
				 and rd.cod_estrangeiro is null
			</cfif>
			 order by nome_fantasia  
 		</cfquery>
		<cfreturn qr_pessoa>
	</cffunction>		

	<!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos lançados
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006
	--->
	<cffunction name="get_conhecimento" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" >
		<cfargument name="num_conhecimento" displayname="Numero do conhecimento"  >
		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="false">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="false">
		<cfargument name="serie" displayname="Serie" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="false">
		<cfargument name="cod_setor" displayname="Setor" required="false"> 
		<cfargument name="nivel_acesso"  required="false" default="0">
		<cfargument name="situacao_id"  required="false" default="0">
        <cfargument name="impresso_id"  required="false" default="">
        <cfargument name="faturado_id"  required="false" default="">
        <cfargument name="cod_centro_custo"  required="false" default="">
        <cfargument name="cnpj_cpf"  required="false" default="">
        <cfargument name="check_remetente"  required="false" default="">
        <cfargument name="check_destinatario"  required="false" default="">
        <cfargument name="check_consignatario"  required="false" default="">
        <cfargument name="check_redespacho"  required="false" default="">
        <cfargument name="check_cobranca"  required="false" default="">
     	<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
				select c.item_id,
                       c.num_romaneio,
                       o.operacao_id, o.descricao as operacao,
                       c.conhecimento_id,
                       p.cliente as filial,
                       p.cnpj_cpf as cnpj_cpf_filial,
                       c.cod_pessoa_filial,
                       c.cod_setor,
                       s.descricao as setor,
                       c.serie,
                       c.num_conhecimento,
                       to_char(c.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao,
                       to_char(c.prazo_entrega,'dd/mm/yyyy hh24:mi') as prazo_entrega,
                       c.cfop || '-' || c.cfop_id as cfop,
                       c.natureza_operacao,
                       c.pagador,
                       c.cod_remetente,
                       c.rem_razao_social,
                       c.rem_endereco,
                       c.rem_municipio,
                       c.rem_uf,
                       c.rem_cep,
                       c.rem_cnpj_cpf,
                       c.rem_inscricao_estadual,
                       c.cod_destinatario,
                       c.dest_razao_social,
                       c.dest_endereco,
                       c.dest_municipio,
                       c.dest_uf,
                       c.dest_cep,
                       c.dest_cnpj_cpf,
                       c.dest_inscricao_estadual,
                       c.cod_consignatario,
                       c.cons_razao_social,
                       c.cons_endereco,
                       c.cons_municipio,
                       c.cons_uf,
                       c.cons_cep,
                       c.cons_cnpj_cpf,
                       c.cons_inscricao_estadual,
                       c.cod_destinatario,
                       c.peso,
                       c.volume,
                       c.m3,
                       c.frete_unitario,
                       c.frete_valor,
                       c.despacho,
                       c.base_calculo_icms,
                       c.aliquota_icms,
                       c.ademe,
                       c.desconto,
                       c.valor_icms,
                       c.coleta_entrega,
                       c.impostos,
                       c.total_conhecimento,
                       c.num_natureza,
                       n.descricao as natureza,
                       c.num_especie,
                       e.descricao as especie,
                       c.cod_unidade,
                       u.unidade,
                       col.municipio as coleta,
                       col.uf_id as coleta_sigla_uf,
                       ent.municipio as entrega,
                       ent.uf_id as entrega_sigla_uf,
                       c.placa,
                       r.placa_controle,
                       c.nome_motorista,
                       c.cod_proprietario,
                       c.prop_cnpj_cpf,
                       c.prop_razao_social,
                       c.prop_endereco,
                       c.prop_uf,
                       c.entrada_dados,
                       c.cancelado, c.impresso,
                       case
                         when c.cancelado is not null then 'Cancelado' 
                         when c.impresso is not null then 'Impresso' 
                       else 'Confirmado' end situacao,
                       c.observacao,
                       c.tipo_venda,
                       c.rodape,
                       c.user_insert,
                       c.st_icms_id,
                       c.st_origem_id,
                       c.num_produto,
                       c.frete_peso,
                       c.cod_motorista,
                       c.coleta_municipio_id,
                       c.entrega_municipio_id,
                       c.impresso,
                       decode(c.placa_tracao,
                              '',
                              '',
                              oper.pkg_veiculo.fnc_veiculo_proprietario(c.placa_tracao)) proprietario_tracao,
                       c.placa_tracao,
                       fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
                       (select sum(nf.valor_total)
                          from fiscal.v$conhecimento_nota_fiscal nf
                         where nf.conhecimento_id = c.conhecimento_id) as valor_nota_fiscal,
                       c.regra_fiscal_id, /*ar.valor_liquido,*/
                       decode(c.cancelado, null, 'Nao', 'Sim') as cancelado,
                       decode(decode(c.placa_tracao,'','',oper.pkg_veiculo.fnc_veiculo_proprietario(c.placa_tracao)),
                              1,
                              'Frota',
                              2,
                              'Agregado',
                              3,
                              'Terceiro',
                              '',
                              '---') as veiculo_prop_tipo, 
                       c.user_insert as usuario,
                       (select sum(nf.peso)
                          from fiscal.v$conhecimento_nota_fiscal nf
                         where nf.conhecimento_id = c.conhecimento_id) as peso_real,
                       (select sum(nf.peso_cobrado)
                          from fiscal.v$conhecimento_nota_fiscal nf
                         where nf.conhecimento_id = c.conhecimento_id) as peso_cobrado,
                       (select cc.carga_id
                          from oper.v$carga_ctrc cc
                         where cc.conhecimento_id = c.conhecimento_id) as carga_id,
                       (select count(cc.conhecimento_id)
                          from fiscal.v$conhecimento_complemento cc
                         where cc.conhecimento_complemento_id = c.conhecimento_id) as complemento
                  from fiscal.v$conhecimento c
				  inner join kss.v$pessoa p 
				          on p.cod_pessoa = c.cod_pessoa_filial
				  left join kss.v$setor s 
 							   on c.cod_setor = s.cod_setor
				  left join oper.v$romaneio r
				         on r.num_romaneio = c.num_romaneio
				  left join oper.v$romaneio_item ri
 							   on ri.num_romaneio = c.num_romaneio
							  and ri.item_id = c.item_id
                  left join logistica.v$operacao o
                         on o.operacao_id = ri.operacao_id
                  left join logistica.v$viagem_carga vc
                         on vc.viagem_carga_id = ri.viagem_carga_id
                  left join logistica.v$solicitacao_carga sc
                         on sc.solicitacao_carga_id = vc.solicitacao_carga_id
			      left join cep.municipio col
					    		on c.coleta_municipio_id = col.municipio_id
				  left join cep.municipio ent
							    on c.entrega_municipio_id = ent.municipio_id
			      left join oper.v$natureza n
			            on c.num_natureza = n.num_natureza
			      left outer join oper.v$especie e
			            on c.num_especie = e.num_especie
				  left join fiscal.v$unidade_medida u
			    	      on c.cod_unidade = u.cod_unidade
				   <cfif isDefined("Arguments.conhecimento_id") and Len(Trim(Arguments.conhecimento_id))>
				  	   	where c.conhecimento_id = #Arguments.conhecimento_id#
				   <cfelseif isDefined("Arguments.num_conhecimento") and Len(Trim(Arguments.num_conhecimento))>
					   	where c.num_conhecimento = #Arguments.num_conhecimento#
				   <cfelseif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
						where trunc(c.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
				   </cfif>
	   <cfif isDefined("arguments.serie") and Len(Trim(arguments.serie)) >
		   and c.serie = '#arguments.serie#'
	   </cfif>
	   <cfif isDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial)) >
		   and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
	   </cfif>
	   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor)) and (arguments.nivel_acesso eq 5) and (arguments.nivel_acesso eq 1) >
		   and c.cod_setor = #arguments.cod_setor#
	   </cfif> 
	   <cfif isDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id)) >
         <cfswitch expression="#arguments.situacao_id#">
         	<cfcase value="0">
            	and c.impresso is null
            	and c.cancelado is null
            </cfcase>
         	<cfcase value="1">
            	and c.cancelado is not null
            </cfcase>
         	<cfcase value="2">
            	and c.cancelado is null
                and c.impresso is not null
            </cfcase>
         </cfswitch>
	   </cfif>
       <cfif isDefined("arguments.impresso_id") and Len(Trim(arguments.impresso_id))>
       	   and c.impresso = #arguments.impresso_id#
       </cfif>
       <cfif isDefined("arguments.faturado_id") and Len(Trim(arguments.faturado_id))>
       	   and co.faturado = #arguments.faturado_id#
       </cfif>
       <cfif isDefined("arguments.cod_centro_custo") and Len(Trim(arguments.cod_centro_custo)) >
		   and c.cod_centro_custo = #arguments.cod_centro_custo#
	   </cfif>
       <cfif isDefined("arguments.cod_remetente") and Len(Trim(arguments.cod_remetente)) >
		   and c.cod_remetente = #arguments.cod_remetente#
	   </cfif>
       <cfif isDefined("arguments.check_remetente") and Len(Trim(arguments.check_remetente))>
       	   and c.rem_cnpj_cpf = #arguments.cnpj_cpf#
       </cfif>
       <cfif isDefined("arguments.check_destinatario") and Len(Trim(arguments.check_destinatario))>
       	   and c.dest_cnpj_cpf = #arguments.cnpj_cpf#
       </cfif>
        <cfif isDefined("arguments.check_consignatario") and Len(Trim(arguments.check_consignatario))>
       	   and c.cons_cnpj_cpf = #arguments.cnpj_cpf#
       </cfif>
       <cfif isDefined("arguments.check_redespacho") and Len(Trim(arguments.check_redespacho))>
       	   and c.red_cnpj_cpf = #arguments.cnpj_cpf#
       </cfif>
        <cfif isDefined("arguments.check_cobranca") and Len(Trim(arguments.check_cobranca))>
       	   and c.cob_cnpj_cpf = #arguments.cnpj_cpf#
       </cfif>       
	   order by c.num_conhecimento 
	  </cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>
	


		
	<!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos lançados
	-- NOTAS EXPLICATIVAS
	-- GUTO 23/02/2006
	--->
	<cffunction name="get_conhecimentos" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" >
		<cfargument name="num_conhecimento" displayname="Numero do conhecimento"  >
		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="false">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="false">
		<cfargument name="serie" displayname="Serie" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="false">
		<cfargument name="cod_setor" displayname="Setor" required="false"> 
		<cfargument name="nivel_acesso"  required="false" default="0">
		<cfargument name="situacao_id"  required="false" default="0">
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
				select c.item_id, c.num_romaneio, l.num_lote, c.conhecimento_id, 
						  p.cliente as filial,
					     c.cod_pessoa_filial, c.cod_setor, s.descricao as setor, c.serie,
					     c.num_conhecimento, c.data_emissao,           
					     c.cfop || '-' || c.cfop_id as cfop, c.natureza_operacao, c.pagador,
					     c.cod_remetente, c.rem_razao_social, c.rem_endereco,
               	  		 c.rem_municipio, c.rem_uf, c.rem_cep, c.rem_cnpj_cpf,
					     c.rem_inscricao_estadual, c.cod_destinatario,
					     c.dest_razao_social, c.dest_endereco, c.dest_municipio,
					     c.dest_uf, c.dest_cep, c.dest_cnpj_cpf,
					     c.dest_inscricao_estadual, 
						  c.cod_consignatario, c.cons_razao_social, c.cons_endereco,
               	  		 c.cons_municipio, c.cons_uf, c.cons_cep, c.cons_cnpj_cpf,
					     c.cons_inscricao_estadual, c.cod_destinatario,						 
					     c.peso,
					     c.volume, c.m3, c.frete_unitario, c.frete_valor, c.despacho,
					     c.base_calculo_icms, c.aliquota_icms, c.ademe, c.desconto,
					     c.valor_icms, c.coleta_entrega, c.impostos, c.total_conhecimento,
					     c.num_natureza, n.descricao as natureza, c.num_especie,
					     e.descricao as especie, c.cod_unidade, u.unidade,
					     col.municipio as coleta, col.uf_id as coleta_sigla_uf,
					     c.coleta_cod_uf, c.coleta_cod_municipio, c.coleta_cod_distrito,
					     c.coleta_cod_dv, ent.municipio as entrega,
					     ent.uf_id as entrega_sigla_uf, c.entrega_cod_uf,
					     c.entrega_cod_municipio, c.entrega_cod_distrito, c.entrega_cod_dv,
					     c.placa, r.placa_controle, c.nome_motorista, c.cod_proprietario, c.prop_cnpj_cpf, c.prop_razao_social,
					     c.prop_endereco, c.prop_uf, c.entrada_dados,
					     c.situacao_id,
					     decode(c.situacao_id, 0, 'Confirmado', 1, 'Cancelado', 2, 'Impresso') as situacao,
					     c.observacao, c.rodape, c.user_insert, c.st_icms_id, c.st_origem_id,
					     c.num_produto,
						 c.frete_peso,
						 c.cod_motorista,
						 c.coleta_municipio_id,
						 c.entrega_municipio_id,
						 c.impresso,
						 decode(c.placa_tracao,'','',oper.pkg_operacional.fnc_veiculo_proprietario(c.placa_tracao)) proprietario_tracao,
						 c.placa_tracao,
					     oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
					     (select sum(nf.valor_total)
					 	     from oper.v$conhecimento_nota_fiscal nf
						    where nf.conhecimento_id = c.conhecimento_id) as valor_nota_fiscal,
					      l.regra_fiscal_id, ar.valor_liquido,
						  decode(c.situacao_id,2,'Sim','Não') as cancelado,
						  decode(oper.pkg_operacional.fnc_veiculo_proprietario(c.placa_tracao),1,'Frota',2,'Agregado',3,'Terceiro','','---') as veiculo_prop_tipo,
						  m.num_manifesto,
						  m.manifesto_id,
						  c.user_insert as usuario,
						  (select sum(nf.peso)
					 	     from oper.v$conhecimento_nota_fiscal nf
						    where nf.conhecimento_id = c.conhecimento_id) as peso_real,
                		  (select sum(nf.peso_cobrado)
					 	     from oper.v$conhecimento_nota_fiscal nf
						    where nf.conhecimento_id = c.conhecimento_id) as peso_cobrado					  
			    from oper.v$conhecimento c
				  inner join oper.v$pessoa p 
				          on p.cod_pessoa = c.cod_pessoa_filial
				  left join oper.v$agregado_romaneio ar
				         on ar.num_romaneio = c.num_romaneio
						  and ar.conhecimento_id = c.conhecimento_id
				  left join oper.v$setor s 
 							   on c.cod_pessoa_filial = s.cod_pessoa_filial
 							  and  c.cod_setor = s.cod_setor
				  left join oper.v$romaneio r
				         on r.num_romaneio = c.num_romaneio
				  left join oper.v$romaneio_item ri
 							   on ri.num_romaneio = c.num_romaneio
							  and ri.item_id = c.item_id
				  left join oper.v$lote l
				         on l.num_lote = ri.num_lote			  
			      left join cep.municipio col
					    		on c.coleta_municipio_id = col.municipio_id
				  left join cep.municipio ent
							    on c.entrega_municipio_id = ent.municipio_id
			      left join oper.v$natureza n
			            on c.num_natureza = n.num_natureza
			      left outer join oper.v$especie e
			            on c.num_especie = e.num_especie
				  left join fiscal.v$unidade_medida u
			    	      on c.cod_unidade = u.cod_unidade
				  left join oper.v$manifesto_conhecimento mc
				         on mc.conhecimento_id = c.conhecimento_id 
				  left join oper.v$manifesto m
				         on m.manifesto_id = mc.manifesto_id
				   <cfif isDefined("Arguments.conhecimento_id") and Len(Trim(Arguments.conhecimento_id))>
				  	   	where c.conhecimento_id = #Arguments.conhecimento_id#
				   <cfelseif isDefined("Arguments.num_conhecimento") and Len(Trim(Arguments.num_conhecimento))>
					   	where c.num_conhecimento = #Arguments.num_conhecimento#
				   <cfelseif isDefined("arguments.data_inicial") and isDefined("arguments.data_final")>
						where trunc(c.data_emissao) between '#arguments.data_inicial#' and '#arguments.data_final#'
				   </cfif>
	   <cfif isDefined("arguments.serie") and Len(Trim(arguments.serie)) >
		   and c.serie = '#arguments.serie#'
	   </cfif>
	   <cfif isDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial)) >
		   and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
	   </cfif>
	   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor)) and (arguments.nivel_acesso eq 5) and (arguments.nivel_acesso eq 1) >
		   and c.cod_setor = #arguments.cod_setor#
	   </cfif> 
	   <cfif isDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id)) >
		   and c.situacao_id in (#arguments.situacao_id#)
	   </cfif>
	   order by c.num_conhecimento 
	  </cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>	
		
		
	
	
	<!--- 
	-- PROPÓSITO 
	-- Busca dados do item do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_item" displayname="Busca o item do romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" required="no" default="" />
		<cfargument name="frete_proprio" displayname="FLAG que indica se a consulta é por frete propio" required="no" default="" />
        <cfargument name="tipo_documento" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ORDERED*/
                   ri.num_romaneio,
                   ri.item_id, o.operacao_id, vc.viagem_carga_id,
                   ri.num_lote, 
                   ri.volume,
                   ri.m3,
                   ri.valor_frete,
                   fiscal.pkg_conhecimento.fnc_produto_frete(col.municipio_id, ent.municipio_id, o.frete_proprio) as num_produto,
                   
                   ri.cod_remetente,
                   rem.razao_social as remetente,
                   rem.cnpj_cpf as rem_cnpj_cpf,
                   col.municipio_id as rem_municipio_id,
                   col.uf_id as rem_uf,
                   per.logradouro || ',' || per.numero || ' - ' || per.complemento as rem_endereco,
                   per.logradouro as rem_logradouro,
                   per.numero as rem_endereco_num,
                   to_char(per.cep) as rem_cep,
                   per.bairro as rem_bairro,
                   initcap(col.municipio) as rem_municipio,
                   rem.inscricao_estadual as rem_inscr_estadual,
                   
                   ri.cod_destinatario,
                   dest.razao_social as destinatario,
                   dest.cnpj_cpf as dest_cnpj_cpf,
                   d_end.logradouro || ', ' || d_end.numero || ' - ' || d_end.complemento as dest_endereco,
                   d_end.logradouro as dest_logradouro,
                   d_end.numero as dest_endereco_num,
                   d_end.uf as dest_uf,
                   to_char(d_end.cep) as dest_cep,
                   d_end.bairro as dest_bairro,
                   initcap(ent.municipio) as dest_municipio,
                   ent.municipio_id as dest_municipio_id,
                   dest.cod_atividade_fiscal as dest_atividade_fiscal,
                   dest.inscricao_estadual as dest_inscr_estadual,
                   
                   ri.observacao,
                   case
                     when sc.valor_em = 'PESO' then
                      ri.valor_frete / decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),0,1,fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                     when sc.valor_em = 'LOTACAO' then
                      ri.valor_frete
                     else
                      ri.valor_frete /
                      decode(fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade),
                             0,
                             1,
                             fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'kg', sc.cod_unidade))
                   end frete_valor_unitario,
                   o.frete_por_conta,
                   sc.valor_em as frete_em, 
                   decode(o.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal, 
                   fiscal.pkg_fiscal.fnc_converte_peso(ri.peso, 'Kg', sc.cod_unidade) as peso,
                   '' as rodape,
                   decode(dest.cod_pessoa, null, 0, 1) as lote_com_destinatario, 
                   o.frete_proprio,
                   o.regra_fiscal_id,
				   
                   nvl(sc.cod_consignatario,ri.cod_remetente) as cod_consignatario,
                
                   nvl(cons.razao_social,rem.razao_social) as cons_razao_social,
                   nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf,
                   nvl(cons.inscricao_estadual,rem.inscricao_estadual) as cons_inscricao_estadual,
                   nvl(decode(sc.cod_consignatario,null,'',cons_end.logradouro || ',' || cons_end.numero)
                       ,per.logradouro || ',' || per.numero || ' - ' || per.complemento)  as cons_endereco,
                   nvl(cons_end.numero,per.numero) as cons_endereco_num,
                   nvl(cons_end.bairro,per.bairro) as cons_bairro,
                   nvl(cons_end.cep,to_char(per.cep)) as cons_cep,
                   nvl(cons_end.municipio,initcap(col.municipio)) as cons_municipio,
                   nvl(cons_end.uf,col.uf_id) as cons_uf,
                   nvl(cons_mun.municipio_id,col.municipio_id) as cons_municipio_id,
                   
                   nvl(sc.cod_redespacho,ri.cod_destinatario) as cod_redespacho,
                   nvl(red.razao_social,dest.razao_social) as redespacho,
                   nvl(red.cnpj_cpf,dest.cnpj_cpf) as red_cnpj_cpf,
                   nvl(red_end.logradouro,d_end.logradouro) as red_logradouro,
                   nvl(red_end.numero,d_end.numero) as red_endereco_num,
                   nvl(red_end.uf,d_end.uf) as red_uf,
                   nvl(to_char(red_end.cep),to_char(d_end.cep)) as red_cep,
                   nvl(red_end.bairro,d_end.bairro) as red_bairro,
                   nvl(initcap(red_mun.municipio),initcap(ent.municipio)) as red_municipio,
                   nvl(red_mun.municipio_id,ent.municipio_id) as red_municipio_id,
                   nvl(red.cod_atividade_fiscal,dest.cod_atividade_fiscal) as red_atividade_fiscal,
                   nvl(red.inscricao_estadual,dest.inscricao_estadual) as red_inscr_estadual,
                     
                   pcob.cod_pessoa as  cod_cliente_cobranca,
                   pcob.cnpj_cpf cob_cnpj_cpf,
                   pcob.razao_social cob_razao_social,
                   pcob.inscricao_estadual cob_inscricao_estadual,
                   pecob.logradouro as cob_endereco,
                   pecob.numero as cob_endereco_numero,
                   pecob.cep cob_cep,
                   cobm.municipio cob_municipio,
                   cobm.uf_id cob_uf,
                   pecob.municipio_id cob_municipio_id,
                   ro.abreviatura as rota_abreviatura,
                   ro.rota_id	  as rota_id,
                   ro.descricao_rota   as rota_descricao,
                   o.cod_negociador,
                   neg.cnpj_cpf as neg_cnpj_cpf,
                   neg.razao_social as neg_razao_social,
                   neg.inscricao_estadual as neg_inscricao_estadual,
                   neg_end.logradouro as neg_endereco,
                   neg_end.numero as neg_endereco_num,
                   neg_end.cep as neg_cep,
                   neg_end.municipio as neg_municipio,
                   neg_end.municipio_id as neg_municipio_id,
                   neg_end.bairro as neg_bairro,
                   neg_end.uf as neg_uf , o.descricao as operacao,
                   sc.origem_municipio_id, sc.destino_municipio_id,
                   vc.viagem_id, 
                   sc.solicitacao_carga_id,
                   to_char(sc.data_entrega_fim, 'dd/mm/yyyy hh24:mi') as data_entrega_fim,
                   (select count(*)
                     from fiscal.v$conhecimento c
                    where c.num_romaneio = ri.num_romaneio
                      and c.item_id = ri.item_id) as possui_conhecimento
              from oper.v$romaneio_item ri
             inner join logistica.v$viagem_carga vc
                     on vc.viagem_carga_id = ri.viagem_carga_id 
             inner join logistica.v$solicitacao_carga sc
                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
             inner join kss.v$pessoa rem 
                     on rem.cod_pessoa = sc.cod_remetente
             inner join kss.v$pessoa_endereco_padrao per 
                     on per.cod_pessoa = rem.cod_pessoa
             inner join cep.municipio col 
                     on ri.rem_municipio_id = col.municipio_id
             inner join logistica.v$operacao o 
                     on ri.operacao_id = o.operacao_id
              left join oper.v$rota ro
                     on ro.origem_municipio_id = sc.origem_municipio_id
                    and ro.destino_municipio_id = sc.destino_municipio_id
                    and ro.data_cancelamento is null
              left join kss.v$pessoa dest 
                     on ri.cod_destinatario = dest.cod_pessoa
              left join kss.v$pessoa_endereco_padrao d_end 
                     on d_end.cod_pessoa = dest.cod_pessoa
              left join kss.v$pessoa_endereco_padrao pecob
                     on pecob.cod_pessoa = sc.cod_cobranca
              left join kss.v$pessoa pcob
                     on pcob.cod_pessoa = sc.cod_cobranca
              left join cep.municipio cobm 
                     on cobm.municipio_id = pecob.municipio_id
              left join cep.municipio ent 
                     on d_end.municipio_id = ent.municipio_id
              left join kss.v$pessoa red
                     on sc.cod_redespacho = red.cod_pessoa
              left join kss.v$pessoa_endereco_padrao red_end 
                     on red_end .cod_pessoa = sc.cod_redespacho
              left join cep.municipio red_mun
                     on red_end.municipio_id = red_mun.municipio_id
              left join kss.v$pessoa neg 
                     on neg.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa_endereco_padrao neg_end 
                     on neg_end.cod_pessoa = o.cod_negociador
              left join kss.v$pessoa cons 
                     on cons.cod_pessoa = sc.cod_consignatario
              left join kss.v$pessoa_endereco_padrao cons_end
                     on cons_end.cod_pessoa = sc.cod_consignatario
              left join cep.municipio cons_mun
                     on cons_end.municipio_id = cons_mun.municipio_id
            where ri.num_romaneio = #arguments.num_romaneio# 
			 <cfif Len(Trim(arguments.item_id))>
			   and ri.item_id = #arguments.item_id#
			 </cfif>
             <cfif Len(Trim(arguments.tipo_documento))>
			   and o.tipo_documento = #arguments.tipo_documento#
			 </cfif>
 			 <cfif Len(Trim(arguments.frete_proprio))>
			   and o.frete_proprio = #arguments.frete_proprio#
			 </cfif> 
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca dados do romaneio
	-- NOTAS EXPLICATIVAS
	-- GUTO 08/04/2006
	--->
	<cffunction name="get_romaneio_aberto" displayname="Busca o romaneio aberto para o veículo" access="remote" returntype="query" output="true">
		<cfargument name="placa_referencia" required="no" default="" />
		<cfargument name="placa_controle" required="no" default="" />
		<cfargument name="data" required="no" default="" />
		<cfargument name="num_romaneio" required="no" default="" />
		<cfquery result="query" datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select /*+ STAR_TRANSFORMATION */ 
            	   r.num_romaneio, 
                   r.carregamento, 
                   r.destino, 
                   r.cliente, 
                   r.remetente, 
                   r.destinatario, 
                   to_char(rhv.data_inicio,'dd/mm/yyyy hh24:mi:ss') as data_inicio, 
                   to_char(rhv.data_termino,'dd/mm/yyyy hh24:mi:ss') as data_termino, 
                   r.data_previsao_descarga, 
				   r.data_previsao_carregado, 
                   r.num_natureza, 
                   n.descricao as natureza, 
                   r.num_especie, 
                   r.cod_unidade, 
                   r.frete_em, 
                   fiscal.pkg_fiscal.fnc_converte_peso(r.peso_total, 'Kg',r.cod_unidade) as peso_convertido,
				   r.peso_total, 
                   r.volume_total, 
                   r.m3_total, 
                   r.frete_total, 
				   r.valor_entregue, 
                   r.km_vazio, 
                   r.km_carregado, 
                   r.valor_pedagio_vazio, 
                   r.valor_pedagio_carregado, 
                   nvl(r.valor_descarga,0) as valor_descarga, 
                   r.org_logradouro, 
				   r.org_complemento, 
                   r.org_bairro, 
                   r.org_cep, 
                   r.dest_logradouro, 
				   r.dest_complemento, 
                   r.dest_bairro, 
                   r.dest_cep, 
                   r.situacao_id, 
				   r.data_inicio_carga, 
                   r.data_termino_carga, 
                   r.data_inicio_descarga, 
                   r.data_termino_descarga, 
                   r.observacao, 
                   r.data_destinado, 
                   rhv.placa_referencia, 
                   rhv.placa_controle,
				   oper.pkg_veiculo.fnc_get_composicao(rhv.placa_controle) as composicao,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(rhv.placa_controle) as veiculo_proprietario,
				   r.placa_referencia, r.cod_pessoa_filial,					
				   case 
				      when exists (select 0
                                     from logistica.v$operacao_filial_emissao lsd
                                    inner join oper.v$romaneio_item ri 
                                       on ri.operacao_id = lsd.operacao_id
                                    where ri.num_romaneio = r.num_romaneio
									  and lsd.cod_organograma = '#session.cod_organograma#') then 1
					 else 0 end permitido_filial,
					 (select count(*) 
					    from oper.v$romaneio_item ri
					   where ri.num_romaneio = r.num_romaneio) as num_entregas,
				   (select count(*)
                        from oper.v$romaneio_item rit
                       inner join logistica.v$operacao o
                          on o.operacao_id = rit.operacao_id
                         and o.internacional = 1
                       where rit.num_romaneio = r.num_romaneio) as possui_internacional
			  from oper.v$romaneio r
			  inner join oper.v$romaneio_hist_veiculo rhv
				on r.num_romaneio = rhv.num_romaneio    	           
			  left join oper.v$natureza n
				on r.num_natureza = n.num_natureza
			 where 1 = 1 
			 	and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate)) 
												      from oper.v$romaneio_hist_veiculo rhv2
													 where rhv2.num_romaneio = rhv.num_romaneio)
			 <cfif Len(Trim(arguments.num_romaneio))>
				and r.num_romaneio = #arguments.num_romaneio#
			 <cfelse>
			 	<cfif Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
				   and to_date('#arguments.data#','dd/mm/yyyy hh24:mi') between rhv.data_inicio and nvl(rhv.data_termino,sysdate)
			   <cfelseif not Len(Trim(arguments.data)) and Len(Trim(arguments.placa_referencia)) and Len(Trim(arguments.placa_controle))>
			       and rhv.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
				   and rhv.placa_controle = '#Replace(arguments.placa_controle,'-','')#'
				   and nvl(rhv.data_termino,sysdate) = (select max(nvl(rhv2.data_termino,sysdate)) 
														  from oper.v$romaneio_hist_veiculo rhv2 
														   where rhv2.placa_referencia = '#Replace(arguments.placa_referencia,'-','')#'    
															 and rhv2.placa_controle = '#Replace(arguments.placa_controle,'-','')#')
															 
			   </cfif>
			 </cfif>	             		 			 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPÓSITO
	-- Executa todos os calculos do CTRC levando em consideração as regras fiscais
	-- guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name='calcula_ctrc' displayname='Executa todos os calculos do CTRC levando em considera??o as regras fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes' >
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='AD_VALOREM' required='no' default="0">
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_CLIENTE_COBRANCA' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
		<cfargument name='REGRA_FISCAL_ID' required='no' default="1">
		<cfargument name='COLETA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='SEM_ICMS' required='no' default="0">
            <cfstoredproc procedure='fiscal.prc_calcula_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
 			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#' variable='retorno.PESO'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#' variable='retorno.DESPACHO'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#' variable='retorno.SEC_CAT'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#' variable='retorno.GRIS'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#' variable='retorno.PEDAGIO'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#' variable='retorno.NUM_PRODUTO'>>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGO_POR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
			
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#' variable='retorno.COLETA_ENTREGA' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='COLETA_UF'  value='#arguments.COLETA_UF#'  null='#iif(len(trim(arguments.COLETA_UF)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='ENTREGA_UF' value='#arguments.ENTREGA_UF#'  null='#iif(len(trim(arguments.ENTREGA_UF)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MERCADORIA' value='#arguments.VALOR_MERCADORIA#' null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AD_VALOREM' value='#arguments.AD_VALOREM#' null='#iif(len(trim(arguments.AD_VALOREM)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#' variable='retorno.FRETE_UNITARIO' null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR' variable='retorno.FRETE_VALOR'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO' variable='retorno.FRETE_PESO'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO' variable='retorno.TOTAL_CONHECIMENTO' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS' variable='retorno.BASE_CALCULO_ICMS' >
			
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS' variable='retorno.ALIQUOTA_ICMS' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS' variable='retorno.VALOR_ICMS' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT' variable='retorno.VALOR_ICMS_SUBSTIT' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE' value='#arguments.COD_REMETENTE#' null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COD_UNIDADE' value='#arguments.COD_UNIDADE#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_REGRA_FISCAL_ID' value='#arguments.regra_fiscal_id#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COB_UF' value='#arguments.COB_UF#'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID' value='#arguments.COLETA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID' value='#arguments.ENTREGA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE' value='#arguments.NUM_LOTE#' null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEM_ICMS' value='#arguments.SEM_ICMS#' null='#iif(len(trim(arguments.SEM_ICMS)), de('no'), de('yes'))#'>
		    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA' value='#arguments.COD_CLIENTE_COBRANCA#' null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'> 
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_FILIAL' value='#arguments.UF_EMITENTE#'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP' variable='retorno.CFOP' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID' variable='retorno.CFOP_ID' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO' variable='retorno.NATUREZA_OPERACAO' >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL' variable='retorno.FUNDAMENTACAO_LEGAL' >
		</cfstoredproc>
		<cfif not Len(Trim(retorno.FRETE_UNITARIO))>
			<cfset retorno.FRETE_UNITARIO = 0>
		</cfif>		
		<cfreturn retorno/>
	</cffunction>			

	<!--- 
	-- PROPÓSITO 
	-- Busca dados do adiantamento para o agregado
	-- NOTAS EXPLICATIVAS
	-- GUTO 25/10/2006
	--->
	<cffunction name="get_agregado_romaneio" displayname="Busca o romaneio aberto para o veículo" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="" />
		<cfargument name="conhecimento_id" required="no" default="" />
		<cfargument name="manifesto_id" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select pj.nome_fantasia as filial,
 					   r.num_romaneio, c.num_conhecimento, c.serie, ar.data_lancamento as data_emissao, 
					   to_char(ar.data_lancamento,'dd/mm/yyyy') as data_emissao_char, 
					   round((sysdate - ar.data_lancamento) *24) as tempo_emissao,
              		   r.cliente as rem_razao_social, 
					   m.municipio rem_municipio, m.uf_id as rem_uf,
					   r.destinatario as dest_razao_social, 
		               md.municipio as dest_municipio, md.uf_id as dest_uf,					   
					   ar.pedagio + nvl(ar.pedagio_semparar,0) as pedagio, ar.despesa,
					   nvl(ar.soma_despesa,1) as soma_despesa ,nvl(ar.soma_pedagio,0) as soma_pedagio,
					   case
						when ar.soma_pedagio = 1 and ar.soma_despesa = 1 then ar.adiantamento+nvl(ar.pedagio,0)+nvl(ar.despesa,0)
						when ar.soma_pedagio = 1 and ar.soma_despesa = 0 then ar.adiantamento+nvl(ar.pedagio,0)
						when ar.soma_pedagio = 0 and ar.soma_despesa = 1 then ar.adiantamento+nvl(ar.despesa,0)
						when ar.soma_pedagio = 0 and ar.soma_despesa = 0 then ar.adiantamento 
					   end adiantamento, 
					   ar.valor_servico, ar.valor_liquido,
					   nvl(c.total_conhecimento,r.frete_total) as total_conhecimento, ar.placa,
					   pjp.razao_social prop_razao_social, pjp.cnpj_cpf as prop_cnpj_cpf, 
               		   pm.cliente nome_motorista, pm.cnpj_cpf as cpf_motorista, 
						oper.fnc_get_cod_veiculo(ar.placa) as frota,
						   (select fnc_concat_all(to_concat_expr(to_char(c2.num_conhecimento), '/'))
						 	 from oper.v$conhecimento c2
						 	 where c2.num_romaneio = c.num_romaneio) as conhecimentos_viagem,
						   finan.pkg_financeiro.fnc_extenso( case
            when ar.soma_pedagio = 1 and ar.soma_despesa = 1 then ar.adiantamento+nvl(ar.pedagio,0)+nvl(ar.despesa,0)
            when ar.soma_pedagio = 1 and ar.soma_despesa = 0 then ar.adiantamento+nvl(ar.pedagio,0)
            when ar.soma_pedagio = 0 and ar.soma_despesa = 1 then ar.adiantamento+nvl(ar.despesa,0)
            when ar.soma_pedagio = 0 and ar.soma_despesa = 0 then ar.adiantamento 
             end ) as valor_extenso,
						   nvl(ar.inss_retido,0) as inss_retido, nvl(ar.inss_outras_fontes,0) as inss_outras_fontes, 
						   ar.valor_servico + nvl(ar.pedagio_semparar,0), ar.pedagio_semparar,
						   ar.valor_liquido + nvl(ar.pedagio_semparar,0), nvl(ar.irrf,0) as irrf,
						   nvl(ar.sest_senat,0) as sest_senat, ar.observacao,
						   substr(pj.cnpj_ordem, 4, 2) || '/' || nvl(c.serie,'Int') as serie, ar.ps_id
				  from oper.v$agregado_romaneio ar
				 inner join oper.v$romaneio r 
						 on r.num_romaneio = ar.num_romaneio
				 left join cep.municipio m
						 on m.municipio_id = r.org_municipio_id 
						 left join oper.v$pessoa_juridica pj
									 on pj.cod_pessoa = nvl(m.cod_pessoa_un,1)
				 left join oper.v$pessoa pjp
						 on pjp.cod_pessoa = ar.cod_pessoa
				 left join oper.v$pessoa pm
						 on pm.cod_pessoa = ar.cod_pessoa_motorista
				 left join cep.municipio md
						 on md.municipio_id = r.dest_municipio_id
						 left join oper.v$conhecimento c
									on c.num_romaneio = ar.num_romaneio
								  and c.conhecimento_id = ar.conhecimento_id				 
				  where ar.data_cancelamento is null
				<cfif Len(Trim(arguments.num_romaneio))>
					and ar.num_romaneio = #arguments.num_romaneio#
				 </cfif>
				 <cfif Len(Trim(arguments.conhecimento_id))>
					and c.conhecimento_id = #arguments.conhecimento_id#
				 </cfif>
			</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca Carta frete de um conhecimento(Quando Existente)
	-- NOTAS EXPLICATIVAS
	-- GUTO 25/10/2006
	--->
	<cffunction name="get_carta_frete_conhecimento" displayname="Busca Carta frete de um conhecimento(Quando Existente)" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes"/>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select lancto_id, num_romaneio, data_emissao, remetente, origem,destinatario, 
					 destino,proprietario,placa_referencia,placa_controle,
					 prop_municipio, proprietario_cnpj_cpf, 
					 peso, valor_frete_bruto, valor_carga_descarga,
                valor_frete_liquido + valor_pedagio + valor_carga_descarga as total_servico, irrf,
                consulta_cadastro, adiantamento, inss, valor_frete_liquido,
                faltas_avarias, observacao, peso_pagar, peso_ton,
                canhoto_nota, comprovante_entrega, despacho_transporte,
                sest_senat, adto_pedagio + adiantamento as total_adiantamento, valor_pedagio, 
					 valor_carga_descarga, adto_pedagio, adto_combustivel,
                (valor_frete_liquido + valor_pedagio + valor_carga_descarga) - adiantamento - adto_pedagio - sest_senat - inss - irrf - adto_combustivel as total_a_pagar
				from (
				select distinct lancto_id, nvl(ct.num_romaneio,0) as num_romaneio, 
								ct.data_emissao, remetente, origem,destinatario, 
								destino,proprietario,placa_referencia,placa_controle,
								prop_municipio,oper.pkg_global.fnc_mascara_cnpj_cpf(proprietario_cod_pessoa) as proprietario_cnpj_cpf, 
								ct.peso, valor_frete_bruto, 
								nvl((select sum(valor) 
														from oper.v$contrato_transp_item cti
													where cti.lancto_id = ct.lancto_id
													 and cti.item_id = 8),0) as valor_carga_descarga,
								nvl((select sum(valor) 
														from oper.v$contrato_transp_item cti
													where cti.lancto_id = ct.lancto_id
													 and cti.item_id = 1),0) as valor_pedagio,
							   nvl((select sum(valor) 
												from oper.v$contrato_transp_item cti
											  where cti.lancto_id = ct.lancto_id
												and cti.item_id = 20),0) as irrf,
								 0 as consulta_cadastro,
								 nvl((select sum(valor) 
								   			from oper.v$contrato_transp_item cti
											 where cti.lancto_id = ct.lancto_id
												and cti.item_id = 7),0) as adiantamento,
								 nvl((select sum(valor) 
								   			from oper.v$contrato_transp_item cti
											 where cti.lancto_id = ct.lancto_id
												and cti.item_id = 4),0) as adto_pedagio, 
								 nvl((select sum(valor) 
								   			from oper.v$contrato_transp_item cti
											 where cti.lancto_id = ct.lancto_id
												and cti.item_id = 2),0) as adto_combustivel, 
			                nvl((select sum(valor) 
														from oper.v$contrato_transp_item cti
													where cti.lancto_id = ct.lancto_id
													 and cti.item_id in (23,24)),0) as sest_senat, 
								nvl((select sum(valor) 
  									 	 from oper.v$contrato_transp_item cti
  										where cti.lancto_id = ct.lancto_id
  									    and cti.item_id = 21),0) as inss,
								valor_frete_liquido,
								nvl((select sum(valor) 
  									 	 from oper.v$contrato_transp_item cti
  										where cti.lancto_id = ct.lancto_id
  									    and cti.item_id = 6),0) as faltas_avarias,
								ct.observacao,
								ct.valor_unitario as peso_pagar,
								oper.pkg_operacional.fnc_converte_peso(ct.peso,ct.cod_unidade,'Kg')/1000 as peso_ton,
								decode((select t.DOCUMENTO_ID
												  from oper.v$lote_documento t
											inner join oper.v$lote l 
											on l.NUM_LOTE = t.NUM_LOTE
											inner join oper.v$romaneio_item ri
											on ri.NUM_LOTE = l.NUM_LOTE
												 where  ri.NUM_ROMANEIO = ct.num_romaneio
													and t.documento_id = 3
													and rownum = 1),'','','X') as canhoto_nota
									,decode((select t.DOCUMENTO_ID
												  from oper.v$lote_documento t
											inner join oper.v$lote l 
											on l.NUM_LOTE = t.NUM_LOTE
											inner join oper.v$romaneio_item ri
											on ri.NUM_LOTE = l.NUM_LOTE
												 where  ri.NUM_ROMANEIO = ct.num_romaneio
													and t.documento_id = 2
													and rownum = 1),'','','X') as comprovante_entrega
									,decode((select t.DOCUMENTO_ID
												  from oper.v$lote_documento t
											inner join oper.v$lote l
											on l.NUM_LOTE = t.NUM_LOTE
											inner join oper.v$romaneio_item ri
											on ri.NUM_LOTE = l.NUM_LOTE
												 where  ri.NUM_ROMANEIO = ct.num_romaneio
													and t.documento_id = 2
													and rownum = 1),'','','X') as despacho_transporte
																 
							from oper.v$contrato_transporte ct
					 inner join oper.v$conhecimento c
								on (c.num_romaneio = ct.num_romaneio or
								    c.conhecimento_id = ct.conhecimento_id)
					 where c.conhecimento_id = #arguments.conhecimento_id#
						and c.num_conhecimento = ct.num_formulario)
				</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_unidade_conversao" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select umc.cod_unidade, umc.cod_unidade_eq, umc.equivalencia
			  from fiscal.v$unidade_medida_conversao umc
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPÓSITO 
	-- Busca unidades de medida
	-- NOTAS EXPLICATIVAS
	-- ANDERSONC 20/04/2009
	--->
	<cffunction name="get_unidade" displayname="Busca unidades de medida" access="remote" returntype="query" output="false">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select u.cod_unidade
            	 , u.unidade
                 , u.cod_grupo_umedida
                 , u.valor_em
                 , nvl((select uc.equivalencia
                      from fiscal.v$unidade_medida_conversao uc
                     where uc.cod_unidade = u.cod_unidade
                       and uc.cod_unidade_eq = 'Kg'),1) as equivalencia_kg
			  from fiscal.v$unidade_medida u
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<cffunction name="print_conhecimento_rodomar" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="yes" displayname="Identificador do sistema para o conhecimento" >
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
			 select c.num_conhecimento,c.natureza_operacao as natureza_operacao
		            ,c.cfop,trunc(c.data_emissao) as data_emissao
					,to_char(c.data_emissao, 'HH24:MI:SS') as hora_emissao
					,to_char((select cod_unidade_negocio
						  	   from kss.v$unidade_negocio 
						 	  where cod_pessoa = c.cod_pessoa_filial),'00') || '/' || c.serie as serie
					--cabecalho
					,en.logradouro || ' ' || en.numero || chr(13) || 'Fone: ' || t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero ||
					chr(13) || 'CEP: ' || en.cep || chr(13) ||'CNPJ: ' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) ||
					chr(13) ||'I.E.: ' || pj.inscricao_estadual as cabecalho
					--cabecalho_internet
					,en.logradouro || ' ' || en.numero || chr(13) as cabecalho_endereco
   				    ,'Fone: ' || t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero as cabecalho_telefone
					,'CEP: ' || en.cep as cabecalho_cep
					,'CNPJ: ' || oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as cabecalho_cnpj
					,'I.E.: ' || pj.inscricao_estadual as cabecalho_ie
					-- emitente
					,pj.razao_social as emit_razao_social
					,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_pessoa_filial) as emit_cnpj
					,pj.inscricao_estadual as emit_inscricao_estadual
					,en.logradouro || ' ' || en.numero as emit_endereco
					,en.municipio as emit_municipio
					,en.cep as emit_cep
					,t.fone_ddd || '-' || t.fone_prefixo || t.fone_numero as emit_telefone
					-- remetente
					,c.rem_razao_social,c.rem_endereco,c.rem_municipio
					,c.rem_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente) as rem_cnpj_cpf
					,c.rem_inscricao_estadual
					-- destinatario
					,c.dest_razao_social,c.dest_endereco,c.dest_municipio
					,c.dest_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario) as dest_cnpj_cpf
					,c.dest_inscricao_estadual
					-- consignatário
					,c.cons_razao_social,c.cons_endereco,c.cons_municipio
					,c.cons_uf,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_CONSIGNATARIO) as cons_cnpj_cpf
					,decode(c.pagador, 0, 'X', '') as cons_pago
					,decode(c.pagador, 1, 'X', '') as cons_apagar
					,(select m.uf_id
					    from cep.municipio m
					   where upper(m.municipio) like upper(c.cons_municipio)
						 and rownum = 1) as cons_calculado_ate
					-- redespacho
					,c.red_razao_social,c.red_endereco,c.red_municipio
					,c.red_uf,c.red_cnpj_cpf,'' as red_pago,'' as red_apagar
					,c.serie || ' ' || c.num_conhecimento as red_num_conhec
					,c.placa_tracao
					--local coleta
					,col.municipio as coleta_municipio
					,col.uf_id as coleta_uf
					--local entrega
				    ,ent.municipio as entrega_municipio
				    ,ent.uf_id as entrega_uf
					,c.entrega_logradouro as entrega_logradouro
					-- cobrança     
					,c.cob_razao_social
					,c.cob_endereco
					,c.cob_municipio
					,c.cob_uf
					,c.cob_cnpj_cpf
					-- mercadorias transportadas
					,n.descricao as natureza_carga
					,fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal
					,e.descricao as especie ,c.volume as quantidade
					,c.peso as peso_cobrar
					,nvl((select sum(oper.pkg_operacional.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg'))
             				from fiscal.v$conhecimento_nota_fiscal cnf
            			   where cnf.conhecimento_id = c.conhecimento_id),0) as peso_kg_nf
					,'' as m3_l
					,(select sum(nf.valor_total)
						from fiscal.v$conhecimento_nota_fiscal nf
					   where nf.conhecimento_id = c.conhecimento_id) as valor_nf
					,(select sum(nf.valor_segurado)
					  	from fiscal.v$conhecimento_nota_fiscal nf
					   where nf.conhecimento_id = c.conhecimento_id) as valor_nf_segurado
					, decode(c.conhecimento_id_sub_contr,'','',c.num_conhecimento_sub_contr || '/' || c.serie_conhecimento_sub_contr,(select to_char(substr(pj1.cnpj_ordem,3,2)) || '/' || c1.serie || ' ' || c1.num_conhecimento
                                                     from fiscal.v$conhecimento c1
                                                     inner join kss.v$pessoa_juridica pj1
				                                                     on pj1.cod_pessoa = c1.cod_pessoa_filial
                                                     where c1.conhecimento_id = c.conhecimento_id_sub_contr
                                                     )) as num_conhec_subcontr
					-- veículo transportador
					,c.prop_razao_social,oper.pkg_global.fnc_mascara_cnpj_cpf(c.COD_PROPRIETARIO) as prop_cnpj_cpf
					,c.placa as placa_sr
					,(select vc.placa_1
						from oper.v$veiculo_composicao vc
					   where vc.placa_2 = c.placa
						 and c.data_emissao between vc.data_hora_engate and nvl(vc.data_hora_desengate,sysdate)
						 and rownum = 1) as placa_veiculo
					-- composição do frete
					,c.frete_peso,c.frete_valor,c.sec_cat,c.despacho,c.pedagio
					,c.gris as seguro,c.coleta_entrega as outros,c.total_conhecimento as total_frete
					,c.base_calculo_icms as base_calculo
					,c.st_icms_id
					,c.aliquota_icms as aliquota
					,c.valor_icms
					,c.valor_icms_substit
					,c.observacao
					,(select decode(sum(nfc.altura),'','','('||sum(nfc.altura)||'X'|| sum(nfc.largura)||'X'||sum(nfc.comprimento)||')')
                   		from fiscal.v$conhecimento_nota_fiscal nfc
                       where nfc.conhecimento_id = c.conhecimento_id) as observacao_cubagem
					,(select (sum(nfc.altura)*sum(nfc.largura)*sum(nfc.comprimento))
          				from fiscal.v$conhecimento_nota_fiscal nfc
         			   where nfc.conhecimento_id = c.conhecimento_id) as cubagem
					,(select kss.fnc_concat_all(to_concat_expr(to_char(nfc.ordem_compra_cliente), '/'))
                   		from fiscal.v$conhecimento_nota_fiscal nfc
                       where nfc.conhecimento_id = c.conhecimento_id) as ordem_compra
					,to_char(c.prazo_entrega,'dd/mm/yyyy hh24:mi') as prazo_entrega
					,c.num_produto
					,c.BASE_CALCULO_ISS
					,c.ALIQUOTA_ISS
					,c.VALOR_ISS
					,c.regra_fiscal_id
			   from fiscal.v$conhecimento c
		 inner join kss.v$pessoa_juridica pj
				 on pj.cod_pessoa = c.cod_pessoa_filial
      left join cep.municipio col
             on col.municipio_id = c.coleta_municipio_id
      left join cep.municipio ent
             on ent.municipio_id = c.entrega_municipio_id
		  left join kss.v$pessoa_endereco en
				 on en.endereco_padrao = 1
				and en.cod_pessoa = c.cod_pessoa_filial
		  left join kss.v$pessoa_telefone tel
				 on tel.telefone_padrao = 1
				and tel.cod_pessoa = c.cod_pessoa_filial
		  left join kss.v$telefone t
				 on t.telefone_id = tel.telefone_id
		  left join fiscal.v$natureza n
				 on c.num_natureza = n.num_natureza
		  left join fiscal.v$especie e
				 on c.num_especie = e.num_especie		 
			  where c.conhecimento_id = #arguments.conhecimento_id#
		   order by c.data_emissao
  	</cfquery>
		<cfreturn qr_conhecimento>
	</cffunction>		

	<!--- 
	-- PROPÓSITO 
	-- Busca relações de complemento em aberto
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_relacao_aberto" displayname="Busca relações de complemento em aberto" access="remote" returntype="query" output="true">
	<cfargument name="conhecimento_romaneios" displayname="FLAG Conhecimento ou Romaneio, 0 - CTRC. 1 - Romaneio" required="no" default="0">
	<cfargument name="relacao_id" required="no" default="" />
	<cfargument name="pagador" required="no" default="" />
	<cfargument name="todas" displayname="FLAG que indica a consulta por todas as relações" required="no" />
		<cfquery datasource="#session.dsn#" name="qr_relacao_complemento" username="#session.usuario#" password="#session.senha#">
			<cfif arguments.conhecimento_romaneios eq 0>
				select /*+ FIRST_ROWS */ 
					   cc.relacao_id, 
					   cc.conhecimento_id, 
					   decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) as pagador,
					   decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social) as razao_social, 
					   decode(c.pagador,0,oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_remetente),oper.pkg_global.fnc_mascara_cnpj_cpf(c.cod_destinatario)) as cnpj_cpf, 
					   c.num_conhecimento, c.cod_unidade, cc.cod_unidade as cod_unidade_complemento,
					   oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade) as peso_lancado, 
					   oper.pkg_operacional.fnc_converte_peso(c.peso+cc.peso,'Kg',c.cod_unidade) as peso_correto, 
					   cc.volume, 
					   cc.m3, 
					   c.frete_unitario as unit_lancado, 
					   cc.valor_unitario as unit_correto, 
					   c.frete_valor as frete_lancado, 
					   cc.valor_frete_liquido + c.frete_valor as frete_correto, 
					   cc.valor_frete_liquido as diferenca, 
					   cc.cod_unidade, 
					   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,
					   c.cod_pessoa_filial, 
					   c.cod_setor, 
					   decode(cc.situacao,1,'Fechada','Aberta') as situacao
				  from oper.v$conhecimento_complemento cc
				 inner join oper.v$conhecimento c
					on cc.conhecimento_id = c.conhecimento_id
				 where 1=1
				 <cfif not isDefined("arguments.todas")>
  		          and cc.situacao = 0
				 </cfif> 
				 <cfif Len(Trim(arguments.RELACAO_ID))>
  		           and cc.relacao_id = #arguments.RELACAO_ID#
				 </cfif> 
				 <cfif Len(Trim(arguments.pagador))>
				   and decode(c.pagador,0,c.cod_remetente,c.cod_destinatario) = #arguments.pagador#
				 </cfif>
				order by pagador, cc.relacao_id  
          <cfelse>
				select /*+ FIRST_ROWS */ c.conhecimento_id, r.num_romaneio, cc.relacao_id, avg(c.frete_unitario) as unit_lancado, avg(cc.valor_unitario) as unit_correto,
					   sum(oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade)) as peso_lancado, 
					   sum(oper.pkg_operacional.fnc_converte_peso(c.peso,'Kg',c.cod_unidade)) + sum(oper.pkg_operacional.fnc_converte_peso(cc.peso,'Kg',cc.cod_unidade)) as peso_correto,
					   sum(c.total_conhecimento) as frete_lancado, sum(c.total_conhecimento) + sum(cc.valor_frete) as frete_correto,
					   sum(cc.valor_frete_liquido) as diferenca, oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as num_nota_fiscal,  
					   decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social) as razao_social,
					   c.cod_pessoa_filial, c.cod_setor,  cc.cod_unidade as cod_unidade_complemento, c.cod_unidade,
					   decode(cc.situacao,1,'Fechada','Aberta') as situacao
 			      from oper.v$conhecimento_complemento cc
			     inner join oper.v$conhecimento c       
					     on cc.conhecimento_id = c.conhecimento_id
				inner join oper.v$romaneio r
				  on r.num_romaneio = c.num_romaneio
				 where 1=1
				 <cfif not isDefined("arguments.todas")>
			       and cc.situacao = 0
				 </cfif> 
				 <cfif Len(Trim(arguments.relacao_id))>
				   and cc.relacao_id = #arguments.relacao_id#
				 </cfif>
			  group by r.num_romaneio, c.conhecimento_id, 
			  		   cc.relacao_id,decode(c.pagador,0,c.rem_razao_social,c.dest_razao_social),
			  		   oper.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id), c.cod_pessoa_filial, c.cod_setor, decode(cc.situacao,1,'Fechada','Aberta')
					order by cc.relacao_id  
		  </cfif>
		</cfquery> 
		<cfreturn qr_relacao_complemento>
	</cffunction>

<!--- 
	-- PROPÓSITO
	-- Busca os lotes que estão aberto para as agências
	-- Guto 11/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_lote_aberto_agencia" displayname="Busca os lotes que estão aberto para as agências" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lotes" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ l.num_lote, l.data_inicio_retirada, l.data_prazo_retirada, l.data_contrato, l.num_natureza, 
				   n.descricao as natureza, l.num_especie, e.descricao as especie, 
				   oper.pkg_operacional.fnc_converte_peso(l.peso,'Kg',l.cod_unidade) as peso, l.volume, 
				   l.m3, l.frete_em, l.cod_unidade, l.qtde_viagem, 
				   l.frete_proprio, l.frete_valor_unitario, l.frete_valor, l.frete_por_conta, 
				   l.num_produto, l.situacao_tributaria, l.aliquota_icms, l.reducao_base_calculo, 
				   l.icms_incluso, l.destaca_base_calc_icms, 
				   l.fundamentacao_legal, 
				   rem.razao_social as remetente, rem.municipio as rem_municipio, rem.uf as rem_uf, rem.codigo as cnpj_cpf_remetente, dest.codigo as cnpj_cpf_destinatario,
				   dest.razao_social as destinatario, dest.municipio as dest_municipio, dest.uf as dest_uf, 
				   decode(l.cod_pessoa_destinatario,null,0,1) as lote_com_destinatario,
				   l.cod_pessoa_remetente, l.cod_pessoa_destinatario, l.coleta_logradouro, 
				   l.coleta_complemento, l.coleta_bairro, l.coleta_cep, l.coleta_cod_uf, 
				   l.coleta_cod_municipio, l.coleta_cod_dv, l.coleta_cod_distrito, l.entrega_logradouro, 
				   l.entrega_complemento, l.entrega_cep, l.entrega_bairro, l.entrega_cod_uf, 
				   l.entrega_cod_municipio, l.entrega_cod_distrito, l.entrega_cod_dv, l.controle_peso, 
				   l.controle_peso_veiculo, l.situacao_id, l.observacao, l.negociado_por, 
				   l.controle_viagem, l.observacao_emitente, l.pedagio_incluso,
				   decode(l.frete_por_conta,0,rem.cod_atividade_fiscal,dest.cod_atividade_fiscal) as cod_atividade_fiscal,
				   0 as peso_carregado,
				   decode(ld.imprime_conhecimento,1,ld.observacao,'') as rodape,
    		      l.num_produto, p.descricao as produto
			  from oper.v$lote l 
	       inner join oper.v$produto p
               on p.produto_id = l.num_produto
			 inner join oper.v$natureza n
			   on l.num_natureza = n.num_natureza
			 inner join oper.v$especie e 
			   on l.num_especie = e.num_especie
			 inner join oper.v$remetente_destinatario rem
				on rem.cod_pessoa = l.cod_pessoa_remetente
			 left outer join oper.v$remetente_destinatario dest
				on dest.cod_pessoa = l.cod_pessoa_destinatario
			 left outer join oper.v$lote_descarga ld
			   on l.num_lote = ld.num_lote				
 			 where l.situacao_id = 1
			  and (exists (select 'x' 
						   from oper.v$kss_usuario_lotacao u
								where l.cod_pessoa_filial = u.cod_pessoa
								  and l.cod_departamento = u.cod_departamento
								  and l.cod_setor	     = u.cod_setor
								  and u.cod_aplicacao = 'EMISSAO_DOCUMENTO'
								  )
				  or
				   exists (select 'x' 
							  from oper.v$kss_usuario_lotacao u2
							 inner join oper.v$lote_setor_compto lac
								on lac.cod_pessoa_filial = u2.cod_pessoa
								   and lac.cod_departamento = u2.cod_departamento
								   and lac.cod_setor        = u2.cod_setor
								 where lac.num_lote = l.num_lote))          
		</cfquery>
		<cfreturn qr_lotes>
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca os dados gerais do conhecimento
	-- CRISTOFER  06/12/2006
	--->		
	<cffunction name="get_conhecimento_dados" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="serie" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="rem_cnpj" required="no" default="">
		<cfargument name="rem_razao_social" required="no" default="">
		<cfargument name="dest_cnpj" required="no" default="">
		<cfargument name="dest_razao_social" required="no" default="">
		<cfargument name="cpf_motorista" required="no" default="">
		<cfargument name="nome_motorista" required="no" default="">
		<cfargument name="data_emissao" required="no" default="">  
        <cfargument name="lotacao" required="no" default="1">        
        <cfargument name="cod_modelo" required="no" default="08">
		<cfquery result="reslt" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.serie,
				   con.item_id,
				   con.num_romaneio,
                   p.cliente as filial,
				   con.cod_pessoa_filial,
				   con.cod_departamento,
				   con.cod_setor,
				   con.cod_centro_custo,
				   con.data_emissao,
				   to_char(data_emissao,'dd/mm/yyyy hh24:mi') data_emissao_data_hora,
				   con.num_produto,
				   con.cfop_id,
				   con.cfop,
				   con.natureza_operacao,
				   trim(con.st_origem_id) as st_origem_id,
				   trim(con.st_icms_id) as st_icms_id,
				   con.pagador,
				   con.cod_remetente,
				   con.rem_razao_social,
				   con.rem_endereco,
				   con.rem_endereco_num,
				   con.rem_bairro,
				   con.rem_municipio,
       			   con.rem_municipio_id,
				   con.rem_uf,
				   to_char(con.rem_cep) as rem_cep,
				   con.rem_cnpj_cpf,
				   con.rem_inscricao_estadual,
				   con.cod_destinatario,
				   con.dest_razao_social,
				   con.dest_endereco,
				   con.dest_endereco_num,
				   con.dest_bairro,
				   con.dest_municipio,
       			   con.dest_municipio_id,
				   con.dest_uf,
				   to_char(con.dest_cep) as dest_cep,
				   con.dest_cnpj_cpf,
				   con.dest_inscricao_estadual,
				   con.cod_consignatario,
				   con.cons_razao_social,
				   con.cons_endereco,
				   con.cons_endereco_num,
				   con.cons_bairro,
				   con.cons_municipio,
       			   con.cons_municipio_id,       
				   con.cons_uf,
				   to_char(con.cons_cep) as cons_cep,
				   con.cons_cnpj_cpf,
				   con.cons_inscricao_estadual,
				   con.cod_redespacho,
				   con.red_razao_social,
				   con.red_endereco,
				   con.red_endereco_num,
				   con.red_bairro,
				   con.red_municipio,
       			   con.red_municipio_id,
				   con.red_uf,
				   to_char(con.red_cep) as red_cep,
				   con.red_cnpj_cpf,
				   con.red_inscricao_estadual,
				   con.peso,
				   con.volume,
				   con.m3,
				   con.frete_unitario,
				   con.frete_peso,
				   con.frete_valor,
				   con.despacho,
				   con.base_calculo_icms,
				   con.aliquota_icms,
				   con.ademe,
				   con.desconto,
				   con.sec_cat,
				   con.gris,
				   con.pedagio,
				   con.valor_icms,
				   con.valor_icms_substit,
				   con.coleta_entrega,
				   con.impostos,
				   con.total_conhecimento,
				   con.num_natureza,
				   con.num_especie,
				   con.cod_unidade,
                   con.coleta_cnpj_cpf,
       			   con.coleta_razao_social,
                   con.coleta_inscricao_estadual,
				   con.coleta_logradouro,
				   con.coleta_complemento,
				   con.coleta_bairro,
				   to_char(con.coleta_cep) as coleta_cep,
				   con.entrega_logradouro,
				   con.entrega_complemento,
				   con.entrega_bairro,
				   to_char(con.entrega_cep) as entrega_cep,
				   con.placa,
				   con.cod_motorista,
				   con.nome_motorista,
				   con.cod_proprietario,
				   con.prop_razao_social,
				   con.prop_cnpj_cpf,
				   con.prop_endereco,
				   con.prop_uf,
				   nvl2(con.cancelado,1,0) as situacao_id,
				   nvl2(con.impresso,1,0) as impresso,
				   nvl2(con.conferido,1,0) as conferido,
				   con.observacao,
				   con.rodape,
				   con.entrada_dados,
				   con.user_insert,
				   con.date_insert,
				   con.user_update,
				   con.date_update,
				   con.site,
				   con.coleta_municipio_id,
                   con.peso_real,
				   mc.municipio coleta_municipio,
				   mc.uf_id		coleta_uf,
				   con.entrega_municipio_id,
				   me.municipio entrega_municipio,
				   me.uf_id		entrega_uf,
				   con.cod_cliente_cobranca,
				   con.cob_razao_social,
				   con.cob_endereco,
				   con.cob_endereco_num,
				   con.cob_bairro,
				   con.cob_municipio,
                   con.cob_municipio_id,
				   con.cob_uf,
				   to_char(con.cob_cep) as cob_cep,
				   con.cob_cnpj_cpf,
				   con.cob_inscricao_estadual,
                   con.cod_negociador,
                   neg.cnpj_cpf as neg_cnpj_cpf,
                   neg.razao_social as neg_razao_social,
                   neg.inscricao_estadual as neg_inscricao_estadual,
                   neg_end.logradouro as neg_endereco,
                   neg_end.numero as neg_endereco_num,
                   neg_end.bairro as neg_bairro,
                   to_char(neg_end.cep) as neg_cep,
                   neg_end.municipio as neg_municipio,
                   neg_end.municipio_id as neg_municipio_id,
                   neg_end.uf as neg_uf,
				   to_char(con.prazo_entrega,'dd/mm/yyyy hh24:mi') as prazo_entrega,
				   to_char(con.prazo_entrega,'dd/mm/yyyy') prazo_entrega_data,
				   con.cod_organograma_gerencial,
				   con.regra_fiscal_id,
				   con.valor_iss,
				   con.base_calculo_iss,
				   con.aliquota_iss,
                   con.coleta_cod_pessoa,
                   con.entrega_cod_pessoa,
				   to_char(substr(pj.cnpj_ordem,3,2)) cnpj_ordem,
				   nvl(con.placa_tracao,substr(oper.pkg_veiculo.fnc_get_composicao(con.placa),2,instr(oper.pkg_veiculo.fnc_get_composicao(con.placa),'|',2)-2)) placa_tracao,
				   decode(con.placa_tracao,'','',oper.pkg_veiculo.fnc_veiculo_proprietario(con.placa_tracao)) proprietario_tracao,
				   p.cnpj_cpf cnpj_cpf_filial,
                   nvl2(con.cancelado,1,0) as  cancelado,
                   nvl(con.operacao_id, o.operacao_id) as operacao_id,
                   logistica.pkg_operacao.fnc_descricao_completa(nvl(con.operacao_id, o.operacao_id)) as operacao_descricao,
                   sc.valor_em as frete_em,
                   (select sign(count(1))
                      from fiscal.v$ctrc_comercial_versao ccv
                     where ccv.conhecimento_id = con.conhecimento_id) as possui_tabela_frete,
                   con.organizacional_id,
		           con.cod_organizacional
			  from fiscal.v$conhecimento con
			 inner join kss.v$pessoa p
			         on p.cod_pessoa = con.cod_pessoa_filial
			 inner join cep.municipio mc
			         on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
			         on me.municipio_id = con.entrega_municipio_id
              left join oper.v$romaneio_item ri
                     on ri.item_id = con.item_id
              left join logistica.v$operacao o
                     on o.operacao_id = ri.operacao_id  
             left join logistica.v$viagem_carga vc
                     on ri.viagem_carga_id = vc.viagem_carga_id
             left join logistica.v$solicitacao_carga sc
                    on sc.solicitacao_carga_id = vc.solicitacao_carga_id
			 left join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = con.cod_pessoa_filial
			 left join kss.v$pessoa neg
			         on neg.cod_pessoa = con.cod_negociador
			 left join kss.v$pessoa_endereco neg_end
			         on neg_end.cod_pessoa = con.cod_negociador
           and neg_end.endereco_padrao = 1 
			 where 1=1
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif> 
			 <cfif len(trim(arguments.serie))>
			   and con.serie  = '#arguments.serie#'
			 </cfif> 
			 <cfif len(trim(arguments.cod_pessoa_filial)) && (arguments.lotacao neq 0)>
			   and con.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif> 
			 <cfif len(trim(arguments.conhecimento_id))>
			   and con.conhecimento_id in (#arguments.conhecimento_id#)
			 </cfif> 
			 <cfif len(trim(arguments.rem_cnpj))>
			   and con.rem_cnpj_cpf = '#arguments.rem_cnpj#'
			 </cfif> 
			 <cfif len(trim(arguments.rem_razao_social))>
			   and upper(con.rem_razao_social) like upper('%#arguments.rem_razao_social#%')
			 </cfif> 
			 <cfif len(trim(arguments.dest_cnpj))>
			   and con.dest_cnpj_cpf = '#arguments.dest_cnpj#'
			 </cfif> 
			 <cfif len(trim(arguments.dest_razao_social))>
			   and upper(con.dest_razao_social) like upper('%#arguments.dest_razao_social#%')
			 </cfif> 
			 <cfif len(trim(arguments.data_emissao))>
			   and trunc(con.data_emissao) = '#arguments.data_emissao#'
			 </cfif> 
               and con.modelo_documento = '#arguments.cod_modelo#'
			 order by con.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  06/12/2006
	--->		
	<cffunction name="get_conhecimento_nota_fiscal" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cnf.conhecimento_id,
				   cnf.numero,
				   cnf.data_emissao,
				   to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data,
				   cnf.modelo,
				   cnf.serie,
				   cnf.sub_serie,
				   cnf.valor_total,
				   cnf.user_insert,
				   cnf.date_insert,
				   cnf.user_update,
				   cnf.date_update,
				   cnf.site,
				   cnf.valor_segurado,
				   cnf.ordem_compra_cliente,
				   cnf.peso,
				   to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido,
				   cnf.peso_cubado,
				   cnf.peso_cobrado,
				   nvl(cnf.qtde_volume,1) as qtde_volume,
				   cnf.altura,
				   cnf.comprimento,
				   cnf.largura,
				   cnf.m3,
				   cnf.cubagem,
				   cnf.num_natureza,
				   nat.descricao natureza,
				   cnf.complemento,
				   cnf.num_especie,
				   esp.descricao especie,
				   cnf.cod_unidade,
				   cnf.premio_seguro_rctrc,
				   cnf.premio_seguro_rcfdc,
				   cnf.premio_seguro_rr,
                   (select cc.carga_id
                      from oper.v$carga_ctrc cc
                     where cc.conhecimento_id = cnf.conhecimento_id
                       and cc.num_nota_id = cnf.numero) as carga_id ,
                   cnf.cfop,
                   cnf.chave_acesso_nfe,
                   cnf.tipo_documento_id,
                   cnf.descricao_docto,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_emitente,
                   extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/emit/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as emitente,
                   kss.pkg_string.fnc_formata_cnpj_cpf(nvl(extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/CNPJ','xmlns="http://www.portalfiscal.inf.br/nfe"')
                                                          ,extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/CPF','xmlns="http://www.portalfiscal.inf.br/nfe"'))) as cnpj_destinatario,
                   extractvalue(xmltype.createxml(cnf.nfe_xml),'//NFe/infNFe/dest/xNome','xmlns="http://www.portalfiscal.inf.br/nfe"') as destinatario
			  from fiscal.v$conhecimento_nota_fiscal cnf
			  left join oper.v$especie esp
					 on esp.num_especie = cnf.num_especie
			  left join oper.v$natureza nat
					 on nat.num_natureza = cnf.num_natureza
			 where 1=1
			   and cnf.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		   
	<!--- 
	-- PROPÓSITO 
	-- Busca as filiais cadastradas
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_filial" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct t.cod_pessoa, p.cliente filial, p.cliente as nome
			  from kss.v$organograma t
			 inner join kss.v$pessoa p 
					 on p.cod_pessoa = t.cod_pessoa
	         order by p.cliente
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
		 
	<!--- 
	-- PROPÓSITO 
	-- Busca os conheicmentos sem romaneio
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_ctrc_sem_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id,
				   c.data_emissao,
				   c.num_conhecimento,
				   c.serie,
				   c.cod_pessoa_filial,
				   c.rem_razao_social,
				   c.dest_razao_social
			  from fiscal.v$conhecimento c
			 where c.num_romaneio is null
			   and not exists (select 0
								 from oper.v$manifesto_conhecimento mc
								where mc.conhecimento_id = c.conhecimento_id)
			<cfif len(trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial in (#arguments.cod_pessoa_filial#)
			</cfif>
			<cfif len(trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#'
			</cfif>
			<cfif len(trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#'
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
					
	<!--- 
	-- PROPÓSITO 
	-- Busca os items de romaneio que não possuem conhecimento
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_roo_item_aberto" access="remote" returntype="query" output="true">
		<cfargument name="frota" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio,
				   ri.num_lote,
				   ri.item_id,
				   r.placa_controle,
				   ri.cod_remetente,
				   nvl(rem.razao_social,rem.cliente) rem_razao_social,
				   ri.rem_municipio_id,
				   cep.fnc_municipio_uf(ri.rem_municipio_id) rem_municipio_uf,
				   ri.cod_destinatario,
				   nvl(dest.razao_social,dest.cliente) dest_razao_social,
				   ri.dest_municipio_id,
				   cep.fnc_municipio_uf(ri.dest_municipio_id) dest_municipio_uf,
				   ri.peso,
				   ri.valor_frete,
				   case when not exists (select 0
								 from fiscal.v$conhecimento c
								where c.num_romaneio = ri.num_romaneio
								  and c.item_id      = ri.item_id) then 1
					else 1 end disponivel
			  from oper.v$romaneio_item ri
			 inner join oper.v$romaneio r
					 on r.num_romaneio = ri.num_romaneio
			 inner join kss.v$pessoa rem
					 on rem.cod_pessoa = ri.cod_remetente
			 left join kss.v$pessoa dest
					 on dest.cod_pessoa = ri.cod_destinatario
			 where r.situacao_id <> 2
			<cfif len(trim(arguments.frota))>
			   and (r.placa_controle = '#arguments.frota#'
			    	or 
					oper.pkg_veiculo.fnc_get_cod_veiculo('#arguments.frota#'))
			</cfif>
			<cfif len(trim(arguments.num_romaneio))>
			   and r.num_romaneio = #arguments.num_romaneio#
			</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca os romaneios com itens em aberto
	-- CRISTOFER  19/12/2006
	--->		
	<cffunction name="get_romaneio_item_aberto" access="remote" returntype="query" output="true">
		<cfargument name="frota" required="no" default="">
		<cfargument name="DATA_INICIAL" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.num_romaneio, 
				   r.placa_controle, 
				   oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) frota,
				   r.DATA_INICIO,
				   r.carregamento,
				   r.destino
			  from oper.v$romaneio r
			 where r.situacao_id = 0	
/*			   and not exists (select 0
								 from fiscal.v$conhecimento c
								inner join oper.v$romaneio_item ri 
										on c.num_romaneio = ri.num_romaneio
									   and c.item_id = ri.item_id
								where ri.num_romaneio = r.num_romaneio)
*/
			<cfif len(trim(arguments.data_inicial))>
			   and trunc(r.data_inicio) >= '#arguments.data_inicial#'
			</cfif>            								
			<cfif len(trim(arguments.data_final))>
			   and trunc(r.data_inicio) <= '#arguments.data_final#'
			</cfif>            								
			<cfif len(trim(arguments.frota))>
			   and (r.placa_controle = '#ucase(arguments.frota)#'
			    	or
					oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) = '#ucase(arguments.frota)#')
			</cfif>
			 order by r.num_romaneio 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
						
	<!--- 
	-- PROPÓSITO 
	-- Busca os dados do lote
	-- CRISTOFER  27/12/2006
	--->		
	<cffunction name="get_lote" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select l.num_lote,
				   l.cod_pessoa_filial,
				   l.cod_departamento,
				   l.cod_setor,
				   l.cod_centro_custo,
				   l.data_inicio_retirada,
				   l.data_prazo_retirada,
				   l.data_contrato,
				   l.num_natureza,
				   l.num_especie,
				   l.peso,
				   l.volume,
				   l.m3,
				   l.frete_em,
				   l.cod_unidade,
				   l.qtde_viagem,
				   l.frete_proprio,
				   l.frete_valor_unitario,
				   l.frete_valor,
				   l.frete_por_conta,
				   l.num_produto,
				   l.pedagio_incluso,
				   l.situacao_tributaria,
				   l.aliquota_icms,
				   l.reducao_base_calculo,
				   l.icms_incluso,
				   l.destaca_base_calc_icms,
				   l.fundamentacao_legal,
				   l.cod_pessoa_remetente,
				   rem.cnpj_cpf as rem_cnpj_cpf,
				   nvl(rem.razao_social,rem.cliente) rem_razao_social,
				   rem.inscricao_estadual rem_inscricao_estadual,
				   rpe.logradouro||', '||rpe.numero||' '||rpe.bairro rem_endereco,
				   rpe.cep rem_cep,
				   nvl(rpe.municipio,pe.municipio) as  rem_municipio,
				   rpe.uf rem_uf,
				   nvl(rpe.municipio_id,pe.municipio_id) as rem_municipio_id,
				   col.municipio coleta_municipio,
				   col.uf_id coleta_uf,
				   l.coleta_municipio_id,
				   l.coleta_logradouro,
				   l.coleta_complemento,
				   l.coleta_bairro,
				   l.coleta_cep,
				   
				   l.cod_pessoa_destinatario,
				   dest.cnpj_cpf as dest_cnpj_cpf,
				   nvl(dest.razao_social,dest.cliente) dest_razao_social,
				   dest.inscricao_estadual dest_inscricao_estadual,
				   dpe.logradouro||', '||dpe.numero||' '||dpe.bairro dest_endereco,
				   dpe.cep dest_cep,
				   dpe.municipio dest_municipio,
				   dpe.uf dest_uf,
				   dpe.municipio_id dest_municipio_id,
				   ent.municipio entrega_municipio,
				   ent.uf_id entrega_uf,

				   cons.cod_consignatario,
				   cons.razao_social cons_razao_social,
				   cons.cep cons_cep,
				   cons.endereco cons_endereco,
				   cons.cnpj_cpf cons_cnpj_cpf,
				   cons.inscricao_estadual cons_inscricao_estadual,
				   cons.municipio cons_municipio,
				   cons.uf cons_uf,
				   cons.municipio_id cons_municipio_id,
				   
				   cob.cod_cliente_cobranca,
				   cob.cnpj_cpf cob_cnpj_cpf,
				   cob.razao_social cob_razao_social,
				   
				   cob.inscricao_estadual cob_inscricao_estadual,
				   cob.cep cob_cep,
				   cob.endereco cob_endereco,
				   cob.municipio_id cob_municipio_id,
				   cobm.municipio cob_municipio,
				   cobm.uf_id cob_uf,

       l.cod_negociador,
       neg.cnpj_cpf as neg_cnpj_cpf,
       neg.razao_social as neg_razao_social,
       neg.inscricao_estadual as neg_inscricao_estadual,
       neg_end.logradouro || ' ' || neg_end.numero as neg_endereco,
       to_char(neg_end.cep) as neg_cep,
       neg_end.municipio as neg_municipio,
       neg_end.uf as neg_uf,       

				   l.entrega_logradouro,
				   l.entrega_complemento,
				   l.entrega_bairro,
				   l.entrega_cep,
				   l.entrega_municipio_id,
				   l.controle_peso,
				   l.controle_viagem,
				   l.controle_peso_veiculo,
				   l.situacao_id,
				   l.negociado_por,
				   l.negociado_por_telefone,
				   l.negociado_por_email,
				   l.observacao,
				   l.observacao_emitente,
				   l.user_insert,
				   l.date_insert,
				   l.user_update,
				   l.date_update,
				   l.site,
				   l.regra_fiscal_id,
				   l.seguro,
				   l.com_retorno_embalagem,
				   l.rem_envia_monitoramento,
				   l.dest_envia_monitoramento,
				   l.permite_lanctoctrc_antesmacro3,
				   l.fracionado,
				   l.internacional,
				   ls.id_seg_rctr_c,
				   ls.rcf_dc,
				   ls.responsavel_rcf_dc,
				   ls.id_seg_rcf_dc,
				   ls.exige_gerenciadora,
				   ls.cod_gerenciadora,
				   ls.exige_monitoramento,
				   ls.cod_pessoa_monitora,
				   ls.tipo_valor_mercadoria,
				   ls.valor_medio_mercadoria,
				   ls.intervalo_minuto,
				   ls.rctr_vi,
				   ls.id_seg_rctr_vi,
				   ls.observacao,
				   ls.valor_cob_rcf_dc_cliente,
				   ls.id_lote_seguro,
				   ls.num_liberacao_rctr_c,
				   ls.num_liberacao_rcf_dc,
				   ls.num_liberacao_rctr_vi,
				   pjvi.razao_social razao_social_rctr_vi,
				   ls.cod_pessoa_escolta,
				   ls.tipo_escolta,
				   ls.rr,
				   ls.id_seg_rr,
				   ls.num_liberacao_rr,
				   pjrr.razao_social razao_social_rr,
				   ger.cnpj_cpf cnpj_gerenciadora,
				   ger.razao_social razao_social_gerenciadora,
				   esc.cnpj_cpf cnpj_escolta,
				   esc.razao_social razao_social_escolta,
				   mon.cnpj_cpf cnpj_monitora,
				   mon.razao_social razao_social_monitora,
				   l.dedicado
			  from oper.v$lote l
			 inner join kss.v$pessoa rem
			         on rem.cod_pessoa = l.cod_pessoa_remetente
			 left join kss.v$pessoa_endereco rpe
			         on rpe.cod_pessoa = rem.cod_pessoa
					and rpe.endereco_padrao = 1
			 left join kss.v$pessoa_estrangeira pe
			        on pe.cod_pessoa = rem.cod_pessoa		
			 left join cep.municipio col
			         on col.municipio_id = l.coleta_municipio_id
			  left join oper.v$lote_consignatario cons
			         on cons.num_lote = l.num_lote
			  left join oper.v$lote_cliente_cobranca cob
			         on cob.num_lote = l.num_lote
			  left join cep.municipio cobm
			         on cobm.municipio_id = cob.municipio_id
 			  left join kss.v$pessoa dest
			         on dest.cod_pessoa = l.cod_pessoa_destinatario
			  left join kss.v$pessoa_endereco dpe
			         on dpe.cod_pessoa = dest.cod_pessoa
					and dpe.endereco_padrao = 1
			  left join cep.municipio ent
			         on ent.municipio_id = l.entrega_municipio_id
			  left join oper.v$lote_seguro ls
			         on ls.num_lote = l.num_lote
					 
			  left join oper.v$seg_contratado sc
			         on sc.id_seguradora = ls.id_seg_rctr_vi
			  left join kss.v$pessoa_juridica pjvi
			         on pjvi.cod_pessoa = sc.cod_seguradora

			  left join oper.v$seg_contratado scrr
			         on scrr.id_seguradora = ls.id_seg_rr
			  left join kss.v$pessoa_juridica pjrr
			         on pjrr.cod_pessoa = scrr.cod_seguradora
			  left join kss.v$pessoa ger
			         on ger.cod_pessoa = ls.cod_gerenciadora
			  left join kss.v$pessoa esc
			         on esc.cod_pessoa = ls.cod_pessoa_escolta
			  left join kss.v$pessoa mon
			         on mon.cod_pessoa = ls.cod_pessoa_monitora
			 left join kss.v$pessoa neg
			         on neg.cod_pessoa = l.cod_negociador
			 left join kss.v$pessoa_endereco neg_end
			         on neg_end.cod_pessoa = l.cod_negociador
           and neg_end.endereco_padrao = 1 
			 where 1=1
			 <cfif len(trim(arguments.num_lote))>
			   and l.num_lote in (#arguments.num_lote#)
			 </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca os documentos vinculados ao lote
	-- CRISTOFER  28/12/2006
	--->		
	<cffunction name="get_lote_documento" access="remote" returntype="query" output="true">
		<cfargument name="num_lote" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select num_lote,
				   documento_id,
				   embarcador,
				   faturista,
				   motorista,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from oper.v$lote_documento
			 where 1=1
			   and num_lote = #arguments.num_lote#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca os Conhecimentos realcionados a nota fiscal
	-- GUTO  08/01/2007
	--->		
	<cffunction name="get_busca_conhecimento_nota" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ordered */ c.conhecimento_id, 
					decode(c.situacao_id,0,'Confirmado',1,'Cancelado',2,'Impresso') as situacao,
				   c.num_conhecimento, c.serie, c.user_insert, c.data_emissao, 
				   c.peso, c.frete_valor, c.frete_unitario, c.despacho, c.total_conhecimento,
				   c.valor_icms, oper.pkg_global.fnc_busca_nome_pessoa(c.cod_remetente) as remetente,
				   oper.pkg_global.fnc_busca_nome_pessoa(c.cod_destinatario) as destinatario,
				   oper.pkg_global.fnc_busca_nome_pessoa(c.COD_CLIENTE_COBRANCA) as cliente_cobranca,
				   p.cliente as filial
			  from oper.v$conhecimento_nota_fiscal cnf
			 inner join oper.v$conhecimento c
				on c.conhecimento_id = cnf.conhecimento_id
			 inner join oper.v$pessoa p 
			         on p.cod_pessoa = c.cod_pessoa_filial
			 where cnf.numero = #arguments.num_nota_fiscal#	
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca Todos os romaneios de lotes próprios que não possuem conhecimento emitido no sistema
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 28/08/2009 - ALTERADO
	--->
	<cffunction name="get_romaneio_sem_conhecimento" displayname="Busca Todos os romaneios de lotes próprios que não possuem conhecimento emitido no sistema" access="remote" returntype="query" output="true">
    	<cfargument name="frete_proprio" required="no" default="">
    	<cfargument name="municipal" required="no" default="">
        <cfargument name="lotacao" required="no" default="">
        <cfargument name="tipo_documento" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#" blockfactor="10">
            select /*+ORDERED*/
                   distinct sc.solicitacao_carga_id,
                   v.viagem_id,
                   roo.cod_pessoa_filial,
                   kss.pkg_pessoa.fnc_get_cliente(roo.cod_pessoa_filial, 1) as filial,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id) as placa_controle,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia) as placa_referencia,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id) as frota_controle,
                   oper.pkg_veiculo.fnc_cod_veiculo(v.veiculo_id_referencia) as frota_referencia,
                   roo.num_romaneio,
                   roo.carregamento,
                   case
                      when roo.situacao_id = 1 then '<<Encerrado>>'
                      else to_char(rfr.data_ultima_posicao, 'dd/mm/yyyy hh24:mi:ss')
                   end as data_ultima_posicao,
                   case
                      when roo.situacao_id = 1 then '<<Encerrado>>'
                      else rfr.landmark
                   end as referencia,
                   case
                      when roo.situacao_id = 1 then 'Encerrado'
                      else evs.descricao_resumida
                   end as status
              from oper.v$romaneio roo
             inner join oper.v$romaneio_item rit
                     on roo.num_romaneio = rit.num_romaneio
             inner join logistica.v$viagem_carga vc
                     on vc.viagem_carga_id = rit.viagem_carga_id
             inner join logistica.v$solicitacao_carga sc
                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
             inner join logistica.v$viagem v
                     on v.viagem_id = vc.viagem_id
             inner join logistica.v$operacao op
                     on op.operacao_id = sc.operacao_id
             inner join logistica.v$operacao_filial_emissao ofe
                     on ofe.operacao_id = sc.operacao_id
			<cfif Len(Trim(arguments.lotacao)) and arguments.lotacao eq 1>
                    and ofe.cod_organograma = #session.COD_ORGANOGRAMA#
			</cfif>
              left join oper.v$rank_frota rfr
                     on rfr.placa_referencia = oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia)
              left join oper.v$evento_operacao evo
                     on evo.controle_evo_id = rfr.roo_evo_id
              left join oper.v$evento_operacao_setup evs
                     on evs.num_evento = evo.num_evento
             where 1 = 1
               and op.internacional = 0
               and trunc(sc.data_carregamento_inicio) >= '01/08/2009'
               and not exists (select 'x'
                                 from fiscal.v$conhecimento c
                                where c.num_romaneio = roo.num_romaneio
                                  and c.item_id = rit.item_id)
               and roo.situacao_id <> 1
			<cfif Len(Trim(arguments.frete_proprio))>
		       and op.frete_proprio = #arguments.frete_proprio#
			</cfif>
			<cfif Len(Trim(arguments.municipal)) and arguments.municipal eq 1>
		       and sc.origem_municipio_id = sc.destino_municipio_id
			</cfif>
            <cfif Len(Trim(arguments.tipo_documento))>
		       and op.tipo_documento = #arguments.tipo_documento#
			</cfif>
 	    </cfquery>
	    <cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca os dados do CTRC baseado no romaneio
	-- GUTO 15/01/2007
	--->		
	<cffunction name="get_conhecimento_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select con.conhecimento_id,
				   con.num_conhecimento,
				   con.serie,
				   con.item_id,
				   con.num_romaneio,
				   con.cod_pessoa_filial,
				   con.cod_departamento,
				   con.cod_setor,
				   con.cod_centro_custo,
				   con.data_emissao,
				   to_char(data_emissao,'dd/mm/yyyy hh24:mi') emissao_data_hora,
				   con.pagador,
				   con.cod_remetente,
				   con.rem_razao_social,
				   con.rem_endereco,
				   con.rem_municipio,
				   con.rem_uf,
				   con.rem_cep,
				   con.rem_cnpj_cpf,
				   con.rem_inscricao_estadual,
				   con.cod_destinatario,
				   con.dest_razao_social,
				   con.dest_endereco,
				   con.dest_municipio,
				   con.dest_uf,
				   con.dest_cep,
				   con.dest_cnpj_cpf,
				   con.dest_inscricao_estadual,
				   con.peso,
				   con.volume,
				   con.m3,
				   con.frete_unitario,
				   con.frete_peso,
				   con.frete_valor,
				   con.total_conhecimento,
				   con.coleta_municipio_id,
				   mc.municipio coleta_municipio,
				   mc.uf_id		coleta_uf,
				   con.entrega_municipio_id,
				   me.municipio entrega_municipio,
				   me.uf_id		entrega_uf,
				   nvl(con.placa_tracao,substr(oper.pkg_veiculo.fnc_get_composicao(con.placa),2,instr(oper.pkg_veiculo.fnc_get_composicao(con.placa),'|',2)-2)) placa_tracao,
				   decode(con.placa_tracao,'','',oper.pkg_operacional.fnc_veiculo_proprietario(con.placa_tracao)) proprietario_tracao,
				   p.cnpj_cpf cnpj_cpf_filial,
				   r.descricao_rota as rota, r.abreviatura as rota_abreviatura
			  from fiscal.v$conhecimento con
			 inner join kss.v$pessoa p
			         on p.cod_pessoa = con.cod_pessoa_filial
			 inner join cep.municipio mc
			         on mc.municipio_id = con.coleta_municipio_id
			 inner join cep.municipio me
			         on me.municipio_id = con.entrega_municipio_id
			 left join oper.v$rota r
			         on r.rota_id = con.rota_id
			 left join kss.v$pessoa_juridica pj
			         on pj.cod_pessoa = con.cod_pessoa_filial
			 where 1=1
			 <cfif len(trim(arguments.num_conhecimento))>
			   and con.num_conhecimento in (#arguments.num_conhecimento#)
			 </cfif> 
			 <cfif len(trim(arguments.num_romaneio))>
			   and con.num_romaneio in (#arguments.num_romaneio#)
			 </cfif> 
			 order by con.num_conhecimento	 
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	
	<!--- 
	-- PROPÓSITO 
	-- Busca os CTRC vinculados ao mesmo romaneio 
	-- WAGNER 17/01/2007
	--->		
	<cffunction name="get_conhecimento_por_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_conhecimento" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
		<cfargument name="serie" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select c.conhecimento_id as conhecimento_id,
					   c.data_emissao as data_emissao,
					   c.num_romaneio as num_romaneio,
					   c.placa_tracao || ' / ' || c.placa as placa,
					   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_tracao) || ' / ' || oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa) as frota_composicao,
					   c.num_conhecimento as num_conhecimento,
					   to_char(substr(pj.cnpj_ordem,3,2)) || '/' || c.serie as serie,
					   c.rota_id as rota_id,
					   ro.abreviatura ||' - '|| ro.descricao_rota  as rota_complemento,
					   c.total_conhecimento as valor,
					   '' as ctrc_complementado
				  from fiscal.v$conhecimento c
			inner join oper.v$romaneio r
					on r.num_romaneio = c.num_romaneio
			inner join kss.v$pessoa_juridica pj
					on pj.cod_pessoa = c.cod_pessoa_filial
			 left join oper.v$rota ro
					on ro.rota_id = c.rota_id
				 where 1=1
				   <cfif Len(Trim(arguments.num_romaneio))>
				   and c.num_romaneio = #arguments.num_romaneio#
				   <cfelse>
				   and c.num_romaneio = (select c2.num_romaneio
										   from fiscal.v$conhecimento c2
										  where c2.num_conhecimento = #arguments.num_conhecimento#
											and c2.serie = '#arguments.serie#')
			 		</cfif>
                     and not exists(select 'x'
                            from fiscal.v$conhecimento_complemento cc
                           where cc.conhecimento_complemento_id = c.conhecimento_id)
			 union all
				select cc.conhecimento_id as conhecimento_id,
					   c.data_emissao as data_emissao,
					   c.num_romaneio as num_romaneio,
					   c.placa_tracao || ' / ' || c.placa as placa,
					   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_tracao) || ' / ' || oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa) as frota_composicao,


					   c.num_conhecimento as num_conhecimento,
					   to_char(substr(pj.cnpj_ordem,3,2)) || '/' || c.serie as serie,
					   c.rota_id as rota_id,
					   'Complemento de preço' as rota_complemento,
					   c.total_conhecimento as valor,
					   (select to_char(substr(pj3.cnpj_ordem,3,2)) || '/' || c.serie ||' - '|| c3.num_conhecimento
						  from fiscal.v$conhecimento c3
					inner join kss.v$pessoa_juridica pj3
							on pj3.cod_pessoa = c3.cod_pessoa_filial
						 where c3.conhecimento_id = cc.conhecimento_id) as ctrc_complementado
				  from fiscal.v$conhecimento_complemento cc
			inner join fiscal.v$conhecimento c
					on c.conhecimento_id = cc.conhecimento_complemento_id
			inner join kss.v$pessoa_juridica pj
					on pj.cod_pessoa = c.cod_pessoa_filial
				 where 1=1 
				 <cfif Len(Trim(arguments.num_romaneio))>
				   and c.num_romaneio = #arguments.num_romaneio#
				 <cfelse>
				   and cc.conhecimento_id in ( select c.conhecimento_id
						   					     from fiscal.v$conhecimento c
												where c.num_romaneio = (select c2.num_romaneio
												  					      from fiscal.v$conhecimento c2
																		 where c2.num_conhecimento = #arguments.num_conhecimento#
																		   and c2.serie = '#arguments.serie#'))  
				</cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO
	-- Busca nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_terceiro_id" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select nf.num_nota_id
			  from fiscal.v$nf_terceiro nf
			 where nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			   and nf.cod_pessoa_filial = #session.cod_pessoa# 
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPÓSITO
	-- Busca dados nota fiscal 
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_terceiro" displayname="Busca dados nota fiscal" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default="" />
        <cfargument name="num_nota_fiscal" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select nf.num_nota_id,
                   nf.cod_pessoa_filial,

                   nf.cod_departamento,
                   nf.cod_setor,
                   nf.cod_centro_custo,
                   nf.num_nota_fiscal,
                   nf.cod_modelo,
                   nf.serie,
                   nf.subserie,
                   nf.cod_contabil,
                   nf.natureza_id,
                   nf.natureza_descricao,
                   nf.data_emissao,
                   nf.data_entrada,
                   nf.cod_emitente,
                   nf.emit_razao_social,
                   nf.emit_endereco,
                   nf.emit_bairro,
                   nf.emit_municipio,
                   nf.emit_uf,
                   nf.emit_cep,
                   nf.emit_telefone,
                   nf.emit_cnpj_cpf,
                   nf.emit_inscricao_estadual,
                   nf.cod_cliente,
                   nf.nf_imposto_id,
                   nf.calc_base_icms,
                   nf.calc_valor_icms,
                   nf.calc_base_icms_subst,
                   nf.calc_valor_icms_subst,
                   nf.calc_valor_total_produtos,
                   nf.calc_valor_frete,
                   nf.calc_valor_seguro,
                   nf.calc_outras_despesas,
                   nf.calc_valor_total_ipi,
                   nf.calc_valor_total_nota,
                   nf.observacao_fiscal,
                   nf.observacao_usuario,
                   nf.conferida,
                   nf.incluir_siss,
                   nf.cod_servico_des,
                   nf.natureza_siss_id,
                   nf.avista_aprazo,
                   nf.contabilizada,
                   p.identificador,
                   p.cliente
              from fiscal.v$nf_terceiro nf
             inner join kss.v$pessoa p
                     on p.cod_pessoa = nf.cod_emitente
             where 1 = 1
			<cfif Len(Trim(arguments.num_nota_id))>
           	   and num_nota_id = #arguments.num_nota_id#
            </cfif>
            <cfif Len(Trim(arguments.num_nota_fiscal))>
           	   and num_nota_fiscal = #arguments.num_nota_fiscal#
            </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPÓSITO
	-- Busca dados nota fiscal itens
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_terceiro_it" displayname="Busca dados nota fiscal" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select ni.num_nota_it_id, ni.cfop, ni.cfop_id, ni.produto_id, ni.descricao, ni.descricao_complemento, 
				   ni.cod_ncm, ni.st_origem_id, ni.st_icms_id, ni.cod_unidade, ni.qtde_peso, qtde_volume, 
				   ni.qtde_metro, ni.valor_em, ni.valor_em_unidade, ni.valor_unitario, ni.valor_total, 
				   ni.icms_reducao_base, ni.icms_base_calculo, ni.icms_aliquota, ni.icms_valor, ni.icms_base_calc_subst, 
				   ni.icms_valor_subst, ni.icms_isentas, ni.icms_outras, ni.ipi_reducao_base, ni.ipi_base_calculo, 
				   ni.ipi_aliquota, ni.ipi_valor, ni.ipi_isentas, ni.ipi_outras, ni.serv_total_tributavel, 
				   ni.serv_total_nao_tributavel, ni.serv_total_produto, ni.serv_iss_aliquota, ni.serv_iss_deducao, 
				   ni.serv_iss_valor, ni.desconto_percentual, ni.desconto_valor, ni.incluir_estoque, 
				   ni.incluir_livro_fiscal, ni.contabilizacao_id, nf.emit_uf as uf_emitente, f.uf as uf_unidade_negocio
			  from fiscal.v$nf_terceiro nf
			 inner join oper.v$filial f
					 on f.cod_pessoa = nf.cod_pessoa_filial
			 inner join fiscal.v$nf_terceiro_it nft
					 on nft.num_nota_id = nf.num_nota_id
			 inner join fiscal.v$nf_item ni
					 on nft.num_nota_it_id = ni.num_nota_it_id
			 where nft.num_nota_id = #arguments.num_nota_id#
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPÓSITO
	-- 
	-- NOTAS EXPLICATIVAS
	--  Busca dados do localiza de notas fiscais de ES
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_es_localizar" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default=""/>
		<cfargument name="dest_cnpj_cpf" required="no" default=""/>
		<cfargument name="dest_razao_social" required="no" default=""/>
		<cfargument name="data_emissao" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select num_nota_id, num_nota_fiscal, data_emissao, data_es, 
				   cod_destinatario, dest_razao_social, dest_municipio, dest_cnpj_cpf, 
				   calc_valor_total_nota
			  from fiscal.v$nf_es es		
	    inner join kss.v$organograma o
			    on o.cod_pessoa = es.cod_pessoa_filial
			   and o.cod_departamento = es.cod_departamento
			   and o.cod_setor = es.cod_setor
			   and o.cod_centro_custo = es.cod_centro_custo
			 where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
			 <cfif Len(Trim(arguments.dest_cnpj_cpf))>
			   and dest_cnpj_cpf = '#arguments.dest_cnpj_cpf#'
			 </cfif>
			 <cfif Len(Trim(arguments.dest_razao_social))>
			   and upper(dest_razao_social) like upper('#arguments.dest_razao_social#%')
			 </cfif>
			 <cfif Len(Trim(arguments.data_emissao))>
			   and trunc(data_emissao) = '#arguments.data_emissao#'
			 </cfif>
		  </cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPÓSITO
	-- Busca dados completos da nota fiscal de entrada/saida
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_es" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="num_nota_fiscal" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select es.num_nota_id, to_char(o.cod_unidade_negocio,'000') as cod_unidade_negocio,
				   to_char(es.cod_pessoa_filial,'990000') as cod_pessoa_filial, to_char(es.cod_departamento,'000') as cod_departamento, 
				   to_char(es.cod_setor,'000') as cod_setor, to_char(es.cod_centro_custo,'0000') as cod_centro_custo, 
				   es.num_nota_fiscal, es.cod_modelo, 
				   es.serie, es.subserie, es.e_s, es.cod_contabil, es.servico, es.inscricao_estadual_substituto, 
				   es.natureza_id, es.natureza_descricao, to_char(es.data_emissao,'dd/mm/yyyy') as data_emissao, 
           		   to_char(es.data_es,'dd/mm/yyyy') as data_es, es.cod_destinatario, 
				   es.dest_razao_social, es.dest_endereco, es.dest_bairro, es.dest_municipio, es.dest_uf, es.dest_cep, 
				   es.dest_telefone, es.dest_cnpj_cpf, es.dest_inscricao_estadual, es.nf_imposto_id, es.serv_total_tributavel, 
				   es.serv_total_nao_tributavel, es.serv_total_nota, es.serv_iss_aliquota, es.serv_iss_deducao, 
				   es.serv_iss_valor, es.calc_base_icms, es.calc_valor_icms, es.calc_base_icms_subst, es.calc_valor_icms_subst, 
				   es.calc_valor_total_produtos, es.calc_valor_frete, es.calc_valor_seguro, es.calc_outras_despesas, es.calc_valor_total_ipi, 
				   es.calc_valor_total_nota, es.cod_transportador, es.trp_razao_social, es.trp_endereco, es.trp_municipio, 
				   es.trp_uf, es.trp_cnpj_cpf, es.trp_inscricao_estadual, es.trp_placa, es.trp_placa_uf, es.trp_frete_por, 
				   es.trp_quantidade, es.trp_especie, es.trp_marca, es.trp_numero, es.trp_peso_bruto, es.info_complementares, 
				   es.reservado_fisco, es.observacao_fiscal, es.observacao_usuario, es.emitida, es.cancelada, 
				   es.trp_peso_liquido, es.conferida, es.manual, es.user_insert, es.date_insert, es.user_update, es.date_update, 
				   es.site, es.tipo_recolhimento_iss, es.conversao_moeda, es.conversao_taxa, es.cod_servico_des, es.natureza_siss_id, 
				   es.avista_aprazo, es.incluir_siss, es.cod_organizacional, es.organizacional_id
			  from fiscal.v$nf_es es
		     inner join kss.v$organograma o
			  	     on o.cod_pessoa = es.cod_pessoa_filial
				    and o.cod_departamento = es.cod_departamento
				    and o.cod_setor = es.cod_setor
				    and o.cod_centro_custo = es.cod_centro_custo
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_id))>
              and num_nota_id = #arguments.num_nota_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and es.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>    
			 <cfif Len(Trim(arguments.serie))>
			   and es.serie = '#arguments.serie#'
			 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>			

	<!--- 
	-- PROPÓSITO
	-- Busca dados completos da nota fiscal de entrada/saida FRETE
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 09/02/2007 - criado
	--->	
	<cffunction name="get_nf_es_frete" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfargument name="num_nota_fiscal" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="data_inicial" required="no" default=""/>
		<cfargument name="data_final" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select es.num_nota_id, to_char(o.cod_unidade_negocio,'000') as cod_unidade_negocio,
				   to_char(es.cod_pessoa_filial,'990000') as cod_pessoa_filial, to_char(es.cod_departamento,'000') as cod_departamento, 
				   to_char(es.cod_setor,'000') as cod_setor, to_char(es.cod_centro_custo,'0000') as cod_centro_custo, 
				   es.num_nota_fiscal, es.cod_modelo, 
				   es.serie, es.subserie, es.e_s, es.cod_contabil, es.servico, es.inscricao_estadual_substituto, 
				   es.natureza_id, es.natureza_descricao, to_char(es.data_emissao,'dd/mm/yyyy') as data_emissao, 
       				to_char(es.data_es,'dd/mm/yyyy') as data_es, 
       				ef.placa_tracao, ef.rem_razao_social, ef.rem_municipio, ef.rem_uf,
       				es.cod_destinatario, 
				   es.dest_razao_social, es.dest_endereco, es.dest_bairro, es.dest_municipio, es.dest_uf, es.dest_cep, 
				   es.dest_telefone, es.dest_cnpj_cpf, es.dest_inscricao_estadual, es.nf_imposto_id, es.serv_total_tributavel, 
				   es.serv_total_nao_tributavel, es.serv_total_nota, es.serv_iss_aliquota, es.serv_iss_deducao, 
				   es.serv_iss_valor, es.calc_base_icms, es.calc_valor_icms, es.calc_base_icms_subst, es.calc_valor_icms_subst, 
				   es.calc_valor_total_produtos, es.calc_valor_frete, es.calc_valor_seguro, es.calc_outras_despesas, es.calc_valor_total_ipi, 
				   es.calc_valor_total_nota, es.cod_transportador, es.trp_razao_social, es.trp_endereco, es.trp_municipio, 
				   es.trp_uf, es.trp_cnpj_cpf, es.trp_inscricao_estadual, es.trp_placa, es.trp_placa_uf, es.trp_frete_por, 
				   es.trp_quantidade, es.trp_especie, es.trp_marca, es.trp_numero, es.trp_peso_bruto, es.info_complementares, 
				   es.reservado_fisco, es.observacao_fiscal, es.observacao_usuario, es.emitida, es.cancelada, 
				   es.trp_peso_liquido, es.conferida, es.manual, es.user_insert, es.date_insert, es.user_update, es.date_update, 
				   es.site, es.tipo_recolhimento_iss, es.conversao_moeda, es.conversao_taxa, es.cod_servico_des, es.natureza_siss_id, 
				   es.avista_aprazo, es.incluir_siss,
       				ef.rem_razao_social, ef.num_romaneio, es.user_insert,
				   decode(ef.placa_tracao,null,'',decode(oper.pkg_veiculo.fnc_veiculo_proprietario(ef.placa_tracao),1,'Frota',2,'Agregado',3,'Terceiro','','---')) as veiculo_prop_tipo,
       				p.cliente as filial, m.municipio, ef.cod_motorista, 
 					 case 
	  				   when ef.placa_tracao_modalidade = 'TERCEIRO' then 3
			  		   when ef.placa_tracao_modalidade = 'AGREGADO' then 2
					     when ef.placa_tracao_modalidade = 'FROTA' then 1
			        end proprietario_veiculo, ef.coleta_municipio_id, ef.entrega_municipio_id, ef.volume,
      			 ef.peso, ef.placa, ef.m3, ef.num_especie, ef.cod_unidade, ef.despacho2 as despacho, ef.cod_remetente
			  from fiscal.v$nf_es es
		     inner join kss.v$organograma o
			  	     on o.cod_pessoa = es.cod_pessoa_filial
				    and o.cod_departamento = es.cod_departamento
				    and o.cod_setor = es.cod_setor
				    and o.cod_centro_custo = es.cod_centro_custo
             inner join kss.v$pessoa p 
                     on p.cod_pessoa = es.cod_pessoa_filial
             left join fiscal.v$nf_es_frete ef
                     on ef.nf_es_id = es.num_nota_id
             left join cep.municipio m
                     on m.municipio_id = ef.coleta_municipio_id
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
              and num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
			 <cfif Len(Trim(arguments.num_nota_id))>
              and num_nota_id = #arguments.num_nota_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
			 <cfif Len(Trim(arguments.data_inicial))>
			   and trunc(es.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_final))>
			   and trunc(es.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			 <cfif Len(Trim(arguments.serie))>
			   and es.serie = '#arguments.serie#'
			 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		    
	
	<!--- 
	-- PROPÓSITO
	-- Busca dados nota fiscal ES itens
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/02/2007 - criado
	--->	
	<cffunction name="get_nf_es_it" displayname="Busca dados nota fiscal" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes"/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select nf.e_s as es, nfe.num_nota_id, nfe.num_nota_it_id, cfop, cfop_id, produto_id, descricao, descricao_complemento, 
				   cod_ncm, st_origem_id, st_icms_id, cod_unidade, qtde_peso, qtde_volume, qtde_metro, valor_em, 
				   valor_em_unidade, valor_unitario, valor_total, icms_reducao_base, icms_base_calculo, 
				   icms_aliquota, icms_valor, icms_base_calc_subst, icms_valor_subst, ipi_reducao_base, ipi_base_calculo, 
				   ipi_aliquota, ipi_valor, 
				   ni.serv_total_tributavel as servico_total_tributavel, ni.serv_total_nao_tributavel as servico_total_nao_tributavel, 
				   ni.serv_total_produto as servico_total_produto, 
				   ni.serv_iss_aliquota as servico_iss_aliquota, ni.serv_iss_deducao as servico_iss_deducao, 
				   ni.serv_iss_valor as servico_iss_valor, desconto_percentual, desconto_valor, 
				   incluir_estoque, incluir_livro_fiscal, pe.uf as uf_unidade_negocio, nf.dest_uf as uf_destinatario
			  from fiscal.v$nf_es nf
			 inner join kss.v$unidade_negocio f
					 on f.cod_pessoa = nf.cod_pessoa_filial
             inner join kss.v$pessoa_endereco pe
			         on pe.cod_pessoa = f.cod_pessoa
			        and pe.endereco_padrao = 1        
			 inner join fiscal.v$nf_es_it nfe
					 on nfe.num_nota_id = nf.num_nota_id
			 inner join fiscal.v$nf_item ni
					 on nfe.num_nota_it_id = ni.num_nota_it_id
			 where nfe.num_nota_id = #arguments.num_nota_id#
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and f.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca PRODUTOS
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_produto" access="remote" returntype="query" output="true">
		<cfargument name="produto_id" required="no" default="">
        <cfargument name="somente_produto" required="no" default="0">
        <cfargument name="somente_servicos" required="no" default="">
        <cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct 
                   p.produto_id, 
                   p.descricao, 
                   p.cod_ncm, 
                   p.st_origem_id,
            	   p.categoria_id,
				   p.ipi_aliquota,
				   p.ipi_reducao_base,
				   p.ii_aliquota,
				   p.produto, 
                   p.servico,
           		   p.cod_unidade
                   <cfif arguments.somente_produto neq 1>
                   , nvl(t.st_icms_id,'41') as st_icms_id
				   , nvl(t.reducao_base_icms,0) as reducao_base_icms
				   </cfif>
                   ,(select kss.fnc_concat_all(kss.to_concat_expr(to_char(cir.imposto_id), ','))
                       from fiscal.v$categoria_imp_retencao cir
                      where cir.categoria_id = p.categoria_id) as categoria_impostos
   			  from fiscal.v$produto p
                   <cfif arguments.somente_produto neq 1>
			  left join fiscal.v$tributo t
			   	      on t.produto_id = p.produto_id
                   </cfif>
			 where p.ativo = 1 
			 <cfif Len(Trim(arguments.produto_id))>
			   and p.produto_id in (#arguments.produto_id#)
			 </cfif>
             <cfif Len(Trim(arguments.descricao))>
			   and upper(kss.pkg_string.fnc_string_clean(p.descricao)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.descricao#%'))
			 </cfif>
             <cfif Len(Trim(arguments.somente_servicos))>
			   and p.servico = 1
			 </cfif>
			 order by p.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca IMPOSTO mapeamento
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_imposto_mapeamento" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_emissao" required="no" default="">
		<cfargument name="produto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ig.imposto_reducao_base, p.cod_unidade,
				   ig.imposto_aliquota
			  from fiscal.v$imposto_gestao ig
			 inner join fiscal.v$produto_categoria pc
					 on ig.categoria_id = pc.categoria_id
			 inner join fiscal.v$produto p
					 on p.categoria_id = pc.categoria_id
			 where p.produto_id = #arguments.produto_id#
			   and ig.cod_pessoa = #arguments.cod_pessoa_emissao#
			   and ig.imposto_id = 4
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca Organograma completo
	-- GUTO  20/12/2006
	--->		
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.cod_organograma, o.cod_unidade_negocio, 
				   p.cliente as filial, o.cod_pessoa, 
				   d.descricao as departamento, o.cod_departamento,
				   s.descricao as setor, o.cod_setor,
				   cc.centro_custo, o.cod_centro_custo
			  from kss.v$organograma o
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = o.cod_pessoa
			 inner join kss.v$departamento d
					 on d.cod_departamento = o.cod_departamento
			 inner join kss.v$setor s
					 on s.cod_setor = o.cod_setor
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = o.cod_centro_custo   
             where 1=1
			 <cfif Len(Trim(arguments.cod_pessoa))>
			   and o.cod_pessoa = #arguments.cod_pessoa#
			 </cfif>			 					                      
			 <cfif Len(Trim(arguments.cod_centro_custo))>
			   and o.cod_centro_custo = '#arguments.cod_centro_custo#'
			 </cfif>			 					                      
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca COTACAO moeda
	-- GUTO  10/02/2007
	--->		
	<cffunction name="get_cotacao_moeda" access="remote" returntype="query" output="true">
		<cfargument name="cod_moeda" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select mb.cod_moeda, mb.tipo,      
					 mb.moeda || ' - ' || initcap(mb.descricao_moeda) moeda_desc,
					 nvl(mbc.taxa_venda,1) taxa_venda,
					 mbc.data_cotacao
				from finan.v$moeda_bacen mb
				left join finan.v$moeda_bacen_cotacao mbc
					   on mbc.cod_moeda = mb.cod_moeda
			    where mb.cod_moeda = #arguments.cod_moeda#
			   order by mbc.data_cotacao desc
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
	
	<!--- 
	-- PROPÓSITO 
	-- Busca as notas fiscais para imprimi-la.
	-- Jonas 30/07/2009
	--->		
	<cffunction name="get_nf_es_print" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
  			 select nf.num_nota_id
                  , nf.calc_valor_total_nota as total_nota
                  , nf.num_nota_fiscal
                  , nf.cod_modelo
                  , to_char(nf.data_emissao,'DD/MM/YYYY') as data_emissao
                  , upper(nf.dest_razao_social) as dest_razao_social
                  , nf.dest_cnpj_cpf
                  , upper(nf.dest_endereco) as dest_endereco
                  , upper(nf.dest_bairro) as dest_bairro
                  , nf.dest_cep
                  , upper(nf.dest_municipio) as dest_municipio
                  , nf.dest_telefone
                  , nf.dest_uf
                  , nf.dest_inscricao_estadual
                  , nf.observacao_usuario
                  , nf.tipo_recolhimento_iss
                  , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.num_docto), '| '))
                       from finan.v$finan_contas_receber fcr
                      inner join fiscal.v$nf_es_receber nfr
                              on nfr.contas_receber_id = fcr.contas_receber_id
                      where nfr.num_nota_id = nf.num_nota_id) as num_fatura 
                  , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.valor_docto ), '| '))
                       from finan.v$finan_contas_receber fcr
                      inner join fiscal.v$nf_es_receber nfr
                              on nfr.contas_receber_id = fcr.contas_receber_id
                      where nfr.num_nota_id = nf.num_nota_id) as valor_fatura 
                  , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.data_vencto,'MM/DD/YYYY'), '| '))
                       from finan.v$finan_contas_receber fcr
                      inner join fiscal.v$nf_es_receber nfr
                              on nfr.contas_receber_id = fcr.contas_receber_id
                      where nfr.num_nota_id = nf.num_nota_id) as data_vencto_fatura
                  , ps.identificador
               from fiscal.v$nf_es nf
               inner join kss.v$pessoa ps
               on ps.cod_pessoa = nf.cod_pessoa_filial
               where nf.num_nota_id = #arguments.num_nota_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
   
   <!--- 
	-- PROPÓSITO 
	-- Busca os itens das notas fiscais para imprimi-la.
	-- Jonas  30/07/2009
	--->		
	<cffunction name="get_nf_es_it_print" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select upper(ni.descricao) as descricao
                  , upper(ni.descricao_complemento) as complemento
                  , ni.valor_total
                  , ni.serv_iss_aliquota as iss_aliquota
                  , ni.serv_iss_valor as iss_valor
                  , ni.icms_aliquota
                  , ni.icms_valor
                  , (select count(*)
                       from fiscal.v$nf_imposto nfi
                      where nfi.num_nota_it_id = #arguments.num_nota_id#
                        and nfi.imposto_retido_fonte = 1) as impostos_retidos
               from fiscal.v$nf_es_it nfi
         inner join fiscal.v$nf_item ni
                 on ni.num_nota_it_id = nfi.num_nota_it_id
              where nfi.num_nota_id = #arguments.num_nota_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    
	<!--- 
	-- PROPÓSITO 
	-- Busca os impostos retidos na fonte para a nf
	-- CRISTOFER  12/05/2008
	--->		
	<cffunction name="get_nf_es_imposto_print" access="remote" returntype="query" output="true">
    	<cfargument name="num_nota_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select imp.DESCRICAO_IMPOSTO, 
                   nvl(sum(t.imposto_total),0) as valor
              from fiscal.v$nf_imposto t 
             inner join fiscal.v$imposto imp
                     on imp.imposto_id = t.imposto_id
             inner join fiscal.v$nf_es_it n
                     on n.num_nota_it_id = t.num_nota_it_id
             inner join fiscal.v$nf_item i
                     on i.num_nota_it_id = n.num_nota_it_id
             where t.imposto_id in (14,15,16,17,18,19)
               and n.num_nota_id = #arguments.num_nota_id#
             group by imp.descricao_imposto
            having nvl(sum(i.valor_total),0) > 0
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca as notas fiscais para imprimi-la.
	-- Wagner  10/02/2007
	--->		
	<cffunction name="get_nf_es_frete_print" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nef.nf_es_id
                 , to_char(nf.data_emissao,'DD/MM/YYYY') as data_emissao
                 , nf.num_nota_fiscal
                 , nef.cod_cliente_cobranca
                 , nef.cob_razao_social
                 , upper(nef.cob_endereco) as cob_endereco
                 , upper(nef.cob_municipio) as cob_municipio
                 , nef.cob_uf
                 , nef.cob_cep
                 , nef.cob_cnpj_cpf
                 , nef.cob_inscricao_estadual
                 , nf.calc_valor_total_nota total_nota
                 , (select sum(ni.valor_total)
                     from fiscal.v$nf_es_it it
                    inner join fiscal.v$nf_item ni
                            on ni.num_nota_it_id = it.num_nota_it_id
                    where it.num_nota_id = nf.num_nota_id) as total_produtos
                 , (select bairro from(select log.cep8_log as cep
                                           , upper(tit.abrev_tipo || '.' || '  ' || log.nome_log) as logradouro,            
                                                  (decode(loc.tipo_local, 'D', 'Dist. ' || loc.nome_local,  
                                                   decode(loc.tipo_local,'P', 'Pov. ' || loc.nome_local
                                           , upper(bai.extenso_bai)))) as bairro
                                           , upper(bai2.extenso_bai) as bairro2           
                                        from cep.cep_log log
                                  inner join cep.cep_tit tit
                                          on log.chave_tipo = tit.chave_tipo
                                  inner join cep.cep_bai bai
                                          on log.chvbai1_log = bai.chave_bai
                                         and log.chave_local = bai.chave_local
                                  inner join cep.cep_loc loc
                                          on log.chave_local = loc.chave_local     
                                   left join cep.cep_bai bai2
                                          on log.chvbai2_log = bai2.chave_bai
                                         and log.chave_local = bai2.chave_local
                                   left join cep.municipio m
                                          on loc.municipio_id_kmm = m.municipio_id) x
                      where x.cep = nef.cob_cep
                        and upper(x.logradouro) like upper(nef.cob_endereco)) as cob_bairro
                 , (select '('||t.fone_ddd||') '||t.fone_prefixo||'-'||t.fone_numero as telefone from kss.v$telefone t
                            where t.telefone_id = (select pt.telefone_id
                                                    from kss.v$pessoa_telefone_padrao pt
                                                    where pt.cod_pessoa = nef.cod_cliente_cobranca)) as cob_telefone
                  , (select m.municipio||' - '||m.uf_id
                       from cep.municipio m
                      where m.municipio_id = nef.coleta_municipio_id) as coleta
              from fiscal.v$nf_es_frete nef
        inner join fiscal.v$nf_es nf
                on nf.num_nota_id = nef.nf_es_id
		     where nef.nf_es_id = #arguments.num_nota_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca as notas fiscais para imprimi-la.
	-- Wagner  10/02/2007
	--->		
	<cffunction name="get_nf_es_frete_nota_print" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nf_es_id, numero, data_emissao, modelo, serie, sub_serie, 
                   valor_total, valor_segurado, ordem_compra_cliente, peso, 
                   peso_cubado, peso_cobrado, qtde_volume, altura, comprimento, 
                   largura, m3, cubagem, num_natureza, complemento, num_especie, 
                   cod_unidade, premio_seguro_rctrc, premio_seguro_rcfdc, 
                   premio_seguro_rr, valor_iof_seguro_rctrc, valor_iof_seguro_rcfdc, 
                   valor_iof_seguro_rr, seg_rctrc_id, seg_rcfdc_id, seg_rr_id
              from fiscal.v$nf_es_frete_nota_fiscal
             where nf_es_id = #arguments.num_nota_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    	
	<!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos para emissão de relatório de indicadores de qualidade
	-- NOTAS EXPLICATIVAS
	-- LOUIS 22/03/2006
	--->
	<cffunction name="get_indicadores_qualidade_atrasados" displayname="Busca os dados do conhecimento para emissão de relatório de indicadores de qualidade" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="no" default="">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="tipo_venda" displayname="Tipo de Venda" required="no" default="">
        <cfargument name="complementar" displayname="Conhecimento Complementar" required="no" default="0">
       	<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
				select un.unidade_negocio,
				   sum(case when (t.placa_tracao_modalidade = 'FROTA' or t.placa_tracao_modalidade is null) then 1 else 0 end) emitidos_frota,
				   sum(case when (t.placa_tracao_modalidade = 'FROTA' or t.placa_tracao_modalidade is null)and trunc(c.prazo_entrega) < nvl(trunc(c.data_entrega), trunc(c.prazo_entrega)) then 1 else 0 end) as atrasados_frota,
				   sum(case when t.placa_tracao_modalidade = 'AGREGADO' then 1 else 0 end) emitidos_agregado, 
				   sum(case when t.placa_tracao_modalidade = 'AGREGADO' and trunc(c.prazo_entrega) < nvl(trunc(c.data_entrega), trunc(c.prazo_entrega)) then 1 else 0 end) as atrasados_agregado,
				   sum(case when t.placa_tracao_modalidade = 'TERCEIRO' then 1 else 0 end) emitidos_terceiro,
				   sum(case when t.placa_tracao_modalidade = 'TERCEIRO' and trunc(c.prazo_entrega) < nvl(trunc(c.data_entrega), trunc(c.prazo_entrega)) then 1 else 0 end) as atrasados_terceiro
			   from fiscal.v$conhecimento c
               inner join kss.v$unidade_negocio un 
                       on un.cod_pessoa = c.cod_pessoa_filial           
			   inner join fiscal.v$conhecimento_outros_dados t 
					 on c.conhecimento_id = t.conhecimento_id
               where 1 = 1 
			   <cfif Len(Trim(arguments.data_inicial))>
					and trunc(c.data_emissao) >= '#arguments.data_inicial#'
			   </cfif>	 	
			   <cfif Len(Trim(arguments.data_final))>
			 	    and trunc(c.data_emissao ) <= '#arguments.data_final#'
			   </cfif>
			   <cfif Len(Trim(arguments.tipo_venda))>
					and t.tipo_venda = '#arguments.tipo_venda#'
			   </cfif>
			   <cfif Len(Trim(arguments.cod_pessoa_filial))>
                        and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
                            and not exists(select 'x' 
                                         from fiscal.v$conhecimento_complemento cc
                                         where cc.conhecimento_complemento_id = c.conhecimento_id)    
               </cfif>
               <cfif arguments.complementar neq 0>
                    and not exists(select 'x' 
                                     from fiscal.v$conhecimento_complemento cc
                                    where cc.conhecimento_complemento_id = c.conhecimento_id) 
               </cfif>	
               and c.situacao_id = 0
               -- Não considera os dedicados
               and not exists
  				(select 'x'
                   from  kss.v$org_grupo_item og
                  where og.cod_centro_custo = t.cod_centro_custo_gerencial and og.grupo_id = 2)
               group by un.unidade_negocio
    	</cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos para emissão de relatório de indicadores de qualidade
	-- NOTAS EXPLICATIVAS
	-- LOUIS 22/03/2006
	--->
	<cffunction name="get_indicadores_qualidade_retornados" displayname="Busca os dados do conhecimento para emissão de relatório de indicadores de qualidade" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="no" default="">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="no" default="">
		<cfargument name="tipo_venda" displayname="Tipo de venda" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="no" default="0">
        <cfargument name="complementar" displayname="Conhecimento Complementar" required="no" default="1">
		<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
			select un.unidade_negocio, 
			   sum(case when (t.placa_tracao_modalidade = 'FROTA' or t.placa_tracao_modalidade is null) then 1 else 0 end) emitidos_frota,
			   sum(case when (t.placa_tracao_modalidade = 'FROTA' or t.placa_tracao_modalidade is null) and trunc(c.DATA_ENTREGA) is not null then 1 else 0 end) as retornados_frota,
			   sum(case when t.placa_tracao_modalidade = 'AGREGADO' then 1 else 0 end) emitidos_agregado,
			   sum(case when t.placa_tracao_modalidade = 'AGREGADO' and trunc(c.DATA_ENTREGA) is not null then 1 else 0 end) as retornados_agregado,
			   sum(case when t.placa_tracao_modalidade = 'TERCEIRO' then 1 else 0 end) emitidos_terceiro,
			   sum(case when t.placa_tracao_modalidade = 'TERCEIRO' and trunc(c.DATA_ENTREGA) is not null then 1 else 0 end) as retornados_terceiro
		   from fiscal.v$conhecimento c
     inner join kss.v$unidade_negocio un 
           on un.cod_pessoa = c.cod_pessoa_filial           
	 inner join fiscal.v$conhecimento_outros_dados t
				on c.conhecimento_id = t.conhecimento_id
  		  where 1 = 1 
			<cfif Len(Trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#'
			</cfif>	 	
			<cfif Len(Trim(arguments.data_final))>
			   and trunc(c.data_emissao ) <= '#arguments.data_final#'
			</cfif>
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
                   and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
                                  and not exists(select 'x' 
                                 from fiscal.v$conhecimento_complemento cc
                                where cc.conhecimento_complemento_id = c.conhecimento_id)
                    </cfif>
       		<cfif Len(Trim(arguments.tipo_venda))>
			   and t.tipo_venda = '#arguments.tipo_venda#'
			</cfif>
            <cfif arguments.complementar neq 0>
                    and not exists(select 'x' 
                                     from fiscal.v$conhecimento_complemento cc
                                    where cc.conhecimento_complemento_id = c.conhecimento_id) 
            </cfif>	
			and c.situacao_id = 0
			-- Não considera os dedicados
               and not exists
  				(select 'x'
                   from  kss.v$org_grupo_item og
                  where og.cod_centro_custo = t.cod_centro_custo_gerencial and og.grupo_id = 2)
		  group by un.unidade_negocio
		</cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO
	-- Busca Conhecimentos de agregados que não possuem entrega de comprovante
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 12/04/2007 - criado
	--->	
	<cffunction name="get_ctrc_sem_entrega_agregado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select t.num_conhecimento, t.serie, t.filial, t.num_romaneio, 
				   to_char(t.data_emissao,'dd/mm/yyyy') as data_emissao, 
				   to_char(t.prazo_entrega,'dd/mm/yyyy') as prazo_entrega,  
				   to_char(t.data_ps,'dd/mm/yyyy') as data_ps, t.data_entrega, t.linha 
			  from (select c.num_conhecimento, c.serie, p.cliente as filial, c.num_romaneio, c.data_emissao, c.prazo_entrega, ar.data_lancamento as data_ps, c.data_entrega,
						   row_number() over(order by ar.data_lancamento desc) as linha
					  from fiscal.v$conhecimento c
					 inner join oper.v$romaneio_item ri
							 on ri.num_romaneio = c.num_romaneio
							and ri.item_id = c.item_id
					 inner join oper.v$lote l
							 on l.num_lote = ri.num_lote
					 inner join oper.v$agregado_romaneio ar
							 on ar.num_romaneio = ri.num_romaneio
					 inner join kss.v$pessoa p 
							 on p.cod_pessoa = c.cod_pessoa_filial
					 where ar.placa = '#arguments.PLACA#'
					   and l.internacional = 0
					   and l.frete_proprio = 1
					   and c.situacao_id <> 1
					   and ar.data_cancelamento is null
					   order by data_ps desc) t
			where t.data_entrega is null
			  and t.linha > 1
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>		

	<!--- 
	-- PROPÓSITO 
	-- Realiza a consulta de conhecimentos de indicadores de qualidade
	-- NOTAS EXPLICATIVAS
	-- LOUIS 22/03/2006
	--->
	<cffunction name="get_conh_indicadores_qualidade" displayname="Busca os dados do conhecimento para emissão de relatório de indicadores de qualidade" access="remote" returntype="query" output="true">

		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="no" default="">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="tipo_venda" required="no" default="">
        <cfargument name="complementares" required="no" default="1">
       	<cfquery datasource="#session.dsn#" name="qr_conhecimento" username="#session.usuario#" password="#session.senha#">
				select un.unidade_negocio,
				   c.num_conhecimento || '/' || c.serie conhecimento,
								  c.data_emissao,
								  c.rem_cnpj_cpf,
				   c.rem_razao_social remetente,
								  c.rem_municipio || '/' || rem_uf  municipio_origem,
								  c.dest_cnpj_cpf,
								  c.dest_razao_social destinatario,
				   c.dest_municipio || '/' || c.DEST_UF  municipio_dest,
								  c.total_conhecimento total_ctrc,
								  c.prazo_entrega,
								  c.data_entrega,
								  t.placa_tracao_modalidade,
								  case
								  -- Senão tem data de entrega  não considera atrasado
					  when trunc(c.prazo_entrega) < nvl(trunc(c.data_entrega), trunc(c.prazo_entrega)) then  'Sim' 
				   else 'Não'                 
				   end atrasado,
								  case
					  when trunc(c.data_entrega) is not null then 'Sim'
				   else 'Não'
				   end retornado,
								  count(*) over () total_ctrc_count,
								  sum(case
						  when trunc(c.data_entrega) is not null then 1
					   else 0
					   end) over () total_retornado,
								  sum(case 
								  -- Senão tem data de entrega  não considera atrasado
						  when trunc(c.prazo_entrega) < nvl(trunc(c.data_entrega), trunc(c.prazo_entrega)) then 1
					   else 0
					   end) over ()  total_atrasado
			  from fiscal.v$conhecimento c
             inner join kss.v$unidade_negocio un 
                   on un.cod_pessoa = c.cod_pessoa_filial           
			 inner join fiscal.v$conhecimento_outros_dados t 
					 on c.conhecimento_id = t.conhecimento_id
         	 where 1 = 1 
			 <cfif Len(Trim(arguments.data_inicial))>
			   and trunc(c.data_emissao) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif Len(Trim(arguments.data_final))>
			   and trunc(c.data_emissao) <= '#arguments.data_final#'
			 </cfif>
			 <cfif Len(Trim(arguments.cod_pessoa_filial))>
			   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
					and not exists(select 'x' 
									 from fiscal.v$conhecimento_complemento cc
									 where cc.conhecimento_complemento_id = c.conhecimento_id)

			 </cfif>
			 <cfif Len(Trim(arguments.tipo_venda))>
			   and t.tipo_venda = '#arguments.tipo_venda#'
			 </cfif>
             <cfif Len(Trim(arguments.complementares)) and arguments.complementares eq 0>
               and not exists(select 'x' 
									 from fiscal.v$conhecimento_complemento cc
									 where cc.conhecimento_complemento_id = c.conhecimento_id)
             </cfif>
			  and c.situacao_id = 0
              -- Não considera os dedicados
              and not exists
  				(select 'x'
                   from  kss.v$org_grupo_item og
                  where og.cod_centro_custo = t.cod_centro_custo_gerencial and og.grupo_id = 2)
			order by c.data_emissao 

		</cfquery>
	   <cfreturn qr_conhecimento>
	</cffunction>
	
	<!--- 
	-- PROPÓSITO
	-- Calculo de ICMS para fretes
	-- guto 22/06/2007 10:47:14 - CRIADO
	--->
	<cffunction name='calcula_icms_frete' displayname='Calculo de ICMS para fretes' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='UF_FILIAL_EMITENTE' required='yes'>
		<cfargument name='MUNICIPAL' required='yes' default="0">
		<cfargument name='COD_ATIVIDADE_TOMADOR' required='yes'>
		<cfargument name='UF_ORIGEM' required='yes'>
		<cfargument name='UF_DESTINO' required='yes'>
		<cfargument name='TOMADOR_SERVICO' required='yes'>
		<cfif MUNICIPAL eq 1>
			<cfset arguments.MUNICIPIO_ID_ORIGEM  = 1>			
			<cfset arguments.MUNICIPIO_ID_DESTINO = 1>			
		<cfelse>
			<cfset arguments.MUNICIPIO_ID_ORIGEM  = 1>			
			<cfset arguments.MUNICIPIO_ID_DESTINO = 0>			
		</cfif>
				<cfstoredproc procedure='fiscal.pkg_conhecimento.prc_calcula_icms_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_FILIAL_EMITENTE'  value='#arguments.UF_FILIAL_EMITENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_ATIVIDADE_TOMADOR'  value='#arguments.COD_ATIVIDADE_TOMADOR#'  null='#iif(len(trim(arguments.COD_ATIVIDADE_TOMADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID_ORIGEM'  value='#arguments.MUNICIPIO_ID_ORIGEM#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_ORIGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_ORIGEM'  value='#arguments.UF_ORIGEM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID_DESTINO'  value='#arguments.MUNICIPIO_ID_DESTINO#'  null='#iif(len(trim(arguments.MUNICIPIO_ID_DESTINO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_DESTINO'  value='#arguments.UF_DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TOMADOR_SERVICO'  value='#arguments.TOMADOR_SERVICO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID' variable='retorno.ST_ICMS_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS' variable='retorno.ALIQUOTA_ICMS' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_CFOP' variable='retorno.CFOP' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_CFOP_ID' variable='retorno.CFOP_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO' variable='retorno.NATUREZA_OPERACAO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL' variable='retorno.FUNDAMENTACAO_LEGAL' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPÓSITO 
	-- Busca os impostos
	-- CRISTOFER  25/06/2007
	--->		
	<cffunction name="get_imposto" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select i.imposto_id,
				   i.descricao_imposto
			  from fiscal.v$imposto i
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca as categorias de Produtos
	-- CRISTOFER  25/06/2007
	--->		
	<cffunction name="get_produto_categoria" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.categoria_id, 
				   c.descricao
			  from fiscal.v$produto_categoria c
              order by c.descricao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca os impostos da NF
	-- CRISTOFER  26/06/2007
	--->		
	<cffunction name="get_nf_imposto" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default="">
		<cfargument name="retido_fonte" required="no" default="">
		<cfargument name="positivos" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.descricao produto,
				   ip.imposto_id,
			       io.descricao_imposto imposto,
				   ip.imposto_reducao_base,
				   ip.imposto_base_calculo,
				   ip.imposto_aliquota,
				   ip.imposto_total,
				   ip.data_vencimento,
				   ip.imposto_retido_fonte,
				   ip.nf_imposto_id
			  from fiscal.v$nf_es_it ei
			 inner join fiscal.v$nf_item i
					 on i.num_nota_it_id = ei.num_nota_it_id
			 inner join fiscal.v$produto p 
					 on i.produto_id = p.produto_id
			 inner join fiscal.v$nf_es nf
					 on nf.num_nota_id = ei.num_nota_id
			 inner join fiscal.v$nf_imposto ip
					 on ip.num_nota_it_id = ei.num_nota_it_id
			 inner join fiscal.v$imposto io
					 on io.IMPOSTO_ID = ip.IMPOSTO_ID
			 where 1=1
			 <cfif len(trim(arguments.retido_fonte))>
			   and ip.imposto_retido_fonte = #arguments.retido_fonte#
			 </cfif>
			 <cfif len(trim(arguments.positivos)) and arguments.positivos eq 1>
			   and ip.imposto_total > 0
			 </cfif>
			 <cfif len(trim(arguments.num_nota_id))>
			   and nf.num_nota_id = #arguments.num_nota_id#
			 </cfif>
             
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPÓSITO 
	-- Busca as cartas frete para impressao
	-- CRISTOFER  07/05/2007
	--->		
	<cffunction name="get_carta_frete_impressao" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nvl(lancto_id_pai,lancto_id) lancto_id_pai,
            	   c.lancto_id,
                   c.num_formulario,
                   c.parcela,
                   c.total_parcela,
                   c.placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) cod_veiculo_controle,
                   c.proprietario_cod_pessoa,
                   p.cliente as proprietario,
                   c.impresso,
                   c.usuario_cancelamento,
                   c.data_cancelamento
              from oper.v$contrato_transp c
             inner join kss.v$pessoa p
                     on p.cod_pessoa = c.proprietario_cod_pessoa
             where 1=1
             <cfif len(trim(arguments.lancto_id))>
               and coalesce(c.lancto_id_pai,c.lancto_id) = #arguments.lancto_id#
             </cfif>
             order by c.num_formulario
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
   	<!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos lista
	-- NOTAS EXPLICATIVAS
	-- igor 13/03/2006
	--->
	<cffunction name="get_conhecimento_cliente" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" >
		<cfargument name="num_conhecimento" displayname="Numero do conhecimento"  >
		<cfargument name="data_inicial" displayname="Data Inicial emissão conhecimento" required="false" default="">
		<cfargument name="data_final" displayname="Data Final emissão conhecimento" required="false" default="">
		<cfargument name="serie" displayname="Serie" required="false">
		<cfargument name="cod_pessoa_filial" displayname="Filial" required="false">
        <cfargument name="cod_unidade_negocio" required="false" default="">      
        <cfargument name="NOME_FANTASIA" required="false" default="">   
		<cfargument name="cod_setor" displayname="Setor" required="false">
		<cfargument name="nivel_acesso"  required="false" default="0">
		<cfargument name="situacao_id"  required="false" default="0">
        <cfargument name="impresso_id"  required="false" default="">
        <cfargument name="faturado_id"  required="false" default="">
        <cfargument name="cod_centro_custo"  required="false" default="0">
        <cfargument name="cnpj_cpf"  required="false" default="">
        <cfargument name="check_remetente"  required="false" default="">
        <cfargument name="check_destinatario"  required="false" default="">
        <cfargument name="check_consignatario"  required="false" default="">
        <cfargument name="check_redespacho"  required="false" default="">
        <cfargument name="check_cobranca"  required="false" default="">
        <cfargument name="cod_remetente"  required="false" default="">     
        <cfargument name="frota"  required="false" default="">  
        <cfquery datasource="#session.dsn#" name="qr_conhecimento_lista" username="#session.usuario#" password="#session.senha#">
    	select trunc(c.data_emissao) as data_emissao,
        	  c.cod_pessoa_filial,
              c.num_conhecimento,
           orig.municipio || '/' || orig.uf_id as origem,
           dest.municipio || '/' || dest.uf_id as destino,
           c.km_rota,
           vc.cod_veiculo as cavalo,
           vr.cod_veiculo as carreta,
           c.peso_real,
           c.peso,
           c.total_conhecimento - c.valor_icms - c.valor_icms_substit as frete_sem_icms,
           c.valor_icms + c.valor_icms_substit as icms,
           c.total_conhecimento frete_com_icms,
           case
             when (select count(*)
                     from fiscal.v$conhecimento_complemento cp
                    where cp.conhecimento_id = c.conhecimento_id) > 0 then
              'Sim'
             else
              'N&Atilde;o'
           end as complemento,
           (select kss.fnc_concat_all(to_concat_expr(to_char(cnf.numero), '/'))
              from fiscal.v$conhecimento_nota_fiscal cnf
             where cnf.conhecimento_id = c.conhecimento_id
             group by cnf.conhecimento_id) as nota_fiscal,
           (select kss.fnc_concat_all(to_concat_expr(to_char(cnf.ordem_compra_cliente), '/'))
              from fiscal.v$conhecimento_nota_fiscal cnf
             where cnf.conhecimento_id = c.conhecimento_id
             group by cnf.conhecimento_id) as brm_transporte
      from fiscal.v$conhecimento c
     inner join oper.v$municipio orig on orig.municipio_id = c.coleta_municipio_id
     inner join oper.v$municipio dest on dest.municipio_id = c.entrega_municipio_id
     inner join kss.v$unidade_negocio u on u.cod_pessoa = c.cod_pessoa_filial
     left join oper.v$veiculo vc on vc.placa = c.placa_tracao
     left join oper.v$veiculo vr on vr.placa = c.placa
		 where 1=1
       <cfif isDefined("arguments.conhecimento_id") and Len(Trim(arguments.conhecimento_id))>
            and c.conhecimento_id = #arguments.conhecimento_id#
       <cfelseif isDefined("arguments.num_conhecimento") and Len(Trim(arguments.num_conhecimento))>
            and c.num_conhecimento = #arguments.num_conhecimento#
       </cfif>
       <cfif len(trim(arguments.data_inicial))>
            and trunc(c.data_emissao) >= '#arguments.data_inicial#'
       </cfif>
       <cfif len(trim(arguments.data_final))>
          and trunc(c.data_emissao) <= '#arguments.data_final#'
       </cfif>
	   <cfif isDefined("arguments.serie") and Len(Trim(arguments.serie)) >
		   and c.serie = '#arguments.serie#'
	   </cfif>
       <cfif isDefined("arguments.frota") and Len(Trim(arguments.frota)) >
		   and (vc.cod_veiculo = '#arguments.frota#' or c.placa = '#arguments.frota#' )
	   </cfif>
	   <cfif isDefined("arguments.cod_unidade_negocio") and Len(Trim(arguments.cod_unidade_negocio)) >
		   and u.cod_unidade_negocio = '#arguments.cod_unidade_negocio#'
	   </cfif>
	   <cfif isDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id)) >
		   and c.situacao_id in (#arguments.situacao_id#)
	   </cfif> 
	    <cfif isDefined("arguments.impresso_id") and Len(Trim(arguments.impresso_id))>
       	   and c.impresso = #arguments.impresso_id#
       </cfif>
       <cfif isDefined("arguments.faturado_id") and Len(Trim(arguments.faturado_id))>
       	   and c.faturado = #arguments.faturado_id#
       </cfif>
       <cfif isDefined("arguments.cod_centro_custo") and Len(Trim(arguments.cod_centro_custo)) >
		   and c.cod_centro_custo = #arguments.cod_centro_custo#
	   </cfif>
       <cfif isDefined("arguments.cod_remetente") and Len(Trim(arguments.cod_remetente)) >
		   and c.cod_remetente = #arguments.cod_remetente#
	   </cfif>
       <cfif Len(Trim(arguments.check_remetente)) or Len(Trim(arguments.check_destinatario)) or Len(Trim(arguments.check_consignatario)) or Len(Trim(arguments.check_redespacho)) or Len(Trim(arguments.check_cobranca))>
	   and ( <cfif isDefined("arguments.check_remetente") and Len(Trim(arguments.check_remetente))>
                c.rem_cnpj_cpf = #arguments.cnpj_cpf#
           </cfif>
           <cfif isDefined("arguments.check_destinatario") and Len(Trim(arguments.check_destinatario))>
               <cfif len(trim(arguments.check_remetente))>
               	or c.dest_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	c.dest_cnpj_cpf = #arguments.cnpj_cpf# 
               </cfif>
           </cfif>
           <cfif isDefined("arguments.check_consignatario") and Len(Trim(arguments.check_consignatario))>
       		   <cfif len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente))>
                or c.cons_cnpj_cpf = #arguments.cnpj_cpf#
           	   <cfelse>
               	c.cons_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>
		   </cfif>
           <cfif isDefined("arguments.check_redespacho") and Len(Trim(arguments.check_redespacho))>
               <cfif len(trim(arguments.check_consignatario)) or len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente))>
                 or c.red_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	 c.red_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>	
           </cfif>
            <cfif isDefined("arguments.check_cobranca") and Len(Trim(arguments.check_cobranca))>
               <cfif len(trim(arguments.check_consignatario)) or len(trim(arguments.check_destinatario)) or len(trim(arguments.check_remetente)) or len(trim(arguments.check_redespacho))>
               or c.cob_cnpj_cpf = #arguments.cnpj_cpf#
               <cfelse>
               	c.cob_cnpj_cpf = #arguments.cnpj_cpf#
               </cfif>
           </cfif>
           )
       </cfif>
	   order by trunc(c.data_emissao)
	  </cfquery>
	   <cfreturn qr_conhecimento_lista>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Séries
	-- NOTAS EXPLICATIVAS
	-- GUTO 24/02/2006
	--->
	<cffunction name="get_serie" displayname="Busca Séries" access="remote" returntype="query" output="false">
	    <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfargument name="cod_pessoa" hint="Usado para algumas telas que usam o COD_PESSOA como o código pessoa da filial" required="no" default=""/>
	    <cfargument name="cod_departamento" required="no" default="">
	    <cfargument name="cod_setor" required="no">
	    <cfargument name="cod_centro_custo" required="no">
		<cfargument name="cod_modelo" required="no" default="">
	    <cfargument name="organograma" required="no" default="">		
		<cfargument name="todas" required="no">
        <cfargument name="serie" required="no">
		<cfargument name="ordenada" required="no">
        <cfargument name="documento_proprio" required="no">
		<cfif Len(Trim(arguments.cod_pessoa)) and not Len(Trim(arguments.cod_pessoa_filial))>
			<cfset arguments.cod_pessoa_filial = arguments.cod_pessoa>
		</cfif>
		<cfif Len(Trim(arguments.ORGANOGRAMA))>
			<cfset arguments.cod_pessoa_filial = ListGetAt(arguments.organograma,1,'_')>
			<cfset arguments.cod_departamento = ListGetAt(arguments.organograma,2,'_')>
			<cfset arguments.cod_setor = ListGetAt(arguments.organograma,3,'_')>
			<cfset arguments.cod_centro_custo = ListGetAt(arguments.organograma,4,'_')>
		</cfif>
		<cfif not isDefined("arguments.todas")>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				 <cfif Len(Trim(arguments.cod_pessoa_filial))>
					select distinct ags.serie, ags.cod_modelo , (select f.formulario_id
                                                          from kss.v$formulario f
                                                         where f.formulario_id = ags.formulario_id) as formulario
					  from fiscal.v$modelo_serie ags
					 where ags.cod_pessoa       = #arguments.cod_pessoa_filial#
					   <cfif isDefined("arguments.cod_departamento") and Len(Trim(arguments.cod_departamento))>
                       and ags.cod_departamento = #arguments.cod_departamento#
                       </cfif>
					   <cfif isDefined("arguments.cod_setor") and Len(Trim(arguments.cod_setor))>
					   and ags.cod_setor        = #arguments.cod_setor#
                       </cfif>                       
					   and ags.ativo 			= 1
					   <cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
                      <cfif  isDefined("arguments.ordenada") and Len(Trim(arguments.ordenada))>
                      order by lpad(ags.serie,3,'0')
					   </cfif>
				 <cfelse>
					select distinct ags.serie 
					  from fiscal.v$modelo_serie ags
					 inner join kss.v$kss_usuario_lotacao ul
						on ags.cod_pessoa = ul.cod_pessoa
					   and ags.cod_departamento = ul.cod_departamento
					   and ags.cod_setor = ul.cod_setor
					  where ags.ativo 	 = 1
                        and ul.usuario = user
					  	<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					   		and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
					   </cfif>
                       <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
					   </cfif>
					  order by ags.serie
				 </cfif>
			</cfquery>		
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_serie" username="#session.usuario#" password="#session.senha#">
				select distinct serie 
				from fiscal.v$modelo_serie ags
				where ativo 	 = 1
				<cfif isDefined("arguments.cod_modelo") and Len(Trim(arguments.cod_modelo))>
					and ags.cod_modelo in (#ListQualify(arguments.cod_modelo,"'",",")#)
				</cfif>
                <cfif isDefined("arguments.documento_proprio") and Len(Trim(arguments.documento_proprio))>
					   		and ags.documento_proprio = #arguments.documento_proprio#
				</cfif>
  			</cfquery>		
	    </cfif>
		<cfreturn qr_serie> 
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca unidades de negocio
	-- GUTO 20/10/2008
	--->		
	<cffunction name="get_unidade_negocio" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(cod_unidade_negocio,'0000') as cod_unidade_negocio, to_char(cod_unidade_negocio,'0000') as cod_un_negocio,
                   unidade_negocio, cod_pessoa
              from kss.v$unidade_negocio t
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca impostos
	-- GUTO 20/10/2008
	--->		
	<cffunction name="get_impostos" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.imposto_id, i.descricao_imposto, 
                   i.historico_contabil_entrada, i.historico_contabil_saida,
                   i.imposto_aliquota, i.imposto_reducao_base 
              from fiscal.v$imposto i
            order by i.descricao_imposto
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPÓSITO
	-- Busca Dados do calculo do ICMS
	-- Guto 06/05/2006 15:46:31 - CRIADO
	--->
	<cffunction name="get_icms" displayname="Busca Dados do calculo do ICMS" access="remote" returntype="struct" output="true">
		<cfargument name="produto_id" displayname="Produto que está sendo transportando" required="yes">
		<cfargument name="cod_atividade" displayname="Código da atividade fiscal do pagador" required="yes">
		<cfargument name="uf_origem" displayname="UF coleta" required="yes">
		<cfargument name="uf_destino" displayname="UF entrega" required="yes">
		<cfargument name="tomador_servico" displayname="UF Tomador do Serviço" required="no">
		<cfstoredproc datasource="#session.dsn#" procedure="fiscal.pkg_fiscal.prc_calcula_icms" username="#session.usuario#" password="#session.senha#">
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_produto_id" value="#arguments.produto_id#">
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_cod_atividade" value="#arguments.cod_atividade#">
			<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_uf_origem" value="#arguments.uf_origem#">
			<cfprocparam type="in" cfsqltype="cf_sql_char" dbvarname="p_uf_destino" value="#arguments.uf_destino#">
			<cfprocparam type="in" cfsqltype="cf_sql_varchar" dbvarname="p_tomador_servico" value="#arguments.tomador_servico#">
			<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_reducao_base_icms" variable="retorno.reducao_base_icms">
			<cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_st_icms_id" variable="retorno.st_icms_id">
			<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_aliquota_icms" variable="retorno.aliquota_icms">
		</cfstoredproc>
		<cfreturn retorno>
	</cffunction>    

	<!--- 
	-- PROPÓSITO
	-- Consulta uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 05/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_completa" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
        <cfargument name="num_nota_fiscal" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		    select nf.num_nota_id,
				   nf.cod_pessoa_filial,
				   nf.cod_departamento,
				   nf.cod_setor,
				   nf.cod_centro_custo,
				   nf.num_nota_fiscal,
				   nf.cod_modelo,
				   nf.serie,
				   nf.subserie,
				   nf.cod_contabil,
				   nf.natureza_id,
				   nf.natureza_descricao,
				   nf.data_emissao,
				   to_char(nf.data_entrada,'dd/mm/yyyy hh24:mi') as data_entrada,

				   nf.cod_emitente,
				   nf.emit_razao_social,
				   nf.emit_endereco,
				   nf.emit_bairro,
				   nf.emit_municipio,
				   nf.emit_uf,
				   nf.emit_cep,
				   nf.emit_telefone,
				   nf.emit_cnpj_cpf,
				   nf.emit_inscricao_estadual,
				   nf.cod_cliente,
				   nf.nf_imposto_id,
				   nf.calc_base_icms,
				   nf.calc_valor_icms,
				   nf.calc_base_icms_subst,
				   nf.calc_valor_icms_subst,
				   nf.calc_valor_total_produtos,
				   nf.calc_valor_frete,
				   nf.calc_valor_seguro,
				   nf.calc_outras_despesas,
				   nf.calc_valor_total_ipi,
				   nf.calc_valor_total_nota,
				   nf.observacao_fiscal,
				   nf.observacao_usuario,
				   nf.conferida,
				   nf.cod_servico_des,
				   nf.natureza_siss_id,
				   nf.incluir_siss,
				   nf.avista_aprazo,
				   nf.contabilizada,
				   nfi.num_nota_it_id, 
				   nfi.cfop, 
				   nfi.cfop_id, 
				   nfi.produto_id, 
				   nfi.descricao, 
				   nfi.cod_ncm, 
				   nfi.st_origem_id, 
				   nfi.st_icms_id, 
				   nfi.cod_unidade, 
				   nfi.qtde_peso, 
				   nfi.qtde_volume, 
				   nfi.qtde_metro, 
				   nfi.valor_em, 
				   nfi.valor_unitario, 
				   nfi.valor_total, 
				   nfi.icms_reducao_base, 
				   nfi.icms_base_calculo, 
				   nfi.icms_aliquota, 
				   nfi.icms_valor, 
				   nfi.ipi_reducao_base, 
				   nfi.ipi_base_calculo, 
				   nfi.ipi_aliquota, 
				   nfi.ipi_valor, 
				   nfi.desconto_percentual, 

				   nfi.desconto_valor, 
				   nfi.incluir_estoque, 
				   nfi.incluir_livro_fiscal, 
				   nfi.serv_total_tributavel, 
				   nfi.serv_total_nao_tributavel, 
				   nfi.serv_total_produto, 
				   nfi.serv_iss_aliquota, 
				   nfi.serv_iss_deducao, 
				   nfi.serv_iss_valor, 
				   nfi.valor_em_unidade, 
				   nfi.descricao_complemento, 
				   nfi.icms_base_calc_subst, 
				   nfi.icms_valor_subst, 
				   nfi.contabilizacao_id, 
				   nfi.icms_isentas, 
				   nfi.icms_outras, 
				   nfi.ipi_isentas, 
				   nfi.ipi_outras,
				   st.st_origem_descricao,
				   sti.st_icms_descricao,
				   n.descricao as natureza_operacao,
				   un.unidade as unidade_medida
		      from fiscal.v$nf_terceiro nf  
			  inner join kss.v$pessoa p 
				   	  on p.cod_pessoa = nf.cod_emitente 
			  inner join fiscal.v$nf_terceiro_it nft
			          on nft.num_nota_id = nf.num_nota_id
			  inner join fiscal.v$nf_item nfi
			          on nfi.num_nota_it_id = nft.num_nota_it_id
			  inner join fiscal.v$st_origem st
     				  on st.st_origem_id = nfi.st_origem_id
			  inner join fiscal.v$st_icms sti
     				  on sti.st_icms_id = nfi.st_icms_id  
			  inner join fiscal.v$cfop_id cf
					  on cf.cfop = nfi.cfop
                     and cf.id = nfi.cfop_id
			  inner join fiscal.v$natureza_operacao n
				      on n.natureza_id = cf.natureza_id
			  inner join fiscal.v$unidade_medida un
			          on un.cod_unidade =nfi.cod_unidade	
		      where 1=1
		     <cfif Len(Trim(arguments.num_nota_id))>
		   		and nf.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>
             <cfif Len(Trim(arguments.num_nota_fiscal))>
		   		and nf.num_nota_fiscal = '#arguments.num_nota_fiscal#'
		 	 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>   
    
	<!--- 
	-- PROPÓSITO
	-- Consulta os itens referentes a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 12/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_item" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select i.num_nota_it_id, 
				i.cfop, 
				i.cfop_id, 
				i.produto_id, 
				i.descricao, 
				i.cod_ncm, 
				i.st_origem_id, 
				i.st_icms_id, 
				i.cod_unidade, 
				i.qtde_peso, 
				i.qtde_volume, 
				i.qtde_metro, 
				i.valor_em, 
				i.valor_unitario, 
				i.valor_total, 
				i.icms_reducao_base, 
				i.icms_base_calculo, 
				i.icms_aliquota, 
				i.icms_valor, 
				i.ipi_reducao_base, 
				i.ipi_base_calculo, 
				i.ipi_aliquota, 
				i.ipi_valor, 
				i.desconto_percentual, 
				i.desconto_valor, 
				i.incluir_estoque, 
				i.incluir_livro_fiscal, 
				i.serv_total_tributavel, 
				i.serv_total_nao_tributavel, 
				i.serv_total_produto, 
				i.serv_iss_aliquota, 
				i.serv_iss_deducao, 
				i.serv_iss_valor, 
				i.valor_em_unidade, 
				i.descricao_complemento, 
				i.icms_base_calc_subst, 
				i.icms_valor_subst, 
				i.contabilizacao_id, 
				i.icms_isentas, 
				i.icms_outras, 
				i.ipi_isentas, 
				i.ipi_outras,
				un.unidade as unidade_medida,
		        i.icms_base_calc_subst, i.icms_valor_subst, p.categoria_id
		   from fiscal.v$nf_item i 
	 inner join fiscal.v$nf_terceiro_it t
	 	     on i.num_nota_it_id = t.num_nota_it_id
	 inner join fiscal.v$unidade_medida un
	         on un.cod_unidade = i.cod_unidade
     inner join fiscal.v$produto p
             on p.produto_id = i.produto_id
			 where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and t.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	    

	<!--- 
	-- PROPÓSITO
	-- Consulta os impostos a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- LOUIS - 12/06/2007  - criado
	--->	
	<cffunction name="get_nf_terceiro_imposto" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ni.imposto_id,
                   ni.nf_imposto_id,
                   ni.imposto_reducao_base,
                   ni.imposto_base_calculo,
                   ni.imposto_aliquota,
                   ni.imposto_total,       
                   to_char(ni.data_vencimento,'dd/mm/yyyy hh24:mi') as  data_vencimento,
                   ni.imposto_retido_fonte,
                   ni.num_nota_it_id,
                   it.num_nota_id,
                   decode(ni.imposto_retido_fonte, 1, 'Sim', 'Nao') as desc_imp_retido_fonte,
                   im.descricao_imposto as descricao_imposto,
                   i.descricao as produto,
                   i.valor_total + i.ipi_valor as valor_total,
                   (select cp.num_docto
                      from finan.v$finan_contas_pagar cp
                     inner join fiscal.v$nf_imposto_pagar ip 
                        on cp.contas_pagar_id = ip.contas_pagar_id
                     where ip.nf_imposto_id = ni.nf_imposto_id) as num_docto,
                   count(case when ni.imposto_id between 14 and 19 then 1 end) over () as tem_imposto_retido
              from fiscal.v$nf_imposto ni
                   inner join fiscal.v$nf_terceiro_it it
                           on it.num_nota_it_id = ni.num_nota_it_id
                   inner join fiscal.v$imposto im
                           on im.imposto_id = ni.imposto_id
                   inner join fiscal.v$nf_item i
                           on i.num_nota_it_id = it.num_nota_it_id
			 where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and it.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
             order by ni.imposto_id, i.descricao

   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	    

	<!--- 
	-- PROPÓSITO
	-- Consulta os rateios a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/12/2008  - criado
	--->	
	<cffunction name="get_nf_terceiro_rateio" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ntr.num_nota_id, ntr.nf_rateio_id, ntr.cod_pessoa, ntr.cod_departamento, 
                   ntr.cod_setor, ntr.cod_centro_custo, ntr.cod_contabil, nvl(pc.apelido,ntr.cod_contabil) as apelido,
                   pc.descricao, cc.centro_custo, nr.perc_rateio, nr.valor_rateio
              from fiscal.v$nf_terceiro_rateio ntr
              inner join fiscal.v$nf_rateio nr
                      on nr.nf_rateio_id = ntr.nf_rateio_id
              inner join contab.v$contab_plano_de_contas pc 
                      on pc.cod_reduzido = ntr.cod_contabil          
              inner join kss.v$centro_custo cc
                      on cc.cod_centro_custo = ntr.cod_centro_custo      
  			  where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and ntr.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	    

	<!--- 
	-- PROPÓSITO
	-- Consulta o faturamento a uma nota fiscal
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO - 10/12/2008  - criado
	--->	
	<cffunction name="get_nf_terceiro_faturamento" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ntp.num_nota_id, ntp.contas_pagar_id,
                   cp.num_docto, to_char(cp.data_vencto,'dd/mm/yyyy') as data_vencto, cp.valor_docto,
                   cp.cod_historico, cp.tipo_pagto_id, cp.docto_id
              from fiscal.v$nf_terceiro_pagar ntp
              inner join finan.v$finan_contas_pagar cp
                      on cp.contas_pagar_id = ntp.contas_pagar_id
  			  where 1=1
			 <cfif len(trim(arguments.num_nota_id))>
		   		and ntp.num_nota_id = #arguments.num_nota_id# 
		 	 </cfif>    
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	        
    
<!--- 
	-- PROPÓSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="DOMINIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv_domain dominio, 
				   rv_low_value id, 
				   rv_high_value, 
				   rv_abbreviation abreviacao, 
				   rv_meaning descricao
			  from kss.cg_ref_codes
			 where rv_domain = '#arguments.dominio#'
               and owner = 'FISCAL'
             order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca Itens para a carta frete
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  11/01/2006
	--->
	<cffunction name="get_carta_frete_item" displayname="Busca Itens para a carta frete" access="remote" returntype="query" output="true">
		<cfargument name="posto" 				required="no" default="0">
		<cfargument name="contrato_transporte" 	required="no" default="0">
		<cfargument name="ctf_frete" 	        required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select item_id, descricao, 
				   decode(desconto,1,'Desconto','Acréscimo') as tipo,
				   desconto,
				   compoe_frete, deb_cred_motorista
			  from oper.v$contrato_transp_item_setup
			 where 1=1
			  <cfif arguments.posto eq 1>
			   and mostra_posto = 1
			  </cfif>
			  <cfif arguments.contrato_transporte eq 1>
			   and mostra_lancto_ct = 1
			  </cfif>
			  <cfif arguments.ctf_frete eq 1>
			   and ctf_frete = 1
			  </cfif>
			 order by descricao	
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPÓSITO 
	-- Busca os conhecimentos romaneio
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_ctrc_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select c.conhecimento_id,
				   c.num_conhecimento,
				   c.num_romaneio,
				   c.item_id, 
                   to_char(c.data_emissao,'dd/mm/yyyy') as data_emissao,
                   cc.conhecimento_id conhecimento_id_complementado,
                   case 
                      when exists(select 'x' 
                                    from oper.v$contrato_transp_conhecimento ct
                              inner join oper.v$contrato_transp ct2
                                      on ct2.lancto_id = ct.lancto_id
                                   where ct.conhecimento_id = c.conhecimento_id) then 1 
                      else 0 
                   end ct_vinculado
			  from fiscal.v$conhecimento c
              left join fiscal.v$conhecimento_complemento cc
                     on cc.conhecimento_complemento_id = c.conhecimento_id
			 where 1=1
			   and num_romaneio in (#arguments.num_romaneio#)			
			 order by c.num_conhecimento
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPÓSITO 
	-- Busca os dados da rota
	-- CRISTOFER  14/04/2007
	--->		
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
    	<cfargument name="abreviatura" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id, r.destino_municipio_id
            	 , r.abreviatura
                 , mo.municipio municipio_origem
                 , mo.uf_id uf_origem
                 , md.municipio municipio_destino
                 , md.uf_id uf_destino
                 , r.origem_municipio_id
                 , r.destino_municipio_id
                 , r.descricao_rota
                 , md.municipio||'/'||md.uf_id as localidade
                 , 0 as valor_fixo
                 , 0 as valor_eixo
                 , 0 as valor_semparar_fixo
                 , 0 as valor_semparar_eixo
                 , r.distancia_padrao
              from oper.v$rota r
             inner join cep.municipio md
                on md.municipio_id = r.destino_municipio_id
             inner join cep.municipio mo
                on mo.municipio_id = r.origem_municipio_id
             where 1=1
             <cfif len(trim(arguments.abreviatura))>
               and upper(r.abreviatura) like upper('#arguments.abreviatura#%')
             </cfif>
             order by r.abreviatura
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPÓSITO 
	-- Busca os itinerarios do romaneio para a insercao na viagem de agregado
	-- CRISTOFER  15/04/2007
	--->		
	<cffunction name="get_romaneio_itinetario_agregado" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="">
    	<cfargument name="vazio_carregado" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.rota_id,
                   r.abreviatura as cod_rota,
                   r.descricao_rota as descricao_rota,
                   r.origem_municipio_id,
                   r.destino_municipio_id,
                   r.distancia_padrao as km,
                   to_char(i.data_previsao,'dd/mm/yyyy hh24:mi') previsao_chegada,
                   0 as pedagio_fixo,
                   0 as pedagio_eixo,
                   0 as pedagio_semparar_fixo,
                   0 as pedagio_semparar_eixo,
                   mo.municipio origem_municipio,
                   mo.uf_id origem_uf,
                   md.municipio destino_municipio,
                   md.uf_id destino_uf,
                   roo.placa_controle
              from oper.v$romaneio_itinerario i
             inner join oper.v$romaneio roo
                     on roo.num_romaneio = i.num_romaneio
             inner join oper.v$rota r
                     on r.rota_id = i.rota_id
             inner join cep.municipio md
                     on md.municipio_id = r.destino_municipio_id
             inner join cep.municipio mo
                     on mo.municipio_id = r.origem_municipio_id
             where 1=1
             <cfif len(trim(arguments.num_romaneio))>
               and i.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif len(trim(arguments.vazio_carregado))>
               and i.vazio_carregado = #arguments.vazio_carregado#
             </cfif>
             order by i.vazio_carregado,i.ordem
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPÓSITO 
	-- Busca os dados da operação para a emissao de conhecimentos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 13/12/2006
	--->		
	<cffunction name="get_operacao_ctrc" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
		<cfargument name="viagem_carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select o.operacao_id, o.pedido_shipment, 
               vc.viagem_carga_id,
               o.regra_fiscal_id,
               o.descricao as operacao,
               logistica.pkg_operacao.fnc_descricao_completa(o.operacao_id) as operacao_descricao,
               sc.valor_em as frete_em,
               o.frete_por_conta,
               rem.cod_atividade_fiscal,               
               fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,pes.municipio_id),nvl(destm.municipio_id,pesd.municipio_id),o.frete_proprio) as num_produto,
               
               rem.cod_pessoa cod_remetente,
               rem.cnpj_cpf rem_cnpj_cpf,
               nvl(rem.razao_social,rem.cliente) rem_razao_social,
               rem.inscricao_estadual rem_inscricao_estadual,
               reme.logradouro as rem_logradouro, reme.numero as rem_numero, reme.bairro as rem_bairro,
               reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro rem_endereco,
               to_char(reme.cep) rem_cep,
               nvl(remm.municipio,pes.municipio) rem_municipio,
               remm.uf_id rem_uf,
               nvl(remm.municipio_id,pes.municipio_id) rem_municipio_id,
               
               dest.cod_pessoa cod_destinatario,
               dest.cnpj_cpf dest_cnpj_cpf,
               nvl(dest.razao_social,dest.cliente) dest_razao_social,
               dest.inscricao_estadual dest_inscricao_estadual,
               trim(decode(dest.cod_pessoa,null,'',
                           deste.logradouro||decode(deste.numero,'','',',')||
                        deste.numero||' '||deste.complemento||
                           decode(deste.bairro,'','',' - ')||deste.bairro)) dest_endereco,
               to_char(deste.cep) dest_cep,
               deste.logradouro||decode(deste.numero,'','',',')||deste.numero||' '||deste.complemento||' - '||deste.bairro dest_endereco,
               deste.logradouro as dest_logradouro, deste.numero as dest_numero, deste.bairro as dest_bairro,
               nvl(destm.municipio,pesd.municipio) dest_municipio,
               destm.uf_id dest_uf,
               nvl(destm.municipio_id,pesd.municipio_id) dest_municipio_id,
    
               nvl(sc.cod_consignatario,rem.cod_pessoa) cod_consignatario,
               nvl(cons.cnpj_cpf,rem.cnpj_cpf) as cons_cnpj_cpf,
               nvl(cons.razao_social,nvl(rem.razao_social,rem.cliente)) cons_razao_social,
               nvl(cons.inscricao_estadual,rem.inscricao_estadual) cons_inscricao_estadual,
               nvl(cons_end.logradouro,reme.logradouro) as cons_logradouro, 
               nvl(cons_end.numero,reme.numero) as cons_endereco_num, 
               nvl(cons_end.bairro,reme.bairro) as cons_bairro,
               decode(sc.cod_consignatario,null,reme.logradouro||decode(reme.numero,'','',',')||reme.numero||' '||reme.complemento||' - '||reme.bairro,
                      cons_end.logradouro||decode(cons_end.numero,'','',',')||cons_end.numero||' '||cons_end.complemento||' - '||cons_end.bairro) as cons_endereco,
               nvl(to_char(cons_end.cep),to_char(reme.cep)) cons_cep,
               nvl(cons_end.municipio,nvl(remm.municipio,pes.municipio)) cons_municipio,
               nvl(cons_end.uf,remm.uf_id) as cons_uf,
               nvl(cons_end.municipio_id,nvl(remm.municipio_id,pes.municipio_id)) cons_municipio_id,               
    
               reme.cep as coleta_cep,
               reme.logradouro as coleta_logradouro,
               reme.complemento as coleta_complemento,
               reme.bairro as coleta_bairro,
               col.municipio coleta_municipio,
               reme.uf coleta_uf,
               sc.origem_municipio_id as coleta_municipio_id,
                   
               deste.cep as entrega_cep,
               deste.logradouro as entrega_logradouro,
               deste.complemento entrega_complemento,
               deste.bairro entrega_bairro,
               ent.municipio entrega_municipio,
               ent.uf_id entrega_uf,
               sc.destino_municipio_id as entrega_municipio_id,
               
               dest.cod_pessoa cod_redespacho,
               dest.cnpj_cpf redespacho_cnpj_cpf,
               nvl(dest.razao_social,dest.cliente) redespacho_razao_social,
               dest.inscricao_estadual redespacho_inscricao_estadual,
               trim(decode(dest.cod_pessoa,null,'',
                           deste.logradouro||decode(deste.numero,'','',',')||
                        deste.numero||' '||deste.complemento||
                           decode(deste.bairro,'','',' - ')||deste.bairro)) red_endereco,
               to_char(deste.cep) redespacho_cep,
               deste.logradouro as redespacho_logradouro,
               deste.logradouro as dest_logradouro, 
               deste.numero as redespacho_numero, 
               deste.bairro as redespacho_bairro,
               nvl(destm.municipio,pesd.municipio) redespacho_municipio,
               destm.uf_id redespacho_uf,
               nvl(destm.municipio_id,pesd.municipio_id) redespacho_municipio_id,
               
               cob.cod_pessoa cod_cliente_cobranca,
               cob.cnpj_cpf cob_cnpj_cpf,
               cob.razao_social cob_razao_social,
               cob.inscricao_estadual cob_inscricao_estadual,
               ecob.logradouro as cob_endereco,
               ecob.cep cob_cep,
               cobm.municipio cob_municipio,
               cobm.uf_id cob_uf,
               ecob.municipio_id cob_municipio_id,
                
                       o.cod_negociador,
                       neg.cnpj_cpf as neg_cnpj_cpf,
                       neg.razao_social as neg_razao_social,
                       neg.inscricao_estadual as neg_inscricao_estadual,
                       neg_end.logradouro || ' ' || neg_end.numero as neg_endereco,
                       to_char(neg_end.cep) as neg_cep,
                       neg_end.municipio as neg_municipio,
                       neg_end.uf as neg_uf,       
    
               sc.num_natureza,
               sc.num_especie,
               sc.cod_unidade,
               o.fracionado, o.internacional, o.frete_proprio, o.dedicado,
               logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,nvl(v.data_inicio , sysdate),' > ', 1) as composicao,
               logistica.pkg_agendamento.fnc_viagem_composicao(vc.viagem_id,nvl(v.data_inicio , sysdate),' > ') as composicao_frota,
               logistica.pkg_agendamento.fnc_viagem_motorista(vc.viagem_id) as motorista,
               (select pm.cliente from kss.v$pessoa pm where pm.cod_pessoa = logistica.pkg_agendamento.fnc_viagem_motorista(vc.viagem_id)) as motorista_nome,
               to_char(v.data_termino,'dd/mm/yyyy hh24:mi') as data_termino,
               (select count(*)
                  from fiscal.v$categoria_imp_retencao cir
                 inner join fiscal.v$produto pr
                    on pr.categoria_id = cir.categoria_id
                 where produto_id = fiscal.pkg_conhecimento.fnc_produto_frete(nvl(remm.municipio_id,
                                                                                  pes.municipio_id),
                                                                              nvl(destm.municipio_id,
                                                                                  pesd.municipio_id),
                                                                              o.frete_proprio)) as impostos
            from logistica.v$viagem_carga vc
           inner join logistica.v$viagem v
                   on v.viagem_id = vc.viagem_id
           inner join logistica.v$solicitacao_carga sc
                   on sc.solicitacao_carga_id = vc.solicitacao_carga_id           
           inner join logistica.v$operacao o
                   on o.operacao_id = sc.operacao_id                            
           inner join cep.municipio col
                   on col.municipio_id = sc.origem_municipio_id
           inner join kss.v$pessoa rem
                   on rem.cod_pessoa = sc.cod_remetente
            left join kss.v$pessoa_endereco_padrao reme
                on rem.cod_pessoa = reme.cod_pessoa
            left join kss.v$pessoa_estrangeira pes
                   on pes.cod_pessoa = rem.cod_pessoa
            left join cep.municipio remm
                on remm.municipio_id = reme.municipio_id
            left join kss.v$pessoa dest
                   on dest.cod_pessoa = sc.cod_destinatario
            left join kss.v$pessoa cob
                   on cob.cod_pessoa = sc.cod_cobranca
            left join kss.v$pessoa_endereco_padrao ecob
                   on ecob.cod_pessoa = sc.cod_cobranca
            left join cep.municipio cobm
                   on cobm.municipio_id =  ecob.municipio_id
             left join kss.v$pessoa_endereco_padrao deste
                on dest.cod_pessoa = deste.cod_pessoa
            left join kss.v$pessoa_estrangeira pesd
                   on pesd.cod_pessoa = dest.cod_pessoa
             left join cep.municipio destm
                on destm.municipio_id = deste.municipio_id
             left join cep.municipio ent
                   on ent.municipio_id = sc.destino_municipio_id
           left join kss.v$pessoa neg
                   on neg.cod_pessoa = o.cod_negociador
           left join kss.v$pessoa_endereco_padrao neg_end
                   on neg_end.cod_pessoa = o.cod_negociador
           left join kss.v$pessoa cons
                   on cons.cod_pessoa = sc.cod_consignatario
           left join kss.v$pessoa_endereco_padrao cons_end
                   on cons_end.cod_pessoa = sc.cod_consignatario
               where 1=1
           <cfif Len(Trim(arguments.OPERACAO_ID)) and not Len(Trim(arguments.VIAGEM_CARGA_ID))>
               and o.operacao_id = #arguments.OPERACAO_ID#
           </cfif>
           <cfif Len(Trim(arguments.VIAGEM_CARGA_ID))>
             and vc.viagem_carga_id = #arguments.VIAGEM_CARGA_ID#
           </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    

	<!--- 
	-- PROPÓSITO
	-- Executa todos os calculos do CTRC levando em consideração as regras fiscais
	-- guto 11/04/2006 15:46:31 - CRIADO
	--->
	<cffunction name='calcula_ctrc_comercial' displayname='Executa todos os calculos do CTRC levando em considera??o as regras fiscais' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes' >
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='VALOR_MERCADORIA' required='yes'>
		<cfargument name='AD_VALOREM' required='no' default="0">
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='ENTREGA_UF' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COD_REMETENTE' required='no' default="">
		<cfargument name='COD_CLIENTE_COBRANCA' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
		<cfargument name='REGRA_FISCAL_ID' required='no' default="1">
		<cfargument name='COLETA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='no' default="">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='SEM_ICMS' required='no' default="0">
		<!---Novos campos para CONTRATO--->	
		<cfargument name='COD_NEGOCIADOR' required='no' default="">
		<cfargument name='FRACIONADO' required='no' default="">
		<cfargument name='NUM_NATUREZA' required='no' default="">
		<cfargument name='COD_TABELA_FRETE' required='no' default="">
		<cfargument name='VALOR_TOTAL_NOTA' required='no' default="">
		<cfargument name='FLAG_COLETA' required='no' default="">
		<cfargument name='NUM_EIXOS' required='no' default="">
		<cfargument name='FLAG_URGENTE' required='no' default="">
		<cfargument name='FLAG_TRUCK' required='no' default="">
		<cfargument name='NUM_AJUDANTES' required='no' default="">
		<cfargument name='NUM_ENTREGAS' required='no' default="">
		<cfargument name='FLAG_LOTACAO' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='CTRC_COMPLEMENTAR' required='no' default="0">
		<cfargument name='ADEME' required='no' default="">
		<cfargument name='NOTA_FISCAL' required='no' default="0">
		<cfargument name='FRETE_EM' required='no' default="">        
    	<cftry>        
            <cfstoredproc procedure='fiscal.pkg_conhecimento.prc_calcula_ctrc_comercial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#' variable="retorno.PESO">
    
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#' variable='retorno.DESPACHO'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#' variable='retorno.SEC_CAT'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#' variable='retorno.GRIS'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#' variable='retorno.PEDAGIO'>
    
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#' variable="retorno.NUM_PRODUTO">
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGO_POR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#' variable='retorno.COLETA_ENTREGA' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='COLETA_UF'  value='#arguments.COLETA_UF#'  null='#iif(len(trim(arguments.COLETA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='ENTREGA_UF' value='#arguments.ENTREGA_UF#'  null='#iif(len(trim(arguments.ENTREGA_UF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MERCADORIA' value='#arguments.VALOR_MERCADORIA#' null='#iif(len(trim(arguments.VALOR_MERCADORIA)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AD_VALOREM' value='#arguments.AD_VALOREM#' null='#iif(len(trim(arguments.AD_VALOREM)), de('no'), de('yes'))#' variable='retorno.AD_VALOREM'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#' variable='retorno.FRETE_UNITARIO' null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
    
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR' value='#arguments.FRETE_VALOR#'  variable='retorno.FRETE_VALOR'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO' variable='retorno.FRETE_PESO'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO' variable='retorno.TOTAL_CONHECIMENTO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS' variable='retorno.BASE_CALCULO_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS' variable='retorno.ALIQUOTA_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS' variable='retorno.VALOR_ICMS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT' variable='retorno.VALOR_ICMS_SUBSTIT' >
    
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE' value='#arguments.COD_REMETENTE#' null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COD_UNIDADE' value='#arguments.COD_UNIDADE#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_REGRA_FISCAL_ID' value='#arguments.regra_fiscal_id#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_COB_UF' value='#arguments.COB_UF#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID' value='#arguments.COLETA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID' value='#arguments.ENTREGA_MUNICIPIO_ID#' null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE' value='#arguments.NUM_LOTE#' null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEM_ICMS' value='#arguments.SEM_ICMS#' null='#iif(len(trim(arguments.SEM_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA' value='#arguments.COD_CLIENTE_COBRANCA#' null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_FILIAL' value='#arguments.UF_EMITENTE#'>
    
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP' variable='retorno.CFOP' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID' variable='retorno.CFOP_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO' variable='retorno.NATUREZA_OPERACAO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL' variable='retorno.FUNDAMENTACAO_LEGAL' >
				<!---Novos campos para CONTRATO--->	
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_INCLUSO' variable='retorno.PEDAGIO_INCLUSO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR' value='#arguments.COD_NEGOCIADOR#' null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRACIONADO' value='#arguments.FRACIONADO#' null='#iif(len(trim(arguments.FRACIONADO)), de('no'), de('yes'))#'>
                <!---Se possuir M3 então é 1 (por volume) senão é PESO (0)--->
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_UNIDADE_COBRANCA' value='#iif(arguments.M3 gt 0,DE("1"),DE("0"))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA' value='#arguments.NUM_NATUREZA#' null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TABELA_FRETE_RET' variable='retorno.COD_TABELA_FRETE_RET' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_CONTRATO' variable='retorno.DESCRICAO_CONTRATO' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_LISTA_TABELA_FRETE' variable='retorno.LISTA_TABELA_FRETE' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TABELA_FRETE' value='#arguments.COD_TABELA_FRETE#' null='#iif(len(trim(arguments.COD_TABELA_FRETE)), de('no'), de('yes'))#'> 
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL_NOTA' value='#arguments.VALOR_TOTAL_NOTA#' null='#iif(len(trim(arguments.VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_COLETA' value='#arguments.FLAG_COLETA#' null='#iif(len(trim(arguments.FLAG_COLETA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_EIXOS' value='#arguments.NUM_EIXOS#' null='#iif(len(trim(arguments.NUM_EIXOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_URGENTE' value='#arguments.FLAG_URGENTE#' null='#iif(len(trim(arguments.FLAG_URGENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_TRUCK' value='#arguments.FLAG_TRUCK#' null='#iif(len(trim(arguments.FLAG_TRUCK)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_AJUDANTES' value='#arguments.NUM_AJUDANTES#' null='#iif(len(trim(arguments.NUM_AJUDANTES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ENTREGAS' value='#arguments.NUM_ENTREGAS#' null='#iif(len(trim(arguments.NUM_ENTREGAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FLAG_LOTACAO' value='#arguments.FLAG_LOTACAO#' null='#iif(len(trim(arguments.FLAG_LOTACAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3' value='#arguments.M3#' null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_OUTROS' variable='retorno.OUTROS' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_COBRADO' variable='retorno.PESO_COBRADO' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CTRC_COMPLEMENTAR' value='#arguments.CTRC_COMPLEMENTAR#' null='#iif(len(trim(arguments.CTRC_COMPLEMENTAR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME' value='#arguments.ADEME#' null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NOTA_FISCAL' value='#arguments.NOTA_FISCAL#' null='#iif(len(trim(arguments.NOTA_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QUANTIDADE' value='#arguments.QUANTIDADE#' null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM' value='#arguments.FRETE_EM#'>
            </cfstoredproc>
            <cfif not Len(Trim(retorno.FRETE_UNITARIO))>
                <cfset retorno.FRETE_UNITARIO = 0>
            </cfif>		
            <cfif not Len(Trim(retorno.AD_VALOREM))>
                <cfset retorno.AD_VALOREM = 0>
            </cfif>		
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfif Find('ORA-',cfcatch.Detail,10)>
	            <cfset retorno.mensagem_str = Mid(cfcatch.Detail,1,Find('ORA-',cfcatch.Detail,10)-1)>
            <cfelse>
                <cfset retorno.mensagem_str = cfcatch.Message>
            </cfif>
            <cfset retorno.mensagem = cfcatch.detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno/>
	</cffunction>	    
    
	<!--- 
	-- PROPÓSITO 
	-- Busca romaneio
	-- CRISTOFER  18/12/2006
	--->		
	<cffunction name="get_produto_frete" access="remote" returntype="query" output="true">
		<cfargument name="municipio_id_origem" required="no" default="">
		<cfargument name="municipio_id_destino" required="no" default="">
		<cfargument name="frete_proprio" required="no" default="">
        <cfif Len(Trim(frete_proprio)) >
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select fiscal.pkg_conhecimento.fnc_produto_frete(#arguments.municipio_id_origem#, #arguments.municipio_id_destino#, #arguments.frete_proprio#) as num_produto
                  from dual
            </cfquery>
        <cfelse>
            <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                  select produto_id, descricao as produto
                  from fiscal.v$produto p
                 inner join table(kss.pkg_string.fnc_split(fiscal.pkg_conhecimento.fnc_produto_frete_list(#arguments.municipio_id_origem#, #arguments.municipio_id_destino#),';')) a
                         on a.column_value = p.produto_id  
          </cfquery>
        </cfif>
		<cfreturn qr_result>		
	</cffunction>
	
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Série para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_serie_nota" displayname="Busca Série para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="cod_departamento" required="no" default=""/>
		<cfargument name="cod_setor" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1">
		<cfargument name="todas" required="no" default="0">
		<cfargument name="todos_modelos" required="no" default="0">
		<cfif arguments.TODAS eq 0>
        	<cfif arguments.todos_modelos eq 0>
                <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                    select ms.cod_pessoa, ms.cod_departamento, ms.cod_setor,
                             ms.cod_modelo, ms.serie, ms.subserie, ms.num_inicial, 
                             ms.num_final, ms.documento_proprio, ms.incluir_livro_fiscal, ms.INCLUIR_SINTEGRA
                      from fiscal.v$modelo_serie ms
                     where ms.ativo = 1
                        and ms.documento_proprio = #arguments.documento_proprio#
                    <cfif Len(Trim(arguments.cod_modelo))>
                        and ms.cod_modelo in (#PreserveSingleQuotes(arguments.cod_modelo)#)
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and ms.cod_pessoa = #arguments.cod_pessoa#
                        and ms.cod_departamento = #arguments.cod_departamento#
                        and ms.cod_setor = #arguments.cod_setor#
                    </cfif>
                    order by ms.cod_pessoa, ms.cod_departamento, ms.cod_setor, ms.cod_modelo, ms.serie, ms.subserie 
                </cfquery>		
            <cfelse>
                <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                    select distinct ms.cod_modelo, ms.serie, ms.INCLUIR_SINTEGRA
                      from fiscal.v$modelo_serie ms
                     where ms.ativo = 1
                        and ms.documento_proprio = #arguments.documento_proprio#
                    <cfif Len(Trim(arguments.cod_modelo))>
                        and ms.cod_modelo in (#PreserveSingleQuotes(arguments.cod_modelo)#)
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and ms.cod_pessoa = #arguments.cod_pessoa#
                        and ms.cod_departamento = #arguments.cod_departamento#
                        and ms.cod_setor = #arguments.cod_setor#
                    </cfif>
                    order by ms.cod_modelo, ms.serie
                </cfquery>		
            </cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.serie, ms.documento_proprio, ms.incluir_livro_fiscal, ms.INCLUIR_SINTEGRA
				  from fiscal.v$modelo_serie ms
				 where ms.ativo = 1
					and ms.documento_proprio = #arguments.documento_proprio#
				order by ms.serie
			</cfquery>		
		</cfif>
		<cfreturn qr_result>
	</cffunction>
	<!--- 
	-- PROPÓSITO 
	-- Busca ISS para o municipio
	-- GUTO 29/05/2009
	--->		
	<cffunction name="get_iss_municipio" access="remote" returntype="query" output="true">
    	<cfargument name="municipio_id" required="no" default=""/>
        <cfargument name="produto_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.iss_aliquota 
              from fiscal.v$municipio_iss m
            where m.municipio_id = #arguments.municipio_id#
            <cfif Len(Trim(arguments.produto_id))>
			  and exists (select 'x'
                            from fiscal.v$categoria_imp_retencao cir
                           where cir.categoria_id = (select p.categoria_id
                                                       from fiscal.v$produto p
                                                      where p.produto_id = #arguments.produto_id# ) 
                             and cir.imposto_id in(31,41,42,43))
            </cfif>            			
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
   
    <!--- 
	-- PROPÓSITO 
	-- Busca ISS para o produto. Os impostos são considerados na seguinte ordem:
	--	1 - Deve ser considerado a aliquota cadastrada para a gestão de impostos.
	--	2 - Não havendo o anterior, deve ser considerado a aliquota cadastrada no imposto
	--	3 - Não havendo os anteriores, deve ser considerada a aliquota do município
	--
	-- WAGNERS 30/09/2011	
	--->		
	<cffunction name="get_iss_produto" access="remote" returntype="query" output="true">
    	<cfargument name="municipio_id" required="no" default=""/>
        <cfargument name="produto_id" required="no" default=""/>
        
        <cfscript>
	        ret = this.get_produto( produto_id = arguments.produto_id );
        </cfscript>
        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select coalesce(ig.imposto_aliquota, i.imposto_aliquota,m.iss_aliquota) as iss_aliquota, 
			       coalesce(ig.imposto_reducao_base, i.imposto_reducao_base, 0) as imposto_reducao_base
               from fiscal.v$municipio_iss m
               left join fiscal.v$categoria_imp_retencao ci
                 on ci.categoria_id = #ret.categoria_id#
                and ci.imposto_id in(31,41,42,43)
               left join fiscal.v$imposto_gestao ig
                 on ig.categoria_id = ci.categoria_id
               left join fiscal.v$imposto i
                 on i.imposto_id = ci.imposto_id
              where m.municipio_id = #arguments.municipio_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
    
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Modelos para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 17/07/2009 - ALTERADO
	--->
	<cffunction name="get_nota_modelo" displayname="Busca Modelos para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
        <cfargument name="agrupar" required="no" default="1" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.cod_modelo
                	 , smf.modelo                     
				<cfif arguments.agrupar eq 0>
                 	 , ms.serie
                  	 , ms.subserie
                </cfif>
                  from fiscal.v$modelo_serie ms
                 inner join fiscal.v$sintegra_modelo_fiscal smf
                  	     on smf.cod_modelo = ms.cod_modelo
                 where 1 = 1
                   and ms.ativo = 1
				<cfif len(trim(arguments.documento_proprio))>
				   and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				</cfif>
                <cfif Len(Trim(arguments.nfes))>
				   and smf.nfes = '#arguments.nfes#' 
				</cfif>
				<cfif Len(Trim(arguments.cod_modelo))>
				   and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				</cfif>
				<cfif Len(Trim(arguments.serie))>
				   and ms.serie ='#arguments.serie#'
				</cfif>
                <cfif Len(Trim(arguments.cod_departamento))>
				   and ms.cod_departamento ='#arguments.cod_departamento#'
				</cfif>
                <cfif Len(Trim(arguments.cod_pessoa))>
				   and ms.cod_pessoa ='#arguments.cod_pessoa#'
				</cfif>
                <cfif Len(Trim(arguments.cod_setor))>
				   and ms.cod_setor ='#arguments.cod_setor#'
				</cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
				   and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				</cfif>
                <cfif arguments.agrupar eq 1>
                 group by ms.cod_modelo , smf.modelo
                </cfif>
				 order by ms.cod_modelo
			</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Séries para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_nota_serie" displayname="Busca Séries para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.serie
                           from fiscal.v$modelo_serie ms
                     inner join fiscal.v$sintegra_modelo_fiscal smf
                     	     on smf.cod_modelo = ms.cod_modelo
                          where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                  <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 group by ms.serie
				 order by ms.serie
				</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Sub-Séries para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_nota_subserie" displayname="Busca Sub-Séries para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.subserie
                      ,nvl((select (max(nf.num_nota_fiscal)+1)
                              from fiscal.v$nf_es nf
                             where nf.cod_pessoa_filial = ms.cod_pessoa
                               and nf.cod_departamento  = ms.cod_departamento
                               and nf.cod_setor         = ms.cod_setor
                               and nf.cod_centro_custo  = ms.cod_centro_custo
                               and nf.cod_modelo        = ms. cod_modelo
                               and nf.serie             = ms.serie
                               and nf.subserie          = ms.subserie),(ms.num_inicial)) as prox_nota
                      , ms.incluir_livro_fiscal
                	  , ms.incluir_sintegra
                           from fiscal.v$modelo_serie ms
                     inner join fiscal.v$sintegra_modelo_fiscal smf
                     	     on smf.cod_modelo = ms.cod_modelo
                          where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                  <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 order by ms.subserie
				</cfquery>		
		<cfreturn qr_result>
	</cffunction>
          
    <!--- 
	-- PROPÓSITO 
	-- Busca Sub-series para as notas com base no SINTEGRA
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/04/2006
	--->
	<cffunction name="get_sub_serie_nota" displayname="Busca Sub-series para as notas com base no SINTEGRA" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="todas" required="no" default="0" />
        <cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
        <cfargument name="carga_transportada" required="no" default="" />
		<cfif arguments.TODAS eq 0>
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.cod_modelo
                               ,ms.serie
                               ,ms.subserie
                               ,smf.modelo
                               ,nvl((select (max(nf.num_nota_fiscal)+1)
                                       from fiscal.v$nf_es nf
                                       where nf.cod_pessoa_filial = ms.cod_pessoa
                                       and nf.cod_departamento  = ms.cod_departamento
                                       and nf.cod_setor         = ms.cod_setor
                                       and nf.cod_centro_custo  = ms.cod_centro_custo
                                       and nf.cod_modelo        = ms. cod_modelo
                                       and nf.serie             = ms.serie
                                       and nf.subserie          = ms.subserie),(ms.num_inicial)) as prox_nota
                          	from fiscal.v$modelo_serie ms
                      inner join fiscal.v$sintegra_modelo_fiscal smf
                       	      on smf.cod_modelo = ms.cod_modelo
                              
                           where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                 <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
                 <cfif Len(Trim(arguments.carga_transportada))>
					and smf.cod_modelo in (select column_value 
                           from table(kss.str2table(replace(kss.pkg_global.fnc_parametro_str(25,'FISCAL.EXE',9,405),',',';')))
                                          )
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 order by ms.cod_modelo, ms.serie, ms.subserie
				</cfquery>		
		<cfelse>			
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select distinct ms.subserie
				  from fiscal.v$modelo_serie ms
				 where 1=1
				 and ms.ativo = 1 
				 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
				</cfquery>		
		</cfif>
		<cfreturn qr_result>
	</cffunction>		
    
    <!--- 
	-- PROPÓSITO 
	-- Busca o organograma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/01/2006
	--->	
    <cffunction name="get_departamento" displayname="Busca o organograma" access="remote" returntype="query" output="true">
        <cfargument name="COD_PESSOA" 		required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
            select /*+FIRST_ROWS*/ distinct pj.cod_pessoa, pj.cliente nome_fantasia, d.cod_departamento, d.descricao as departamento
             from kss.v$organograma o 
            inner join kss.v$unidade_negocio u
               on o.cod_unidade_negocio = u.cod_unidade_negocio
            inner join kss.v$pessoa pj 
               on u.cod_pessoa = pj.cod_pessoa
            inner join kss.v$departamento d
               on o.cod_departamento = d.cod_departamento
            inner join kss.v$setor s
               on o.cod_setor = s.cod_setor				
            inner join kss.v$centro_custo c
               on o.cod_centro_custo = c.cod_centro_custo
            where 1=1
            <cfif len(trim(arguments.COD_PESSOA))>
              and u.cod_pessoa = #arguments.COD_PESSOA#
            </cfif>
            <cfif len(trim(arguments.COD_DEPARTAMENTO))>
              and d.cod_departamento = #arguments.COD_DEPARTAMENTO#
            </cfif>  
            <cfif len(trim(arguments.operacao_id))>
	          and d.cod_departamento in (select o.cod_departamento
                                           from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                                   on o.cod_organograma = ofe.cod_organograma                                                   
                                           where ofe.operacao_id = #arguments.operacao_id#)
            </cfif>                                    
            order by nome_fantasia, departamento
        </cfquery>
        <cfreturn qr_organograma>
    </cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca o setor
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/01/2006
	--->	
	<cffunction name="get_setor" displayname="Busca o organograma" access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" 		required="no" default="">
		<cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" required="no" default="">
        <cfargument name="OPERACAO_ID" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/ distinct u.cod_unidade_negocio, pj.cod_pessoa, pj.cliente nome_fantasia, s.cod_setor, s.descricao as setor
			 from kss.v$organograma o 
			inner join kss.v$unidade_negocio u
			   on o.cod_unidade_negocio = u.cod_unidade_negocio
			inner join kss.v$pessoa pj 
			   on u.cod_pessoa = pj.cod_pessoa
			inner join kss.v$departamento d
			   on o.cod_departamento = d.cod_departamento
			inner join kss.v$setor s
			   on o.cod_setor = s.cod_setor				
			inner join kss.v$centro_custo c
			   on o.cod_centro_custo = c.cod_centro_custo
			where 1=1
			<cfif len(trim(arguments.COD_PESSOA))>
			  and u.cod_pessoa = #arguments.COD_PESSOA#
			</cfif>
			<cfif len(trim(arguments.COD_DEPARTAMENTO))>
			  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
			</cfif>
            <cfif len(trim(arguments.COD_SETOR))>
			  and s.cod_setor = #arguments.COD_SETOR#
			</cfif>
            <cfif len(trim(arguments.OPERACAO_ID))>
	          and s.cod_setor in (select o.cod_setor
                                           from logistica.v$operacao_filial_emissao ofe
                                           inner join kss.v$organograma o
                                                   on o.cod_organograma = ofe.cod_organograma                                                   
                                           where ofe.operacao_id = #arguments.operacao_id#)
            </cfif>                                    
			order by nome_fantasia, setor
		</cfquery>
		<cfreturn qr_organograma>
	</cffunction>
       
     <!--- 
	-- PROPÓSITO
	-- Consulta o ultimo numero de conhecimento 
	-- NOTAS EXPLICATIVAS
	--  
	-- RAFAEL - 02/09/2009  - alterado
	--->	
	<cffunction name="get_num_conhecimento" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
        <cfargument name="cod_setor" required="no" default=""/>
        <cfargument name="cod_departamento" required="no" default=""/>
        <cfargument name="cod_centro_custo" required="no" default=""/>
		<cfif not Len(Trim(arguments.cod_pessoa_filial))>
        	<cfset arguments.cod_pessoa_filial = session.cod_pessoa />
        </cfif>
        <cfif not Len(Trim(arguments.cod_setor))>
        	<cfset arguments.cod_setor = session.cod_setor/>
        </cfif>
        <cfif not Len(Trim(arguments.cod_departamento))>
        	<cfset arguments.cod_departamento = session.cod_departamento/>
        </cfif>
        <cfif not Len(Trim(arguments.cod_centro_custo))>
        	<cfset arguments.cod_centro_custo = session.cod_centro_custo/>
        </cfif>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select nvl(max(c.num_conhecimento),0) + 1 as num_conhecimento
              from fiscal.v$conhecimento c
             where c.cod_pessoa_filial 	= #arguments.cod_pessoa_filial#
               and c.cod_setor			= #arguments.cod_setor#
               and c.cod_departamento	= #arguments.cod_departamento#
               and c.cod_centro_custo 	= #arguments.cod_centro_custo#
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca todos os Conhecimentos lista
	-- NOTAS EXPLICATIVAS
	-- LOUIS 13/03/2006
	--->
	<cffunction name="get_conhecimento_print" displayname="Busca os dados do conhecimento" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" displayname="Identificador do sistema para o conhecimento" required="yes">
		<cfargument name="documento_id" required="no" default=""/>
		<cfquery datasource="#session.dsn#" name="qr_conhecimento_lista" username="#session.usuario#" password="#session.senha#">
            select c.conhecimento_id
            	   <cfif Len(Trim(arguments.documento_id))>
                   ,#arguments.documento_id# as doc_contrato
                   </cfif>
                   ,c.num_conhecimento,
                   (select pe.municipio
                      from kss.v$pessoa_endereco pe
                     where pe.cod_pessoa = c.cod_pessoa_filial
                       and pe.endereco_padrao = 1) as municipio_emissao,
                   to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   to_char(c.data_emissao, 'dd')||' de '||to_char(c.data_emissao, 'month')||' de '||to_char(c.data_emissao, 'yyyy') as data_emissao_extenso,
                   (select p.razao_social from kss.v$pessoa p
                     where p.cod_pessoa = c.cod_pessoa_filial) as emitente_razao_social,
                   
                   --transportador
                   c.prop_razao_social as transportador_nome,
                   c.prop_endereco transportador_endereco,
                   (select municipio from kss.v$pessoa_endereco_padrao te
                     where te.cod_pessoa = c.cod_proprietario) as transportador_municipio,
                   c.prop_uf as transportador_uf,
                   (select telefone from kss.v$pessoa_telefone_padrao tt
                     where tt.cod_pessoa = c.cod_proprietario) as transportador_telefone,
                   (select identificador from kss.v$pessoa tp
                     where tp.cod_pessoa = c.cod_proprietario) as transportador_cnpj,
                   
                   --motorista
                   c.nome_motorista as motorista_nome,
                   (select logradouro||' ,'||numero||' , '||bairro||' '||complemento from kss.v$pessoa_endereco_padrao me
                     where me.cod_pessoa = c.cod_motorista) as motorista_endereco,
                   (select municipio from kss.v$pessoa_endereco_padrao me
                     where me.cod_pessoa = c.cod_motorista) as motorista_municipio,
                   (select uf from kss.v$pessoa_endereco_padrao me
                     where me.cod_pessoa = c.cod_motorista) as motorista_uf,
                   (select telefone from kss.v$pessoa_telefone_padrao mt
                     where mt.cod_pessoa = c.cod_motorista) as motorista_telefone,
                   (select identificador from kss.v$pessoa mp
                     where mp.cod_pessoa = c.cod_motorista) as motorista_cnpj,
                   (select cnh_num_registro from kss.v$pessoa_fisica mpf
                     where mpf.cod_pessoa = c.cod_motorista) as motorista_cnh, 
                   
                   --veiculo tracionador
                   c.placa_tracao as placa_tracao,
                   (select cor_predominante from oper.v$veiculo v
                     where v.placa = c.placa_tracao) as tracao_cor,
                   (select ano from oper.v$veiculo v
                     where v.placa = c.placa_tracao) as tracao_ano,
                   (select chassis from oper.v$veiculo v
                   where v.placa = c.placa_tracao) as tracao_chassis,
                   (select renavan from oper.v$veiculo v
                     where v.placa = c.placa_tracao) as tracao_renavam,
                            (select vm2.marca|| ' ' || vm.modelo from oper.v$veiculo v
                         inner join oper.v$veiculo_modelo vm
                                 on vm.modelo_id = v.modelo_id
                         inner join oper.v$veiculo_marca vm2
                                 on vm2.marca_id = v.marca_id
                              where v.placa = c.placa_tracao) as tracao_modelo,
                     
                   --veiculos tracionados
                   case
                       when c.placa_tracao <> c.placa then
                            c.placa
                   end  as tracionado_placa,
                   case
                       when c.placa_tracao <> c.placa then
                            (select v.cor_predominante from oper.v$veiculo v
                              where v.placa = c.placa)
                   end  as tracionado_cor,
                   case
                       when c.placa_tracao <> c.placa then
                            (select v.ano from oper.v$veiculo v
                              where v.placa = c.placa)
                   end  as tracionado_ano,
                   case
                       when c.placa_tracao <> c.placa then
                            (select v.chassis from oper.v$veiculo v
                              where v.placa = c.placa)
                   end  as tracionado_chassis,
                   case
                       when c.placa_tracao <> c.placa then
                            (select v.renavan from oper.v$veiculo v
                              where v.placa = c.placa)
                   end  as tracionado_renavam,
                   
                   --coleta / entrega
                   mcol.municipio as coleta_municipio,
                   mcol.uf_id as coleta_uf,
                   ment.municipio as entrega_municipio,
                   ment.uf_id as entrega_uf,
                   
                   --dados do frete
                   nvl2(ct.valor_frete_bruto, to_char(ct.valor_frete_bruto,'FM9G9999G990D00','nls_numeric_characters=,.'), '0,00')as frete_bruto,
                   nvl2(ctf.cf_pedagio,ctf.cf_pedagio,'0,00')as frete_pedagio,
                   nvl2(ctf.CF_IRRF,ctf.CF_IRRF,'0,00') as frete_irrf,
                   nvl2(ctf.CF_INSS,ctf.CF_INSS,'0,00') as frete_inss,
                   nvl2(ctf.CF_SEST_SENAT,ctf.CF_SEST_SENAT,'0,00') as frete_sest_senat,
                   nvl2(ctf.CF_VALOR_LIQUIDO ,ctf.CF_VALOR_LIQUIDO,'0,00') as frete_liquido,
                   nvl2(ctf.CF_ADIANT,ctf.CF_ADIANT,'0,00') as frete_adiantamento,
                   nvl2(ctf.CF_SALDO_FRETE,ctf.CF_SALDO_FRETE,'0,00') as frete_saldo,
                   fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as notas_fiscais
                   -- Logo e endereço da filial
                  , (select pl.logotipo
                      from kss.v$pessoa_logotipo pl
                     where pl.cod_pessoa = 1
                    ) as logo
                  , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = 1
                     ) as razao_social_filial
                  /*, (select pe.logradouro || ', ' || pe.numero
                       from kss.v$pessoa_endereco_padrao pe
                      where pe.cod_pessoa = c.cod_pessoa_filial
                    ) as endereco_filial
                  , (select pe.bairro || ' ' || 'C.E.P.: ' || kss.pkg_string.fnc_formata_cep(pe.cep) as cep
                       from kss.v$pessoa_endereco pe
                      where pe.cod_pessoa = c.cod_pessoa_filial
                    ) as bairro_filial
                  , (select m.municipio || ' - ' || m.uf_id || ' Tel: ' || tp.fone_cod_pais || ' ' || tp.telefone
                       from cep.municipio m
                      inner join kss.v$pessoa_endereco pe
                              on pe.municipio_id = m.municipio_id 
                      inner join kss.v$pessoa_telefone_padrao tp
                              on tp.cod_pessoa = pe.cod_pessoa
                      where pe.cod_pessoa = c.cod_pessoa_filial
                    ) as cidade_filial*/
              from fiscal.v$conhecimento c
             inner join kss.v$departamento dp
                     on dp.cod_departamento = c.cod_departamento
             inner join kss.v$setor st
                     on st.cod_setor = c.cod_setor
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo = c.cod_centro_custo
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = c.cod_pessoa_filial
              left join fiscal.v$unidade_medida und
                     on und.cod_unidade = c.cod_unidade
              left join cep.municipio mcol
                     on mcol.municipio_id = c.coleta_municipio_id
              left join cep.municipio ment
                     on ment.municipio_id = c.entrega_municipio_id
              left join oper.v$contrato_transp ct
                     on ct.num_romaneio = c.num_romaneio
                    and ct.data_cancelamento is null
              left join oper.v$contrato_transp_form ctf
                     on ctf.documento_id = ct.lancto_id
              where 1 = 1
       <cfif Len(Trim(Arguments.conhecimento_id))>
            and c.conhecimento_id = '#Arguments.conhecimento_id#'
       </cfif>
	   order by trunc(c.data_emissao)
	  </cfquery>
	   <cfreturn qr_conhecimento_lista>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca os impostos para a NF Frete
	-- RAFAEL 02/12/2009
	--->		
	<cffunction name="get_impostos_nf_frete" access="remote" returntype="query" output="true">
    	<cfargument name="categoria_id" required="no" default="">
        <cfargument name="municipio_id" required="no" default="">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select i.imposto_id,
                   i.descricao_imposto,
                   i.imposto_reducao_base,
                   case
                     when i.imposto_id in (31,41,42,43)
                       then nvl((select mi.iss_aliquota
                                   from fiscal.v$municipio_iss mi
                                  where mi.municipio_id = #arguments.municipio_id#), i.imposto_aliquota)
                   else i.imposto_aliquota end imposto_aliquota,
                   c.categoria_id
              from fiscal.v$categoria_imp_retencao c
             inner join fiscal.v$imposto_docto_fiscal i on i.imposto_id = c.imposto_id
             where 1 = 1
          <cfif Len(Trim(arguments.categoria_id))>
               and c.categoria_id in (#arguments.categoria_id#)
          </cfif>
       </cfquery>
	   <cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPÓSITO 
    -- Retorna os dados para a Lista de Notas Fiscais de Serviço
    -- ANDERSON 20/07/2009 - CRIADO
    --->		
    <cffunction name="get_nf_es_lista" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="subserie" required="no" default="">
        <cfargument name="emitida" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
        <cfargument name="conferida" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select count(*)
                      from fiscal.v$nf_es nf2
                     inner join kss.v$organograma o
                             on o.cod_pessoa = nf2.cod_pessoa_filial
                            and o.cod_departamento = nf2.cod_departamento
                            and o.cod_setor = nf2.cod_setor
                            and o.cod_centro_custo = nf2.cod_centro_custo
                     where nf2.num_nota_id = nf.num_nota_id
                       and nf2.cod_pessoa_filial = #session.cod_pessoa#
                       and nf2.emitida = 0) as impresso
                 , nf.num_nota_id
                 , nf.num_nota_fiscal
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.num_docto), '/'))
                      from fiscal.v$nf_es_receber nfr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = nfr.contas_receber_id
                     where nfr.num_nota_id = nf.num_nota_id) as num_fatura
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = nf.cod_pessoa_filial) as filial
                 , to_char(nf.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , nf.dest_razao_social
                 , nf.dest_municipio
                 , nf.dest_uf
                 , nf.calc_valor_total_nota as valor_bruto
                 , nf.serv_iss_valor as valor_iss
                 , (nf.calc_valor_icms +
                    nf.calc_valor_icms_subst +
                    nf.calc_valor_total_ipi +
                    fiscal.pkg_nf_es.fnc_valor_retencao_impostos(nf.num_nota_id)) as valor_impostos
                 , nf.valor_faturamento as valor_liquido
                 , nf.user_insert
                 , to_char(nf.date_insert, 'dd/mm/yyyy') as date_insert
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(ni.descricao), '/'))
                      from fiscal.v$nf_es_it nfi
                     inner join fiscal.v$nf_item ni
                             on ni.num_nota_it_id = nfi.num_nota_it_id
                     where nfi.num_nota_id = nf.num_nota_id) as tipo_servico
                 , nf.serie
                 , to_char(nf.data_es, 'dd/mm/yyyy') as data_es
                 , nf.natureza_descricao
                 , (nf.calc_valor_icms + nf.calc_valor_icms_subst) as valor_icms
                 , nf.trp_peso_liquido
                 , (case nf.cancelada
                        when 1 then 'Sim'
                        when 0 then 'Não'
                   end) cancelada
                 , nf.cod_organizacional || ' - ' ||
                   (select descricao
                      from kss.v$organizacional org
                     where org.organizacional_id = nf.organizacional_id ) as organizacional
              from fiscal.v$nf_es nf
              inner join kss.v$pessoa ps
              on ps.cod_pessoa = nf.cod_pessoa_filial
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and nf.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and nf.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and nf.organizacional_id = #arguments.organizacional_id_gerencial#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and nf.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.num_nota_fiscal))>
               and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
            </cfif>
            <cfif Len(Trim(arguments.cod_modelo))>
               and nf.cod_modelo = '#arguments.cod_modelo#'
            </cfif>
            <cfif Len(Trim(arguments.serie))>
               and nf.serie = '#arguments.serie#'
            </cfif>
            <cfif Len(Trim(arguments.subserie))>
               and nf.subserie = '#arguments.subserie#'
            </cfif>
            <cfif Len(Trim(arguments.emitida)) and arguments.emitida eq 1>
               and nf.emitida = 1
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
            	<cfif arguments.cancelada eq 0>
					and nf.cancelada = 0
				<cfelseif arguments.cancelada eq 1>
                	and nf.cancelada = 1
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.conferida)) and arguments.conferida eq 1>
               and nf.conferida = 1
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(nf.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(nf.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by nf.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPÓSITO 
    -- Retorna os dados para a Lista de Notas Fiscais de Frete Municipal
    -- ANDERSON 20/07/2009 - CRIADO
    --->		
    <cffunction name="get_nf_es_frete_lista" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="organizacional_id_gerencial" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfargument name="serie" required="no" default="">
        <cfargument name="subserie" required="no" default="">
        <cfargument name="emitida" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
        <cfargument name="conferida" required="no" default="">
        <cfargument name="terceiro" required="no" default="">
        <cfargument name="tipo_pessoa" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select count(*)
                      from fiscal.v$nf_es nf2
                     inner join kss.v$organograma o
                             on o.cod_pessoa = nf2.cod_pessoa_filial
                            and o.cod_departamento = nf2.cod_departamento
                            and o.cod_setor = nf2.cod_setor
                            and o.cod_centro_custo = nf2.cod_centro_custo
                     where nf2.num_nota_id = nf.num_nota_id
                       and nf2.cod_pessoa_filial = #session.cod_pessoa#
                       and nf2.emitida = 0) as impresso
            	 , nff.nf_es_id

            	 , nf.num_nota_fiscal
                 , nff.num_romaneio
                 , (select kss.fnc_concat_all(kss.to_concat_expr(to_char(fcr.num_docto), '/'))
                      from fiscal.v$nf_es_receber nfr
                     inner join finan.v$finan_contas_receber fcr
                             on fcr.contas_receber_id = nfr.contas_receber_id
                     where nfr.num_nota_id = nff.nf_es_id) as num_fatura
                 , (select p.cliente
                      from kss.v$pessoa p
                     where p.cod_pessoa = nf.cod_pessoa_filial) as filial
                 , to_char(nf.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(nff.placa_tracao) as cod_veiculo_tracao
                 , oper.pkg_veiculo.fnc_veiculo_modalidade(nff.placa_tracao, nff.date_insert) as modalidade
                 , nff.rem_razao_social
                 , nff.dest_razao_social
                 , nff.dest_municipio
                 , nff.dest_uf
                 , nf.calc_valor_total_nota as valor_bruto
                 , nf.serv_iss_valor as valor_iss
                 , nff.impostos as valor_impostos
                 , (nff.total_viagem - nff.impostos) as valor_liquido
                 , (select ct.valor_frete_bruto
                      from oper.v$contrato_transp ct
                     where ct.num_romaneio = nff.num_romaneio
                       and ct.data_cancelamento is null) as valor_cf
                 , nf.user_insert
                 , (case nf.cancelada
                        when 1 then 'Sim'
                        when 0 then 'Não'
                   end) cancelada
                 , to_char(nf.date_insert, 'dd/mm/yyyy') as date_insert
                 , (select sign(count(1))
                      from fiscal.v$nf_frete_comercial_versao nfcv
                     where nfcv.nf_es_id = nff.nf_es_id) as possui_tabela_frete                 
                 , nff.organizacional_id
                 , nff.cod_organizacional || ' - '||
                   (select descricao
                      from kss.v$organizacional org
                     where org.organizacional_id = nff.organizacional_id) as organizacional          
              from fiscal.v$nf_es_frete nff
             inner join fiscal.v$nf_es nf
                     on nf.num_nota_id = nff.nf_es_id
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa_filial))>
               and nf.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and nf.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.organizacional_id_gerencial))>
               and nf.organizacional_id = #arguments.organizacional_id_gerencial#
            </cfif>
            <cfif Len(Trim(arguments.cod_remetente))>
               and nff.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.cod_destinatario))>
               and nff.cod_destinatario = #arguments.cod_destinatario#
            </cfif>
            <cfif Len(Trim(arguments.num_nota_fiscal))>
               and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
            </cfif>
            <cfif Len(Trim(arguments.cod_modelo))>
               and nf.cod_modelo = '#arguments.cod_modelo#'
            </cfif>
            <cfif Len(Trim(arguments.serie))>
               and nf.serie = '#arguments.serie#'
            </cfif>
            <cfif Len(Trim(arguments.subserie))>
               and nf.subserie = '#arguments.subserie#'
            </cfif>
            <cfif Len(Trim(arguments.emitida)) and arguments.emitida eq 1>
               and nf.emitida = 1
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
            	<cfif arguments.cancelada eq 0>
					and nf.cancelada = 0
				<cfelseif arguments.cancelada eq 1>
                	and nf.cancelada = 1
                </cfif>
            </cfif>
            
			<cfif Len(Trim(arguments.conferida)) and arguments.conferida eq 1>
               and nf.conferida = 1
            </cfif>
            <cfif Len(Trim(arguments.terceiro)) and arguments.terceiro eq 1>
               and exists (select 0
                             from oper.v$contrato_transp ct
                            where ct.num_romaneio = nff.num_romaneio
                              and ct.data_cancelamento is null)
				<cfif Len(Trim(arguments.tipo_pessoa))>
					and nff.cod_proprietario in (select p.cod_pessoa
                                                   from kss.v$pessoa p
                                                  where p.tipo_pessoa = #arguments.tipo_pessoa#)
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.data_inicio))>
               and trunc(nf.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_fim))>
               and trunc(nf.data_emissao) <= '#arguments.data_fim#'
            </cfif>
             order by nf.data_emissao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca Próximo Numero de Nota Fiscal
	-- NOTAS EXPLICATIVAS
	-- ANDRÉF 22/03/2010
	--->
	<cffunction name="get_prox_nota" displayname="Busca Próximo Numero de Nota Fiscal" access="remote" returntype="query" output="false">
		<cfargument name="cod_modelo" required="no" default=""/>
		<cfargument name="serie" required="no" default=""/>
		<cfargument name="subserie" required="no" default=""/>
		<cfargument name="documento_proprio" required="no" default="1" />
		<cfargument name="cod_pessoa" required="no" default="" />
        <cfargument name="cod_departamento" required="no" default="" />
        <cfargument name="cod_setor" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="nfes" required="no" default="" />
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select nvl((select (max(nf.num_nota_fiscal)+1)
                              from fiscal.v$nf_es nf
                             where nf.cod_pessoa_filial = ms.cod_pessoa
                               and nf.cod_departamento  = ms.cod_departamento
                               and nf.cod_setor         = ms.cod_setor
                               and nf.cod_centro_custo  = ms.cod_centro_custo
                               and nf.cod_modelo        = ms. cod_modelo
                               and nf.serie             = ms.serie
                               and nf.subserie          = ms.subserie),(ms.num_inicial)) as prox_nota
                      , ms.incluir_livro_fiscal
                	  , ms.incluir_sintegra
                           from fiscal.v$modelo_serie ms
                     inner join fiscal.v$sintegra_modelo_fiscal smf
                     	     on smf.cod_modelo = ms.cod_modelo
                          where 1=1
                            and ms.ativo = 1 
                 <cfif len(trim(arguments.documento_proprio))>
					and ms.DOCUMENTO_PROPRIO = #arguments.documento_proprio#
				 </cfif>
                  <cfif Len(Trim(arguments.nfes))>
					and smf.nfes = '#arguments.nfes#' 
				 </cfif>
				 <cfif Len(Trim(arguments.cod_modelo))>
					and ms.cod_modelo in ('#PreserveSingleQuotes(arguments.cod_modelo)#')
				 </cfif>
				 <cfif Len(Trim(arguments.serie))>
					and ms.serie ='#arguments.serie#'
				 </cfif>
                 
                 <cfif Len(Trim(arguments.subserie))>
					and ms.subserie ='#arguments.subserie#'
				 </cfif>
                 
				 <cfif Len(Trim(arguments.cod_departamento))>
					and ms.cod_departamento ='#arguments.cod_departamento#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_pessoa))>
					and ms.cod_pessoa ='#arguments.cod_pessoa#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_setor))>
					and ms.cod_setor ='#arguments.cod_setor#'
				 </cfif>
                 <cfif Len(Trim(arguments.cod_centro_custo))>
					and ms.cod_centro_custo ='#arguments.cod_centro_custo#'
				 </cfif>
                 order by ms.subserie
			</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPÓSITO 
	-- Busca o Histórico de Nota Fiscal
	-- NOTAS EXPLICATIVAS
	-- ANDRÉF 23/03/2010
	--->
	
    <cffunction name="get_historico_nota" displayname="Busca o Histórico da Nota Fiscal" access="remote" returntype="query" output="false">
		<cfargument name="num_nota_id" displayname="Identificador da Nota Fiscal" required="yes"/>
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select oc.num_nota_id
                 , oc.ocorrencia_id
                 , nf_es_ocorrencia_id
                 , fiscal.fnc_ref_code('OCORRENCIA', oc.ocorrencia_id) as descricao_ocorrencia
                 , oc.historico
                 , oc.motivo
                 , oc.usuario
                 , to_char(oc.data_hora, 'dd/mm/yyyy hh24:mi:ss') as data_hora
              from fiscal.v$nf_es_ocorrencia oc
             where oc.num_nota_id = #arguments.num_nota_id#
             order by nf_es_ocorrencia_id
        </cfquery>
    	<cfreturn qr_result>
    </cffunction>
    
</cfcomponent>