<cfcomponent extends="_transportes.consulta.cfc_controle_trafego"> 
	<!--- 
	-- PROPSITO
	-- Todos os veculos do controle de trfego
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/11/2005 - criado
	--->	
	<cffunction name="get_controle_trafego" displayname="Todos os veculos do controle de trfego" output="true" returntype="query" access="public">
		<cfargument name="COD_GRUPO" required="no">
		<cfargument name="VEICULOS" required="no">
		<cfargument name="RASTREADOS" required="no">
		<cfargument name="ENCOSTADOS" required="no">
		<cfargument name="ACIDENTADOS" required="no">
		<cfargument name="STATUS" required="no">
		<cfargument name="PROPRIETARIO" required="no">
		<cfargument name="OPERACAO_ID" required="no" default="">
		<cfargument name="AGREGADO" required="no" default="0">
		<cfargument name="COD_PESSOA_RESPONSAVEL" required="no" default="">
		<cfargument name="COD_FILIAL_ORIGEM" required="no" default="">
		<cfargument name="COD_FILIAL_DESTINO" required="no" default="">
		<cfargument name="COD_VEICULO" required="no" default="">
        <cfargument name="DEDICADO" required="no" default="0">
        <cfif arguments.dedicado eq 1>
			<cfscript>
                qrGrupos = this.get_veiculo_grupo_usuario(usuario = ucase(trim(session.usuario)));
				if(qrGrupos.recordcount) {
					arguments.cod_grupo = ValueList(qrGrupos.cod_grupo);
				} else {
					arguments.cod_grupo = -1;
				}
            </cfscript>        
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select ct.*, 
			   vhr.rastreador_id 
	      from (select upper(kss.pkg_string.fnc_string_clean(destino)) as destino_clear,
		  			   upper(kss.pkg_string.fnc_string_clean(origem)) as origem_clear,
					   placa_tracao,                                                
					   case                                                         
						 when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) then 1 
					   else 0 end tracao,                                           
					   placa_reboque,                                               
					   case                                                         
						 when (ct.placa_referencia is not null) then 1              
					   else 0 end semi_reboque,                                     
					   placa_controle,                                              
					   num_rastreador,                                              
					   possui_rastreador,                                           
					   rastreador_com_problemas,                                    
					   case                                                         
						  when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) 
						  then km_30dias 
					   	  else 0 
					   end km_30dias,                                        
					   case                                                         
						  when (ct.articulado = 0 or ct.engatada = 1 or (ct.engatada = 0 and ct.placa_referencia is null)) 
						  then km_atual  
					      else 0 
					   end km_atual,                                         
					   case                                                         
						  when ct.placa_controle is null 
						  then 0
					      else km_revisao 
					   end km_revisao,                              
					   km_revisao_local,                                            
					   capacidade_carga,                                            
					   cod_grupo,                                                   
					   marca,                                                       
					   modelo,                                                      
					   capacidade_tanque,                                           
					   veiculo_empresa,                                             
					   placa_referencia,                                            
					   engatada,                                                    
					   articulado,                                                  
					   cod_pessoa,                                                  
					   cod_funcionario,                                             
					   com_motorista,                                               
					   aniversario_motorista,                                       
					   dias_trabalho,                                               
					   data_residencia,                                             
					   mdr_num_romaneio,                                            
					   to_char(maxdatahora,'dd/mm/yyyy hh24:mi') as maxdatahora,
					   distancia,                                                   
					   referencia,                                                  
					   latitude,                                                    
					   longitude,                                                   
					   num_evento,                                                  
					   tempo,                                                       
					   tempo_evento,                                                
					   status,
					   nvl(status_msg_destina, 'E') status_msg_destina,
               		   nvl(status_msg_previsao,'E') status_msg_previsao,                                                       
			  	      /* Se o tempo do evento no status destinado for maior que 1:30 alterta que o motorista pode ter antecipado a macro 5 antes de descarregar  */
					   case                                                                                                                                       
						  when status = 'Destinado' and segundos_tempo_evento > 5400 and                                                                        
							   oper.pkg_coord_geografica.fnc_haversine1(ct.evo_latitude, ct.evo_longitude, ct.latitude, ct.longitude) < 5                         
						  then 1                                                                                                                                  
					   else 0 end parado_origem,                                                                                                                  
					   segundos,                                                                        
					   segundos_tempo_evento,                                                           
					   atraso_vazio,                                                                    
					   atraso_carregado,                                                                
					   problema_macro,                                                                  
					   num_romaneio,                                                                    
					   rastreabilidade_id,                                                              
					   num_entrega,                                                                     
					   frete_proprio,                                                                   
					   origem,                                                                          
					   carregamento,                                                                    
					   destino destino,      
                       distancia_destino,                                                                   
					   cliente,                                                                         
					   remetente,                                                                       
					   destinatario,                	                                                     
					   data_evento,                                                                     
					   data_evento_resumida,                                                            
					   data_inicio,                                                                     
					   to_char(data_inicio,'dd-mm hh24') data_inicio_resumida,                                                            
					   to_char(previsao_descarga,'dd/mm/yyyy hh24:mi') as previsao_descarga,
					   previsao_descarga_resumida,                                                      
					   num_motorista_vazio,                                                             
					   previsao_vazio,                                                                  
					   to_char(previsao_vazio, 'DD Dy HH24:MI ' ||  case                              
																	   when cod_pessoa_atraso_vazio is null then  '"('||    
																		  decode(num_motorista_vazio, 0, '', num_motorista_vazio) || decode(bloquear_previsao_vazio, 1, 'B') || ')"'
																	   when bloquear_previsao_vazio = 1 then  '"(B)"' 
																	 else null end) previsao_vazio_resumida,            
					   cod_pessoa_atraso_vazio,                                                         
					   num_motorista_carregado,                                                         
					   to_char(previsao_carregado, 'DD Dy HH24:MI ' ||  case                          
																		  when cod_pessoa_atraso_carr is null then  '"('||  
																			 decode(num_motorista_carregado, 0, '', num_motorista_carregado) || decode(bloquear_previsao_carr, 1, 'B') || ')"' 
																		  when bloquear_previsao_carr = 1 then  '"(B)"'
																		 else null end) previsao_carregado_resumida,     
					   previsao_carregado,        
                       pisca_status,                                                                       
					   cod_pessoa_atraso_carr,                                                                           
					   bloquear_previsao_carr, 
					   bloquear_previsao_vazio,                                                  
					   motivo,                                                                                           
					   comentario_veiculo,                                                                               
					   comentario_motorista,                                                                             
					   comentario_viagem,                                                                                
--					   decode(num_romaneio, null, 0, oper.pkg_operacional.fnc_converte_peso(peso_total, 'Kg', 'Ton')) peso_total, 
					   referencia_id, referencia_situacao_id, referencia_situacao,                                       
					   controle_situacao_id, controle_situacao, status_celular, 
                       status_msg_livre,               
					   placa_controle||placa_referencia||cod_pessoa||num_evento||status||num_romaneio keyfield,          
					   proprietario_reboque, proprietario_tracao, cnh_status, cnh_mensagem,
					   laudo_tracao, laudo_reboque, status_cavalo,
					   cod_filial_origem, cod_filial_destino, filial_origem as filial_origem, replace(filial_destino,'Rodo Mar - ','') filial_destino,
                       cod_pessoa_responsavel, 
                       filial_responsavel filial_responsavel,
                       comp_cod_classificacao,
                       comp_classificacao,
                       comp_cap_carga_bruta,
                       comp_tara,
                       comp_cap_carga_real,
                       num_entregas,
                       num_entregas_concluidas,
                       filial_mais_proxima||'('||round(distancia_filial,1)||' Km)' filial_mais_proxima,
                       monitorado_por,
                       case                                                                                               
                          when num_evento =any(100,1,2) then                                                                                                                                
                             to_char(previsao_vazio, 'DD Dy HH24:MI ' || '"('|| decode(num_motorista_vazio, 0, '', num_motorista_vazio) ||               
                                     decode(bloquear_previsao_vazio, 1, 'B') ||  ')"' )                                                             
                          when num_evento = 5 then ''                                                                                                        
                          else                                                                                                                                 
                             to_char(previsao_carregado, 'DD Dy HH24:MI ' || '"('|| decode(num_motorista_carregado, 0, '', num_motorista_carregado) ||   
                                      decode(bloquear_previsao_carr, 1, 'B')|| ')"' )                                                                
                       end previsao_chegada,
                      case                                                                                               
                          when laudo_tracao = 0 then                                                                      
                             'Possui laudo(s) vencido(s)'                                                               
                          when laudo_tracao = 1 then                                                                      
                             'Possui laudo(s) a vencer'                                                                 
                          else 'Laudo(s) ok'                                                                            
                       end desc_laudo_tracao,                                                                             
                       case                                                                                               
                          when laudo_reboque = 0 then                                                                     
                             'Possui laudo(s) vencido(s)'                                                               
                          when laudo_reboque = 1 then                                                                     
                             'Possui Laudo(s) a vencer'                                                                 
                          else 'Laudo(s) ok'                                                                            
                       end desc_laudo_reboque
				  from oper.v$controle_trafego ct 
				 where 1=1
			     <cfif Len(Trim(arguments.OPERACAO_ID))>
                   and (ct.placa_controle in (select ov.placa
                                             from dedicado.v$operacao_veiculo ov
                                            where ov.data_termino is null
                                              and ov.operacao_id in (select a.operacao_id
                                                                       from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                       or ct.placa_referencia in (select ov.placa
                                                 from dedicado.v$operacao_veiculo ov
                                                where ov.data_termino is null
                                                  and ov.operacao_id in (select a.operacao_id
                                                                           from table(dedicado.pkg_operacao.fnc_operacao_antecessoras(#arguments.OPERACAO_ID#)) a))
                     )                                                      
                 </cfif>
                 
				 <cfif Len(Trim(arguments.cod_veiculo))>
				 	and (ct.placa_tracao = '#arguments.cod_veiculo#'  
					    or ct.placa_reboque = '#arguments.cod_veiculo#')
				 <cfelse>
					 <cfif Len(Trim(arguments.cod_pessoa_responsavel)) and not Len(Trim(arguments.OPERACAO_ID))>
					   and cod_pessoa_responsavel = #arguments.cod_pessoa_responsavel#
					 </cfif>
					 <cfif Len(Trim(arguments.cod_filial_origem))>
						and nvl(cod_filial_origem,1) in (#arguments.cod_filial_origem#)
					 </cfif>
					 <cfif Len(Trim(arguments.cod_filial_destino))>
						and nvl(cod_filial_destino,1) in (#arguments.cod_filial_destino#)
					 </cfif>
					 <cfif IsDefined("arguments.COD_GRUPO") and Len(Trim(arguments.COD_GRUPO))>
						 and ct.cod_grupo = any( #ListQualify(arguments.COD_GRUPO,"'")# )
					 <cfelseif IsDefined("arguments.COD_GRUPO")>
						 and ct.cod_grupo is null
					 </cfif>
				
					 <cfif IsDefined("arguments.VEICULO")>
						 <cfswitch expression="#arguments.VEICULO#">
							<cfcase value="2">
								and ct.engatada = 1
							</cfcase>
							<cfcase value="3">
								and ct.placa_referencia is null
							</cfcase>
							<cfcase value="4">
								and ct.engatada = 1
							</cfcase>
							<cfcase value="5">
								and ct.engatada = 0 and ct.placa_referencia is not null
							</cfcase>
							<cfdefaultcase></cfdefaultcase>
						  </cfswitch>
					  </cfif>
				
					  <cfif IsDefined("arguments.STATUS") and Len(Trim(arguments.STATUS))>
							and (ct.descricao_resumida = any(#ListQualify(arguments.STATUS,"'")#) or ct.descricao_resumida is null )
					  <cfelseif IsDefined("arguments.STATUS")>
							and ct.descricao_resumida is null
					  </cfif>
		
					  <cfif IsDefined("arguments.PROPRIETARIO") and arguments.PROPRIETARIO eq 1>
						  and ct.placa_controle = any(#ListQualify(v_lista_placas,"'")#)		
					  </cfif>
					  <cfif session.site eq 'rodomar/'>
						  <cfif UCase(session.usuario) eq 'CVRD'>
							  and ct.placa_tracao in ('2101', '2102')
							  and ct.engatada = 1
						  </cfif>
						  <cfif UCase(session.usuario) eq 'BELGO'>
							  and ct.cod_grupo in ('DEDIC - FR')
							  and (ct.engatada = 1 or (ct.engatada=0 and ct.placa_referencia is null))
						  </cfif>
						  <cfif UCase(session.usuario) eq 'MANNESMANN'>
							  and ct.cod_grupo = 'PARAOPEBA'
							  and ct.engatada = 1
						  </cfif>
					  </cfif>
				 </cfif>
				) ct
		 left join integracao.v$rastreador_historico_veiculo vhr 
				 on vhr.placa = ct.placa_controle
				and vhr.data_termino is null
			<cfif arguments.agregado eq 1>
                 inner join oper.v$veiculo_agregado va
                         on (va.placa = ct.placa_controle or va.placa = ct.placa_referencia)
                 where possui_rastreador = 1
                   and va.cod_pessoa = #session.cod_pessoa_usuario# 
			</cfif>
            
		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
</cfcomponent>