<cfcomponent extends="_transportes.consulta.cfc_controle_combustivel">
	<!--- 
	-- PROPSITO 
	-- Busca proximo numero de requisicao
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_proxima_requisicao" access="remote" returntype="numeric" output="true">
		<cfargument name="COD_PESSOA_FILIAL" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nvl(oper.pkg_abastecimento.FNC_PROXIMA_REQUISICAO(#arguments.COD_PESSOA_FILIAL#),1) as proxima_requisicao
			  from dual
  		</cfquery>
		<cfreturn qr_result.proxima_requisicao>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca bombas de combustivel da filial
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 04/02/2010 ALTERADO
	--->
	<cffunction name="get_bombas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select b.bomba_id,
                   b.cod_pessoa,
                   b.num_bomba,
                   b.contador,
                   b.situacao,
                   b.contador_sequencial,
                   b.contador_maximo
              from oper.v$bomba_combustivel b
             where b.cod_pessoa = #arguments.cod_pessoa#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca movimentao no perodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/01/2006
	--->
	<cffunction name="get_movimentacao_combustivel" displayname="Busca a movimentao da filial" access="remote" returntype="query" output="true">
		<cfargument name="estoque_id"  required="true">
		<cfargument name="data_inicio" required="true">
		<cfargument name="data_fim"    required="true">		
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select num_documento, oper.pkg_veiculo.fnc_get_cod_veiculo(placa_veiculo) as placa_veiculo, historico, nvl(quantidade,0) as quantidade, to_char(data,'dd/mm/yyyy HH24:mi') as data, 
				   tipo,usuario, num_bomba, contador_inicial, contador_final,
				   round(contador_final - contador_inicial,1) as diferenca,
				   oper.pkg_veiculo.fnc_veiculo_modalidade(placa_veiculo) veiculo_proprietario
			from  (SELECT 0 as lancto_id, 0 as num_documento, '----' as placa_veiculo, 
						  'Inventrio de '||e.data_inventario as historico, e.qtde_estoque as quantidade, 
						  e.data_inventario as data, 'Inventrio' as tipo, e.user_insert as usuario, 0 as num_bomba ,
						  0 as contador_inicial, 0 as contador_final
					 from oper.v$estoque_inventario e 
					where e.estoque_id = #arguments.estoque_id#
					  and e.data_inventario between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400
					  
					union 
					
				   SELECT nfr.num_nota_fiscal as lancto_id, nfr.num_nota_fiscal as num_documento,                                       
           		    '----' as placa_veiculo, nfr.emit_razao_social as historico, nf_it.QTDE_VOLUME as quantidade,                                       
						      nfr.data_entrada as data, 'Entrada' as tipo, nfr.user_insert as usuario, 0 as num_bomba,
							  0 as contador_inicial, 0 as contador_final
 					   from fiscal.v$nf_terceiro nfr 
					  inner join fiscal.v$nf_terceiro_it nfr_it
					     on nfr.num_nota_id = nfr_it.num_nota_id
					    and trunc(nfr.data_entrada) between to_date('#Arguments.data_inicio#','dd/mm/yyyy') and to_date('#Arguments.data_fim#','dd/mm/yyyy')
            inner join fiscal.v$nf_item nf_it
                   on nf_it.num_nota_it_id = nfr_it.num_nota_it_id
				   and exists (select 'x'
				      			 from oper.v$produto_abastecimento pa
								where pa.produto_id = nf_it.produto_id
  								  and pa.produto_oper_id in (2,4))
  					inner join kss.v$unidade_negocio pjf
	  				   on pjf.cod_pessoa = nfr.cod_pessoa_filial
			  		inner join oper.v$estoque e
                    on e.cod_pessoa_filial = pjf.cod_pessoa
                   and e.estoque_id = #arguments.estoque_id#
  					inner join oper.v$estoque_inventario ei 
  	  				      on ei.estoque_id = e.estoque_id
			  		inner join kss.pessoa_juridica pj
				  	   on pj.cod_pessoa = nfr.COD_EMITENTE
	  				  and nfr.data_entrada >= ei.data_inventario
												   
					union                                     
					
				  select pe.controle_id,  
                  decode(pe.num_requisicao,null,es.num_saida, pe.num_requisicao) as num_documento,                                        
                 pe.placa, 'KM - ' || pe.km as historico,                                       
                 round(es_it.quantidade,3) as quantidade, es.data_saida as data,                                         
                 'Sada' as tipo, pe.user_update as usuario, b.num_bomba,
				 pe.contador_inicial, pe.contador_final
            from oper.v$estoque_saida es
           inner join oper.v$estoque_saida_it es_it
                   on es_it.num_saida = es.num_saida
           inner join oper.v$estoque e
                   on e.estoque_id = es_it.estoque_id
                  and e.estoque_id = #arguments.estoque_id#
           left join oper.v$abastecimento pe
                   on pe.num_saida = es.num_saida
           left join oper.v$bomba_combustivel b
                   on b.bomba_id = pe.bomba_id         
			      where es.data_saida between to_date('#Arguments.data_inicio#','dd/mm/yyyy HH24:mi') and to_date('#Arguments.data_fim#','dd/mm/yyyy HH24:mi')+1-1/86400

			ORDER BY data, num_documento,tipo) 
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca requisies canceladas
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/01/2006
	--->
	<cffunction name="get_requisicao_cancelada" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="yes" />
		<cfargument name="num_requisicao" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		   select cod_pessoa_filial, num_requisicao, data_cancelamento, motivo_cancelamento, controle_id
		     from oper.v$abastecimento_req_cancelada
			 where cod_pessoa_filial = #arguments.cod_pessoa#
			 <cfif Len(Trim(arguments.num_requisicao))>
			   and num_requisicao = #arguments.num_requisicao#
			 </cfif>
		    order by num_requisicao 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>			
   
	<!--- 
	-- PROPSITO
	-- Retorna uma Relao de Abastecimentos de acordo com os parmetros atribudos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 10/03/2009
	--->
	<cffunction name="get_relacao_abastecimentos" displayname="Retorna uma Relao de Abastecimentos de acordo com os parmetros atribudos" output="true" returntype="query" access="remote">
		<cfargument name="data_inicial" required="yes">
		<cfargument name="data_final" required="yes">
        <cfargument name="placa" required="no" default="">
        <cfargument name="modelo_id" required="no" default="">
        <cfargument name="agrupamento_id" required="no" default="">
        <cfargument name="tipo_carroceria_id" required="no" default="">
        <cfargument name="controle_evo_id" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">        
        <cfargument name="abastecido" required="no" default="">
        <cfargument name="cod_pessoa_posto" required="no" default="">
        <cfargument name="filial" required="no" default="">
        <cfargument name="status_tanque" required="no" default="">
        <cfargument name="situacao_abastecimento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.controle_id, to_char(a.data_hora, 'dd/mm/yyyy hh24:mi') as data_hora, a.quantidade
     			 , nvl(ai.quantidade, 0) as qtde_indevida
     			 , vmo.modelo
     			 , v.cod_veiculo
     			 , a.placa
     			 , a.km
     			 , decode(a.encheu,0,'No',1,'Sim') as encheu_tanque
     			 , (select (select mrh.cod_registro
                              from oper.v$motorista_reg_historico mrh
                             where a.data_hora between mrh.data_inicio and nvl(mrh.data_fim, a.data_hora)
                               and mrh.cod_pessoa = vm.cod_pessoa
                               )||' - '||kss.pkg_pessoa.fnc_get_cliente(vm.cod_pessoa) as funcionario
                      from oper.v$veiculo_motorista vm
                     where case
                              when vm.placa is null then 1
                              else
                                 case 
                                    when a.data_hora between vm.data_inicio and nvl(vm.data_fim, sysdate +1/24) then 1
                                    else 0
                                 end
                           end = 1
                       and vm.placa = nvl(vjp.placa_controle, a.placa)
                   ) as funcionario
                 , a.controle_evo_id
                 , nvl2(a.cod_pessoa_posto,kss.pkg_pessoa.fnc_get_cliente(a.cod_pessoa_posto,1),'****  vista ****') as posto
                 , a.valor_unitario
                 , a.valor_total as valor_abastecimento
                 , (select pe.uf
                      from kss.v$pessoa_endereco pe
                     where pe.endereco_padrao = 1
                       and pe.cod_pessoa = a.cod_pessoa_posto) as uf
                 , (select vtr.valor_num_centro_custo
                      from oper.v$veiculo_atributo vtr
                     where vtr.placa = a.placa) as valor_num_centro_custo
                 , decode(a.tipo_entrada,6,'Sim','No') as esso_card
                 , vj.num_romaneio
                 , nvl(vj.volume_total,0) as volume_total
                 , nvl(vj.m3_total,0) as m3_total
                 , vj.peso_total/1000 as peso
                 , (select ran.destino
                      from oper.v$romaneio ran
                     inner join oper.v$romaneio_viagem_anterior rva
                        on ran.num_romaneio = rva.num_romaneio_anterior
                     where rva.num_romaneio = vj.num_romaneio
                       and rva.placa = vj.placa_controle)||' - '||vj.carregamento||' - '||vj.destino as desc_viagem
                 , decode(ai.controle_macro_id, null, 'Normal', 'Indevido') as indevido
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).km,0) as km_ench
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).quantidade,0) as quantidade_ench
                 , decode(a.encheu,1,oper.pkg_veiculo.fnc_media_abastecimento(a.placa,a.data_hora,a.km,a.quantidade).media,0) as media
                 , decode(a.data_confirmacao, null, 'No', 'Sim') as abast_nao_confirmado
                 , a.date_insert, a.date_update, a.user_insert, a.user_update
                 , (select kss.pkg_pessoa.fnc_get_cliente(vp.cod_pessoa)
                      from oper.v$veiculo_proprietario vp
                     where vp.placa = a.placa
                       and a.data_hora between vp.data_inicio and nvl(vp.data_fim, a.data_hora) and rownum = 1) as proprietario
                 , a.num_requisicao
                 , decode(a.tipo_entrada, 7, 'Sim', 'No') as ticket_car
                 , decode(a.autenticado,0,'No','Sim') as situacao
                 , a.autenticado
                 , a.nao_autenticado_motivo
                 , decode(a.combustivel,0,'Lubrificante','Diesel') as tipo_abastecimento
                 , a.combustivel
                 , a.cod_pessoa_posto
                 , v.tipo_carroceria_id
                 , vtc.descricao as classificacao
                 , va.descricao as agrupamento
                 , nvl(a.media_consumo_ideal,0) as media_consumo_ideal
                 , a.rowid
              from oper.v$abastecimento a
             inner join oper.v$veiculo v
                on v.placa = a.placa
             inner join oper.v$veiculo_modelo vmo
                on vmo.marca_id = v.marca_id
               and vmo.modelo_id = v.modelo_id
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vtc.tipo_carroceria_id = v.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$romaneio_hist_veiculo vjp
                on vjp.placa_controle = a.placa
               and a.data_hora between vjp.data_inicio and nvl(vjp.data_termino, sysdate+1/24)
              left join oper.v$romaneio vj
                on vj.num_romaneio = vjp.num_romaneio
              left join oper.v$posto_abast_indevido ai
                on ai.controle_macro_id = a.controle_id
             where 1=1
               and a.combustivel = 1			
               and a.data_hora between to_date('#arguments.data_inicial# 00:00:00','dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_final# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfif Len(Trim(arguments.placa))>
			   and a.placa = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.modelo_id))>
			   and vmo.modelo_id = #arguments.modelo_id#
            </cfif>
            <cfif Len(Trim(arguments.agrupamento_id))>
			   and va.agrupamento_id = #arguments.agrupamento_id#
            </cfif>
            <cfif Len(Trim(arguments.tipo_carroceria_id))>
			   and v.tipo_carroceria_id = #tipo_carroceria_id#
            </cfif>
            <cfif Len(Trim(arguments.controle_evo_id))>
			   and a.controle_evo_id = #arguments.controle_evo_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa))>
			   and exists (select 0 from oper.v$veiculo_proprietario vp
                            where vp.placa = a.placa and a.data_hora between vp.data_inicio and nvl(vp.data_fim, a.data_hora)
                              and vp.cod_pessoa  = #arguments.cod_pessoa#
                              and rownum = 1)
            </cfif>
            <cfif Len(Trim(arguments.abastecido))>
				<cfif arguments.abastecido eq 2>
                	and not exists (select 0
                   from kss.v$unidade_negocio un
                  where un.cod_pessoa = a.cod_pessoa_posto)
                <cfelseif arguments.abastecido eq 3>
                	and exists (select 0
                   from kss.v$unidade_negocio un
                  where un.cod_pessoa = a.cod_pessoa_posto)
                <cfelseif arguments.abastecido eq 4>
                	and a.cod_pessoa_posto = #arguments.cod_pessoa_posto#
                <cfelseif arguments.abastecido eq 5>
                	and a.cod_pessoa_posto = #arguments.filial#
				 </cfif>
            </cfif>
            <cfif Len(Trim(arguments.status_tanque))>
			   and a.encheu = #arguments.status_tanque#
            </cfif>
            <cfif Len(Trim(arguments.situacao_abastecimento))>
            	<cfif arguments.situacao_abastecimento eq 0>
                	and a.data_confirmacao is null
                <cfelseif arguments.situacao_abastecimento eq 1>
                	and a.data_confirmacao is not null
                </cfif>
            </cfif>
			 order by a.data_hora, v.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>   
</cfcomponent>