<cfcomponent displayname="Consultas da rea de caixas" extends="_transportes.consulta.cfc_caixa">
	<!--- 
	-- PROPSITO 
	-- Busca todos os caixas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  30/12/2005
	--->		
	<cffunction name="get_caixas" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="yes">
		<cfquery datasource="#session.dsn#" name="qr" username="#session.usuario#" password="#session.senha#">
                select fc.caixa_id, fc.cod_pessoa_filial, fc.num_caixa, fc.descricao,
                       fcf.descricao as finalidade, fct.descricao as tipo,
                       fcc.controle_id, fcc.usuario, 
                       to_char(fcc.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura, 
                       to_char(fcc.data_encerramento,'dd/mm/yyyy hh24:mi') as data_encerramento, 
                       fcc.saldo_abertura, fcc.saldo_encerramento
                  from finan.v$finan_caixa fc 
                  inner join finan.v$finan_caixa_finalidade fcf
                          on fcf.finalidade_id = fc.finalidade_id
                  inner join finan.v$finan_caixa_tipo fct
                          on fct.tipo_id = fc.tipo_id
                  inner join finan.v$finan_caixa_controle fcc
                          on fcc.caixa_id = fc.caixa_id
                 where fc.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
                   and fc.ativo = 1
                   and fcc.controle_id = (select max(fcc2.controle_id) 
                                            from finan.v$finan_caixa_controle fcc2
                                           where fcc2.caixa_id = fc.caixa_id) 
                  order by fc.num_caixa
		</cfquery>
		<cfreturn qr>
	</cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os historicos para lancamento de caixa (BRASIL)
	-- GUTO 28/05/2007
	--->		
	<cffunction name="get_historico" access="remote" returntype="query" output="true">
		<cfargument name="cod_historico" required="no" default="">
		<cfargument name="historico" required="no" default="">
		<cfargument name="cod_contabil" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select h.cod_historico, h.historico, h.cod_contabil, h.cod_centro_custo, cc.centro_custo 
			  from finan.v$finan_caixa_historico h
		      left join kss.v$centro_custo cc
                     on cc.cod_centro_custo = h.cod_centro_custo
		      where 1=1
			 <cfif len(trim(arguments.historico))>
		        and upper(h.historico) like upper('%#arguments.historico#%')
			 </cfif>
			  <cfif len(trim(arguments.cod_historico))>
			   and h.cod_historico = #arguments.cod_historico#
			 </cfif>
			  <cfif len(trim(arguments.cod_contabil))>
			   and  upper(h.cod_contabil) like upper('%#arguments.cod_contabil#%')
			 </cfif>
			  order by h.cod_historico
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>           
</cfcomponent>