<!-- KM&M Componentes -->
<cfcomponent displayname="Manipulao da rea de pneus" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca FROTA
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_placa" returntype="string" access="remote">
		<cfargument name="cod_veiculo" required="no">
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#') as placa
			  from dual
 		</cfquery>		
		<cfreturn qr_result.placa>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Abre uma ficha de inspecao do veiculo
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="abre_inspecao" returntype="struct" access="remote">
		<cfargument name="cod_veiculo" required="yes">
		<cfargument name="km_veiculo" required="yes">
		<cftry>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_abre_inspecao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_placa" cfsqltype="cf_sql_varchar" value="#arguments.placa#">
				<cfprocparam type="inout" dbvarname="p_km_inspecao" cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#" variable="retorno.km_veiculo">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Inspeo do frota " & #arguments.cod_veiculo# & " aberta com sucesso."> 			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera a situacao atual do pneu
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="alt_situacao_pneu" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="situacao_id" required="no">
		<cfargument name="motivo" required="no">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_alt_situacao_pneu" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_situacao_id" cfsqltype="cf_sql_integer" value="#arguments.situacao_id#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Situao do pneu alterada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Atualiza o Sulco do Pneu
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="atualiza_sulco" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="sulco" required="yes">
		<cfargument name="data" required="yes">
		<cfargument name="motivo" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_atualiza_sulco" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 	cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_sulco" 		cfsqltype="cf_sql_integer" value="#arguments.sulco#">
				<cfprocparam type="in" dbvarname="p_data" 		cfsqltype="cf_sql_varchar" value="#arguments.data#">
				<cfprocparam type="in" dbvarname="p_motivo"		cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Sulco atualizado com sucesso!"> 			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Bloqueia a reforma do pneu
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="bloqueia_reforma" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="motivo" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_bloqueia_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Bloqueio de reforma executado com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cancela o envio de um pneu para a reforma
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="cancela_envio_reforma" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_del_envio_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Envio para reforma cancelado com sucesso. Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Cancela uma ficha de inspecao do veiculo
	-- CRISTOFER 30/01/2006
	--->
	<cffunction name="cancela_inspecao" returntype="struct" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="motivo" required="no" default="">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_canc_inspecao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_placa" cfsqltype="cf_sql_varchar" value="#arguments.placa#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Inspeo do veculo " & #Insert('-',arguments.placa,3)# & " cancelada com sucesso."> 			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cancela uma inspecao do pneu
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="cancela_inspecao_individual" returntype="struct" access="remote">
		<cfargument name="num_inspecao" required="yes">
		<cfargument name="motivo" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_canc_inspecao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_inspecao" cfsqltype="cf_sql_integer" value="#arguments.num_inspecao#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Inspeo cancelada com sucesso."> 			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Confirma o conserto do pneu
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="confirma_conserto_pneu" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="num_documento" required="yes">
		<cfargument name="data" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfargument name="tipo_conserto_id" required="yes">
		<cfargument name="complemento" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="num_recibo_viagem" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_confirma_conserto_estrada" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PNEU_ID'  value='#arguments.PNEU_ID#'  null='#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_RECIBO_VIAGEM'  value='#arguments.NUM_RECIBO_VIAGEM#'  null='#iif(len(trim(arguments.NUM_RECIBO_VIAGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONSERTO_ID'  value='#arguments.TIPO_CONSERTO_ID#'  null='#iif(len(trim(arguments.TIPO_CONSERTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_REFORMADOR'  value='#arguments.COD_PESSOA_REFORMADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_REFORMADOR)), de('no'), de('yes'))#'>
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Conserto confirmado com sucesso.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Confirma o conserto do pneu
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="confirma_retorno_conserto" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cfargument name="data_retorno_reforma" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfargument name="tipo_conserto_id" required="yes">
		<cfargument name="mm_sulco" required="yes">
		<cfargument name="consertos" required="no">		
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_confirma_retorno_conserto" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.tipo_conserto_id#">
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
				<cfprocparam type="in" dbvarname="p_custo" cfsqltype="cf_sql_float" value="#arguments.valor#">
				<cfprocparam type="in" dbvarname="p_data_retorno_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
				<cfprocparam type="in" dbvarname="p_mm_sulco" cfsqltype="cf_sql_integer" value="#arguments.mm_sulco#" null="#iif(isdefined("arguments.mm_sulco") and len(trim(arguments.mm_sulco)),de("no"),de("yes"))#" >
			</cfstoredproc>
			<cfscript>
				v_tipo_conserto_id = this.ListaToArray (lista = arguments, variavel = "L_TIPO_CONSERTO_ID_CONSERTOS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "L_QUANTIDADE_CONSERTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_tipo_conserto_id)#" index="count">
				<cfloop from="1" to="#v_quantidade[count]#" index="qnt">
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_ins_conserto_reforma" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
						<cfprocparam type="in" dbvarname="p_data" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
						<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
						<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#v_tipo_conserto_id[count]#">
					</cfstoredproc>			
				</cfloop>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Retorno do conserto confirmado com sucesso. Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	
	<!--- 
	-- PROPSITO
	-- Confirma o retorno de um pneu da reforma
	-- CRISTOFER 10/02/2006
	--->
	<cffunction name="confirma_retorno_reforma" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cfargument name="data_retorno_reforma" required="yes">
		<cfargument name="custo" required="yes">
		<cfargument name="garantia_carcaca" required="no">
		<cfargument name="garantia_reforma" required="no">
		<cfargument name="num_nota_fiscal" required="yes">
		<cfargument name="recusa_reforma" required="no">
		<cfargument name="motivo_recusa" required="no">
		<cfargument name="pneu_id" required="no">		
		<cfargument name="sucatear" required="no">
		<cfargument name="novos_consertos" required="no">
		<cfargument name="consertos" required="no">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_confirma_retorno_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
				<cfprocparam type="in" dbvarname="p_data_retorno_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
				<cfprocparam type="in" dbvarname="p_custo" cfsqltype="cf_sql_float" value="#arguments.custo#" null="#iif(isdefined("arguments.custo") and len(trim(arguments.custo)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_garantia_carcaca" cfsqltype="cf_sql_integer" value="#arguments.garantia_carcaca#" null="#iif(isdefined("arguments.garantia_carcaca") and len(trim(arguments.garantia_carcaca)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_garantia_reforma" cfsqltype="cf_sql_integer" value="#arguments.garantia_reforma#" null="#iif(isdefined("arguments.garantia_reforma") and len(trim(arguments.garantia_reforma)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#" null="#iif(isdefined("arguments.num_nota_fiscal") and len(trim(arguments.num_nota_fiscal)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_recusa_reforma" cfsqltype="cf_sql_integer" value="#arguments.recusa_reforma#">
				<cfprocparam type="in" dbvarname="p_motivo_recusa" cfsqltype="cf_sql_varchar" value="#arguments.motivo_recusa#" null="#iif(isdefined("arguments.motivo_recusa") and len(trim(arguments.motivo_recusa)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_pneu_id_garantia" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#" null="#iif(isdefined("arguments.pneu_id") and len(trim(arguments.pneu_id)) and arguments.GARANTIA_OUTRO_PNEU eq 1,de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_sucatear" cfsqltype="cf_sql_integer" value="#arguments.sucatear#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
			</cfstoredproc>
			<cfscript>
				v_tipo_conserto_id = this.ListaToArray (lista = arguments, variavel = "L_TIPO_CONSERTO_ID_CONSERTOS");
				v_quantidade = this.ListaToArray (lista = arguments, variavel = "L_QUANTIDADE_CONSERTOS");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_tipo_conserto_id)#" index="count">
				<cfloop from="1" to="#v_quantidade[count]#" index="qnt">
					<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_ins_conserto_reforma" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
						<cfprocparam type="in" dbvarname="p_data" cfsqltype="cf_sql_varchar" value="#arguments.data_retorno_reforma#">
						<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#">
						<cfprocparam type="in" dbvarname="p_tipo_conserto_id" cfsqltype="cf_sql_integer" value="#v_tipo_conserto_id[count]#">
					</cfstoredproc>			
				</cfloop>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Retorno do pneu confirmado com sucesso! Pneu novamente no estoque.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>			
	
	<!--- 
	-- PROPSITO
	-- Confirma o sucateamento do pneu
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="confirma_sucateamento" returntype="struct" access="remote">
		<cfargument name="psu_id" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="laudo_id" required="yes">
		<cfargument name="data_analise" required="yes">
		<cfargument name="valor_venda" required="yes">
		<cfargument name="COD_PESSOA_MOTORISTA" required="no" default="">
		<cfargument name="observacao" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_confirma_sucateamento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_psu_id" cfsqltype="cf_sql_integer" value="#arguments.psu_id#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_laudo_id" cfsqltype="cf_sql_varchar" value="#ListGetAt(arguments.LAUDO_ID,1, '_')#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_data_analise" cfsqltype="cf_sql_varchar" value="#arguments.data_analise#">
				<cfprocparam type="in" dbvarname="p_valor_venda" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_venda#" null="#iif(isdefined("arguments.valor_venda") and len(trim(arguments.valor_venda)),de("no"),de("yes"))#" >
				<cfprocparam type="in" dbvarname="p_cod_pessoa_mot_resp" cfsqltype="cf_sql_integer" value="#arguments.COD_PESSOA_MOTORISTA#" null="#iif(isdefined("arguments.COD_PESSOA_MOTORISTA") and len(trim(arguments.COD_PESSOA_MOTORISTA)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
			</cfstoredproc>
			<cfquery name="qr_placa"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				  select placa, data_desmontagem
					from oper.v$pneu_movimentacao
				   where pneu_id = #arguments.pneu_id# 
					 and data_desmontagem = (select max(data_desmontagem)
												from oper.v$pneu_movimentacao
											   where pneu_id =#arguments.pneu_id#)
			</cfquery>
			<cfscript>
				if (IsDefined("arguments.cod_pessoa_motorista")){
					this.ins_debito_conta_motorista(cod_pessoa = arguments.cod_pessoa_motorista,
													pneu_id = arguments.pneu_id,
													valor_venda = arguments.valor_venda,
													historico= "Pneu: " & arguments.num_pneu & " Laudo: " & ListGetAt(arguments.LAUDO_ID,2,'_') & " Placa: " & qr_placa.placa);
				}
			</cfscript>		
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " sucateado.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>				

	<!--- 
	-- PROPSITO
	-- Confirma a transferencia de um pneu entre filiais
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="confirma_transferencia_pneu" returntype="struct" access="remote">
		<cfargument name="localizacao_id" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_fecha_transferencia" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_localizacao_id" cfsqltype="cf_sql_integer" value="#arguments.localizacao_id#">
				<cfprocparam type="in" dbvarname="p_data_entrada" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Transferncia confirmada com sucesso.">			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Envia um pneu para o conserto
	-- CRISTOFER 02/02/2006
	--->
	<cffunction name="envia_pneu_conserto" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="data" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_pneu_conserto" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
				<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Registrado o envio do pneu para conserto.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Envia um pneu para a reforma
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="envia_pneu_reforma" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="data_envio_reforma" required="yes">
		<cftry>
			<cfdump var="#arguments#">
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_pneu_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
				<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_envio_reforma#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu enviado para reforma.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Envia uma listagem de pneus para a reforma
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="envia_lista_pneus_reforma" returntype="struct" access="remote">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="data_envio_reforma" required="yes">
		<cftry>
			<cfscript>
				v_pneu_id = this.ListaToArray (lista = arguments, variavel = "PNEU_ID_PNEUS");
			</cfscript>
			<cfset retorno.erro = false>
			<cfloop from="1" to="#ArrayLen(v_pneu_id)#" index="count">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_pneu_reforma" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#v_pneu_id[count]#">
					<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
					<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
					<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#arguments.data_envio_reforma#">
				</cfstoredproc>				
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu(s) enviado(s) para reforma com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Envia um pneu para a analise de sucateamento
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="envio_para_analise" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="observacao" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_ins_analise_sucateamento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_sucateador" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_data_sucateamento" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
				<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " deve ser enviado para a matriz para anlise.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Envia um pneu para a analise de garantia
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="envio_para_analise_garantia" returntype="struct" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="COD_PESSOA_FORNECEDOR" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_envia_analise_garantia" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.COD_PESSOA_FORNECEDOR#">
				<cfprocparam type="in" dbvarname="p_data_envio_reforma" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " deve ser enviado para anlise de garantia.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Realiza um inventario de Pneu
	-- CRISTOFER 19/01/2006
	--->
	<cffunction name="fecha_inspecao" returntype="struct" access="remote">
		<cfargument name="num_inspecao" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="mm_inspecao" required="yes">
		<cfargument name="pressao_encontrada" required="yes">
		<cfargument name="medida_1" required="yes">
		<cfargument name="medida_2" required="yes">
		<cfargument name="medida_3" required="yes">
		<cfargument name="laudo_analise_id" required="yes">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_fecha_inspecao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_inspecao" cfsqltype="cf_sql_integer" value="#arguments.num_inspecao#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_mm_inspecao" cfsqltype="cf_sql_integer" value="#arguments.mm_inspecao#">
				<cfprocparam type="in" dbvarname="p_pressao_encontrada" cfsqltype="cf_sql_integer" value="#arguments.pressao_encontrada#">
				<cfprocparam type="in" dbvarname="p_medida_1" cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise_id" cfsqltype="cf_sql_integer" value="#arguments.laudo_analise_id#" null="#iif(isdefined("arguments.laudo_analise_id") and len(trim(arguments.laudo_analise_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Inspeo do veculo fechada com sucesso."> 			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Gera a 
	-- CRISTOFER 19/01/2006
	--->
	<cffunction name="gera_relacao_envio" returntype="struct" access="remote">
		<cfargument name="lista_pneus" required="yes">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="observacao" required="yes">
		<cftry>
			<cfset retorno.num_relacao = 0>
			<cfloop list="#arguments.lista_pneus#" index="i">
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_ins_pneu_rel_reforma" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="inout" dbvarname="p_num_relacao" cfsqltype="cf_sql_integer" value="#retorno.num_relacao#" variable="retorno.num_relacao">
					<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#i#">
					<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
					<cfprocparam type="in" dbvarname="p_data_envio" cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
					<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
				</cfstoredproc>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Ficha de envio para reforma gerada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Realiza um inventario de Pneu
	-- CRISTOFER 19/01/2006
	--->
	<cffunction name='ins_inventario_pneu' displayname='Realiza um inventario de Pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_PNEU' required='yes'>
		<cfargument name='NUM_INTERNO' required='no' default=''>
		<cfargument name='SERIE' required='no' default="1">
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='SULCO_ATUAL' required='yes'>
		<cfargument name='ANO_FABRICACAO' required='yes'>
		<cfargument name='DATA_AQUISICAO' required='yes'>
		<cfargument name='PNEU_REFORMADO' required='yes'>
		<cfargument name='REFORMAS' required='yes'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cfargument name='DESENHO_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_pneu_inventario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_PNEU'  value='#arguments.NUM_PNEU#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_INTERNO'  value='#arguments.NUM_INTERNO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SERIE'  value='#arguments.SERIE#'  null='#iif(len(trim(arguments.SERIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MODELO_ID'  value='#ListGetAt(arguments.MODELO_ID, 1, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MEDIDA_ID'  value='#ListGetAt(arguments.MODELO_ID, 2, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_MEDIDA_RODA_ID'  value='#ListGetAt(arguments.MODELO_ID, 3, '_')#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_SULCO_ATUAL'  value='#arguments.SULCO_ATUAL#'  null='#iif(len(trim(arguments.SULCO_ATUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ANO_FABRICACAO'  value='#arguments.ANO_FABRICACAO#'  null='#iif(len(trim(arguments.ANO_FABRICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_AQUISICAO'  value='#arguments.DATA_AQUISICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PNEU_REFORMADO'  value='#arguments.PNEU_REFORMADO#'  null='#iif(len(trim(arguments.PNEU_REFORMADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_REFORMAS'  value='#arguments.REFORMAS#'  null='#iif(len(trim(arguments.REFORMAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_DESENHO_ID'  value='#arguments.DESENHO_ID#'  null='#iif(len(trim(arguments.DESENHO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_PNEU_ID' variable="retorno.PNEU_ID" >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pneu inventariado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Inicia uma transferencia de pneus entre filiais
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="ins_transferencia_pneu" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_organograma" required="yes">
		<cfargument name="data_previsao_chegada" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_ins_pneu_localizacao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 				cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_organograma" 			cfsqltype="cf_sql_varchar" value="#arguments.cod_organograma#">
				<cfprocparam type="in" dbvarname="p_data_transferencia" 	cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
				<cfprocparam type="in" dbvarname="p_data_previsao_chegada" 	cfsqltype="cf_sql_varchar" value="#arguments.data_previsao_chegada#">
			</cfstoredproc>
			<!---<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_ins_pneu_localizacao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 				cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" 			cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_filial#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" 		cfsqltype="cf_sql_integer" value="#arguments.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" 				cfsqltype="cf_sql_integer" value="#arguments.cod_setor#">
				<cfprocparam type="in" dbvarname="p_centro_custo" 			cfsqltype="cf_sql_integer" value="#arguments.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_data_transferencia" 	cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#">
				<cfprocparam type="in" dbvarname="p_data_previsao_chegada" 	cfsqltype="cf_sql_varchar" value="#arguments.data_previsao_chegada#">
			</cfstoredproc>--->
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Transferncia aberta com sucesso.">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Desmonta um pneu
	-- CRISTOFER 26/01/2006
	--->
	<cffunction name="mov_estoque" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="km_veiculo" required="yes">
		<cfargument name="laudo_desmontagem_id" required="yes">
		<cfargument name="data_desmontagem" required="yes">
		<cfargument name="mm_desmontagem" required="yes">
		<cfargument name="medida_1" required="yes">
		<cfargument name="medida_2" required="yes">
		<cfargument name="medida_3" required="yes">
		<cfargument name="laudo_analise" required="no">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_estoque" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_km_veiculo" cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#">
				<cfprocparam type="in" dbvarname="p_laudo_desmontagem_id" cfsqltype="cf_sql_integer" value="#arguments.laudo_desmontagem_id#">
				<cfprocparam type="in" dbvarname="p_data_desmontagem" cfsqltype="cf_sql_varchar" value="#arguments.data_desmontagem#">
				<cfprocparam type="in" dbvarname="p_mm_desmontagem" cfsqltype="cf_sql_integer" value="#arguments.mm_desmontagem#">
				<cfprocparam type="in" dbvarname="p_medida_1" cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise" cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" value="#session.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.laudo_analise)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Desmontagem efetuada com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Cancela uma montagem de pneu
	-- CRISTOFER 26/01/2006
	--->
	<cffunction name="mov_exclui_montagem" returntype="struct" access="remote">
		<cfargument name="pmov_id" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_del_montagem" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pmov_id" cfsqltype="cf_sql_integer" value="#arguments.pmov_id#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Montagem cancelada com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Realiza a inspeo do pneu
	-- CRISTOFER 27/01/2006
	--->
	<cffunction name="mov_inspecao" returntype="struct" access="remote">
		<cfargument name="pneu_id" 				required="yes">
		<cfargument name="mm_inspecao" 			required="yes">
		<cfargument name="pressao_encontrada" 	required="yes">
		<cfargument name="medida_1" 			required="yes">
		<cfargument name="medida_2" 			required="yes">
		<cfargument name="medida_3" 			required="yes">
		<cfargument name="laudo_analise" 		required="no">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_inspecao" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in"  dbvarname="p_pneu_id" 				cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in"  dbvarname="p_mm_inspecao" 			cfsqltype="cf_sql_integer" value="#arguments.mm_inspecao#">
				<cfprocparam type="in"  dbvarname="p_pressao_encontrada" 	cfsqltype="cf_sql_integer" value="#arguments.pressao_encontrada#" null="#iif(isDefined("arguments.pressao_encontrada") and Len(Trim(arguments.pressao_encontrada)),DE("no"),DE("yes"))#">
				<cfprocparam type="in"  dbvarname="p_medida_1" 				cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in"  dbvarname="p_medida_2" 				cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in"  dbvarname="p_medida_3" 				cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in"  dbvarname="p_laudo_analise_id" 		cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in"  dbvarname="p_pmov_id" 				cfsqltype="cf_sql_integer" null="yes">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="out" dbvarname="p_num_inspecao" 			cfsqltype="cf_sql_integer" variable="retorno.num_inspecao">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Inspeo confirmada com sucesso.">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Monta um pneu na posio
	-- CRISTOFER 26/01/2006
	--->
	<cffunction name="mov_montagem" returntype="struct" access="remote">
		<cfargument name="num_gabarito" required="yes">
		<cfargument name="num_eixo" required="yes">
		<cfargument name="posicao" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="data_montagem" required="yes">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfif Len(Trim(arguments.COD_VEICULO))>
			<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		</cfif>
		<cfdump var="#arguments#">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_montagem" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_num_gabarito" 	cfsqltype="cf_sql_integer" value="#arguments.num_gabarito#">
				<cfprocparam type="in" dbvarname="p_num_eixo" 		cfsqltype="cf_sql_integer" value="#arguments.num_eixo#">
				<cfprocparam type="in" dbvarname="p_posicao" 		cfsqltype="cf_sql_varchar" value="#arguments.posicao#">
				<cfprocparam type="in" dbvarname="p_placa"			cfsqltype="cf_sql_varchar" value="#arguments.placa#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 		cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_data_montagem" 	cfsqltype="cf_sql_varchar" value="#arguments.data_montagem#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.cod_pessoa_responsavel)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu montado com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Realiza uma recapagem do pneu
	-- CRISTOFER 27/01/2006
	--->
	<cffunction name="mov_recapagem" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="km_veiculo" required="yes">
		<cfargument name="laudo_desmontagem_id" required="yes">
		<cfargument name="data_hora" required="yes">
		<cfargument name="mm_desmontagem" required="yes">
		<cfargument name="medida_1" required="yes">
		<cfargument name="medida_2" required="yes">
		<cfargument name="medida_3" required="yes">
		<cfargument name="laudo_analise" required="no">
		<cfargument name="cod_pessoa_reformador" required="yes">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_km_veiculo" cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#">
				<cfprocparam type="in" dbvarname="p_laudo_desmontagem_id" cfsqltype="cf_sql_integer" value="#arguments.laudo_desmontagem_id#">
				<cfprocparam type="in" dbvarname="p_data_desmontagem" cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
				<cfprocparam type="in" dbvarname="p_mm_desmontagem" cfsqltype="cf_sql_integer" value="#arguments.mm_desmontagem#">
				<cfprocparam type="in" dbvarname="p_medida_1" cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise" cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" cfsqltype="cf_sql_integer" value="#session.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_reformador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_reformador#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.cod_pessoa_responsavel)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu desmontado e enviado para a reforma com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>			
	</cffunction>	
		
	<!--- 
	-- PROPSITO
	-- Realiza um sucateamento de pneu
	-- CRISTOFER 24/01/2006
	--->
	<cffunction name="mov_sucateamento" returntype="struct" access="remote">
		<cfargument name="pneu_id" 				required="yes">
		<cfargument name="km_veiculo" 			required="yes">
		<cfargument name="laudo_desmontagem_id" required="yes">
		<cfargument name="data_desmontagem" 	required="yes">
		<cfargument name="mm_desmontagem" 		required="yes">
		<cfargument name="medida_1" 			required="yes">
		<cfargument name="medida_2" 			required="yes">
		<cfargument name="medida_3" 			required="yes">
		<cfargument name="laudo_analise" 		required="no">
		<cfargument name="observacao" 			required="yes">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_sucata" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" 				cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_km_veiculo" 			cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#">
				<cfprocparam type="in" dbvarname="p_laudo_desmontagem_id" 	cfsqltype="cf_sql_integer" value="#arguments.laudo_desmontagem_id#">
				<cfprocparam type="in" dbvarname="p_data_desmontagem" 		cfsqltype="cf_sql_varchar" value="#arguments.data_desmontagem#">
				<cfprocparam type="in" dbvarname="p_mm_desmontagem" 		cfsqltype="cf_sql_integer" value="#arguments.mm_desmontagem#">
				
				<cfprocparam type="in" dbvarname="p_medida_1" 				cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" 				cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" 				cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise" 			cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" 			cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				
				<cfprocparam type="in" dbvarname="p_cod_departamento" 		cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" 				cfsqltype="cf_sql_integer" value="#session.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" 		cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_sucateador" 	cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_observacao" 			cfsqltype="cf_sql_varchar" value="#arguments.observacao#">
				
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.laudo_analise)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu desmontado e enviado para anlise de sucateamento!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>			
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Realiza uma troca de pneus
	-- CRISTOFER 24/01/2006
	--->
	<cffunction name="mov_troca" returntype="struct" access="remote">
		<cfargument name="pneu_id_colocado" required="yes">
		<cfargument name="pneu_id" hint="RETIRADO" required="yes">
		<cfargument name="km_veiculo" required="yes">
		<cfargument name="laudo_desmontagem_id" required="yes">
		<cfargument name="data_hora" required="yes">
		<cfargument name="mm_desmontagem" required="yes">
		<cfargument name="medida_1" required="yes">
		<cfargument name="medida_2" required="yes">
		<cfargument name="medida_3" required="yes">
		<cfargument name="laudo_analise" required="no">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="cod_pessoa_motorista" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_movimentacao.prc_mov_troca_pneu" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id_colocado" 		cfsqltype="cf_sql_integer" value="#arguments.pneu_id_colocado#">
				<cfprocparam type="in" dbvarname="p_pneu_id_retirado" 		cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_km_veiculo" 			cfsqltype="cf_sql_integer" value="#arguments.km_veiculo#">
				<cfprocparam type="in" dbvarname="p_laudo_desmontagem_id" 	cfsqltype="cf_sql_integer" value="#arguments.laudo_desmontagem_id#">
				<cfprocparam type="in" dbvarname="p_data" 					cfsqltype="cf_sql_varchar" value="#arguments.data_hora#">
				<cfprocparam type="in" dbvarname="p_mm_desmontagem" 		cfsqltype="cf_sql_integer" value="#arguments.mm_desmontagem#">
				<cfprocparam type="in" dbvarname="p_medida_1" 				cfsqltype="cf_sql_integer" value="#arguments.medida_1#">
				<cfprocparam type="in" dbvarname="p_medida_2" 				cfsqltype="cf_sql_integer" value="#arguments.medida_2#">
				<cfprocparam type="in" dbvarname="p_medida_3" 				cfsqltype="cf_sql_integer" value="#arguments.medida_3#">
				<cfprocparam type="in" dbvarname="p_laudo_analise" 			cfsqltype="cf_sql_integer" value="#arguments.laudo_analise#" null="#iif(isDefined("arguments.laudo_analise") and Len(Trim(arguments.laudo_analise)),DE("no"),DE("yes"))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa" 			cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_cod_departamento" 		cfsqltype="cf_sql_integer" value="#session.cod_departamento#">
				<cfprocparam type="in" dbvarname="p_cod_setor" 				cfsqltype="cf_sql_integer" value="#session.cod_setor#">
				<cfprocparam type="in" dbvarname="p_cod_centro_custo" 		cfsqltype="cf_sql_integer" value="#session.cod_centro_custo#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_responsavel" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_responsavel#" null="#iif(len(trim(arguments.laudo_analise)) ,DE('no'),DE('yes'))#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_motorista" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_motorista#" null="#iif(len(trim(arguments.cod_pessoa_motorista)) ,DE('no'),DE('yes'))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneus Trocados com sucesso!">
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>			
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Recusa o sucateamento do pneu
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="recusa_sucateamento" returntype="struct" access="remote">
		<cfargument name="psu_id" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="motivo" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_del_sucateamento" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_psu_id" cfsqltype="cf_sql_integer" value="#arguments.psu_id#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "O sucateamento foi recusado, ele ficar bloqueado at que sua situao seja resolvida.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Realiza uma troca de pneus
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="recusa_transferencia_pneu" returntype="struct" access="remote">
		<cfargument name="localizacao_id" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="motivo" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu_dml.prc_transf_recusa" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_localizacao_id" cfsqltype="cf_sql_integer" value="#arguments.localizacao_id#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Transferncia recusada, pneu ficar bloqueado at o momento que a situao de transferncia for resolvida.">			
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Registra uma nova observao para o pneu
	-- CRISTOFER 08/02/2006
	--->	
	<cffunction name="registra_observacao" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="no">
		<cfargument name="observacoes" required="no">
		<cftry>
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				update oper.v$pneu
				   set observacoes = '[' || user || '] ' || to_char(sysdate,'dd/mm hh24:mi') || ' - #arguments.observacoes# ' || decode(observacoes,null,observacoes, chr(10) || observacoes)
				 where pneu_id = #arguments.pneu_id#
			</cfquery>			
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Observao registrada com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna um pneu da analise de garantia
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="retorno_garantia" returntype="struct" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_pessoa_fornecedor" required="yes">
		<cfargument name="data_envio_analise" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="sucata" required="no" default="0">
		<cfargument name="reforma" required="no" default="0">
		<cfargument name="observacao" required="no">
		<cfargument name="laudo_id" required="no">
		<cfargument name="cod_pessoa_mot_resp" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="desenho_id" required="no" default="">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_retorno_analise_garantia" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_fornecedor" cfsqltype="cf_sql_integer" value="#arguments.COD_PESSOA_FORNECEDOR#">
				<cfprocparam type="in" dbvarname="p_data_envio_analise" cfsqltype="cf_sql_varchar" value="#DateFormat(arguments.DATA_ENVIO_ANALISE,'dd/mm/yyyy')# #TimeFormat(arguments.DATA_ENVIO_ANALISE,'HH:MM:SS')#">
				<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_float" value="#arguments.VALOR#" null="#iif(len(trim(arguments.valor)), de('no'), de('yes'))#">
				<cfprocparam type="in" dbvarname="p_sucata" cfsqltype="cf_sql_integer" value="#arguments.SUCATA#">
				<cfprocparam type="in" dbvarname="p_reforma" cfsqltype="cf_sql_integer" value="#arguments.REFORMA#">
				<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.OBSERVACAO#">
				<cfprocparam type="in" dbvarname="p_laudo_id" cfsqltype="cf_sql_varchar" value="#arguments.LAUDO_ID#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_mot_resp" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_mot_resp#"  null="#iif(isdefined("arguments.cod_pessoa_mot_resp") and len(trim(arguments.cod_pessoa_mot_resp)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#"  null="#iif(isdefined("arguments.borracha_id") and len(trim(arguments.borracha_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#" null="#iif(isdefined("arguments.desenho_id") and len(trim(arguments.desenho_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_num_nota_fiscal" cfsqltype="cf_sql_integer" value="#arguments.num_nota_fiscal#" null="#iif(isdefined("arguments.num_nota_fiscal") and len(trim(arguments.num_nota_fiscal)),de("no"),de("yes"))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " teve sua anlise de garantia avaliada com sucesso.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Realiza uma troca de proprietario dos pneus
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="troca_proprietario" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="data_troca" required="yes">
		<cfargument name="cod_pessoa_comprador" required="yes">
		<cfargument name="complemento" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_troca_proprietario" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_data_troca" cfsqltype="cf_sql_varchar" value="#arguments.data_troca#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_comprador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_comprador#">
				<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_float" value="#arguments.valor#">
				<cfprocparam type="in" dbvarname="p_complemento" cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Proprietrio do pneu trocado com sucesso. Valor do pneu debitado na conta do agregado.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Altera o desenho de uma reforma
	-- CRISTOFER 08/02/2006
	--->	
	<cffunction name="upd_desenho_reforma" returntype="struct" access="remote">
		<cfargument name="conserto_id" required="yes">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="motivo" required="yes">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_upd_reforma" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_conserto_id" cfsqltype="cf_sql_integer" value="#arguments.conserto_id#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#">
				<cfprocparam type="in" dbvarname="borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#">
				<cfprocparam type="in" dbvarname="motivo" cfsqltype="cf_sql_varchar" value="#arguments.motivo#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Desenho da reforma alterado com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Realiza uma venda do pneu
	-- CRISTOFER 01/02/2006
	--->	
	<cffunction name="venda_pneu" returntype="struct" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="data_venda" required="yes">
		<cfargument name="valor_venda" required="yes">
		<cfargument name="cod_pessoa_comprador" required="yes">
		<cfargument name="complemento" required="yes">
		<cftry>
			<cfif not len(trim(session.cod_pessoa))>
				<cfthrow message="No foi possvel determinar a lotao do usurio">
			</cfif>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_venda_pneu" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_data_venda" cfsqltype="cf_sql_varchar" value="#LSDateFormat(arguments.data_venda,'dd/mm/yyyy')# #LSTimeFormat(arguments.data_venda)#">
				<cfprocparam type="in" dbvarname="p_valor_venda" cfsqltype="cf_sql_numeric" scale="5" value="#arguments.valor_venda#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_comprador" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_comprador#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
				<cfprocparam type="in" dbvarname="p_complemento" cfsqltype="cf_sql_varchar" value="#arguments.complemento#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu vendido com sucesso!">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Realiza a venda de todos os pneus do veiculo
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="venda_veiculo" returntype="struct" access="remote">
		<cfargument name="cod_veiculo" 					required="yes">
		<cfargument name="data" 					required="yes">
		<cfargument name="cod_pessoa_fornecedor" 	required="yes">
		<cfset arguments.placa = this.get_placa(arguments.COD_VEICULO)>
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_venda_veiculo" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_placa" 					cfsqltype="cf_sql_varchar" value="#arguments.placa#">
				<cfprocparam type="in" dbvarname="p_data" 					cfsqltype="cf_sql_varchar" value="#arguments.data#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_venda" 		cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_fornecedor#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_sucateador" 	cfsqltype="cf_sql_integer" value="#session.cod_pessoa#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Todos os pneus foram marcados como vendidos e desmontados do veculo.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Libera reforma manualmente
	-- guto 27/06/2006 15:32:47 - CRIADO
	--->
	<cffunction name='libera_reforma' displayname='Libera reforma manualmente' access='remote' returntype='Struct' output='true'>
		<cfargument name='PNEU_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu.prc_libera_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PNEU_ID'  value='#arguments.PNEU_ID#'  null='#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reforma liberada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Libera Lancamento de Debito na conta corrente do motorista(pneu Sucateado)
	-- Wagner 31/07/2006 15:32:47 - CRIADO
	--->
	<cffunction name='ins_debito_conta_motorista' displayname='Lanca debito na conta do motorista' access='remote' returntype='Struct' output='true'>
		<cfargument name="cod_pessoa" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="valor_venda" required="yes">
		<cfargument name="historico" required="yes">
		
		<cftry>
			<cftransaction action="begin">	
				<cfquery datasource="#session.dsn#" name="qr_ccorrente" username="#session.usuario#" password="#session.senha#">
							select /*+ORDERED */ cc.cod_conta, oper.pkg_global.fnc_busca_nome_pessoa(#arguments.cod_pessoa#) as nome_funcionario
							  from oper.v$ccorrente cc 
							 where cc.cod_pessoa = #arguments.cod_pessoa#
							   and cc.modalidade_id = 9  
							   and cc.ativo = 1 
				</cfquery>
				
				
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_ccorrente.prc_insere_lancto_ccorrente" username="#session.usuario#" password="#session.senha#">
						<cfprocparam type="inout" dbvarname="p_num_lancamento" cfsqltype="cf_sql_integer" null="yes" variable="retorno.num_lancamento">
						<cfprocparam type="in" dbvarname="p_cod_conta" 		   cfsqltype="cf_sql_integer" value="#qr_ccorrente.cod_conta#">
						<cfprocparam type="in" dbvarname="p_cod_pessoa_un" 	   cfsqltype="cf_sql_integer" value="1">
						<cfprocparam type="in" dbvarname="p_cod_documento" 	   cfsqltype="cf_sql_integer" value="93">
						<cfprocparam type="in" dbvarname="p_num_documento" 	   cfsqltype="cf_sql_integer" value="#DateFormat(Now(),'yyyy')##arguments.pneu_id#">
						<cfprocparam type="in" dbvarname="p_data_lancamento"   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
						<cfprocparam type="in" dbvarname="p_data_vencto" 	   cfsqltype="cf_sql_varchar" value="#DateFormat(Now(),'dd/mm/yyyy')#">
						<cfprocparam type="in" dbvarname="p_historico" 		   cfsqltype="cf_sql_varchar" value="Controle de pneus: #arguments.historico#">
						<cfprocparam type="in" dbvarname="p_valor_lancamento"  cfsqltype="cf_sql_float"   value="#arguments.valor_venda#">
						<cfprocparam type="in" dbvarname="p_deb_cred" 		   cfsqltype="cf_sql_integer" value="0">
						<cfprocparam type="in" dbvarname="p_favorecido" 	   cfsqltype="cf_sql_varchar" value="#qr_ccorrente.nome_funcionario#">
						<cfprocparam type="inout" dbvarname="p_rowid" 		   cfsqltype="cf_sql_varchar" variable="retorno.rowid" null="yes">					
				</cfstoredproc>
			</cftransaction>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = "Items verificados com sucesso!">
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere um tipo de conserto para pneu.
	-- arlen 05/10/2006 16:50:20 - CRIADO
	--->
	<cffunction name='ins_pneu_tipo_conserto' displayname='Insere um tipo de conserto para pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='BLOQUEIA_REFORMA' required='no' default="0">
		<cfargument name='PREJUDICA_CARCACA' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_tipo_conserto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BLOQUEIA_REFORMA'  value='#arguments.BLOQUEIA_REFORMA#'  null='#iif(len(trim(arguments.BLOQUEIA_REFORMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREJUDICA_CARCACA'  value='#arguments.PREJUDICA_CARCACA#'  null='#iif(len(trim(arguments.PREJUDICA_CARCACA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONSERTO_ID' variable='retorno.TIPO_CONSERTO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conserto para pneu inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Altera um tipo de conserto para pneu.
	-- arlen 05/10/2006 16:55:19 - CRIADO
	--->
	<cffunction name='alt_pneu_tipo_conserto' displayname='Altera um tipo de conserto para pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_CONSERTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='BLOQUEIA_REFORMA' required='no' default="0">
		<cfargument name='PREJUDICA_CARCACA' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_tipo_conserto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONSERTO_ID'  value='#arguments.TIPO_CONSERTO_ID#'  null='#iif(len(trim(arguments.TIPO_CONSERTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BLOQUEIA_REFORMA'  value='#arguments.BLOQUEIA_REFORMA#'  null='#iif(len(trim(arguments.BLOQUEIA_REFORMA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PREJUDICA_CARCACA'  value='#arguments.PREJUDICA_CARCACA#'  null='#iif(len(trim(arguments.PREJUDICA_CARCACA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conserto para pneu alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um tipo de conserto para pneu.
	-- arlen 05/10/2006 16:57:01 - CRIADO
	--->
	<cffunction name='del_pneu_tipo_conserto' displayname='Exclui um tipo de conserto para pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_CONSERTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_tipo_conserto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_CONSERTO_ID'  value='#arguments.TIPO_CONSERTO_ID#'  null='#iif(len(trim(arguments.TIPO_CONSERTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de conserto para pneu excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Cancela Venda
	-- Wagner 07/11/2006 15:32:47 - CRIADO
	--->
	<cffunction name='cancela_venda_pneu' displayname='Cancela Venda' access='remote' returntype='Struct' output='true'>
		<cfargument name='PNEU_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu.prc_cancela_venda_pneu' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PNEU_ID'  value='#arguments.PNEU_ID#'  null='#iif(len(trim(arguments.PNEU_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Venda cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere uma marca de pneu
	-- LOUIS 08/03/2007 09:01:57 - CRIADO
	--->
	<cffunction name='ins_pneu_marca' displayname='Insere uma marca de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID' variable='retorno.MARCA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de pneu inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma marca de pneu
	-- LOUIS 08/03/2007 16:43:39 - CRIADO
	--->
	<cffunction name='upd_pneu_marca' displayname='Altera uma marca de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de pneu alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	<!--- 
	-- PROPSITO
	-- Exclui uma marca de pneu
	-- LOUIS 08/03/2007 10:46:30 - CRIADO
	--->
	<cffunction name='del_pneu_marca' displayname='Exclui uma marca de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='MARCA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_marca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de pneu excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma medida de pneu
	-- LOUIS 08/03/2007 10:49:56 - CRIADO
	--->
	<cffunction name='ins_pneu_medida' displayname='Insere uma medida de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_medida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_ID' variable='retorno.MEDIDA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida de pneu inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma medida de pneu
	-- LOUIS 08/03/2007 10:51:28 - CRIADO
	--->
	<cffunction name='upd_pneu_medida' displayname='Altera uma medida de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='MEDIDA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_medida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_ID'  value='#arguments.MEDIDA_ID#'  null='#iif(len(trim(arguments.MEDIDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida de pneu alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui uma medida de pneu
	-- LOUIS 08/03/2007 10:53:00 - CRIADO
	--->
	<cffunction name='del_pneu_medida' displayname='Exclui uma medida de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='MEDIDA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_medida' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_ID'  value='#arguments.MEDIDA_ID#'  null='#iif(len(trim(arguments.MEDIDA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida de pneu excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere uma medida de roda
	-- LOUIS 08/03/2007 10:55:37 - CRIADO
	--->
	<cffunction name='ins_pneu_medida_roda' displayname='Insere a medida da roda' access='remote' returntype='Struct' output='true'>
		<cfargument name='MEDIDA_RODA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_medida_roda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MEDIDA_RODA'  value='#arguments.MEDIDA_RODA#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_RODA_ID' variable='retorno.MEDIDA_RODA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida da roda inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>

				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera uma medida entre a roda e o pneu
	-- LOUIS 08/03/2007 10:57:13 - CRIADO
	--->
	<cffunction name='upd_pneu_medida_roda' displayname='Altera a medida da roda' access='remote' returntype='Struct' output='true'>
		<cfargument name='MEDIDA_RODA_ID' required='yes'>
		<cfargument name='MEDIDA_RODA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_medida_roda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_RODA_ID'  value='#arguments.MEDIDA_RODA_ID#'  null='#iif(len(trim(arguments.MEDIDA_RODA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MEDIDA_RODA'  value='#arguments.MEDIDA_RODA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida da roda alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Exclui uma medida entre a roda e o pneu
	-- LOUIS 08/03/2007 10:57:59 - CRIADO
	--->
	
	<cffunction name='del_pneu_medida_roda' displayname='Exclui a medida da roda' access='remote' returntype='Struct' output='true'>
		<cfargument name='MEDIDA_RODA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_medida_roda' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_RODA_ID'  value='#arguments.MEDIDA_RODA_ID#'  null='#iif(len(trim(arguments.MEDIDA_RODA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Medida da roda excluda com sucesso!')>
			</cftransaction>
			<cfcatch>	
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um tipo de lona
	-- LOUIS 09/03/2007 10:47:45 - CRIADO
	--->
	<cffunction name='ins_pneu_lona' displayname='Insere um tipo de lona' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_lona' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONA_ID' variable='retorno.LONA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de lona inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um tipo de lona
	-- LOUIS 09/03/2007 11:13:39 - CRIADO
	--->
	<cffunction name='upd_pneu_lona' displayname='Altera um tipo de lona' access='remote' returntype='Struct' output='true'>
		<cfargument name='LONA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_lona' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONA_ID'  value='#arguments.LONA_ID#'  null='#iif(len(trim(arguments.LONA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de lona alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um tipo de lona
	-- LOUIS 09/03/2007 11:16:12 - CRIADO
	--->
	<cffunction name='del_pneu_lona' displayname='Exclui um tipo de lona' access='remote' returntype='Struct' output='true'>
		<cfargument name='LONA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_lona' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONA_ID'  value='#arguments.LONA_ID#'  null='#iif(len(trim(arguments.LONA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de lona excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Inclui um formato de borracha
	-- LOUIS 09/03/2007 11:27:46 - CRIADO
	--->
	<cffunction name='ins_pneu_formato_borracha' displayname='Inclui um formato de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_formato_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID' variable='retorno.FORMATO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Formato de borracaha includo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Altera um formato de borracha
	-- LOUIS 09/03/2007 11:29:03 - CRIADO
	--->
	<cffunction name='upd_pneu_formato_borracha' displayname='Altera um formato de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_formato_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Formato de borracaha alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um formato de borracha
	-- LOUIS 09/03/2007 11:30:07 - CRIADO
	--->
	<cffunction name='del_pneu_formato_borracha' displayname='Exclui um formato de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_formato_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Formato de borracaha excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere um modelo de pneu
	-- LOUIS 12/03/2007 09:23:08 - CRIADO
	--->
	<cffunction name='ins_pneu_modelo' displayname='Insere um modelo de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<!--- <cfargument name='IMAGEM' required='yes'> --->
		<cfargument name='SULCO' required='yes'>
		<cfargument name='COD_INDICE_CARGA_SIMPLES' required='yes'>
		<cfargument name='COD_INDICE_CARGA_DUPLO' required='yes'>
		<cfargument name='COD_INDICE_VELOCIDADE' required='yes'>
		<!--- <cfargument name='NUM_LONAS' required='yes'> --->
		<cfargument name='POSSUI_CAMARA' required='yes'>
		<cfargument name='MAXIMO_REFORMAS' required='yes'>
		<cfargument name='MAXIMO_CONSERTOS' required='yes'>
		<cfargument name='MAXIMO_FUROS' required='yes'>
		<cfargument name='EIXO_TRACIONADO' required='yes'>
		<cfargument name='EIXO_DIRECIONAL' required='yes'>
		<cfargument name='EIXO_SUSPENSO' required='yes'>
		<cfargument name='PRESSAO_IDEAL' required='yes'>
		<cfargument name='LARGURA_MANTA' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MEDIDA_ID' required='yes'>
		<cfargument name='MEDIDA_RODA_ID' required='yes'>
		<cfargument name='LONA_ID' required='yes'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  null="yes" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SULCO'  value='#arguments.SULCO#'  null='#iif(len(trim(arguments.SULCO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_INDICE_CARGA_SIMPLES'  value='#arguments.COD_INDICE_CARGA_SIMPLES#'  null='#iif(len(trim(arguments.COD_INDICE_CARGA_SIMPLES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_INDICE_CARGA_DUPLO'  value='#arguments.COD_INDICE_CARGA_DUPLO#'  null='#iif(len(trim(arguments.COD_INDICE_CARGA_DUPLO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_INDICE_VELOCIDADE'  value='#arguments.COD_INDICE_VELOCIDADE#' >
					<!--- <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LONAS'  value='#arguments.NUM_LONAS#'  null='#iif(len(trim(arguments.NUM_LONAS)), de('no'), de('yes'))#'> --->
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LONAS'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSSUI_CAMARA'  value='#arguments.POSSUI_CAMARA#'  null='#iif(len(trim(arguments.POSSUI_CAMARA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_REFORMAS'  value='#arguments.MAXIMO_REFORMAS#'  null='#iif(len(trim(arguments.MAXIMO_REFORMAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_CONSERTOS'  value='#arguments.MAXIMO_CONSERTOS#'  null='#iif(len(trim(arguments.MAXIMO_CONSERTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_FUROS'  value='#arguments.MAXIMO_FUROS#'  null='#iif(len(trim(arguments.MAXIMO_FUROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_TRACIONADO'  value='#arguments.EIXO_TRACIONADO#'  null='#iif(len(trim(arguments.EIXO_TRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_DIRECIONAL'  value='#arguments.EIXO_DIRECIONAL#'  null='#iif(len(trim(arguments.EIXO_DIRECIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_SUSPENSO'  value='#arguments.EIXO_SUSPENSO#'  null='#iif(len(trim(arguments.EIXO_SUSPENSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRESSAO_IDEAL'  value='#arguments.PRESSAO_IDEAL#'  null='#iif(len(trim(arguments.PRESSAO_IDEAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA_MANTA'  value='#arguments.LARGURA_MANTA#'  null='#iif(len(trim(arguments.LARGURA_MANTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_ID'  value='#arguments.MEDIDA_ID#'  null='#iif(len(trim(arguments.MEDIDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_RODA_ID'  value='#arguments.MEDIDA_RODA_ID#'  null='#iif(len(trim(arguments.MEDIDA_RODA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONA_ID'  value='#arguments.LONA_ID#'  null='#iif(len(trim(arguments.LONA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#' variable='retorno.MODELO_ID'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de pneu inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Altera um modelo de pneu
	-- LOUIS 12/03/2007 10:22:34 - CRIADO
	--->
	<cffunction name='upd_pneu_modelo' displayname='Altera um modelo de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
	<!--- <cfargument name='IMAGEM' required='yes'> --->
		<cfargument name='SULCO' required='yes'>
		<cfargument name='COD_INDICE_CARGA_SIMPLES' required='yes'>
		<cfargument name='COD_INDICE_CARGA_DUPLO' required='yes'>
		<cfargument name='COD_INDICE_VELOCIDADE' required='yes'>
	<!--- <cfargument name='NUM_LONAS' required='yes'> --->
		<cfargument name='POSSUI_CAMARA' required='yes'>
		<cfargument name='MAXIMO_REFORMAS' required='yes'>
		<cfargument name='MAXIMO_CONSERTOS' required='yes'>
		<cfargument name='MAXIMO_FUROS' required='yes'>
		<cfargument name='EIXO_TRACIONADO' required='yes'>
		<cfargument name='EIXO_DIRECIONAL' required='yes'>
		<cfargument name='EIXO_SUSPENSO' required='yes'>
		<cfargument name='PRESSAO_IDEAL' required='yes'>
		<cfargument name='LARGURA_MANTA' required='yes'>
		<cfargument name='MARCA_ID' required='yes'>
		<cfargument name='MEDIDA_ID' required='yes'>
		<cfargument name='MEDIDA_RODA_ID' required='yes'>
		<cfargument name='LONA_ID' required='yes'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
<!---					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#arguments.IMAGEM#' > --->
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  null="yes" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SULCO'  value='#arguments.SULCO#'  null='#iif(len(trim(arguments.SULCO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_INDICE_CARGA_SIMPLES'  value='#arguments.COD_INDICE_CARGA_SIMPLES#'  null='#iif(len(trim(arguments.COD_INDICE_CARGA_SIMPLES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_INDICE_CARGA_DUPLO'  value='#arguments.COD_INDICE_CARGA_DUPLO#'  null='#iif(len(trim(arguments.COD_INDICE_CARGA_DUPLO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_INDICE_VELOCIDADE'  value='#arguments.COD_INDICE_VELOCIDADE#' >
<!--- 					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LONAS'  value='#arguments.NUM_LONAS#'  null='#iif(len(trim(arguments.NUM_LONAS)), de('no'), de('yes'))#'> --->
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_LONAS'  null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSSUI_CAMARA'  value='#arguments.POSSUI_CAMARA#'  null='#iif(len(trim(arguments.POSSUI_CAMARA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_REFORMAS'  value='#arguments.MAXIMO_REFORMAS#'  null='#iif(len(trim(arguments.MAXIMO_REFORMAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_CONSERTOS'  value='#arguments.MAXIMO_CONSERTOS#'  null='#iif(len(trim(arguments.MAXIMO_CONSERTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MAXIMO_FUROS'  value='#arguments.MAXIMO_FUROS#'  null='#iif(len(trim(arguments.MAXIMO_FUROS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_TRACIONADO'  value='#arguments.EIXO_TRACIONADO#'  null='#iif(len(trim(arguments.EIXO_TRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_DIRECIONAL'  value='#arguments.EIXO_DIRECIONAL#'  null='#iif(len(trim(arguments.EIXO_DIRECIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_SUSPENSO'  value='#arguments.EIXO_SUSPENSO#'  null='#iif(len(trim(arguments.EIXO_SUSPENSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRESSAO_IDEAL'  value='#arguments.PRESSAO_IDEAL#'  null='#iif(len(trim(arguments.PRESSAO_IDEAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA_MANTA'  value='#arguments.LARGURA_MANTA#'  null='#iif(len(trim(arguments.LARGURA_MANTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MARCA_ID'  value='#arguments.MARCA_ID#'  null='#iif(len(trim(arguments.MARCA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_ID'  value='#arguments.MEDIDA_ID#'  null='#iif(len(trim(arguments.MEDIDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MEDIDA_RODA_ID'  value='#arguments.MEDIDA_RODA_ID#'  null='#iif(len(trim(arguments.MEDIDA_RODA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LONA_ID'  value='#arguments.LONA_ID#'  null='#iif(len(trim(arguments.LONA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de pneu alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Exclui um modelo de pneu
	-- LOUIS 12/03/2007 10:27:22 - CRIADO
	--->
	<cffunction name='del_pneu_modelo' displayname='Exclui um modelo de pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_ID'  value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de pneu excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
		
	<!--- 
	-- PROPSITO
	-- Insere uma marca de borracha
	-- LOUIS 12/03/2007 15:50:50 - CRIADO
	--->
	<cffunction name='ins_pneu_borracha' displayname='Insere uma marca de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='IMAGEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_imagem = ''>
				<cfif len(trim(arguments.imagem))>
					<cffile action="readbinary" file="#arguments.imagem#" variable="v_imagem">
				</cfif>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#v_imagem#' null="#iif(len(trim(arguments.imagem)),de('no'),de('yes'))#	" >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BORRACHA_ID' variable='retorno.BORRACHA_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de borracha inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera uma marca de borracha
	-- LOUIS 12/03/2007 15:52:12 - CRIADO
	--->
	<cffunction name='upd_pneu_borracha' displayname='Altera uma marca de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cfargument name='IMAGEM' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_imagem = ''>
				<cfif len(trim(arguments.imagem))>
					<cffile action="readbinary" file="#arguments.imagem#" variable="v_imagem">
				</cfif>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#v_imagem#' null="#iif(len(trim(arguments.imagem)),de('no'),de('yes'))#	" >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de borracha alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Exclui uma marca de borracha
	-- LOUIS 12/03/2007 15:22:02 - CRIADO
	--->
	<cffunction name='del_pneu_borracha' displayname='Exclui uma marca de borracha' access='remote' returntype='Struct' output='true'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_borracha' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Marca de borracha excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um desenho da Reforma
	-- LOUIS 13/03/2007 09:20:50 - CRIADO
	--->
	<cffunction name='ins_pneu_desenho' displayname='Insere um desenho da Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SULCO' required='yes'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cfargument name='MODALIDADE_ID' required='yes'>
		<cfargument name='IMAGEM' required='yes'>
		<cfargument name='EIXO_TRACIONADO' required='yes'>
		<cfargument name='EIXO_DIRECIONAL' required='yes'>
		<cfargument name='EIXO_SUSPENSO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_imagem = ''>
				<cfif len(trim(arguments.imagem))>
					<cffile action="readbinary" file="#arguments.imagem#" variable="v_imagem">
				</cfif>
				<cfdump var="#arguments#">
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_ins_pneu_desenho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SULCO'  value='#arguments.SULCO#'  null='#iif(len(trim(arguments.SULCO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#arguments.MODALIDADE_ID#'  null='#iif(len(trim(arguments.MODALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#v_imagem#' null="#iif(len(trim(arguments.imagem)),de('no'),de('yes'))#" >
			    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_TRACIONADO'  value='#arguments.EIXO_TRACIONADO#'  null='#iif(len(trim(arguments.EIXO_TRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_DIRECIONAL'  value='#arguments.EIXO_DIRECIONAL#'  null='#iif(len(trim(arguments.EIXO_DIRECIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_SUSPENSO'  value='#arguments.EIXO_SUSPENSO#'  null='#iif(len(trim(arguments.EIXO_SUSPENSO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESENHO_ID' variable='retorno.DESENHO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Desenho da reforma inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Altera um desenho da Reforma
	-- LOUIS 13/03/2007 09:21:43 - CRIADO
	--->
	<cffunction name='upd_pneu_desenho' displayname='Altera um desenho da Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='BORRACHA_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SULCO' required='yes'>
		<cfargument name='FORMATO_ID' required='yes'>
		<cfargument name='MODALIDADE_ID' required='yes'>
		<cfargument name='IMAGEM' required='yes'>
		<cfargument name='EIXO_TRACIONADO' required='yes'>
		<cfargument name='EIXO_DIRECIONAL' required='yes'>
		<cfargument name='EIXO_SUSPENSO' required='yes'>
		<cfargument name='DESENHO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_imagem = ''>
				<cfif len(trim(arguments.imagem))>
					<cffile action="readbinary" file="#arguments.imagem#" variable="v_imagem">
				</cfif>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_alt_pneu_desenho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_BORRACHA_ID'  value='#arguments.BORRACHA_ID#'  null='#iif(len(trim(arguments.BORRACHA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SULCO'  value='#arguments.SULCO#'  null='#iif(len(trim(arguments.SULCO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FORMATO_ID'  value='#arguments.FORMATO_ID#'  null='#iif(len(trim(arguments.FORMATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODALIDADE_ID'  value='#arguments.MODALIDADE_ID#'  null='#iif(len(trim(arguments.MODALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_IMAGEM'  value='#v_imagem#' null="#iif(len(trim(arguments.imagem)),de('no'),de('yes'))#">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_TRACIONADO'  value='#arguments.EIXO_TRACIONADO#'  null='#iif(len(trim(arguments.EIXO_TRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_DIRECIONAL'  value='#arguments.EIXO_DIRECIONAL#'  null='#iif(len(trim(arguments.EIXO_DIRECIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EIXO_SUSPENSO'  value='#arguments.EIXO_SUSPENSO#'  null='#iif(len(trim(arguments.EIXO_SUSPENSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESENHO_ID'  value='#arguments.DESENHO_ID#'  null='#iif(len(trim(arguments.DESENHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Desenho da reforma alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um desenho da Reforma
	-- LOUIS 13/03/2007 09:22:41 - CRIADO
	--->
	<cffunction name='del_pneu_desenho' displayname='Exclui um desenho da Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESENHO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu_dml.prc_del_pneu_desenho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESENHO_ID'  value='#arguments.DESENHO_ID#'  null='#iif(len(trim(arguments.DESENHO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Desenho da reforma excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere ficha de calibragem
	-- guto 02/04/2007 13:52:49 - CRIADO
	--->
	<cffunction name='ins_ficha_calibragem' displayname='Insere ficha de calibragem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu.prc_ins_calibragem_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ficha aberta com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Fecha calibragem por pneu
	-- guto 02/04/2007 13:53:57 - CRIADO
	--->
	<cffunction name='fecha_calibragem' displayname='Fecha calibragem por pneu' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='PRESSAO_ENCONTRADA' required='yes'>
		<cftry>			
			<cftransaction action='begin'>
				<cfdump var="#arguments#">
				<cfstoredproc procedure='oper.pkg_pneu.prc_fecha_calibragem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRESSAO_ENCONTRADA'  value='#arguments.PRESSAO_ENCONTRADA#'  null='#iif(len(trim(arguments.PRESSAO_ENCONTRADA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Calibragem registrada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Cancela ficha de calibragem
	-- guto 02/04/2007 13:52:49 - CRIADO
	--->
	<cffunction name='cancela_ficha_calibragem' displayname='Insere ficha de calibragem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu.prc_cancela_calibragem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ficha cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Cancela calibragem individual
	-- guto 02/04/2007 13:52:49 - CRIADO
	--->
	<cffunction name='cancela_calibragem_pneu' displayname='Insere ficha de calibragem' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_pneu.prc_cancela_calibragem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_integer' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Calibragem cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
</cfcomponent>