<cfcomponent extends="_transportes.consulta.cfc_pneus">
	<!--- 
	-- PROPSITO 
	-- Busca km atual do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_km_data(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'),'#arguments.DATA#') as km_atual
			  from dual
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
 <!--- 
	-- PROPSITO 
	-- Busca as inspees de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_inspecoes" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
        <cfargument name="num_inspecao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select pi.num_inspecao, p.num_pneu, pi.placa, oper.fnc_get_cod_veiculo(pi.placa) as cod_veiculo, pi.posicao, pi.data_ult_inspecao, pi.km_ult_inspecao, pi.mm_ult_inspecao, pi.data_inspecao, 
				   pi.km_inspecao, pi.mm_inspecao, pi.medida_1, pi.medida_2, pi.medida_3, pi.movimentacao,
				   pa.descricao as laudo, pi.pressao_encontrada, pi.user_insert,
                   nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pi.pneu_id),1),0) as sulco_atual,
                   nvl(pm.mm_montagem,0) as mm_montagem,
                   oper.pkg_global.fnc_get_parametro(1,'PNEU')/100 as tolerancia,p.pneu_id,
                   pi.medida_1,pi.medida_2,pi.medida_3,pi.pressao_encontrada,
                   pi.km_carregado, pi.km_vazio
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_inspecao pi
					 on pi.pneu_id = p.pneu_id
			 left join oper.v$pneu_laudo_analise pa
					 on pa.laudo_id = pi.laudo_analise_id      
             left join oper.v$pneu_movimentacao pm 
							 on pm.pneu_id = p.pneu_id  
                             and pm.pmov_id = pi.pmov_id
			where 1=1
			<cfif IsDefined("arguments.PNEU_ID")>
				and pi.pneu_id = #arguments.PNEU_ID#
			</cfif>
            <cfif len(trim(arguments.num_inspecao))>
            	and pi.num_inspecao = #arguments.num_inspecao#
            </cfif>            
			order by pi.data_inspecao
            
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="perc_consumido" required="no">
		<cfargument name="considera_peso" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
			select a.marca_borracha || '-' || medida as marca_borracha,  
				   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
					   round(decode(a.peso_tracionado,1,a.rendimento, a.rendimento * (a.peso_tracionado/b.max_peso))) as rendimento,
				   <cfelse>
					   a.rendimento,
				   </cfif>
				   a.peso_tracionado,b.max_peso, mm_consumido,
                   case 
                    when eixo = '1' then 1
                    when eixo = '2' then 2
                    when eixo = '3' then 3
                    when eixo = 'SR1' then 4
                    when eixo = 'SR2' then 5 
                    when eixo = 'SR3' then 6
                   end ordem,
                   case 
                    when eixo = '1' then 'CV - eixo Dianteiro'
                    when eixo = '2' then 'CV - eixo Tracao'
                    when eixo = '3' then 'CV - eixo Truck'
                    when eixo = 'SR1' then 'SR - Primeiro eixo'
                    when eixo = 'SR2' then 'SR - Segundo eixo'
                    when eixo = 'SR3' then 'SR - Terceiro eixo'
                   end eixo  			   
			  from (select eixo, marca_borracha, medida, round(km_percorrido/mm_consumido) as rendimento, 
						   round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, mm_consumido
					  from (select eixo,  decode(r.reformas, 0, marca, borracha) as marca_borracha,r.medida,
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
									  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
								  <cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
								     and r.perc_consumido >= #arguments.perc_consumido#
								  </cfif>
									 group by eixo, decode(r.reformas, 0,  marca, borracha), r.medida
									 order by eixo,  decode(r.reformas, 0,marca, borracha)
								 )) a,
					(select max(round(decode(eixo,'2',peso_tracionado,1))) as max_peso
					  from (select eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha) as marca_borracha,r.medida,	
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
							  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
									 group by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha), r.medida
									 order by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha)
								 )) b
				where a.mm_consumido > 50
				  order by ordem 
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico parcial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico_parcial" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="considera_peso" required="no">
		<cfargument name="mm_ate" required="yes">
		<cfargument name="perc_consumido" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
		  <cfif IsDefined("arguments.reformas") and ((ListLen(arguments.reformas) gte 1 and ListFind(arguments.reformas,'0')) or not Len(Trim(arguments.reformas)))>
				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = '1' then 1
							  when eixo = '2' then 2
							  when eixo = '3' then 3
							  when eixo = 'SR1' then 4
							  when eixo = 'SR2' then 5 
							  when eixo = 'SR3' then 6
						   end ordem,
						   case 
							  when eixo = '1' then 'eixo Dianteiro'
							  when eixo = '2' then 'eixo Tracao'
							  when eixo = '3' then 'eixo Truck'
							  when eixo = 'SR1' then 'Primeiro eixo'
							  when eixo = 'SR2' then 'Segundo eixo'
							  when eixo = 'SR3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'2',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, marca_id, modelo_id, 
                                              medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, r.marca, r.modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where reformas = 0
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>                         
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50
			   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>
				   union 
			   </cfif>
			</cfif>
		   
		   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>

				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = '1' then 1
							  when eixo = '2' then 2
							  when eixo = '3' then 3
							  when eixo = 'SR1' then 4
							  when eixo = 'SR2' then 5 
							  when eixo = 'SR3' then 6
						   end ordem,
						   case 
							  when eixo = '1' then 'eixo Dianteiro'
							  when eixo = '2' then 'eixo Tracao'
							  when eixo = '3' then 'eixo Truck'
							  when eixo = 'SR1' then 'Primeiro eixo'
							  when eixo = 'SR2' then 'Segundo eixo'
							  when eixo = 'SR3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'2',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, 
								 			  borracha_id as marca_id, desenho_id as modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, 
											  r.borracha as marca, r.desenho as modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where 1=1
										<cfif Len(Trim(arguments.reformas))>
										  and reformas in (#arguments.reformas#)
										<cfelse>  
										  and reformas > 0
										</cfif>
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										   and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>   
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>										                      
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50				   
			  </cfif>
				  order by ordem, 1
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>
    
	<!--- 
	-- PROPSITO 
	-- Busca as inspees de veiculos
	-- NOTAS EXPLICATIVAS
	-- LOUIS 20/07/2007 SQL criada pelo GUTO
	--->
	<cffunction name="get_inspecoes_veiculo" returntype="query" access="remote">
	    <cfargument name="modalidade" required="no" default="">
	     <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select placa, cod_veiculo, classificacao, marca, modelo, num_inspecao, data_inspecao, round(sysdate - data_inspecao) as dias
  			  from (select vd.placa, vd.cod_veiculo, vd.classificacao, vd.marca, vd.modelo, 
               max(pi.num_inspecao) keep (dense_rank last order by pi.data_inspecao) num_inspecao,
               max(pi.data_inspecao) keep (dense_rank last order by pi.data_inspecao) data_inspecao
             from oper.v$veiculo_dados vd
       inner join oper.v$veiculo_frota_geral vfg
               on vd.placa = vfg.placa
        left join oper.v$pneu_inspecao pi
               on pi.placa = vfg.placa    
            where  1=1
			<cfif len(trim(arguments.modalidade))>
            	and vfg.empresa = #arguments.modalidade#
            <cfelse>
            	and vfg.empresa in (1,2)
            </cfif>
         group by vd.placa, vd.cod_veiculo, vd.classificacao, vd.marca, vd.modelo) 
         
        </cfquery>
        <cfreturn qr_result>
     </cffunction>   

	<!--- 
	-- PROPSITO 
	-- Busca as ocorrencias do pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 07/02/2006
	--->
	<cffunction name="get_ocorrencias" returntype="query" access="remote">
		<cfargument name="num_pneu" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="data_inicial" required="no">
		<cfargument name="data_final" required="no">
		<cfargument name="operacao" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfargument name="num_ocorrencia" required="no" default="">		
		<cfquery datasource="#session.dsn#" name="qr_ocorrencias" username="#session.usuario#" password="#session.senha#">
			select /*+ first_rows_1000 */ pd.pneu_id, pd.num_pneu, pd.situacao_id, pd.data_aquisicao, pd.marca_id, pd.marca, 
				   pd.modelo_id, pd.modelo, pd.sulco, pd.medida_id, pd.medida, pd.medida_roda_id, pd.medida_roda, 
				   pd.reformas, pd.situacao, pd.formato_borracha, p.operacao, p.usuario, to_char(p.data_ocorrencia,'dd/mm/yyyy hh24:mi') as data_ocorrencia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_ocorrencia p
				on p.pneu_id = pd.pneu_id
			 where 1 = 1 
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu)) and arguments.num_pneu neq -1> 
			  and pd.num_pneu = #arguments.num_pneu#
			 </cfif>
			 <cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id)) and arguments.pneu_id neq -1> 
			  and pd.pneu_id = #arguments.pneu_id#
			 </cfif>
			 <cfif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial)) and IsDefined("arguments.data_final") and Len(Trim(arguments.data_final))>
			  and trunc(p.data_ocorrencia) between '#arguments.data_inicial#' and '#arguments.data_final#'
			 <cfelseif IsDefined("arguments.data_inicial") and Len(Trim(arguments.data_inicial))>
			  and trunc(p.data_ocorrencia) >= '#arguments.data_inicial#'
			 </cfif>
			 <cfif len(trim(arguments.operacao))>			 	
			  and ( 1=0 
				  <cfloop list="#arguments.operacao#" index="v_item" delimiters=",">
				  or upper(p.operacao) like upper('%#v_item#%')
				  </cfloop>
				  )
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			 	and p.usuario in (''
				<cfloop list="#arguments.usuario#" delimiters="," index="v_item">
					, '#v_item#'
				</cfloop>
				)
			 </cfif>
			 order by p.pneu_id, p.data_ocorrencia   
		</cfquery>
		<cfreturn qr_ocorrencias>
	</cffunction>			

<!---  
-- PROPSITO  
-- Busca os tipos basicos de ocorrencia 
-- NOTAS EXPLICATIVAS 
-- CRISTOFER 07/02/2006 
---> 
<cffunction name="get_tipo_ocorrencia" returntype="query" access="remote"> 
    <cfquery name="qr" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#"> 
            select 01 as id, 'Pneu montado' as descricao from dual union 
            select 02 as id, 'Pneu desmontado' as descricao from dual union 
            select 03 as id, 'Alterado o sulco do pneu' as descricao from dual union 
            select 04 as id, 'Transf&ecirc;rencia aberta' as descricao from dual union 
            select 05 as id, 'Transf&ecirc;rencia confirmada' as descricao from dual union 
            select 06 as id, 'Transf&ecirc;rencia recusada' as descricao from dual union 
            select 07 as id, 'Inserido no sistema' as descricao from dual union 
            select 08 as id, 'Gerada inspe&ccedil;&atilde;o' as descricao from dual union 
            select 09 as id, 'Inspe&ccedil;&atilde;o conclu&iacute;da' as descricao from dual union 
            select 10 as id, 'Inspe&ccedil;&atilde;o cancelada' as descricao from dual union 
            select 11 as id, 'Pneu enviado para reforma' as descricao from dual union 
            select 12 as id, 'Reforma bloqueada' as descricao from dual union 
            select 13 as id, 'Retorno do pneu para estoque' as descricao from dual union 
            select 14 as id, 'Aberta an&aacute;lise para sucateamento' as descricao from dual union 
            select 15 as id, 'Montagem do pneu excluida' as descricao from dual union 
            select 16 as id, 'Envio para reforma cancelado' as descricao from dual union 
            select 17 as id, 'Alterada a situa&ccedil;&atilde;o do pneu' as descricao from dual union 
            select 18 as id, 'Confirmado o sucateamento' as descricao from dual union 
            select 19 as id, 'Pneu vendido' as descricao from dual  
    </cfquery>  
	<cfreturn qr> 
</cffunction> 
    
    <!--- 
	-- PROPSITO 
	-- Busca as Reformadores para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_reformadores" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrReformadores" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 0
							  else cod_pessoa_reformador end cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
										  where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																			from oper.v$pneu_reforma pr2
																		   where pr2.pneu_id = pr.pneu_id
																			 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador
			group by cod_pessoa_reformador, cliente
		</cfquery>
		<cfreturn qrReformadores>
	</cffunction>    
    
    <!--- 
	-- PROPSITO 
	-- Busca todas os reformadores de pneu para a montagem do relatorio de reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_reformador" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
                    where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                  																		from oper.v$pneu_reforma pr2
                  																	   where pr2.pneu_id = pr.pneu_id
                  																		 and pr2.conserto = 0)) as total      
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id		
								where  p.situacao_id in (1,2,3,4,5,6,8,9,10)   	   
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																 and pr2.conserto = 0)
                
							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador              
			group by cod_pessoa_reformador, cliente
		  order by 3 desc
		</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>
</cfcomponent>