<cfcomponent extends="_transportes.manipulacao.cfc_pneus">    
    <!--- 
	-- PROPSITO
	-- Retorna um pneu da analise de garantia
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="retorno_garantia" returntype="struct" access="remote">
		<cfargument name="num_pneu" required="yes">
		<cfargument name="pneu_id" required="yes">
		<cfargument name="cod_pessoa_fornecedor" required="yes">
		<cfargument name="data_envio_analise" required="yes">
		<cfargument name="valor" required="yes">
		<cfargument name="sucata" required="no" default="0">
		<cfargument name="reforma" required="no" default="0">
		<cfargument name="observacao" required="no">
		<cfargument name="laudo_id" required="no">
		<cfargument name="cod_pessoa_mot_resp" required="no" default="">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="desenho_id" required="no" default="">
		<cfargument name="num_nota_id" required="no" default="">
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_pneu.prc_retorno_analise_garantia" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" dbvarname="p_pneu_id" cfsqltype="cf_sql_integer" value="#arguments.pneu_id#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_fornecedor" cfsqltype="cf_sql_integer" value="#arguments.COD_PESSOA_FORNECEDOR#">
				<cfprocparam type="in" dbvarname="p_data_envio_analise" cfsqltype="cf_sql_varchar" value="#DateFormat(arguments.DATA_ENVIO_ANALISE,'dd/mm/yyyy')# #TimeFormat(arguments.DATA_ENVIO_ANALISE,'HH:MM:SS')#">
				<cfprocparam type="in" dbvarname="p_valor" cfsqltype="cf_sql_float" value="#arguments.VALOR#" null="#iif(len(trim(arguments.valor)), de('no'), de('yes'))#">
				<cfprocparam type="in" dbvarname="p_sucata" cfsqltype="cf_sql_integer" value="#arguments.SUCATA#">
				<cfprocparam type="in" dbvarname="p_reforma" cfsqltype="cf_sql_integer" value="#arguments.REFORMA#">
				<cfprocparam type="in" dbvarname="p_observacao" cfsqltype="cf_sql_varchar" value="#arguments.OBSERVACAO#">
				<cfprocparam type="in" dbvarname="p_laudo_id" cfsqltype="cf_sql_varchar" value="#arguments.LAUDO_ID#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_tecnico_analise" cfsqltype="cf_sql_integer" value="#session.cod_pessoa_usuario#">
				<cfprocparam type="in" dbvarname="p_cod_pessoa_mot_resp" cfsqltype="cf_sql_integer" value="#arguments.cod_pessoa_mot_resp#"  null="#iif(isdefined("arguments.cod_pessoa_mot_resp") and len(trim(arguments.cod_pessoa_mot_resp)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_borracha_id" cfsqltype="cf_sql_integer" value="#arguments.borracha_id#"  null="#iif(isdefined("arguments.borracha_id") and len(trim(arguments.borracha_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_desenho_id" cfsqltype="cf_sql_integer" value="#arguments.desenho_id#" null="#iif(isdefined("arguments.desenho_id") and len(trim(arguments.desenho_id)),de("no"),de("yes"))#">
				<cfprocparam type="in" dbvarname="p_num_nota_id" cfsqltype="cf_sql_integer" value="#arguments.num_nota_id#" null="#iif(isdefined("arguments.num_nota_id") and len(trim(arguments.num_nota_id)),de("no"),de("yes"))#">
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = "Pneu num. " & #arguments.num_pneu# & " teve sua anlise de garantia avaliada com sucesso.">
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
		</cftry>
		<cfreturn retorno>	
	</cffunction>
</cfcomponent>