<cffunction access="private" name="fnc_confirma_pneus" returntype="struct">
	<cftransaction action="begin">
	<cfloop list="#arguments.pneu_id_lista#" index="id">
		<cfscript>
			conn = CreateComponent("verdescampos._componentes.manipulacao.cfc_pneus");	
			ret = conn.confirma_conserto_pneu(	pneu_id = id,
												num_documento = arguments.num_nota_fiscal,
												data = arguments.data,
												valor = arguments.valor,
												num_nota_fiscal = arguments.num_nota_fiscal,
												tipo_conserto_id = arguments.tipo_conserto_id,
												complemento = arguments.complemento,
												cod_pessoa_reformador = arguments.cod_pessoa_reformador,
												num_recibo_viagem = arguments.num_recibo_viagem
												);
		</cfscript>
		<cfif ret.erro>
			<cftransaction action="rollback">
			<cfreturn ret>
		</cfif>
	</cfloop>	
	</cftransaction>
	<cfreturn ret>
</cffunction>


<cffunction access="private" name="fnc_envia_pneus" returntype="struct">
	<cftransaction action="begin">
	<cfloop list="#arguments.pneu_id_lista#" index="id">
		<cfscript>
			conn = CreateComponent("_transportes.manipulacao.cfc_pneus");	
			ret = conn.envia_pneu_conserto(	pneu_id = id,
												data = arguments.data,
												cod_pessoa_reformador = arguments.cod_pessoa_reformador
												
												);
		</cfscript>
		<cfif ret.erro>
			<cftransaction action="rollback">
			<cfreturn ret>
		</cfif>
	</cfloop>	
	</cftransaction>
	<cfreturn ret>
</cffunction>

<cfscript>
if( IsDefined("vars.OPERACAO") and Len( Trim( vars.OPERACAO ) ) ) {
	conn = CreateComponent("_transportes.manipulacao.cfc_pneus");
	switch ( val( vars.operacao ) ) 
	{   	 
		case 1 : 
			set_manipulacao = fnc_confirma_pneus(argumentCollection = vars); 
			break;
		case 2 : 
			set_manipulacao = fnc_envia_pneus(argumentCollection = vars); 
			break;
		case 3 : 
			set_manipulacao = conn.confirma_retorno_conserto(argumentCollection = vars); 
			break;
		case 4 : 
			set_manipulacao = conn.cancela_envio_reforma(argumentCollection = vars); 
			break;
	}
	fnc_trata_erros(struct_erro = set_manipulacao);
}  
</cfscript>

<script language="javascript1.2">
	<cfif vars.operacao neq 4>
	parent.window.location = 'principal.cfm';
	<cfelse>
	parent.window.location.reload();	
	</cfif>
</script>