<cfcomponent>
    <cffunction name="redimensiona_imagem" returntype="string" output="true"> 
        <cfargument name="url" required="yes"> 
        <cfargument name="width" required="no" default=""> 
        <cfargument name="height" required="no" default=""> 
        <cfargument name="maxwidth" required="no" default=""> 
        <cfargument name="maxheight" required="no" default=""> 
        <cfargument name="watermark" required="no" default="0"> 
        <cfargument name="borda_arredondada_sombra" required="no" default="0">         
        <cftry> 
            <cfscript> 
                if(not len(trim(arguments.url))) { 
                    return arguments.url; 
                }  
                v_url = arguments.url; 
            </cfscript> 
            <cfscript>
			     v_extensao = 'jpg'; 
                 if (Len(Trim(arguments.maxheight)) or Len(Trim(arguments.maxwidth))) {
  					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_mh"&arguments.maxwidth&"_mv"&arguments.maxheight&"."&(v_extensao);
				 }		

				 if (arguments.watermark eq 1) {
  					v_url = ListDeleteAt(v_url,listlen(v_url,'.'),'.')&'_wm.'&(v_extensao);
				 }
				 if (arguments.borda_arredondada_sombra eq 1) {
  					v_url = ListDeleteAt(v_url,listlen(v_url,'.'),'.')&'_bas.'&(v_extensao);
				 }
            </cfscript> 
            <cfif not FileExists(ExpandPath(v_url))> 
              <cfimage action="info" structname="v_imagem" source="#Expandpath(arguments.url)#"> 
			   <cfscript> 
                  if (Len(Trim(arguments.maxwidth)) and Len(Trim(arguments.maxheight))
                      and ((v_imagem.width/(v_imagem.height/arguments.maxheight)) gt arguments.maxwidth )) { 
                      v_altura = v_imagem.height/(v_imagem.width/arguments.maxwidth); 
                      v_largura = arguments.maxwidth; 
                  } else if (Len(Trim(arguments.maxheight)) 
                             and ((v_imagem.height/(arguments.maxheight/v_imagem.height)) gt arguments.maxheight )) { 
                      v_altura = arguments.maxheight; 
                      v_largura = v_imagem.width/(v_imagem.height/arguments.maxheight); 
                  } else {
                          v_altura = v_imagem.height; 
                          v_largura = v_imagem.width; 
																		}
               </cfscript> 

              <cfimage action="resize" source="#Expandpath(arguments.url)#" name="v_imagem" height="#v_altura#" width="#v_largura#"> 
 
              <cfif arguments.watermark eq 1>
				 	<cfset objWatermark = ImageNew(#ExpandPath('/girassol/_imagens/uteis/marca_dagua.png')#) />              
                    <cfset ImageSetAntialiasing(v_imagem,"on") />
                    <cfset ImageSetDrawingTransparency(v_imagem,70) />
                    <cfset ImagePaste(v_imagem,
									  objWatermark,
									  (v_imagem.GetWidth() - objWatermark.GetWidth()),
									  (v_imagem.GetHeight() - objWatermark.GetHeight())
									  ) />

              </cfif>

              <cfif arguments.borda_arredondada_sombra eq 1>
              	<cfscript>
					   connImg = CreateObject("component","girassol._componentes.manipulacao.cfc_imagem");    
				   	   
//					   v_imagem = connImg.ImageShadow(#v_imagem#,1,3,"##fffce3","##CCCCCC");
					   v_imagem = connImg.ImageRounded(#v_imagem#,15,"##fffce3");
//					   v_imagem = connImg.ImageShadow(connImg.ImageRounded(#v_imagem#,15,'##fffce3'),3,3,'##fffce3','##fffce3');
				</cfscript>
              </cfif>

	          <cfimage action="write" source="#v_imagem#" destination="#Expandpath(v_url)#" quality="0.9" overwrite="yes" > 

            </cfif> 

            <cfreturn v_url> 
            <cfcatch> 
                <cfreturn 'ERRO - #cfcatch.Message# - #url#'>
            </cfcatch> 
        </cftry>  
    </cffunction> 

	<cffunction name="redimensiona_imagem_java" returntype="string" output="true">
		<cfargument name="url" required="yes">
		<cfargument name="width" required="no" default="">
		<cfargument name="height" required="no" default="">
		<cfargument name="maxwidth" required="no" default="">
		<cfargument name="maxheight" required="no" default="">
		<cftry>
			<cfscript>
			  // http://www.dcmais.com.br/diariodoscampos/_componentes/consulta/cfc_imagem.cfc?method=redimensiona_imagem_cfm&url=/diariodoscampos/upload/fotos/foto10499.jpg&maxwidth=600&maxheight=438
				if(not len(trim(arguments.url))) {
					return arguments.url;
				}
				v_url = arguments.url;
				conn = CreateObject("component", "_transportes.funcoes.cfc_image_utils");
				// Alterao foi feita pois o componente somente salva arquivos no formato JPG
				v_extensao = 'jpg';//ListLast(arguments.url,'.');
				if (len(trim(arguments.width))) {
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_h"&arguments.width&"."&(v_extensao);
					if(not FileExists(Expandpath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						conn.setWidth(JavaCast("int",arguments.width));
						conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));	
					}
				} else if(len(trim(arguments.height))) {
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_v"&arguments.height&"."&(v_extensao);
					if(not FileExists(Expandpath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						conn.setHeight(JavaCast('int',arguments.height));
						conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));	
					}
	
				} else if (len(trim(arguments.maxwidth)) or len(trim(arguments.maxheight)))	{
					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_mh"&arguments.maxwidth&"_mv"&arguments.maxheight&"."&(v_extensao);
					if (not fileexists(ExpandPath(v_url))) {
						conn.load(filename = Expandpath(arguments.url));
						v_width = conn.getWidth();
						v_height = conn.getHeight();
						if (len(trim(arguments.maxwidth))) {
							if(v_width gt arguments.maxwidth or v_height gt arguments.maxheight) {
								v_reducao = arguments.maxwidth/v_width;
								if(len(trim(arguments.maxheight)) and  (v_height*v_reducao gt arguments.maxheight)) {
									//Reduz na vertical
									conn.setHeight(JavaCast('int',arguments.maxheight));
								} else {
									conn.setWidth(JavaCast('int',arguments.maxwidth));
								}
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							} else {
								conn.setHeight(v_height);
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							}
						} else if (len(trim(arguments.maxheight))) {
							if(v_height gt arguments.maxheight) {
								//Reduz na vertical
								conn.setHeight(JavaCast('int',arguments.maxheight));
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							} else {
								conn.setHeight(v_height);
								conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
							}
						} else {
							conn.setHeight(v_height);
							conn.writeResult(filename = Expandpath(v_url), type = lcase(iif(lcase(v_extensao) eq 'jpg',de('jpeg'),de(v_extensao))));
						}
					}
				
				} else {
					v_url = arguments.url;
				}
				if(ListFind("www.dcmais.com.br,sincronizador.kmm.com.br",cgi.HTTP_HOST)) {
					if(not isdefined("session.imgdomaincounter")) {
						session.imgdomaincounter = 0;
					}
					session.imgdomaincounter = session.imgdomaincounter + 1;
					if(session.imgdomaincounter gt 4) {
						session.imgdomaincounter = 1;
					}
					v_url = "http://img"&session.imgdomaincounter&".dcmais.com.br"&v_url;
				}
				return v_url;
			</cfscript>
			<cfcatch>
				<cfreturn arguments.url>
			</cfcatch>
		</cftry>
	</cffunction>

    <cffunction name="redimensiona_imagem_cfm" returntype="string" output="true" access="remote"> 
        <cfargument name="url" required="yes"> 
        <cfargument name="width" required="no" default=""> 
        <cfargument name="height" required="no" default=""> 
        <cfargument name="maxwidth" required="no" default=""> 
        <cfargument name="maxheight" required="no" default=""> 
        <cfargument name="qualidade" required="no" default="0.9"> 
        <cftry> 
            <cfscript> 
                if(not len(trim(arguments.url))) { 
                    return arguments.url; 
                }  
                v_url = arguments.url; 
            </cfscript> 
            <cfscript>
												     v_extensao = 'jpg'; 
                 if (Len(Trim(arguments.maxheight)) or Len(Trim(arguments.maxwidth))) {
                					v_url = ListDeleteAt(arguments.url,listlen(arguments.url,'.'),'.')&"_mh"&arguments.maxwidth&"_mv"&arguments.maxheight&"."&lcase(v_extensao);																	
																		}		
            </cfscript> 
            <cfif not FileExists(ExpandPath(v_url))> 
              <cfimage action="info" structname="v_imagem" source="#Expandpath(arguments.url)#"> 
														<cfscript> 
                  if (v_imagem.width gt v_imagem.height) {
																		   v_tipo_foto = 1; // horizontal
																		} else { v_tipo_foto = 2; // vertical
																		}
																		
																		if (v_tipo_foto eq 1) {
																		   // Horizontal
																					if (Len(Trim(arguments.maxwidth)) 
																									and ((v_imagem.width/(v_imagem.height/arguments.maxheight)) gt arguments.maxwidth )) { 
																									v_altura = v_imagem.height/(v_imagem.width/arguments.maxwidth); 
																									v_largura = arguments.maxwidth; 
																					} else if (Len(Trim(arguments.maxheight)) 
																																and ((v_imagem.height/(arguments.maxheight/v_imagem.height)) gt arguments.maxheight )) { 
																									v_altura = arguments.maxheight; 
																									v_largura = v_imagem.width/(v_imagem.height/arguments.maxheight); 
																					} else {
																													v_altura = v_imagem.height; 
																													v_largura = v_imagem.width; 
																					}
																		 } else {
																												// Veritical
																												if (Len(Trim(arguments.maxheight)) 
																																and ((v_imagem.height/(arguments.maxheight/v_imagem.height)) gt arguments.maxheight )) { 
																																v_altura = arguments.maxheight; 
																																v_largura = v_imagem.width/(v_imagem.height/arguments.maxheight); 
																												} else if (Len(Trim(arguments.maxwidth)) 
																																and ((v_imagem.width/(v_imagem.height/arguments.maxheight)) gt arguments.maxwidth )) { 
																																v_altura = v_imagem.height/(v_imagem.width/arguments.maxwidth); 
																																v_largura = arguments.maxwidth; 
																												} else {
																																				v_altura = v_imagem.height; 
																																				v_largura = v_imagem.width; 
																												}
																			}
              </cfscript> 
              <cfimage action="resize" source="#Expandpath(arguments.url)#" name="v_imagem" height="#v_altura#" width="#v_largura#"> 
              <cfimage action="write" source="#v_imagem#" destination="#Expandpath(v_url)#" quality="#arguments.qualidade#" overwrite="yes" > 
            </cfif> 
            <cfreturn v_url> 
            <cfcatch> 
               <cfreturn "">
            </cfcatch> 
        </cftry>  
    </cffunction> 
</cfcomponent>