<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $SiteManObj;
if(!$SiteManObj) {
	class SiteComMan extends QueryCom {
		/*
		 * Criado em Tue May 6 17:23:51 UTC-0300 2008
		 * Insere uma categoria de fotos
		 */
		function ins_foto_categoria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_ins_foto_categoria(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID_PAI	       =>  :P_CATEGORIA_ID_PAI,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID_PAI',$arguments['categoria_id_pai'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
		
		/*
		 * Criado em Tue May 6 17:23:51 UTC-0300 2008
		 * Insere uma categoria de fotos
		 */
		function ins_arquivo_categoria_path($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_arquivo.prc_ins_arquivo_categoria_path(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_PATH	       =>  :P_PATH,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PATH',$arguments['path'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
		
		/*
		 * Criado em Tue May 6 17:24:45 UTC-0300 2008
		 * Altera uma categoria de fotos
		 */
		function upd_foto_categoria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_alt_foto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
			
		/*
		 * Criado em Tue May 6 17:25:34 UTC-0300 2008
		 * Exclui uma categoria de fotos
		 */
		function del_foto_categoria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_del_foto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Thu May 8 20:21:00 UTC-0300 2008
		 * Insere uma foto
		 */
		function ins_foto($arguments=array()) {

			$timer = new BC_Timer;
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			// Move o arquivo de um diretorio temporario se necessario
			if($arguments['temporario'] == 1) {
				/*$connImg = CreateObject("_class.funcoes.imagem");
				$arquivo_destino = $connImg->upload_arquivo(array(
												source		=> $_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],
												destination	=> $_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/foto.jpg',
												"filetype"	=> 'image',
												quality		=> 100,
												));
				$arguments['url_imagem'] = str_replace($_SERVER['DOCUMENT_ROOT'],'',$arquivo_destino);*/
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'],0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_foto".$count.".".$extensao)) {
					$count++;
				}
			//print("ins_foto1.1: ".$timer->get_elapsed_time()."<br>");
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_foto".$count.".".$extensao);
/*				
					$source = imagecreatefromstring(file_get_contents($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']));
			print("ins_foto1.2: ".$timer->get_elapsed_time()."<br>");
					list($width, $height) = getimagesize($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']);
			print("ins_foto1.3: ".$timer->get_elapsed_time()."<br>");
					$thumb = imagecreatetruecolor($width, $height);
			print("ins_foto1.4: ".$timer->get_elapsed_time()."<br>");
					imagecopyresampled($thumb, $source, 0, 0, 0, 0, $width, $height, $width, $height);
			print("ins_foto1.5: ".$timer->get_elapsed_time()."<br>");
					imagejpeg($thumb, $_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_foto".$count.".".$extensao, 100);
			print("ins_foto1.6: ".$timer->get_elapsed_time()."<br>");
*/
				
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',$arguments['fotos_url'].'/'.$extensao."_foto".$count.".".$extensao));
			}
			
			if($arguments['formato_id'] == 1) {
				list($arguments['largura'],$arguments['altura']) = @getimagesize($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']);
			} else {
				$arguments['largura'] = 0;
				$arguments['altura'] = 0;
			}
			
			$arguments['largura'] = strlen(trim($arguments['largura']))?$arguments['largura']:0;
			$arguments['altura'] = strlen(trim($arguments['altura']))?$arguments['altura']:0;
			
			$sql  = 'BEGIN';
			$sql .= '	:P_CONTEUDO := empty_blob(); ';
			$sql .= '	site.pkg_foto.prc_ins_foto(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_CONTEUDO			=> :P_CONTEUDO,';
			$sql .= '					   P_MD5			=> :P_MD5,';
			$sql .= '					   P_TRANSPARENTE			=> :P_TRANSPARENTE,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= ' UPDATE site.v$foto set conteudo = empty_blob() where foto_id = :P_FOTO_ID returning conteudo into :P_CONTEUDO; ';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);

			$blob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_CONTEUDO',$blob,-1,OCI_B_BLOB);

			oci_bind_by_name($stmt,':P_MD5',$arguments['md5'],4000);
			oci_bind_by_name($stmt,':P_TRANSPARENTE',$arguments['transparente'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			
			$arguments['md5'] = md5_file($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			
			$blob->saveFile($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']);
			
			
			
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Thu May 8 20:21:00 UTC-0300 2008
		 * Insere uma foto
		 */
		function ins_arquivo($arguments=array()) {
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if($arguments['formato_id'] == 1) {
				list($arguments['largura'],$arguments['altura']) = getimagesize($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
			} else {
				$arguments['largura'] = 0;
				$arguments['altura'] = 0;
			}
			if(!strlen(trim($arguments['extensao']))) {
				$parts = array_reverse(explode(".",$arguments['url_temporario']));
				$arguments['extensao'] = $parts[0];
			}
			
			$arguments['largura'] = strlen(trim($arguments['largura']))?$arguments['largura']:0;
			$arguments['altura'] = strlen(trim($arguments['altura']))?$arguments['altura']:0;
			
			$sql  = 'BEGIN';
			$sql .= '	:P_CONTEUDO := empty_blob(); ';
			$sql .= '	site.pkg_arquivo.prc_ins_arquivo(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_CONTEUDO			=> :P_CONTEUDO,';
			$sql .= '					   P_MD5			=> :P_MD5,';
			$sql .= '					   P_TRANSPARENTE			=> :P_TRANSPARENTE,';
			$sql .= '					   P_FORMATO_ID			=> :P_FORMATO_ID,';
			$sql .= '					   P_EXTENSAO			=> :P_EXTENSAO,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID);';
			$sql .= ' UPDATE site.v$foto set conteudo = empty_blob() where foto_id = :P_ARQUIVO_ID returning conteudo into :P_CONTEUDO; ';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_temporario'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);

			$blob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_CONTEUDO',$blob,-1,OCI_B_BLOB);

			oci_bind_by_name($stmt,':P_MD5',$arguments['md5'],4000);
			oci_bind_by_name($stmt,':P_TRANSPARENTE',$arguments['transparente'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_EXTENSAO',$arguments['extensao'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
			
			$arguments['md5'] = md5_file($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
		
			$sucesso = (oci_execute($stmt,OCI_DEFAULT));
			
			$blob->saveFile($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
			
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 8 20:22:05 UTC-0300 2008
		 * Altera uma foto
		 */
		function upd_arquivo($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if(strlen(trim($arguments['url_imagem'])))
				$arguments['url_temporario'] = $arguments['url_imagem'];
			
			if(strlen(trim($arguments['url_temporario']))) {
				if($arguments['formato_id'] == 1) {
					list($arguments['largura'],$arguments['altura']) = getimagesize($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
				} else {
					$arguments['largura'] = 0;
					$arguments['altura'] = 0;
				}
				if(!strlen(trim($arguments['extensao']))) {
					$parts = array_reverse(explode(".",$arguments['url_temporario']));
					$arguments['extensao'] = $parts[0];
				}
				
				$arguments['largura'] = strlen(trim($arguments['largura']))?$arguments['largura']:0;
			    $arguments['altura'] = strlen(trim($arguments['altura']))?$arguments['altura']:0;
			
			
				$sql  = 'BEGIN';
				$sql .= '   select conteudo into :P_CONTEUDO from site.v$arquivo where arquivo_id = :P_ARQUIVO_ID; ';
				$sql .= '	site.pkg_arquivo.prc_alt_arquivo(P_ARQUIVO_ID   =>  :P_ARQUIVO_ID,';
				$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
				$sql .= '					   P_TITULO	       =>  :P_TITULO,';
				$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
				$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
				$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
				$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
				$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
				$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
				$sql .= '					   P_TIPO	       =>  :P_TIPO,';
				$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
				$sql .= '					   P_CONTEUDO			=> :P_CONTEUDO,';
				$sql .= '					   P_MD5			=> :P_MD5,';
				$sql .= '					   P_TRANSPARENTE			=> :P_TRANSPARENTE,';
				$sql .= '					   P_FORMATO_ID			=> :P_FORMATO_ID,';
				$sql .= '					   P_EXTENSAO			=> :P_EXTENSAO);';
				$sql .= ' UPDATE site.v$arquivo set conteudo = :P_CONTEUDO where arquivo_id = :P_ARQUIVO_ID returning conteudo into :P_CONTEUDO; ';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
				oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
				oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
				oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
				oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
				oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
				oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
				oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
				oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
				oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
				oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);
				oci_bind_by_name($stmt,':P_MD5',$arguments['md5'],4000);
				oci_bind_by_name($stmt,':P_TRANSPARENTE',$arguments['transparente'],4000);
				oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
				oci_bind_by_name($stmt,':P_EXTENSAO',$arguments['extensao'],4000);
				
				// Calcula o MD5 para o arquivo
				$arguments['md5'] = md5_file($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
				
				// Salva a imagem no campo BLOB
				$blob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_CONTEUDO',$blob,-1,OCI_B_BLOB);
			} else {
				$sql  = 'BEGIN';
				$sql .= '	site.pkg_arquivo.prc_alt_arquivo(P_ARQUIVO_ID   =>  :P_ARQUIVO_ID,';
				$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
				$sql .= '					   P_TITULO	       =>  :P_TITULO,';
				$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
				$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
				$sql .= '					   P_CREDITO	       =>  :P_CREDITO);';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
				oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
				oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
				oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
				oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
				oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			}
		
			$sucesso = (oci_execute($stmt,OCI_DEFAULT));
			if(strlen(trim($arguments['url_temporario']))) {
				$blob->saveFile($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
				$_VARS['foto_id'] = $arguments['arquivo_id'];
				include($_SERVER['DOCUMENT_ROOT'].'/portal/publico/limpar_cache_foto.php');
			}
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Thu May 8 20:22:05 UTC-0300 2008
		 * Altera uma foto
		 */
		function upd_foto($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$arguments['url_temporario'] = $arguments['url_imagem'];

			if(!strlen(trim($arguments['url_temporario']))) {
				$conn = CreateObject("portal._class.consulta.site");
				$qrFoto = $conn->get_foto(array(
											foto_id => $arguments['foto_id'],
										));
			}
			
			if($arguments['formato_id'] == 1) {
				list($arguments['largura'],$arguments['altura']) = @getimagesize($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem']);
			} else { 	 	
				$arguments['largura'] = 0;
				$arguments['altura'] = 0;
			}
			
			$arguments['largura'] = strlen(trim($arguments['largura']))?$arguments['largura']:0;
			$arguments['altura'] = strlen(trim($arguments['altura']))?$arguments['altura']:0;
				
			$sql  = 'BEGIN';
			$sql .= '   :P_CONTEUDO := empty_blob(); ';
			$sql .= '	site.pkg_foto.prc_alt_foto(P_FOTO_ID   =>  :P_FOTO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_CONTEUDO			=> :P_CONTEUDO,';
			$sql .= '					   P_MD5			=> :P_MD5,';
			$sql .= '					   P_TRANSPARENTE			=> :P_TRANSPARENTE);';
			$sql .= ' UPDATE site.v$foto set conteudo = empty_blob() where foto_id = :P_FOTO_ID returning conteudo into :P_CONTEUDO; ';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);
			oci_bind_by_name($stmt,':P_MD5',$arguments['md5'],4000);
			oci_bind_by_name($stmt,':P_TRANSPARENTE',$arguments['transparente'],4000);
			
			// Calcula o MD5 para o arquivo
			$arguments['md5'] = md5_file($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
			
			// Salva a imagem no campo BLOB
			$blob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_CONTEUDO',$blob,-1,OCI_B_BLOB);
		
			$sucesso = (oci_execute($stmt,OCI_DEFAULT));
			$blob->saveFile($_SERVER['DOCUMENT_ROOT'].$arguments['url_temporario']);
			
			
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 8 20:22:05 UTC-0300 2008
		 * Altera uma foto
		 */
		function upd_foto_conteudo($arguments=array()){
			$sql  = 'BEGIN';
			$sql .= '	update site.v$foto ';
			$sql .= '	   set conteudo = :p_conteudo ';
			$sql .= '	 where foto_id = :p_foto_id; ';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_BLOB);
			$clob->writeTemporary($arguments['texto']);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 2 13:46:19 UTC-0200 2008
		 * Exclu uma foto do Banco de Imagens
		 */
		function del_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_del_foto(P_FOTO_ID   =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Oct 2 13:46:19 UTC-0200 2008
		 * Exclu uma foto do Banco de Imagens
		 */
		function del_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_arquivo.prc_del_arquivo(P_ARQUIVO_ID   =>  :P_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo excludo com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Fri May 23 14:51:37 UTC-0300 2008
		 * Insere um video
		 */
		function ins_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_video.prc_ins_video(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_COD_VIDEO	       =>  :P_COD_VIDEO,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_COD_VIDEO',$arguments['cod_video'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		/*
		 * Criado em Fri May 23 14:52:55 UTC-0300 2008
		 * Altera um video
		 */
		function upd_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_video.prc_alt_video(P_VIDEO_ID   =>  :P_VIDEO_ID,';
			$sql .= '					   P_COD_VIDEO	       =>  :P_COD_VIDEO,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_COD_VIDEO',$arguments['cod_video'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 23 14:53:30 UTC-0300 2008
		 * Exclui um video
		 */
		function del_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_video.prc_del_video(P_VIDEO_ID   =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Feb 11 17:59:26 UTC-0200 2009
		 * Retorna o espao disponvel do portal
		 */
		function valida_espaco_portal($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_arquivo.prc_valida_espaco_portal(P_COD_PORTAL   =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Espao retornado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}


		/*
		 * Criado em Tue May 6 17:23:51 UTC-0300 2008
		 * Insere uma categoria de fotos
		 */
		function ins_layout_objeto_acesso($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
//			$sql  = 'BEGIN';
			$sql = '	insert into site.layout_objeto_acesso (layout_objeto_id) values (:P_LAYOUT_OBJETO_ID) returning acesso_id into :P_ACESSO_ID';
//			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LAYOUT_OBJETO_ID',$arguments['layout_objeto_id'],4000);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	

		/*
		 * Criado em Tue May 6 17:23:51 UTC-0300 2008
		 * Insere uma categoria de fotos
		 */
		function upd_layout_objeto_acesso($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
//			$sql  = 'BEGIN';
			$sql = '	update site.layout_objeto_acesso set data_termino = sysdate where acesso_id = :P_ACESSO_ID';
//			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	

	}
	global $conexao_banco;
	$SiteManObj = new SiteComMan($conexao_banco);
}

global $createdObject;
$createdObject = $SiteManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>