<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");


global $RHObj;
if(!$RHObj) {
	class RHMan extends QueryCom {
	
		/*
		 * Criado em Fri Jun 12 17:04:56 UTC-0300 2009
		 * Insere um currculo
		 */
		function ins_curriculo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				
				if(strlen(trim($arguments['url_foto']))){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			   path => '/RH/Curriculos/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria'] = $ret['categoria_id'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],
										url_imagem		=> $arguments['url_foto'],
										categoria_id	=> $arguments['categoria'],
										titulo		    => $arguments['nome'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['foto_id'] = $ret['foto_id'];
				}
										  
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_curriculo(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_RUA	       =>  :P_RUA,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CIDADE	       =>  :P_CIDADE,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_ESTADO_CIVIL	       =>  :P_ESTADO_CIVIL,';
			$sql .= '					   P_DATA_NASCIMENTO	       =>  :P_DATA_NASCIMENTO,';
			$sql .= '					   P_CIDADE_ORIGEM	       =>  :P_CIDADE_ORIGEM,';
			$sql .= '					   P_CIDADE_RESIDENCIA	       =>  :P_CIDADE_RESIDENCIA,';
			$sql .= '					   P_TEMPO_RESIDENCIA	       =>  :P_TEMPO_RESIDENCIA,';
			$sql .= '					   P_NOME_PAI	       =>  :P_NOME_PAI,';
			$sql .= '					   P_NOME_MAE	       =>  :P_NOME_MAE,';
			$sql .= '					   P_DEPENDENTES	       =>  :P_DEPENDENTES,';
			$sql .= '					   P_CONJUGE_NOME	       =>  :P_CONJUGE_NOME,';
			$sql .= '					   P_TRABALHA	       =>  :P_TRABALHA,';
			$sql .= '					   P_LOCAL_TRABALHO	       =>  :P_LOCAL_TRABALHO,';
			$sql .= '					   P_TEMPO	       =>  :P_TEMPO,';
			$sql .= '					   P_FUMANTE	       =>  :P_FUMANTE,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_SEXO	       =>  :P_SEXO,';
			$sql .= '					   P_CARGO_PRETENDIDO	       =>  :P_CARGO_PRETENDIDO,';
			$sql .= '					   P_PRETENSAO_SALARIAL	       =>  :P_PRETENSAO_SALARIAL,';
			$sql .= '					   P_RELACOES_EMPRESA	       =>  :P_RELACOES_EMPRESA,';
			$sql .= '					   P_NOME_RELACIONADO	       =>  :P_NOME_RELACIONADO,';
			$sql .= '					   P_CARGO_OCUPADO	       =>  :P_CARGO_OCUPADO,';
			$sql .= '					   P_ENSINO	       =>  :P_ENSINO,';
			$sql .= '					   P_PRIMEIRO_GRAU      =>  :P_PRIMEIRO_GRAU,';
			$sql .= '					   P_SEGUNDO_GRAU	       =>  :P_SEGUNDO_GRAU,';
			$sql .= '					   P_TECNICO	       =>  :P_TECNICO,';
			$sql .= '					   P_SUPERIOR	       =>  :P_SUPERIOR,';
			$sql .= '					   P_WINDOWS	       =>  :P_WINDOWS,';
			$sql .= '					   P_WORD	       =>  :P_WORD,';
			$sql .= '					   P_EXCEL	       =>  :P_EXCEL,';
			$sql .= '					   P_OUTROS_CONHECIMENTOS	       =>  :P_OUTROS_CONHECIMENTOS,';
			$sql .= '					   P_PASSATEMPO	       =>  :P_PASSATEMPO,';
			$sql .= '					   P_CARTA	       =>  :P_CARTA,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DIRIGE	       =>  :P_DIRIGE,';
			$sql .= '					   P_CNH	       =>  :P_CNH,';
			$sql .= '					   P_NOME_REFERENCIA_1	       =>  :P_NOME_REFERENCIA_1,';
			$sql .= '					   P_NOME_REFERENCIA_2	       =>  :P_NOME_REFERENCIA_2,';
			$sql .= '					   P_TELEFONE_REFERENCIA_1	       =>  :P_TELEFONE_REFERENCIA_1,';
			$sql .= '					   P_TELEFONE_REFERENCIA_2	       =>  :P_TELEFONE_REFERENCIA_2,';
			$sql .= '					   P_TRABALHO_VOLUNTARIO	       =>  :P_TRABALHO_VOLUNTARIO,';
			$sql .= '					   P_NOME_TRABALHO_VOLUNTARIO	       =>  :P_NOME_TRABALHO_VOLUNTARIO,';
			$sql .= '					   P_ESCOLARIDADE	       =>  :P_ESCOLARIDADE,';
			$sql .= '					   P_CURRICULO_ID	       =>  :P_CURRICULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_RUA',$arguments['rua'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_ESTADO_CIVIL',$arguments['estado_civil'],4000);
			oci_bind_by_name($stmt,':P_DATA_NASCIMENTO',$arguments['data_nascimento'],4000);
			oci_bind_by_name($stmt,':P_CIDADE_ORIGEM',$arguments['cidade_origem'],4000);
			oci_bind_by_name($stmt,':P_CIDADE_RESIDENCIA',$arguments['cidade_residencia'],4000);
			oci_bind_by_name($stmt,':P_TEMPO_RESIDENCIA',$arguments['tempo_residencia'],4000);
			oci_bind_by_name($stmt,':P_NOME_PAI',$arguments['nome_pai'],4000);
			oci_bind_by_name($stmt,':P_NOME_MAE',$arguments['nome_mae'],4000);
			oci_bind_by_name($stmt,':P_DEPENDENTES',$arguments['dependentes'],4000);
			oci_bind_by_name($stmt,':P_CONJUGE_NOME',$arguments['conjuge_nome'],4000);
			oci_bind_by_name($stmt,':P_TRABALHA',$arguments['trabalha'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_TRABALHO',$arguments['local_trabalho'],4000);
			oci_bind_by_name($stmt,':P_TEMPO',$arguments['tempo'],4000);
			oci_bind_by_name($stmt,':P_FUMANTE',$arguments['fumante'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_SEXO',$arguments['sexo'],4000);
			oci_bind_by_name($stmt,':P_CARGO_PRETENDIDO',$arguments['cargo_pretendido'],4000);
			oci_bind_by_name($stmt,':P_PRETENSAO_SALARIAL',$arguments['pretensao_salarial'],4000);
			oci_bind_by_name($stmt,':P_RELACOES_EMPRESA',$arguments['relacoes_empresa'],4000);
			oci_bind_by_name($stmt,':P_NOME_RELACIONADO',$arguments['nome_relacionado'],4000);
			oci_bind_by_name($stmt,':P_CARGO_OCUPADO',$arguments['cargo_ocupado'],4000);
			oci_bind_by_name($stmt,':P_ENSINO',$arguments['ensino'],4000);
			oci_bind_by_name($stmt,':P_PRIMEIRO_GRAU',$arguments['primeiro_grau'],4000);
			oci_bind_by_name($stmt,':P_SEGUNDO_GRAU',$arguments['segundo_grau'],4000);
			oci_bind_by_name($stmt,':P_TECNICO',$arguments['tecnico'],4000);
			oci_bind_by_name($stmt,':P_SUPERIOR',$arguments['superior'],4000);
			oci_bind_by_name($stmt,':P_WINDOWS',$arguments['windows'],4000);
			oci_bind_by_name($stmt,':P_WORD',$arguments['word'],4000);
			oci_bind_by_name($stmt,':P_EXCEL',$arguments['excel'],4000);
			oci_bind_by_name($stmt,':P_OUTROS_CONHECIMENTOS',$arguments['outros_conhecimentos'],4000);
			oci_bind_by_name($stmt,':P_PASSATEMPO',$arguments['passatempo'],4000);
			oci_bind_by_name($stmt,':P_CARTA',$arguments['carta'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DIRIGE',$arguments['dirige'],4000);
			oci_bind_by_name($stmt,':P_CNH',$arguments['cnh'],4000);
			oci_bind_by_name($stmt,':P_NOME_REFERENCIA_1',$arguments['nome_referencia_1'],4000);
			oci_bind_by_name($stmt,':P_NOME_REFERENCIA_2',$arguments['nome_referencia_2'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE_REFERENCIA_1',$arguments['telefone_referencia_1'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE_REFERENCIA_2',$arguments['telefone_referencia_2'],4000);
			oci_bind_by_name($stmt,':P_TRABALHO_VOLUNTARIO',$arguments['trabalho_voluntario'],4000);
			oci_bind_by_name($stmt,':P_NOME_TRABALHO_VOLUNTARIO',$arguments['nome_trabalho_voluntario'],4000);
			oci_bind_by_name($stmt,':P_ESCOLARIDADE',$arguments['escolaridade'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$curso = listatoarray($arguments,'curso_nome_aperfeicoamento');
				$inst = listatoarray($arguments,'inst_aperfeicoamento');
				$duracao = listatoarray($arguments,'duracao_aperfeicoamento');
				$concluido = listatoarray($arguments,'concluido_aperfeicoamento');
				
				for($i=0; $i<count($curso); $i++){
					$ret = $this->ins_curriculo_curso(array(curso => $curso[$i],
															entidade => $inst[$i],
															duracao => $duracao[$i],
															concluido => $concluido[$i],
															curriculo_id => $arguments['curriculo_id'],
															no_commit => 1
														  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				$curriculo_emprego_id = listatoarray($arguments,'curriculo_emprego_id');
				$telefone = listatoarray($arguments,'emp_telefone');
				$empresa = listatoarray($arguments,'emp_empresa');
				$funcao = listatoarray($arguments,'emp_funcao');
				$superior = listatoarray($arguments,'emp_supimediato');
				$salario = listatoarray($arguments,'emp_ultsalario');
				$cargo_entrada = listatoarray($arguments,'emp_cargoentrada');
				$cargo_saida = listatoarray($arguments,'emp_cargosaida');
				$data_entrada = listatoarray($arguments,'emp_dataentrada');
				$data_saida = listatoarray($arguments,'emp_datasaida');
				$motivo_saida = listatoarray($arguments,'emp_motivosaida');
				$atividade = listatoarray($arguments,'emp_princativ');

				for($i=0; $i<count($curriculo_emprego_id); $i++){
					$ret = $this->ins_curriculo_emprego(array(curriculo_id => $arguments['curriculo_id'],
															  curriculo_emprego_id => $curriculo_emprego_id[$i],
															  telefone => $telefone[$i],
															  empresa => $empresa[$i],
															  funcao => $funcao[$i],
															  superior => $superior[$i],
															  salario => $salario[$i],
															  cargo_entrada => $cargo_entrada[$i],
															  cargo_saida => $cargo_entrada[$i],
															  data_entrada => $data_entrada[$i],
															  data_saida => $data_saida[$i],
															  motivo_saida => $motivo_saida[$i],
															  principais_atividades => $atividade[$i],
															  tipo => $i,
															  no_commit => 1
															));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Currculo cadastrado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 12 11:58:30 UTC-0300 2009
		 * Altera um currculo
		 */
		function upd_curriculo($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if(strlen(trim($arguments['url_foto']))){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			   path => '/RH/Curriculos/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria'] = $ret['categoria_id'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],
										url_imagem		=> $arguments['url_foto'],
										categoria_id	=> $arguments['categoria'],
										titulo		    => $arguments['nome'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['foto_id'] = $ret['foto_id'];
				}
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_curriculo(P_CURRICULO_ID   =>  :P_CURRICULO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_RUA	       =>  :P_RUA,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CIDADE	       =>  :P_CIDADE,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_ESTADO_CIVIL	       =>  :P_ESTADO_CIVIL,';
			$sql .= '					   P_DATA_NASCIMENTO	       =>  :P_DATA_NASCIMENTO,';
			$sql .= '					   P_CIDADE_ORIGEM	       =>  :P_CIDADE_ORIGEM,';
			$sql .= '					   P_CIDADE_RESIDENCIA	       =>  :P_CIDADE_RESIDENCIA,';
			$sql .= '					   P_TEMPO_RESIDENCIA	       =>  :P_TEMPO_RESIDENCIA,';
			$sql .= '					   P_NOME_PAI	       =>  :P_NOME_PAI,';
			$sql .= '					   P_NOME_MAE	       =>  :P_NOME_MAE,';
			$sql .= '					   P_DEPENDENTES	       =>  :P_DEPENDENTES,';
			$sql .= '					   P_CONJUGE_NOME	       =>  :P_CONJUGE_NOME,';
			$sql .= '					   P_TRABALHA	       =>  :P_TRABALHA,';
			$sql .= '					   P_LOCAL_TRABALHO	       =>  :P_LOCAL_TRABALHO,';
			$sql .= '					   P_TEMPO	       =>  :P_TEMPO,';
			$sql .= '					   P_FUMANTE	       =>  :P_FUMANTE,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_SEXO	       =>  :P_SEXO,';
			$sql .= '					   P_CARGO_PRETENDIDO	       =>  :P_CARGO_PRETENDIDO,';
			$sql .= '					   P_PRETENSAO_SALARIAL	       =>  :P_PRETENSAO_SALARIAL,';
			$sql .= '					   P_RELACOES_EMPRESA	       =>  :P_RELACOES_EMPRESA,';
			$sql .= '					   P_NOME_RELACIONADO	       =>  :P_NOME_RELACIONADO,';
			$sql .= '					   P_CARGO_OCUPADO	       =>  :P_CARGO_OCUPADO,';
			$sql .= '					   P_ENSINO	       =>  :P_ENSINO,';
			$sql .= '					   P_PRIMEIRO_GRAU	       =>  :P_PRIMEIRO_GRAU,';
			$sql .= '					   P_SEGUNDO_GRAU	       =>  :P_SEGUNDO_GRAU,';
			$sql .= '					   P_TECNICO	       =>  :P_TECNICO,';
			$sql .= '					   P_SUPERIOR	       =>  :P_SUPERIOR,';
			$sql .= '					   P_WINDOWS	       =>  :P_WINDOWS,';
			$sql .= '					   P_WORD	       =>  :P_WORD,';
			$sql .= '					   P_EXCEL	       =>  :P_EXCEL,';
			$sql .= '					   P_OUTROS_CONHECIMENTOS	       =>  :P_OUTROS_CONHECIMENTOS,';
			$sql .= '					   P_PASSATEMPO	       =>  :P_PASSATEMPO,';
			$sql .= '					   P_DIRIGE	       =>  :P_DIRIGE,';
			$sql .= '					   P_CNH	       =>  :P_CNH,';
			$sql .= '					   P_NOME_REFERENCIA_1	       =>  :P_NOME_REFERENCIA_1,';
			$sql .= '					   P_NOME_REFERENCIA_2	       =>  :P_NOME_REFERENCIA_2,';
			$sql .= '					   P_TELEFONE_REFERENCIA_1	       =>  :P_TELEFONE_REFERENCIA_1,';
			$sql .= '					   P_TELEFONE_REFERENCIA_2	       =>  :P_TELEFONE_REFERENCIA_2,';
			$sql .= '					   P_TRABALHO_VOLUNTARIO	       =>  :P_TRABALHO_VOLUNTARIO,';
			$sql .= '					   P_NOME_TRABALHO_VOLUNTARIO	       =>  :P_NOME_TRABALHO_VOLUNTARIO,';
			$sql .= '					   P_ESCOLARIDADE	       =>  :P_ESCOLARIDADE,';
			$sql .= '					   P_CARTA	       =>  :P_CARTA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_RUA',$arguments['rua'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_ESTADO_CIVIL',$arguments['estado_civil'],4000);
			oci_bind_by_name($stmt,':P_DATA_NASCIMENTO',$arguments['data_nascimento'],4000);
			oci_bind_by_name($stmt,':P_CIDADE_ORIGEM',$arguments['cidade_origem'],4000);
			oci_bind_by_name($stmt,':P_CIDADE_RESIDENCIA',$arguments['cidade_residencia'],4000);
			oci_bind_by_name($stmt,':P_TEMPO_RESIDENCIA',$arguments['tempo_residencia'],4000);
			oci_bind_by_name($stmt,':P_NOME_PAI',$arguments['nome_pai'],4000);
			oci_bind_by_name($stmt,':P_NOME_MAE',$arguments['nome_mae'],4000);
			oci_bind_by_name($stmt,':P_DEPENDENTES',$arguments['dependentes'],4000);
			oci_bind_by_name($stmt,':P_CONJUGE_NOME',$arguments['conjuge_nome'],4000);
			oci_bind_by_name($stmt,':P_TRABALHA',$arguments['trabalha'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_TRABALHO',$arguments['local_trabalho'],4000);
			oci_bind_by_name($stmt,':P_TEMPO',$arguments['tempo'],4000);
			oci_bind_by_name($stmt,':P_FUMANTE',$arguments['fumante'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_SEXO',$arguments['sexo'],4000);
			oci_bind_by_name($stmt,':P_CARGO_PRETENDIDO',$arguments['cargo_pretendido'],4000);
			oci_bind_by_name($stmt,':P_PRETENSAO_SALARIAL',$arguments['pretensao_salarial'],4000);
			oci_bind_by_name($stmt,':P_RELACOES_EMPRESA',$arguments['relacoes_empresa'],4000);
			oci_bind_by_name($stmt,':P_NOME_RELACIONADO',$arguments['nome_relacionado'],4000);
			oci_bind_by_name($stmt,':P_CARGO_OCUPADO',$arguments['cargo_ocupado'],4000);
			oci_bind_by_name($stmt,':P_ENSINO',$arguments['ensino'],4000);
			oci_bind_by_name($stmt,':P_PRIMEIRO_GRAU',$arguments['primeiro_grau'],4000);
			oci_bind_by_name($stmt,':P_SEGUNDO_GRAU',$arguments['segundo_grau'],4000);
			oci_bind_by_name($stmt,':P_TECNICO',$arguments['tecnico'],4000);
			oci_bind_by_name($stmt,':P_SUPERIOR',$arguments['superior'],4000);
			oci_bind_by_name($stmt,':P_WINDOWS',$arguments['windows'],4000);
			oci_bind_by_name($stmt,':P_WORD',$arguments['word'],4000);
			oci_bind_by_name($stmt,':P_EXCEL',$arguments['excel'],4000);
			oci_bind_by_name($stmt,':P_OUTROS_CONHECIMENTOS',$arguments['outros_conhecimentos'],4000);
			oci_bind_by_name($stmt,':P_PASSATEMPO',$arguments['passatempo'],4000);
			oci_bind_by_name($stmt,':P_DIRIGE',$arguments['dirige'],4000);
			oci_bind_by_name($stmt,':P_CNH',$arguments['cnh'],4000);
			oci_bind_by_name($stmt,':P_NOME_REFERENCIA_1',$arguments['nome_referencia_1'],4000);
			oci_bind_by_name($stmt,':P_NOME_REFERENCIA_2',$arguments['nome_referencia_2'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE_REFERENCIA_1',$arguments['telefone_referencia_1'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE_REFERENCIA_2',$arguments['telefone_referencia_2'],4000);
			oci_bind_by_name($stmt,':P_TRABALHO_VOLUNTARIO',$arguments['trabalho_voluntario'],4000);
			oci_bind_by_name($stmt,':P_NOME_TRABALHO_VOLUNTARIO',$arguments['nome_trabalho_voluntario'],4000);
			oci_bind_by_name($stmt,':P_ESCOLARIDADE',$arguments['escolaridade'],4000);
			oci_bind_by_name($stmt,':P_CARTA',$arguments['carta'],4000);

		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$curso_id = listatoarray($arguments,'curso_aperfeicoamento_id');
				$curso = listatoarray($arguments,'curso_nome_aperfeicoamento');
				$inst = listatoarray($arguments,'inst_aperfeicoamento');
				$duracao = listatoarray($arguments,'duracao_aperfeicoamento');
				$concluido = listatoarray($arguments,'concluido_aperfeicoamento');
				
				for($i=0; $i<count($curso); $i++){
					$ret = $this->upd_curriculo_curso(array(curriculo_curso_id => $curso_id[$i],
															curso => $curso[$i],
															entidade => $inst[$i],
															duracao => $duracao[$i],
															concluido => $concluido[$i],
															curriculo_id => $arguments['curriculo_id'],
															no_commit => 1
														  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				$curriculo_emprego_id = listatoarray($arguments,'curriculo_emprego_id');
				$telefone = listatoarray($arguments,'emp_telefone');
				$empresa = listatoarray($arguments,'emp_empresa');
				$funcao = listatoarray($arguments,'emp_funcao');
				$superior = listatoarray($arguments,'emp_supimediato');
				$salario = listatoarray($arguments,'emp_ultsalario');
				$cargo_entrada = listatoarray($arguments,'emp_cargoentrada');
				$cargo_saida = listatoarray($arguments,'emp_cargosaida');
				$data_entrada = listatoarray($arguments,'emp_dataentrada');
				$data_saida = listatoarray($arguments,'emp_datasaida');
				$motivo_saida = listatoarray($arguments,'emp_motivosaida');
				$atividade = listatoarray($arguments,'emp_princativ');

				for($i=0; $i<count($curriculo_emprego_id); $i++){
					$ret = $this->upd_curriculo_emprego(array(curriculo_id => $arguments['curriculo_id'],
															  curriculo_emprego_id => $curriculo_emprego_id[$i],
															  telefone => $telefone[$i],
															  empresa => $empresa[$i],
															  funcao => $funcao[$i],
															  superior => $superior[$i],
															  salario => $salario[$i],
															  cargo_entrada => $cargo_entrada[$i],
															  cargo_saida => $cargo_entrada[$i],
															  data_entrada => $data_entrada[$i],
															  data_saida => $data_saida[$i],
															  motivo_saida => $motivo_saida[$i],
															  principais_atividades => $atividade[$i],
															  tipo => $i,
															  no_commit => 1
															));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Currculo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 12 11:59:19 UTC-0300 2009
		 * Exclui um currculo
		 */
		function del_curriculo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_curriculo(P_CURRICULO_ID   =>  :P_CURRICULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Currculo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 12 17:22:44 UTC-0300 2009
		 * Insere um curso no currculo
		 */
		function ins_curriculo_curso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_curriculo_curso(P_CURRICULO_ID   =>  :P_CURRICULO_ID,';
			$sql .= '					   P_CURSO	       =>  :P_CURSO,';
			$sql .= '					   P_ENTIDADE	       =>  :P_ENTIDADE,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_CONCLUIDO	       =>  :P_CONCLUIDO,';
			$sql .= '					   P_CURRICULO_CURSO_ID	       =>  :P_CURRICULO_CURSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_CURSO',$arguments['curso'],4000);
			oci_bind_by_name($stmt,':P_ENTIDADE',$arguments['entidade'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_CONCLUIDO',$arguments['concluido'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_CURSO_ID',$arguments['curriculo_curso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Curso adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 12 17:23:29 UTC-0300 2009
		 * Altera um curso no currculo
		 */
		function upd_curriculo_curso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_curriculo_curso(P_CURRICULO_CURSO_ID   =>  :P_CURRICULO_CURSO_ID,';
			$sql .= '					   P_CURSO	       =>  :P_CURSO,';
			$sql .= '					   P_ENTIDADE	       =>  :P_ENTIDADE,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_CONCLUIDO	       =>  :P_CONCLUIDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_CURSO_ID',$arguments['curriculo_curso_id'],4000);
			oci_bind_by_name($stmt,':P_CURSO',$arguments['curso'],4000);
			oci_bind_by_name($stmt,':P_ENTIDADE',$arguments['entidade'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_CONCLUIDO',$arguments['concluido'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Curso alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 12 17:24:13 UTC-0300 2009
		 * Exclui um curso no currculo
		 */
		function del_curriculo_curso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_curriculo_curso(P_CURRICULO_CURSO_ID   =>  :P_CURRICULO_CURSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_CURSO_ID',$arguments['curriculo_curso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Curso excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Sat Jun 13 10:07:42 UTC-0300 2009
		 * Insere um emprego no currculo
		 */
		function ins_curriculo_emprego($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_curriculo_emprego(P_CURRICULO_ID   =>  :P_CURRICULO_ID,';
			$sql .= '					   P_EMPRESA	       =>  :P_EMPRESA,';
			$sql .= '					   P_SUPERIOR	       =>  :P_SUPERIOR,';
			$sql .= '					   P_FUNCAO	       =>  :P_FUNCAO,';
			$sql .= '					   P_SALARIO	       =>  :P_SALARIO,';
			$sql .= '					   P_CARGO_ENTRADA	       =>  :P_CARGO_ENTRADA,';
			$sql .= '					   P_CARGO_SAIDA	       =>  :P_CARGO_SAIDA,';
			$sql .= '					   P_DATA_ENTRADA	       =>  :P_DATA_ENTRADA,';
			$sql .= '					   P_DATA_SAIDA	       =>  :P_DATA_SAIDA,';
			$sql .= '					   P_MOTIVO_SAIDA	       =>  :P_MOTIVO_SAIDA,';
			$sql .= '					   P_PRINCIPAIS_ATIVIDADES	       =>  :P_PRINCIPAIS_ATIVIDADES,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO,';
			$sql .= '					   P_CURRICULO_EMPREGO_ID	       =>  :P_CURRICULO_EMPREGO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_EMPRESA',$arguments['empresa'],4000);
			oci_bind_by_name($stmt,':P_SUPERIOR',$arguments['superior'],4000);
			oci_bind_by_name($stmt,':P_FUNCAO',$arguments['funcao'],4000);
			oci_bind_by_name($stmt,':P_SALARIO',$arguments['salario'],4000);
			oci_bind_by_name($stmt,':P_CARGO_ENTRADA',$arguments['cargo_entrada'],4000);
			oci_bind_by_name($stmt,':P_CARGO_SAIDA',$arguments['cargo_saida'],4000);
			oci_bind_by_name($stmt,':P_DATA_ENTRADA',$arguments['data_entrada'],4000);
			oci_bind_by_name($stmt,':P_DATA_SAIDA',$arguments['data_saida'],4000);
			oci_bind_by_name($stmt,':P_MOTIVO_SAIDA',$arguments['motivo_saida'],4000);
			oci_bind_by_name($stmt,':P_PRINCIPAIS_ATIVIDADES',$arguments['principais_atividades'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_EMPREGO_ID',$arguments['curriculo_emprego_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Emprego adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Sat Jun 13 10:08:20 UTC-0300 2009
		 * Altera um emprego no currculo
		 */
		function upd_curriculo_emprego($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_curriculo_emprego(P_CURRICULO_EMPREGO_ID   =>  :P_CURRICULO_EMPREGO_ID,';
			$sql .= '					   P_EMPRESA	       =>  :P_EMPRESA,';
			$sql .= '					   P_SUPERIOR	       =>  :P_SUPERIOR,';
			$sql .= '					   P_FUNCAO	       =>  :P_FUNCAO,';
			$sql .= '					   P_SALARIO	       =>  :P_SALARIO,';
			$sql .= '					   P_CARGO_ENTRADA	       =>  :P_CARGO_ENTRADA,';
			$sql .= '					   P_CARGO_SAIDA	       =>  :P_CARGO_SAIDA,';
			$sql .= '					   P_DATA_ENTRADA	       =>  :P_DATA_ENTRADA,';
			$sql .= '					   P_DATA_SAIDA	       =>  :P_DATA_SAIDA,';
			$sql .= '					   P_MOTIVO_SAIDA	       =>  :P_MOTIVO_SAIDA,';
			$sql .= '					   P_PRINCIPAIS_ATIVIDADES	       =>  :P_PRINCIPAIS_ATIVIDADES,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CURRICULO_EMPREGO_ID',$arguments['curriculo_emprego_id'],4000);
			oci_bind_by_name($stmt,':P_EMPRESA',$arguments['empresa'],4000);
			oci_bind_by_name($stmt,':P_SUPERIOR',$arguments['superior'],4000);
			oci_bind_by_name($stmt,':P_FUNCAO',$arguments['funcao'],4000);
			oci_bind_by_name($stmt,':P_SALARIO',$arguments['salario'],4000);
			oci_bind_by_name($stmt,':P_CARGO_ENTRADA',$arguments['cargo_entrada'],4000);
			oci_bind_by_name($stmt,':P_CARGO_SAIDA',$arguments['cargo_saida'],4000);
			oci_bind_by_name($stmt,':P_DATA_ENTRADA',$arguments['data_entrada'],4000);
			oci_bind_by_name($stmt,':P_DATA_SAIDA',$arguments['data_saida'],4000);
			oci_bind_by_name($stmt,':P_MOTIVO_SAIDA',$arguments['motivo_saida'],4000);
			oci_bind_by_name($stmt,':P_PRINCIPAIS_ATIVIDADES',$arguments['principais_atividades'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Emprego alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Apr 5 14:10:57 UTC-0300 2010
		 * Insere uma Vaga
		 */
		function ins_vaga($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['vaga'])))
				$arguments['vaga'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_vaga(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_SETOR	       =>  :P_SETOR,';
			$sql .= '					   P_REQUISITOS	       =>  :P_REQUISITOS,';
			$sql .= '					   P_BENEFICIOS	       =>  :P_BENEFICIOS,';
			$sql .= '					   P_ATIVA	       =>  :P_ATIVA,';
			$sql .= '					   P_LOCALIDADE	       =>  :P_LOCALIDADE,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_VAGA_ID	       =>  :P_VAGA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SETOR',$arguments['setor'],4000);
			oci_bind_by_name($stmt,':P_REQUISITOS',$arguments['requisitos'],4000);
			oci_bind_by_name($stmt,':P_BENEFICIOS',$arguments['beneficios'],4000);
			oci_bind_by_name($stmt,':P_ATIVA',$arguments['ativa'],4000);
			oci_bind_by_name($stmt,':P_LOCALIDADE',$arguments['localidade'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Mon Apr 5 14:13:05 UTC-0300 2010
		 * Altera uma Vaga
		 */
		function upd_vaga($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['vaga'])))
				$arguments['vaga'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_vaga(P_VAGA_ID   =>  :P_VAGA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_SETOR	       =>  :P_SETOR,';
			$sql .= '					   P_REQUISITOS	       =>  :P_REQUISITOS,';
			$sql .= '					   P_BENEFICIOS	       =>  :P_BENEFICIOS,';
			$sql .= '					   P_LOCALIDADE	       =>  :P_LOCALIDADE,';
			$sql .= '					   P_ATIVA	       =>  :P_ATIVA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SETOR',$arguments['setor'],4000);
			oci_bind_by_name($stmt,':P_REQUISITOS',$arguments['requisitos'],4000);
			oci_bind_by_name($stmt,':P_BENEFICIOS',$arguments['beneficios'],4000);
			oci_bind_by_name($stmt,':P_LOCALIDADE',$arguments['localidade'],4000);
			oci_bind_by_name($stmt,':P_ATIVA',$arguments['ativa'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Apr 5 14:13:42 UTC-0300 2010
		 * Exclui uma Vaga
		 */
		function del_vaga($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_vaga(P_VAGA_ID   =>  :P_VAGA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Apr 5 14:10:57 UTC-0300 2010
		 * Insere uma Vaga
		 */
		function ins_vaga_completa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['vaga'])))
				$arguments['vaga'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_vaga(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_SETOR	       =>  :P_SETOR,';
			$sql .= '					   P_REQUISITOS	       =>  :P_REQUISITOS,';
			$sql .= '					   P_BENEFICIOS	       =>  :P_BENEFICIOS,';
			$sql .= '					   P_ATIVA	       =>  :P_ATIVA,';
			$sql .= '					   P_LOCALIDADE	       =>  :P_LOCALIDADE,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_VAGA_ID	       =>  :P_VAGA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SETOR',$arguments['setor'],4000);
			oci_bind_by_name($stmt,':P_REQUISITOS',$arguments['requisitos'],4000);
			oci_bind_by_name($stmt,':P_BENEFICIOS',$arguments['beneficios'],4000);
			oci_bind_by_name($stmt,':P_ATIVA',$arguments['ativa'],4000);
			oci_bind_by_name($stmt,':P_LOCALIDADE',$arguments['localidade'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
				$vaga_atributo_id = listatoarray($arguments,'vaga_atributo_id');
				$atributo_id = listatoarray($arguments,'atributo_id');
				
				$conn = CreateObject("portal._class.consulta.rh");
				$qrVA = $conn->get_vaga_atributo(array(vaga_id => $_VARS['vaga_id']));
				
				for($i=0; $i<count($qrVA); $i++){
					if(array_search($qrVA[$i]['VAGA_ATRIBUTO_ID'], $vaga_atributo_id) === false){
						$ret = $this->del_vaga_atributo(array(vaga_atributo_id  => $qrVA[$i]['VAGA_ATRIBUTO_ID'],
															  no_commit 		=> 1
															 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i < count($vaga_atributo_id); $i++){ 
					if(!strlen(trim($vaga_atributo_id[$i]))){
						$ret = $this->ins_vaga_atributo(array(vaga_id 	  => $arguments['vaga_id'],
															  atributo_id => $atributo_id[$i],
															  no_commit   => 1
															 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Apr 5 14:13:05 UTC-0300 2010
		 * Altera uma Vaga
		 */
		function upd_vaga_completa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['vaga'])))
				$arguments['vaga'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_vaga(P_VAGA_ID   =>  :P_VAGA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_SETOR	       =>  :P_SETOR,';
			$sql .= '					   P_REQUISITOS	       =>  :P_REQUISITOS,';
			$sql .= '					   P_BENEFICIOS	       =>  :P_BENEFICIOS,';
			$sql .= '					   P_LOCALIDADE	       =>  :P_LOCALIDADE,';
			$sql .= '					   P_ATIVA	       =>  :P_ATIVA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SETOR',$arguments['setor'],4000);
			oci_bind_by_name($stmt,':P_REQUISITOS',$arguments['requisitos'],4000);
			oci_bind_by_name($stmt,':P_BENEFICIOS',$arguments['beneficios'],4000);
			oci_bind_by_name($stmt,':P_LOCALIDADE',$arguments['localidade'],4000);
			oci_bind_by_name($stmt,':P_ATIVA',$arguments['ativa'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				$vaga_atributo_id = listatoarray($arguments,'vaga_atributo_id');
				$atributo_id = listatoarray($arguments,'atributo_id');
				
				$conn = CreateObject("portal._class.consulta.rh");
				$qrVA = $conn->get_vaga_atributo(array(vaga_id => $arguments['vaga_id']));
				
				for($i=0; $i<count($qrVA); $i++){
					if(array_search($qrVA[$i]['VAGA_ATRIBUTO_ID'], $vaga_atributo_id) === false){
						$ret = $this->del_vaga_atributo(array(vaga_atributo_id  => $qrVA[$i]['VAGA_ATRIBUTO_ID'],
															  no_commit 		=> 1
															 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i < count($vaga_atributo_id); $i++){ 
					if(!strlen(trim($vaga_atributo_id[$i]))){
						$ret = $this->ins_vaga_atributo(array(vaga_id 	  => $arguments['vaga_id'],
															  atributo_id => $atributo_id[$i],
															  no_commit   => 1
															 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 17 10:01:48 UTC-0300 2010
		 * Insere um atributo da vaga
		 */
		function ins_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_atributo(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_ATRIBUTO_ID	       =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 17 10:02:30 UTC-0300 2010
		 * Altera um atributo da vaga
		 */
		function upd_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_atributo(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 17 10:03:02 UTC-0300 2010
		 * Exclui um atributo da vaga
		 */
		function del_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_atributo(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 17 13:37:43 UTC-0300 2010
		 * Insere um atributo para a vaga
		 */
		function ins_vaga_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_vaga_atributo(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_VAGA_ID	       =>  :P_VAGA_ID,';
			$sql .= '					   P_VAGA_ATRIBUTO_ID	       =>  :P_VAGA_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
			oci_bind_by_name($stmt,':P_VAGA_ATRIBUTO_ID',$arguments['vaga_atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 17 13:38:47 UTC-0300 2010
		 * Exclui um atributo de uma vaga
		 */
		function del_vaga_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_vaga_atributo(P_VAGA_ATRIBUTO_ID   =>  :P_VAGA_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ATRIBUTO_ID',$arguments['vaga_atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri May 21 15:09:44 UTC-0300 2010
		 * Vincula uma vaga a um currculo
		 */
		function ins_vaga_curriculo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_vaga_curriculo(P_VAGA_ID   =>  :P_VAGA_ID,';
			$sql .= '					   P_CURRICULO_ID	       =>  :P_CURRICULO_ID,';
			$sql .= '					   P_VAGA_CURRICULO_ID	       =>  :P_VAGA_CURRICULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_VAGA_CURRICULO_ID',$arguments['vaga_curriculo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga vinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 21 15:10:21 UTC-0300 2010
		 * Desvincula uma vaga a um currculo
		 */
		function del_vaga_curriculo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_vaga_curriculo(P_VAGA_CURRICULO_ID   =>  :P_VAGA_CURRICULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_CURRICULO_ID',$arguments['vaga_curriculo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vaga desvinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 21 16:26:33 UTC-0300 2010
		 * Insere uma entrevista
		 */
		function ins_entrevista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_ins_entrevista(P_VAGA_ID   =>  :P_VAGA_ID,';
			$sql .= '					   P_CURRICULO_ID	       =>  :P_CURRICULO_ID,';
			$sql .= '					   P_VAGA_ENTREVISTA_ID	       =>  :P_VAGA_ENTREVISTA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ID',$arguments['vaga_id'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_VAGA_ENTREVISTA_ID',$arguments['vaga_entrevista_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri May 21 16:27:58 UTC-0300 2010
		 * Altera uma entrevista
		 */
		function upd_entrevista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_alt_entrevista(P_VAGA_ENTREVISTA_ID   =>  :P_VAGA_ENTREVISTA_ID,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_COMENTARIO	       =>  :P_COMENTARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ENTREVISTA_ID',$arguments['vaga_entrevista_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_COMENTARIO',$arguments['comentario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista finalizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 21 16:28:44 UTC-0300 2010
		 * Exclui uma entrevista
		 */
		function del_entrevista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	rh.pkg_rh.prc_del_entrevista(P_VAGA_ENTREVISTA_ID   =>  :P_VAGA_ENTREVISTA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_VAGA_ENTREVISTA_ID',$arguments['vaga_entrevista_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
			

/*
		 * Criado em Mon Jan 24 10:46:01 UTC-0200 2011
		 * Insere um candidato
		 */
		function ins_candidato($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_ins_candidato(P_NOME  	   =>  :P_NOME,';
			$sql .= '					   				P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   					 P_DDD	       =>  :P_DDD,';
			$sql .= '					   				   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   				  P_CIDADE	       =>  :P_CIDADE,';
			$sql .= '					  				  P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   			  P_OBSERVACAO	       =>  :P_OBSERVACAO,';
			$sql .= '					   				  	 P_CEP	       =>  :P_CEP,';
			$sql .= '					   		 P_DATA_NASCIMENTO	       =>  :P_DATA_NASCIMENTO,';
			$sql .= '					   			P_ESTADO_CIVIL	       =>  :P_ESTADO_CIVIL,';
			$sql .= '					   				  P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   			 P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   				  P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   			  P_LOGRADOURO	       =>  :P_LOGRADOURO,';
			$sql .= '					   	P_OUTROS_CONHECIMENTOS	       =>  :P_OUTROS_CONHECIMENTOS,';
			$sql .= '					      P_REGIME_CONTRATACAO	       =>  :P_REGIME_CONTRATACAO,';
			$sql .= '					   	  P_PRETENSAO_SALARIAL	       =>  :P_PRETENSAO_SALARIAL,';
			$sql .= '					   			 P_DISP_INICIO	       =>  :P_DISP_INICIO,';
			$sql .= '					  			 P_DISP_VIAGEM	       =>  :P_DISP_VIAGEM,';
			$sql .= '					 	     P_VEICULO_PROPRIO	       =>  :P_VEICULO_PROPRIO,';
			$sql .= '					   		  P_AREA_INTERESSE	       =>  :P_AREA_INTERESSE,';
			$sql .= '					   		            P_SEXO	       =>  :P_SEXO,';
			$sql .= '					   		  P_CATEGORIA_CNH	       =>  :P_CATEGORIA_CNH,';
			$sql .= '					   			  P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   				P_CONTEUDO	       =>  :P_CONTEUDO,';
			$sql .= '					   			P_CANDIDATO_ID	       =>  :P_CANDIDATO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_DDD',$arguments['ddd'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);		
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_DATA_NASCIMENTO',$arguments['data_nascimento'],4000);
			oci_bind_by_name($stmt,':P_ESTADO_CIVIL',$arguments['estado_civil'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_LOGRADOURO',$arguments['logradouro'],4000);
			oci_bind_by_name($stmt,':P_OUTROS_CONHECIMENTOS',$arguments['outros_conhecimentos'],4000);
			oci_bind_by_name($stmt,':P_REGIME_CONTRATACAO',$arguments['regime_contratacao'],4000);
			oci_bind_by_name($stmt,':P_PRETENSAO_SALARIAL',$arguments['pretensao_salarial'],4000);
			oci_bind_by_name($stmt,':P_DISP_INICIO',$arguments['disp_inicio'],4000);
			oci_bind_by_name($stmt,':P_DISP_VIAGEM',$arguments['disp_viagem'],4000);
			oci_bind_by_name($stmt,':P_VEICULO_PROPRIO',$arguments['veiculo_proprio'],4000);
			oci_bind_by_name($stmt,':P_AREA_INTERESSE',$arguments['area_interesse'],4000);
			oci_bind_by_name($stmt,':P_SEXO',$arguments['sexo'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_CNH',$arguments['categoria_cnh'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			
			$p_lob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_CONTEUDO',$p_lob,-1,OCI_B_BLOB);
			$binario = file_get_contents($_SERVER['DOCUMENT_ROOT'].$arguments['url_anexo']);
			$p_lob->writeTemporary($binario,OCI_TEMP_BLOB);
			 
			oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);

		
			if($sucesso){	
				//Formao
					if(strlen(trim($arguments['formacao_1'])))	{		
					$resultado = $this->ins_candidato_formacao(array(candidato_id	=> $arguments['candidato_id'],
							  										   formacao_id	=> $arguments['formacao_1'],
																			 curso	=> $arguments['curso_1'],
																	   instituicao	=> $arguments['instituicao_1'],
																	  concluido_em	=> $arguments['concluido_em_1'],
																	  status_curso	=> $arguments['status_curso_1'],
																		 no_commit 	=> 1));																 
					if($resultado['erro'] == 'true') 
						return $resultado;
				}	
			if(strlen(trim($arguments['formacao_2'])))	{		
					$resultado = $this->ins_candidato_formacao(array(candidato_id	=> $arguments['candidato_id'],
							  										   formacao_id	=> $arguments['formacao_2'],
																			 curso	=> $arguments['curso_2'],
																	   instituicao	=> $arguments['instituicao_2'],
																	  concluido_em	=> $arguments['concluido_em_2'],
																	  status_curso	=> $arguments['status_curso_2'],
																		 no_commit 	=> 1));	
					if($resultado['erro'] == 'true') 
						return $resultado;
				}				
				
				//Experincia
				if(strlen(trim($arguments['empresa_1'])))	{		
					$resultado = $this->ins_candidato_experiencia(array(candidato_id	=> $arguments['candidato_id'],
							  										   		 empresa	=> $arguments['empresa_1'],
																	     	   cargo	=> $arguments['cargo_1'],
																	  	  atividades	=> $arguments['atividade_1'],
																	    data_inicial	=> $arguments['data_exp_inicial_1'],
																	   	  data_final	=> $arguments['data_exp_final_1'],																	
																		 no_commit 		=> 1)); 	
					if($resultado['erro'] == 'true') 
						return $resultado;
				}	
				if(strlen(trim($arguments['empresa_2'])))	{		
					$resultado = $this->ins_candidato_experiencia(array(candidato_id	=> $arguments['candidato_id'],
							  										   		 empresa	=> $arguments['empresa_2'],
																	     	   cargo	=> $arguments['cargo_2'],
																	  	  atividades	=> $arguments['atividade_2'],
																	    data_inicial	=> $arguments['data_exp_inicial_2'],
																	   	  data_final	=> $arguments['data_exp_final_2'],																	
																		 no_commit 		=> 1));
					if($resultado['erro'] == 'true') 
						return $resultado;
				}	
				
				if(strlen(trim($arguments['empresa_3'])))	{		
					$resultado = $this->ins_candidato_experiencia(array(candidato_id	=> $arguments['candidato_id'],
							  										   		 empresa	=> $arguments['empresa_3'],
																	     	   cargo	=> $arguments['cargo_3'],
																	  	  atividades	=> $arguments['atividade_3'],
																	    data_inicial	=> $arguments['data_exp_inicial_3'],
																	   	  data_final	=> $arguments['data_exp_final_3'],																	
																		 no_commit 		=> 1));																		 
																		 
					if($resultado['erro'] == 'true')
						return $resultado;
				}
				
				//Conhecimentos
				
				$conhecimentos = explode(',',$arguments['conhecimentos']);			
				
				for($i=0; $i < count($conhecimentos); $i++)	{									
					if(strlen(trim($conhecimentos[$i]))){													
						$resultado = $this->ins_candidato_conhecimentos(array(candidato_id	=> $arguments['candidato_id'],
																		   conhecimento_id	=> $conhecimentos[$i],																
																				 no_commit 	=> 1));																	 
																			 
						if($resultado['erro'] == 'true')
							return $resultado;
					}
				}
				
				//Como soube da vaga?
				
				$conheceu_vaga = explode(',',$arguments['conheceu_vaga']);				
					
				for($i=0; $i < count($conheceu_vaga); $i++)	{
					if(strlen(trim($conheceu_vaga[$i]))){
						$resultado = $this->ins_candidato_divulgacao(array(candidato_id	=> $arguments['candidato_id'],
																		  divulgacao_id	=> $conheceu_vaga[$i],																
																			 no_commit  => 1));																		 
																			 
						if($resultado['erro'] == 'true')
							return $resultado;
					}
				}
			
				//Se todos os cadastros esto ok, envia email para vagas@kmm.com.br
			 	$connKMM = CreateObject("_class.consulta.kmm");
			    $qrAreas = $connKMM->get_cg_ref_codes(array(dominio => 'AREA EMPRESA', id => $arguments['area_interesse']));				
				
				$mail = new SendMail();
				$mail->from = 'noreply@kmm.com.br';
				$mail->headers = "Errors-To: maria@kmm.com.br";
				$mail->to = $arguments['para'];
				$mail->subject = "[".$qrAreas[0]['DESCRICAO']."] Trabalhe Conosco";
				
				global $g_candidato_id;
				$g_candidato_id = $arguments['candidato_id'];
							
				$mail->add_attachment($arguments['anexo']['tmp_name'],$arguments['anexo']['name'],$arguments['anexo']['type']);
				$corpo = get_include_contents($_SERVER['DOCUMENT_ROOT'].'/portal/objetos/kmm/trabalhe_conosco/template_trab_conosco2.php');				
				
				$mail->body = $corpo;					
				
				$sended = $mail->send();				

			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Currculo enviado com sucesso. Agradecemos seu interesse em fazer parte da equipe KMM.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
	}
	
			/*
			 * Criado em Fri Dec 20 14:57:37 UTC-0200 2013
			 * Inserir formao ao candidato
			 */
			function ins_candidato_formacao($arguments=array()){
			
			
				if(!isset($arguments['no_commit']))
					$this-> start();
				$sql  = 'BEGIN';
				$sql .= '	kmm.pkg_adicional.prc_ins_candidato_formacao(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID,';
				$sql .= '					   							  P_FORMACAO_ID   =>  :P_FORMACAO_ID,';
				$sql .= '					   									P_CURSO   =>  :P_CURSO,';
				$sql .= '					   							  P_INSTITUICAO   =>  :P_INSTITUICAO,';
				$sql .= '					   							 P_CONCLUIDO_EM   =>  :P_CONCLUIDO_EM,';
				$sql .= '					   							 P_STATUS_CURSO   =>  :P_STATUS_CURSO,';
				$sql .= '					   					P_CANDIDATO_FORMACAO_ID   =>  :P_CANDIDATO_FORMACAO_ID);';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
				oci_bind_by_name($stmt,':P_FORMACAO_ID',$arguments['formacao_id'],4000);
				oci_bind_by_name($stmt,':P_CURSO',$arguments['curso'],4000);
				oci_bind_by_name($stmt,':P_INSTITUICAO',$arguments['instituicao'],4000);
				oci_bind_by_name($stmt,':P_CONCLUIDO_EM',$arguments['concluido_em'],4000);
				oci_bind_by_name($stmt,':P_STATUS_CURSO',$arguments['status_curso'],4000);
				oci_bind_by_name($stmt,':P_CANDIDATO_FORMACAO_ID',$arguments['candidato_formacao_id'],4000);
			
				$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
				$_SESSION['last_error'] = oci_error($stmt);
			
				if($sucesso){
			
				}
			
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				   $arguments["erro"] = "false";
				   $arguments["mensagem"] = "Formao inserida com sucesso!";
				}else{
				   $arguments["erro"] = "true";
				   $arguments["mensagem"] = $_SESSION['last_error'];
				   $this->rollback();
				}
				return $arguments;
			}
			
			/*
			 * Criado em Fri Dec 20 14:58:29 UTC-0200 2013
			 * Inserir experincia ao candidato
			 */
			function ins_candidato_experiencia($arguments=array()){
			
				if(!isset($arguments['no_commit']))
					$this-> start();
				$sql  = 'BEGIN';
				$sql .= '	kmm.pkg_adicional.prc_ins_candidato_experiencia(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID,';
				$sql .= '					   									 P_EMPRESA	 =>  :P_EMPRESA,';
				$sql .= '					   									   P_CARGO	 =>  :P_CARGO,';
				$sql .= '					   								  P_ATIVIDADES	 =>  :P_ATIVIDADES,';
				$sql .= '					   								P_DATA_INICIAL	 =>  :P_DATA_INICIAL,';
				$sql .= '					   								  P_DATA_FINAL	 =>  :P_DATA_FINAL,';
				$sql .= '					   					P_CANDIDATO_EXPERIENCIA_ID	 =>  :P_CANDIDATO_EXPERIENCIA_ID);';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
				oci_bind_by_name($stmt,':P_EMPRESA',$arguments['empresa'],4000);
				oci_bind_by_name($stmt,':P_CARGO',$arguments['cargo'],4000);
				oci_bind_by_name($stmt,':P_ATIVIDADES',$arguments['atividades'],4000);
				oci_bind_by_name($stmt,':P_DATA_INICIAL',$arguments['data_inicial'],4000);
				oci_bind_by_name($stmt,':P_DATA_FINAL',$arguments['data_final'],4000);
				oci_bind_by_name($stmt,':P_CANDIDATO_EXPERIENCIA_ID',$arguments['candidato_experiencia_id'],4000);
			
				$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
				$_SESSION['last_error'] = oci_error($stmt);
			
				if($sucesso){
			
				}
			
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				   $arguments["erro"] = "false";
				   $arguments["mensagem"] = "Experincia inserida com sucesso!";
				}else{
				   $arguments["erro"] = "true";
				   $arguments["mensagem"] = $_SESSION['last_error'];
				   $this->rollback();
				}
				return $arguments;
			}
			
			/*
			 * Criado em Fri Dec 20 14:57:37 UTC-0200 2013
			 * Inserir candidato conhecimentos
			 */
			function ins_candidato_conhecimentos($arguments=array()){
			
			
				if(!isset($arguments['no_commit']))
					$this-> start();
				$sql  = 'BEGIN';
				$sql .= '	kmm.pkg_adicional.prc_ins_cand_conhecimentos(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID,';
				$sql .= '					   				     	  P_CONHECIMENTO_ID   =>  :P_CONHECIMENTO_ID);';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
				oci_bind_by_name($stmt,':P_CONHECIMENTO_ID',$arguments['conhecimento_id'],4000);
				
				$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
				$_SESSION['last_error'] = oci_error($stmt);
			
				if($sucesso){
			
				}
			
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				   $arguments["erro"] = "false";
				   $arguments["mensagem"] = "Conhecimento inserido com sucesso!";
				}else{
				   $arguments["erro"] = "true";
				   $arguments["mensagem"] = $_SESSION['last_error'];
				   $this->rollback();
				}
				return $arguments;
			}
			
			/*
			 * Criado em Fri Dec 20 14:57:37 UTC-0200 2013
			 * Inserir candidato conhecimentos
			 */
			function ins_candidato_divulgacao($arguments=array()){
			
			
				if(!isset($arguments['no_commit']))
					$this-> start();
				$sql  = 'BEGIN';
				$sql .= '	kmm.pkg_adicional.prc_ins_cand_divulgacao_vaga(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID,';
				$sql .= '					   				     	      P_DIVULGACAO_ID   =>  :P_DIVULGACAO_ID);';
				$sql .= 'END;';
			
				$stmt = oci_parse($this->conexao,$sql);
				oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
				oci_bind_by_name($stmt,':P_DIVULGACAO_ID',$arguments['divulgacao_id'],4000);
				
				$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
				$_SESSION['last_error'] = oci_error($stmt);
			
				if($sucesso){
			
				}
			
				if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				   $arguments["erro"] = "false";
				   $arguments["mensagem"] = "Divulgao inserida com sucesso!";
				}else{
				   $arguments["erro"] = "true";
				   $arguments["mensagem"] = $_SESSION['last_error'];
				   $this->rollback();
				}
				return $arguments;
			}
				
					
		/*
		 * Criado em Mon Jan 24 10:45:13 UTC-0200 2011
		 * Altera um candidato
		 */
		function upd_candidato($arguments=array()){			
					
			if(strlen(trim($arguments['url_anexo']))){
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
								
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_anexo'],
									categoria_id	=> 37201,
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['curriculo_id'] = $ret['foto_id'];
			}
			
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_alt_candidato(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID,';
			$sql .= '					   P_CURRICULO_ID	       			  =>  :P_CURRICULO_ID,';
			$sql .= '					   P_NOME	      =>  :P_NOME,';
			$sql .= '					   P_SOBRENOME    =>  :P_SOBRENOME,';
			$sql .= '					   P_EMAIL        =>  :P_EMAIL,';
			$sql .= '					   P_DDD          =>  :P_DDD,';
			$sql .= '					   P_TELEFONE     =>  :P_TELEFONE,';
			$sql .= '					   P_CIDADE       =>  :P_CIDADE,';
			$sql .= '					   P_OBSERVACAO      =>  :P_OBSERVACAO,';
			$sql .= '					   P_ESTADO       =>  :P_ESTADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
			oci_bind_by_name($stmt,':P_CURRICULO_ID',$arguments['curriculo_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SOBRENOME',$arguments['sobrenome'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_DDD',$arguments['ddd'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Candidato alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jan 24 10:44:18 UTC-0200 2011
		 * Exclui um candidato
		 */
		function del_candidato($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_del_candidato(P_CANDIDATO_ID   =>  :P_CANDIDATO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Candidato excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jan 24 10:46:01 UTC-0200 2011
		 * Insere uma entrevista
		 */
		function ins_entrevista_kmm($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_ins_entrevista(P_ENTREVISTA_ID    =>  :P_ENTREVISTA_ID,';
			$sql .= '					   P_CANDIDATO_ID	       			  	=>  :P_CANDIDATO_ID,';
			$sql .= '					   P_DATA	      						=>  :P_DATA,';
			$sql .= '					   P_ENTREVISTADOR    	  				=>  :P_ENTREVISTADOR,';
			$sql .= '					   P_OBSERVACAO      					=>  :P_OBSERVACAO,';
			$sql .= '					   P_COD_PORTAL	       					=>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);		
			oci_bind_by_name($stmt,':P_ENTREVISTA_ID',$arguments['entrevista_id'],4000);
			oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_ENTREVISTADOR',$arguments['entrevistador_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
       
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
}
		
		/*
		 * Criado em Mon Jan 24 10:45:13 UTC-0200 2011
		 * Altera uma entrevista
		 */
		function upd_entrevista_kmm($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_alt_entrevista(P_ENTREVISTA_ID    =>  :P_ENTREVISTA_ID,';
			$sql .= '					   P_CANDIDATO_ID	       			    =>  :P_CANDIDATO_ID,';
			$sql .= '					   P_DATA	      					    =>  :P_DATA,';
			$sql .= '					   P_ENTREVISTADOR    	 				=>  :P_ENTREVISTADOR,';
			$sql .= '					   P_OBSERVACAO      					=>  :P_OBSERVACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);		
			oci_bind_by_name($stmt,':P_ENTREVISTA_ID',$arguments['entrevista_id'],4000);
			oci_bind_by_name($stmt,':P_CANDIDATO_ID',$arguments['candidato_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_ENTREVISTADOR',$arguments['entrevistador_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jan 24 10:44:18 UTC-0200 2011
		 * Exclui uma entrevista
		 */
		function del_entrevista_kmm($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	kmm.pkg_adicional.prc_del_entrevista(P_ENTREVISTA_ID   =>  :P_ENTREVISTA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ENTREVISTA_ID',$arguments['entrevista_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Aug 23 11:27:41 UTC-0300 2012
		 * Responder questionrio de pesquisas
		 */
		function ins_questionario($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
		
			$connRH = CreateObject("portal._class.consulta.rh");
			$qrP   = $connRH->get_pergunta_pesquisa(array(pesquisa_id => $arguments['pesquisa_id']));
			
			for($i=0;$i<count($qrP);$i++) {
				
				if($qrP[$i]['PERGUNTA_TIPO'] == 1 && strlen(trim($qrP[$i]['PESQUISA_PERGUNTA_ID']))){ //Radiobutton				
					$ret = $this->ins_resposta_pesquisa(array(pesquisa_id 		  => $arguments['pesquisa_id']
															,pesquisa_resposta_id => $arguments['resposta_'.$qrP[$i]['PESQUISA_PERGUNTA_ID']]
															,descricao 			  => ''
															,pesquisa_pergunta_id => $qrP[$i]['PESQUISA_PERGUNTA_ID']
															,setor 				  => $qrP[$i]['PESQUISA_PERGUNTA_ID']
															,no_commit 			  => 1));
					
				} else if($qrP[$i]['PERGUNTA_TIPO'] == 2){ //Checkbox
				
					$qrR = $connRH->get_resposta_pesquisa(array(pesquisa_pergunta_id => $qrP[$i]['PESQUISA_PERGUNTA_ID']));		
					
					for($k = 0; $k < count($qrR); $k++) {			
						
						if(strlen(trim($arguments['resposta_'.$qrR[$k]['PESQUISA_RESPOSTA_ID'].'_'.$qrP[$i]['PESQUISA_PERGUNTA_ID']]))){
							$ret = $this->ins_resposta_pesquisa(array(pesquisa_id 		  => $arguments['pesquisa_id']
																	,pesquisa_resposta_id => $arguments['resposta_'.$qrR[$k]['PESQUISA_RESPOSTA_ID'].'_'.$qrP[$i]['PESQUISA_PERGUNTA_ID']]
																	,descricao 			  => ''
																	,pesquisa_pergunta_id => $qrP[$i]['PESQUISA_PERGUNTA_ID']
																	,setor				  => $qrP[$i]['PESQUISA_PERGUNTA_ID']
																	,no_commit 			  => 1));
						}
					}
					
				} else if($qrP[$i]['PERGUNTA_TIPO'] == 3 && strlen(trim($qrP[$i]['PESQUISA_PERGUNTA_ID']))){ //Textarea
					$ret = $this->ins_resposta_pesquisa(array(pesquisa_id 		  => $arguments['pesquisa_id']
															,pesquisa_resposta_id => ''
															,descricao 			  => $arguments['resposta_'.$qrP[$i]['PESQUISA_PERGUNTA_ID']]
															,pesquisa_pergunta_id => $qrP[$i]['PESQUISA_PERGUNTA_ID']
															,setor			      => $qrP[$i]['PESQUISA_PERGUNTA_ID']
															,no_commit 			  => 1));
				}
														
				if($ret['erro'] == 'true') 
					return $ret;										
			}
			
			if($ret['erro']){
			
				$ret = $this->del_pesquisa_chave(array(pesquisa_id => $arguments['pesquisa_id']
													           ,chave => $arguments['chave']
														   ,no_commit => 1));
														
				if($ret['erro'] == 'true') 
					return $ret;	
			
			}
			
			if($ret['erro'] && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Agradecemos sua participao em nossa pesquisa!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			return $arguments;	
		}
		/*
		 * Criado em Thu Aug 23 11:27:41 UTC-0300 2012
		 * Responder questionrio de pesquisas
		 */
		function ins_resposta_pesquisa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_ins_pesquisa_resposta(P_PESQUISA_ID  =>  :P_PESQUISA_ID,';
			$sql .= '					   						 P_PESQUISA_RESPOSTA_ID  =>  :P_PESQUISA_RESPOSTA_ID,';
			$sql .= '					   									P_DESCRICAO	 =>  :P_DESCRICAO,';
			$sql .= '					   						 P_PESQUISA_PERGUNTA_ID	 =>  :P_PESQUISA_PERGUNTA_ID,';
			$sql .= '					   						 				P_SETOR	 =>  :P_SETOR);';
			$sql .= 'END;';
			
			$arguments['pesquisa_id'] = 4;
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PESQUISA_ID',$arguments['pesquisa_id'],4000);
			oci_bind_by_name($stmt,':P_PESQUISA_RESPOSTA_ID',$arguments['pesquisa_resposta_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_PESQUISA_PERGUNTA_ID',$arguments['pesquisa_pergunta_id'],4000);
			oci_bind_by_name($stmt,':P_SETOR',$arguments['setor'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Agradecemos sua participao em nossa pesquisa!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Aug 23 11:27:41 UTC-0300 2012
		 * Exclui chave da pesquisa
		 */
		function del_pesquisa_chave($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_del_pesquisa_chave(P_PESQUISA_ID  =>  :P_PESQUISA_ID,';
			$sql .= '					   						             P_CHAVE  =>  :P_CHAVE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PESQUISA_ID',$arguments['pesquisa_id'],4000);
			oci_bind_by_name($stmt,':P_CHAVE',$arguments['chave'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pesquisa executada!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Aug 24 11:13:24 UTC-0300 2012
		 * Insere um recado no mural
		 */
		function ins_recado_mural($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				
			if(strlen(trim($arguments['url_arquivo']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $_SESSION['cod_portal'],
																		    path => '/Mural/',
																	   no_commit => 1));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(cod_portal => $_SESSION['cod_portal'],
												    url_imagem => $arguments['url_arquivo'],
												  categoria_id => $arguments['categoria'],
														titulo => $arguments['titulo_anexo'],
													  extensao => $arguments['extensao'],
													 no_commit => 1));
													 
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['arquivo_id'] = $ret['foto_id'];
			}
				
				
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_ins_recado_mural(P_MURAL_ID   =>  :P_MURAL_ID,';
			$sql .= '					   							   P_RECADO   =>  :P_RECADO,';
			$sql .= '					   							 P_ANEXO_ID   =>  :P_ANEXO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MURAL_ID',$arguments['mural_id'],4000);
			oci_bind_by_name($stmt,':P_RECADO',$arguments['recado'],4000);
			oci_bind_by_name($stmt,':P_ANEXO_ID',$arguments['arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO_ANEXO',$arguments['titulo_anexo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Recado enviado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Aug 24 11:14:37 UTC-0300 2012
		 * Exclui um recado no mural
		 */
		function del_recado_mural($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_del_recado_mural(P_MURAL_ID   =>  :P_MURAL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MURAL_ID',$arguments['mural_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Recado excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		function upd_foto_funcionario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_alt_foto_funcionario(P_USUARIO  =>  :P_USUARIO,';
			$sql .= '					   							        P_FOTO  =>  :P_FOTO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$_SESSION['usuario'],4000);

			$p_lob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_FOTO',$p_lob,-1,OCI_B_BLOB);
			$binario = file_get_contents($_SERVER['DOCUMENT_ROOT'].$arguments['url_foto']);
			$p_lob->writeTemporary($binario,OCI_TEMP_BLOB);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 29 11:16:49 UTC-0300 2014
		 * Inscrio treinamento
		 */
		function inscricao_treinamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_ins_trein_participante(P_TREINAMENTO_PARTICIPANTE_ID  =>  :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   							         		      P_TREINAMENTO_ID  =>  :P_TREINAMENTO_ID,';
			$sql .= '					   							         		  P_NIVEL_CONHECIMENTO  =>  :P_NIVEL_CONHECIMENTO,';
						$sql .= '					   							              P_RECURSO_ID  =>  :P_RECURSO_ID);';

			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_ID',$arguments['treinamento_id'],4000);
			oci_bind_by_name($stmt,':P_NIVEL_CONHECIMENTO',$arguments['nivel_conhecimento'],4000);
			oci_bind_by_name($stmt,':P_RECURSO_ID',$arguments['recurso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Inscrio realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 29 11:16:49 UTC-0300 2014
		 * Cancelar inscrio
		 */
		function cancelar_inscricao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_del_trein_participante(P_TREINAMENTO_PARTICIPANTE_ID  =>  :P_TREINAMENTO_PARTICIPANTE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Inscrio cancelada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 29 15: UTC-0300 2014
		 * Lista de Presena
		 */
		function lista_presenca($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			$conn = CreateObject("portal._class.consulta.rh");
			$qrParticipante   = $conn->get_participante_treinamento(array(treinamento_id => $arguments['treinamento_id']));			
			
			for($i=0;$i<count($qrParticipante);$i++) {
				if(strlen(trim($arguments['treinamento_participante_id_'.$qrParticipante[$i]['TREINAMENTO_PARTICIPANTE_ID']]))){
					
					$ret = $this->ins_lista_presenca(array(treinamento_participante_id => $qrParticipante[$i]['TREINAMENTO_PARTICIPANTE_ID']
																			 ,presenca => 1
																			,no_commit => 1));
														
					if($ret['erro'] == 'true') 
						return $ret;
				}
			}
			
			
			if($ret['erro'] && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Lista de presena enviada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		function ins_lista_presenca($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();				

			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_lista_presenca(P_TREINAMENTO_PARTICIPANTE_ID  =>  :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   						                        P_PRESENCA  =>  :P_PRESENCA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_PRESENCA',$arguments['presenca'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Lista de presena enviada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 2 17:22:49 UTC-0300 2014
		 * Avaliao de reao
		 */
		function avaliacao_reacao($arguments=array()){ 
		
			if(!isset($arguments['no_commit']))
				$this-> start(); 
				
			
			$conn = CreateObject("portal._class.consulta.rh");
			$qrAssunto = $conn->get_assunto_avaliacao();
			
			for($i=0;$i<count($qrAssunto);$i++) {
				
				$avaliacao_id = $arguments['avaliacao_assunto_'.$qrAssunto[$i]['AVALIACAO_ASSUNTO_ID']];
				
				if(strlen(trim($avaliacao_id))){
					
					$ret = $this->ins_avaliacao_reacao(array(avaliacao_reacao_id => $arguments['avaliacao_reacao_id']
												    ,treinamento_participante_id => $arguments['treinamento_participante_id']
													       		     ,assunto_id => $qrAssunto[$i]['AVALIACAO_ASSUNTO_ID']
																   ,avaliacao_id => $avaliacao_id
																	  ,no_commit => 1));
													
					if($ret['erro'] == 'true') 
						return $ret;
						
				}
			}	
			
			$ret = $this->ins_avaliacao_reacao_obs(array(treinamento_participante_id => $arguments['treinamento_participante_id']
																		 ,observacao => $arguments['observacao']
																		  ,no_commit => 1));
											
			if($ret['erro'] == 'true') 
				return $ret;			
			
			$ret['erro'] = 'true';
				
			if($ret['erro'] && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao enviada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Mon Jun 2 17:22:49 UTC-0300 2014
		 * Avaliao de reao
		 */
		function ins_avaliacao_reacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_avaliacao_reacao(P_AVALIACAO_REACAO_ID =>  :P_AVALIACAO_REACAO_ID,';
			$sql .= '					   					   P_TREINAMENTO_PARTICIPANTE_ID =>  :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   									    P_ASSUNTO_ID =>  :P_ASSUNTO_ID,';
			$sql .= '					   							         P_AVALIACAO_ID  =>  :P_AVALIACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_AVALIACAO_REACAO_ID',$arguments['avaliacao_reacao_id'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_ASSUNTO_ID',$arguments['assunto_id'],4000);
			oci_bind_by_name($stmt,':P_AVALIACAO_ID',$arguments['avaliacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao de reao realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
		/*
		 * Criado em Mon Jun 2 17:22:49 UTC-0300 2014
		 * Avaliao de reao
		 */
		function ins_avaliacao_reacao_obs($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_avaliacao_reacao_obs(P_TREINAMENTO_PARTICIPANTE_ID =>  :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   							           				P_OBSERVACAO =>  :P_OBSERVACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);			
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao de reao realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Mon Jun 2 17:22:49 UTC-0300 2014
		 * Avaliao de reao
		 */
		function avaliacao_aprendizado($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();

			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_avaliacao_aprendizado(P_AVALIACAO_APRENDIZADO_ID => :P_AVALIACAO_APRENDIZADO_ID,';
			$sql .= '					   					  			 P_TREINAMENTO_PARTICIPANTE_ID => :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   									   			 P_COMPETENCIA => :P_COMPETENCIA,';
			$sql .= '					   									     P_NIVEL_APRIMORAMENTO => :P_NIVEL_APRIMORAMENTO,';
			$sql .= '					   									    			 P_PRATICA => :P_PRATICA,';
			$sql .= '					   									   		   P_MULTIPLICADOR => :P_MULTIPLICADOR,';
			$sql .= '					   							         			   P_EVIDENCIA => :P_EVIDENCIA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);			
			oci_bind_by_name($stmt,':P_AVALIACAO_APRENDIZADO_ID',$arguments['avaliacao_aprendizado_id'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_COMPETENCIA',substr($arguments['competencia'],0,-1),4000);
			oci_bind_by_name($stmt,':P_NIVEL_APRIMORAMENTO',$arguments['nivel_aprimoramento'],4000);
			oci_bind_by_name($stmt,':P_PRATICA',$arguments['pratica'],4000);
			oci_bind_by_name($stmt,':P_MULTIPLICADOR',$arguments['multiplicador'],4000);
			oci_bind_by_name($stmt,':P_EVIDENCIA',$arguments['evidencia'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao de aprendizagem realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
		
		/*
		 * Criado em Mon Jun 2 17:22:49 UTC-0300 2014
		 * Avaliao de reao
		 */
		function avaliacao_resultado($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	qualidade.pkg_treinamento.prc_avaliacao_resultado(P_AVALIACAO_RESULTADO_ID => :P_AVALIACAO_RESULTADO_ID,';
			$sql .= '					   					         P_TREINAMENTO_PARTICIPANTE_ID => :P_TREINAMENTO_PARTICIPANTE_ID,';
			$sql .= '					   									    		P_NIVEL_ID => :P_NIVEL_ID,';
			$sql .= '					   									   			P_EFICACIA => :P_EFICACIA,';
			$sql .= '					   									    	P_EVIDENCIA_ID => :P_EVIDENCIA_ID,';
			$sql .= '					   							         		   P_EVIDENCIA => :P_EVIDENCIA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_AVALIACAO_RESULTADO_ID',$arguments['avaliacao_resultado_id'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_PARTICIPANTE_ID',$arguments['treinamento_participante_id'],4000);
			oci_bind_by_name($stmt,':P_NIVEL_ID',$arguments['nivel_id'],4000);
			oci_bind_by_name($stmt,':P_EFICACIA',$arguments['eficacia'],4000);
			oci_bind_by_name($stmt,':P_EVIDENCIA_ID',$arguments['evidencia_id'],4000);
			oci_bind_by_name($stmt,':P_EVIDENCIA',$arguments['evidencia'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao de resultado realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
			
		/*
		 * Criado em Thu Aug 23 11:27:41 UTC-0300 2012
		 * Responder questionrio de pesquisas
		 */
		function ins_questionario_entrevista($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
		
			$connRH = CreateObject("portal._class.consulta.rh");
			$qrP   = $connRH->get_pergunta_entrevista(array(entrevista_id => $arguments['entrevista_id']));
			
			for($i=0;$i<count($qrP);$i++) {
				
				if($qrP[$i]['PERGUNTA_TIPO'] == 1 && strlen(trim($qrP[$i]['ENTREVISTA_PERGUNTA_ID']))){ //Radiobutton				
					$ret = $this->ins_resposta_ENTREVISTA(array(ENTREVISTA_id 		  => $arguments['entrevista_id']
															,ENTREVISTA_resposta_id => $arguments['resposta_'.$qrP[$i]['ENTREVISTA_PERGUNTA_ID']]
															,descricao 			  => ''
															,ENTREVISTA_pergunta_id => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
															,setor 				  => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
															,no_commit 			  => 1));
					
				} else if($qrP[$i]['PERGUNTA_TIPO'] == 2){ //Checkbox
				
					$qrR = $connRH->get_resposta_ENTREVISTA(array(ENTREVISTA_pergunta_id => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']));		
					
					for($k = 0; $k < count($qrR); $k++) {			
						
						if(strlen(trim($arguments['resposta_'.$qrR[$k]['ENTREVISTA_RESPOSTA_ID'].'_'.$qrP[$i]['ENTREVISTA_PERGUNTA_ID']]))){
							$ret = $this->ins_resposta_ENTREVISTA(array(ENTREVISTA_id 		  => $arguments['entrevista_id']
																	,ENTREVISTA_resposta_id => $arguments['resposta_'.$qrR[$k]['ENTREVISTA_RESPOSTA_ID'].'_'.$qrP[$i]['ENTREVISTA_PERGUNTA_ID']]
																	,descricao 			  => ''
																	,ENTREVISTA_pergunta_id => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
																	,setor				  => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
																	,no_commit 			  => 1));
						}
					}
					
				} else if($qrP[$i]['PERGUNTA_TIPO'] == 3 && strlen(trim($qrP[$i]['ENTREVISTA_PERGUNTA_ID']))){ //Textarea
					$ret = $this->ins_resposta_ENTREVISTA(array(ENTREVISTA_id 		  => $arguments['entrevista_id']
															,ENTREVISTA_resposta_id => ''
															,descricao 			  => $arguments['resposta_'.$qrP[$i]['ENTREVISTA_PERGUNTA_ID']]
															,ENTREVISTA_pergunta_id => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
															,setor			      => $qrP[$i]['ENTREVISTA_PERGUNTA_ID']
															,no_commit 			  => 1));
				}
														
				if($ret['erro'] == 'true') 
					return $ret;										
			}
			
			if($ret['erro'] && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			return $arguments;	
		}
		/*
		 * Criado em Thu Aug 23 11:27:41 UTC-0300 2012
		 * Responder questionrio de entrevistas
		 */
		function ins_resposta_entrevista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	avaliacao.pkg_avaliacao.prc_ins_ENTREVISTA_resposta(P_ENTREVISTA_ID  =>  :P_ENTREVISTA_ID,';
			$sql .= '					   									    P_DESCRICAO  =>  :P_DESCRICAO,';
			$sql .= '					   						   P_ENTREVISTA_RESPOSTA_ID  =>  :P_ENTREVISTA_RESPOSTA_ID,';
			$sql .= '					   						   P_ENTREVISTA_PERGUNTA_ID	 =>  :P_ENTREVISTA_PERGUNTA_ID);';
			$sql .= 'END;';
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ENTREVISTA_ID',$arguments['entrevista_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ENTREVISTA_RESPOSTA_ID',$arguments['entrevista_resposta_id'],4000);
			oci_bind_by_name($stmt,':P_ENTREVISTA_PERGUNTA_ID',$arguments['entrevista_pergunta_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Entrevista realizada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				

	}//fecha classe
	
	global $conexao_banco;
	$RHObj = new RHMan($conexao_banco);
	
}// fecha if

global $createdObject;
$createdObject = $RHObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>