<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $RadioManipulacaoObj;
if(!$RadioManipulacaoObj) {
	class RadioManipulacao extends QueryCom {
	
		 /*
			 * Criado em Tue Jul 29 14:13:07 UTC-0300 2008
			 * Inserir Msicas no banco
		 */
		function ins_musica($arguments=array()){
			new dbug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_musica(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_ARTISTA	       =>  :P_ARTISTA,';
			$sql .= '					   P_ALBUM	       =>  :P_ALBUM,';
			$sql .= '					   P_LETRA	       =>  :P_LETRA,';
			$sql .= '					   P_MUSICA_ID	       =>  :P_MUSICA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_ARTISTA',$arguments['artista'],4000);
			oci_bind_by_name($stmt,':P_ALBUM',$arguments['album'],4000);
			oci_bind_by_name($stmt,':P_LETRA',$arguments['letra'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				if(isset($arguments['cd_id'])){
					$ret2 = $this->ins_cd_musica(array(musica_id 	=> $arguments['musica_id'],
														cd_id		=> $arguments['cd_id'],
														ordem		=> $arguments['ordem'],
														no_commit	=> 1
													  ));
					if($ret2['erro'] == 'true')
						return $ret2;
				}
				
				
				$conn2 = CreateObject("portal._class.manipulacao.site");
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');
				$v_ordem = listatoarray($arguments,'videos_ordem_videos');
				
				// Vincula a imagem ao filme
				for($i=0;$i<count($v_cod_video);$i++){
					$ret = $conn2->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
					if($ret['erro'] == 'true') 
						return $ret;
						
						
					$ret2 = $this->ins_musica_video(array(
											musica_id		=> $arguments['musica_id'],
											video_id		=> $ret['video_id'],
											cod_video		=> $v_cod_video[$i],
											titulo			=> $v_titulo[$i],
											legenda			=> $v_legenda[$i],
											descricao		=> $v_descricao[$i],
											credito			=> $v_credito[$i],
											ordem			=> $v_ordem[$i],
											no_commit		=> 1
											));
	
					if($ret2['erro'] == 'true') 
						return $ret2;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Msica cadastrada com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim ins_musica
		
		/*
		 * Criado em Tue Jul 29 16:09:51 UTC-0300 2008
		 * Alterar uma msica cadastrada
		 */
		function upd_musica($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_alt_musica(P_MUSICA_ID   =>  :P_MUSICA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_ARTISTA	       =>  :P_ARTISTA,';
			$sql .= '					   P_ALBUM	       =>  :P_ALBUM,';
			$sql .= '					   P_LETRA	       =>  :P_LETRA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_ARTISTA',$arguments['artista'],4000);
			oci_bind_by_name($stmt,':P_ALBUM',$arguments['album'],4000);
			oci_bind_by_name($stmt,':P_LETRA',$arguments['letra'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				// Busca os videos cadastrados para identificar quais precisam ser excluidos
				$conn = CreateObject("portal._class.consulta.radio");
				$qrMusicaVideo = $conn->get_musica_video(array(musica_id => $arguments['musica_id'],
															   cod_portal => $_SESSION['cod_portal']));

				$conn2 = CreateObject("portal._class.manipulacao.site");
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');
				$v_ordem = listatoarray($arguments,'videos_ordem_videos');

				for($i=0;$i<count($qrMusicaVideo);$i++) {
					if(array_search($qrMusicaVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_musica_video(array(
											musica_id  => $arguments['musica_id'],
											video_id  => $qrMusicaVideo[$i]['VIDEO_ID'],
											no_commit => 1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}
				
				$conn2 = CreateObject("portal._class.manipulacao.site");
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');
				$v_ordem = listatoarray($arguments,'videos_ordem_videos');
				
				// Vincula a imagem ao filme
				for($i=0;$i<count($v_cod_video);$i++){
					if(!strlen(trim($v_video_id[$i]))) {
						$ret = $conn2->ins_video(array(
													cod_portal		=> $_SESSION['cod_portal'],
													cod_video		=> $v_cod_video[$i],
													titulo			=> $v_titulo[$i],
													legenda			=> $v_legenda[$i],
													descricao		=> $v_descricao[$i],
													credito			=> $v_credito[$i],
													duracao			=> $v_duracao[$i],
													no_commit		=> 1											
													));
						if($ret['erro'] == 'true') 
							return $ret;
							
							
						$ret2 = $this->ins_musica_video(array(
												musica_id		=> $arguments['musica_id'],
												video_id		=> $ret['video_id'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
		
						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Msica Alterada com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim  upd_musica
		
		/*
		 * Criado em Tue Jul 29 16:12:40 UTC-0300 2008
		 * Deletar uma msica cadastrada
		 */
		function del_musica($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_musica(P_MUSICA_ID   =>  :P_MUSICA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Msica excluda com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim del_musica
		
		/*
		 * Criado em Wed Jul 30 13:56:30 UTC-0300 2008
		 * Inserir um Top Hit
		 */
		function ins_top_hits($arguments=array()){
			if( $arguments['concluido'] == '' ){
				$arguments['concluido']= 0;
			}
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_top_hits(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_CONCLUIDO	       =>  :P_CONCLUIDO,';
			$sql .= '					   P_TOP_ID	       =>  :P_TOP_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_CONCLUIDO',$arguments['concluido'],4000);
			oci_bind_by_name($stmt,':P_TOP_ID',$arguments['top_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
					$v_musica = listatoarray($arguments,'musica_id_top');
					$v_top = listatoarray($arguments,'top_id_top');
					$v_ordem = listatoarray($arguments,'ordem_top');
					
				for($i=0;$i<count($v_musica);$i++) {
					if(strlen(trim($v_musica[$i]))) {
						$ret = $this->ins_top_hits_musica(array(
															ordem    => $v_ordem[$i],
															musica_id => $v_musica[$i],
															top_id => $arguments['top_id'],   
															no_commit	=> 1
														));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Top Hit cadastrado com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim ins_top_hits
		
		/*
		 * Criado em Wed Jul 30 18:41:24 UTC-0300 2008
		 * Alterar Top Hits
		 */
		function upd_top_hits($arguments=array()){
			if( $arguments['concluido'] == '' ){
					$arguments['concluido']= 0;
			}
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_alt_top_hits(P_TOP_ID   =>  :P_TOP_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_CONCLUIDO	       =>  :P_CONCLUIDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOP_ID',$arguments['top_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_CONCLUIDO',$arguments['concluido'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				$v_musica_id = listatoarray($arguments,'musica_id_top');
				$v_top_id = listatoarray($arguments,'top_id_top');
				$v_ordem = listatoarray($arguments,'ordem_top');
				
				$connRadio = CreateObject("portal._class.consulta.radio");
				$qrMusica = $connRadio->get_top_hit_musica(array(top_id => $arguments['top_id']));
				
				//exclui as msicas do top hit que foram excludas da lista
				for($i=0;$i<count($qrMusica);$i++) {				
					if(array_search($qrMusica[$i]['MUSICA_ID'],$v_musica_id) === false) {
						$ret = $this->del_top_hits_musica(array(top_id => $arguments['top_id'],
																  musica_id => $qrMusica[$i]['MUSICA_ID'],  
																 no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_musica_id);$i++) {
						$ret = $this->ins_top_hits_musica(array(
															ordem    => $v_ordem[$i],
															musica_id => $v_musica_id[$i],
															top_id => $arguments['top_id'],   
															no_commit	=> 1
														));
						if($ret['erro'] == 'true')
							return $ret;
				}
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Top Hit alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim upd_top_hits
		
		/*
		 * Criado em Thu Jul 31 10:30:00 UTC-0300 2008
		 * Deletar Um Top Hit
		 */
		function del_top_hits($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_top_hits(P_TOP_ID   =>  :P_TOP_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOP_ID',$arguments['top_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Top Hit deletado com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim del_top_hits
		
		/*
		 * Criado em Wed Jul 30 14:56:28 UTC-0300 2008
		 * Inserir Msica dos Top Hits
		 */
		function ins_top_hits_musica($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_top_hits_musica(P_TOP_ID   =>  :P_TOP_ID,';
			$sql .= '					   P_MUSICA_ID	       =>  :P_MUSICA_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOP_ID',$arguments['top_id'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Musicas Cadastradas com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim ins_top_hits_musica
		
		/*
		 * Criado em Thu Jul 31 10:33:27 UTC-0300 2008
		 * Deletar Musicas de determinado Top Hit
		 */
		function del_top_hits_musica($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_top_hits_musica(P_TOP_ID   =>  :P_TOP_ID,';
			$sql .= '					   P_MUSICA_ID	       =>  :P_MUSICA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOP_ID',$arguments['top_id'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}

		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Musicas excludas com Sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}//fim del_top_hits_musica
		
		
/************************************************** INSERE UM CD *********************************************************		
		
		/*
		 * Criado em Tue Aug 26 14:28:35 UTC-0300 2008
		 * Insere um Cd
		 */
		function ins_cd($arguments=array()){

			//Copia arquivo temporario para pasta permanente
			$parts = array_reverse(explode(".",$arguments['url_imagem']));
			$extensao = strtolower($parts[0]);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/',0775,true);
			$count = 0;
			
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao."_arquivo".$count.".".$extensao)) {
				$count++;
			}
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao);
			$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao));
		
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_cd(P_ARTISTA   =>  :P_ARTISTA,';
			$sql .= '					   P_ALBUM	       =>  :P_ALBUM,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_GENERO	       =>  :P_GENERO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= ' 					   P_GRAVADORA		=>  :P_GRAVADORA,';
			$sql .= ' 					   P_AO_VIVO		=>  :P_AO_VIVO,';
			$sql .= ' 					   P_RECOMENDADO	=>  :P_RECOMENDADO,';
			$sql .= '					   P_CD_ID	       =>  :P_CD_ID);';
			$sql .= 'END;';
		
		
			if(!strlen(trim($arguments['ao_vivo'])))	
				$arguments['ao_vivo'] = 0;
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ARTISTA',$arguments['artista'],4000);
			oci_bind_by_name($stmt,':P_ALBUM',$arguments['album'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_GENERO',$arguments['genero'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_GRAVADORA',$arguments['gravadora'],4000);
			oci_bind_by_name($stmt,':P_AO_VIVO',$arguments['ao_vivo'],4000);
			oci_bind_by_name($stmt,':P_CD_ID',$arguments['cd_id'],4000);
			oci_bind_by_name($stmt,':P_RECOMENDADO',$arguments['recomendado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			new dBug($arguments);
		
			if($sucesso){
				$musicas = listatoarray($arguments,"titulo_cd");
				$ordem	 = listatoarray($arguments,"ordem_cd");
				new dBug($ordem);


				for($i=0;$i<count($musicas);$i++){
					$ret = $this->ins_musica(array(titulo => $musicas[$i],
												   artista => $arguments['artista'],
												   album	=> $arguments['album'],
												   letra	=> '',
												   cod_portal => $arguments['cod_portal'],
												   cd_id	=> $arguments['cd_id'],
												   ordem	=> $ordem[$i],
												   no_commit => 1
												));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}

			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "CD Inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Aug 26 14:29:33 UTC-0300 2008
		 * Altera um Cd
		 */
		function upd_cd($arguments=array()){
				
			if($arguments['temporario'] == '1'){
				//Copia arquivo temporario para pasta permanente
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/',0775,true);
				$count = 0;
				
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao."_arquivo".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/radio/cd/arquivo/'.$extensao.'_arquivo'.$count.".".$extensao));			
			}
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_alt_cd(P_CD_ID   =>  :P_CD_ID,';
			$sql .= '					   P_ARTISTA	       =>  :P_ARTISTA,';
			$sql .= '					   P_ALBUM	       =>  :P_ALBUM,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_GENERO	       =>  :P_GENERO,';
			$sql .= ' 					   P_GRAVADORA		=>  :P_GRAVADORA,';
			$sql .= ' 					   P_AO_VIVO		=>  :P_AO_VIVO,';
			$sql .= ' 					   P_RECOMENDADO	=>	:P_RECOMENDADO);';
			$sql .= 'END;';
		
			if(!strlen(trim($arguments['ao_vivo'])))	
				$arguments['ao_vivo'] = 0;
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CD_ID',$arguments['cd_id'],4000);
			oci_bind_by_name($stmt,':P_ARTISTA',$arguments['artista'],4000);
			oci_bind_by_name($stmt,':P_ALBUM',$arguments['album'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_GENERO',$arguments['genero'],4000);
			oci_bind_by_name($stmt,':P_GRAVADORA',$arguments['gravadora'],4000);
			oci_bind_by_name($stmt,':P_AO_VIVO',$arguments['ao_vivo'],4000);
			oci_bind_by_name($stmt,':P_RECOMENDADO',$arguments['recomendado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);			
		
			if($sucesso){
				$conn = CreateObject("portal._class.consulta.radio");
				$qrM = $conn->get_cd_musica(array(cod_portal => $arguments['cod_portal'],
												  cd_id		 => $arguments['cd_id']
												 ));
							
				//APAGA AS MSICAS				
				for($i=0;$i<count($qrM);$i++){
					$retM = $this->del_musica(array(musica_id =>  $qrM[$i]['MUSICA_ID'],
													no_commit => 1
												  ));
					if($retM['erro'] == 'true')
						return $retM;
				}

				$musicas = listatoarray($arguments,"titulo_cd");
				$ordem	 = listatoarray($arguments,"ordem_cd");	

				for($i=0;$i<count($musicas);$i++){
					$ret2 = $this->ins_musica(array(titulo => $musicas[$i],
												   artista => $arguments['artista'],
												   album	=> $arguments['album'],
												   letra	=> '',
												   cod_portal => $arguments['cod_portal'],
												   cd_id	=> $arguments['cd_id'],
												   ordem	=> $ordem[$i],
												   no_commit => 1
												));
					if($ret2['erro'] == 'true')
						return $ret2;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "CD alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Aug 26 14:30:16 UTC-0300 2008
		 * Exclui um Cd
		 */
		function del_cd($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_cd(P_CD_ID   =>  :P_CD_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CD_ID',$arguments['cd_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "CD excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
/******************************************** VINCULA MSICA A UM CD *******************************************/		
		
		/*
		 * Criado em Tue Aug 26 16:00:46 UTC-0300 2008
		 * Insere uma msica a um cd
		 */
		function ins_cd_musica($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_cd_musica(P_MUSICA_ID   =>  :P_MUSICA_ID,';
			$sql .= '					   P_CD_ID	       =>  :P_CD_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_MUSICA_CD_ID	       =>  :P_MUSICA_CD_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_CD_ID',$arguments['cd_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_CD_ID',$arguments['musica_cd_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Msica inserida com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 26 15:28:53 UTC-0300 2008
		 * Exclui uma msica a um cd
		 */
		function del_cd_musica($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_cd_musica(P_CD_ID	       =>  :P_CD_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CD_ID',$arguments['cd_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Msica excluda com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
/************************************* VINCULA MSICA AO CLIP ***************************************************/

	
		/*
		 * Criado em Thu Nov 20 15:59:11 UTC-0300 2008
		 * Insere um vdeo de uma msica
		 */
		function ins_musica_video($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_ins_musica_video(P_MUSICA_ID   =>  :P_MUSICA_ID,';
			$sql .= '					   P_COD_VIDEO	       =>  :P_COD_VIDEO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID,';
			$sql .= '					   P_ORDEM		       =>  :P_ORDEM,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_MUSICA_VIDEO_ID	       =>  :P_MUSICA_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_COD_VIDEO',$arguments['cod_video'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_VIDEO_ID',$arguments['musica_video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vdeo inseridocom sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Thu Nov 20 15:58:04 UTC-0300 2008
		 * Altera um vdeo de uma msica
		 */
		function upd_musica_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_alt_musica_video(P_MUSICA_VIDEO_ID   =>  :P_MUSICA_VIDEO_ID,';
			$sql .= '					   P_MUSICA_ID	       =>  :P_MUSICA_ID,';
			$sql .= '					   P_COD_VIDEO	       =>  :P_COD_VIDEO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID,';
			$sql .= '					   P_ORDEM		       =>  :P_ORDEM,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_VIDEO_ID',$arguments['musica_video_id'],4000);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_COD_VIDEO',$arguments['cod_video'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vdeo alterado com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
	
		/*
		 * Criado em Thu Nov 20 15:59:50 UTC-0300 2008
		 * Exclui um vdeo de uma msica
		 */
		function del_musica_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_musica_video(P_MUSICA_ID   =>  :P_MUSICA_ID,';
			$sql .= '					   					  P_VIDEO_ID     =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vdeo excludo com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Nov 20 16:00:36 UTC-0300 2008
		 * Exclui todos os vdeos de uma msica
		 */
		function del_musica_video_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_musica.prc_del_musica_video_all(P_MUSICA_ID   =>  :P_MUSICA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MUSICA_ID',$arguments['musica_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vdeos excludo com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Nov 26 11:34:49 UTC-0300 2008
		 * Insere um torpedo
		 */
		function ins_torpedo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_radio.prc_ins_torpedo(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_ASSUNTO	       =>  :P_ASSUNTO,';
			$sql .= '					   P_MENSAGEM	       =>  :P_MENSAGEM,';
			$sql .= '					   P_STATUS	       =>  :P_STATUS,';
			$sql .= '					   P_BLOQUEADO	       =>  :P_BLOQUEADO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_TORPEDO_ID	       =>  :P_TORPEDO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ASSUNTO',$arguments['assunto'],4000);
			oci_bind_by_name($stmt,':P_MENSAGEM',$arguments['mensagem'],4000);
			oci_bind_by_name($stmt,':P_STATUS',$arguments['status'],4000);
			oci_bind_by_name($stmt,':P_BLOQUEADO',$arguments['bloqueado'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TORPEDO_ID',$arguments['torpedo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Torpedo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Nov 26 11:36:35 UTC-0300 2008
		 * Altera status do torpedo
		 */
		function upd_torpedo_status($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_radio.prc_alt_torpedo_status(P_TORPEDO_ID   =>  :P_TORPEDO_ID,';
			$sql .= '					   P_STATUS	       =>  :P_STATUS);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TORPEDO_ID',$arguments['torpedo_id'],4000);
			oci_bind_by_name($stmt,':P_STATUS',$arguments['status'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Torpedo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Nov 26 11:37:17 UTC-0300 2008
		 * Altera bloqueio do torpedo
		 */
		function upd_torpedo_bloqueio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	radio.pkg_radio.prc_alt_torpedo_bloqueio(P_TORPEDO_ID   =>  :P_TORPEDO_ID,';
			$sql .= '					   P_BLOQUEADO	       =>  :P_BLOQUEADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TORPEDO_ID',$arguments['torpedo_id'],4000);
			oci_bind_by_name($stmt,':P_BLOQUEADO',$arguments['bloqueado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Torpedo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	/*Final das Funes*/
	}
	global $conexao_banco;
	$RadioManipulacaoObj = new RadioManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $RadioManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}


?>