<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ProdutoManipulacaoObj;
if(!$ProdutoManipulacaoObj) {
	class ProdutoManipulacao extends QueryCom {

		/*
		 * Criado em Thu Sep 4 09:08:14 UTC-0300 2008
		 * Insere selo
		 */
		function prc_ins_selo($arguments=array()){
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Selos/',
																   no_commit => 1
																 ));
			if($ret['erro'] == 'true')
				return $ret;
			
			$arguments['categoria_id'] = $ret['categoria_id'];
			
			$ret = $connSiteMan->ins_foto(array(
								cod_portal		=> $arguments['cod_portal'],								
								url_imagem		=> $arguments['url_imagem'],
								categoria_id	=> $arguments['categoria_id'],
								titulo		    => $arguments['titulo_logotipo'],
								no_commit 		=> 1
								));
			if($ret['erro'] == 'true') 
				return $ret;
				
			$arguments['foto_id'] = $ret['foto_id'];
		
				
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_selo(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_SELO_ID	       =>  :P_SELO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);	
			
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_SELO_ID',$arguments['selo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Selo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Sep 4 09:13:14 UTC-0300 2008
		 * Altera selo
		 */
		function prc_upd_selo($arguments=array()){
			
			if($arguments['temporario'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Selos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_selo(P_SELO_ID   =>  :P_SELO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SELO_ID',$arguments['selo_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
			
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Selo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Sep 4 09:14:08 UTC-0300 2008
		 * Exclui Selo
		 */
		function prc_del_selo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_selo(P_SELO_ID   =>  :P_SELO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SELO_ID',$arguments['selo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Selo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
					
			
		
		/*
		 * Criado em Fri Sep 5 17:58:58 UTC-0300 2008
		 * Insere um produto
		 */
		function ins_produto($arguments=array()){
			
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
			if($arguments['logo_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Logotipos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_logo'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_id'] = $ret['foto_id'];
			}
			
			if($arguments['inst_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Institucionais/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_institucional'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['institucional_id'] = $ret['foto_id'];
			}
			
			if($arguments['logo_detalhes_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Logotipos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_logo_detalhes'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_detalhes_id'] = $ret['foto_id'];
			}
			
			// Realiza o upload da ficha tcnica para o Banco
			if($arguments['ficha_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $arguments['url_ficha'],
											no_commit		=> 1,
											));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['ficha_id'] = $ret['arquivo_id'];
			}
			
			// Realiza o upload da documentao para o Banco			
			if($arguments['doc_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $arguments['url_docto'],
											no_commit		=> 1,
											));
				if($ret['erro'] == 'true')
					return $ret;
					
				$arguments['documento_id'] = $ret['arquivo_id'];
			}
			
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto(P_LOGO_ID   =>  :P_LOGO_ID,';
			$sql .= '					   P_LOGO_DETALHES_ID	       =>  :P_LOGO_DETALHES_ID,';
			$sql .= '					   P_INSTITUCIONAL_ID	       =>  :P_INSTITUCIONAL_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_LANCAMENTO	       =>  :P_LANCAMENTO,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_FICHA_ID	       =>  :P_FICHA_ID,';
			$sql .= '					   P_DOCUMENTO_ID      =>  :P_DOCUMENTO_ID,';
			$sql .= '					   P_ORDEM      =>  :P_ORDEM,';
			$sql .= '					   P_PRODUTO_ID	       =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LOGO_ID',$arguments['logo_id'],4000);
			oci_bind_by_name($stmt,':P_LOGO_DETALHES_ID',$arguments['logo_detalhes_id'],4000);
			oci_bind_by_name($stmt,':P_INSTITUCIONAL_ID',$arguments['institucional_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_LANCAMENTO',$arguments['lancamento'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_FICHA_ID',$arguments['ficha_id'],4000);
			oci_bind_by_name($stmt,':P_DOCUMENTO_ID',$arguments['documento_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem_produto'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);			
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//INSERE, NOME, DESCRICAO, E SUBTITULO REFERENTE AO IDIOMA
				$idiomas = explode(",",$arguments['idiomas']);				
				$nome = listatoarray($arguments,"nome");
				$subtitulo = listatoarray($arguments,"subtitulo");
				$descricao = listatoarray($arguments,"descricao");
				$instalacao = listatoarray($arguments,"instalacao");
				
				
				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_produto_idioma(array(produto_id => $arguments['produto_id'],
														  idioma_id => $idiomas[$i],
														  nome		=> $nome[$i],
														  subtitulo => $subtitulo[$i],
														  descricao => $descricao[$i],
														  instalacao => $instalacao[$i],
														  no_commit => 1
														 ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE ATRIBUTOS 
				$atributo = listatoarray($arguments,"atributo_id_atributo");
				$valor	  = listatoarray($arguments,"valor_atributo");
				$ordem	  = listatoarray($arguments,"ordem_atributo");
				
				
				
				for($i=0;$i<count($atributo);$i++){
					$ret = $this->ins_produto_atributo(array(produto_id => $arguments['produto_id'],
															atributo_id	=> $atributo[$i],															
															valor		=> $valor[$i],
															ordem		=> $ordem[$i],
															no_commit	=> 1
														  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE AS CORES DO PRODUTO
				$cor = listatoarray($arguments,"cor_id_cor");
				$cor_ordem = listatoarray($arguments,"ordem_cor");
				
				for($i=0;$i<count($cor);$i++){
					$ret = $this->ins_produto_cor(array(produto_id => $arguments['produto_id'],
														cor_id => $cor[$i],
														ordem => $cor_ordem[$i],
														no_commit => 1
													));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE OS SELOS DO PRODUTO
				$selo = listatoarray($arguments,"selo_id_selo");
				for($i=0;$i<count($selo);$i++){
					$ret = $this->ins_produto_selo(array(produto_id => $arguments['produto_id'],
														 selo_id  	=> $selo[$i],
														 no_commit => 1
													   ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 5 17:59:59 UTC-0300 2008
		 * Altera um produto
		 */
		function upd_produto($arguments=array()){			
			
			if(!isset($arguments['no_commit']))			
				$this-> start();
				
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
			if($arguments['logo_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Logotipos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_logo'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_id'] = $ret['foto_id'];
			}
			
			if($arguments['inst_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Institucionais/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_institucional'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['institucional_id'] = $ret['foto_id'];
			}
			
			if($arguments['logo_detalhes_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Logotipos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_logo_detalhes'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_detalhes_id'] = $ret['foto_id'];
			}
			
			// Realiza o upload da ficha tcnica para o Banco
			if($arguments['ficha_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $arguments['url_ficha'],
											no_commit		=> 1,
											));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['ficha_id'] = $ret['arquivo_id'];
			}
			
			// Realiza o upload da documentao para o Banco			
			if($arguments['doc_tmp'] == 1){
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $arguments['url_docto'],
											no_commit		=> 1,
											));
				if($ret['erro'] == 'true')
					return $ret;
					
				$arguments['documento_id'] = $ret['arquivo_id'];
			}
				
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_produto(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_LOGO_ID	       =>  :P_LOGO_ID,';
			$sql .= '					   P_LOGO_DETALHES_ID	       =>  :P_LOGO_DETALHES_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_LANCAMENTO	       =>  :P_LANCAMENTO,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_FICHA_ID	       =>  :P_FICHA_ID,';
			$sql .= '					   P_DOCUMENTO_ID      =>  :P_DOCUMENTO_ID,';
			$sql .= '					   P_ORDEM      =>  :P_ORDEM,';
			$sql .= '					   P_INSTITUCIONAL_ID	       =>  :P_INSTITUCIONAL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_LOGO_ID',$arguments['logo_id'],4000);
			oci_bind_by_name($stmt,':P_LOGO_DETALHES_ID',$arguments['logo_detalhes_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_LANCAMENTO',$arguments['lancamento'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_FICHA_ID',$arguments['ficha_id'],4000);
			oci_bind_by_name($stmt,':P_DOCUMENTO_ID',$arguments['documento_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem_produto'],4000);
			oci_bind_by_name($stmt,':P_INSTITUCIONAL_ID',$arguments['institucional_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//EXCLUI ATRIBUTOS DE IDIOMA
				$ret = $this->del_produto_idioma_all(array(produto_id => $arguments['produto_id'],
													       no_commit  => 1
													 ));
				if($ret['erro'] == 'true')
					return $ret;			
				//EXCLUI ATRIBUTOS
				$ret = $this->del_produto_atributo_all(array(produto_id => $arguments['produto_id'],
															 no_commit => 1
															 ));
				if($ret['erro'] == 'true')
					return $ret;
				//EXCLUI CORES
				$ret = $this->del_produto_cor_all(array(produto_id => $arguments['produto_id'],
														no_commit => 1
													 ));
				if($ret['erro'] == 'true')
					return $ret;
				//EXCLUI SELOS
				$ret = $this->del_produto_selo_all(array(produto_id => $arguments['produto_id'],
														 no_commit => 1
													 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				//INSERE, NOME, DESCRICAO, E SUBTITULO REFERENTE AO IDIOMA
				$idiomas = explode(",",$arguments['idiomas']);
				$nome = listatoarray($arguments,"nome");
				$subtitulo = listatoarray($arguments,"subtitulo");
				$descricao = listatoarray($arguments,"descricao");
				$instalacao = listatoarray($arguments,"instalacao");
				
				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_produto_idioma(array(produto_id => $arguments['produto_id'],
														  idioma_id => $idiomas[$i],
														  nome		=> $nome[$i],
														  subtitulo => $subtitulo[$i],
														  descricao => $descricao[$i],
														  instalacao => $instalacao[$i],
														  no_commit => 1
														 ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE ATRIBUTOS 
				$atributo = listatoarray($arguments,"atributo_id_atributo");
				$valor	  = listatoarray($arguments,"valor_atributo");
				$ordem	  = listatoarray($arguments,"ordem_atributo");
				
				for($i=0;$i<count($atributo);$i++){
					$ret = $this->ins_produto_atributo(array(produto_id => $arguments['produto_id'],
															atributo_id	=> $atributo[$i],
															valor		=> $valor[$i],
															ordem		=> $ordem[$i],
															no_commit	=> 1
														  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE AS CORES DO PRODUTO
				$cor = listatoarray($arguments,"cor_id_cor");
				$cor_ordem = listatoarray($arguments,"ordem_cor");
				
				for($i=0;$i<count($cor);$i++){
					$ret = $this->ins_produto_cor(array(produto_id => $arguments['produto_id'],
														cor_id => $cor[$i],
														ordem => $cor_ordem[$i],
														no_commit => 1
													));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//INSERE OS SELOS DO PRODUTO
				$selo = listatoarray($arguments,"selo_id_selo");
				for($i=0;$i<count($selo);$i++){
					$ret = $this->ins_produto_selo(array(produto_id => $arguments['produto_id'],
														 selo_id  	=> $selo[$i],
														 no_commit => 1
													   ));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

	
		/*
		 * Criado em Fri Sep 5 18:00:45 UTC-0300 2008
		 * Exclui um produto
		 */
		function del_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 25 16:04:03 UTC-0300 2008
		 * Insere os dados de um produto para um idioma
		 */
		function ins_produto_idioma($arguments=array()){
			
			if($arguments['instalacao'] == "")
				$arguments['instalacao'] = " ";
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_idioma(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_SUBTITULO	       =>  :P_SUBTITULO,';
			$sql .= '					   P_INSTALACAO	       =>  :P_INSTALACAO,';
			$sql .= '					   P_PRODUTO_IDIOMA_ID	       =>  :P_PRODUTO_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_SUBTITULO',$arguments['subtitulo'],4000);
			
			if(strlen(trim($arguments['instalacao']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_INSTALACAO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['instalacao']);
			}else
				oci_bind_by_name($stmt,':P_INSTALACAO',$arguments['instalacao'],4000);
			
			oci_bind_by_name($stmt,':P_PRODUTO_IDIOMA_ID',$arguments['produto_idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados Cadastrados com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 25 16:06:22 UTC-0300 2008
		 * Insere os dados de um produto para um idioma
		 */
		function alt_produto_idioma($arguments=array()){
			if($arguments['instalacao'] == "")
				$arguments['instalacao'] = " ";
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_upd_produto_idioma(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_SUBTITULO	       =>  :P_SUBTITULO,';
			$sql .= '					   P_INSTALACAO	       =>  :P_INSTALACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_SUBTITULO',$arguments['subtitulo'],4000);
			
			if(strlen(trim($arguments['instalacao']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_INSTALACAO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['instalacao']);
			}else
				oci_bind_by_name($stmt,':P_INSTALACAO',$arguments['instalacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados Alterados com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 25 16:06:56 UTC-0300 2008
		 * Altera os dados de um produto para um idioma
		 */
		function del_produto_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_idioma(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados Excludos com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Sep 25 16:06:56 UTC-0300 2008
		 * Exclui os dados de um produto para todos idiomas
		 */
		function del_produto_idioma_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_idioma_all(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados Excludos com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:07:09 UTC-0300 2008
		 * Vincula um atributo a um produto
		 */
		function ins_produto_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_atributo(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_ATRIBUTO_ID	       =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_PRODUTO_ATRIBUTO_ID	       =>  :P_PRODUTO_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_VALOR',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['valor']);
			
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ATRIBUTO_ID',$arguments['produto_atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:08:18 UTC-0300 2008
		 * Altera o vinculo de um atributo a um produto
		 */
		function upd_produto_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_produto_atributo(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_ATRIBUTO_ID	       =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_VALOR',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['valor']);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Sep 26 09:12:01 UTC-0300 2008
		 * Exclui o vinculo de um atributo a um produto
		 */
		function del_produto_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_atributo(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_ATRIBUTO_ID	       =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:12:44 UTC-0300 2008
		 * Exclui todos os atributos de um produto
		 */
		function del_produto_atributo_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_atributo_all(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributos excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:30:20 UTC-0300 2008
		 * Vincula uma cor ao produto
		 */
		function ins_produto_cor($arguments=array()){			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_cor(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_COR_ID	       =>  :P_COR_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_PRODUTO_COR_ID	       =>  :P_PRODUTO_COR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_COR_ID',$arguments['produto_cor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor vinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:31:18 UTC-0300 2008
		 * Exclui um vinculo de uma cor ao produto
		 */
		function del_produto_cor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_cor(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_COR_ID	       =>  :P_COR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor desvinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 09:33:03 UTC-0300 2008
		 * Exclui todos vinculos de cores do produto
		 */
		function del_produto_cor_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_cor_all(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Todas as cores desvinculadas com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 10:05:50 UTC-0300 2008
		 * Insere o vinculo de produto com selo
		 */
		function ins_produto_selo($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_selo(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_SELO_ID	       =>  :P_SELO_ID,';
			$sql .= '					   P_PRODUTO_SELO_ID	       =>  :P_PRODUTO_SELO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_SELO_ID',$arguments['selo_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_SELO_ID',$arguments['produto_selo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Selo vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Sep 26 10:06:59 UTC-0300 2008
		 * Exclui o vinculo de produto com selo
		 */
		function del_produto_selo_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_selo_all(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Selo desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 2008 16:53:57 GMT-0200 (Hora oficial do Brasil)
		 * Insere uma cor
		 */
		function ins_cor($arguments=array()){		
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																   path => '/Produtos/Cores/',
																   no_commit => 1
																 ));
			if($ret['erro'] == 'true')
				return $ret;
			
			$arguments['categoria_id'] = $ret['categoria_id'];
			
			$ret = $connSiteMan->ins_foto(array(
								cod_portal		=> $arguments['cod_portal'],								
								url_imagem		=> $arguments['url_imagem'],
								categoria_id	=> $arguments['categoria_id'],
								titulo		    => $arguments['titulo_logotipo'],
								no_commit 		=> 1
								));
			if($ret['erro'] == 'true') 
				return $ret;
				
			$arguments['foto_id'] = $ret['foto_id'];
			
			$connImg = CreateObject("_class.funcoes.imagem");
			$new_url = $connImg->redimensiona_imagem(array(foto_id => $arguments['foto_id'],
															  maxwidth => 90,
															  maxheight => 90
															 ));
			
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/',0775,true);
			// Busca a extensao do arquivo original
			$parts = array_reverse(explode('.',$new_url));
			$extensao = strtolower($parts[0]);
			// Cria um nome unico para o arquivo
			$count = 0;
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/'.$extensao.'_cor'.$count.'.'.$extensao)) {
				$count++;
			}
			$url_arquivo = '/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/'.$extensao.'_cor'.$count.'.'.$extensao;
			// Move o arquivo temporario
			rename($_SERVER['DOCUMENT_ROOT'].$new_url,$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
			//Atribui Permisses
			chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0775);
			
			$arguments['foto_redimensionada'] = $url_arquivo;
			
			
			
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_cor(P_FOTO_ID   =>  :P_FOTO_ID,';
			$sql .= '					   P_FOTO_REDIMENSIONADA =>  :P_FOTO_REDIMENSIONADA,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_COR_ID	       =>  :P_COR_ID);';
			$sql .= 'END;';

			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_REDIMENSIONADA',$arguments['foto_redimensionada'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$idiomas = explode(",",$arguments['idiomas']);
				$nome = listatoarray($arguments,"nome");

				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_cor_idioma(array(cor_id => $arguments['cor_id'],
														idioma_id => $idiomas[$i],
														nome => $nome[$i],
														no_commit => 1
													  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 2008 16:55:04 GMT-0200 (Hora oficial do Brasil)
		 * Altera uma cor
		 */
		function upd_cor($arguments=array()){

			if($arguments['img_tmp'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Cores/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
				
				$connImg = CreateObject("_class.funcoes.imagem");
				$new_url = $connImg->redimensiona_imagem(array(foto_id => $arguments['foto_id'],
																	  maxwidth => 90,
																	  maxheight => 90
																	 ));
				
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/',0775,true);
				// Busca a extensao do arquivo original
				$parts = array_reverse(explode('.',$new_url));
				$extensao = strtolower($parts[0]);
				// Cria um nome unico para o arquivo
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/'.$extensao.'_cor'.$count.'.'.$extensao)) {
					$count++;
				}
				$url_arquivo = '/portal/upload/'.$_SESSION['cod_portal'].'/produto/cor/'.$extensao.'_cor'.$count.'.'.$extensao;
				// Move o arquivo temporario
				rename($_SERVER['DOCUMENT_ROOT'].$new_url,$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
				//Atribui Permisses
				chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0775);
				
				$arguments['foto_redimensionada'] = $url_arquivo;
				
			}
				
			
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_cor(P_COR_ID   =>  :P_COR_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_FOTO_REDIMENSIONADA =>  :P_FOTO_REDIMENSIONADA,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_REDIMENSIONADA',$arguments['foto_redimensionada'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//EXCLUI DADOS DA COR PARA OS IDIOMAS
				$ret = $this->del_cor_idioma_all(array(cor_id => $arguments['cor_id'],
														no_commit => 1
													  ));
				if($ret['erro'] == 'true')
					return $ret;
					
				//INSERE DADOS DA COR PARA OS IDIOMAS
				$idiomas = explode(",",$arguments['idiomas']);
				$nome = listatoarray($arguments,"nome");

				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_cor_idioma(array(cor_id => $arguments['cor_id'],
														idioma_id => $idiomas[$i],
														nome => $nome[$i],
														no_commit => 1
													  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Sep 29 2008 16:55:04 GMT-0200 (Hora oficial do Brasil)
		 * Altera uma cor
		 */
		function upd_cor_foto($arguments=array()){

				
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_cor(P_COR_ID   =>  :P_COR_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_FOTO_REDIMENSIONADA =>  :P_FOTO_REDIMENSIONADA,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_REDIMENSIONADA',$arguments['foto_redimensionada'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 2008 16:56:04 GMT-0200 (Hora oficial do Brasil)
		 * Exclui uma cor
		 */
		function del_cor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_cor(P_COR_ID   =>  :P_COR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 16:16:41 UTC-0300 2008
		 * Insere dados de uma cor para um idioma
		 */
		function ins_cor_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_cor_idioma(P_COR_ID   =>  :P_COR_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 16:17:29 UTC-0300 2008
		 * Altera dados de uma cor para um idioma
		 */
		function upd_cor_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_cor_idioma(P_COR_ID   =>  :P_COR_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Sep 29 16:23:37 UTC-0300 2008
		 * Exclui dados de uma cor para um idioma
		 */
		function del_cor_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_cor_idioma(P_COR_ID   =>  :P_COR_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cor excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Sep 29 17:18:08 UTC-0300 2008
		 * Exclui todos os dados da cor para todos os idiomas
		 */
		function del_cor_idioma_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_cor_idioma_all(P_COR_ID   =>  :P_COR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COR_ID',$arguments['cor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados excludos com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Sep 30 11:19:25 UTC-0300 2008
		 * Insere um Atributo
		 */
		function ins_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_atributo(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_ATRIBUTO_ID	       =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$idiomas = explode(",",$arguments['idiomas']);
				$nome = listatoarray($arguments,"nome");
				
				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_atributo_idioma(array(atributo_id => $arguments['atributo_id'],
															idioma_id => $idiomas[$i],
															nome	=> $nome[$i],
															no_commit => 1
														  ));
					if($ret['erro'] == 'true')
						return $ret;
				}				 
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Sep 30 11:23:39 UTC-0300 2008
		 * Insere  dados do atributo para o idioma
		 */
		function ins_atributo_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_atributo_idioma(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				 
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Sep 30 11:20:19 UTC-0300 2008
		 * Altera um Atributo
		 */
		function upd_atributo($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			//REMOVE OS DADOS DO ATRIBUTO PARA OS IDIOMAS
			$ret = $this->del_atributo_idioma_all(array(atributo_id => $arguments['atributo_id'],
														no_commit => 1
													  ));
			if($ret['erro'] == 'true')
				return $ret;
				
			//INSERE OS DADOS DO ATRIBUTO PARA OS IDIOMAS
			$idiomas = explode(",",$arguments['idiomas']);
			$nome = listatoarray($arguments,"nome");			
			for($i=0;$i<count($idiomas);$i++){			
				$ret = $this->ins_atributo_idioma(array(atributo_id => $arguments['atributo_id'],
														idioma_id => $idiomas[$i],
														nome	=> $nome[$i],
														no_commit => 1
													  ));
				if($ret['erro'] == 'true')
					return $ret;
			}			
			
			if((isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;		
		}
		
		
		/*
		 * Criado em Tue Sep 30 11:20:19 UTC-0300 2008
		 * Excli um Atributo
		 */
		function del_atributo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_atributo(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Sep 30 11:24:30 UTC-0300 2008
		 * Altera  dados do atributo para o idioma
		 */
		function upd_atributo_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_atributo_idioma(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Atributo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		} 
		
		
		/*
		 * Criado em Tue Sep 30 11:25:19 UTC-0300 2008
		 * Exclui  dados do atributo para o idioma
		 */
		function del_atributo_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_atributo_idioma(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados do atributo excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Sep 30 11:29:48 UTC-0300 2008
		 * Exclui todos dados do atributo para todos idiomas
		 */
		function del_atributo_idioma_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_atributo_idioma_all(P_ATRIBUTO_ID   =>  :P_ATRIBUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ATRIBUTO_ID',$arguments['atributo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados do atributo excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Insere todas as fotos do produto
		 */
		 function ins_produto_foto_all($arguments=array()){
		 	
		 	if(!isset($arguments['no_commit']))
				$this-> start();
			
			$ret = $this->del_produto_foto_all(array(produto_id => $arguments['produto_id'],
													 no_commit => 1
													 ));
			if($ret['erro'] == 'true')
				return $ret;
			
			$url = listatoarray($arguments,"url_imagem_foto");
			$altura = listatoarray($arguments,"altura_foto");
			$largura = listatoarray($arguments,"largura_foto");
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
			$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Fotos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_foto_id'] = $ret['categoria_id'];
			
			for($i=0;$i<count($url);$i++){				
				$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $arguments['categoria_foto_id'],										
										url_imagem		=> $url[$i],
										largura			=> $largura[$i],
										altura			=> $altura[$i],										
										no_commit 		=> 1
										));
					
					if($ret['erro'] == 'true') 
						return $ret;
				
				$ret = $this->ins_produto_foto(array(produto_id => $arguments['produto_id'],
													 foto_id => $ret['foto_id'],
													 no_commit => 1
												));
				if($ret['erro'] == 'true')
					return $erro;
				
			}
			
			
			if(isset($arguments['no_commit']) || @$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Fotos inseridas com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		 }
		

		
		/*
		 * Criado em Wed Oct 1 11:46:25 UTC-0300 2008
		 * Insere uma foto do produto
		 */
		function ins_produto_foto($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_foto(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_PRODUTO_FOTO_ID	       =>  :P_PRODUTO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_FOTO_ID',$arguments['produto_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 1 11:47:40 UTC-0300 2008
		 * Exclui as fotos do produto
		 */
		function del_produto_foto_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_foto_all(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Fotos excludas com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Oct 1 17:47:24 UTC-0300 2008
		 * Insere foto
		 */
		function ins_foto($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_ins_foto(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_TIPO	       =>  :P_TIPO,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$ret = $this->ins_produto_foto(array(produto_id => $arguments['produto_id'],
													 foto_id => $arguments['foto_id'],
													 no_commit => 1
													));
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Mon Oct 6 21:58:49 UTC-0300 2008
		 * Insere uma instalao
		 */
		function ins_instalacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_ins_instalacao(P_DATA_INSTALACAO   =>  :P_DATA_INSTALACAO,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_APROVADA	       =>  :P_APROVADA,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_INSTALACAO_ID	       =>  :P_INSTALACAO_ID);';
			$sql .= 'END;';
			
			if(!strlen(trim($arguments['destaque'])))
				$arguments['destaque'] = 0;
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DATA_INSTALACAO',$arguments['data_instalacao'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_APROVADA',$arguments['aprovada'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//DADOS PARA CADASTRO DOS CAMPOS PARA DETERMINADO IDIOMA
				$titulo = listatoarray($arguments,"titulo");
				$descricao = listatoarray($arguments,"descricao");
				$idiomas = explode(",",$arguments['idiomas']);				
				
				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_instalacao_idioma(array(instalacao_id => $arguments['instalacao_id'],
															  titulo => $titulo[$i],
															  descricao => $descricao[$i],
															  idioma_id => $idiomas[$i],
															  no_commit => 1
															));
				   if($ret['erro'] == 'true')
				   	return $ret;
				}
				
				//DADOS PARA CADASTRO DO VINCULO INSTALACAO-PRODUTO-COR
				$cores = listatoarray($arguments,"cores_id");
				$produto_id = listatoarray($arguments,"produto_id");
				
				for($i=0;$i<count($produto_id);$i++){
					$cor = explode(',',$cores[$i]);

					for($j=0;$j<count($cor);$j++){						
						$ret = $this->ins_instalacao_produto(array(instalacao_id => $arguments['instalacao_id'],
																   produto_cor_id => $cor[$j],
																   no_commit => 1
																 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}

			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Instalao cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Oct 6 22:00:13 UTC-0300 2008
		 * Altera uma instalao
		 */
		function upd_instalacao($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_alt_instalacao(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_DATA_INSTALACAO	       =>  :P_DATA_INSTALACAO,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_APROVADA	       =>  :P_APROVADA);';
			$sql .= 'END;';
		
			if(!strlen(trim($arguments['destaque'])))
				$arguments['destaque'] = 0;
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INSTALACAO',$arguments['data_instalacao'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_APROVADA',$arguments['aprovada'],4000);
		
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//EXCLUI DADOS DA INSTALACAO PARA OS IDIMOAS
				$ret = $this->del_instalacao_idioma_all(array(instalacao_id => $arguments['instalacao_id'],
															  no_commit		=> 1
															));
				if($ret['erro'] == 'true')
					return $ret;
					
				//EXCLUI PRODUTOS DA INSTALACAO
				$ret = $this->del_instalacao_produto_all(array(instalacao_id => $arguments['instalacao_id'],
																no_commit    => 1
														 	 ));
				if($ret['erro'] == 'true')
					return $ret;
			
				//DADOS PARA CADASTRO DOS CAMPOS PARA DETERMINADO IDIOMA
				$titulo = listatoarray($arguments,"titulo");
				$descricao = listatoarray($arguments,"descricao");
				$idiomas = explode(",",$arguments['idiomas']);				
				
				for($i=0;$i<count($idiomas);$i++){
					$ret = $this->ins_instalacao_idioma(array(instalacao_id => $arguments['instalacao_id'],
															  titulo => $titulo[$i],
															  descricao => $descricao[$i],
															  idioma_id => $idiomas[$i],
															  no_commit => 1
															));
				   if($ret['erro'] == 'true')
				   	   return $ret;
				}
				
				//DADOS PARA CADASTRO DO VINCULO INSTALACAO-PRODUTO-COR
				$cores = listatoarray($arguments,"cores_id");
				$produto_id = listatoarray($arguments,"produto_id");
				
				for($i=0;$i<count($produto_id);$i++){
					$cor = explode(',',$cores[$i]);

					for($j=0;$j<count($cor);$j++){						
						$ret = $this->ins_instalacao_produto(array(instalacao_id => $arguments['instalacao_id'],
																   produto_cor_id => $cor[$j],
																   no_commit => 1
																 ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}

			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Instalao alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Oct 6 22:01:51 UTC-0300 2008
		 * Exclui uma instalao
		 */
		function del_instalacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Instalao excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Oct 6 22:04:20 UTC-0300 2008
		 * Insere dados da instalao referente ao idioma
		 */
		function ins_instalacao_idioma($arguments=array()){			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_ins_instalacao_idioma(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_INSTALACAO_IDIOMA_ID	       =>  :P_INSTALACAO_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_INSTALACAO_IDIOMA_ID',$arguments['instalacao_idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
							
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados da instalao inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		
		/*
		 * Criado em Mon Oct 6 22:05:50 UTC-0300 2008
		 * Exclui dados da instalao referente ao idioma
		 */
		function del_instalacao_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao_idioma(P_INSTALACAO_IDIOMA_ID   =>  :P_INSTALACAO_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_IDIOMA_ID',$arguments['instalacao_idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados da instalao excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Oct 6 22:07:06 UTC-0300 2008
		 * Exclui dados da instalao referente ao idioma
		 */
		function del_instalacao_idioma_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao_idioma_all(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados da instalao excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}


		/*
		 * Criado em Tue Oct 7 14:04:26 UTC-0300 2008
		 * Insere produtos na instalao
		 */
		function ins_instalacao_produto($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_ins_instalacao_produto(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_PRODUTO_COR_ID	       =>  :P_PRODUTO_COR_ID,';
			$sql .= '					   P_INSTALACAO_PRODUTO_ID	       =>  :P_INSTALACAO_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_COR_ID',$arguments['produto_cor_id'],4000);
			oci_bind_by_name($stmt,':P_INSTALACAO_PRODUTO_ID',$arguments['instalacao_produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produtos inseridos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 7 14:05:35 UTC-0300 2008
		 * Exclui produtos da instalao
		 */
		function del_instalacao_produto_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao_produto_all(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produtos excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 8 14:08:39 UTC-0300 2008
		 * Insere todas foto da instalacao
		 */
		function ins_instalacao_fotos($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
						
			$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
			$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
			$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
			$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
			$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
			$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
			$v_credito = listatoarray($arguments,'fotos_credito_fotos');
			$v_largura = listatoarray($arguments,'fotos_largura_fotos');
			$v_altura = listatoarray($arguments,'fotos_altura_fotos');
			$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
			$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
			$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
			$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
			$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
			$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
			$fotos_excluir = explode("_",$arguments["lista_deleted_fotos"]);
				
				foreach($fotos_excluir as $v){
					if($v != '')
						$ret = $this->del_instalacao_foto(array(instalacao_id => $arguments["instalacao_id"],
													  foto_id => $v,
													  no_commit => 1
													));
						if($ret['erro'] == 'true')
							return $ret;
				}
			
			
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
			for($i=0;$i<count($v_foto_id);$i++){
				if(!strlen(trim($v_foto_id[$i]))){
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $v_categoria_id[$i],
										titulo			=> $v_titulo[$i],
										legenda			=> $v_legenda[$i],
										descricao		=> $v_descricao[$i],
										credito			=> $v_credito[$i],
										url_imagem		=> $v_url_imagem[$i],
										largura			=> $v_largura_original[$i],
										altura			=> $v_altura_original[$i],
										tipo			=> $v_tipo[$i],
										tamanho			=> $v_tamanho_original[$i],
										fotos_url		=> $arguments['fotos_url'],
										temporario		=> $v_url_temporario[$i],
										no_commit 		=> 1
										));
					
					if($ret['erro'] == 'true') 
						return $ret;
					$v_url_imagem[$i] = $ret['url_imagem'];
					
					$ret = $this->ins_instalacao_foto(array(instalacao_id => $arguments['instalacao_id'],
															foto_id => $ret['foto_id'],
															ordem => $v_ordem[$i],
															no_commit => 1
														  ));	
					if($ret['erro'] == 'true')
						return $ret;										
				
				}else{
					$ret = $connSiteMan->upd_arquivo(array(
										arquivo_id		=> $v_foto_id[$i],
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $v_categoria_id[$i],
										formato_id 		=> 1,
										titulo			=> $v_titulo[$i],
										legenda			=> $v_legenda[$i],
										descricao		=> $v_descricao[$i],
										credito			=> $v_credito[$i],
										url_imagem		=> $v_url_imagem[$i],
										largura			=> $v_largura_original[$i],
										altura			=> $v_altura_original[$i],
										tipo			=> $v_tipo[$i],
										tamanho			=> $v_tamanho_original[$i],
										fotos_url		=> $arguments['fotos_url'],
										temporario		=> $v_url_temporario[$i],
										no_commit 		=> 1
										));
					
					$ret = $this->upd_instalacao_foto(array(instalacao_id => $arguments['instalacao_id'],
															foto_id => $v_foto_id[$i],
															ordem => $v_ordem[$i],
															no_commit => 1
														  ));	
					if($ret['erro'] == 'true')
						return $ret;						
					
					if($ret['erro'] == 'true') 
						return $ret;
				}
			}
			
			$ret = $this->upd_instalacao_num_fotos(array(instalacao_id => $arguments['instalacao_id'],
														 fotos => count($v_foto_id),
														 no_commit => 1
													));
			if($ret['erro'] == 'true')
				return $ret;
			
		
			if(isset($arguments['no_commit']) || @$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto(s) inserida(s)/alterada(s) com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Wed Oct 8 14:08:39 UTC-0300 2008
		 * Altera uma foto da instalacao
		 */
		function ins_instalacao_foto($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_ins_instalacao_foto(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_INSTALACAO_FOTO_ID	       =>  :P_INSTALACAO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_INSTALACAO_FOTO_ID',$arguments['instalacao_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Fotos inseridas/alteradas com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 8 14:09:48 UTC-0300 2008
		 * Exclui todas as fotos da instalacao
		 */
		function upd_instalacao_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_alt_instalacao_foto(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 10 17:20:52 UTC-0300 2008
		 * Exclui uma foto de instalacao
		 */
		function del_instalacao_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao_foto(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 8 14:10:40 UTC-0300 2008
		 * Exclui todas as fotos da instalacao
		 */
		function del_instalacao_foto_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_del_instalacao_foto(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 9 11:15:58 UTC-0300 2008
		 * Avalia uma instalao(Reprova ou Aprova)
		 */
		function avaliar_instalacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_avaliar_instalacao(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_APROVADA	       =>  :P_APROVADA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_APROVADA',$arguments['aprovada'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   if($arguments['aprovada'] == 1)
			   	   $arguments["mensagem"] = "Aprovao registrada com sucesso. A instalao ir ao ar na dara especificada!";
			   else
			   	   $arguments["mensagem"] = "Reprovao registrada com sucesso. A instalao no ser exibida!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 14 08:43:06 UTC-0300 2008
		 * Insere um revendedor
		 */
		function ins_revendedor($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_revendedor(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_UF	       =>  :P_UF,';
			$sql .= '					   P_MUNICIPIO	       =>  :P_MUNICIPIO,';
			$sql .= '					   P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_FONE	       =>  :P_FONE,';
			$sql .= '					   P_FAX	       =>  :P_FAX,';
			$sql .= '					   P_WEBSITE	       =>  :P_WEBSITE,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_PAIS_ID	       =>  :P_PAIS_ID,';
			$sql .= '					   P_REVENDEDOR_ID	       =>  :P_REVENDEDOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_UF',$arguments['uf'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO',$arguments['municipio'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_FONE',$arguments['fone'],4000);
			oci_bind_by_name($stmt,':P_FAX',$arguments['fax'],4000);
			oci_bind_by_name($stmt,':P_WEBSITE',$arguments['website'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PAIS_ID',$arguments['pais_id'],4000);
			oci_bind_by_name($stmt,':P_REVENDEDOR_ID',$arguments['revendedor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Revendedor inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 14 08:46:11 UTC-0300 2008
		 * Insere um revendedor
		 */
		function upd_revendedor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_revendedor(P_REVENDEDOR_ID   =>  :P_REVENDEDOR_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_UF	       =>  :P_UF,';
			$sql .= '					   P_MUNICIPIO	       =>  :P_MUNICIPIO,';
			$sql .= '					   P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_FONE	       =>  :P_FONE,';
			$sql .= '					   P_FAX	       =>  :P_FAX,';
			$sql .= '					   P_WEBSITE	       =>  :P_WEBSITE,';
			$sql .= '					   P_PAIS_ID	       =>  :P_PAIS_ID,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_REVENDEDOR_ID',$arguments['revendedor_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_UF',$arguments['uf'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO',$arguments['municipio'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_FONE',$arguments['fone'],4000);
			oci_bind_by_name($stmt,':P_FAX',$arguments['fax'],4000);
			oci_bind_by_name($stmt,':P_WEBSITE',$arguments['website'],4000);
			oci_bind_by_name($stmt,':P_PAIS_ID',$arguments['pais_id'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Revendedor alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 14 08:47:00 UTC-0300 2008
		 * Exclui um revendedor
		 */
		function del_revendedor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_revendedor(P_REVENDEDOR_ID   =>  :P_REVENDEDOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_REVENDEDOR_ID',$arguments['revendedor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Revendedor excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 14 21:58:56 UTC-0300 2008
		 * Insere um Pais
		 */
		function ins_pais($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			

			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
			$ret = $connSiteMan->ins_foto(array(cod_portal		=> $arguments['cod_portal'],												
												url_imagem		=> $arguments['url_imagem'],
												no_commit 		=> 1
												));
			if($ret['erro'] == 'true')
				return $ret;			
			
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_pais(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_PAIS_ID	       =>  :P_PAIS_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$ret['foto_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PAIS_ID',$arguments['pais_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pas inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
 		 * Criado em Tue Oct 14 22:00:07 UTC-0300 2008
		 * Altera um Pais
		 */
		function upd_pais($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['img_tmp'] == 1){	
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
				$ret = $connSiteMan->ins_foto(array(cod_portal		=> $arguments['cod_portal'],												
													url_imagem		=> $arguments['url_imagem'],
													no_commit 		=> 1
													));
				if($ret['erro'] == 'true')
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_pais(P_PAIS_ID   =>  :P_PAIS_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAIS_ID',$arguments['pais_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pas alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 14 22:00:57 UTC-0300 2008
		 * Exclui um Pais
		 */
		function del_pais($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_pais(P_PAIS_ID   =>  :P_PAIS_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAIS_ID',$arguments['pais_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pas excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 21 15:42:34 UTC-0300 2008
		 * Atualiza o nmero de fotos da instalao
		 */
		function upd_instalacao_num_fotos($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_instalacao.prc_alt_instalacao_num_fotos(P_INSTALACAO_ID   =>  :P_INSTALACAO_ID,';
			$sql .= '					   P_FOTOS	       =>  :P_FOTOS);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INSTALACAO_ID',$arguments['instalacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTOS',$arguments['fotos'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Nmero de fotos alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Sat Oct 25 17:37:01 UTC-0300 2008
		 * Insere uma categoria
		 */
		function ins_categoria($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if( $arguments['url_imagem'] != '' ){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Categoria/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],									
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_categoria(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_PAI_ID	       =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$idiomas = explode(",",$arguments['idiomas']);				
				$descricao = listatoarray($arguments,"descricao");
				$texto = listatoarray($arguments,"texto");
				
				for($i=0;$i<count($idiomas);$i++){
					if($descricao[$i] != ''){
						$ret = $this->ins_categoria_idioma(array(categoria_id => $arguments['categoria_id'],
																 idioma_id => $idiomas[$i],
																 descricao => $descricao[$i],
																 texto	   => $texto[$i],
																 no_commit => 1
															));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria Inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Oct 25 17:37:45 UTC-0300 2008
		 * Altera uma categoria
		 */
		function upd_categoria($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temporario'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Categoria/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id_arquivo'],									
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			new dBug($arguments);		
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_CATEGORIA_PAI_ID	       =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$idiomas = explode(",",$arguments['idiomas']);				
				$descricao = listatoarray($arguments,"descricao");
				$texto = listatoarray($arguments,"texto");
				
				for($i=0;$i<count($idiomas);$i++){
					if(strlen(trim($descricao[$i]))){
						$ret = $this->upd_categoria_idioma(array(categoria_id => $arguments['categoria_id'],
																 idioma_id => $idiomas[$i],
																 descricao => $descricao[$i],
																 texto	   => $texto[$i],
																 no_commit => 1
															));
						if($ret['erro'] == 'true')
							return $ret;
					}else{
						$ret = $this->del_categoria_idioma(array(categoria_id => $arguments['categoria_id'],
															     idioma_id => $idiomas[$i],
																 no_commit => 1
															));
						if($rer['erro'] == 'true')
							return $ret;
					}
				}				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Oct 25 17:38:19 UTC-0300 2008
		 * Eclui uma categoria
		 */
		function del_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 28 09:37:31 UTC-0300 2008
		 * Insere um idioma para categoria
		 */
		function ins_categoria_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_categoria_idioma(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= ' 					   P_TEXTO			   =>  :P_TEXTO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Idioma da categoria inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 28 09:38:12 UTC-0300 2008
		 * Altera um idioma para categoria
		 */
		function upd_categoria_idioma($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_categoria_idioma(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_IDIOMA_ID	       =>  :P_IDIOMA_ID,';
			$sql .= ' 					   P_TEXTO			   =>  :P_TEXTO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Idioma da categoria alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Oct 28 10:33:41 UTC-0300 2008
		 * Exclui uma categoria idioma
		 */
		function del_categoria_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_categoria_idioma(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   							 P_IDIOMA_ID	  =>  :P_IDIOMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Idioma da categoria excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Sep 9 11:13:21 UTC-0300 2009
		 * Insere uma marca
		 */
		function ins_marca($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Marca/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url'],
									categoria_id	=> $arguments['categoria_id_arquivo'],									
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_marca(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_MARCA_ID	       =>  :P_MARCA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_MARCA_ID',$arguments['marca_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Marca cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Sep 9 11:14:10 UTC-0300 2009
		 * Altera uma marca
		 */
		function upd_marca($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Marca/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url'],
									categoria_id	=> $arguments['categoria_id_arquivo'],									
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_marca(P_MARCA_ID   =>  :P_MARCA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MARCA_ID',$arguments['marca_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Marca alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Sep 9 11:14:39 UTC-0300 2009
		 * Excli uma marca
		 */
		function del_marca($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_marca(P_MARCA_ID   =>  :P_MARCA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MARCA_ID',$arguments['marca_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Marca excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 10 15:25:22 UTC-0300 2009
		 * Insere um produto simples
		 */
		function ins_produto_simples($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['destaque'])))
				$arguments['destaque'] = 0;
			if(!strlen(trim($arguments['acessorio'])))
				$arguments['acessorio'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_simples(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_MARCA_ID	       =>  :P_MARCA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_COD_REFERENCIA	       =>  :P_COD_REFERENCIA,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_DETALHES	       =>  :P_DETALHES,';
			$sql .= '					   P_INFORMACOES	       =>  :P_INFORMACOES,';
			$sql .= '					   P_ACESSORIO	       =>  :P_ACESSORIO,';
			$sql .= '					   P_PRODUTO_ID	       =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_MARCA_ID',$arguments['marca_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_COD_REFERENCIA',$arguments['cod_referencia'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_DETALHES',$arguments['detalhes'],4000);
			oci_bind_by_name($stmt,':P_INFORMACOES',$arguments['informacoes'],4000);
			oci_bind_by_name($stmt,':P_ACESSORIO',$arguments['acessorio'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){

				//separa em arrays os dados das fotos
				$foto_id = listatoarray($arguments,"foto_id_foto");
				$produto_foto_id = listatoarray($arguments,"produto_foto_id_foto");
				$url_foto = listatoarray($arguments,"url_foto_foto");
				$ordem = listatoarray($arguments,"ordem_foto");
				
				//Busca as fotos ja cadastradas
				$conn = CreateObject("portal._class.consulta.produtos");
				$qrF = $conn->get_produto_simples_foto(array(produto_id => $arguments['produto_id']));
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				for($i=0; $i<count($qrF); $i++){
					if(array_search($qrF[$i]['PRODUTO_FOTO_ID'],$produto_foto_id) === false){
						$ret = $this->del_produto_simples_foto(array(produto_foto_id => $produto_foto_id[$i],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($foto_id); $i++){
					if(strlen(trim($foto_id[$i]))){ // se a foto ja est cadastrada
						
						if(strlen(trim($url_foto[$i]))){ // se o url da foto no estiver em branco  uma foto nova, ento a altera
							$ret = $connSiteMan->upd_arquivo(array( arquivo_id => $foto_id[$i],
																	url_imagem => $url_foto[$i],
																	no_commit => 1
																));
							if($ret['erro'] == 'true') 
								return $ret;
						}
						
						$ret = $this->upd_produto_simples_foto(array(foto_id => $foto_id[$i],
																	 produto_foto_id => $produto_foto_id[$i],
																	 ordem => $ordem[$i],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}else{
						
						$ret = $this->ins_produto_simples_foto(array(url_foto => $url_foto[$i],
																	 produto_id => $arguments['produto_id'],
																	 ordem => $ordem[$i],
																	 cod_portal => $arguments['cod_portal'],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
						
						
					}
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto cadastrado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 10 15:26:33 UTC-0300 2009
		 * Altera um produto simples
		 */
		function upd_produto_simples($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['destaque'])))
				$arguments['destaque'] = 0;
			if(!strlen(trim($arguments['acessorio'])))
				$arguments['acessorio'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_produto_simples(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_MARCA_ID	       =>  :P_MARCA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESTAQUE	       =>  :P_DESTAQUE,';
			$sql .= '					   P_DETALHES	       =>  :P_DETALHES,';
			$sql .= '					   P_INFORMACOES	       =>  :P_INFORMACOES,';
			$sql .= '					   P_ACESSORIO	       =>  :P_ACESSORIO,';
			$sql .= '					   P_COD_REFERENCIA	       =>  :P_COD_REFERENCIA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_MARCA_ID',$arguments['marca_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
			oci_bind_by_name($stmt,':P_DETALHES',$arguments['detalhes'],4000);
			oci_bind_by_name($stmt,':P_INFORMACOES',$arguments['informacoes'],4000);
			oci_bind_by_name($stmt,':P_ACESSORIO',$arguments['acessorio'],4000);
			oci_bind_by_name($stmt,':P_COD_REFERENCIA',$arguments['cod_referencia'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				//separa em arrays os dados das fotos
				$foto_id = listatoarray($arguments,"foto_id_foto");
				$produto_foto_id = listatoarray($arguments,"produto_foto_id_foto");
				$url_foto = listatoarray($arguments,"url_foto_foto");
				$ordem = listatoarray($arguments,"ordem_foto");
				
				new dBug($produto_foto_id);
				
				//Busca as fotos ja cadastradas
				$conn = CreateObject("portal._class.consulta.produtos");
				$qrF = $conn->get_produto_simples_foto(array(produto_id => $arguments['produto_id']));
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				for($i=0; $i<count($qrF); $i++){
					if(array_search($qrF[$i]['PRODUTO_FOTO_ID'],$produto_foto_id) === false){
						$ret = $this->del_produto_simples_foto(array(produto_foto_id => $produto_foto_id[$i],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($foto_id); $i++){
					if(strlen(trim($foto_id[$i]))){ // se a foto ja est cadastrada
						
						if(strlen(trim($url_foto[$i]))){ // se o url da foto no estiver em branco  uma foto nova, ento a altera
							$ret = $connSiteMan->upd_arquivo(array( arquivo_id => $foto_id[$i],
																	url_imagem => $url_foto[$i],
																	formato_id => 1,
																	no_commit => 1
																));
							if($ret['erro'] == 'true') 
								return $ret;
						}
						
						$ret = $this->upd_produto_simples_foto(array(foto_id => $foto_id[$i],
																	 produto_foto_id => $produto_foto_id[$i],
																	 ordem => $ordem[$i],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}else{
						//se a foto nao esta cadastrada ainda entao cadastra-a
						$ret = $this->ins_produto_simples_foto(array(url_foto => $url_foto[$i],
																	 produto_id => $arguments['produto_id'],
																	 ordem => $ordem[$i],
																	 cod_portal => $arguments['cod_portal'],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
						
						
					}
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 10 15:38:48 UTC-0300 2009
		 * Exclui um produto simples
		 */
		function del_produto_simples($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_simples(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		
		
		/*
		 * Criado em Thu Sep 17 14:13:04 UTC-0300 2009
		 * Insere uma foto para o produto simples
		 */
		function ins_produto_simples_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_foto']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Fotos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_foto'],
									categoria_id	=> $arguments['categoria_id_arquivo'],									
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_simples_foto(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_PRODUTO_FOTO_ID	       =>  :P_PRODUTO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_FOTO_ID',$arguments['produto_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto adicionada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 17 14:14:07 UTC-0300 2009
		 * Altera uma foto para o produto simples
		 */
		function upd_produto_simples_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				new dBug($arguments);
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_produto_simples_foto(P_PRODUTO_FOTO_ID   =>  :P_PRODUTO_FOTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_FOTO_ID',$arguments['produto_foto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 17 14:15:06 UTC-0300 2009
		 * Exclui uma foto para o produto simples
		 */
		function del_produto_simples_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_simples_foto(P_PRODUTO_FOTO_ID   =>  :P_PRODUTO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_FOTO_ID',$arguments['produto_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Sep 17 18:08:14 UTC-0300 2009
		 * Insere um valor para o produto
		 */
		function ins_produto_simples_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['oferta'])))
				$arguments['oferta'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_produto_simples_valor(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_OFERTA	       =>  :P_OFERTA,';
			$sql .= '					   P_FORMA_PAGAMENTO	       =>  :P_FORMA_PAGAMENTO,';
			$sql .= '					   P_VALOR_FINAL	       =>  :P_VALOR_FINAL,';
			$sql .= '					   P_PRODUTO_VALOR_ID	       =>  :P_PRODUTO_VALOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_OFERTA',$arguments['oferta'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO',$arguments['forma_pagamento'],4000);
			oci_bind_by_name($stmt,':P_VALOR_FINAL',$arguments['valor_final'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_VALOR_ID',$arguments['produto_valor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor atribudo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
				
		/*
		 * Criado em Thu Sep 17 18:08:56 UTC-0300 2009
		 * Altera um valor para o produto
		 */
		function upd_produto_simples_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!strlen(trim($arguments['oferta'])))
				$arguments['oferta'] = 0;
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_produto_simples_valor(P_PRODUTO_VALOR_ID   =>  :P_PRODUTO_VALOR_ID,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_OFERTA	       =>  :P_OFERTA,';
			$sql .= '					   P_FORMA_PAGAMENTO	       =>  :P_FORMA_PAGAMENTO,';
			$sql .= '					   P_VALOR_FINAL	       =>  :P_VALOR_FINAL,';
			$sql .= '					   P_DATA	       =>  :P_DATA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_VALOR_ID',$arguments['produto_valor_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_OFERTA',$arguments['oferta'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO',$arguments['forma_pagamento'],4000);
			oci_bind_by_name($stmt,':P_VALOR_FINAL',$arguments['valor_final'],4000);
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
				
		/*
		 * Criado em Thu Sep 17 18:09:57 UTC-0300 2009
		 * Excli um valor para o produto
		 */
		function del_produto_simples_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_produto_simples_valor(P_PRODUTO_VALOR_ID   =>  :P_PRODUTO_VALOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_VALOR_ID',$arguments['produto_valor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor excli com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Nov 30 10:58:55 UTC-0200 2009
		 * Insere uma forma de pagamento
		 */
		function ins_forma_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_foto']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Forma de Pagamento/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_foto'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo			=> $arguments['nome'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_ins_forma_pagamento(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_FORMA_PAGAMENTO_ID	       =>  :P_FORMA_PAGAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO_ID',$arguments['forma_pagamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Forma de pagamento cadastrada com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Nov 30 10:59:57 UTC-0200 2009
		 * Altera uma forma de pagamento
		 */
		function upd_forma_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_foto']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Produtos/Forma de Pagamento/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_arquivo'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_foto'],
									categoria_id	=> $arguments['categoria_id_arquivo'],
									titulo			=> $arguments['nome'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_alt_forma_pagamento(P_FORMA_PAGAMENTO_ID   =>  :P_FORMA_PAGAMENTO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO_ID',$arguments['forma_pagamento_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Forma de pagamento alterada com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Nov 30 11:00:38 UTC-0200 2009
		 * Exclui uma forma de pagamento
		 */
		function del_forma_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	produto.pkg_produto.prc_del_forma_pagamento(P_FORMA_PAGAMENTO_ID   =>  :P_FORMA_PAGAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO_ID',$arguments['forma_pagamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Forma de pagamento excluda com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
	}
	global $conexao_banco;
	$ProdutoManipulacaoObj = new ProdutoManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ProdutoManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>