<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $PortalAjudaManObj;
if(!$PortalAjudaManObj) {
	class PortalAjudaMan extends QueryCom {		
		/*
		 * Criado em Fri Oct 16 10:14:51 UTC-0300 2009
		 * Insere uma categoria de tpicos
		 */
		function ins_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_ins_categoria(P_CATEGORIA_ID     => :P_CATEGORIA_ID,';
			$sql .= '					   						 P_CATEGORIA_ID_PAI	=> :P_CATEGORIA_ID_PAI,';
			$sql .= '					   						 P_COD_PORTAL       => :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID_PAI',$arguments['categoria_id_pai'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				// Categoria -> Idioma
				$idiomas   = explode(",", $arguments['idiomas']);
				$descricao = listatoarray($arguments, "descricao");
				$texto     = listatoarray($arguments, "texto");
				
				for($i = 0; $i < count($idiomas); $i++) {
					if($descricao[$i] != '') {
						$ret = $this->ins_categoria_idioma(array(categoria_id => $arguments['categoria_id'],
																 idioma_id 	  => $idiomas[$i],
																 descricao 	  => $descricao[$i],
																 texto	   	  => $texto[$i],
																 no_commit 	  => 1
																));
						if($ret['erro'] == 'true') {
							return $ret;
						}
					}
				}
				
				// Mdulos
				$modulo_id = listatoarray($arguments, "modulo_id_modulo");
				
				for($i = 0; $i < count($modulo_id); $i++) {
					$ret = $this->ins_categoria_modulo(array(categoria_id => $arguments['categoria_id'],
															 modulo_id    => $modulo_id[$i],
															 no_commit 	  => 1
															));
					if($ret['erro'] == 'true') {
						return $ret;
					}
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Oct 16 10:16:08 UTC-0300 2009
		 * Altera uma categoria de tpicos
		 */
		function upd_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_alt_categoria(P_CATEGORIA_ID     => :P_CATEGORIA_ID,';
			$sql .= '					   						 P_CATEGORIA_ID_PAI	=> :P_CATEGORIA_ID_PAI,';
			$sql .= '					   						 P_COD_PORTAL	    => :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID_PAI',$arguments['categoria_id_pai'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				// Categoria -> Idioma
				$idiomas   = explode(",", $arguments['idiomas']);
				$descricao = listatoarray($arguments, "descricao");
				$texto     = listatoarray($arguments, "texto");
				
				for($i = 0; $i < count($idiomas); $i++) {
					if($descricao[$i] != '') {
						$ret = $this->upd_categoria_idioma(array(categoria_id => $arguments['categoria_id'],
																 idioma_id 	  => $idiomas[$i],
																 descricao 	  => $descricao[$i],
																 texto	   	  => $texto[$i],
																 no_commit 	  => 1
																));
						if($ret['erro'] == 'true') {
							return $ret;
						}
					}
				}
				
				// Mdulos
				$controle_id = listatoarray($arguments, "controle_id_modulo");
				$modulo_id   = listatoarray($arguments, "modulo_id_modulo");
				
				$conn = CreateObject("portal._class.consulta.portal_ajuda");
				$qrCategoriaModulo = $conn->get_categoria_modulo(array(categoria_id => $arguments['categoria_id']));
				
				for($i = 0; $i < count($qrCategoriaModulo); $i++) {
					if(array_search($qrCategoriaModulo[$i]['MODULO_ID'], $modulo_id) === false) {
						$ret = $this->del_categoria_modulo(array(controle_id => $qrCategoriaModulo[$i]['CONTROLE_ID'],
															     no_commit 	 => 1
															    ));
						
						if($ret['erro'] == 'true') {
							return $ret;
						}
					}
				}				
				
				for($i = 0; $i < count($controle_id); $i++) {
					if($controle_id[$i] == '') {
						$ret = $this->ins_categoria_modulo(array(categoria_id => $arguments['categoria_id'],
																 modulo_id    => $modulo_id[$i],
																 no_commit 	  => 1
																));
					}
					else {
						$ret = $this->upd_categoria_modulo(array(controle_id  => $controle_id[$i],
																 categoria_id => $arguments['categoria_id'],
																 modulo_id    => $modulo_id[$i],
																 no_commit 	  => 1
																));
					}
					
					if($ret['erro'] == 'true') {
						return $ret;
					}
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Oct 16 10:16:57 UTC-0300 2009
		 * Exclui uma categoria de tpicos
		 */
		function del_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_del_categoria(P_CATEGORIA_ID => :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria excluda com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Oct 16 10:19:33 UTC-0300 2009
		 * Insere uma categoria a um idioma
		 */
		function ins_categoria_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_ins_categoria_idioma(P_CATEGORIA_ID => :P_CATEGORIA_ID,';
			$sql .= '					   								P_IDIOMA_ID	   => :P_IDIOMA_ID,';
			$sql .= '					   								P_DESCRICAO	   => :P_DESCRICAO,';
			$sql .= '					  								P_TEXTO	       => :P_TEXTO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Oct 16 10:20:45 UTC-0300 2009
		 * Altera uma categoria de uma idioma
		 */
		function upd_categoria_idioma($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_alt_categoria_idioma(P_CATEGORIA_ID => :P_CATEGORIA_ID,';
			$sql .= '					   								P_IDIOMA_ID	   => :P_IDIOMA_ID,';
			$sql .= '					   								P_DESCRICAO	   => :P_DESCRICAO,';
			$sql .= '					   								P_TEXTO	       => :P_TEXTO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 20 13:50:17 UTC-0200 2009
		 * Insere um mdulo a uma categoria
		 */
		function ins_categoria_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_ins_categoria_modulo(P_CONTROLE_ID  => :P_CONTROLE_ID,';
			$sql .= '					   								P_CATEGORIA_ID => :P_CATEGORIA_ID,';
			$sql .= '					   								P_MODULO_ID	   => :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CONTROLE_ID',$arguments['controle_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mdulo inserido com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 20 13:50:58 UTC-0200 2009
		 * Altera um mdulo de uma categoria
		 */
		function upd_categoria_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_alt_categoria_modulo(P_CONTROLE_ID  => :P_CONTROLE_ID,';
			$sql .= '					   								P_CATEGORIA_ID => :P_CATEGORIA_ID,';
			$sql .= '					   								P_MODULO_ID	   => :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CONTROLE_ID',$arguments['controle_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mdulo alterado com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Oct 20 13:51:53 UTC-0200 2009
		 * Exclui um mdulo de uma categoria
		 */
		function del_categoria_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_del_categoria_modulo(P_CONTROLE_ID => :P_CONTROLE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CONTROLE_ID',$arguments['controle_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mdulo excludo com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Oct 24 18:07:05 UTC-0200 2009
		 * Insere um tpico
		 */
		function ins_topico_completo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_ins_topico_completo(P_TOPICO_ID    => :P_TOPICO_ID,';
			$sql .= '					   							   P_CATEGORIA_ID => :P_CATEGORIA_ID,';
			$sql .= '					 							   P_VERSAO_ID	  => :P_VERSAO_ID,';
			$sql .= '												   P_CLIENTE_ID	  => :P_CLIENTE_ID,';
			$sql .= '												   P_IDIOMA_ID	  => :P_IDIOMA_ID,';
			$sql .= '												   P_DESCRICAO	  => :P_DESCRICAO,';
			$sql .= '												   P_CONTROLE_ID  => :P_CONTROLE_ID,';
			$sql .= '												   P_TITULO	      => :P_TITULO,';
			$sql .= '												   P_CONTEUDO	  => :P_CONTEUDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOPICO_ID',$arguments['topico_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_VERSAO_ID',$arguments['versao_id'],4000);
			oci_bind_by_name($stmt,':P_CLIENTE_ID',$arguments['cliente_id'],4000);
			oci_bind_by_name($stmt,':P_IDIOMA_ID',$arguments['idioma_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CONTROLE_ID',$arguments['controle_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
		
			if(strlen(trim($arguments['conteudo']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_CONTEUDO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['conteudo']);
			}else
				oci_bind_by_name($stmt,':P_CONTEUDO',$arguments['conteudo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tpico inserido com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Oct 22 10:18:22 UTC-0200 2009
		 * Exclui um tpico
		 */
		function del_topico($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	ajuda.pkg_portal_ajuda.prc_del_topico(P_TOPICO_ID => :P_TOPICO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TOPICO_ID',$arguments['topico_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tpico excludo com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
	} // Fim da Classe
	
	global $conexao_banco;
	$PortalAjudaManObj = new PortalAjudaMan($conexao_banco);
} // Fim IF

global $createdObject;
$createdObject = $PortalAjudaManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->" . $_VARS["method"] . "(\$_VARS, 'wddx')));");
	}
	catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>