<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $PortalManipulacaoObj;
if(!$PortalManipulacaoObj) {
	class PortalManipulacao extends QueryCom {
		/**
		 * Insere um grupo de portais
		 */
		function ins_portal_grupo($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_ins_portal_grupo(p_descricao    => :p_descricao, ';
					$sql .= '										 p_grupo_id		=> :p_grupo_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_grupo_id',$arguments['grupo_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Altera um grupo de portais
		 */
		function upd_portal_grupo($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_alt_portal_grupo(p_grupo_id		=> :p_grupo_id, ';
					$sql .= '										 p_descricao    => :p_descricao); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_grupo_id',$arguments['grupo_id'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_alt_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Exclui um grupo de portais
		 */
		function del_portal_grupo($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_del_portal_grupo(p_grupo_id		=> :p_grupo_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_grupo_id',$arguments['grupo_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_del_portal_grupo(\''.$arguments['grupo_id'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Grupo excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}

		/**
		 * Insere um portal
		 */
		function ins_portal($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(empty($arguments['proprietario']))
				$arguments['proprietario'] = $_SESSION['email'];
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_ins_portal(p_cod_portal     => :p_cod_portal, ';
					$sql .= '	 							   p_grupo_id		=> :p_grupo_id,';
					$sql .= '	 							   p_descricao		=> :p_descricao,';
					$sql .= '	 							   p_proprietario	=> :p_proprietario,';
					$sql .= '	 							   p_title			=> :p_title,';
					$sql .= '	 							   p_keywords		=> :p_keywords,';
					$sql .= '	 							   p_verify_vl		=> :p_verify_vl,';
					$sql .= '	 							   p_espaco  		=> :p_espaco,';
					$sql .= '	 							   p_analytics_key	=> :p_analytics_key,';
					$sql .= '	 							   p_meta_tags		=> :p_meta_tags);';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_grupo_id',$arguments['grupo_id'],4000);
					oci_bind_by_name($stmt,':p_proprietario',$arguments['proprietario'],4000);
					oci_bind_by_name($stmt,':p_title',$arguments['title'],4000);
					oci_bind_by_name($stmt,':p_keywords',$arguments['keywords'],4000);
					oci_bind_by_name($stmt,':p_verify_vl',$arguments['verify_vl'],4000);
					oci_bind_by_name($stmt,':p_espaco',$arguments['espaco'],4000);
					oci_bind_by_name($stmt,':p_analytics_key',$arguments['analytics_key'],4000);
					oci_bind_by_name($stmt,':p_meta_tags',$arguments['meta_tags'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso) {
				// Cria o usuario proprietario do Portal
				$connAcesso = CreateObject("portal._class.manipulacao.acesso");
				$ret = $connAcesso->replicar_usuario(array(
										email				=> $_SESSION['email'],
										cod_portal_origem	=> $_SESSION['cod_portal'],
										cod_portal_destino	=> $arguments['cod_portal'],
										no_commit			=> 1,
										));
				if($ret['erro'] == 'true')
					return $ret;
					
				$ret = $connAcesso->atribui_modulos_basicos(array(
										email				=> $_SESSION['email'],										
										cod_portal	  	    => $arguments['cod_portal'],
										no_commit			=> 1,
										));
				if($ret['erro'] == 'true')
					return $ret;
					

					
				$v_modulo_id = listatoarray($arguments,'modulo_id_modulos');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_modulos'])),implode(',',$v_modulo_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_portal_modulo(array(
													modulo_id => $v_excluir[$i],
													cod_portal => $arguments['cod_portal'],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_modulo_id);$i++) {
					$ret = $this->ins_portal_modulo(array(
											modulo_id		=> $v_modulo_id[$i],
											cod_portal		=> $arguments['cod_portal'],
											no_commit		=> 1
											));
					if($ret['erro'] == 'true') 
						return $ret;
				}		
				
				
				$v_dominio_id = listatoarray($arguments,'dominio_id_dominios');
				$v_dominio = listatoarray($arguments,'dominio_dominios');
				$v_maps_key = listatoarray($arguments,'maps_key_dominios');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_dominios'])),implode(',',$v_dominio_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_portal_dominio(array(
													dominio_id => $v_excluir[$i],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_dominio_id);$i++) {
					if(!strlen(trim($v_dominio_id[$i]))) {
						$ret = $this->ins_portal_dominio(array(
												dominio_id		=> $v_dominio_id[$i],
												cod_portal		=> $arguments['cod_portal'],
												dominio			=> $v_dominio[$i],
												google_maps_key => $v_maps_key[$i],
												no_commit		=> 1,
												));
					} else {
						$ret = $this->upd_portal_dominio(array(
												dominio_id		=> $v_dominio_id[$i],
												cod_portal		=> $arguments['cod_portal'],
												dominio			=> $v_dominio[$i],
												google_maps_key => $v_maps_key[$i],
												no_commit		=> 1,
												));
					}
					if($ret['erro'] == 'true') 
						return $ret;
				}		
				

				// Cria o Setor Inicial
				$ret = $this->ins_portal_setor(array(
											no_commit 	=> 1,
											cod_portal	=> $arguments['cod_portal'],
											cod_setor	=> 'INICIAL',
											descricao	=> 'Pagina Inicial',
											padrao		=> 1,
											largura		=> 1000
											));
				if($ret['erro'] == "true")
					return $ret;
				
				$arguments['layout_id'] = $ret['layout_id'];
				
				// Copia o Layout Inicial Padrao
				$connLayout = CreateObject("portal._class.manipulacao.layout");
				$ret = $connLayout->copiar_layout(array(
										layout_id_origem	=> 2142,
										layout_id_destino	=> $arguments['layout_id'],
										excluir_conteudo	=> 0,
										no_commit			=> 1
										));
				if($ret['erro'] == 'true') 
					return $ret;
				
				// Cria os arquivos de configurao do portal
				$connFile = CreateObject("_class.funcoes.file");
				$ret = $connFile->copiar_pasta(array(
									origem	=> $_SERVER['DOCUMENT_ROOT']."/portal/skeleton",
									destino	=> $_SERVER['DOCUMENT_ROOT']."/sites/".$arguments['cod_portal'],
									));
				if($ret['erro'] == "true")
					return $ret;
				
				$ret = $connFile->gravar_arquivo(array(
										destino => $_SERVER['DOCUMENT_ROOT']."/sites/".$arguments['cod_portal']."/config.cfm",
										conteudo => "<cflocation url='/sites/".$arguments['cod_portal']."/config.php' addtoken='no'>"
										));
				if($ret['erro'] == "true")
					return $ret;
				
				$conteudo_config = "<?php\n";
				$conteudo_config .= "\tsession_start();\n";
				$conteudo_config .= "\t\$_SESSION['site'] = \"sites/".$arguments['cod_portal']."/\";\n";
				$conteudo_config .= "\t\$_SESSION['dsn'] = \"JMNEWS01.JMNEWS.COM.BR\";\n";
				$conteudo_config .= "\t\$_SESSION['cod_portal'] = \"".$arguments['cod_portal']."\";\n";
				$conteudo_config .= "\t\$_SESSION['nome_cliente'] = \"".$arguments['descricao']."\";\n";
				$conteudo_config .= "\t\$_SESSION['cc_erro'] = \"\";\n";
				$conteudo_config .= "\tif(!isset(\$_SESSION['usuario'])) {\n";
				$conteudo_config .= "\t\t\$_SESSION['usuario'] = 'publico';\n";
				$conteudo_config .= "\t\t\$_SESSION['senha'] = 'kmm2007';\n";
				$conteudo_config .= "\t}\n";
				$conteudo_config .= "?>\n";
				$conteudo_config .= "<script language='javascript1.2'>\n";
				$conteudo_config .= "\ttop.window.location = '/index.php';\n";
				$conteudo_config .= "</script>\n";
				
				$ret = $connFile->gravar_arquivo(array(
										destino => $_SERVER['DOCUMENT_ROOT']."/sites/".$arguments['cod_portal']."/config.php",
										conteudo => $conteudo_config
										));
				if($ret['erro'] == "true")
					return $ret;
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Portal inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Altera um Portal
		 */
		function upd_portal($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_alt_portal(p_cod_portal     => :p_cod_portal, ';
					$sql .= '	 							   p_grupo_id		=> :p_grupo_id,';
					$sql .= '	 							   p_descricao		=> :p_descricao, ';
					$sql .= '	 							   p_title			=> :p_title,';
					$sql .= '	 							   p_keywords		=> :p_keywords,';
					$sql .= '	 							   p_verify_vl		=> :p_verify_vl,';
					$sql .= '	 							   p_espaco  		=> :p_espaco,';
					$sql .= '	 							   p_analytics_key	=> :p_analytics_key,';
					$sql .= '	 							   p_meta_tags		=> :p_meta_tags);';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_grupo_id',$arguments['grupo_id'],4000);
					oci_bind_by_name($stmt,':p_title',$arguments['title'],4000);
					oci_bind_by_name($stmt,':p_keywords',$arguments['keywords'],4000);
					oci_bind_by_name($stmt,':p_verify_vl',$arguments['verify_vl'],4000);
					oci_bind_by_name($stmt,':p_espaco',$arguments['espaco'],4000);
					oci_bind_by_name($stmt,':p_analytics_key',$arguments['analytics_key'],4000);
					oci_bind_by_name($stmt,':p_meta_tags',$arguments['meta_tags'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso) {
				// Cria o usuario proprietario do Portal
				$connAcesso = CreateObject("portal._class.manipulacao.acesso");
				$ret = $connAcesso->replicar_usuario(array(
										email				=> $_SESSION['email'],
										cod_portal_origem	=> $_SESSION['cod_portal'],
										cod_portal_destino	=> $arguments['cod_portal'],
										no_commit			=> 1,
										));
				
				if($ret['erro'] == 'true')
					return $ret;
					
				$v_modulo_id = listatoarray($arguments,'modulo_id_modulos');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_modulos'])),implode(',',$v_modulo_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_portal_modulo(array(
													modulo_id => $v_excluir[$i],
													cod_portal => $arguments['cod_portal'],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_modulo_id);$i++) {
					$ret = $this->ins_portal_modulo(array(
											modulo_id		=> $v_modulo_id[$i],
											cod_portal		=> $arguments['cod_portal'],
											no_commit		=> 1
											));
					if($ret['erro'] == 'true') 
						return $ret;
				}		
				
				
				$v_dominio_id = listatoarray($arguments,'dominio_id_dominios');
				$v_dominio = listatoarray($arguments,'dominio_dominios');
				$v_maps_key = listatoarray($arguments,'maps_key_dominios');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_dominios'])),implode(',',$v_dominio_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_portal_dominio(array(
													dominio_id => $v_excluir[$i],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_dominio_id);$i++) {
					if(!strlen(trim($v_dominio_id[$i]))) {
						$ret = $this->ins_portal_dominio(array(
												dominio_id		=> $v_dominio_id[$i],
												cod_portal		=> $arguments['cod_portal'],
												dominio			=> $v_dominio[$i],
												google_maps_key => $v_maps_key[$i],
												no_commit		=> 1,
												));
					} else {
						$ret = $this->upd_portal_dominio(array(
												dominio_id		=> $v_dominio_id[$i],
												cod_portal		=> $arguments['cod_portal'],
												dominio			=> $v_dominio[$i],
												google_maps_key => $v_maps_key[$i],
												no_commit		=> 1,
												));
					}
					if($ret['erro'] == 'true') 
						return $ret;
				}							
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Portal alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Exclui um portal
		 */
		function del_portal($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_del_portal(p_cod_portal     => :p_cod_portal); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Portal excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $this->getErrors();
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}

		/**
		 * Insere um setor do portal 
		 */
		function ins_portal_setor($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this->start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_ins_portal_setor(p_cod_portal     => :p_cod_portal, ';
					$sql .= '										 p_cod_setor	  => :p_cod_setor, ';
					$sql .= '			 							 p_descricao	  => :p_descricao,';
					$sql .= '			 							 p_padrao		  => :p_padrao,';
					$sql .= '			 							 p_setor_id		  => :p_setor_id';
					$sql .= '										); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
					oci_bind_by_name($stmt,':p_cod_setor',$arguments['cod_setor'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_padrao',$arguments['padrao'],4000);
					oci_bind_by_name($stmt,':p_setor_id',$arguments['setor_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso) {
				$ret = $this->ins_portal_setor_layout(array(
										setor_id		=> $arguments['setor_id'],
										data_exibicao	=> date("d/m/Y H:i:s"),
										descricao		=> "Layout Inicial",
										largura			=> $arguments['largura'],
										no_commit		=> 1
										));
				if($ret["erro"] == "true")
					return $ret;
				
				$arguments['layout_id'] = $ret['layout_id'];
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Setor inserido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];

				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Altera um setor do portal 
		 */
		function upd_portal_setor($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_alt_portal_setor(p_setor_id		  => :p_setor_id,';
					$sql .= '										 p_cod_portal     => :p_cod_portal, ';
					$sql .= '										 p_cod_setor	  => :p_cod_setor, ';
					$sql .= '			 							 p_descricao	  => :p_descricao,';
					$sql .= '			 							 p_padrao		  => :p_padrao';
					$sql .= '										); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
					oci_bind_by_name($stmt,':p_cod_setor',$arguments['cod_setor'],4000);
					oci_bind_by_name($stmt,':p_descricao',$arguments['descricao'],4000);
					oci_bind_by_name($stmt,':p_padrao',$arguments['padrao'],4000);
					oci_bind_by_name($stmt,':p_setor_id',$arguments['setor_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Setor alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];

				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Exclui um setor do portal 
		 */
		function del_portal_setor($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_del_portal_setor(p_setor_id     => :p_setor_id); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_setor_id',$arguments['setor_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Setor excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/**
		 * Insere um layout para o setor
		 */
		function ins_portal_setor_layout($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$conn = CreateObject("portal._class.manipulacao.layout");
			$connCons = CreateObject("portal._class.consulta.layout");
			$result = $conn->ins_layout(array(
									descricao => $arguments['descricao'],
									largura	  => $arguments['largura'],
									no_commit => 1
								));
			if($result['erro'] == "true")
				return $result;
			$arguments['layout_id'] = $result['layout_id'];
			
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_ins_setor_layout(p_setor_id          => :p_setor_id ';
					$sql .= '										,p_data_exibicao 	 => :p_data_exibicao ';
					$sql .= '										,p_layout_id	 	 => :p_layout_id ';
					$sql .= '										,p_setor_layout_id	 => :p_setor_layout_id ';
					$sql .= '										); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_setor_id',$arguments['setor_id'],4000);
					oci_bind_by_name($stmt,':p_data_exibicao',$arguments['data_exibicao'],4000);
					oci_bind_by_name($stmt,':p_layout_id',$result['layout_id'],4000);
					oci_bind_by_name($stmt,':p_setor_layout_id',$result['setor_layout_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Layout vinculado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/*
		 * Criado em Thu Jul 17 17:13:20 UTC-0300 2008
		 * Efetua a copia de um layout
		 */
		function ins_setor_layout_backup($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_setor_layout_backup(P_SETOR_LAYOUT_ID_ORIGEM   =>  :P_SETOR_LAYOUT_ID_ORIGEM,';
			$sql .= '					   P_SETOR_LAYOUT_ID	       =>  :P_SETOR_LAYOUT_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SETOR_LAYOUT_ID_ORIGEM',$arguments['setor_layout_id_origem'],4000);
			oci_bind_by_name($stmt,':P_SETOR_LAYOUT_ID',$arguments['setor_layout_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Layout copiado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/**
		 * Altera um layout para o setor
		 */
		function upd_portal_setor_layout($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$connPortal = CreateObject("portal._class.consulta.portal");
			$qrLayout = $connPortal->get_portal_setor_layout(array(
										setor_layout_id => $arguments['setor_layout_id']
										));
			$arguments['layout_id'] = $qrLayout[0]['LAYOUT_ID'];			
			
			$conn = CreateObject("portal._class.manipulacao.layout");
			$ret = $conn->upd_layout(array(layout_id => $arguments['layout_id']
											 ,descricao => $arguments['descricao']
											 ,largura	=> $arguments['largura']
											 ,no_commit	=> 1));
			if($ret['erro'] == "true") {
				return $ret;
			}
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_alt_setor_layout(p_setor_layout_id	 => :p_setor_layout_id ';
					$sql .= '										,p_setor_id          => :p_setor_id ';
					$sql .= '										,p_data_exibicao 	 => :p_data_exibicao ';
					$sql .= '										,p_layout_id	 	 => :p_layout_id ';
					$sql .= '										); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_setor_layout_id',$arguments['setor_layout_id'],4000);
					oci_bind_by_name($stmt,':p_setor_id',$arguments['setor_id'],4000);
					oci_bind_by_name($stmt,':p_data_exibicao',$arguments['data_exibicao'],4000);
					oci_bind_by_name($stmt,':p_layout_id',$arguments['layout_id'],4000);
					$sucesso = (oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = $this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || $this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Layout alterado com sucesso!";
			} else {
				$arguments["erro"] = "true";
				if(!$_SESSION['last_error']) 
					$_SESSION['last_error'] = oci_error($stmt);
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}

		/**
		 * Exclui um layout para o setor
		 */
		function del_portal_setor_layout($arguments,$resulttype="array") {
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			switch($this->dbtype) {
				case "oracle":
					$sql  = 'BEGIN ';
					$sql .= '	site.pkg_portal.prc_del_setor_layout(p_setor_layout_id	 => :p_setor_layout_id ';
					$sql .= '										); ';
					$sql .= 'END; ';
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':p_setor_layout_id',$arguments['setor_layout_id'],4000);
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
					$sql  = 'select * from ';
					$sql .= '   site.prc_ins_portal_grupo(\''.$arguments['descricao'].'\'';
					$sql .= '                             );';
					$sucesso = ($arguments = @$this->getResult($sql,'0'));
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Layout excluido com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			switch($resulttype) {
				case "wddx":
					return $this->toWddx($arguments);
				case "array":
					return $arguments;
			}
		}
		
		/*
		 * Criado em Fri May 9 17:23:55 UTC-0300 2008
		 * Insere um acesso
		 */
		function ins_acesso($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			switch(strtolower($this->dbtype)) {
				case "oracle":
					$sql  = 'BEGIN';
					$sql .= '	acesso.pkg_ctrl_acesso.prc_ins_acesso(P_COD_PORTAL   =>  :P_COD_PORTAL,';
					$sql .= '					   P_SESSION_ID	       =>  :P_SESSION_ID,';
					$sql .= '					   P_IP	       =>  :P_IP,';
					$sql .= '					   P_REFERER	       =>  :P_REFERER,';
					$sql .= '					   P_USER_AGENT	       =>  :P_USER_AGENT,';
					$sql .= '					   P_ACESSO_ID	       =>  :P_ACESSO_ID);';
					$sql .= 'END;';
				
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
					oci_bind_by_name($stmt,':P_SESSION_ID',$arguments['session_id'],4000);
					oci_bind_by_name($stmt,':P_IP',$arguments['ip'],4000);
					oci_bind_by_name($stmt,':P_REFERER',$arguments['referer'],4000);
					oci_bind_by_name($stmt,':P_USER_AGENT',$arguments['user_agent'],4000);
					oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
				
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
					break;
				case "postgresql":
				default:
					$sql  = 'select * from ';
					$sql .= '   acesso.pkg_ctrl_acesso_prc_ins_acesso($1,$2,$3,$4,$5);';

					$params[] = $arguments['cod_portal'];
					$params[] = $arguments['session_id'];
					$params[] = $arguments['ip'];
					$params[] = $arguments['referer'];
					$params[] = $arguments['user_agent'];
					
					$sucesso = ($result = @$this->getResult($sql,'array',$params));
					$this->getArguments($arguments,$result);
					break;
			}
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acesso inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 9 17:26:37 UTC-0300 2008
		 * Insere uma profundidade acesso
		 */
		function ins_acesso_profundidade($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	acesso.pkg_ctrl_acesso.prc_ins_acesso_profundidade(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_COD_SETOR	       =>  :P_COD_SETOR,';
			$sql .= '					   P_ACESSO_ID	       =>  :P_ACESSO_ID,';
			$sql .= '					   P_URL	       =>  :P_URL,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_TEMPO_PROCESSAMENTO	       =>  :P_TEMPO_PROCESSAMENTO,';
			$sql .= '					   P_PROFUNDIDADE_ID	       =>  :P_PROFUNDIDADE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_COD_SETOR',$arguments['cod_setor'],4000);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
			oci_bind_by_name($stmt,':P_URL',$arguments['url'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TEMPO_PROCESSAMENTO',$arguments['tempo_processamento'],4000);
			oci_bind_by_name($stmt,':P_PROFUNDIDADE_ID',$arguments['profundidade_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Profundidade inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jul 22 14:29:04 UTC-0200 2008
		 * Insere um modulo do portal
		 */
		function ins_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
								
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_modulo(P_MODULO_ID   =>  :P_MODULO_ID,';
			$sql .= '					               P_DESCRICAO   =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				if(strlen(trim($arguments['modulo_dependente_id']))){
					$ret = $this->ins_modulo_dependencia(array(
											 modulo_id             => $arguments['modulo_id'],
											 modulo_dependente_id  => $arguments['modulo_dependente_id'],									    
											 no_commit => 1
										  ));
										  
				   if($ret["erro"] == "true")
				   		return $ret;
				}
											
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo inserido com sucesso !";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Wed Jul 23 09:51:40 UTC-0200 2008
		 * Altera um modulo
		 */
		function upd_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_alt_modulo(P_MODULO_ID   =>  :P_MODULO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				if(strlen(trim($arguments['modulo_dependente_id']))){
					$ret = $this->ins_modulo_dependencia(array(
											 modulo_id             => $arguments['modulo_id'],
											 modulo_dependente_id  => $arguments['modulo_dependente_id'],									    
											 no_commit => 1
										  ));
										  
				   if($ret["erro"] == "true")
				   		return $ret;
				}					
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo Alterado com sucesso !";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jul 22 17:24:46 UTC-0200 2008
		 * Exclui um modulo
		 */
		function del_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_del_modulo(P_MODULO_ID   =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo excluido com sucesso !";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jul 22 14:34:39 UTC-0200 2008
		 * Vincula a dependencia de um modulo
		 */
		function ins_modulo_dependencia($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_modulo_dependencia(P_MODULO_ID   =>  :P_MODULO_ID,';
			$sql .= '					   P_MODULO_DEPENDENTE_ID	       =>  :P_MODULO_DEPENDENTE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
			oci_bind_by_name($stmt,':P_MODULO_DEPENDENTE_ID',$arguments['modulo_dependente_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dependencia inserida com sucesso !";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Wed Aug 13 22:07:37 UTC-0300 2008
		 * Insere um dominio para o portal
		 */
		function ins_portal_dominio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_portal_dominio(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DOMINIO	       =>  :P_DOMINIO,';
			$sql .= '					   P_GOOGLE_MAPS_KEY	       =>  :P_GOOGLE_MAPS_KEY,';
			$sql .= '					   P_DOMINIO_ID	       =>  :P_DOMINIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DOMINIO',$arguments['dominio'],4000);
			oci_bind_by_name($stmt,':P_GOOGLE_MAPS_KEY',$arguments['google_maps_key'],4000);
			oci_bind_by_name($stmt,':P_DOMINIO_ID',$arguments['dominio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dominio inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Aug 13 22:07:37 UTC-0300 2008
		 * Altera um dominio para o portal
		 */
		function upd_portal_dominio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_alt_portal_dominio(P_DOMINIO_ID	       =>  :P_DOMINIO_ID,';
			$sql .= '					   P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DOMINIO	       =>  :P_DOMINIO,';
			$sql .= '					   P_GOOGLE_MAPS_KEY	       =>  :P_GOOGLE_MAPS_KEY';
			$sql .= '					   );';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DOMINIO',$arguments['dominio'],4000);
			oci_bind_by_name($stmt,':P_GOOGLE_MAPS_KEY',$arguments['google_maps_key'],4000);
			oci_bind_by_name($stmt,':P_DOMINIO_ID',$arguments['dominio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dominio alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Aug 13 22:09:24 UTC-0300 2008
		 * Exclui um dominio para o portal
		 */
		function del_portal_dominio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_del_portal_dominio(P_DOMINIO_ID   =>  :P_DOMINIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DOMINIO_ID',$arguments['dominio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dominio excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		

		/*
		 * Criado em Wed Aug 13 22:22:39 UTC-0300 2008
		 * Insere um modulo para o portal
		 */
		function ins_portal_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_portal_modulo(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_MODULO_ID	       =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/*
		 * Criado em Wed Aug 13 22:22:39 UTC-0300 2008
		 * Exclui um modulo para o portal
		 */
		function del_portal_modulo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_del_portal_modulo(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_MODULO_ID	       =>  :P_MODULO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_MODULO_ID',$arguments['modulo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Modulo excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Jan 30 09:55:26 UTC-0200 2010
		 * Inserir Treinamento
		 */
		function ins_treinamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_ins_treinamento(P_COD_PORTAL =>  :P_COD_PORTAL,';
			$sql .= '					   P_TREINAMENTO_ID				 =>  :P_TREINAMENTO_ID,';
			$sql .= '					   P_TITULO						 =>  :P_TITULO,';
			$sql .= '					   P_DATA_TREINAMENTO	         =>  :P_DATA_TREINAMENTO,';
			$sql .= '					   P_HORARIO_TREINAMENTO	     =>  :P_HORARIO_TREINAMENTO,';
			$sql .= '					   P_PUBLICO_ALVO	       		 =>  :P_PUBLICO_ALVO,';
			$sql .= '					   P_CONTEUDO	       			 =>  :P_CONTEUDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_ID',$arguments['treinamento_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DATA_TREINAMENTO',$arguments['data_treinamento'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_TREINAMENTO',$arguments['horario_treinamento'],4000);
			oci_bind_by_name($stmt,':P_PUBLICO_ALVO',$arguments['publico_alvo'],4000);
		
			if(strlen(trim($arguments['conteudo']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_CONTEUDO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['conteudo']);
			}else
				oci_bind_by_name($stmt,':P_CONTEUDO',$arguments['conteudo'],4000);
		
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Treinamento inserido com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Jan 30 09:59:21 UTC-0200 2010
		 * Alterar Treinamento
		 */
		function upd_treinamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_alt_treinamento(P_COD_PORTAL =>  :P_COD_PORTAL,';
			$sql .= '					   P_TREINAMENTO_ID	             =>  :P_TREINAMENTO_ID,';
			$sql .= '					   P_TITULO	                     =>  :P_TITULO,';
			$sql .= '					   P_DATA_TREINAMENTO	         =>  :P_DATA_TREINAMENTO,';
			$sql .= '					   P_HORARIO_TREINAMENTO	     =>  :P_HORARIO_TREINAMENTO,';
			$sql .= '					   P_PUBLICO_ALVO	             =>  :P_PUBLICO_ALVO,';
			$sql .= '					   P_CONTEUDO	                 =>  :P_CONTEUDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_ID',$arguments['treinamento_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DATA_TREINAMENTO',$arguments['data_treinamento'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_TREINAMENTO',$arguments['horario_treinamento'],4000);
			oci_bind_by_name($stmt,':P_PUBLICO_ALVO',$arguments['publico_alvo'],4000);
		
			if(strlen(trim($arguments['conteudo']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_CONTEUDO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['conteudo']);
			}else
				oci_bind_by_name($stmt,':P_CONTEUDO',$arguments['conteudo'],4000);
		
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Treinamento alterado com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Sat Jan 30 10:01:05 UTC-0200 2010
		 * Excluir Treinamento
		 */
		function del_treinamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_portal.prc_del_treinamento(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TREINAMENTO_ID	       =>  :P_TREINAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TREINAMENTO_ID',$arguments['treinamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Treinamento excluido com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
	}
	global $conexao_banco;
	$PortalManipulacaoObj = new PortalManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $PortalManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>