<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $JornalManipulacaoObj;
if(!$JornalManipulacaoObj) {
	class JornalManipulacao extends QueryCom {
	
		//************************************************ NOTICIAS - FONTES *****************************************************

		/**
		 * Insere uma fonte
		 */
		function ins_fonte($arguments=array()) {		    
			if(!isset($arguments['no_commit']))
				$this->start();
			
			$sql  = 'BEGIN ';
			$sql .= '   jornal.pkg_noticia.prc_ins_fonte(p_nome 	=> :p_nome, ';
			$sql .= '								     p_link		=> :p_link,';
			$sql .= '								     p_cod_portal		=> :p_cod_portal,';
			$sql .= '								     p_fonte_id => :p_fonte_id);';
			$sql .= 'END; ';
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':p_nome',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':p_link',$arguments['link'],4000);
			oci_bind_by_name($stmt,':p_cod_portal',$_SESSION['cod_portal'],4000);
			oci_bind_by_name($stmt,':p_fonte_id',$arguments['fonte_id'],4000);
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);					
				
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Fonte inserida com sucesso!";
			} else {
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			return $arguments;
		}
		

		/*
		 *  Altera dados da fonte
		 */
		function upd_fonte($arguments=array()) {
			if(!isset($arguments['no_commit']))
				$this->start();
	
			$sql  = 'BEGIN ';
			$sql .= '   jornal.pkg_noticia.prc_alt_fonte(p_fonte_id  =>  :p_fonte_id, ';
			$sql .= '   								 p_nome		 =>	 :p_nome, ';
			$sql .= '									 p_link		 =>	 :p_link);';
			$sql .= 'END; ';
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':p_fonte_id',$arguments['fonte_id'],4000);
			oci_bind_by_name($stmt,':p_nome',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':p_link',$arguments['link'],4000);
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);				
				
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Fonte alterada com sucesso!";				
			}else{
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Exlui uma fonte
		 */
		function del_fonte($arguments=array()) {
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN ';
			$sql .= '     jornal.pkg_noticia.prc_del_fonte(p_fonte_id =>  :p_fonte_id);';
			$sql .= 'END; ';
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':p_fonte_id',$arguments['fonte_id'],4000);
			$sucesso = (oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Fonte excluda com sucesso";
			}else{
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}			
			return $arguments;
		}  
	
		//*************************************************** NOTICIAS - CADASTRO *************************************************
		
		
		/*
		 * Criado em Fri May 9 09:52:11 UTC-0100 2008 Wagner L.V.
		 * Inserir Categoria
		 */
		function ins_foto_categoria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_imagem.prc_ins_foto_categoria(P_CATEGORIA_PAI_ID   =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_DESCRICAO	       		 =>  :P_DESCRICAO,';
			$sql .= '					   P_CATEGORIA_ID	         =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_COD_PORTAL	      		 =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',str_replace("/","",$_SESSION["site"]),4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Mon May 12 11:23:51 UTC-0100 2008
		 * insere foto a notcia
		 */
		function ins_noticia_foto($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_noticia_foto(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
		
			$sucesso = (oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto inserida com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 12 15:20:06 UTC-0100 2008
		 * descinvula
		 */
		function del_noticia_foto($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_noticia_foto(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = ".";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 12 15:57:35 UTC-0100 2008
		 * extermina a noticia
		 */
		function del_noticia($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_noticia(P_NOTICIA_ID   =>  :P_NOTICIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Notcia excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		
		
		/*
		 * Criado em Thu May 15 17:44:54 UTC-0300 2008
		 * Insere uma seo
		 */
		function ins_secao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			if(!isset($arguments['newsletter']))
				$arguments['newsletter'] = 0;
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_secao(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_FORMATO_ID	       =>  :P_FORMATO_ID,';
			$sql .= '					   P_URL_CABECALHO	       =>  :P_URL_CABECALHO,';
			$sql .= '					   P_NEWSLETTER	       =>  :P_NEWSLETTER,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_SECAO_PAI_ID	       =>  :P_SECAO_PAI_ID,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_URL_CABECALHO',$arguments['url_cabecalho'],4000);
			oci_bind_by_name($stmt,':P_NEWSLETTER',$arguments['newsletter'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_SECAO_PAI_ID',$arguments['secao_pai_id'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Seo inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 15 17:45:35 UTC-0300 2008
		 * Altera uma seo
		 */
		function upd_secao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			if(!isset($arguments['newsletter']))
				$arguments['newsletter'] = 0;
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_secao(P_SECAO_ID   =>  :P_SECAO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_FORMATO_ID	       =>  :P_FORMATO_ID,';
			$sql .= '					   P_URL_CABECALHO	       =>  :P_URL_CABECALHO,';
			$sql .= '					   P_NEWSLETTER	       =>  :P_NEWSLETTER,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_SECAO_PAI_ID	       =>  :P_SECAO_PAI_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_FORMATO_ID',$arguments['formato_id'],4000);
			oci_bind_by_name($stmt,':P_URL_CABECALHO',$arguments['url_cabecalho'],4000);
			oci_bind_by_name($stmt,':P_NEWSLETTER',$arguments['newsletter'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_SECAO_PAI_ID',$arguments['secao_pai_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Seo alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 15 17:46:32 UTC-0300 2008
		 * Altera a situacao de uma seo
		 */
		function upd_secao_ativa($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_secao_ativa(P_SECAO_ID   =>  :P_SECAO_ID,';
			$sql .= '					   P_ATIVA	       =>  :P_ATIVA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_ATIVA',$arguments['ativa'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Seo alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 15 17:47:17 UTC-0300 2008
		 * Exclui uma seo
		 */
		function del_secao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_secao(P_SECAO_ID   =>  :P_SECAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Seo excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu May 15 17:47:17 UTC-0300 2008
		 * Insere uma noticia
		 */
		function ins_noticia($arguments=array()) {
			if(!isset($arguments['no_commit']))
				$this->start();


			$sql  = 'BEGIN ';
			$sql .= '   jornal.pkg_noticia.prc_ins_noticia(p_data_publicacao    =>  :p_data_publicacao,';
			$sql .= '										p_categoria		    =>  :p_categoria,';
			$sql .= '									    p_titulo			=>  :p_titulo,';
			$sql .= '										p_subtitulo			=>  :p_subtitulo,';
			$sql .= '										p_texto				=>  :p_texto,';
			$sql .= '										p_autor				=>  :p_autor,';
			$sql .= '										p_fonte_id			=>  :p_fonte_id,';
			$sql .= '										p_plantao			=>  :p_plantao,';
			$sql .= '										p_noticia_id		=>  :p_noticia_id,';
			$sql .= '										p_cod_portal		=>  :p_cod_portal,';
			$sql .= '										p_tags				=>  :p_tags);';
			$sql .= 'END;';	
			
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':p_data_publicacao',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':p_categoria',$arguments['categoria'],4000);
			oci_bind_by_name($stmt,':p_titulo',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':p_subtitulo',$arguments['subtitulo'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['texto']);

			oci_bind_by_name($stmt,':p_autor',$arguments['autor'],4000);
			oci_bind_by_name($stmt,':p_fonte_id',$arguments['fonte_id'],4000);
			oci_bind_by_name($stmt,':p_noticia_id',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':p_plantao',$arguments['plantao'],4000);	
			oci_bind_by_name($stmt,':p_cod_portal',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':p_tags',$arguments['tags'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);				

			$timer = new BC_Timer;
			if($sucesso) {
				// Vincula a noticia com a seo
				$ret = $this->ins_noticia_secao(array(
										   cod_portal => $_SESSION["cod_portal"],
										   secao_id   => $arguments["secao_id"],
										   noticia_id => $arguments["noticia_id"],
										   edicao_id  => $arguments["edicao_id"],
										   ordem	  => $arguments["ordem"],
										   no_commit  => 1));
				if($ret['erro'] == 'true')
					return $ret;
				print($timer->get_elapsed_time()."<br>");
				// Busca os dados das fotos inseridas nas noticias
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');

				print($timer->get_elapsed_time()."<br>");
				
				$connJornal = CreateObject("portal._class.consulta.jornal");
				$connSite = CreateObject("portal._class.consulta.site");
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				// Busca as fotos atualmente cadastradas para a noticia
				$qrNoticiaFoto = $connJornal->get_noticia_foto(array(noticia_id => $arguments['noticia_id']));
				
				// Desvincula as fotos das noticias
				for($i=0;$i<count($qrNoticiaFoto);$i++) {
					if(array_search($qrNoticiaFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_noticia_foto(array(noticia_id => $arguments["noticia_id"],
													  foto_id => $qrNoticiaFoto[$i]['FOTO_ID'],
													  no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}
				
				print($timer->get_elapsed_time()."<br>");

				// Vincula e insere as fotos quando necessrio
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $connSiteMan->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						
						$ret2 = $this->ins_noticia_foto(array(
														noticia_id		=> $arguments['noticia_id'],
														foto_id			=> $ret['foto_id'],
														ordem			=> $v_ordem[$i],
														titulo			=> $v_titulo[$i],
														credito			=> $v_credito[$i],
														legenda			=> $v_legenda[$i],
														descricao		=> $v_descricao[$i],
														altura			=> $v_altura[$i],
														largura			=> $v_largura[$i],
													    no_commit 		=> 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
					} else {
						$ret2 = $this->ins_noticia_foto(array( 
														noticia_id		=> $arguments['noticia_id'],
														foto_id			=> $v_foto_id[$i],
														ordem			=> $v_ordem[$i],
														titulo			=> $v_titulo[$i],
														credito			=> $v_credito[$i],
														legenda			=> $v_legenda[$i],
														descricao		=> $v_descricao[$i],
														altura			=> $v_altura[$i],
														largura			=> $v_largura[$i],
													    no_commit 		=> 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					}
				}
															
				print($timer->get_elapsed_time()."<br>");
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');
				$v_ordem = listatoarray($arguments,'videos_ordem_videos');

				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.jornal");
				$conn2 = CreateObject("portal._class.manipulacao.site");
				$qrNoticiaVideo = $conn->get_noticia_video(array(noticia_id => $arguments['noticia_id']));
				
				for($i=0;$i<count($qrNoticiaVideo);$i++) {
					if(array_search($qrNoticiaVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_noticia_video(array(
											noticia_id 		=> $arguments['noticia_id'],
											video_id			=> $qrNoticiaVideo[$i]['VIDEO_ID'],
											no_commit		=> 1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}			
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_noticia_video(array(
												noticia_id		=> $arguments['noticia_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_noticia_video(array(
												noticia_id		=> $arguments['noticia_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
			}
				
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Notcia inserida com sucesso!";				
			}else{
				$arguments["erro"] = "true";
				$arguments["mensagem"] = $_SESSION['last_error'];
				$this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 12 14:24:40 UTC-0100 2008
		 * Altera a noticia
		 */
		function upd_noticia($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_noticia(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_DATA_PUBLICACAO	    	  =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_CATEGORIA	      			  =>  :P_CATEGORIA,';
			$sql .= '					   P_TITULO	      				  =>  :P_TITULO,';
			$sql .= '					   P_SUBTITULO	      			  =>  :P_SUBTITULO,';
			$sql .= '					   P_TEXTO	       			      =>  :P_TEXTO,';
			$sql .= '					   P_AUTOR	      				  =>  :P_AUTOR,';
			$sql .= '					   P_FONTE_ID	      			  =>  :P_FONTE_ID,';
			$sql .= '					   P_PLANTAO	      			  =>  :P_PLANTAO,';
			$sql .= '					   P_TAGS	 	     			  =>  :P_TAGS);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA',$arguments['categoria'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_SUBTITULO',$arguments['subtitulo'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['texto']);
			
			oci_bind_by_name($stmt,':P_AUTOR',$arguments['autor'],4000);
			oci_bind_by_name($stmt,':P_FONTE_ID',$arguments['fonte_id'],4000);
			oci_bind_by_name($stmt,':P_PLANTAO',$arguments['plantao'],4000);
			oci_bind_by_name($stmt,':P_TAGS',$arguments['tags'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			$timer = new BC_Timer;
			if($sucesso) {
				$conn2 = CreateObject("portal._class.manipulacao.site");
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				$fotos_excluir = explode("_",$arguments["lista_deleted_fotos"]);
				
				foreach($fotos_excluir as $v){
					if($v != '')
						$this->del_noticia_foto(array(noticia_id => $arguments["noticia_id"],
													  foto_id => $v,
													  no_commit => 1));
				}
					
					
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $conn2->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return 'ERRO: '.$ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						

						$ret2 = $this->ins_noticia_foto(array(
														noticia_id		=> $arguments['noticia_id'],
														foto_id			=> $ret['foto_id'],
														ordem			=> $v_ordem[$i],
														titulo			=> $v_titulo[$i],
														credito			=> $v_credito[$i],
														legenda			=> $v_legenda[$i],
														descricao		=> $v_descricao[$i],
														altura			=> $v_altura[$i],
														largura			=> $v_largura[$i],
													    no_commit 		=> 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;

					}else
					{
						$ret2 = $this->ins_noticia_foto(array( 
														noticia_id		=> $arguments['noticia_id'],
														foto_id			=> $v_foto_id[$i],
														ordem			=> $v_ordem[$i],
														titulo			=> $v_titulo[$i],
														credito			=> $v_credito[$i],
														legenda			=> $v_legenda[$i],
														descricao		=> $v_descricao[$i],
														altura			=> $v_altura[$i],
														largura			=> $v_largura[$i],
													    no_commit 		=> 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					}
				}


				$ret = $this->ins_noticia_secao(array(cod_portal => $_SESSION["cod_portal"],
													   secao_id   => $arguments["secao_id"],
													   noticia_id => $arguments["noticia_id"],
													   edicao_id => $arguments["edicao_id"],
													   no_commit  => 1));
				if($ret['erro'] == 'true')
					return $ret;
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');
				$v_ordem = listatoarray($arguments,'videos_ordem_videos');

				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.jornal");
				$qrNoticiaVideo = $conn->get_noticia_video(array(noticia_id => $arguments['noticia_id']));
				
				for($i=0;$i<count($qrNoticiaVideo);$i++) {
					if(array_search($qrNoticiaVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_noticia_video(array(
											noticia_id 		=> $arguments['noticia_id'],
											video_id			=> $qrNoticiaVideo[$i]['VIDEO_ID'],
											no_commit		=> 1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}			
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_noticia_video(array(
												noticia_id		=> $arguments['noticia_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_noticia_video(array(
												noticia_id		=> $arguments['noticia_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Notcia alterada com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
/*
		 * Criado em Mon May 12 14:32:25 UTC-0100 2008
		 * Altera a noticia
		 */
		function ins_noticia_secao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_noticia_secao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID,';
			$sql .= '					   P_NOTICIA_ID	       =>  :P_NOTICIA_ID,';
			$sql .= '					   P_EDICAO_ID	       =>  :P_EDICAO_ID,';
			$sql .= '					   P_ORDEM             =>  :P_ORDEM';
			$sql .= '					   );';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Notcia vinculada com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 12 14:51:06 UTC-0100 2008
		 * Desvincula uma noticia da secao
		 */
		function del_noticia_secao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_noticia_secao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID,';
			$sql .= '					   P_NOTICIA_ID	       =>  :P_NOTICIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())) {
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Notcia excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
						
		/*
		 * Criado em Mon Jun 9 14:00:33 UTC-0300 2008
		 * Insere um video na noticia
		 */
		function ins_noticia_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_noticia_video(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video vinculado a noticia com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 9 14:01:18 UTC-0300 2008
		 * Exclui um video na noticia
		 */
		function del_noticia_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_noticia_video(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video desvinculado da noticia com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
				
		/*
		 * Criado em Thu Jun 12 15:04:34 UTC-0300 2008
		 * Insere uma edio
		 */
		function ins_edicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_edicao(P_COD_EDICAO   =>  :P_COD_EDICAO,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_EDICAO_ID	       =>  :P_EDICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		/*
		 * Criado em Thu Jun 12 15:05:27 UTC-0300 2008
		 * Altera uma edio
		 */
		function upd_edicao($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao(P_EDICAO_ID   =>  :P_EDICAO_ID,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Thu Jun 12 15:06:10 UTC-0300 2008
		 * Exclui uma edio
		 */
		function del_edicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_edicao(P_EDICAO_ID   =>  :P_EDICAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jun 12 15:07:13 UTC-0300 2008
		 * Altera o status de travado de uma edicao
		 */
		function upd_edicao_travada($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao_travada(P_EDICAO_ID   =>  :P_EDICAO_ID,';
			$sql .= '					   P_TRAVADA	       =>  :P_TRAVADA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_TRAVADA',$arguments['travada'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jun 12 15:07:44 UTC-0300 2008
		 * Altera o status de concluida de uma edicao
		 */
		function upd_edicao_concluida($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao_concluida(P_EDICAO_ID   =>  :P_EDICAO_ID,';
			$sql .= '					   P_CONCLUIDA	       =>  :P_CONCLUIDA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_CONCLUIDA',$arguments['concluida'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 13 10:17:35 UTC-0300 2008
		 * Move uma noticia dentro da secao
		 */
		function mover_noticia_secao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_mover_noticia_secao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOTICIA_ID	       =>  :P_NOTICIA_ID,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID,';
			$sql .= '					   P_EDICAO_ID	       =>  :P_EDICAO_ID,';
			$sql .= '					   P_DIRECAO	       =>  :P_DIRECAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_DIRECAO',$arguments['direcao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Noticia alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 13 14:40:53 UTC-0300 2008
		 * Move uma noticia dentro da secao
		 */
		function upd_noticia_secao_posicao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_noticia_secao_posicao(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID,';
			$sql .= '					   P_EDICAO_ID	       =>  :P_EDICAO_ID,';
			$sql .= '					   P_NOTICIA_ID	       =>  :P_NOTICIA_ID,';			
			$sql .= '					   P_NOTICIA_ID_ANTERIOR	       =>  :P_NOTICIA_ID_ANTERIOR,';
			$sql .= '					   P_NOTICIA_ID_POSTERIOR	       =>  :P_NOTICIA_ID_POSTERIOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$_SESSION['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_ID',$arguments['edicao_id'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID_ANTERIOR',$arguments['noticia_id_anterior'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID_POSTERIOR',$arguments['noticia_id_posterior'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Noticia alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:23:22 UTC-0300 2008
		 * Insere uma edio impressa do jornal
		 */
		function ins_edicao_impressa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_edicao_impressa(P_DATA_PUBLICACAO   =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_EDICAO_IMPRESSA_ID	       =>  :P_EDICAO_IMPRESSA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:23:57 UTC-0300 2008
		 * Altera uma edio impressa do jornal
		 */
		function upd_edicao_impressa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao_impressa(P_EDICAO_IMPRESSA_ID   =>  :P_EDICAO_IMPRESSA_ID,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso){
				$v_caderno_id = listatoarray($arguments,'caderno_id_cadernos');
				$v_descricao = listatoarray($arguments,'caderno_descricao_cadernos');
				$v_sigla = listatoarray($arguments,'caderno_sigla_cadernos');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_cadernos'])),implode(',',$v_caderno_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_edicao_impressa_caderno(array(
													caderno_id => $v_excluir[$i],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_caderno_id);$i++) {
					if(!strlen(trim($v_caderno_id[$i]))) {
						$ret = $this->ins_edicao_impressa_caderno(array(
												descricao		=> $v_descricao[$i],
												letra			=> $v_sigla[$i],
												edicao_impressa_id => $arguments['edicao_impressa_id'],
												no_commit		=> 1
												));
					} else {
						$ret = $this->upd_edicao_impressa_caderno(array(
												caderno_id		=> $v_caderno_id[$i],
												descricao		=> $v_descricao[$i],
												letra			=> $v_sigla[$i],
												edicao_impressa_id => $arguments['edicao_impressa_id'],
												no_commit		=> 1
												));
					}
					if($ret['erro'] == 'true') 
						return $ret;
				}			
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:24:47 UTC-0300 2008
		 * Exclui uma edio impressa do jornal
		 */
		function del_edicao_impressa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_edicao_impressa(P_EDICAO_IMPRESSA_ID   =>  :P_EDICAO_IMPRESSA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:26:31 UTC-0300 2008
		 * Insere uma pagina na edio impressa
		 */
		function ins_edicao_impressa_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temporario_pdf'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}

			if($arguments['temporario_imagem'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_edicao_pagina(P_EDICAO_IMPRESSA_ID   =>  :P_EDICAO_IMPRESSA_ID,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID,';
			$sql .= '					   P_COD_PAGINA	       =>  :P_COD_PAGINA,';
			$sql .= '					   P_NRO_PAGINA	       =>  :P_NRO_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF,';
			$sql .= '					   P_PAGINA_ID	       =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PAGINA',$arguments['cod_pagina'],4000);
			oci_bind_by_name($stmt,':P_NRO_PAGINA',$arguments['nro_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:27:57 UTC-0300 2008
		 * Altera uma pagina na edio impressa
		 */
		function upd_edicao_impressa_pagina($arguments=array()){
		
			if($arguments['temporario_pdf'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}

			if($arguments['temporario_imagem'] == "1") {
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
			}
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID,';
			$sql .= '					   P_EDICAO_IMPRESSA_ID	       =>  :P_EDICAO_IMPRESSA_ID,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID,';
			$sql .= '					   P_COD_PAGINA	       =>  :P_COD_PAGINA,';
			$sql .= '					   P_NRO_PAGINA	       =>  :P_NRO_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PAGINA',$arguments['cod_pagina'],4000);
			oci_bind_by_name($stmt,':P_NRO_PAGINA',$arguments['nro_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:28:33 UTC-0300 2008
		 * Exclui uma pagina na edio impressa
		 */
		function del_edicao_impressa_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_edicao_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:29:21 UTC-0300 2008
		 * Insere um caderno para a edio
		 */
		function ins_edicao_impressa_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_edicao_caderno(P_EDICAO_IMPRESSA_ID   =>  :P_EDICAO_IMPRESSA_ID,';
			$sql .= '					   P_LETRA	       =>  :P_LETRA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
			oci_bind_by_name($stmt,':P_LETRA',$arguments['letra'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:29:54 UTC-0300 2008
		 * Altera um caderno para a edio
		 */
		function upd_edicao_impressa_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_edicao_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID,';
			$sql .= '					   P_EDICAO_IMPRESSA_ID	       =>  :P_EDICAO_IMPRESSA_ID,';
			$sql .= '					   P_LETRA	       =>  :P_LETRA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_EDICAO_IMPRESSA_ID',$arguments['edicao_impressa_id'],4000);
			oci_bind_by_name($stmt,':P_LETRA',$arguments['letra'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 18 08:30:21 UTC-0300 2008
		 * Exclui um caderno para a edio
		 */
		function del_edicao_impressa_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_edicao_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Thu Aug 7 11:50:17 UTC-0300 2008
		 * Insere um acesso para a noticia
		 */
		function ins_noticia_acesso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_noticia_acesso(P_ACESSO_ID   =>  :P_ACESSO_ID,';
			$sql .= '					   P_NOTICIA_ID	       =>  :P_NOTICIA_ID,';
			$sql .= '					   P_LOG_ID	       =>  :P_LOG_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_LOG_ID',$arguments['log_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acesso inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 2 09:13:03 UTC-0200 2008
		 * Exclu uma foto do Banco de Imagens
		 */
		function del_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	site.pkg_foto.prc_del_foto(P_FOTO_ID   =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jan 6 11:17:27 UTC-0200 2010
		 * Insere um destaque
		 */
		function ins_destaque($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_ins_destaque(P_TITULO   =>  :P_TITULO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESTAQUE_ID	       =>  :P_DESTAQUE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
		
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
		
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE_ID',$arguments['destaque_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Destaque inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Wed Jan 6 11:18:03 UTC-0200 2010
		 * Altera um destaque
		 */
		function upd_destaque($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_alt_destaque(P_DESTAQUE_ID   =>  :P_DESTAQUE_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESTAQUE_ID',$arguments['destaque_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
		
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
		
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Destaque alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jan 6 11:18:45 UTC-0200 2010
		 * Exclui um destaque
		 */
		function del_destaque($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_noticia.prc_del_destaque(P_DESTAQUE_ID   =>  :P_DESTAQUE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESTAQUE_ID',$arguments['destaque_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Destaque excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	}
	global $conexao_banco;
	$JornalManipulacaoObj = new JornalManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $JornalManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>