<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ImprimaAquiManipulacaoObj;
if(!$ImprimaAquiManipulacaoObj) {
	class ImprimaAquiManipulacao extends QueryCom {
		
		/*
		 * Criado em Thu Apr 16 16:41:41 UTC-0300 2009
		 * Insere um produto
		 */
		function ins_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_foto']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],
									url_imagem		=> $arguments['url_foto'],
									categoria_id	=> $arguments['categoria'],
									titulo		    => $arguments['nome'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			$arguments['tamanho_fixo'] = strlen(trim($arguments['tamanho_fixo']))?$arguments['tamanho_fixo']:0;
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_produto(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_GRAMATURA	       =>  :P_GRAMATURA,';
			$sql .= '					   P_MARCA	       =>  :P_MARCA,';
			$sql .= '					   P_MATERIAL	       =>  :P_MATERIAL,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_PRAZO	       =>  :P_PRAZO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_PESO	       =>  :P_PESO,';
			$sql .= '					   P_TAMANHO_FIXO      =>  :P_TAMANHO_FIXO,';
			$sql .= '					   P_ALTURA      =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA      =>  :P_LARGURA,';
			$sql .= '					   P_PRODUTO_ID	       =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_GRAMATURA',$arguments['gramatura'],4000);
			oci_bind_by_name($stmt,':P_MARCA',$arguments['marca'],4000);
			oci_bind_by_name($stmt,':P_MATERIAL',$arguments['material'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);
			oci_bind_by_name($stmt,':P_PRAZO',$arguments['prazo'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_PESO',$arguments['peso'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO_FIXO',$arguments['tamanho_fixo'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				//TIPOS DE ARQUIVO PARA O PRODUTO
				$tipo_id = listatoarray($arguments,"tipo_arquivo_id_arquivo");
				
				for($i=0; $i<count($tipo_id); $i++){
					$ret = $this->ins_produto_tipo_arquivo(array(produto_id => $arguments['produto_id'],
																 tipo_arquivo_id => $tipo_id[$i],
																 no_commit => 1
																));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				//ACABAMENTOS PARA O PRODUTO
				$acabamento_id = listatoarray($arguments,"acabamento_id_acabamento");
				
				for($i=0; $i<count($acabamento_id); $i++){
					$ret = $this->ins_produto_acabamento(array(produto_id => $arguments['produto_id'],
																 acabamento_id => $acabamento_id[$i],
																 no_commit => 1
																));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Apr 16 16:42:46 UTC-0300 2009
		 * Insere um produto
		 */
		function upd_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_foto']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_foto'],
									categoria_id	=> $arguments['categoria'],
									titulo		    => $arguments['nome'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
						
			$arguments['tamanho_fixo'] = strlen(trim($arguments['tamanho_fixo']))?$arguments['tamanho_fixo']:0;
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_produto(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_GRAMATURA	       =>  :P_GRAMATURA,';
			$sql .= '					   P_MARCA	       =>  :P_MARCA,';
			$sql .= '					   P_MATERIAL	       =>  :P_MATERIAL,';
			$sql .= '					   P_TAMANHO	       =>  :P_TAMANHO,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_PESO	       =>  :P_PESO,';
			$sql .= '					   P_TAMANHO_FIXO      =>  :P_TAMANHO_FIXO,';
			$sql .= '					   P_ALTURA      =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA      =>  :P_LARGURA,';
			$sql .= '					   P_PRAZO	       =>  :P_PRAZO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_GRAMATURA',$arguments['gramatura'],4000);
			oci_bind_by_name($stmt,':P_MARCA',$arguments['marca'],4000);
			oci_bind_by_name($stmt,':P_MATERIAL',$arguments['material'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO',$arguments['tamanho'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_PESO',$arguments['peso'],4000);
			oci_bind_by_name($stmt,':P_TAMANHO_FIXO',$arguments['tamanho_fixo'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_PRAZO',$arguments['prazo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				//TIPOS DE ARQUIVO PARA O PRODUTO
				$tipo_id = listatoarray($arguments,"tipo_arquivo_id_arquivo");
				$produto_tipo = listatoarray($arguments,"produto_tipo_id_arquivo");
				
				$conn = CreateObject("portal._class.consulta.imprimaaqui");
				$qrPTA = $conn->get_produto_tipo_arquivo(array(produto_id => $arguments['produto_id']));
				
				for($i=0; $i<count($qrPTA); $i++){
					if(array_search($qrPTA[$i]['PRODUTO_TIPO_ID'],$produto_tipo) === false){	
						$ret = $this->del_produto_tipo_arquivo(array(produto_tipo_id => $qrPTA[$i]['PRODUTO_TIPO_ID'],
															   		 no_commit 	     => 1
															  ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($produto_tipo); $i++){
					if(!strlen(trim($produto_tipo[$i]))){
						$ret = $this->ins_produto_tipo_arquivo(array(produto_id => $arguments['produto_id'],
																	 tipo_arquivo_id => $tipo_id[$i],
																	 no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}						
				}
				
				//TIPOS DE ACABAMENTOS PARA O PRODUTO
				$acabamento_id = listatoarray($arguments,"acabamento_id_acabamento");
				$id = listatoarray($arguments,"produto_acabamento_id_acabamento");
				
				$conn = CreateObject("portal._class.consulta.imprimaaqui");
				$qrPA = $conn->get_produto_acabamento(array(produto_id => $arguments['produto_id']));
				
				for($i=0; $i<count($qrPA); $i++){
					if(array_search($qrPA[$i]['PRODUTO_TIPO_ID'],$produto_tipo) === false){	
						$ret = $this->del_produto_acabamento(array(produto_acabamento_id => $qrPA[$i]['PRODUTO_ACABAMENTO_ID'],
															   		 no_commit 	     => 1
															  ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($acabamento_id); $i++){
					$ret = $this->ins_produto_acabamento(array(produto_id => $arguments['produto_id'],
																 acabamento_id => $acabamento_id[$i],
																 no_commit => 1
																));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Apr 16 16:43:34 UTC-0300 2009
		 * Exclui um produto
		 */
		function del_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_produto(P_PRODUTO_ID   =>  :P_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Apr 17 09:57:44 UTC-0300 2009
		 * Insere uma categoria de produto
		 */
		function ins_produto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_produto_categoria(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Apr 17 09:58:57 UTC-0300 2009
		 * Altera uma categoria de produto
		 */
		function upd_produto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_produto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Apr 17 09:59:29 UTC-0300 2009
		 * Exclui uma categoria de produto
		 */
		function del_produto_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_produto_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria excluir com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 *Insere todos os cases selecionados
		 */
		function upd_all_case_impresso($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			$url       = listatoarray($arguments,"url_imagem_case");
			$descricao = listatoarray($arguments,"descricao_case");
			$case_id   = listatoarray($arguments,"case_id_case");
			$foto_id   = listatoarray($arguments,"foto_id_case");
			
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			$qrC = $conn->get_case_impresso(array(produto_id => $arguments['produto_id']));
			
			//Exclui do banco de dados os cases excludos pelo usurio
			for($i=0; $i<count($qrC); $i++){
				if(array_search($qrC[$i]['CASE_ID'],$case_id) === false){
					$ret = $this->del_case_impresso(array(case_id => $qrC[$i]['CASE_ID'],
														  no_commit  => 1
													   ));
					if($ret['erro'] == 'true')
						return $ret;
				 }
			}
				
			for($i=0;$i<count($url);$i++){
				if($case_id[$i] == ''){//se for em branco entao insere o registro
					$ret = $this->ins_case_impresso(array(produto_id => $arguments['produto_id'],
												   url_imagem => $url[$i],
												   descricao  => $descricao[$i],
												   cod_portal => $arguments['cod_portal'],
												   no_commit  => 1
												 ));
				}else{// case contrrio altera o registro
					$ret = $this->upd_case_impresso(array(url_imagem => $url[$i],
												   descricao  => $descricao[$i],
												   case_id    => $case_id[$i],
												   foto_id	  => $foto_id[$i],
												   cod_portal => $arguments['cod_portal'],
												   no_commit  => 1
												 ));
				}
				if($ret['erro'] == 'true')
						return $ret;
			}

		
			if(@$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Case alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Apr 17 14:22:02 UTC-0300 2009
		 * Insere um case impresso de um produto
		 */
		function ins_case_impresso($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
				
			
			if(strlen(trim($arguments['url_imagem']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Case Impresso/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['descricao'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_case_impresso(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CASE_ID	       =>  :P_CASE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CASE_ID',$arguments['case_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Case inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Apr 17 14:22:49 UTC-0300 2009
		 * Altera um case impresso de um produto
		 */
		function upd_case_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if(strlen(trim($arguments['url_imagem']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Case Impresso/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['descricao'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_case_impresso(P_CASE_ID   =>  :P_CASE_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CASE_ID',$arguments['case_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Case alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Apr 17 14:23:46 UTC-0300 2009
		 * Exclui um case impresso de um produto
		 */
		function del_case_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_case_impresso(P_CASE_ID   =>  :P_CASE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CASE_ID',$arguments['case_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Case excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 11:14:33 UTC-0300 2009
		 * Insere um valor para um produto
		 */
		function ins_produto_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_produto_valor(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_PRODUTO_PRECO_ID	       =>  :P_PRODUTO_PRECO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_PRECO_ID',$arguments['produto_preco_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor atribudo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 11:15:34 UTC-0300 2009
		 * Exclui um valor para um produto
		 */
		function del_produto_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_produto_valor(P_PRODUTO_PRECO_ID   =>  :P_PRODUTO_PRECO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_PRECO_ID',$arguments['produto_preco_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 18:54:31 UTC-0300 2009
		 * Insere um carrinho de compras
		 */
		function ins_carrinho($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_carrinho(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_CARRINHO_ID	       =>  :P_CARRINHO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_CARRINHO_ID',$arguments['carrinho_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Carrinho inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 18:55:15 UTC-0300 2009
		 * Exclui um carrinho de compras
		 */
		function del_carrinho($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if(!strlen(trim($arguments['carrinho_id']))){
					$conn = CreateObject("portal._class.consulta.imprimaaqui");	
					$qrCarrinho = $conn->get_carrinho(array(cod_portal => $_SESSION['cod_portal'],
															email      => $_SESSION['email']
														  ));
					$arguments['carrinho_id'] = $qrCarrinho[0]['CARRINHO_ID'];
				}
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_carrinho(P_CARRINHO_ID   =>  :P_CARRINHO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_ID',$arguments['carrinho_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Carrinho excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 18:56:15 UTC-0300 2009
		 * Insere um produto no carrinho
		 */
		function ins_carrinho_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				$conn = CreateObject("portal._class.consulta.imprimaaqui");
				$qrC = $conn->get_carrinho(array(cod_portal => $arguments['cod_portal'],
												 email		=> $arguments['email']
												));
				
				if(count($qrC)){
					$arguments['carrinho_id'] = $qrC[0]['CARRINHO_ID'];	
				}else{
					$ret = $this->ins_carrinho(array(cod_portal => $arguments['cod_portal'],
													 email 		=> $arguments['email'],
													 no_commit  => 1
												   ));
					if($ret['erro'] == 'true')
						return $ret;
					else
						$arguments['carrinho_id'] = $ret['carrinho_id'];
				}
				
				$qrProduto = $conn->get_carrinho_produto(array(cod_portal  => $arguments['cod_portal'],
															   carrinho_id => $arguments['carrinho_id'],
															   produto_id  => $arguments['produto_id']
															  ));
				if(count($qrProduto) == 0){
						
					$sql  = 'BEGIN';
					$sql .= '	imprimaaqui.pkg_produto.prc_ins_carrinho_produto(P_CARRINHO_ID   =>  :P_CARRINHO_ID,';
					$sql .= '					   P_PRODUTO_ID	       =>  :P_PRODUTO_ID,';
					$sql .= '					   P_QUANTIDADE	       =>  :P_QUANTIDADE,';
					$sql .= '					   P_CARRINHO_PRODUTO_ID	       =>  :P_CARRINHO_PRODUTO_ID);';
					$sql .= 'END;';
				
					$stmt = oci_parse($this->conexao,$sql);
					oci_bind_by_name($stmt,':P_CARRINHO_ID',$arguments['carrinho_id'],4000);
					oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
					oci_bind_by_name($stmt,':P_QUANTIDADE',$arguments['quantidade'],4000);
					oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
				
					$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
					$_SESSION['last_error'] = oci_error($stmt);
				
					if($sucesso){
				
					}
				
					if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
					   $arguments["erro"] = "false";
					   $arguments["mensagem"] = "Produto adicionado com sucesso!";
					}else{
					   $arguments["erro"] = "true";
					   $arguments["mensagem"] = $_SESSION['last_error'];
					   $this->rollback();
					}
					
				}else{
					$arguments["erro"] = "false";
					$arguments["mensagem"] = "Produto adicionado com sucesso!";
					$this->rollback();
				}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 18:56:53 UTC-0300 2009
		 * Altera um produto no carrinho
		 */
		function upd_carrinho_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_carrinho_produto(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_QUANTIDADE	       =>  :P_QUANTIDADE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_QUANTIDADE',$arguments['quantidade'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 4 18:57:39 UTC-0300 2009
		 * Exclui um produto do carrinho
		 */
		function del_carrinho_produto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_carrinho_produto(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 5 19:35:04 UTC-0300 2009
		 * Insere um endereo para o usurio
		 */
		function ins_usuario_endereco($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_usuario_endereco(P_USUARIO   =>  :P_USUARIO,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_MUNICIPIO	       =>  :P_MUNICIPIO,';
			$sql .= '					   P_MUNICIPIO_ID	       =>  :P_MUNICIPIO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_USUARIO_ENDERECO_ID	       =>  :P_USUARIO_ENDERECO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO',$arguments['municipio'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO_ID',$arguments['municipio_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_ENDERECO_ID',$arguments['usuario_endereco_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Endereo Inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 5 19:35:53 UTC-0300 2009
		 * Altera um endereo para o usurio
		 */
		function upd_usuario_endereco($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_usuario_endereco(P_USUARIO_ENDERECO_ID   =>  :P_USUARIO_ENDERECO_ID,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_MUNICIPIO	       =>  :P_MUNICIPIO,';
			$sql .= '					   P_MUNICIPIO_ID	       =>  :P_MUNICIPIO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO_ENDERECO_ID',$arguments['usuario_endereco_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO',$arguments['municipio'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO_ID',$arguments['municipio_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Endereo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed May 6 15:39:21 UTC-0300 2009
		 * Altera para padro o endereo selecionado pelo usurio
		 */
		function upd_usuario_end_padrao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_usuario_end_padrao(P_USUARIO_ENDERECO_ID   =>  :P_USUARIO_ENDERECO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO_ENDERECO_ID',$arguments['usuario_endereco_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Endereo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jun 18 11:18:07 UTC-0300 2009
		 * Altera o status de todos os endereos cadastrados do usurio pra 0
		 */
		function clear_status_end_usuario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_clear_status_end_usuario(P_USUARIO   =>  :P_USUARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Status alterados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 5 19:37:06 UTC-0300 2009
		 * Exclui um endereo para o usurio
		 */
		function del_usuario_endereco($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_usuario_endereco(P_USUARIO_ENDERECO_ID   =>  :P_USUARIO_ENDERECO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO_ENDERECO_ID',$arguments['usuario_endereco_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Endereo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 12 10:51:11 UTC-0300 2009
		 * Insere um tipo de arquivo
		 */
		function ins_tipo_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_tipo_arquivo(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_TIPO_ARQUIVO_ID	       =>  :P_TIPO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ARQUIVO_ID',$arguments['tipo_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 12 10:51:45 UTC-0300 2009
		 * Altera um tipo de arquivo
		 */
		function upd_tipo_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_tipo_arquivo(P_TIPO_ARQUIVO_ID   =>  :P_TIPO_ARQUIVO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_ARQUIVO_ID',$arguments['tipo_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 12 10:52:28 UTC-0300 2009
		 * Exclui um tipo de arquivo
		 */
		function del_tipo_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_tipo_arquivo(P_TIPO_ARQUIVO_ID   =>  :P_TIPO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_ARQUIVO_ID',$arguments['tipo_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 12 16:54:13 UTC-0300 2009
		 * Insere um tipo de arquivo para o produto
		 */
		function ins_produto_tipo_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_produto_tipo_arquivo(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_TIPO_ARQUIVO_ID	       =>  :P_TIPO_ARQUIVO_ID,';
			$sql .= '					   P_PRODUTO_TIPO_ID	       =>  :P_PRODUTO_TIPO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ARQUIVO_ID',$arguments['tipo_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_TIPO_ID',$arguments['produto_tipo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo de arquivo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 12 16:55:01 UTC-0300 2009
		 * Exclui um tipo de arquivo para o produto
		 */
		function del_produto_tipo_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_produto_tipo_arquivo(P_PRODUTO_TIPO_ID   =>  :P_PRODUTO_TIPO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_TIPO_ID',$arguments['produto_tipo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo de arquivo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed May 13 17:23:34 UTC-0300 2009
		 * Insere um arquivo para o produto do carrinho
		 */
		function ins_carrinho_prod_arquivo($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
				
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/',0775,true);
				// Busca a extensao do arquivo original
				$parts = array_reverse(explode('.',$arguments['arquivo']['name']));
				$extensao = strtolower($parts[0]);
				// Cria um nome unico para o arquivo
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao)) {
					$count++;
				}			
				$url_arquivo = '/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao;
				
				// Move o arquivo temporario
				rename($arguments['arquivo']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
				//Atribui Permisses
				chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0666);
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $url_arquivo,
											no_commit		=> 1,
											titulo			=> $parts[1]
											));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['arquivo_id'] = $ret['arquivo_id'];
				
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_carrinho_prod_arquivo(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_PRODUTO_TIPO_ARQUIVO_ID	       =>  :P_PRODUTO_TIPO_ARQUIVO_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID,';
			$sql .= '					   P_CARRINHO_PRODUTO_ARQUIVO_ID	       =>  :P_CARRINHO_PRODUTO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_TIPO_ARQUIVO_ID',$arguments['produto_tipo_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ARQUIVO_ID',$arguments['carrinho_produto_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed May 13 17:24:27 UTC-0300 2009
		 * Altera um arquivo para o produto do carrinho
		 */
		function upd_carrinho_prod_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/',0775,true);
				// Busca a extensao do arquivo original
				$parts = array_reverse(explode('.',$arguments['arquivo']['name']));
				$extensao = strtolower($parts[0]);
				// Cria um nome unico para o arquivo
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao)) {
					$count++;
				}			
				$url_arquivo = '/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao;
				
				// Move o arquivo temporario
				rename($arguments['arquivo']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
				//Atribui Permisses
				chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0666);
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $url_arquivo,
											no_commit		=> 1,
											titulo			=> $parts[1]
											));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['arquivo_id'] = $ret['arquivo_id'];
				
				
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_carrinho_prod_arquivo(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_PRODUTO_TIPO_ARQUIVO_ID	       =>  :P_PRODUTO_TIPO_ARQUIVO_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_TIPO_ARQUIVO_ID',$arguments['produto_tipo_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 15 09:08:56 UTC-0300 2009
		 * Insere um tipo de pagamento
		 */
		function ins_tipo_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_imagem']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Tipo Pagamento/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['descricao'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_tipo_pagamento(P_FORMA   =>  :P_FORMA,';
			$sql .= '					   P_LOGO_ID	       =>  :P_LOGO_ID,';
			$sql .= '					   P_AGENCIA	       =>  :P_AGENCIA,';
			$sql .= '					   P_CONTA	       =>  :P_CONTA,';
			$sql .= '					   P_BANCO	       =>  :P_BANCO,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_TIPO_PAGAMENTO_ID	       =>  :P_TIPO_PAGAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FORMA',$arguments['forma'],4000);
			oci_bind_by_name($stmt,':P_LOGO_ID',$arguments['logo_id'],4000);
			oci_bind_by_name($stmt,':P_AGENCIA',$arguments['agencia'],4000);
			oci_bind_by_name($stmt,':P_CONTA',$arguments['conta'],4000);
			oci_bind_by_name($stmt,':P_BANCO',$arguments['banco'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TIPO_PAGAMENTO_ID',$arguments['tipo_pagamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo de pagamento inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 15 09:09:46 UTC-0300 2009
		 * Altera um tipo de pagamento
		 */
		function upd_tipo_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(strlen(trim($arguments['url_imagem']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Tipo Pagamento/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['descricao'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_tipo_pagamento(P_TIPO_PAGAMENTO_ID   =>  :P_TIPO_PAGAMENTO_ID,';
			$sql .= '					   P_FORMA	       =>  :P_FORMA,';
			$sql .= '					   P_LOGO_ID	       =>  :P_LOGO_ID,';
			$sql .= '					   P_AGENCIA	       =>  :P_AGENCIA,';
			$sql .= '					   P_CONTA	       =>  :P_CONTA,';
			$sql .= '					   P_BANCO	       =>  :P_BANCO,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_PAGAMENTO_ID',$arguments['tipo_pagamento_id'],4000);
			oci_bind_by_name($stmt,':P_FORMA',$arguments['forma'],4000);
			oci_bind_by_name($stmt,':P_LOGO_ID',$arguments['logo_id'],4000);
			oci_bind_by_name($stmt,':P_AGENCIA',$arguments['agencia'],4000);
			oci_bind_by_name($stmt,':P_CONTA',$arguments['conta'],4000);
			oci_bind_by_name($stmt,':P_BANCO',$arguments['banco'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo de pagamento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 15 09:10:38 UTC-0300 2009
		 * Exclui um tipo de pagamento
		 */
		function del_tipo_pagamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_tipo_pagamento(P_TIPO_PAGAMENTO_ID   =>  :P_TIPO_PAGAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_PAGAMENTO_ID',$arguments['tipo_pagamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo de pagamento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 15 11:14:48 UTC-0300 2009
		 * Alterada a forma de pagmento atribuida no carrinho
		 */
		function upd_forma_pag_carrinho($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_forma_pag_carrinho(P_CARRINHO_ID   =>  :P_CARRINHO_ID,';
			$sql .= '					   P_FORMA_PAGAMENTO_ID	       =>  :P_FORMA_PAGAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_ID',$arguments['carrinho_id'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO_ID',$arguments['forma_pagamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Forma alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 18 17:10:46 UTC-0300 2009
		 * Insere um acabamento.
		 */
		function ins_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_acabamento(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 18 17:11:14 UTC-0300 2009
		 * Altera um acabamento.
		 */
		function upd_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_acabamento(P_ACABAMENTO_ID   =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 18 17:11:48 UTC-0300 2009
		 * Exclui um acabamento.
		 */
		function del_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_acabamento(P_ACABAMENTO_ID   =>  :P_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 18 18:23:22 UTC-0300 2009
		 * Insere um valor para o acabamento
		 */
		function ins_acabamento_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_acabamento_valor(P_ACABAMENTO_ID   =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_ACABAMENTO_VALOR_ID	       =>  :P_ACABAMENTO_VALOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_VALOR_ID',$arguments['acabamento_valor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon May 18 18:24:12 UTC-0300 2009
		 * Exclui um valor para o acabamento
		 */
		function del_acabamento_valor($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_acabamento_valor(P_ACABAMENTO_VALOR_ID   =>  :P_ACABAMENTO_VALOR_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ACABAMENTO_VALOR_ID',$arguments['acabamento_valor_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Valor excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 19 09:38:55 UTC-0300 2009
		 * Insere um cabamento para o produp
		 */
		function ins_produto_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_produto_acabamento(P_PRODUTO_ID   =>  :P_PRODUTO_ID,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_PRODUTO_ACABAMENTO_ID	       =>  :P_PRODUTO_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ACABAMENTO_ID',$arguments['produto_acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 19 09:39:44 UTC-0300 2009
		 * Exclui um cabamento para o produp
		 */
		function del_produto_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_produto_acabamento(P_PRODUTO_ACABAMENTO_ID   =>  :P_PRODUTO_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRODUTO_ACABAMENTO_ID',$arguments['produto_acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 19 15:36:07 UTC-0300 2009
		 * Altera o acabamento do produto no carrinho
		 */
		function upd_carrinho_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_carrinho_acabamento(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 19 15:37:59 UTC-0300 2009
		 * Altera a observaao do produto no carrinho
		 */
		function upd_carrinho_observacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();

			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_carrinho_observacao(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_OBSERVACAO	       =>  :P_OBSERVACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Observao alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue May 26 11:12:26 UTC-0300 2009
		 * Altera a forma de entrega no carrinho de compras
		 */
		function upd_carrinho_entrega($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_carrinho_entrega(P_CARRINHO_ID   =>  :P_CARRINHO_ID,';
			$sql .= '					   P_FORMA_ENTREGA_ID	       =>  :P_FORMA_ENTREGA_ID,';
			$sql .= '					   P_VALOR_ENTREGA	       =>  :P_VALOR_ENTREGA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_ID',$arguments['carrinho_id'],4000);
			oci_bind_by_name($stmt,':P_FORMA_ENTREGA_ID',$arguments['forma_entrega_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR_ENTREGA',$arguments['valor_entrega'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Forma alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 29 11:41:29 UTC-0300 2009
		 * Gera pedido completo
		 */
		function gerar_pedido($arguments=array()){
			$this-> start();
			
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			
			$qrCarrinho = $conn->get_carrinho(array(cod_portal => $arguments['cod_portal'],
													email => $arguments['email']
												 ));

			$qrCarrinhoProdutos = $conn->get_carrinho_produto(array(cod_portal => $arguments['cod_portal'],
															carrinho_id => $qrCarrinho[0]['CARRINHO_ID'] ));

			$qrDados = $conn->get_carrinho_dados(array(carrinho_id => $qrCarrinho[0]['CARRINHO_ID']));
			
			$qrValor = $conn->get_carrinho_valor(array(carrinho_id => $qrCarrinho[0]['CARRINHO_ID']));

			$qrEndereco = $conn->get_usuario_endereco(array(cod_portal => $arguments['cod_portal'],
															usuario => $arguments['usuario'] ,
															padrao => 1	 ));
			
			if(!count($qrEndereco)){
				$connA = CreateObject("portal._class.consulta.acesso");
				$qrUE = $connA->get_usuario_acesso(array(cod_portal => $arguments['cod_portal'],
														 usuario => $arguments['usuario']
													));
			}
			//new dBug($qrUE);
			$cep = count($qrEndereco)?$qrEndereco[0]['CEP']:$qrUE[0]['CEP'];
			$endereco = count($qrEndereco)?$qrEndereco[0]['ENDERECO']:$qrUE[0]['LOGRADOURO'];
			$numero = count($qrEndereco)?$qrEndereco[0]['NUMERO']:$qrUE[0]['NUMERO'];
			$complemento = count($qrEndereco)?$qrEndereco[0]['COMPLEMENTO']:"no fornecido";
			$bairro = count($qrEndereco)?$qrEndereco[0]['BAIRRO']:$qrUE[0]['BAIRRO'];
			$estado = count($qrEndereco)?$qrEndereco[0]['ESTADO']:$qrUE[0]['UF'];
			$municipio = count($qrEndereco)?$qrEndereco[0]['MUNICIPIO']:$qrUE[0]['CIDADE'];
			$municipio_id = count($qrEndereco)?$qrEndereco[0]['MUNICIPIO_ID']:$qrUE[0]['MUNICIPIO_ID'];
			
			
			//INSERE O PEDIDO ------------------------------------------------------------------------------------------------------------
			$pedido = $this->ins_pedido(array(prazo => $qrDados[0]['PRAZO'],
										   peso_total => $qrDados[0]['PESO'],
										   valor_total => $qrValor[0]['VALOR'],
										   forma_entrega_id => $qrCarrinho[0]['FORMA_ENTREGA_ID'],
										   valor_entrega => $qrCarrinho[0]['VALOR_ENTREGA'],
										   cep => $cep,
										   endereco => $endereco,
										   numero => $numero,
										   complemento => $complemento,
										   bairro => $bairro,
										   estado =>  $estado,
										   municipio => $municipio,
										   municipio_id => $municipio_id,
										   cod_portal => $arguments['cod_portal'],
										   usuario => $arguments['usuario'],
										   tipo_pagamento_id => $qrCarrinho[0]['FORMA_PAGAMENTO_ID'],
										   no_commit => 1
										 ));

			if($pedido['erro'] == 'true')
				return $pedido;

			//INSERE OS PRODUTOS DO PEDIDO ------------------------------------------------------------------------------------------------
			for($i=0; $i<count($qrCarrinhoProdutos); $i++){
				$qrPreco = $conn->get_produto_valor(array(cod_portal => $arguments['cod_portal'],
														  data => date("d/m/Y G:i:s")
														 ));
				
				/*if(strlen(trim($qrCarrinhoProdutos[$i]['ACABAMENTO_ID']))){
					$qrPrecoAcabamento = $conn->get_acabamento_valor(array(acabamento_id => $qrCarrinhoProdutos[$i]['ACABAMENTO_ID']));
			   	}*/
				 
				$produto = $this->ins_pedido_produto(array(pedido_id => $pedido['pedido_id'],
														   produto_id => $qrCarrinhoProdutos[$i]['PRODUTO_ID'],
														   quantidade => $qrCarrinhoProdutos[$i]['QUANTIDADE'],
														   valor_produto => $qrPreco[0]['VALOR'],
														   acabamento_id => $qrCarrinhoProdutos[$i]['ACABAMENTO_ID'],
														   //valor_acabamento => $qrPrecoAcabamento[0]['VALOR'],
														   observacao => $qrCarrinhoProdutos[$i]['OBSERVACAO'],
														   carrinho_id => $qrCarrinho[0]['CARRINHO_ID'],
														   largura => $qrCarrinhoProdutos[$i]['LARGURA'],
														   altura => $qrCarrinhoProdutos[$i]['ALTURA'],
														   no_commit => 1
														 ));
				
				if($produto['erro'] == 'true')
					return $produto;
					
					$qrAcab = $conn->get_car_produto_acabamento(array(carrinho_produto_id => $qrCarrinhoProdutos[$i]['CARRINHO_PRODUTO_ID']));

					//INSERE OS ACABAMENTOS DO PRODUTO ------------------------------------------------------------------------------------
					for($j=0; $j<count($qrAcab); $j++){
						$qrPrecoAcabamento = $conn->get_acabamento_valor(array(acabamento_id => $qrAcab[$j]['ACABAMENTO_ID']));

						$acabamentos = $this->ins_pedido_acabamento(array(pedido_produto_id => $produto['pedido_produto_id'],
																		  acabamento_id => $qrAcab[$j]['ACABAMENTO_ID'],
																		  distancia => $qrAcab[$j]['DISTANCIA'],
																		  valor => number_format($qrPrecoAcabamento[0]['VALOR'],2,'.',''),
																		  no_commit => 1
																	));
						if($acabamento['erro'] == 'true')
							return $acabamento;
					}
				
			
			
				//INSERE OS ARQUIVOS DOS PRODUTOS DO PEDIDO -------------------------------------------------------------------------------
				$qrArquivo = $conn->get_carrinho_produto_arquivo(array(carrinho_produto_id => $qrCarrinhoProdutos[$i]['CARRINHO_PRODUTO_ID']));
					
				for($j=0; $j<count($qrArquivo); $j++){
					$arquivo = $this->ins_pedido_produto_arquivo(array(pedido_produto_id => $produto['pedido_produto_id'],
																	   tipo_arquivo_id => $qrArquivo[$j]['PRODUTO_TIPO_ARQUIVO_ID'],
																	   arquivo_id	=> $qrArquivo[$j]['ARQUIVO_ID'],
																	   no_commit => 1
																	 ));
					if($arquivo['erro'] == 'true')
						return $arquivo;
				}
				
				//EXCLUI O CARRINHO -------------------------------------------------------------------
				$carrinho = $this->del_carrinho(array(carrinho_id => $qrCarrinho[0]['CARRINHO_ID'],
													  no_commit => 1));
				
				if($carrinho['erro'] == 'true')
					return $carrinho;

			}

		
			if(@$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pedido concludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 29 11:41:29 UTC-0300 2009
		 * Insere um pedido
		 */
		function ins_pedido($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_pedido(P_PRAZO	       =>  :P_PRAZO,';
			$sql .= '					   P_PESO_TOTAL	       =>  :P_PESO_TOTAL,';
			$sql .= '					   P_VALOR_TOTAL	       =>  :P_VALOR_TOTAL,';
			$sql .= '					   P_FORMA_ENTREGA_ID	       =>  :P_FORMA_ENTREGA_ID,';
			$sql .= '					   P_VALOR_ENTREGA	       =>  :P_VALOR_ENTREGA,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_COMPLEMENTO	       =>  :P_COMPLEMENTO,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_MUNICIPIO	       =>  :P_MUNICIPIO,';
			$sql .= '					   P_MUNICIPIO_ID	       =>  :P_MUNICIPIO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_TIPO_PAGAMENTO_ID	       =>  :P_TIPO_PAGAMENTO_ID,';
			$sql .= '					   P_PEDIDO_ID	       =>  :P_PEDIDO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PRAZO',$arguments['prazo'],4000);
			oci_bind_by_name($stmt,':P_PESO_TOTAL',$arguments['peso_total'],4000);
			oci_bind_by_name($stmt,':P_VALOR_TOTAL',$arguments['valor_total'],4000);
			oci_bind_by_name($stmt,':P_FORMA_ENTREGA_ID',$arguments['forma_entrega_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR_ENTREGA',$arguments['valor_entrega'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_COMPLEMENTO',$arguments['complemento'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO',$arguments['municipio'],4000);
			oci_bind_by_name($stmt,':P_MUNICIPIO_ID',$arguments['municipio_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TIPO_PAGAMENTO_ID',$arguments['tipo_pagamento_id'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$ret = $this->ins_pedido_historico(array(pedido_id => $arguments['pedido_id'],
														 status_id => 1,
														 observacao => "Pedido efetuado.",
														 no_commit => 1
													));
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pedido concludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 29 11:43:16 UTC-0300 2009
		 * Insere um produto para o pedido
		 */
		function ins_pedido_produto($arguments=array()){
			//new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_pedido_produto(P_PEDIDO_ID   =>  :P_PEDIDO_ID,';
			$sql .= '					   P_PRODUTO_ID	       =>  :P_PRODUTO_ID,';
			$sql .= '					   P_QUANTIDADE	       =>  :P_QUANTIDADE,';
			$sql .= '					   P_VALOR_PRODUTO	       =>  :P_VALOR_PRODUTO,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_VALOR_ACABAMENTO	       =>  :P_VALOR_ACABAMENTO,';
			$sql .= '					   P_OBSERVACAO	       =>  :P_OBSERVACAO,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_PEDIDO_PRODUTO_ID	       =>  :P_PEDIDO_PRODUTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
			oci_bind_by_name($stmt,':P_PRODUTO_ID',$arguments['produto_id'],4000);
			oci_bind_by_name($stmt,':P_QUANTIDADE',$arguments['quantidade'],4000);
			oci_bind_by_name($stmt,':P_VALOR_PRODUTO',$arguments['valor_produto'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR_ACABAMENTO',$arguments['valor_acabamento'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ID',$arguments['pedido_produto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto includo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 29 11:44:20 UTC-0300 2009
		 * Insere um arquivo para o produto do pedido
		 */
		function ins_pedido_produto_arquivo($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_pedido_produto_arquivo(P_PEDIDO_PRODUTO_ID   =>  :P_PEDIDO_PRODUTO_ID,';
			$sql .= '					   P_TIPO_ARQUIVO_ID	       =>  :P_TIPO_ARQUIVO_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID,';
			$sql .= '					   P_PEDIDO_PRODUTO_ARQUIVO_ID	       =>  :P_PEDIDO_PRODUTO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ID',$arguments['pedido_produto_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ARQUIVO_ID',$arguments['tipo_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ARQUIVO_ID',$arguments['pedido_produto_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo includo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri May 29 11:55:38 UTC-0300 2009
		 * Avanca uma etapa do pedido
		 */
		function avancar_etapa($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_avancar_etapa(P_PEDIDO_ID   =>  :P_PEDIDO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			$qrPedido = $conn->get_pedido(array(cod_portal => $_SESSION['cod_portal'],
											 	pedido_id  => $arguments['pedido_id']
											  ));
		
			
		
			if($sucesso){
				$ret = $this->ins_pedido_historico(array(pedido_id => $arguments['pedido_id'],
														 status_id => $qrPedido[0]['STATUS_ID'],
														 no_commit => 1
													));
				if($ret['erro'] == 'true')
					return $ret;
			}
			
			
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Status do pedido alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri May 29 11:56:40 UTC-0300 2009
		 * Nega um pedido em uma etapa
		 */
		function negar_pedido($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_regeitar_pedido(P_PEDIDO_ID   =>  :P_PEDIDO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			$qrP = $conn->get_pedido(array(cod_portal => $_SESSION['cod_portal'],
										   pedido_id => $arguments['pedido_id']
										  ));
		
			if($sucesso){
				$ret = $this->ins_pedido_historico(array(pedido_id => $arguments['pedido_id'],
														 status_id => $qrP[0]['STATUS_ID'],
														 observacao => $arguments['observacao'],
														 no_commit => 1
													));
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pedido bloqueado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Jun 8 14:05:19 UTC-0300 2009
		 * Regeita o pedido com os arquivos selecionados
		 */
		function regeitar_pedido_arquivo_all($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
					
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			$qrProdutos = $conn->get_pedido_produto(array(cod_portal => $_SESSION['cod_portal'],
														  pedido_id  => $arguments['pedido_id']
														 ));
			
			for($i=0; $i<count($qrProdutos); $i++){
				$qrArquivos = $conn->get_pedido_produto_arquivo(array(cod_portal => $_SESSION['cod_portal'],
																	  pedido_produto_id => $qrProdutos[$i]['PEDIDO_PRODUTO_ID']
																	 ));
				for($j=0;$j<count($qrArquivos); $j++){
					$arq = $this->aceitar_arquivos(array(pedido_produto_arquivo_id => $qrArquivos[$j]['PEDIDO_PRODUTO_ARQUIVO_ID'],
														 no_commit => 1
														 ));
					
					if($arq['erro'] == 'true')
						return $arq;
				}
			}
				
			$obs = listatoarray($arguments,"observacao_id");
			$id = listatoarray($arguments,"ck_observacao");
			
			for($i=0; $i<count($id); $i++){
				//ATRIBUI AO ARQUIVO A FLAG DE REGEITADO
				$reg = $this->regeitar_pedido_arquivo(array(pedido_produto_arquivo_id => $id[$i],
															no_commit => 1));
				if($reg['erro'] == 'true')
					return $reg;
				
				//INSERE O HISTRICO DE REGEIO DO ARQUIVO
				$ret = $this->ins_ped_prod_arq_regeitado(array(pedido_produto_arquivo_id => $id[$i],
															   observacao => $arguments['observacao_id_'.$id[$i]],
															   no_commit => 1
															  ));
				if($ret['erro'] == 'true')
					return $ret;
			}
			
			//PASSA O PEDIDO PARA O STATUS DE NEGADO
			$qrPedido = $conn->get_pedido(array(cod_portal => $_SESSION['cod_portal'],
												pedido_id => $arguments['pedido_id']
											));
			
			$observacao_historico = $qrPedido[0]['STATUS_ID']==2?'Problemas com o comprovante':'Problemas com o(s) arquivo(s)';
			
			$ped = $this->negar_pedido(array(pedido_id => $arguments['pedido_id'],
									  observacao => $observacao_historico,
									  no_commit => 1
									 ));
			if($ped['erro'] == 'true')
				return $ret;
					
			if(@$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo regeitado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 8 15:31:33 UTC-0300 2009
		 * Marca os arquivos do pedido como OK
		 */
		function aceitar_arquivos($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_aceitar_arquivos(P_PEDIDO_PRODUTO_ARQUIVO_ID   =>  :P_PEDIDO_PRODUTO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ARQUIVO_ID',$arguments['pedido_produto_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Status dos arquivos alterados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 5 16:15:19 UTC-0300 2009
		 * Regeita um arquivo de um produto do pedido
		 */
		function regeitar_pedido_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_regeitar_pedido_arquivo(P_PEDIDO_PRODUTO_ARQUIVO_ID   =>  :P_PEDIDO_PRODUTO_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ARQUIVO_ID',$arguments['pedido_produto_arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pedido negado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jun 3 09:13:19 UTC-0300 2009
		 * Altera o comprovante do pedido
		 */
		function upd_pedido_comprovante($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();

			if(strlen(trim($arguments['arquivo']))){
				
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/',0775,true);
				// Busca a extensao do arquivo original
				$parts = array_reverse(explode('.',$arguments['arquivo']['name']));
				$extensao = strtolower($parts[0]);
				// Cria um nome unico para o arquivo
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/produto/'.$extensao.'_temporario'.$count.'.'.$extensao)) {
					$count++;
				}
				$url_arquivo = '/portal/upload/'.$_SESSION['cod_portal'].'/produto/'.$extensao.'_temporario'.$count.'.'.$extensao;
				// Move o arquivo temporario
				rename($arguments['arquivo']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
				//Atribui Permisses
				chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0666);
				//Atribui caminho a variavel da pgina principal 
				
				
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Produtos/Tipo Pagamento/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $url_arquivo,
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $parts[1].".".$extensao,
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['comprovante_id'] = $ret['foto_id'];
			}	

				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_alt_pedido_comprovante(P_PEDIDO_ID   =>  :P_PEDIDO_ID,';
			$sql .= '					   P_COMPROVANTE_ID	       =>  :P_COMPROVANTE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
			oci_bind_by_name($stmt,':P_COMPROVANTE_ID',$arguments['comprovante_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$ret = $this->ins_pedido_historico(array(pedido_id => $arguments['pedido_id'],
														 status_id => 2,
														 observacao => "Efetuado o envio do comprovante",
														 no_commit => 1
													));
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comprovante alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jun 3 10:36:30 UTC-0300 2009
		 * Insere um histrico para pedido
		 */
		function ins_pedido_historico($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_pedido_historico(P_PEDIDO_ID   =>  :P_PEDIDO_ID,';
			$sql .= '					   P_STATUS_ID	       =>  :P_STATUS_ID,';
			$sql .= '					   P_OBSERVACAO	       =>  :P_OBSERVACAO,';
			$sql .= '					   P_PEDIDO_HISTORICO_ID	       =>  :P_PEDIDO_HISTORICO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
			oci_bind_by_name($stmt,':P_STATUS_ID',$arguments['status_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_HISTORICO_ID',$arguments['pedido_historico_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Histrico atualizado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Jun 8 14:53:19 UTC-0300 2009
		 * insere uma regeio a um arquivo do produto do pedido
		 */
		function ins_ped_prod_arq_regeitado($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_ped_prod_arq_regeitado(P_PEDIDO_PRODUTO_ARQUIVO_ID   =>  :P_PEDIDO_PRODUTO_ARQUIVO_ID,';
			$sql .= '					   P_OBSERVACAO	       =>  :P_OBSERVACAO,';
			$sql .= '					   P_PEDIDO_PROD_ARQ_REGEITADO_ID	       =>  :P_PEDIDO_PROD_ARQ_REGEITADO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ARQUIVO_ID',$arguments['pedido_produto_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACAO',$arguments['observacao'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_PROD_ARQ_REGEITADO_ID',$arguments['pedido_prod_arq_regeitado_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Regeio registrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jun 9 14:32:51 UTC-0300 2009
		 * Insere todos os acabamento para o produto no carrinho
		 */
		function ins_car_produto_all_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			$acabamento = listatoarray($arguments,"acabamento_".$arguments['carrinho_produto_id']);
			
			$conn = CreateObject("portal._class.consulta.imprimaaqui");
			$qrA = $conn->get_car_produto_acabamento(array(carrinho_produto_id => $arguments['carrinho_produto_id']));
			
			for($i=0; $i<count($qrA); $i++){
				if(array_search($qrA[$i]['ACABAMENTO_ID'],$acabamento) === false){
					$ret = $this->del_car_produto_acabamento(array(carrinho_produto_id => $arguments['carrinho_produto_id'],
																   acabamento_id => $qrA[$i]['ACABAMENTO_ID'],
																   no_commit => 1
																  ));
					if($ret['erro'] == 'true')
						return $ret;
				}
			}
			
			
			
			for($i=0; $i<count($acabamento); $i++){
				$ret = $this->ins_car_produto_acabamento(array(carrinho_produto_id => $arguments['carrinho_produto_id'],
															   acabamento_id => $acabamento[$i],
															   distancia => $arguments['distancia_'.$arguments['carrinho_produto_id'].'_'.$acabamento[$i]],
															   no_commit => 1
															  ));
				
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if(@$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jun 9 14:32:51 UTC-0300 2009
		 * Insere um acabamento para o produto no carrinho
		 */
		function ins_car_produto_acabamento($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_ins_car_prod_acabamento(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_DISTANCIA	       =>  :P_DISTANCIA,';
			$sql .= '					   P_CARRINHO_ACABAMENTO_ID	       =>  :P_CARRINHO_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_DISTANCIA',$arguments['distancia'],4000);
			oci_bind_by_name($stmt,':P_CARRINHO_ACABAMENTO_ID',$arguments['carrinho_acabamento_id'],4000);
			
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jun 9 14:33:52 UTC-0300 2009
		 * Altea um acabamento para o produto no carrinho
		 */
		function alt_car_produto_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_car_prod_acabamento(P_CARRINHO_ACABAMENTO_ID   =>  :P_CARRINHO_ACABAMENTO_ID,';
			$sql .= '					   P_DISTANCIA	       =>  :P_DISTANCIA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_ACABAMENTO_ID',$arguments['carrinho_acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_DISTANCIA',$arguments['distancia'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jun 9 15:49:06 UTC-0300 2009
		 * Exclui um acabamento para o produto no carrinho
		 */
		function del_car_produto_acabamento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_del_car_prod_acabamento(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jun 17 15:16:14 UTC-0300 2009
		 * Altera o tamanho desejado para o produto no carrinho
		 */
		function upd_car_produto_dimensao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_produto.prc_alt_car_produto_dimensao(P_CARRINHO_PRODUTO_ID   =>  :P_CARRINHO_PRODUTO_ID,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CARRINHO_PRODUTO_ID',$arguments['carrinho_produto_id'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Produto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Jun 18 17:49:19 UTC-0300 2009
		 * Insere um acabamento para um produto do pedido.
		 */
		function ins_pedido_acabamento($arguments=array()){
			//$arguments['distancia'] = 1;

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_ins_pedido_acabamento(P_PEDIDO_PRODUTO_ID   =>  :P_PEDIDO_PRODUTO_ID,';
			$sql .= '					   P_ACABAMENTO_ID	       =>  :P_ACABAMENTO_ID,';
			$sql .= '					   P_DISTANCIA	       =>  :P_DISTANCIA,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_PEDIDO_PRODUTO_ACABAMENTO_ID	       =>  :P_PEDIDO_PRODUTO_ACABAMENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ID',$arguments['pedido_produto_id'],4000);
			oci_bind_by_name($stmt,':P_ACABAMENTO_ID',$arguments['acabamento_id'],4000);
			oci_bind_by_name($stmt,':P_DISTANCIA',$arguments['distancia'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ACABAMENTO_ID',$arguments['pedido_produto_acabamento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acabamento inserido com sucess!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jul 9 11:19:17 UTC-0300 2009
		 * Altera o arquivo de um produto do pedido
		 */
		function upd_pedido_produto_arquivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/',0775,true);
				// Busca a extensao do arquivo original 
				$parts = array_reverse(explode('.',$arguments['arquivo']['name']));
				$extensao = strtolower($parts[0]);
				// Cria um nome unico para o arquivo
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao)) {
					$count++;
				}			
				$url_arquivo = '/portal/upload/'.$arguments['cod_portal'].'/arquivos/'.$extensao.'_local_'.$count.'.'.$extensao;
				
				// Move o arquivo temporario
				rename($arguments['arquivo']['tmp_name'],$_SERVER['DOCUMENT_ROOT'].$url_arquivo);
				//Atribui Permisses
				chmod($_SERVER['DOCUMENT_ROOT'].$url_arquivo,0666);
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $url_arquivo,
											no_commit		=> 1,
											titulo			=> $parts[1]
											));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['arquivo_id'] = $ret['arquivo_id'];
				
				
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_alt_pedido_produto_arquivo(P_PEDIDO_PRODUTO_ARQUIVO_ID   =>  :P_PEDIDO_PRODUTO_ARQUIVO_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_PRODUTO_ARQUIVO_ID',$arguments['pedido_produto_arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Arquivo Alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Jul 9 15:45:58 UTC-0300 2009
		 * Seta o status negado do pedido para 0
		
		 */
		function liberar_pedido($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_pedido.prc_liberar_pedido(P_PEDIDO_ID   =>  :P_PEDIDO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PEDIDO_ID',$arguments['pedido_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pedido liberado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 11 11:00:13 UTC-0300 2009
		 * Insere uma empresa
		 */
		function ins_empresa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_ins_empresa(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_ADVALOREM	       =>  :P_ADVALOREM,';
			$sql .= '					   P_PEDAGIO	       =>  :P_PEDAGIO,';
			$sql .= '					   P_PESO_EXCEDENTE	       =>  :P_PESO_EXCEDENTE,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_EMPRESA_ID	       =>  :P_EMPRESA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ADVALOREM',$arguments['advalorem'],4000);
			oci_bind_by_name($stmt,':P_PEDAGIO',$arguments['pedagio'],4000);
			oci_bind_by_name($stmt,':P_PESO_EXCEDENTE',$arguments['peso_excedente'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_EMPRESA_ID',$arguments['empresa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Empresa cadastrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 11 11:01:19 UTC-0300 2009
		 * Altera uma empresa
		 */
		function upd_empresa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_alt_empresa(P_EMPRESA_ID   =>  :P_EMPRESA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_ADVALOREM	       =>  :P_ADVALOREM,';
			$sql .= '					   P_PEDAGIO	       =>  :P_PEDAGIO,';
			$sql .= '					   P_PESO_EXCEDENTE	       =>  :P_PESO_EXCEDENTE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EMPRESA_ID',$arguments['empresa_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ADVALOREM',$arguments['advalorem'],4000);
			oci_bind_by_name($stmt,':P_PEDAGIO',$arguments['pedagio'],4000);
			oci_bind_by_name($stmt,':P_PESO_EXCEDENTE',$arguments['peso_excedente'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Empresa alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 11 11:01:49 UTC-0300 2009
		 * Exclui uma empresa
		 */
		function del_empresa($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_del_empresa(P_EMPRESA_ID   =>  :P_EMPRESA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EMPRESA_ID',$arguments['empresa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Empresa excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
				
		/*
		 * Criado em Tue Aug 11 11:02:35 UTC-0300 2009
		 * Insere uma faixa de peso para a empresa
		 */
		function ins_faixa_peso_all($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
				$inicial = listatoarray($arguments,"peso_inicial_peso");
				$final = listatoarray($arguments,"peso_final_peso");
				$valor = listatoarray($arguments,"valor_peso");
				$faixa_id = listatoarray($arguments,'faixa_id_peso');
				
				$conn = CreateObject("portal._class.consulta.imprimaaqui");
				$qrF = $conn->get_faixa_peso(array(cod_portal => $_SESSION['cod_portal'],
												   empresa_id => $_VARS['empresa_id']
												  ));
				
				//EXCLUI OS REGISTROS QUE FORAM REMOVIDOS PELO USURIO
				for($i=0; $i<count($qrF); $i++){
					if(array_search($qrF[$i]['FAIXA_ID'],$faixa_id) === false){
						$ret = $this->del_faixa_peso(array(faixa_id => $qrF[$i]['FAIXA_ID'],
														   no_commit => 1
														   ));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($faixa_id); $i++){

					if(strlen(trim($faixa_id[$i]))){ //ATUALIZA SE JA EXISTIR O REGISTRO
						$ret = $this->upd_faixa_peso(array(faixa_id => $faixa_id[$i],
															peso_inicial => $inicial[$i],
															peso_final  => $final[$i],
															valor		=> $valor[$i],
														   no_commit => 1
														  ));
						if($ret['erro'] == 'true')
							return $ret;
							
					}else{//INSERE SE O REGISTRO AINDA NO EXISTE
						$ret = $this->ins_faixa_peso(array(peso_inicial => $inicial[$i],
															peso_final  => $final[$i],
															valor		=> $valor[$i],
															empresa_id => $arguments['empresa_id'],
															no_commit   => 1
														  ));
						if($ret['erro'] == 'true')
							return $ret;

					}
				}
			
		
			if($sucesso){
		
			}
		
			if(@$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Faixas de peso alteradas com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/*
		 * Criado em Tue Aug 11 11:02:35 UTC-0300 2009
		 * Insere uma faixa de peso para a empresa
		 */
		function ins_faixa_peso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_ins_faixa_peso(P_PESO_INICIAL   =>  :P_PESO_INICIAL,';
			$sql .= '					   P_PESO_FINAL	       =>  :P_PESO_FINAL,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_EMPRESA_ID	       =>  :P_EMPRESA_ID,';
			$sql .= '					   P_FAIXA_ID	       =>  :P_FAIXA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PESO_INICIAL',$arguments['peso_inicial'],4000);
			oci_bind_by_name($stmt,':P_PESO_FINAL',$arguments['peso_final'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_EMPRESA_ID',$arguments['empresa_id'],4000);
			oci_bind_by_name($stmt,':P_FAIXA_ID',$arguments['faixa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Faixa de peso adicionada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 11 11:03:04 UTC-0300 2009
		 * Altera uma faixa de peso para a empresa
		 */
		function upd_faixa_peso($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_alt_faixa_peso(P_FAIXA_ID   =>  :P_FAIXA_ID,';
			$sql .= '					   P_PESO_INICIAL	       =>  :P_PESO_INICIAL,';
			$sql .= '					   P_PESO_FINAL	       =>  :P_PESO_FINAL,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FAIXA_ID',$arguments['faixa_id'],4000);
			oci_bind_by_name($stmt,':P_PESO_INICIAL',$arguments['peso_inicial'],4000);
			oci_bind_by_name($stmt,':P_PESO_FINAL',$arguments['peso_final'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Faixa de peso alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Aug 11 11:03:33 UTC-0300 2009
		 * Exclui uma faixa de peso para a empresa
		 */
		function del_faixa_peso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_del_faixa_peso(P_FAIXA_ID   =>  :P_FAIXA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FAIXA_ID',$arguments['faixa_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Faixa de peso excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Aug 12 15:19:16 UTC-0300 2009
		 * Altera o nmero de pedgios para uma cidade
		 */
		function alt_cidade_pedagio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imprimaaqui.pkg_transporte.prc_alt_cidade_pedagio(P_CIDADE_PEDAGIO_ID   =>  :P_CIDADE_PEDAGIO_ID,';
			$sql .= '					   P_PEDAGIOS	       =>  :P_PEDAGIOS);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CIDADE_PEDAGIO_ID',$arguments['cidade_pedagio_id'],4000);
			oci_bind_by_name($stmt,':P_PEDAGIOS',$arguments['pedagios'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Nmero de pedgios alterados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	}
	global $conexao_banco;
	$ImprimaAquiManipulacaoObj = new ImprimaAquiManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ImprimaAquiManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>