<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ImpressoManipulacaoObj;
if(!$ImpressoManipulacaoObj) {
	class ImpressoManipulacao extends QueryCom {
		/*
		 * Criado em Fri Jun 27 09:51:25 UTC-0300 2008
		 * Insere um caderno
		 */
		function ins_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso_caderno(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PREFIXO	       =>  :P_PREFIXO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_PREFIXO',$arguments['prefixo'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 09:52:59 UTC-0300 2008
		 * Altera um caderno
		 */
		function upd_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PREFIXO	       =>  :P_PREFIXO,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_PREFIXO',$arguments['prefixo'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 09:54:07 UTC-0300 2008
		 * Exclui um caderno
		 */
		function del_impresso_caderno($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso_caderno(P_CADERNO_ID   =>  :P_CADERNO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Caderno excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Fri Jun 27 11:45:26 UTC-0300 2008
		 * Insere um impresso
		 */
		function ins_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$arguments['principal'] = strlen(trim($arguments['principal']))?$arguments['principal']:0;	
				
				
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_DATA_LIMITE	       =>  :P_DATA_LIMITE,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PRINCIPAL	       =>  :P_PRINCIPAL,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_DATA_LIMITE',$arguments['data_limite'],4000);
			
			if(strlen(trim($_VARS['descricao']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
				
			oci_bind_by_name($stmt,':P_PRINCIPAL',$arguments['principal'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 11:54:51 UTC-0300 2008
		 * Altera um impresso
		 */
		function upd_impresso($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$arguments['principal'] = strlen(trim($arguments['principal']))?$arguments['principal']:0;
				
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso(P_IMPRESSO_ID   =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DATA_PUBLICACAO	       =>  :P_DATA_PUBLICACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_COD_EDICAO	       =>  :P_COD_EDICAO,';
			$sql .= '					   P_DATA_LIMITE	       =>  :P_DATA_LIMITE,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_PRINCIPAL	       =>  :P_PRINCIPAL,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_PUBLICACAO',$arguments['data_publicacao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_COD_EDICAO',$arguments['cod_edicao'],4000);
			oci_bind_by_name($stmt,':P_DATA_LIMITE',$arguments['data_limite'],4000);
			
			if(strlen(trim($_VARS['descricao']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else
				oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			
			oci_bind_by_name($stmt,':P_PRINCIPAL',$arguments['principal'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jun 27 11:55:22 UTC-0300 2008
		 * Exclui um impresso
		 */
		function del_impresso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso(P_IMPRESSO_ID   =>  :P_IMPRESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Edio excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:11:23 UTC-0300 2008
		 * Insere uma pagina no impresso
		 */
		function ins_impresso_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if(!isset($arguments['cod_portal']))
				$arguments['cod_portal'] = $_SESSION['cod_portal'];
			$conn = CreateObject("portal._class.manipulacao.site");
			$qrCat = $conn->ins_arquivo_categoria_path(array(
											cod_portal => $arguments['cod_portal'],
											path => '/Edio Impressa/',
											no_commit => 1));
			$categoria_id = $qrCat['categoria_id'];
			
			if($arguments['temporario_pdf'] == "1") {
				$ret = $conn->ins_arquivo(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $categoria_id,
										formato_id		=> 4,
										titulo			=> 'Pgina (PDF)',
										url_temporario 	=> $arguments['url_pdf'],
										no_commit		=> 1,
										));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['pdf_id'] = $ret['arquivo_id'];
				
				/*$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));*/
			}

			if($arguments['temporario_imagem'] == "1") {
				$ret = $conn->ins_arquivo(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $categoria_id,
										formato_id		=> 1,
										titulo			=> 'Pgina (Imagem)',
										url_temporario 	=> $arguments['url_imagem'],
										no_commit		=> 1,
										));
				if($ret['erro'] == 'true') 
					return $ret;

				$arguments['imagem_id'] = $ret['arquivo_id'];

				/*$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));*/
			}
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_ins_impresso_pagina(P_CADERNO_ID   =>  :P_CADERNO_ID,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_NUM_PAGINA	       =>  :P_NUM_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_IMAGEM_ID	       =>  :P_IMAGEM_ID,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF,';
			$sql .= '					   P_PDF_ID	       =>  :P_PDF_ID,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA  	       =>  :P_ALTURA,';
			$sql .= '					   P_PAGINA_ID	       =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_NUM_PAGINA',$arguments['num_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_IMAGEM_ID',$arguments['imagem_id'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
			oci_bind_by_name($stmt,':P_PDF_ID',$arguments['pdf_id'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura_imagem'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura_imagem'],4000);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:12:10 UTC-0300 2008
		 * Altera uma pagina no impresso
		 */
		function upd_impresso_pagina($arguments=array()){
			//new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();

			if(!isset($arguments['cod_portal']))
				$arguments['cod_portal'] = $_SESSION['cod_portal'];
			$conn = CreateObject("portal._class.manipulacao.site");
			$qrCat = $conn->ins_arquivo_categoria_path(array(
											cod_portal => $arguments['cod_portal'],
											path => '/Edio Impressa/',
											no_commit => 1));
			$categoria_id = $qrCat['categoria_id'];
				
			if($arguments['temporario_pdf'] == "1") {
				$ret = $conn->ins_arquivo(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $categoria_id,
										formato_id		=> 4,
										titulo			=> 'Pgina (PDF)',
										url_temporario 	=> $arguments['url_pdf'],
										no_commit		=> 1,
										));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['pdf_id'] = $ret['arquivo_id'];
				/*
				$parts = array_reverse(explode(".",$arguments['url_pdf']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_pdf'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_pdf'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
				*/
			}

			if($arguments['temporario_imagem'] == "1") {
				$ret = $conn->ins_arquivo(array(
										cod_portal		=> $arguments['cod_portal'],
										categoria_id	=> $categoria_id,
										formato_id		=> 1,
										titulo			=> 'Pgina (Imagem)',
										url_temporario 	=> $arguments['url_imagem'],
										no_commit		=> 1,
										));
				if($ret['erro'] == 'true') 
					return $ret;

				$arguments['imagem_id'] = $ret['arquivo_id'];
				/*
				$parts = array_reverse(explode(".",$arguments['url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/",0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT']."/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao);
				$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/',"/portal/upload/".$_SESSION['cod_portal']."/edicao_impressa/".'/'.$extensao."_pagina".$count.".".$extensao));
				*/
			}
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_alt_impresso_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID,';
			$sql .= '					   P_CADERNO_ID	       =>  :P_CADERNO_ID,';
			$sql .= '					   P_IMPRESSO_ID	       =>  :P_IMPRESSO_ID,';
			$sql .= '					   P_NUM_PAGINA	       =>  :P_NUM_PAGINA,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_IMAGEM_ID	       =>  :P_IMAGEM_ID,';
			$sql .= '					   P_URL_PDF	       =>  :P_URL_PDF,';
			$sql .= '					   P_PDF_ID	       =>  :P_PDF_ID,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA  	       =>  :P_ALTURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
			oci_bind_by_name($stmt,':P_CADERNO_ID',$arguments['caderno_id'],4000);
			oci_bind_by_name($stmt,':P_IMPRESSO_ID',$arguments['impresso_id'],4000);
			oci_bind_by_name($stmt,':P_NUM_PAGINA',$arguments['num_pagina'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_IMAGEM_ID',$arguments['imagem_id'],4000);
			oci_bind_by_name($stmt,':P_URL_PDF',$arguments['url_pdf'],4000);
			oci_bind_by_name($stmt,':P_PDF_ID',$arguments['pdf_id'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura_imagem'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura_imagem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 1 18:12:10 UTC-0300 2008
		 * Altera uma pagina no impresso
		 */
		function del_impresso_pagina($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_impresso.prc_del_impresso_pagina(P_PAGINA_ID   =>  :P_PAGINA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PAGINA_ID',$arguments['pagina_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Pagina excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Feb 3 10:59:28 UTC-0200 2009
		 * Insere um Panfleto
		 */
		function ins_panfleto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temp_frente'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Impresso/Panfleto/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_frente'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['capa_id'] = $ret['foto_id'];
			}
			
			if($arguments['temp_verso'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Impresso/Panfleto/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['categoria_id'] = $ret['categoria_id'];

				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_verso'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;

				$arguments['verso_id'] = $ret['foto_id'];
			}
			
				
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_ins_panfleto(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_DATA_LIMITE	       =>  :P_DATA_LIMITE,';
			$sql .= '					   P_CAPA_ID	       =>  :P_CAPA_ID,';
			$sql .= '					   P_VERSO_ID	       =>  :P_VERSO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_PANFLETO_ID	       =>  :P_PANFLETO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_DATA_LIMITE',$arguments['data_limite'],4000);
			oci_bind_by_name($stmt,':P_CAPA_ID',$arguments['capa_id'],4000);
			oci_bind_by_name($stmt,':P_VERSO_ID',$arguments['verso_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PANFLETO_ID',$arguments['panfleto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Panfleto inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
				
		/*
		 * Criado em Tue Feb 3 11:00:07 UTC-0200 2009
		 * Altera um Panfleto
		 */
		function upd_panfleto($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			
			if($arguments['temp_frente'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Impresso/Panfleto/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_frente'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['capa_id'] = $ret['foto_id'];
			}
			
			if($arguments['temp_verso'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Impresso/Panfleto/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;

				$arguments['categoria_id'] = $ret['categoria_id'];

				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_verso'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;

				$arguments['verso_id'] = $ret['foto_id'];
			}
				
				
				
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_alt_panfleto(P_PANFLETO_ID   =>  :P_PANFLETO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DATA_EXIBICAO	       =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_DATA_LIMITE	       =>  :P_DATA_LIMITE,';
			$sql .= '					   P_CAPA_ID	       =>  :P_CAPA_ID,';
			$sql .= '					   P_VERSO_ID	       =>  :P_VERSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PANFLETO_ID',$arguments['panfleto_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_DATA_LIMITE',$arguments['data_limite'],4000);
			oci_bind_by_name($stmt,':P_CAPA_ID',$arguments['capa_id'],4000);
			oci_bind_by_name($stmt,':P_VERSO_ID',$arguments['verso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Panfleto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Feb 3 11:00:44 UTC-0200 2009
		 * Exclui um Panfleto
		 */
		function del_panfleto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_del_panfleto(P_PANFLETO_ID   =>  :P_PANFLETO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PANFLETO_ID',$arguments['panfleto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Panfleto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri Oct 24 10:24:52 UTC-0300 2008
		 * Insere informativos
		 */
		function ins_informativo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				//Insere a categoria da foto da capa
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Impresso/Informativo/Capa/',
																   no_commit => 1
																 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_capa'] = $ret['categoria_capa'];
				//insere a foto no banco
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_capa'],
									categoria_id	=> $arguments['categoria_capa'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
				//recebe o id da foto inserida
				$arguments['capa_id'] = $ret['foto_id'];
				
				if($arguments['url_arquivo'] != ''){
					//insere a categoria do arquivo
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Impresso/Informativo/Arquivo/',
																	   no_commit => 1
																	 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_arquivo'] = $ret['categoria_capa'];
					//insere o arquivo no banco
					$ret = $connSiteMan->ins_arquivo(array(
												cod_portal		=> $arguments['cod_portal'],
												formato_id		=> 4,
												url_temporario 	=> $arguments['url_arquivo'],
												no_commit		=> 1,
												));
					if($ret['erro'] == 'true') 
						return $ret;
					//recebe o id do arquivo inserido
					$arguments['arquivo_id'] = $ret['arquivo_id'];
				}
				
				
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_ins_informativo(P_TITULO   =>  :P_TITULO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_CAPA_ID	       =>  :P_CAPA_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_INFORMATIVO_ID	       =>  :P_INFORMATIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['texto']);
			oci_bind_by_name($stmt,':P_CAPA_ID',$arguments['capa_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_INFORMATIVO_ID',$arguments['informativo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Informativo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 24 10:25:25 UTC-0300 2008
		 * Altera informativos
		 */
		function upd_informativo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$connSiteMan = CreateObject("portal._class.manipulacao.site");
			
			if($argumens['url_capa'] != ''){
				//Insere a categoria da foto da capa
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Impresso/Informativo/Capa/',
																   no_commit => 1
																 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_capa'] = $ret['categoria_capa'];
				//insere a foto no banco
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_capa'],
									categoria_id	=> $arguments['categoria_capa'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
				//recebe o id da foto inserida
				$arguments['capa_id'] = $ret['foto_id'];
			}	
			
			if($arguments['url_arquivo'] != ''){
				//insere a categoria do arquivo
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	   path => '/Impresso/Informativo/Arquivo/',
																   no_commit => 1
																 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_arquivo'] = $ret['categoria_capa'];
				//insere o arquivo no banco
				$ret = $connSiteMan->ins_arquivo(array(
											cod_portal		=> $arguments['cod_portal'],
											formato_id		=> 4,
											url_temporario 	=> $arguments['url_arquivo'],
											no_commit		=> 1,
											));
				if($ret['erro'] == 'true') 
					return $ret;
				//recebe o id do arquivo inserido
				$arguments['arquivo_id'] = $ret['arquivo_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_alt_informativo(P_INFORMATIVO_ID   =>  :P_INFORMATIVO_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_CAPA_ID	       =>  :P_CAPA_ID,';
			$sql .= '					   P_ARQUIVO_ID	       =>  :P_ARQUIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INFORMATIVO_ID',$arguments['informativo_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['texto']);
			oci_bind_by_name($stmt,':P_CAPA_ID',$arguments['capa_id'],4000);
			oci_bind_by_name($stmt,':P_ARQUIVO_ID',$arguments['arquivo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Informativo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 24 10:26:10 UTC-0300 2008
		 * Exclui informativos
		 */
		function del_informativo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	impresso.pkg_impresso.prc_del_informativo(P_INFORMATIVO_ID   =>  :P_INFORMATIVO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_INFORMATIVO_ID',$arguments['informativo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Informativos excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
	}
	global $conexao_banco;
	$ImpressoManipulacaoObj = new ImpressoManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ImpressoManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>