<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ImobiliarioManObj;
if(!$ImobiliarioManObj) {
	class ImobiliarioComMan extends QueryCom {
		/*
		 * Criado em Wed May 14 09:58:04 UTC-0300 2008
		 * Insere uma Imobiliaria
		 */
		function ins_imobiliaria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();
			
			if(strlen(trim($arguments['fotos_url_imagem']))) {
				$connSite = CreateObject("portal._class.consulta.site");
				$conn = CreateObject("portal._class.manipulacao.site");
				$ret = $conn->ins_foto(array(
									cod_portal		=> $_SESSION['cod_portal'],
									categoria_id	=> $connSite->get_portal_parametro(array(cod_parametro => 'CATEGORIA_ID_LOGOTIPO_IMOBILIARIA')),
									titulo			=> $arguments['nome'],
									legenda			=> '',
									descricao		=> '',
									credito			=> '',
									url_imagem		=> $arguments['fotos_url_imagem'],
									largura			=> $arguments['fotos_largura'],
									altura			=> $arguments['fotos_altura'],
									tipo			=> $arguments['fotos_tipo'],
									tamanho			=> $arguments['fotos_tamanho'],
									fotos_url		=> '/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/imobiliarias/',
									temporario		=> $arguments['fotos_temporario']
									));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imobiliaria(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_SITE_URL	       =>  :P_SITE_URL,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_PROPRIETARIO	       =>  :P_PROPRIETARIO,';
			$sql .= '					   P_IMOBILIARIA_ID	       =>  :P_IMOBILIARIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SITE_URL',$arguments['site_url'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_PROPRIETARIO',$arguments['proprietario'],4000);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);		
			
			if($sucesso) {
				$v_telefone_id = listatoarray($arguments,'telefone_id_telefones');
				$v_tipo_id = listatoarray($arguments,'telefones_tipo_id_telefones');
				$v_ddd = listatoarray($arguments,'telefones_ddd_telefones');
				$v_numero = listatoarray($arguments,'telefones_numero_telefones');
				$v_ramal = listatoarray($arguments,'telefones_ramal_telefones');
				$v_contato = listatoarray($arguments,'telefones_contato_telefones');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_telefones'])),implode(',',$v_telefone_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_imobiliaria_telefone(array(
													telefone_id => $v_excluir[$i],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_telefone_id);$i++) {
					if(!strlen(trim($v_telefone_id[$i]))) {
						$ret = $this->ins_imobiliaria_telefone(array(
												telefone_id		=> $v_telefone_id[$i],
												imobiliaria_id	=> $arguments['imobiliaria_id'],
												tipo_id			=> $v_tipo_id[$i],
												ddd				=> $v_ddd[$i],
												numero			=> $v_numero[$i],
												ramal			=> $v_ramal[$i],
												contato			=> $v_contato[$i],
													no_commit	=> 1
												));
					} else {
						$ret = $this->upd_imobiliaria_telefone(array(
												telefone_id		=> $v_telefone_id[$i],
												imobiliaria_id	=> $arguments['imobiliaria_id'],
												tipo_id			=> $v_tipo_id[$i],
												ddd				=> $v_ddd[$i],
												numero			=> $v_numero[$i],
												ramal			=> $v_ramal[$i],
												contato			=> $v_contato[$i],
												no_commit	=> 1
												));
					}
					if($ret['erro'] == 'true') 
						return $ret;
				}
				
				
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imobiliaria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 14 09:58:42 UTC-0300 2008
		 * Altera uma Imobiliaria
		 */
		function upd_imobiliaria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();
			
			if(strlen(trim($arguments['fotos_url_imagem'])) && !strlen(trim($arguments['foto_id']))) {
				$connSite = CreateObject("portal._class.consulta.site");
				$conn = CreateObject("portal._class.manipulacao.site");
				$ret = $conn->ins_foto(array(
									cod_portal		=> $_SESSION['cod_portal'],
									categoria_id	=> $connSite->get_portal_parametro(array(cod_parametro => 'CATEGORIA_ID_LOGOTIPO_IMOBILIARIA')),
									titulo			=> $arguments['nome'],
									legenda			=> '',
									descricao		=> '',
									credito			=> '',
									url_imagem		=> $arguments['fotos_url_imagem'],
									largura			=> $arguments['fotos_largura'],
									altura			=> $arguments['fotos_altura'],
									tipo			=> $arguments['fotos_tipo'],
									tamanho			=> $arguments['fotos_tamanho'],
									fotos_url		=> '/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/imobiliarias/',
									temporario		=> $arguments['fotos_temporario'],
									no_commit		=> 1
									));
				if($ret['erro'] == 'true')
					return $ret;
				$arguments['foto_id'] = $ret['foto_id'];
			}			
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imobiliaria(P_IMOBILIARIA_ID   =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_SITE_URL	       =>  :P_SITE_URL,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_PROPRIETARIO	       =>  :P_PROPRIETARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_SITE_URL',$arguments['site_url'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_PROPRIETARIO',$arguments['proprietario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);

			
			if($sucesso) {
				$v_telefone_id = listatoarray($arguments,'telefone_id_telefones');
				$v_tipo_id = listatoarray($arguments,'telefones_tipo_id_telefones');
				$v_ddd = listatoarray($arguments,'telefones_ddd_telefones');
				$v_numero = listatoarray($arguments,'telefones_numero_telefones');
				$v_ramal = listatoarray($arguments,'telefones_ramal_telefones');
				$v_contato = listatoarray($arguments,'telefones_contato_telefones');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_telefones'])),implode(',',$v_telefone_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_imobiliaria_telefone(array(
													telefone_id => $v_excluir[$i],
													no_commit	=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_telefone_id);$i++) {
					if(!strlen(trim($v_telefone_id[$i]))) {
						$ret = $this->ins_imobiliaria_telefone(array(
												telefone_id		=> $v_telefone_id[$i],
												imobiliaria_id	=> $arguments['imobiliaria_id'],
												tipo_id			=> $v_tipo_id[$i],
												ddd				=> $v_ddd[$i],
												numero			=> $v_numero[$i],
												ramal			=> $v_ramal[$i],
												contato			=> $v_contato[$i],
												no_commit	=> 1
												));
					} else {
						$ret = $this->upd_imobiliaria_telefone(array(
												telefone_id		=> $v_telefone_id[$i],
												imobiliaria_id	=> $arguments['imobiliaria_id'],
												tipo_id			=> $v_tipo_id[$i],
												ddd				=> $v_ddd[$i],
												numero			=> $v_numero[$i],
												ramal			=> $v_ramal[$i],
												contato			=> $v_contato[$i],
												no_commit	=> 1
												));
					}
					if($ret['erro'] == 'true') 
						return $ret;
				}
				
				$v_email = listatoarray($arguments,'usuarios_email_usuarios');
				$v_nivel_acesso = listatoarray($arguments,'usuarios_nivel_acesso_usuarios');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_usuarios'])),implode(',',$v_email)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_imobiliaria_usuario(array(
													imobiliaria_id  => $arguments['imobiliaria_id'],
													usuario			=> $v_excluir[$i],
													no_commit		=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_email);$i++) {
					$ret = $this->ins_imobiliaria_usuario(array(
											usuario		=> $v_email[$i],
											nivel_acesso => $v_nivel_acesso[$i],
											imobiliaria_id	=> $arguments['imobiliaria_id'],
											no_commit	=> 1
											));
					if($ret['erro'] == 'true') 
						return $ret;
				}
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imobiliaria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 14 09:59:12 UTC-0300 2008
		 * Exclui uma Imobiliaria
		 */
		function del_imobiliaria($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imobiliaria(P_IMOBILIARIA_ID   =>  :P_IMOBILIARIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imobiliaria excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
				
		/*
		 * Criado em Wed May 14 16:45:14 UTC-0300 2008
		 * Insere um telefone para a imobiliaria
		 */
		function ins_imobiliaria_telefone($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imobiliaria_telefone(P_IMOBILIARIA_ID   =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_DDD	       =>  :P_DDD,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_RAMAL	       =>  :P_RAMAL,';
			$sql .= '					   P_CONTATO	       =>  :P_CONTATO,';
			$sql .= '					   P_TELEFONE_ID	       =>  :P_TELEFONE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_DDD',$arguments['ddd'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_RAMAL',$arguments['ramal'],4000);
			oci_bind_by_name($stmt,':P_CONTATO',$arguments['contato'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE_ID',$arguments['telefone_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Telefone inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 14 16:48:10 UTC-0300 2008
		 * Altera um telefone para a imobiliaria
		 */
		function upd_imobiliaria_telefone($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imobiliaria_telefone(P_TELEFONE_ID   =>  :P_TELEFONE_ID,';
			$sql .= '					   P_IMOBILIARIA_ID	       =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_DDD	       =>  :P_DDD,';
			$sql .= '					   P_NUMERO	       =>  :P_NUMERO,';
			$sql .= '					   P_RAMAL	       =>  :P_RAMAL,';
			$sql .= '					   P_CONTATO	       =>  :P_CONTATO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TELEFONE_ID',$arguments['telefone_id'],4000);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_DDD',$arguments['ddd'],4000);
			oci_bind_by_name($stmt,':P_NUMERO',$arguments['numero'],4000);
			oci_bind_by_name($stmt,':P_RAMAL',$arguments['ramal'],4000);
			oci_bind_by_name($stmt,':P_CONTATO',$arguments['contato'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Telefone alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 14 16:48:47 UTC-0300 2008
		 * Exclui um telefone para a imobiliaria
		 */
		function del_imobiliaria_telefone($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imobiliaria_telefone(P_TELEFONE_ID   =>  :P_TELEFONE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TELEFONE_ID',$arguments['telefone_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Telefone excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Wed May 14 17:59:15 UTC-0300 2008
		 * Vincula um usuario para a imobiliaria
		 */
		function ins_imobiliaria_usuario($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imobiliaria_usuario(P_IMOBILIARIA_ID   =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_NIVEL_ACESSO	       =>  :P_NIVEL_ACESSO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_NIVEL_ACESSO',$arguments['nivel_acesso'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Usuario vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 14 17:59:55 UTC-0300 2008
		 * Desvincula um usuario para a imobiliaria
		 */
		function del_imobiliaria_usuario($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this->start();

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imobiliaria_usuario(P_IMOBILIARIA_ID   =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Usuario desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		function converte_atributos_imovel_tipo($arguments=array()) {
			$v_descricao = listatoarray($arguments,'atributos_descricao_atributos');
			$v_cod_atributo = listatoarray($arguments,'atributos_cod_atributo_atributos');
			$v_tipo_dado = listatoarray($arguments,'atributos_tipo_dado_atributos');
			$v_tamanho = listatoarray($arguments,'atributos_tamanho_atributos');
			$v_valor_padrao = listatoarray($arguments,'atributos_valor_padrao_atributos');
			$v_obrigatorio = listatoarray($arguments,'atributos_obrigatorio_atributos');
			$v_valores = listatoarray($arguments,'atributos_valores_atributos');
			$v_ordem = listatoarray($arguments,'atributos_ordem_atributos');
			$result = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><atributos></atributos>');
			for($i=0;$i<count($v_descricao);$i++) {
				$atributo = $result->addChild("atributo");
				$atributo->addChild("cod_atributo",$v_cod_atributo[$i]);
				$atributo->addChild("descricao",htmlentities($v_descricao[$i]));
				$atributo->addChild("tipo_dado",$v_tipo_dado[$i]);
				$atributo->addChild("tamanho",$v_tamanho[$i]);
				$atributo->addChild("valor_padrao",$v_valor_padrao[$i]);
				$atributo->addChild("obrigatorio",$v_obrigatorio[$i]);
				$atributo->addChild("valores",$v_valores[$i]);
				$atributo->addChild("ordem",$v_ordem[$i]);
			}
			return $result->asXML();
		}
				
		/*
		 * Criado em Mon May 26 09:41:49 UTC-0300 2008
		 * Insere um tipo de imovel
		 */
		function ins_imovel_tipo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			// Monta o XML com os atributos
			$arguments['atributos'] = html_entity_decode($this->converte_atributos_imovel_tipo($arguments));
				
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_tipo(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_ATRIBUTOS	       =>  sys.xmltype.createxml(:P_ATRIBUTOS),';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTOS',$arguments['atributos'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 26 09:42:23 UTC-0300 2008
		 * Altera um tipo de imovel
		 */
		function upd_imovel_tipo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();

			// Monta o XML com os atributos
			$arguments['atributos'] = html_entity_decode($this->converte_atributos_imovel_tipo($arguments));
				
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imovel_tipo(P_TIPO_ID   =>  :P_TIPO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_ATRIBUTOS	       =>  sys.xmltype.createxml(:P_ATRIBUTOS));';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTOS',$arguments['atributos'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 26 09:42:48 UTC-0300 2008
		 * Exclui um tipo de imovel
		 */
		function del_imovel_tipo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_tipo(P_TIPO_ID   =>  :P_TIPO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Tipo excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 26 14:49:57 UTC-0300 2008
		 * Insere uma finalidade de imoveis
		 */
		function ins_imovel_finalidade($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_finalidade(P_DESCRICAO   =>  :P_DESCRICAO,';
			$sql .= '					   P_COD_PORTAL	       	   =>  :P_COD_PORTAL,';
			$sql .= '					   P_FINALIDADE_ID	       =>  :P_FINALIDADE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_FINALIDADE_ID',$arguments['finalidade_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Finalidade inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 26 14:51:18 UTC-0300 2008
		 * Altera uma finalidade de imoveis
		 */
		function upd_imovel_finalidade($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imovel_finalidade(P_FINALIDADE_ID   =>  :P_FINALIDADE_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FINALIDADE_ID',$arguments['finalidade_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Finalidade alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon May 26 14:51:42 UTC-0300 2008
		 * Exclui uma finalidade de imoveis
		 */
		function del_imovel_finalidade($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_finalidade(P_FINALIDADE_ID   =>  :P_FINALIDADE_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FINALIDADE_ID',$arguments['finalidade_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Finalidade excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		function converte_atributos_imovel($arguments=array()) {
			$v_descricao = listatoarray($arguments,'atributos_descricao_atributos');
			$v_cod_atributo = listatoarray($arguments,'atributos_cod_atributo_atributos');
			$v_tipo_dado = listatoarray($arguments,'atributos_tipo_dado_atributos');
			$v_valor = listatoarray($arguments,'atributos_valor_atributos');
			$result = new SimpleXMLElement('<?xml version="1.0" encoding="UTF-8"?><atributos></atributos>');
			for($i=0;$i<count($v_descricao);$i++) {
				$atributo = $result->addChild($v_cod_atributo[$i]);
				$atributo->addChild("cod_atributo",$v_cod_atributo[$i]);
				$atributo->addChild("descricao",htmlentities($v_descricao[$i]));
				$atributo->addChild("valor",$v_valor[$i]);
			}
			return $result->asXML();
		}
		/*
		 * Criado em Tue May 27 16:10:49 UTC-0300 2008
		 * Insere um imovel
		 */
		function ins_imovel($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			// Monta o XML com os atributos
			$arguments['atributos'] = html_entity_decode($this->converte_atributos_imovel($arguments));

			$connGis = CreateObject("portal._class.manipulacao.gis");
			$retGis = $connGis->ins_referencia(array(
									tipo_id        => $arguments['referencia_tipo_id'],
									nome           => $arguments['titulo'],
									descricao      => $arguments['descricao'],
									cep            => $arguments['cep'],
									logradouro     => $arguments['logradouro'],
									numero         => $arguments['numero'],
									complemento    => $arguments['complemento'],
									bairro         => $arguments['bairro'],
									municipio_id   => $arguments['municipio_id'],
									latitude       => $arguments['latitude'],
									longitude      => $arguments['longitude'],
									no_commit	   => 1
								));
			if($retGis['erro'] == "true") {
				return $retGis;
			}
			$arguments['referencia_id'] = $retGis['referencia_id'];
			
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_FINALIDADE_ID	       =>  :P_FINALIDADE_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_AREA_CONSTRUIDA	       =>  :P_AREA_CONSTRUIDA,';
			$sql .= '					   P_AREA	       =>  :P_AREA,';
			$sql .= '					   P_ATRIBUTOS	       =>  XMLTYPE.createxml(:P_ATRIBUTOS),';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_OBSERVACOES	       =>  :P_OBSERVACOES,';
			$sql .= '					   P_IMOVEL_ID	       =>  :P_IMOVEL_ID,';
			$sql .= ' 					   P_DESTAQUE			=>  :P_DESTAQUE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_FINALIDADE_ID',$arguments['finalidade_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_AREA_CONSTRUIDA',$arguments['area_construida'],4000);
			oci_bind_by_name($stmt,':P_AREA',$arguments['area'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTOS',$arguments['atributos'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACOES',$arguments['observacoes'],4000);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$connSite = CreateObject("portal._class.manipulacao.site");
				$connGis = CreateObject("portal._class.manipulacao.gis");
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
	
				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.imobiliario");
				$connGis2 = CreateObject("portal._class.consulta.gis");
				$qrImovelFoto = $conn->get_imovel_foto(array(imovel_id => $arguments['imovel_id']));
				$qrReferenciaFoto = $connGis2->get_referencia_foto(array(referencia_id => $arguments['referencia_id']));
				
				for($i=0;$i<count($qrImovelFoto);$i++) {
					if(array_search($qrImovelFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_imovel_foto(array(
											imovel_id 		=> $arguments['imovel_id'],
											foto_id			=> $qrReferenciaFoto[$i]['FOTO_ID'],
											no_commit		=> 1
										));
					}
				}			
				for($i=0;$i<count($qrReferenciaFoto);$i++) {
					if(array_search($qrReferenciaFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_referencia_foto(array(
											referencia_id 		=> $arguments['referencia_id'],
											foto_id			=> $qrReferenciaFoto[$i]['FOTO_ID'],
											no_commit		=> 1
											));
					}
				}			
								
				for($i=0;$i<count($v_foto_id);$i++) {
					if(!strlen(trim($v_foto_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $connSite->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						// Vincula a foto ao imovel
						$ret2 = $this->ins_imovel_foto(array(
												imovel_id	=> $arguments['imovel_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
						// Vincula a imagem a referencia
						$ret3 = $connGis->ins_referencia_foto(array(
												referencia_id	=> $arguments['referencia_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret3['erro'] == 'true') 
							return $ret3;							
					} else {
						// Vincula a imagem ao imovel
						$ret2 = $this->ins_imovel_foto(array(
												imovel_id	=> $arguments['imovel_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
						// Vincula a imagem a referencia
						$ret3 = $connGis->ins_referencia_foto(array(
												referencia_id	=> $arguments['referencia_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret3['erro'] == 'true') 
							return $ret3;
					}
				}
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');

				// Busca os filmes cadastradas para identificar quais precisam ser excluidas
				$qrImovelVideo = $conn->get_imovel_video(array(filme_id => $arguments['filme_id']));
				/*
				for($i=0;$i<count($qrImovelVideo);$i++) {
					if(array_search($qrImovelVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_imovel_video(array(
											imovel_id 			=> $arguments['imovel_id'],
											video_id			=> $qrImovelVideo[$i]['VIDEO_ID'],
											no_commit			=> 1
											));
					}
					if($ret['erro'] == "true")
						return $ret;
				}*/
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $connSite->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_imovel_video(array(
												imovel_id		=> $arguments['imovel_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_imovel_video(array(
												imovel_id		=> $arguments['imovel_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
				$ret3 = $this->ins_imovel_imobiliaria(array(imovel_id		=> $arguments['imovel_id'],
															imobiliaria_id	=> $arguments['imobiliaria_id'],
															valor			=> $arguments['valor'],
															data_inicio		=> $arguments['data_inicio'],
															data_termino	=> $arguments['data_termino'],
															tipo_venda_id	=> $arguments['tipo_venda_id'],
															no_commit		=> 1
													));
				if($ret3['erro'] == 'true')
					return $ret3;
				
				$arg = $arguments;
				$arg['no_commit'] = 1;
				
				$ret4 = $this->vincular_imovel_finceiras($arg);
				if($ret4['erro'] == 'true')
					return $ret4;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imovel inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 27 16:11:40 UTC-0300 2008
		 * Altera um imovel
		 */
		function upd_imovel($arguments=array()){
			
		
			if(!isset($arguments['no_commit'])){
				$this-> start();
				print("START");
			}	
				
			// Monta o XML com os atributos
			$arguments['atributos'] = html_entity_decode($this->converte_atributos_imovel($arguments));

			$connGis = CreateObject("portal._class.manipulacao.gis");
			$retGis = $connGis->upd_referencia(array(
									referencia_id  => $arguments['referencia_id'],
									tipo_id        => $arguments['referencia_tipo_id'],
									nome           => $arguments['titulo'],
									descricao      => $arguments['descricao'],
									cep            => $arguments['cep'],
									logradouro     => $arguments['logradouro'],
									numero         => $arguments['numero'],
									complemento    => $arguments['complemento'],
									bairro         => $arguments['bairro'],
									municipio_id   => $arguments['municipio_id'],
									latitude       => $arguments['latitude'],
									longitude      => $arguments['longitude'],
									no_commit	   => 1
								));
			if($retGis['erro'] == "true") {
				return $retGis;
			}
			$arguments['referencia_id'] = $retGis['referencia_id'];

			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imovel(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_FINALIDADE_ID	       =>  :P_FINALIDADE_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_AREA_CONSTRUIDA	       =>  :P_AREA_CONSTRUIDA,';
			$sql .= '					   P_AREA	       =>  :P_AREA,';
			$sql .= '					   P_ATRIBUTOS	       =>  XMLTYPE.createxml(:P_ATRIBUTOS),';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_OBSERVACOES	       =>  :P_OBSERVACOES,';
			$sql .= ' 					   P_DESTAQUE				=>  :P_DESTAQUE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_FINALIDADE_ID',$arguments['finalidade_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_AREA_CONSTRUIDA',$arguments['area_construida'],4000);
			oci_bind_by_name($stmt,':P_AREA',$arguments['area'],4000);
			oci_bind_by_name($stmt,':P_ATRIBUTOS',$arguments['atributos'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_OBSERVACOES',$arguments['observacoes'],4000);
			oci_bind_by_name($stmt,':P_DESTAQUE',$arguments['destaque'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$connSite = CreateObject("portal._class.manipulacao.site");
				$connGis = CreateObject("portal._class.manipulacao.gis");
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
	
				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.imobiliario");				
				$connGis2 = CreateObject("portal._class.consulta.gis");
				$qrImovelFoto = $conn->get_imovel_foto(array(imovel_id => $arguments['imovel_id']));
				$qrReferenciaFoto = $connGis2->get_referencia_foto(array(referencia_id => $arguments['referencia_id']));
				
				for($i=0;$i<count($qrImovelFoto);$i++) {
					if(array_search($qrImovelFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_imovel_foto(array(
											imovel_id 		=> $arguments['imovel_id'],
											foto_id			=> $qrImovelFoto[$i]['FOTO_ID'],
											no_commit		=> 1
											));
					}
					if($ret['erro'] == "true")
						return $ret;
				}			
				for($i=0;$i<count($qrReferenciaFoto);$i++) {
					if(array_search($qrReferenciaFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_referencia_foto(array(
											referencia_id 		=> $arguments['referencia_id'],
											foto_id			=> $qrReferenciaFoto[$i]['FOTO_ID'],
											no_commit		=> 1
											));
					}
				}			
								
				for($i=0;$i<count($v_foto_id);$i++) {
					if(!strlen(trim($v_foto_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $connSite->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						// Vincula a foto ao imovel
						$ret2 = $this->ins_imovel_foto(array(
												imovel_id	=> $arguments['imovel_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
						// Vincula a imagem a referencia
						$ret3 = $connGis->ins_referencia_foto(array(
												referencia_id	=> $arguments['referencia_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret3['erro'] == 'true') 
							return $ret3;							
					} else {
						// Vincula a imagem ao imovel
						$ret2 = $this->ins_imovel_foto(array(
												imovel_id	=> $arguments['imovel_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
						// Vincula a imagem a referencia
						$ret3 = $connGis->ins_referencia_foto(array(
												referencia_id	=> $arguments['referencia_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret3['erro'] == 'true') 
							return $ret3;
					}
				}
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');

				// Busca os filmes cadastradas para identificar quais precisam ser excluidas
				$qrImovelVideo = $conn->get_imovel_video(array(filme_id => $arguments['filme_id']));
				
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $connSite->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_imovel_video(array(
												imovel_id		=> $arguments['imovel_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_imovel_video(array(
												imovel_id		=> $arguments['imovel_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
				$ret3 = $this->upd_imovel_imobiliaria(array(imovel_id		=> $arguments['imovel_id'],
															imobiliaria_id	=> $arguments['imobiliaria_id'],
															valor			=> $arguments['valor'],
															data_inicio		=> $arguments['data_inicio'],
															data_termino	=> $arguments['data_termino'],
															tipo_venda_id	=> $arguments['tipo_venda_id'],
															no_commit		=> 1
													));
				if($ret3['erro'] == 'true')
					return $ret3;
				
				$arg = $arguments;
				$arg['no_commit'] = 1;
				
				$ret4 = $this->vincular_imovel_finceiras($arg);
				if($ret4['erro'] == 'true')
					return $ret4;
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imovel alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 27 16:12:09 UTC-0300 2008
		 * Exclui um imovel
		 */
		function del_imovel($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel(P_IMOVEL_ID   =>  :P_IMOVEL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imovel excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 28 11:47:47 UTC-0300 2008
		 * Insere uma foto para o imovel
		 */
		function ins_imovel_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_foto(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto vinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 28 11:49:25 UTC-0300 2008
		 * Desvincula uma foto para o imovel
		 */
		function del_imovel_foto($arguments=array()){
			//new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_foto(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto desvinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Wed May 28 14:00:49 UTC-0300 2008
		 * Vincula um video ao imovel
		 */
		function ins_imovel_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_video(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 28 14:01:28 UTC-0300 2008
		 * Desvincula um video ao imovel
		 */
		function del_imovel_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_video(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 29 11:54:54 UTC-0300 2008
		 * Vincula um mvel a uma imobiliria
		 */
		function ins_imovel_imobiliaria($arguments=array()){
			new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_imobiliaria(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_IMOBILIARIA_ID	       =>  :P_IMOBILIARIA_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_TIPO_VENDA_ID	       =>  :P_TIPO_VENDA_ID,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_IMOVEL_IMOBILIARIA_ID	       =>  :P_IMOVEL_IMOBILIARIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_IMOBILIARIA_ID',$arguments['imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_TIPO_VENDA_ID',$arguments['tipo_venda_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_IMOVEL_IMOBILIARIA_ID',$arguments['imovel_imobiliaria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imveis vinculados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 29 11:56:16 UTC-0300 2008
		 * Vincula um mvel a uma imobiliria
		 */
		function upd_imovel_imobiliaria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_imovel_imobiliaria(P_IMOVEL_IMOBILIARIA_ID   =>  :P_IMOVEL_IMOBILIARIA_ID,';
			$sql .= '					   P_TIPO_VENDA_ID	       =>  :P_TIPO_VENDA_ID,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_IMOBILIARIA_ID',$arguments['imovel_imobiliaria_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO_VENDA_ID',$arguments['tipo_venda_id'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imveis alterados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jul 30 22:14:01 UTC-0300 2008
		 * Insete um imvel na lista de favoritos
		 */
		function ins_imovel_favorito($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_favorito(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_USUARIO_IMOVEL_ID	       =>  :P_USUARIO_IMOVEL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_IMOVEL_ID',$arguments['usuario_imovel_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "imvel adicionado a lista com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Jul 30 22:15:23 UTC-0300 2008
		 * Exclui um imvel na lista de favoritos
		 */
		function del_imovel_favorito($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_favorito(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   							   P_USUARIO	       =>  :P_USUARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imvel excludo da lista com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
	/**************************************** FINANCEIRA ********************************/
		/*
		 * Criado em Mon Aug 4 11:03:20 UTC-0300 2008
		 * Insere uma financeira
		 */
		function ins_financeira($arguments=array()){
		
			//Copia arquivo temporario para pasta permanente
			$parts = array_reverse(explode(".",$arguments['imagem']));
			$extensao = strtolower($parts[0]);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/',0775,true);
			$count = 0;
			
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao."_arquivo".$count.".".$extensao)) {
				$count++;
			}
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['imagem'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao.'_arquivo'.$count.".".$extensao);
			$arguments['arquivo'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao.'_arquivo'.$count.".".$extensao));
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_financeira(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_FINANCEIRA_ID	       =>  :P_FINANCEIRA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['arquivo'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_FINANCEIRA_ID',$arguments['financeira_id'],4000);
			
			
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Financeira inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Aug 4 11:05:44 UTC-0300 2008
		 * Altera uma financeira
		 */
		function upd_financeira($arguments=array()){
		
			if($arguments['temporario'] == 1){
				//Copia arquivo temporario para pasta permanente
				$parts = array_reverse(explode(".",$arguments['imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/publicidade/arquivo/',0775,true);
				$count = 0;
				
				while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao."_arquivo".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['imagem'],$_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao.'_arquivo'.$count.".".$extensao);
				$arguments['arquivo'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/imoveis/financeira/'.$extensao.'_arquivo'.$count.".".$extensao));				
			}else
				$arguments['arquivo'] = $arguments['imagem'];
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_alt_financeira(P_FINANCEIRA_ID   =>  :P_FINANCEIRA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FINANCEIRA_ID',$arguments['financeira_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['arquivo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Financeira alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
	
		/*
		 * Criado em Mon Aug 4 11:06:35 UTC-0300 2008
		 * Excli uma financeira
		 */
		function del_financeira($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_financeira(P_FINANCEIRA_ID   =>  :P_FINANCEIRA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FINANCEIRA_ID',$arguments['financeira_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Financeira excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		function vincular_imovel_finceiras($arguments=array()){			
			
			$financeira = listatoarray($arguments,"financeira_id_financeira");
								
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$ret = $this->del_imovel_financeira(array(imovel_id => $arguments['imovel_id'],
													  no_commit => 1
													 ));
			if($ret["erro"] == "true")
				return $ret;
			
			for($i=0;$i<count($financeira);$i++){
				$ret2 = $this->ins_imovel_financeira(array(imovel_id => $arguments['imovel_id'],
												   financeira_id 	=> $financeira[$i],
												   no_commit		=> 1
										     ));
				if($ret2["erro"] == "true"){
					new dBug($ret2);
					return $ret2;
				}
			}
			
			if(isset($arguments['no_commit']) || @$this->commit()){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Financeira(s) vinculada(s) com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			
			return $arguments;
		}
		
		/*
		 * Criado em Wed Aug 6 15:36:54 UTC-0300 2008
		 * Vincula um imvel a uma financeira
		 */
		function ins_imovel_financeira($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_ins_imovel_financeira(P_IMOVEL_ID   =>  :P_IMOVEL_ID,';
			$sql .= '					   P_FINANCEIRA_ID	       =>  :P_FINANCEIRA_ID,';
			$sql .= '					   P_IMOVEL_APROVACAO_ID	       =>  :P_IMOVEL_APROVACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
			oci_bind_by_name($stmt,':P_FINANCEIRA_ID',$arguments['financeira_id'],4000);
			oci_bind_by_name($stmt,':P_IMOVEL_APROVACAO_ID',$arguments['imovel_aprovacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imvel vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Aug 6 15:38:42 UTC-0300 2008
		 * Desvincula um imvel de suas financeiras
		 */
		function del_imovel_financeira($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	imobiliario.pkg_imovel.prc_del_imovel_financeira(P_IMOVEL_ID   =>  :P_IMOVEL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_IMOVEL_ID',$arguments['imovel_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "imvel desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
	}
	global $conexao_banco;
	$ImobiliarioManObj = new ImobiliarioComMan($conexao_banco);
}

global $createdObject;
$createdObject = $ImobiliarioManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>