<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");


global $EventosObj;
if(!$EventosObj) {
	class EventosMan extends QueryCom {
	
		/*
		 * Criado em Thu Jan 15 11:05:18 UTC-0200 2009
		 * Insere uma data de evento
		 */
		function ins_agenda($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temporario'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Agenda/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			
			
			//Insere a imagem do bonus no banco de dados
			if(strlen(trim($arguments['url_bonus']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Agenda/Bonus/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_bonus'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['bonus_id'] = $ret['foto_id'];
			}
			
			$arguments['lista_vip'] = strlen(trim($arguments['lista_vip']))?$arguments['lista_vip']:0;
				
			
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_ins_agenda(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_LOCAL	       =>  :P_LOCAL,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_DETALHES	       =>  :P_DETALHES,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_INGRESSO	       =>  :P_INGRESSO,';
			$sql .= '					   P_PONTO_VENDA	   =>  :P_PONTO_VENDA,';
			$sql .= '					   P_BONUS_ID	   =>  :P_BONUS_ID,';
			$sql .= '					   P_LISTA_VIP	   =>  :P_LISTA_VIP,';
			$sql .= '					   P_DATA_INICIO_LISTA	   =>  :P_DATA_INICIO_LISTA,';
			$sql .= '					   P_DATA_TERMINO_LISTA	   =>  :P_DATA_TERMINO_LISTA,';
			$sql .= '					   P_INFORMACOES	   =>  :P_INFORMACOES,';
			$sql .= '					   P_SITE_LOCAL	   =>  :P_SITE_LOCAL,';			
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_AGENDA_ID	       =>  :P_AGENDA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_LOCAL',$arguments['local'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_DETALHES',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['detalhes']);
			
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_INGRESSO',$arguments['ingresso'],4000);
			oci_bind_by_name($stmt,':P_PONTO_VENDA',$arguments['ponto_venda'],4000);
			oci_bind_by_name($stmt,':P_BONUS_ID',$arguments['bonus_id'],4000);
			oci_bind_by_name($stmt,':P_LISTA_VIP',$arguments['lista_vip'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO_LISTA',$arguments['data_inicio_lista'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO_LISTA',$arguments['data_termino_lista'],4000);
			oci_bind_by_name($stmt,':P_INFORMACOES',$arguments['informacoes'],4000);
			oci_bind_by_name($stmt,':P_SITE_LOCAL',$arguments['site_local'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_AGENDA_ID',$arguments['agenda_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento cadastrado na agenda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Jan 15 11:06:03 UTC-0200 2009
		 * Altera uma data de evento
		 */
		function upd_agenda($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['temporario'] == 1){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Agenda/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			

			
			//Insere a imagem do bonus no banco de dados
			if(strlen(trim($arguments['url_bonus']))){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret2 = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Agenda/Bonus',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret2 = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_bonus'],
									categoria_id	=> $arguments['categoria_id'],
									no_commit 		=> 1
									));
				if($ret2['erro'] == 'true') 
					return $ret2;
					
				$arguments['bonus_id'] = $ret2['foto_id'];
			}
			
			$arguments['lista_vip'] = strlen(trim($arguments['lista_vip']))?$arguments['lista_vip']:0;

			
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_alt_agenda(P_AGENDA_ID   =>  :P_AGENDA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_LOCAL	       =>  :P_LOCAL,';
			$sql .= '					   P_ENDERECO	       =>  :P_ENDERECO,';
			$sql .= '					   P_DETALHES	       =>  :P_DETALHES,';
			$sql .= '					   P_INGRESSO	       =>  :P_INGRESSO,';
			$sql .= '					   P_PONTO_VENDA	   =>  :P_PONTO_VENDA,';
			$sql .= '					   P_BONUS_ID	   =>  :P_BONUS_ID,';
			$sql .= '					   P_LISTA_VIP	   =>  :P_LISTA_VIP,';
			$sql .= '					   P_DATA_INICIO_LISTA	   =>  :P_DATA_INICIO_LISTA,';
			$sql .= '					   P_DATA_TERMINO_LISTA	   =>  :P_DATA_TERMINO_LISTA,';
			$sql .= '					   P_INFORMACOES	   =>  :P_INFORMACOES,';
			$sql .= '					   P_SITE_LOCAL	   =>  :P_SITE_LOCAL,';	
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_AGENDA_ID',$arguments['agenda_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_LOCAL',$arguments['local'],4000);
			oci_bind_by_name($stmt,':P_ENDERECO',$arguments['endereco'],4000);
			
			$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
			oci_bind_by_name($stmt,':P_DETALHES',$clob,-1,OCI_B_CLOB);
			$clob->writeTemporary($arguments['detalhes']);
			
			oci_bind_by_name($stmt,':P_INGRESSO',$arguments['ingresso'],4000);
			oci_bind_by_name($stmt,':P_PONTO_VENDA',$arguments['ponto_venda'],4000);
			oci_bind_by_name($stmt,':P_BONUS_ID',$arguments['bonus_id'],4000);
			oci_bind_by_name($stmt,':P_LISTA_VIP',$arguments['lista_vip'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO_LISTA',$arguments['data_inicio_lista'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO_LISTA',$arguments['data_termino_lista'],4000);
			oci_bind_by_name($stmt,':P_INFORMACOES',$arguments['informacoes'],4000);
			oci_bind_by_name($stmt,':P_SITE_LOCAL',$arguments['site_local'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento alterado na agenda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Jan 15 11:06:42 UTC-0200 2009
		 * Exclui uma data de evento
		 */
		function del_agenda($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_del_agenda(P_AGENDA_ID   =>  :P_AGENDA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_AGENDA_ID',$arguments['agenda_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento excludo da agenda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Nov 23 00:28:08 UTC-0200 2009
		 * Insere um balcao de negcios
		 */
		function ins_balcao_negocio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_ins_balcao_negocio(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE,';
			$sql .= '					   P_CELULAR	       =>  :P_CELULAR,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_CNPJ_CPF	       =>  :P_CNPJ_CPF,';
			$sql .= '					   P_RG	       =>  :P_RG,';
			$sql .= '					   P_LOGRADOURO	       =>  :P_LOGRADOURO,';
			$sql .= '					   P_CIDADE	       =>  :P_CIDADE,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_FORMA_PAGAMENTO	       =>  :P_FORMA_PAGAMENTO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_PARCELAS	       =>  :P_PARCELAS,';
			$sql .= '					   P_VALOR_PARCELA	       =>  :P_VALOR_PARCELA,';
			$sql .= '					   P_DATA_PARCELA	       =>  :P_DATA_PARCELA,';
			$sql .= '					   P_ESTADO	       =>  :P_ESTADO,';
			$sql .= '					   P_NUM_INSCRICAO	       =>  :P_NUM_INSCRICAO,';
			$sql .= '					   P_BALCAO_NEGOCIO_ID	       =>  :P_BALCAO_NEGOCIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
			oci_bind_by_name($stmt,':P_CELULAR',$arguments['celular'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CNPJ_CPF',$arguments['cnpj_cpf'],4000);
			oci_bind_by_name($stmt,':P_RG',$arguments['rg'],4000);
			oci_bind_by_name($stmt,':P_LOGRADOURO',$arguments['logradouro'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO',$arguments['forma_pagamento'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_PARCELAS',$arguments['parcelas'],4000);
			oci_bind_by_name($stmt,':P_VALOR_PARCELA',$arguments['valor_parcela'],4000);
			oci_bind_by_name($stmt,':P_DATA_PARCELA',$arguments['data_parcela'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_NUM_INSCRICAO',$arguments['num_inscricao'],4000);
			oci_bind_by_name($stmt,':P_BALCAO_NEGOCIO_ID',$arguments['balcao_negocio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados cadastrados com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed May 27 11:40:28 UTC-0300 2009
		 * Altera um balcao de egcios
		 */
		function upd_balcao_negocio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_alt_balcao_negocio(P_BALCAO_NEGOCIO_ID   =>  :P_BALCAO_NEGOCIO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_CNPJ_CPF	       =>  :P_CNPJ_CPF,';
			$sql .= '					   P_RG	       =>  :P_RG,';
			$sql .= '					   P_LOGRADOURO	       =>  :P_LOGRADOURO,';
			$sql .= '					   P_CIDADE	       =>  :P_CIDADE,';
			$sql .= '					   P_BAIRRO	       =>  :P_BAIRRO,';
			$sql .= '					   P_CEP	       =>  :P_CEP,';
			$sql .= '					   P_FORMA_PAGAMENTO	       =>  :P_FORMA_PAGAMENTO,';
			$sql .= '					   P_VALOR	       =>  :P_VALOR,';
			$sql .= '					   P_PARCELAS	       =>  :P_PARCELAS,';
			$sql .= '					   P_VALOR_PARCELA	       =>  :P_VALOR_PARCELA,';
			$sql .= '					   P_DATA_PARCELA	       =>  :P_DATA_PARCELA,';
			$sql .= '					   P_ESTADO		       =>  :P_ESTADO,';
			$sql .= '					   P_CELULAR	       =>  :P_CELULAR,';
			$sql .= '					   P_TELEFONE	       =>  :P_TELEFONE);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BALCAO_NEGOCIO_ID',$arguments['balcao_negocio_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_CNPJ_CPF',$arguments['cnpj_cpf'],4000);
			oci_bind_by_name($stmt,':P_RG',$arguments['rg'],4000);
			oci_bind_by_name($stmt,':P_LOGRADOURO',$arguments['logradouro'],4000);
			oci_bind_by_name($stmt,':P_CIDADE',$arguments['cidade'],4000);
			oci_bind_by_name($stmt,':P_BAIRRO',$arguments['bairro'],4000);
			oci_bind_by_name($stmt,':P_CEP',$arguments['cep'],4000);
			oci_bind_by_name($stmt,':P_FORMA_PAGAMENTO',$arguments['forma_pagamento'],4000);
			oci_bind_by_name($stmt,':P_VALOR',$arguments['valor'],4000);
			oci_bind_by_name($stmt,':P_PARCELAS',$arguments['parcelas'],4000);
			oci_bind_by_name($stmt,':P_VALOR_PARCELA',$arguments['valor_parcela'],4000);
			oci_bind_by_name($stmt,':P_DATA_PARCELA',$arguments['data_parcela'],4000);
			oci_bind_by_name($stmt,':P_ESTADO',$arguments['estado'],4000);
			oci_bind_by_name($stmt,':P_CELULAR',$arguments['celular'],4000);
			oci_bind_by_name($stmt,':P_TELEFONE',$arguments['telefone'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados alterados com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed May 27 09:03:34 UTC-0300 2009
		 * Exclui um balco de negocio
		 */
		function del_balcao_negocio($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_del_balcao_negocio(P_BALCAO_NEGOCIO_ID   =>  :P_BALCAO_NEGOCIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BALCAO_NEGOCIO_ID',$arguments['balcao_negocio_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Dados excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jul 14 16:35:17 UTC-0300 2009
		 * Insere um usuario na lista da agenda do veculo
		 */
		function ins_usuario_agenda($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_ins_usuario_agenda(P_USUARIO   =>  :P_USUARIO,';
			$sql .= '					   P_AGENDA_ID	       =>  :P_AGENDA_ID,';
			$sql .= '					   P_USUARIO_AGENDA_ID	       =>  :P_USUARIO_AGENDA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_AGENDA_ID',$arguments['agenda_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_AGENDA_ID',$arguments['usuario_agenda_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Usurio adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Dec 15 10:30:52 UTC-0200 2009
		 * Insere um projeto
		 */
		function ins_projeto($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_ins_projeto(P_TITULO   =>  :P_TITULO,';
			$sql .= '					   P_SUBTITULO	       =>  :P_SUBTITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID,';
			$sql .= '					   P_INTERNO	       =>  :P_INTERNO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_PROJETO_ID	       =>  :P_PROJETO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_SUBTITULO',$arguments['subtitulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
			oci_bind_by_name($stmt,':P_INTERNO',$arguments['interno'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PROJETO_ID',$arguments['projeto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				$url_foto  = listatoarray($arguments,"fotos_url_imagem_fotos");
				$ordem	   = listatoarray($arguments,"fotos_ordem_fotos");
				$categoria = listatoarray($arguments,"fotos_categoria_id_fotos");
				$foto_id   = listatoarray($arguments,"fotos_foto_id");
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$conn = CreateObject("portal._class.consulta.eventos");

				$qrPF = $conn->get_projeto_foto(array(projeto_id => $arguments['projeto_id']));
				
				for($i=0; $i<count($qrPF); $i++){
					if(array_search($qrPF[$i]['PROJETO_FOTO_ID'],$foto_id)=== false){
						$ret = $this->del_projeto_foto(array(projeto_foto_id => $qrPF[$i]['PROJETO_FOTO_ID'],
																	no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($foto_id); $i++){
					
					if(strlen(trim($foto_id[$i]))){
						
						if(strlen(trim($url_foto[$i]))){
							
							$ret2 = $connSiteMan->upd_arquivo(array(upd_arquivo     => $foto_id[$i],
																	cod_portal		=> $arguments['cod_portal'],
																	url_imagem		=> $url_foto[$i],
																	categoria_id	=> $categoria[$i],
																	tipo_id			=> 1,
																	ordem			=> $ordem[$i],
																	no_commit 		=> 1
																	));
							
							if($ret2['erro'] == 'true') 
								return $ret2;
						}
						
						$ret3 = $this->upd_projeto_foto(array(projeto_foto_id => $foto_id[$i],
															  ordem			  => $ordem[$i],
															  no_commit 	  => 1
															 ));
						
					}else{
					
						$ret2 = $connSiteMan->ins_foto(array(
											cod_portal		=> $arguments['cod_portal'],								
											url_imagem		=> $url_foto[$i],
											categoria_id	=> $categoria[$i],
											no_commit 		=> 1
											));
						if($ret2['erro'] == 'true') 
							return $ret2;
							
						$ret3 = $this->ins_projeto_foto(array(projeto_id => $arguments['projeto_id'],
															  foto_id    => $ret2['foto_id'],
															  ordem		 => $ordem[$i],
															  no_commit	 => 1
															 ));
						if($ret3['erro'] == 'true')
							return $ret3;
					}
					
				}
				
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Projeto cadastrado com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 15 10:33:06 UTC-0200 2009
		 * Altera um projeto
		 */
		function upd_projeto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_alt_projeto(P_PROJETO_ID   =>  :P_PROJETO_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_SUBTITULO	       =>  :P_SUBTITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_INTERNO	       =>  :P_INTERNO,';
			$sql .= '					   P_SECAO_ID	       =>  :P_SECAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PROJETO_ID',$arguments['projeto_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_SUBTITULO',$arguments['subtitulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_INTERNO',$arguments['interno'],4000);
			oci_bind_by_name($stmt,':P_SECAO_ID',$arguments['secao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				$url_foto  = listatoarray($arguments,"fotos_url_imagem_fotos");
				$ordem	   = listatoarray($arguments,"fotos_ordem_fotos");
				$categoria = listatoarray($arguments,"fotos_categoria_id_fotos");
				$foto_id   = listatoarray($arguments,"fotos_foto_id");
				
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$conn = CreateObject("portal._class.consulta.eventos");

				$qrPF = $conn->get_projeto_foto(array(projeto_id => $arguments['projeto_id']));
				
				for($i=0; $i<count($qrPF); $i++){
					if(array_search($qrPF[$i]['PROJETO_FOTO_ID'],$foto_id)=== false){
						$ret = $this->del_projeto_foto(array(projeto_foto_id => $qrPF[$i]['PROJETO_FOTO_ID'],
																	no_commit => 1
																	));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0; $i<count($foto_id); $i++){
					
					if(strlen(trim($foto_id[$i]))){
						
						if(strlen(trim($url_foto[$i]))){
							
							$ret2 = $connSiteMan->upd_arquivo(array(upd_arquivo     => $foto_id[$i],
																	cod_portal		=> $arguments['cod_portal'],
																	url_imagem		=> $url_foto[$i],
																	categoria_id	=> $categoria[$i],
																	tipo_id			=> 1,
																	ordem			=> $ordem[$i],
																	no_commit 		=> 1
																	));
							
							if($ret2['erro'] == 'true') 
								return $ret2;
						}
						
						$ret3 = $this->upd_projeto_foto(array(projeto_foto_id => $foto_id[$i],
															  ordem			  => $ordem[$i],
															  no_commit 	  => 1
															 ));
						
					}else{
					
						$ret2 = $connSiteMan->ins_foto(array(
											cod_portal		=> $arguments['cod_portal'],								
											url_imagem		=> $url_foto[$i],
											categoria_id	=> $categoria[$i],
											no_commit 		=> 1
											));
						if($ret2['erro'] == 'true') 
							return $ret2;
							
						$ret3 = $this->ins_projeto_foto(array(projeto_id => $arguments['projeto_id'],
															  foto_id    => $ret2['foto_id'],
															  ordem		 => $ordem[$i],
															  no_commit	 => 1
															 ));
						if($ret3['erro'] == 'true')
							return $ret3;
					}
					
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Projeto alterado com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 15 10:33:51 UTC-0200 2009
		 * Exclui um projeto
		 */
		function del_projeto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_del_projeto(P_PROJETO_ID   =>  :P_PROJETO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PROJETO_ID',$arguments['projeto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Projeto excludo com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 15 10:35:38 UTC-0200 2009
		 * Insere uma foto para o projeto
		 */
		function ins_projeto_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_ins_projeto_foto(P_PROJETO_ID   =>  :P_PROJETO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_PROJETO_FOTO_ID	       =>  :P_PROJETO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PROJETO_ID',$arguments['projeto_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_PROJETO_FOTO_ID',$arguments['projeto_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto adicionada com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 15 10:36:15 UTC-0200 2009
		 * Altera uma foto para o projeto
		 */
		function upd_projeto_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_alt_projeto_foto(P_PROJETO_FOTO_ID   =>  :P_PROJETO_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PROJETO_FOTO_ID',$arguments['projeto_foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 15 10:37:20 UTC-0200 2009
		 * Exclui uma foto para o projeto
		 */
		function del_projeto_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	eventos.pkg_evento.prc_del_projeto_foto(P_PROJETO_FOTO_ID   =>  :P_PROJETO_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PROJETO_FOTO_ID',$arguments['projeto_foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto excluda com sucesso.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

	}//fecha classe
	
	global $conexao_banco;
	$EventosObj = new EventosMan($conexao_banco);
	
}// fecha if

global $createdObject;
$createdObject = $EventosObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>
