<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ComentarioManipulacaoObj;
if(!$ComentarioManipulacaoObj) {
	class ComentarioManipulacao extends QueryCom {
			
		/*
		 * Criado em Thu Jun 19 17:51:08 UTC-0300 2008
		 * Insere um comentario
		 */
		function ins_comentario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_ins_comentario(P_ASSUNTO   =>  :P_ASSUNTO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_NOTA_ID	       =>  :P_NOTA_ID,';
			$sql .= '					   P_USUARIO_INSERCAO	       =>  :P_USUARIO_INSERCAO,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_TIPO_ID	       =>  :P_TIPO_ID,';
			$sql .= '					   P_COMENTARIO_ID	       =>  :P_COMENTARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ASSUNTO',$arguments['assunto'],4000);
			oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],4000);
			oci_bind_by_name($stmt,':P_NOTA_ID',$arguments['nota_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_INSERCAO',$arguments['usuario_insercao'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_TIPO_ID',$arguments['tipo_id'],4000);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comentario inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jun 19 17:55:14 UTC-0300 2008
		 * Comentario abusivo
		 */
		function comentario_abusivo($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_comentario_abusivo(P_COMENTARIO_ID   =>  :P_COMENTARIO_ID,';
			$sql .= '					   P_USUARIO_ABUSIVO	       =>  :P_USUARIO_ABUSIVO,';
			$sql .= '					   P_NOME_ABUSIVO	       =>  :P_NOME_ABUSIVO,';
			$sql .= '					   P_TEXTO_ABUSIVO	       =>  :P_TEXTO_ABUSIVO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_ABUSIVO',$_SESSION['email'],4000);
			oci_bind_by_name($stmt,':P_NOME_ABUSIVO',$arguments['nome_abusivo'],4000);
			oci_bind_by_name($stmt,':P_TEXTO_ABUSIVO',$arguments['texto_abusivo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comentario enviado para analise com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Thu Jun 19 17:55:55 UTC-0300 2008
		 * Insere um comentario para a noticia
		 */
		function ins_noticia_comentario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$ret = $this->ins_comentario(array(
									assunto				=> $arguments['assunto'],
									texto				=> $arguments['texto'],
									nota_id				=> $arguments['nota_id'],
									usuario_insercao	=> $arguments['usuario_insercao'],
									tipo_id				=> $arguments['tipo_id'],
									no_commit			=> 1,
									));
			if($ret['erro'] == 'true')
				return $ret;
			$arguments['comentario_id'] = $ret['comentario_id'];				
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_ins_noticia_comentario(P_NOTICIA_ID   =>  :P_NOTICIA_ID,';
			$sql .= '					   P_COMENTARIO_ID	       =>  :P_COMENTARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOTICIA_ID',$arguments['noticia_id'],4000);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comentario inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Fri Jun 20 09:09:35 UTC-0300 2008
		 * Exclui um comentario
		 */
		function del_comentario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_del_comentario(P_COMENTARIO_ID   =>  :P_COMENTARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comentario excluido com sucesso!";
			   $_SESSION['force_write_cache'] = true;
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * 
		 * Insere um comentario para o blog
		 */
		function ins_blog_comentario($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$ret = $this->ins_comentario(array(
									assunto				=> $arguments['assunto'],
									texto				=> $arguments['texto'],
									nota_id				=> $arguments['nota_id'],
									nome                => $arguments['nome'],									
									usuario_insercao	=> $arguments['usuario_insercao'],
									tipo_id				=> $arguments['tipo_id'],
									no_commit			=> 1,
									));
			if($ret['erro'] == 'true')
				return $ret;
			$arguments['comentario_id'] = $ret['comentario_id'];				
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_ins_blog_comentario(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID,';
			$sql .= '					   							  P_COMENTARIO_ID	       =>  :P_COMENTARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
			}
		   
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Comentario inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Jun 30 18:12:28 UTC-0300 2008
		 * Aprovar um comentrio denunciado
		 */
		function aprova_comentario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_aprova_comentario(P_COMENTARIO_ID   =>  :P_COMENTARIO_ID,';
			$sql .= '					   P_USUARIO_APROVACAO	       =>  :P_USUARIO_APROVACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_APROVACAO',$arguments['usuario_aprovacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Denncia rejeirada. O Comentrio voltar a pagina da notcia!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Mon Jun 30 18:13:33 UTC-0300 2008
		 * Reprovar um comentrio denunciado
		 */
		function reprova_comentario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_reprova_comentario(P_COMENTARIO_ID   =>  :P_COMENTARIO_ID,';
			$sql .= '					   P_USUARIO_REPROVACAO	       =>  :P_USUARIO_REPROVACAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_REPROVACAO',$arguments['usuario_reprovacao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   if($arguments['correcao'] == 0)
			   		$arguments["mensagem"] = "Denncia aceita. O Comentrio ser retirado do ar permanentemente!";
				else
					$arguments["mensagem"] = "Correo atribuda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Fri Aug 15 22:18:37 UTC-0300 2008
		 * Insere recado
		 */
		function ins_mural_recados($arguments=array()){
			
			$arguments['bloqueado'] = '0';

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_ins_mural_recados(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_RECADO	       =>  :P_RECADO,';
			$sql .= '					   P_BLOQUEADO	       =>  :P_BLOQUEADO,';
			$sql .= '					   P_RECADO_ID	       =>  :P_RECADO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',utf8_encode($arguments['nome']),4000);
			oci_bind_by_name($stmt,':P_RECADO',utf8_encode($arguments['recado']),4000);
			oci_bind_by_name($stmt,':P_BLOQUEADO',$arguments['bloqueado'],4000);
			oci_bind_by_name($stmt,':P_RECADO_ID',$arguments['recado_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
				print("OK");
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Recado inserido com sucesso!";
			}else{
				print("ERRO");
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		

		/*
		 * Criado em Fri Aug 15 22:29:48 UTC-0300 2008
		 * Altera recado
		 */
		function upd_mural_recados($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_alt_mural_recados(P_RECADO_ID   =>  :P_RECADO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_RECADO	       =>  :P_RECADO,';
			$sql .= '					   P_BLOQUEADO	       =>  :P_BLOQUEADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_RECADO_ID',$arguments['recado_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_RECADO',$arguments['recado'],4000);
			oci_bind_by_name($stmt,':P_BLOQUEADO',$arguments['bloqueado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Recado alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}

		/*
		 * Criado em Fri Aug 15 22:40:01 UTC-0300 2008
		 * Exclui recado
		 */
		function del_mural_recados($arguments=array(),$resulttype='array'){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_del_mural_recados(P_RECADO_ID   =>  :P_RECADO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_RECADO_ID',$arguments['recado_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Recado excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 1 18:36:53 UTC-0200 2009
		 * Insere uma avaliao de um comentrio
		 */
		function ins_comentario_avaliacao($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_comentario.prc_ins_comentario_avaliacao(P_COMENTARIO_ID   =>  :P_COMENTARIO_ID,';
			$sql .= '					   P_AVALIACAO	       =>  :P_AVALIACAO,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_AVALIACAO_ID	       =>  :P_AVALIACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COMENTARIO_ID',$arguments['comentario_id'],4000);
			oci_bind_by_name($stmt,':P_AVALIACAO',$arguments['avaliacao'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_AVALIACAO_ID',$arguments['avaliacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao registrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	}
	global $conexao_banco;
	$ComentarioManipulacaoObj = new ComentarioManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ComentarioManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>