<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $ColetivoManipulacaoObj;
if(!$ColetivoManipulacaoObj) {
	class ColetivoManipulacao extends QueryCom {
		
		/*
		 * Criado em Fri Jan 02 2009 07:56:28 GMT-0300 (Hora oficial do Brasil)
		 * Insere uma linha de nibus
		 */
		function ins_linha($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_ins_linha(P_NOME   =>  :P_NOME,';			
			$sql .= '					   P_TEMPO_VIAGEM	       =>  :P_TEMPO_VIAGEM,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_CODIGO	       =>  :P_CODIGO,';
			$sql .= '					   P_PONTO_A	       =>  :P_PONTO_A,';
			$sql .= '					   P_PONTO_B	       =>  :P_PONTO_B,';
			$sql .= '					   P_LINHA_ID	       =>  :P_LINHA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);			
			oci_bind_by_name($stmt,':P_TEMPO_VIAGEM',$arguments['tempo_viagem'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CODIGO',$arguments['codigo'],4000);
			oci_bind_by_name($stmt,':P_PONTO_A',$arguments['ponto_a'],4000);
			oci_bind_by_name($stmt,':P_PONTO_B',$arguments['ponto_b'],4000);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$saida = listatoarray($arguments,"horario_saida_horario");
				//$chegada = listatoarray($arguments,"horario_chegada_horario");
				$sentido = listatoarray($arguments,"sentido_horario");
				$uteis = listatoarray($arguments,"uteis_horario");
				$sabado = listatoarray($arguments,"sabado_horario");
				$domingo = listatoarray($arguments,"domingo_horario");
				$feriado = listatoarray($arguments,"feriado_horario");
				//$sublinha = listatoarray($arguments,"sublinha_id_horario");
				
				
				for($i=0;$i<count($saida);$i++){
					$ret = $this->ins_horario(array(linha_id => $arguments['linha_id'],
													horario_saida => $saida[$i],
												    //horario_chegada => $chegada[$i],
													horario_chegada => '',
												    sentido => $sentido[$i],
													uteis => $uteis[$i],
													sabado => $sabado[$i],
													domingo => $domingo[$i],
													feriado => $feriado[$i],
													//sublinha_id => $sublinha[$i],
													sublinha_id => '',
													no_commit => 1
												));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				$itinerario = listatoarray($arguments,"itinerario_id_itinerario");
				$sentido	= listatoarray($arguments,"sentido_itinerario_itinerario");
				
				for($i=0; $i<count($itinerario); $i++){
					$ret = $this->ins_linha_itinerario(array(linha_id => $arguments['linha_id'],
															 itinerario_id => $itinerario[$i],
															 sentido => $sentido[$i],
															 no_commit => 1
															 ));
					if($ret['erro'] == 'true')
						return $ret;
				}
				
				/*$referencia    = listatoarray($arguments,"referencia_id_ponto");
				$permite_troca = listatoarray($arguments,"permite_troca_ponto");
				$cod_portal    = listatoarray($arguments,"tempo_destino_ponto");
				$sentido_ponto = listatoarray($arguments,"sentido_ponto_ponto");
				
				for($i=0;$i<count($referencia);$i++){
					$ret = $this->ins_ponto(array(linha_id      => $arguments['linha_id'],
												  referencia_id => $referencia[$i],
												  tempo_origem	=> $origem[$i],
												  tempo_destino => $destino[$i],
												  sentido 		=> $sentido[$i],
												  no_commit 	=> 1
												));
					if($ret['erro'] == 'true')			
						return $ret;
				}*/
				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Linha inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Jan 02 2009 07:57:14 GMT-0300 (Hora oficial do Brasil)
		 * Altera uma linha de nibus
		 */
		function upd_linha($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_alt_linha(P_LINHA_ID   =>  :P_LINHA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';	
			$sql .= '					   P_CODIGO	       =>  :P_CODIGO,';
			$sql .= '					   P_PONTO_A	       =>  :P_PONTO_A,';
			$sql .= '					   P_PONTO_B	       =>  :P_PONTO_B,';
			$sql .= '					   P_TEMPO_VIAGEM	       =>  :P_TEMPO_VIAGEM);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);			
			oci_bind_by_name($stmt,':P_CODIGO',$arguments['codigo'],4000);
			oci_bind_by_name($stmt,':P_PONTO_A',$arguments['ponto_a'],4000);
			oci_bind_by_name($stmt,':P_PONTO_B',$arguments['ponto_b'],4000);
			oci_bind_by_name($stmt,':P_TEMPO_VIAGEM',$arguments['tempo_viagem'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$conn = CreateObject("portal._class.consulta.coletivo");
				$qrH = $conn->get_horario(array(linha_id => $arguments['linha_id']));
				
				
				
				$horario = listatoarray($arguments,"horario_id_horario");
				$saida = listatoarray($arguments,"horario_saida_horario");
				$chegada = listatoarray($arguments,"horario_chegada_horario");
				$sentido = listatoarray($arguments,"sentido_horario");
				$uteis = listatoarray($arguments,"uteis_horario");
				$sabado = listatoarray($arguments,"sabado_horario");
				$domingo = listatoarray($arguments,"domingo_horario");
				$feriado = listatoarray($arguments,"feriado_horario");
				$sublinha = listatoarray($arguments,"sublinha_id_horario");
				
				//Exclui Horarios do banco 
				for($i=0;$i<count($qrH);$i++) {
					if(array_search($qrH[$i]['HORARIO_ID'],$horario) === false) {
						$ret = $this->del_horario(array(horario_id => $qrH[$i]['HORARIO_ID'],
													   			no_commit => 1
															));
					}
					if($ret['erro'] == "true") 
						return $ret;
				}
				//fim do bloco for
				
				for($i=0;$i<count($saida);$i++){
					if(!strlen(trim($horario[$i]))){//Insere horarios necessrios
						
						$ret = $this->ins_horario(array(linha_id => $arguments['linha_id'],
														horario_saida => $saida[$i],
														horario_chegada => $chegada[$i],
														sentido => $sentido[$i],
														uteis => $uteis[$i],
														sabado => $sabado[$i],
														domingo => $domingo[$i],
														feriado => $feriado[$i],
														sublinha_id => $sublinha[$i],
														no_commit => 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}else{//atualiza horarios necessrios
						$ret = $this->upd_horario(array(horario_id => $horario[$i],
														horario_saida => $saida[$i],
														horario_chegada => $chegada[$i],
														sentido => $sentido[$i],
														uteis => $uteis[$i],
														sabado => $sabado[$i],
														domingo => $domingo[$i],
														feriado => $feriado[$i],
														sublinha_id => $sublinha[$i],
														no_commit => 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}//fim else
				}//fim do bloco for
				
				$linha_itinerario_id = listatoarray($arguments,"linha_itinerario_id_itinerario");
				$itinerario = listatoarray($arguments,"itinerario_id_itinerario");
				$sentido	= listatoarray($arguments,"sentido_itinerario_itinerario");
				
				$conn = CreateObject("portal._class.consulta.coletivo");
				
				$qrLI = $conn->get_linha_itinerario(array(cod_portal => $_SESSION['cod_portal'],
														  linha_id => $arguments['linha_id']));
				
				$excluidos = array();
				for($i=0; $i<count($qrLI); $i++){
					if(array_search($qrLI[$i]['LINHA_ITINERARIO_ID'],$linha_itinerario_id)===false){
						$ret = $this->del_linha_itinerario(array(linha_itinerario_id => $linha_itinerario_id[$i],
																 no_commit => 1));
						array_push($excluidos, $linha_itinerario_id[$i]);
						
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				
				for($i=0; $i<count($itinerario); $i++){
					if(!strlen(trim($linha_itinerario_id[$i]))){
						print("1");
						$ret = $this->ins_linha_itinerario(array(linha_id => $arguments['linha_id'],
																 itinerario_id => $itinerario[$i],
																 sentido => $sentido[$i],
																 no_commit => 1
																 ));
						if($ret['erro'] == 'true')
							return $ret;
					}else{
						if(array_search($linha_itinerario_id[$i],$excluidos)===false){
							$ret = $this->upd_linha_itinerario(array(linha_id => $arguments['linha_id'],
																	 itinerario_id => $itinerario[$i],
																	 sentido => $sentido[$i],
																	 linha_itinerario_id => $linha_itinerario_id[$i],
																	 no_commit => 1
																	 ));
							if($ret['erro'] == 'true')
								return $ret;
						}
					}
				}
				
				
				/*$ponto_id	   = listatoarray($arguments,"ponto_id_ponto");
				$referencia    = listatoarray($arguments,"referencia_id_ponto");
				$origem		   = listatoarray($arguments,"tempo_origem_ponto");
				$destino       = listatoarray($arguments,"tempo_destino_ponto");
				$sentido_ponto = listatoarray($arguments,"sentido_ponto_ponto");
				
				$qrP =$conn->get_ponto(array(linha_id => $arguments['linha_id']));
				
				//deleta do banco os registros que o usurio excluu
				$ar_reg = array();
				for($i=0;$i<count($qrP);$i++) {
					if(array_search($qrP[$i]['PONTO_ID'],$ponto_id) === false) {
						array_push($ar_reg,$qrP[$i]['PONTO_ID']);
						$ret = $this->del_ponto(array(ponto_id => $qrP[$i]['PONTO_ID'],
													   			no_commit => 1
															));
						if($ret['erro'] == "true") 
						return $ret;
					}
				}
				
				//verifica todos os registros
				for($i=0;$i<count($referencia);$i++){
					if(!strlen(trim($ponto_id[$i]))){ // se no tiver identificador insere o registro
						$ret = $this->ins_ponto(array(linha_id      => $arguments['linha_id'],
													  referencia_id => $referencia[$i],
													  tempo_origem	=> $origem[$i],
													  tempo_destino => $destino[$i],
													  sentido 		=> $sentido[$i],
													  no_commit 	=> 1
													));
						if($ret['erro'] == 'true')			
							return $ret;
					}else{//atualiza os necessrios
						new dBug($ar_reg);
						if(!array_search($ponto_id[$i],$ar_reg)){// se este registro no foi excludo anteriormente ento atualize
							$ret = $this->upd_ponto(array(ponto_id      => $ponto_id[$i],
														  referencia_id => $referencia[$i],
														  tempo_origem	=> $origem[$i],
														  tempo_destino => $destino[$i],
														  sentido 		=> $sentido[$i],
														  no_commit 	=> 1
														));
							if($ret['erro'] == 'true')			
								return $ret;
						}
					}//fim do else
				}// fim do bloco for*/
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Linha alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jan 02 2009 07:57:56 GMT-0300 (Hora oficial do Brasil)
		 * Exclui uma linha de nibus
		 */
		function del_linha($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_linha(P_LINHA_ID   =>  :P_LINHA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Linha excluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jan 02 2009 10:09:11 GMT-0300 (Hora oficial do Brasil)
		 * insere um horario da linha
		 */
		function ins_horario($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$uteis = strlen(trim($arguments['uteis']))?$arguments['uteis']:0;
			$sabado = strlen(trim($arguments['sabado']))?$arguments['sabado']:0;
			$domingo = strlen(trim($arguments['uteis']))?$arguments['domingo']:0;
			$feriado = strlen(trim($arguments['feriado']))?$arguments['feriado']:0;
				
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_ins_horario(P_LINHA_ID   =>  :P_LINHA_ID,';
			$sql .= '					   P_HORARIO_SAIDA	       =>  :P_HORARIO_SAIDA,';
			$sql .= '					   P_HORARIO_CHEGADA	       =>  :P_HORARIO_CHEGADA,';
			$sql .= '					   P_SENTIDO	       =>  :P_SENTIDO,';
			$sql .= '					   P_UTEIS  	       =>  :P_UTEIS,';
			$sql .= '					   P_SABADO	           =>  :P_SABADO,';
			$sql .= '					   P_DOMINGO 	       =>  :P_DOMINGO,';
			$sql .= '					   P_FERIADO       	   =>  :P_FERIADO,';
			$sql .= '					   P_SUBLINHA_ID       =>  :P_SUBLINHA_ID,';
			$sql .= '					   P_HORARIO_ID        =>  :P_HORARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_SAIDA',$arguments['horario_saida'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_CHEGADA',$arguments['horario_chegada'],4000);
			oci_bind_by_name($stmt,':P_SENTIDO',$arguments['sentido'],4000);
			oci_bind_by_name($stmt,':P_UTEIS',$uteis,4000);
			oci_bind_by_name($stmt,':P_SABADO',$sabado,4000);
			oci_bind_by_name($stmt,':P_DOMINGO',$domingo,4000);
			oci_bind_by_name($stmt,':P_FERIADO',$feriado,4000);
			oci_bind_by_name($stmt,':P_SUBLINHA_ID',$arguments['sublinha_id'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horrio inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jan 02 2009 10:09:55 GMT-0300 (Hora oficial do Brasil)
		 * altera um horario da linha
		 */
		function upd_horario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
			$uteis = strlen(trim($arguments['uteis']))?$arguments['uteis']:0;
			$sabado = strlen(trim($arguments['sabado']))?$arguments['sabado']:0;
			$domingo = strlen(trim($arguments['uteis']))?$arguments['domingo']:0;
			$feriado = strlen(trim($arguments['feriado']))?$arguments['feriado']:0;
			
			
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_alt_horario(P_HORARIO_ID   =>  :P_HORARIO_ID,';
			$sql .= '					   P_HORARIO_SAIDA	       =>  :P_HORARIO_SAIDA,';
			$sql .= '					   P_HORARIO_CHEGADA	       =>  :P_HORARIO_CHEGADA,';
			$sql .= '					   P_UTEIS	       =>  :P_UTEIS,';
			$sql .= '					   P_SABADO  	       =>  :P_SABADO,';
			$sql .= '					   P_DOMINGO	           =>  :P_DOMINGO,';
			$sql .= '					   P_FERIADO 	       =>  :P_FERIADO,';
			$sql .= '					   P_SUBLINHA_ID       =>  :P_SUBLINHA_ID,';
			$sql .= '					   P_SENTIDO	       =>  :P_SENTIDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_SAIDA',$arguments['horario_saida'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_CHEGADA',$arguments['horario_chegada'],4000);
			oci_bind_by_name($stmt,':P_UTEIS',$uteis,4000);
			oci_bind_by_name($stmt,':P_SABADO',$sabado,4000);
			oci_bind_by_name($stmt,':P_DOMINGO',$domingo,4000);
			oci_bind_by_name($stmt,':P_FERIADO',$feriado,4000);
			oci_bind_by_name($stmt,':P_SUBLINHA_ID',$arguments['sublinha_id'],4000);
			oci_bind_by_name($stmt,':P_SENTIDO',$arguments['sentido'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horrio alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jan 02 2009 10:10:37 GMT-0300 (Hora oficial do Brasil)
		 * Exclui um horario da linha
		 */
		function del_horario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_horario(P_HORARIO_ID   =>  :P_HORARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horrio excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Nov 12 18:04:06 UTC-0200 2009
		 * Exclui todos os horrios
		 */
		function del_todos_horarios($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_todos_horarios(P_COD_PORTAL   =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horarios excludos com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Nov 17 17:53:52 UTC-0200 2009
		 * Integra horarios a partir de um arquivo XML
		 */
		function integra_horarios($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_integra_horarios(P_CONTEUDO   =>  :P_CONTEUDO,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
		
			if(strlen(trim($arguments['conteudo']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_CONTEUDO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['conteudo']);
			}else
				oci_bind_by_name($stmt,':P_CONTEUDO',$arguments['conteudo'],4000);
		
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Integrao concluda com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri Jan 02 2009 13:52:53 GMT-0300 (Hora oficial do Brasil)
		 * Insere um ponto
		 */
		function ins_ponto($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_ins_ponto(P_REFERENCIA_ID   =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_PERMITE_TROCA     =>  :P_PERMITE_TROCA,';
			$sql .= '					   P_COD_PORTAL     =>  :P_COD_PORTAL,';
			$sql .= '					   P_PONTO_ID	       =>  :P_PONTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_PERMITE_TROCA',$arguments['permite_troca'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_PONTO_ID',$arguments['ponto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Ponto inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri Jan 02 2009 13:53:44 GMT-0300 (Hora oficial do Brasil)
		 * Altera um ponto
		 */
		function upd_ponto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_alt_ponto(P_PONTO_ID   =>  :P_PONTO_ID,';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_PERMITE_TROCA	       =>  :P_PERMITE_TROCA);';			
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PONTO_ID',$arguments['ponto_id'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_PERMITE_TROCA',$arguments['permite_troca'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Ponto alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jan 02 2009 13:54:30 GMT-0300 (Hora oficial do Brasil)
		 * Exclui um ponto
		 */
		function del_ponto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_ponto(P_PONTO_ID   =>  :P_PONTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_PONTO_ID',$arguments['ponto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Ponto excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 13:57:20 UTC-0300 2009
		 * Insere um itinerario
		 */
		function ins_itinerario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_ins_itinerario(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_ITINERARIO	       =>  :P_ITINERARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_ITINERARIO',$arguments['itinerario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerrio cadastrado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 13:58:05 UTC-0300 2009
		 * Altera um itinerario
		 */
		function upd_itinerario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_alt_itinerario(P_ITINERARIO_ID   =>  :P_ITINERARIO_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ITINERARIO_ID',$arguments['itinerario_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerrio alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 13:58:32 UTC-0300 2009
		 * Exclui um itinerario
		 */
		function del_itinerario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_itinerario(P_ITINERARIO_ID   =>  :P_ITINERARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_ITINERARIO_ID',$arguments['itinerario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerrio excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 17:00:11 UTC-0300 2009
		 * Insere um itinerario para a linha
		 */
		function ins_linha_itinerario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_ins_linha_itinerario(P_LINHA_ID   =>  :P_LINHA_ID,';
			$sql .= '					   P_ITINERARIO_ID	       =>  :P_ITINERARIO_ID,';
			$sql .= '					   P_SENTIDO	       =>  :P_SENTIDO,';
			$sql .= '					   P_LINHA_ITINERARIO_ID	       =>  :P_LINHA_ITINERARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
			oci_bind_by_name($stmt,':P_ITINERARIO_ID',$arguments['itinerario_id'],4000);
			oci_bind_by_name($stmt,':P_SENTIDO',$arguments['sentido'],4000);
			oci_bind_by_name($stmt,':P_LINHA_ITINERARIO_ID',$arguments['linha_itinerario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerario adicionado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 17:01:17 UTC-0300 2009
		 * Altera um itinerario para a linha
		 */
		function upd_linha_itinerario($arguments=array()){
			new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_alt_linha_itinerario(P_LINHA_ITINERARIO_ID   =>  :P_LINHA_ITINERARIO_ID,';
			$sql .= '					   P_LINHA_ID	       =>  :P_LINHA_ID,';
			$sql .= '					   P_ITINERARIO_ID	       =>  :P_ITINERARIO_ID,';
			$sql .= '					   P_SENTIDO	       =>  :P_SENTIDO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ITINERARIO_ID',$arguments['linha_itinerario_id'],4000);
			oci_bind_by_name($stmt,':P_LINHA_ID',$arguments['linha_id'],4000);
			oci_bind_by_name($stmt,':P_ITINERARIO_ID',$arguments['itinerario_id'],4000);
			oci_bind_by_name($stmt,':P_SENTIDO',$arguments['sentido'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerario alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Jul 22 17:02:16 UTC-0300 2009
		 * Exclui um itinerario para a linha
		 */
		function del_linha_itinerario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	coletivo.pkg_coletivo.prc_del_linha_itinerario(P_LINHA_ITINERARIO_ID   =>  :P_LINHA_ITINERARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LINHA_ITINERARIO_ID',$arguments['linha_itinerario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Itinerario excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
	}
	global $conexao_banco;
	$ColetivoManipulacaoObj = new ColetivoManipulacao($conexao_banco);
}

global $createdObject;
$createdObject = $ColetivoManipulacaoObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>