<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $CinemaManObj;
if(!$CinemaManObj) {
	class CinemaComMan extends QueryCom {
		/*
		 * Criado em Tue May 20 10:30:20 UTC-0300 2008
		 * Insere um cinema
		 */
		function ins_cinema($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$arguments['fotos_url'] = "/portal/upload/".$_SESSION['cod_portal']."/cinema/";
			// Move o arquivo de um diretorio temporario se necessario
			if($arguments['fotos_temporario'] == 1) {
				$parts = array_reverse(explode(".",$arguments['fotos_url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'],0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url_imagem'].'/'.$extensao."_cinema".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['url_imagem'],$_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_cinema".$count.".".$extensao);
				$arguments['fotos_url_imagem'] = str_replace('//','/',str_replace('//','/',$arguments['fotos_url'].'/'.$extensao."_cinema".$count.".".$extensao));
			}
			$arguments['url_logotipo'] = $arguments['fotos_url_imagem'];
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_cinema(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_URL_LOGOTIPO	       =>  :P_URL_LOGOTIPO,';
			$sql .= '					   P_CINEMA_ID	       =>  :P_CINEMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_URL_LOGOTIPO',$arguments['url_logotipo'],4000);
			oci_bind_by_name($stmt,':P_CINEMA_ID',$arguments['cinema_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso) {
				$v_descricao = listatoarray($arguments,'sala_descricao_salas');
				$v_sala_id = listatoarray($arguments,'sala_id_salas');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_salas'])),implode(',',$v_sala_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_cinema_sala(array(
													sala_id => $v_excluir[$i],
													no_commit		=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_sala_id);$i++) {
					if(!strlen(trim($v_sala_id[$i]))) {
						$ret = $this->ins_cinema_sala(array(
												cinema_id	    => $arguments['cinema_id'],
												descricao		=> $v_descricao[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
					} else {
						$ret = $this->upd_cinema_sala(array(
												sala_id	        => $v_sala_id[$i],
												cinema_id		=> $arguments['cinema_id'],
												descricao		=> $v_descricao[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
					}
				}				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cinema inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 20 10:31:03 UTC-0300 2008
		 * Altera um cinema
		 */
		function upd_cinema($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$arguments['fotos_url'] = "/portal/upload/".$_SESSION['cod_portal']."/cinema/";
			// Move o arquivo de um diretorio temporario se necessario
			if($arguments['fotos_temporario'] == 1) {
				$parts = array_reverse(explode(".",$arguments['fotos_url_imagem']));
				$extensao = strtolower($parts[0]);
				@mkdir($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'],0775,true);
				$count = 0;
				while(file_exists($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_cinema".$count.".".$extensao)) {
					$count++;
				}
				copy($_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url_imagem'],$_SERVER['DOCUMENT_ROOT'].$arguments['fotos_url'].'/'.$extensao."_cinema".$count.".".$extensao);
				$arguments['fotos_url_imagem'] = str_replace('//','/',str_replace('//','/',$arguments['fotos_url'].'/'.$extensao."_cinema".$count.".".$extensao));
			}
			$arguments['url_logotipo'] = $arguments['fotos_url_imagem'];

			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_alt_cinema(P_CINEMA_ID   =>  :P_CINEMA_ID,';
			$sql .= '					   P_REFERENCIA_ID	       =>  :P_REFERENCIA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_URL_LOGOTIPO	       =>  :P_URL_LOGOTIPO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CINEMA_ID',$arguments['cinema_id'],4000);
			oci_bind_by_name($stmt,':P_REFERENCIA_ID',$arguments['referencia_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_URL_LOGOTIPO',$arguments['url_logotipo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso) {
				$v_descricao = listatoarray($arguments,'sala_descricao_salas');
				$v_sala_id = listatoarray($arguments,'sala_id_salas');
				$v_excluir = explode(',',listdiff(implode(',',explode("_",$arguments['lista_deleted_salas'])),implode(',',$v_sala_id)));
				
				for($i=0;$i<count($v_excluir);$i++) {
					if(strlen(trim($v_excluir[$i]))) {
						$ret = $this->del_cinema_sala(array(
													sala_id => $v_excluir[$i],
													no_commit		=> 1
													));
						if($ret['erro'] == 'true')
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_sala_id);$i++) {
					if(!strlen(trim($v_sala_id[$i]))) {
						$ret = $this->ins_cinema_sala(array(
												cinema_id	    => $arguments['cinema_id'],
												descricao		=> $v_descricao[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
					} else {
						$ret = $this->upd_cinema_sala(array(
												sala_id	        => $v_sala_id[$i],
												cinema_id		=> $arguments['cinema_id'],
												descricao		=> $v_descricao[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
					}
				}				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cinema alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 20 10:36:37 UTC-0300 2008
		 * Exclui um cinema
		 */
		function del_cinema($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_cinema(P_CINEMA_ID   =>  :P_CINEMA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CINEMA_ID',$arguments['cinema_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cinema excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
				
		/*
		 * Criado em Tue May 20 10:59:04 UTC-0300 2008
		 * Insere uma sala no cinema
		 */
		function ins_cinema_sala($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_cinema_sala(P_CINEMA_ID   =>  :P_CINEMA_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_SALA_ID	       =>  :P_SALA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CINEMA_ID',$arguments['cinema_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Sala inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 20 10:59:40 UTC-0300 2008
		 * Altera uma sala no cinema
		 */
		function upd_cinema_sala($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_alt_cinema_sala(P_SALA_ID   =>  :P_SALA_ID,';
			$sql .= '					   P_CINEMA_ID	       =>  :P_CINEMA_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
			oci_bind_by_name($stmt,':P_CINEMA_ID',$arguments['cinema_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Sala alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		/*
		 * Criado em Tue May 20 11:00:23 UTC-0300 2008
		 * Exclui uma sala no cinema
		 */
		function del_cinema_sala($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_cinema_sala(P_SALA_ID   =>  :P_SALA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Sala excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 20 14:23:11 UTC-0300 2008
		 * Insere um filme
		 */
		function ins_filme($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_filme(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_TITULO_ORIGINAL	       =>  :P_TITULO_ORIGINAL,';
			$sql .= '					   P_SINOPSE	       =>  :P_SINOPSE,';
			$sql .= '					   P_DIRETOR	       =>  :P_DIRETOR,';
			$sql .= '					   P_ELENCO	       =>  :P_ELENCO,';
			$sql .= '					   P_PRODUCAO	       =>  :P_PRODUCAO,';
			$sql .= '					   P_ROTEIRO	       =>  :P_ROTEIRO,';
			$sql .= '					   P_FOTOGRAFIA	       =>  :P_FOTOGRAFIA,';
			$sql .= '					   P_TRILHA_SONORA	       =>  :P_TRILHA_SONORA,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_PAIS	       =>  :P_PAIS,';
			$sql .= '					   P_CATEGORIA	       =>  :P_CATEGORIA,';
			$sql .= '					   P_CLASSIFICACAO	       =>  :P_CLASSIFICACAO,';
			$sql .= '					   P_SITE_FILME	       =>  :P_SITE_FILME,';
			$sql .= '					   P_CENSURA	       =>  :P_CENSURA,';
			$sql .= '					   P_FILME_ID	       =>  :P_FILME_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_TITULO_ORIGINAL',$arguments['titulo_original'],4000);
			oci_bind_by_name($stmt,':P_SINOPSE',$arguments['sinopse'],4000);
			oci_bind_by_name($stmt,':P_DIRETOR',$arguments['diretor'],4000);
			oci_bind_by_name($stmt,':P_ELENCO',$arguments['elenco'],4000);
			oci_bind_by_name($stmt,':P_PRODUCAO',$arguments['producao'],4000);
			oci_bind_by_name($stmt,':P_ROTEIRO',$arguments['roteiro'],4000);
			oci_bind_by_name($stmt,':P_FOTOGRAFIA',$arguments['fotografia'],4000);
			oci_bind_by_name($stmt,':P_TRILHA_SONORA',$arguments['trilha_sonora'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_PAIS',$arguments['pais'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA',$arguments['categoria'],4000);
			oci_bind_by_name($stmt,':P_CLASSIFICACAO',$arguments['classificacao'],4000);
			oci_bind_by_name($stmt,':P_CENSURA',$arguments['censura'],4000);
			oci_bind_by_name($stmt,':P_SITE_FILME',$arguments['site_filme'],4000);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			
			if($sucesso) {
				$conn2 = CreateObject("portal._class.manipulacao.site");
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				
				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.cinema");
				$qrFilmeImagem = $conn->get_filme_imagem(array(filme_id => $arguments['filme_id']));
				
				for($i=0;$i<count($qrFilmeImagem);$i++) {
					if(array_search($qrFilmeImagem[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_filme_imagem(array(
											filme_id 		=> $arguments['filme_id'],
											foto_id			=> $qrFilmeImagem[$i]['FOTO_ID'],
											no_commit		=> 1
											));
					}
				}			
				
				for($i=0;$i<count($v_foto_id);$i++) {
					if(!strlen(trim($v_foto_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						// Vincula a foto ao filme
						$ret2 = $this->ins_filme_imagem(array(
												filme_id		=> $arguments['filme_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_filme_imagem(array(
												filme_id		=> $arguments['filme_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');

				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$qrFilmeVideo = $conn->get_filme_video(array(filme_id => $arguments['filme_id']));
				
				for($i=0;$i<count($qrFilmeVideo);$i++) {
					if(array_search($qrFilmeVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_filme_video(array(
											filme_id 		=> $arguments['filme_id'],
											video_id			=> $qrFilmeVideo[$i]['VIDEO_ID'],
											no_commit		=> 1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}			
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
					    if($v_ordem[$i] != ''){
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						new dBug($ret);
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_filme_video(array(
												filme_id		=> $arguments['filme_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_filme_video(array(
												filme_id		=> $arguments['filme_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				  }
				}
				
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Filme inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
				
		/*
		 * Criado em Tue May 20 14:23:58 UTC-0300 2008
		 * Altera um filme
		 */
		function upd_filme($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_alt_filme(P_FILME_ID   =>  :P_FILME_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_TITULO_ORIGINAL	       =>  :P_TITULO_ORIGINAL,';
			$sql .= '					   P_SINOPSE	       =>  :P_SINOPSE,';
			$sql .= '					   P_DIRETOR	       =>  :P_DIRETOR,';
			$sql .= '					   P_ELENCO	       =>  :P_ELENCO,';
			$sql .= '					   P_PRODUCAO	       =>  :P_PRODUCAO,';
			$sql .= '					   P_ROTEIRO	       =>  :P_ROTEIRO,';
			$sql .= '					   P_FOTOGRAFIA	       =>  :P_FOTOGRAFIA,';
			$sql .= '					   P_TRILHA_SONORA	       =>  :P_TRILHA_SONORA,';
			$sql .= '					   P_DURACAO	       =>  :P_DURACAO,';
			$sql .= '					   P_ANO	       =>  :P_ANO,';
			$sql .= '					   P_PAIS	       =>  :P_PAIS,';
			$sql .= '					   P_CATEGORIA	       =>  :P_CATEGORIA,';
			$sql .= '					   P_CLASSIFICACAO	       =>  :P_CLASSIFICACAO,';
			$sql .= '					   P_SITE_FILME	       =>  :P_SITE_FILME,';
			$sql .= '					   P_CENSURA	       =>  :P_CENSURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_TITULO_ORIGINAL',$arguments['titulo_original'],4000);
			oci_bind_by_name($stmt,':P_SINOPSE',$arguments['sinopse'],4000);
			oci_bind_by_name($stmt,':P_DIRETOR',$arguments['diretor'],4000);
			oci_bind_by_name($stmt,':P_ELENCO',$arguments['elenco'],4000);
			oci_bind_by_name($stmt,':P_PRODUCAO',$arguments['producao'],4000);
			oci_bind_by_name($stmt,':P_ROTEIRO',$arguments['roteiro'],4000);
			oci_bind_by_name($stmt,':P_FOTOGRAFIA',$arguments['fotografia'],4000);
			oci_bind_by_name($stmt,':P_TRILHA_SONORA',$arguments['trilha_sonora'],4000);
			oci_bind_by_name($stmt,':P_DURACAO',$arguments['duracao'],4000);
			oci_bind_by_name($stmt,':P_ANO',$arguments['ano'],4000);
			oci_bind_by_name($stmt,':P_PAIS',$arguments['pais'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA',$arguments['categoria'],4000);
			oci_bind_by_name($stmt,':P_CLASSIFICACAO',$arguments['classificacao'],4000);
			oci_bind_by_name($stmt,':P_SITE_FILME',$arguments['site_filme'],4000);
			oci_bind_by_name($stmt,':P_CENSURA',$arguments['censura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
			
			if($sucesso) {
				$conn2 = CreateObject("portal._class.manipulacao.site");
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				
				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$conn = CreateObject("portal._class.consulta.cinema");
				$qrFilmeImagem = $conn->get_filme_imagem(array(filme_id => $arguments['filme_id']));
				
				for($i=0;$i<count($qrFilmeImagem);$i++) {
					if(array_search($qrFilmeImagem[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_filme_imagem(array(
											filme_id 		=> $arguments['filme_id'],
											foto_id			=> $qrFilmeImagem[$i]['FOTO_ID'],
											no_commit		=>	1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}			
				
				for($i=0;$i<count($v_foto_id);$i++) {
					if(!strlen(trim($v_foto_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						// Vincula a foto ao filme
						$ret2 = $this->ins_filme_imagem(array(
												filme_id		=> $arguments['filme_id'],
												foto_id			=> $ret['foto_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_filme_imagem(array(
												filme_id		=> $arguments['filme_id'],
												foto_id			=> $v_foto_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												largura			=> $v_largura[$i],
												altura			=> $v_altura[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
				$v_cod_video = listatoarray($arguments,'videos_cod_video_videos');
				$v_video_id = listatoarray($arguments,'videos_video_id_videos');
				$v_titulo = listatoarray($arguments,'videos_titulo_videos');
				$v_legenda = listatoarray($arguments,'videos_legenda_videos');
				$v_descricao = listatoarray($arguments,'videos_descricao_videos');
				$v_credito = listatoarray($arguments,'videos_credito_videos');
				$v_duracao = listatoarray($arguments,'videos_duracao_videos');

				// Busca as fotos cadastradas para identificar quais precisam ser excluidas
				$qrFilmeVideo = $conn->get_filme_video(array(filme_id => $arguments['filme_id']));
				
				for($i=0;$i<count($qrFilmeVideo);$i++) {
					if(array_search($qrFilmeVideo[$i]['VIDEO_ID'],$v_video_id) === false) {
						$ret = $this->del_filme_video(array(
											filme_id  => $arguments['filme_id'],
											video_id  => $qrFilmeVideo[$i]['VIDEO_ID'],
											no_commit => 1
											));
					}
					if($ret['erro'] == "true") 
						return $ret;					
				}			
				for($i=0;$i<count($v_video_id);$i++) {
					if(!strlen(trim($v_video_id[$i]))) {
						// Cadastra a foto no banco de imagens
						$ret = $conn2->ins_video(array(
												cod_portal		=> $_SESSION['cod_portal'],
												cod_video		=> $v_cod_video[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												duracao			=> $v_duracao[$i],
												no_commit		=> 1											
												));
						new dBug($ret);
						if($ret['erro'] == 'true') 
							return $ret;
						// Vincula a foto ao filme
						$ret2 = $this->ins_filme_video(array(
												filme_id		=> $arguments['filme_id'],
												video_id		=> $ret['video_id'],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));
						if($ret2['erro'] == 'true') 
							return $ret2;
					} else {
						// Vincula a imagem ao filme
						$ret2 = $this->ins_filme_video(array(
												filme_id		=> $arguments['filme_id'],
												video_id		=> $v_video_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												ordem			=> $v_ordem[$i],
												no_commit		=> 1
												));

						if($ret2['erro'] == 'true') 
							return $ret2;
					}
				}
				
			}
			
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Filme alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue May 20 14:24:24 UTC-0300 2008
		 * Exclui um filme
		 */
		function del_filme($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_filme(P_FILME_ID   =>  :P_FILME_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Filme excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
				
		/*
		 * Criado em Wed May 21 11:11:36 UTC-0300 2008
		 * Insere uma imagem no filme
		 */
		function ins_filme_imagem($arguments=array()){
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_filme_imagem(P_FILME_ID   =>  :P_FILME_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imagem vinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed May 21 11:12:45 UTC-0300 2008
		 * Exclui uma imagem no filme
		 */
		function del_filme_imagem($arguments=array()){
			if(!isset($arguments['no_commit']))
			     $this->start();
				 
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_filme_imagem(P_FILME_ID   =>  :P_FILME_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		    new dBug($sucesso);
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Imagem desvinculada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}	
				
		/*
		 * Criado em Fri May 23 15:39:03 UTC-0300 2008
		 * Vincula um video ao filme
		 */
		function ins_filme_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_filme_video(P_FILME_ID   =>  :P_FILME_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video vinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		/*
		 * Criado em Fri May 23 15:40:17 UTC-0300 2008
		 * Desvincula um video ao filme
		 */
		function del_filme_video($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_filme_video(P_FILME_ID   =>  :P_FILME_ID,';
			$sql .= '					   P_VIDEO_ID	       =>  :P_VIDEO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_VIDEO_ID',$arguments['video_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Video desvinculado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Trara os dados da lista e chama o procedimento de insero de horarios
		 */
		
		function ins_todos_horarios($arguments=array()){		
			
			$v_sala = listatoarray($arguments,'sala_id_horarios');
			$v_filme = listatoarray($arguments,'filme_id_horarios');
			$v_legendado = listatoarray($arguments,'legendado_horarios');
			$v_horas = listatoarray($arguments,'horarios_valores_horarios');
			$v_dias = listatoarray($arguments,'dias_valores_horarios');

			if(!isset($arguments['no_commit']))
				$this-> start();
			$total = 1;
			for($i=0; $i < count($v_sala) ; $i++){// NUMERO DE SALAS INSERIDAS
								
				$v_datas = explode(",", $v_dias[ $i ]);
				$v_horarios = explode(",", $v_horas[ $i ]);
				
								
				for($j=0; $j<count($v_datas) ; $j++){ //NUMERO DE DATAS
					$total++;

					for($l=0; $l< count($v_horarios) ; $l++){ // INSERE OS HORARIOS REFERENTE AS DATAS						
						
						$v_data_aux = explode("-",$v_datas[$j]);						
						$v_data_hora = $v_data_aux[ 0 ] . ' ' . $v_horarios[ $l ] . ':00';						

						$ret = $this->ins_horario(array(sala_id => $v_sala[$i],
														filme_id => $v_filme[ $i ],
														data => $v_data_hora,
														legendado => $v_legendado[ $i ],
														no_commit => 1
												       ));	
						if($ret['erro'] == 'true')
							return ret;
					}
				}
			}
			

			
			if(isset($arguments['no_commit']) || @$this->commit()){
				$arguments["erro"] = "false";
				$arguments["mensagem"] = "Horario inserido com sucesso!";
			}else{
				$arguments["erro"] = "true";
				$arguments["mensagem"] = "No foi possvel commitar a transao!\n" .  $_SESSION['last_error'];
			}
			
			return $arguments;
			
			
		}
		
		
		
		/*
		 * Criado em Mon Jun 9 15:32:26 UTC-0300 2008
		 * Insere um horario de filme
		 */
		function ins_horario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_ins_horario(P_SALA_ID   =>  :P_SALA_ID,';
			$sql .= '					   P_FILME_ID	       =>  :P_FILME_ID,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_LEGENDADO	       =>  :P_LEGENDADO,';
			$sql .= '					   P_HORARIO_ID	       =>  :P_HORARIO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_LEGENDADO',$arguments['legendado'],4000);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horario inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 *  Atualizar filmes do respectivo cinema
		 */
		function upd_cinema_horarios($arguments=array()){
			
		    $v_sala = listatoarray($arguments,'sala_id_horarios');			
			$v_excluidas = explode('_',$arguments['lista_deleted_horarios']);
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			for($i=0 ; $i<count($v_sala) ; $i++){
				$ret = $this->del_horario(array(sala_id => $v_sala[$i],
												no_commit => 1)); //EXCLUI
				
				if($ret['erro'] == 'true') // SE DEU ERRO NA EXCLUSO
					return $ret;
			}
			
			
			for($i=1; $i<count($v_excluidas) ; $i++){ 
				$ret3 = $this->del_horario(array(sala_id => $v_excluidas[$i],
												no_commit => 1));
				if($ret3['erro'] == "true")
					return ret3;
	        }
			
			if(count($v_sala > 0)){
				$ret2 = $this->ins_todos_horarios(array_merge($arguments, array(no_commit => 1))); //RE-INSERE
			}
			
			if($ret2['erro'] == 'true') // SE DEU ERRO NA RE-INSERO
				return $ret2;
				
			if(isset($arguments['no_commit']) || @$this->commit()){			
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horario(s) alterado(s) com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Mon Jun 9 15:33:29 UTC-0300 2008
		 * Altera um horario de filme
		 */
		function upd_horario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_alt_horario(P_HORARIO_ID   =>  :P_HORARIO_ID,';
			$sql .= '					   P_SALA_ID	       =>  :P_SALA_ID,';
			$sql .= '					   P_FILME_ID	       =>  :P_FILME_ID,';
			$sql .= '					   P_DATA	       =>  :P_DATA,';
			$sql .= '					   P_LEGENDADO	       =>  :P_LEGENDADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_HORARIO_ID',$arguments['horario_id'],4000);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
			oci_bind_by_name($stmt,':P_FILME_ID',$arguments['filme_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_LEGENDADO',$arguments['legendado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horario alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Tue Jun 17 09:14:52 UTC-0300 2008
		 * Exclui horrios de um determinado cinema
		 */
		function del_horario($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	cinema.pkg_cinema.prc_del_horario(P_SALA_ID   =>  :P_SALA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_SALA_ID',$arguments['sala_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Horrio(s) excluido(s) com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
			
	}
	global $conexao_banco;
	$CinemaManObj = new CinemaComMan($conexao_banco);
}

global $createdObject;
$createdObject = $CinemaManObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>