<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");


global $BlogCategoriaObj;
if(!$BlogCategoriaObj) {
	class BlogCategoriaMan extends QueryCom {
	
	
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Inserir uma cateroria
		 */
		function ins_blog_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_blog_categoria(P_CATEGORIA_PAI_ID   =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_DESCRICAO	           =>  :P_DESCRICAO,';
			$sql .= '					   P_COD_PORTAL	           =>  :P_COD_PORTAL,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* fim Insere uma categoria */
		
		
		
		/*
		 * Criado em Wed May 28 12:58:36 UTC-0200 2008
		 * Altera uma cateroria
		 */
		function upd_blog_categoria($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_alt_blog_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_CATEGORIA_PAI_ID	       =>  :P_CATEGORIA_PAI_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_PAI_ID',$arguments['categoria_pai_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Categoria alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* fim Altera uma categoria*/
	
	
	
	/*
	 * Criado em Wed May 28 13:02:53 UTC-0200 2008
	 * Exclui uma cateroria
	 */
	function del_blog_categoria($arguments=array()){
	
		if(!isset($arguments['no_commit']))
			$this-> start();
		$sql  = 'BEGIN';
		$sql .= '	blog.pkg_blog.prc_del_blog_categoria(P_CATEGORIA_ID   =>  :P_CATEGORIA_ID);';
		$sql .= 'END;';
	
		$stmt = oci_parse($this->conexao,$sql);
		oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
	
		$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
		$_SESSION['last_error'] = oci_error($stmt);
	
		if($sucesso){
	
		}
	
		if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
		   $arguments["erro"] = "false";
		   $arguments["mensagem"] = "Categoria excluida com sucesso!";
		}else{
		   $arguments["erro"] = "true";
		   $arguments["mensagem"] = $_SESSION['last_error'];
		   $this->rollback();
		}
		return $arguments;
	}
	/* fim Exclui uma categoria */
	
	
		/*
		 * Criado em Wed May 28 15:59:58 UTC-0200 2008
		 * Insere um colunista
		 */
		function ins_colunista($arguments=array()){
										
			if(array_search($arguments['imagem']['type'],explode(',','image/pjpeg,image/gif')) == false){			
				$arguments["erro"] = "true";
				$arguments["mensagem"] = "O tipo de arquivo '" . $arguments['arquivo_tipo'] . "' no  aceito";				
				$flag = 1; //verifica se usuario cadastrou imagem, caso no, url_imagem recebe vazio
			}			
			//Copia arquivo temporario para pasta permanente
			$parts = array_reverse(explode(".",$arguments['arquivo']));
			$extensao = strtolower($parts[0]);
						
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/',0775,true);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/tmp',0775,true);
			$count = 0;
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/_colunista'.$count.".".$extensao)) {
				$count++;
			}
			$url_arquivo = '/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/_colunista'.$count.'.'.$extensao;			
						
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['arquivo'] , $_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/_colunista'.$count.'.'.$extensao);				
			
			$arguments['url_imagem'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunistas/_colunista'.$count.'.'.$extensao));
						
			if($arguments['excluir_img'] == 1){
				$arguments['url_imagem'] = "";
			}
		    // --------------------		
		    
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_colunista(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_ATIVIDADE	       =>  :P_ATIVIDADE,';
			$sql .= '					   P_HISTORICO_PROFISSIONAL	       =>  :P_HISTORICO_PROFISSIONAL,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_SITUACAO_ID	       =>  :P_SITUACAO_ID,';
			$sql .= '					   P_URL_IMAGEM	       =>  :P_URL_IMAGEM,';
			$sql .= '					   P_COLUNISTA_ID	       =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ATIVIDADE',$arguments['atividade'],4000);
			oci_bind_by_name($stmt,':P_HISTORICO_PROFISSIONAL',$arguments['historico_profissional'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_SITUACAO_ID',$arguments['situacao_id'],4000);
			oci_bind_by_name($stmt,':P_URL_IMAGEM',$arguments['url_imagem'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){				
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Colunista inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* fim Insere um colunista */
		
		
		
		/*
		 * Criado em Wed Oct 29 11:32:11 UTC-0300 2008
		 * Insere um colunista do visitante cadastrado no site
		 */
		function ins_colunista_visitante($arguments=array()){
			
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['url_imagem'] != ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
				
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_colunista_visitante(P_NOME   =>  :P_NOME,';
			$sql .= '					   P_ATIVIDADE	       =>  :P_ATIVIDADE,';
			$sql .= '					   P_HISTORICO_PROFISSIONAL	       =>  :P_HISTORICO_PROFISSIONAL,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_SITUACAO_ID	       =>  :P_SITUACAO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_COLUNISTA_ID	       =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_COLUNISTA_EXTERNO     =>  :P_COLUNISTA_EXTERNO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ATIVIDADE',$arguments['atividade'],4000);
			oci_bind_by_name($stmt,':P_HISTORICO_PROFISSIONAL',$arguments['historico_profissional'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_SITUACAO_ID',$arguments['situacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_EXTERNO',$arguments['colunista_externo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Colunista cadastrado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Wed May 28 16:01:18 UTC-0200 2008
		 * Altera um colunista
		 */
		function upd_colunista($arguments=array()){
				
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['foto_id'] == ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['arquivo'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}
			
			
			
			
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_alt_colunista(P_COLUNISTA_ID   =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_ATIVIDADE	       =>  :P_ATIVIDADE,';
			$sql .= '					   P_HISTORICO_PROFISSIONAL	       =>  :P_HISTORICO_PROFISSIONAL,';
			$sql .= '					   P_EMAIL	       =>  :P_EMAIL,';
			$sql .= '					   P_SITUACAO_ID	       =>  :P_SITUACAO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_ATIVIDADE',$arguments['atividade'],4000);
			oci_bind_by_name($stmt,':P_HISTORICO_PROFISSIONAL',$arguments['historico_profissional'],4000);
			oci_bind_by_name($stmt,':P_EMAIL',$arguments['email'],4000);
			oci_bind_by_name($stmt,':P_SITUACAO_ID',$arguments['situacao_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Colunista alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* fim Altera um colunista*/
		
		
		
		/*
		 * Criado em Tue Nov 4 08:59:28 UTC-0300 2008
		 * Altera Foto do Colunista
		 */
		function upd_foto_colunista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['url_imagem'] != ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																	        path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['foto_id'] = $ret['foto_id'];
			}	
				
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_alt_foto_colunista(P_COLUNISTA_ID   =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Foto alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		
		/*
		 * Criado em Mon Jun 9 14:11:31 UTC-0200 2008
		 * Excluir um colunista
		 */
		function del_colunista($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_del_colunista(P_COLUNISTA_ID   =>  :P_COLUNISTA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Colunista excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}		
		
		
		/*
		 * Criado em Tue Jun 3 08:49:15 UTC-0200 2008
		 * Insere um Blog/Coluna
		 */
		function ins_blog($arguments=array()){
		
			//new dBug($arguments);
		
			if(array_search($arguments['cabecalho']['type'],explode(',','image/pjpeg,image/gif')) == false){
			//if( $arguments['tipo_mime_arquivo'] == NULL){
				$arguments["erro"] = "true";
				$arguments["mensagem"] = "O tipo de arquivo '" . $arguments['arquivo_tipo'] . "' no  aceito";				
				$flag = 1; //verifica se usuario cadastrou imagem, caso no, url_imagem recebe vazio
			}	
			
			//Copia arquivo temporario para pasta permanente
			$parts = array_reverse(explode(".",$arguments['arquivo']));
			$extensao = strtolower($parts[0]);			
			
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/',0775,true);
			@mkdir($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/tmp',0775,true);
			$count = 0;
			while(file_exists($_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/'.$extensao.'_cabecalho'.$count.".".$extensao)) {
				$count++;
			}
			$url_arquivo = '/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/'.$extensao.'_cabecalho'.$count.'.'.$extensao;			
			
			copy($_SERVER['DOCUMENT_ROOT'].$arguments['arquivo'] , $_SERVER['DOCUMENT_ROOT'].'/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/'.$extensao.'_cabecalho' .$count.".".$extensao);				
			
			$arguments['url_cabecalho'] = str_replace('//','/',str_replace('//','/','/portal/upload/'.$_SESSION['cod_portal'].'/blog/colunas/'.$extensao.'_cabecalho'.$count.".".$extensao));
			// --------------------			
			
			if($arguments['excluir_img'] == 1){
				$arguments['url_cabecalho'] = "";
			}
			if(!strlen(trim($arguments['exibir_email']))){
				$arguments['exibir_email']=0;	
			}
		
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_blog(P_USUARIO     =>  :P_USUARIO,';
			$sql .= '					   P_TITULO	      		   =>  :P_TITULO,';
			$sql .= '					   P_URL_CABECALHO	       =>  :P_URL_CABECALHO,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESCRICAO	           =>  :P_DESCRICAO,';
			$sql .= '					   P_COLUNISTA_ID	       =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_COD_PORTAL	           =>  :P_COD_PORTAL,';
			$sql .= '					   P_TIPO    	           =>  :P_TIPO,';
			$sql .= '					   P_ATIVO    	           =>  :P_ATIVO,';
			$sql .= '					   P_INDICADO  	           =>  :P_INDICADO,';
			$sql .= '					   P_EXIBIR_EMAIL          =>  :P_EXIBIR_EMAIL,';
			$sql .= '					   P_BLOG_ID	           =>  :P_BLOG_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_URL_CABECALHO',$arguments['url_cabecalho'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_ATIVO',$arguments['ativo'],4000);
			oci_bind_by_name($stmt,':P_INDICADO',$arguments['indicado'],4000);
			oci_bind_by_name($stmt,':P_EXIBIR_EMAIL',$arguments['exibir_email'],4000);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				$conn = CreateObject("portal._class.consulta.blog");
				$qrColunista = $conn->get_colunistas(array(cod_portal => $arguments['cod_portal'],
														   colunista_id => $arguments['colunista_id']
														 ));
			
				if($ret['erro'] == 'true')
					return $ret;
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog/Coluna inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/*# Fim insere Blog/Coluna #*/
		
		
		/*
		 * Criado em Wed Oct 29 17:44:44 UTC-0300 2008
		 * Insere um blog de um visitante do site
		 */
		function ins_blog_visitante($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
			if($arguments['url_logo'] != ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_blog'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_logo'],
									categoria_id	=> $arguments['categoria_id_blog'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['logo_id'] = $ret['foto_id'];
			}

			if($arguments['url_cabecalho'] != ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_blog'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_cabecalho'],
									categoria_id	=> $arguments['categoria_id_blog'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['cabecalho_id'] = $ret['foto_id'];
			}
				
				
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_blog_visitante(P_USUARIO   =>  :P_USUARIO,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_CABECALHO_ID	       =>  :P_CABECALHO_ID,';
			$sql .= '					   P_LOGO_ID	       =>  :P_LOGO_ID,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_COLUNISTA_ID	       =>  :P_COLUNISTA_ID,';
			$sql .= '					   P_COD_PORTAL	       =>  :P_COD_PORTAL,';
			$sql .= '					   P_BLOG_ID	       =>  :P_BLOG_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CABECALHO_ID',$arguments['cabecalho_id'],4000);
			oci_bind_by_name($stmt,':P_LOGO_ID',$arguments['logo_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog Inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Tue Jun 3 08:51:05 UTC-0200 2008
		 * Altera um Blog/Coluna
		 */
		function upd_blog($arguments=array()){
			
			$arguments['url_imagem'] = $arguments['arquivo'];
			if(!isset($arguments['no_commit']))
				$this-> start();
						
			if($arguments['cabecalho_id'] == '' && $arguments['url_imagem'] != ''){
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																		   path => '/Blogs e Colunas/Perfil/',
																	   no_commit => 1
																	 ));
				if($ret['erro'] == 'true')
					return $ret;
				
				$arguments['categoria_id_blog'] = $ret['categoria_id'];
				
				$ret = $connSiteMan->ins_foto(array(
									cod_portal		=> $arguments['cod_portal'],								
									url_imagem		=> $arguments['url_imagem'],
									categoria_id	=> $arguments['categoria_id_blog'],
									titulo		    => $arguments['titulo_logotipo'],
									no_commit 		=> 1
									));
				if($ret['erro'] == 'true') 
					return $ret;
					
				$arguments['cabecalho_id'] = $ret['foto_id'];
			}			
			
			if(!strlen(trim($arguments['exibir_email']))){
				$arguments['exibir_email']=0;	
			}
			
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_alt_blog(P_BLOG_ID     =>  :P_BLOG_ID,';
			$sql .= '					   P_USUARIO	           =>  :P_USUARIO,';
			$sql .= '					   P_TITULO	               =>  :P_TITULO,';
			$sql .= '					   P_CABECALHO_ID	       =>  :P_CABECALHO_ID,';
			$sql .= '					   P_CATEGORIA_ID	       =>  :P_CATEGORIA_ID,';
			$sql .= '					   P_DESCRICAO	           =>  :P_DESCRICAO,';
			$sql .= '					   P_TIPO	               =>  :P_TIPO,';
			$sql .= '					   P_ATIVO	               =>  :P_ATIVO,';
			$sql .= '					   P_EXIBIR_EMAIL          =>  :P_EXIBIR_EMAIL,';
			$sql .= '					   P_COLUNISTA_ID	       =>  :P_COLUNISTA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CABECALHO_ID',$arguments['cabecalho_id'],4000);
			oci_bind_by_name($stmt,':P_CATEGORIA_ID',$arguments['categoria_id'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_ATIVO',$arguments['ativo'],4000);
			oci_bind_by_name($stmt,':P_EXIBIR_EMAIL',$arguments['exibir_email'],4000);
			oci_bind_by_name($stmt,':P_COLUNISTA_ID',$arguments['colunista_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog/Coluna alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/*# Fim altera Blog/Coluna #*/
		
		
		/*
		 * Criado em Tue Jun 3 08:52:57 UTC-0200 2008
		 * Exclu um Blog/Coluna
		 */
		function del_blog($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_del_blog(P_BLOG_ID   =>  :P_BLOG_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog/Coluna excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/*# Fim exclu Blog/Coluna #*/
		
		
		
		/*
		 * Criado em Tue Jul 29 17:57:12 UTC-0200 2008
		 * Vincula um usurio ao blog
		 */
		function ins_blog_usuario($arguments=array()){
			//new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_ins_blog_usuario(P_BLOG_ID   =>  :P_BLOG_ID,';
			$sql .= '					   P_TIPO	   =>  :P_TIPO,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_TIPO',$arguments['tipo'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vnculo realizado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Fri Oct 31 14:04:31 UTC-0300 2008
		 * Altera bloqueio do usuario
		 */
		function alt_bloqueio_usuario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_alt_bloqueio_blog_usuario(P_USUARIO   =>  :P_USUARIO,';
			$sql .= '					   P_BLOG_ID	       =>  :P_BLOG_ID,';
			$sql .= '					   P_BLOQUEADO	       =>  :P_BLOQUEADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_BLOQUEADO',$arguments['bloqueado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Bloqueio alterado com sucesso";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Jul 29 17:59:01 UTC-0200 2008
		 * Altera um vincula de um usurio ao blog
		 */
		function del_blog_usuario($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_del_blog_usuario(P_BLOG_ID   =>  :P_BLOG_ID,';			
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vnculo excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 31 15:23:54 UTC-0300 2008
		 * Exclui um colaborador do blog
		 */
		function del_blog_colaborador($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_del_blog_colaborador(P_USUARIO   =>  :P_USUARIO,';
			$sql .= '					   P_BLOG_ID	       =>  :P_BLOG_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Usurio excludo com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Mon Jun 9 09:14:06 UTC-0200 2008
		 * Insere uma mensagem no blog
		 */
		function ins_blog_mensagem($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_ins_blog_mensagem(P_BLOG_ID   =>  :P_BLOG_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_USUARIO	   =>  :P_USUARIO,';
			$sql .= '					   P_DATA_EXIBICAO =>  nvl(:P_DATA_EXIBICAO,sysdate),';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO,';
			$sql .= '					   P_COD_PORTAL	   =>  :P_COD_PORTAL,';
			$sql .= '					   P_MENSAGEM_ID   =>  :P_MENSAGEM_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else				
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],400000);
			
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mensagem inserida com sucesso!";
   			   $_SESSION['force_write_cache'] = true;
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* Insere um blog na mensagem */
		
		
		/*
		 * Criado em Mon Jun 9 09:16:29 UTC-0200 2008
		 * Altera uma mensagem no blog
		 */
		function upd_blog_mensagem($arguments=array()){
			
					
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_alt_blog_mensagem(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_DATA_EXIBICAO =>  :P_DATA_EXIBICAO,';
			$sql .= '					   P_TEXTO	       =>  :P_TEXTO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_DATA_EXIBICAO',$arguments['data_exibicao'],4000);
			
			if(strlen(trim($arguments['texto']))){
				$clob=oci_new_descriptor($this->conexao,OCI_D_LOB);
				oci_bind_by_name($stmt,':P_TEXTO',$clob,-1,OCI_B_CLOB);
				$clob->writeTemporary($arguments['texto']);
			}else				
				oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],400000);
			
			//oci_bind_by_name($stmt,':P_TEXTO',$arguments['texto'],400000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mensagem alterada com sucesso!";
			   $_SESSION['force_write_cache'] = true;
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* Altera uma mensagem no blog */
		
		
		/*
		 * Criado em Mon Jun 9 09:17:39 UTC-0200 2008
		 * Exclu uma mensagem no blog
		 */
		function del_blog_mensagem($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	jornal.pkg_blog.prc_del_blog_mensagem(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Mensagem excluida com sucesso!";
			   $_SESSION['force_write_cache'] = true;
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		/* Exclui uma mensagem no blog  */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Inserir uma cateroria
		 */
		function ins_blog_acesso($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_blog_acesso(P_BLOG_ID   =>  :P_BLOG_ID,';
			$sql .= '					   P_ACESSO_ID	           =>  :P_ACESSO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_ACESSO_ID',$arguments['acesso_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Acesso inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Nov 25 21:59:08 UTC-0300 2008
		 * Altera indicao do blog
		 */
		function upd_blog_indicacao($arguments=array()){
		    //new dBug($arguments);
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_alt_blog_indicacao(P_BLOG_ID   =>  :P_BLOG_ID,';
			$sql .= '					   P_INDICADO	       =>  :P_INDICADO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_INDICADO',$arguments['indicado'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Jun 5 08:57:27 UTC-0300 2009
		 * Ativa/Inativa um blog
		 */
		function inativa_blog($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_inativa_blog(P_BLOG_ID   =>  :P_BLOG_ID,';
			$sql .= '					   P_ATIVO	       =>  :P_ATIVO);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_BLOG_ID',$arguments['blog_id'],4000);
			oci_bind_by_name($stmt,':P_ATIVO',$arguments['ativo'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
			
			$confirmacao = $arguments['ativo'] == 1?"ativado":"desativado";
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Blog ".$confirmacao." com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Tue Dec 1 16:56:00 UTC-0200 2009
		 * insere uma avaliacao de um usuario para uma postagem
		 */
		function ins_mensagem_avaliacao($arguments=array()){

			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_mensagem_avaliacao(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID,';
			$sql .= '					   P_USUARIO	       =>  :P_USUARIO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_AVALIACAO	       =>  :P_AVALIACAO,';
			$sql .= '					   P_AVALIACAO_ID	       =>  :P_AVALIACAO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO',$arguments['usuario'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_AVALIACAO',$arguments['avaliacao'],4000);
			oci_bind_by_name($stmt,':P_AVALIACAO_ID',$arguments['avaliacao_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Avaliao registrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		/*
		 * Criado em Wed Dec 2 18:39:47 UTC-0200 2009
		 * Insere uma denncia de uma mensagem
		 */
		function ins_mensagem_denuncia($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_ins_mensagem_denuncia(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID,';
			$sql .= '					   P_USUARIO_DENUNCIA	       =>  :P_USUARIO_DENUNCIA,';
			$sql .= '					   P_NOME_DENUNCIA	       =>  :P_NOME_DENUNCIA,';
			$sql .= '					   P_TEXTO_DENUNCIA	       =>  :P_TEXTO_DENUNCIA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
			oci_bind_by_name($stmt,':P_USUARIO_DENUNCIA',$arguments['usuario_denuncia'],4000);
			oci_bind_by_name($stmt,':P_NOME_DENUNCIA',$arguments['nome_denuncia'],4000);
			oci_bind_by_name($stmt,':P_TEXTO_DENUNCIA',$arguments['texto_denuncia'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Denncia registrada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Dec 2 18:23:41 UTC-0200 2009
		 * Avalia a denuncia de uma postagem.
		 */
		function avalia_denuncia_mensagem($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	blog.pkg_blog.prc_avalia_denuncia_mensagem(P_MENSAGEM_ID   =>  :P_MENSAGEM_ID,';
			$sql .= '					   P_APROVADA	       =>  :P_APROVADA,';
			$sql .= '					   P_BLOQUEADA	       =>  :P_BLOQUEADA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_MENSAGEM_ID',$arguments['mensagem_id'],4000);
			oci_bind_by_name($stmt,':P_APROVADA',$arguments['aprovada'],4000);
			oci_bind_by_name($stmt,':P_BLOQUEADA',$arguments['bloqueada'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   if($arguments['bloqueada']==1)
				   $arguments["mensagem"] = "Avaliao concluda com sucesso! A postagem est sendo retirada do ar permanentemente.";
			   else
			   	   $arguments["mensagem"] = "Avaliao concluda com sucesso! A postagem permanecer no ar.";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		

	}//fecha classe
	
	global $conexao_banco;
	$BlogCategoriaObj = new BlogCategoriaMan($conexao_banco);
	
}// fecha if

global $createdObject;
$createdObject = $BlogCategoriaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>