<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");


global $BaladaObj;
if(!$BaladaObj) {
	class BaladaMan extends QueryCom {
	
	
		/*
		 * Criado em Wed Oct 29 10:50:10 UTC-0200 2008
		 * Insere um Local
		 */
		function ins_local($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Local/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];
				}			
			
				
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_local.prc_ins_local(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LOGOTIPO_ID	       =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_ATIVO	       =>  :P_ATIVO,';
			$sql .= '					   P_LOCAL_ID	       =>  :P_LOCAL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_ATIVO',$arguments['ativo'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				// Busca os dados das fotos inseridas nas noticias
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				
				$connBalada = CreateObject("portal._class.consulta.balada");
				$connJornal = CreateObject("portal._class.consulta.jornal");
				$connSite = CreateObject("portal._class.consulta.site");
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				// Busca as fotos atualmente cadastradas para o local
				$qrLocalFoto = $connBalada->get_local_foto(array(local_id => $arguments['local_id']));
				
				// Desvincula as fotos dao local
				for($i=0;$i<count($qrLocalFoto);$i++) {
					if(array_search($qrLocalFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_local_foto(array(local_id => $arguments["local_id"],
													 	 	   foto_id => $qrLocalFoto[$i]['FOTO_ID'],
													  		   no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}

				// Vincula e insere as fotos quando necessário
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $connSiteMan->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
												
						// cria vinculo
						$ret2 = $this->ins_local_foto(array(
														local_id  => $arguments['local_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
					} else
					{
						$ret2 = $this->ins_local_foto(array( 
														local_id  => $arguments['local_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],														
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					} 
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Local inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 29 10:50:52 UTC-0200 2008
		 * Altera um Local
		 */
		function upd_local($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
		
			if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Local/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];
				}
		
			
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_local.prc_alt_local(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_NOME	       =>  :P_NOME,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LOGOTIPO_ID	       =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_ATIVO	       =>  :P_ATIVO,';
			$sql .= '					   P_LOCAL_ID	       =>  :P_LOCAL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_NOME',$arguments['nome'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_ATIVO',$arguments['ativo'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				$conn = CreateObject("portal._class.manipulacao.site");
				
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				$fotos_excluir = explode("_",$arguments["lista_deleted_fotos"]);
				
				foreach($fotos_excluir as $v){
					if($v != '')
						$this->del_local_foto(array(local_id => $arguments["local_id"],
													    foto_id => $v,
													    no_commit => 1));
				}
				
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $conn->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return 'ERRO: '.$ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						
						// cria vinculo
						$ret2 = $this->ins_local_foto(array(
														local_id  => $arguments['local_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
					} else
					{
						$ret2 = $this->ins_local_foto(array( 
														local_id  => $arguments['local_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],														
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					} 
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Local alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Wed Oct 29 10:51:51 UTC-0200 2008
		 * Exclui um Local
		 */
		function del_local($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_local.prc_del_local(P_LOCAL_ID   =>  :P_LOCAL_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Local excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Thu Oct 30 09:05:35 UTC-0200 2008
		 * Víncula um local a uma foto
		 */
		function ins_local_foto($arguments=array()){
				
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_local.prc_ins_local_foto(P_LOCAL_ID   =>  :P_LOCAL_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vínculo realizado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 30 09:07:05 UTC-0200 2008
		 * Desvincula um local de uma foto
		 */
		function del_local_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_local.prc_del_local_foto(P_LOCAL_ID   =>  :P_LOCAL_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vínculo excluído com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 30 13:53:25 UTC-0200 2008
		 * Insere um Evento
		 */
		function ins_evento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Evento/'.$arguments['titulo_evento'].' - '.str_replace("/","-",$arguments['data_inicio']).'/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					$arguments['titulo'] = $arguments['titulo_foto']; // recebe titulo da foto (evita conflito de nomes iguais)
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];					
					
				}
				
			$arguments['titulo'] = $arguments['titulo_evento'];
				
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_evento.prc_ins_evento(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_LOCAL_ID	       =>  :P_LOCAL_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_EXIBIR_ATE	       =>  :P_EXIBIR_ATE,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LOGOTIPO_ID	       =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_EVENTO_ID	       =>  :P_EVENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_EXIBIR_ATE',$arguments['exibir_ate'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				// Busca os dados das fotos inseridas nas noticias
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				
				$connBalada = CreateObject("portal._class.consulta.balada");
				$connJornal = CreateObject("portal._class.consulta.jornal");
				$connSite = CreateObject("portal._class.consulta.site");
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				// Busca as fotos atualmente cadastradas para o evento
				$qrEventoFoto = $connBalada->get_evento_foto(array(evento_id => $arguments['evento_id']));
				
				// Desvincula as fotos do evento
				for($i=0;$i<count($qrEventoFoto);$i++) {
					if(array_search($qrEventoFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_evento_foto(array(evento_id => $arguments["evento_id"],
													 	 	   foto_id => $qrEventoFoto[$i]['FOTO_ID'],
													  		   no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}
							
				// Vincula e insere as fotos quando necessário
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $connSiteMan->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
												
						// cria vinculo
						$ret2 = $this->ins_evento_foto(array(
														evento_id  => $arguments['evento_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
					} else
					{
						$ret2 = $this->ins_evento_foto(array( 
														evento_id  => $arguments['evento_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],														
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					} 
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento inserido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 30 13:54:19 UTC-0200 2008
		 * Altera um Evento
		 */
		function upd_evento($arguments=array()){
				
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Evento/'.$arguments['titulo_evento']." - ".str_replace("/","-",$arguments['data_inicio']).'/',
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					$arguments['titulo'] = $arguments['titulo_foto']; // recebe titulo da foto (evita conflito de nomes iguais)
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];					
					
				}
			
			$arguments['titulo'] = $arguments['titulo_evento'];
				
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_evento.prc_alt_evento(P_TITULO   =>  :P_TITULO,';
			$sql .= '					   P_LOCAL_ID	       =>  :P_LOCAL_ID,';
			$sql .= '					   P_DATA_INICIO	       =>  :P_DATA_INICIO,';
			$sql .= '					   P_DATA_TERMINO	       =>  :P_DATA_TERMINO,';
			$sql .= '					   P_EXIBIR_ATE	       =>  :P_EXIBIR_ATE,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_LOGOTIPO_ID	       =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_EVENTO_ID	       =>  :P_EVENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_DATA_INICIO',$arguments['data_inicio'],4000);
			oci_bind_by_name($stmt,':P_DATA_TERMINO',$arguments['data_termino'],4000);
			oci_bind_by_name($stmt,':P_EXIBIR_ATE',$arguments['exibir_ate'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				$conn = CreateObject("portal._class.manipulacao.site");
				
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				$fotos_excluir = explode("_",$arguments["lista_deleted_fotos"]);
				
				foreach($fotos_excluir as $v){
					if($v != '')
						$this->del_evento_foto(array(evento_id => $arguments["evento_id"],
													    foto_id => $v,
													    no_commit => 1));
				}
				
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						
						$ret = $conn->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return 'ERRO: '.$ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						
						// cria vinculo
						$ret2 = $this->ins_evento_foto(array(
														evento_id  => $arguments['evento_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true')
							return $ret2;
					} else
					{
						print("2");
						$ret2 = $this->ins_evento_foto(array( 
														evento_id  => $arguments['evento_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;
					} 
				}
			
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento alterado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Thu Oct 30 13:55:29 UTC-0200 2008
		 * Exclui um Evento
		 */
		function del_evento($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_evento.prc_del_evento(P_EVENTO_ID   =>  :P_EVENTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Evento excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Thu Oct 30 13:57:22 UTC-0200 2008
		 * Vincula um Evento a uma Foto
		 */
		function ins_evento_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_evento.prc_ins_evento_foto(P_EVENTO_ID   =>  :P_EVENTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vinculo realizado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Thu Oct 30 13:58:45 UTC-0200 2008
		 * Desvincula um Evento de uma Foto
		 */
		function del_evento_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_evento.prc_del_evento_foto(P_EVENTO_ID   =>  :P_EVENTO_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vinculo excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 31 10:08:14 UTC-0200 2008
		 * Insere uma cobertura
		 */
		function ins_cobertura($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			
				if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Cobertura/'.$arguments['data'],
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					$arguments['titulo'] = $arguments['titulo_foto'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];					
				}
				
			$arguments['titulo'] = $arguments['titulo_cobertura'];
				
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_cobertura.prc_ins_cobertura(P_COD_PORTAL   =>  :P_COD_PORTAL,';
			$sql .= '					   P_LOCAL_ID	       =>  :P_LOCAL_ID,';
			$sql .= '					   P_EVENTO_ID	       =>  :P_EVENTO_ID,';
			$sql .= '					   P_DATA	           =>  :P_DATA,';
			$sql .= '					   P_LOGOTIPO_ID	   =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_TITULO	           =>  :P_TITULO,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_COBERTURA_ID	       =>  :P_COBERTURA_ID);';			
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COD_PORTAL',$arguments['cod_portal'],4000);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COBERTURA_ID',$arguments['cobertura_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
			
				// Busca os dados das fotos inseridas nas noticias
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				
				$connBalada = CreateObject("portal._class.consulta.balada");
				$connJornal = CreateObject("portal._class.consulta.jornal");
				$connSite = CreateObject("portal._class.consulta.site");
				$connSiteMan = CreateObject("portal._class.manipulacao.site");
				
				// Busca as fotos atualmente cadastradas para a cobertura
				$qrCoberturaFoto = $connBalada->get_cobertura_foto(array(cobertura_id => $arguments['cobertura_id']));
				
				// Desvincula as fotos do evento
				for($i=0;$i<count($qrCoberturaFoto);$i++) {
					if(array_search($qrCoberturaFoto[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_cobertura_foto(array(cobertura_id => $arguments["cobertura_id"],
													 	 	   foto_id => $qrCoberturaFoto[$i]['FOTO_ID'],
													  		   no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}
							
				// Vincula e insere as fotos quando necessário
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$ret = $connSiteMan->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return $ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
												
						// cria vinculo
						$ret2 = $this->ins_cobertura_foto(array(
														cobertura_id  => $arguments['cobertura_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
					} else
					{
						$ret2 = $this->ins_cobertura_foto(array( 
														cobertura_id  => $arguments['cobertura_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],														
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					} 
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cobertura inserida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 31 10:09:04 UTC-0200 2008
		 * Altera uma cobertura
		 */
		function upd_cobertura($arguments=array()){			
						
			if(!isset($arguments['no_commit']))
				$this-> start();
				
				if($arguments['arquivo_temp'] != ''){
					$connSiteMan = CreateObject("portal._class.manipulacao.site");
					$ret = $connSiteMan->ins_arquivo_categoria_path(array(cod_portal => $arguments['cod_portal'],
																			    path => '/Festas e Baladas/Cobertura/'.$arguments['data'],
																		   no_commit => 1
																		 ));
					if($ret['erro'] == 'true')
						return $ret;
					
					$arguments['categoria_id'] = $ret['categoria_id'];
					$arguments['titulo'] = $arguments['titulo_foto'];
					
					$ret = $connSiteMan->ins_foto(array(
										cod_portal		=> $arguments['cod_portal'],								
										url_imagem		=> $arguments['arquivo_temp'],
										categoria_id	=> $arguments['categoria_id'],
										titulo		    => $arguments['titulo'],
										no_commit 		=> 1
										));
					if($ret['erro'] == 'true') 
						return $ret;
						
					$arguments['logotipo_id'] = $ret['foto_id'];
				}	
				
			$arguments['titulo'] = $arguments['titulo_cobertura'];	
				
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_cobertura.prc_alt_cobertura(P_LOCAL_ID   =>  :P_LOCAL_ID,';
			$sql .= '					   P_EVENTO_ID	           =>  :P_EVENTO_ID,';
			$sql .= '					   P_DATA	               =>  :P_DATA,';
			$sql .= '					   P_LOGOTIPO_ID	       =>  :P_LOGOTIPO_ID,';
			$sql .= '					   P_TITULO	               =>  :P_TITULO,';
			$sql .= '					   P_DESCRICAO	           =>  :P_DESCRICAO,';
			$sql .= '					   P_COBERTURA_ID	       =>  :P_COBERTURA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_LOCAL_ID',$arguments['local_id'],4000);
			oci_bind_by_name($stmt,':P_EVENTO_ID',$arguments['evento_id'],4000);
			oci_bind_by_name($stmt,':P_DATA',$arguments['data'],4000);
			oci_bind_by_name($stmt,':P_LOGOTIPO_ID',$arguments['logotipo_id'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_COBERTURA_ID',$arguments['cobertura_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
				
				$conn = CreateObject("portal._class.manipulacao.site");
				
				$v_url_imagem = listatoarray($arguments,'fotos_url_imagem_fotos');
				$v_foto_id = listatoarray($arguments,'fotos_foto_id_fotos');
				$v_categoria_id = listatoarray($arguments,'fotos_categoria_id_fotos');
				$v_titulo = listatoarray($arguments,'fotos_titulo_fotos');
				$v_legenda = listatoarray($arguments,'fotos_legenda_fotos');
				$v_descricao = listatoarray($arguments,'fotos_descricao_fotos');
				$v_credito = listatoarray($arguments,'fotos_credito_fotos');
				$v_largura = listatoarray($arguments,'fotos_largura_fotos');
				$v_altura = listatoarray($arguments,'fotos_altura_fotos');
				$v_largura_original = listatoarray($arguments,'fotos_largura_original_fotos');
				$v_altura_original = listatoarray($arguments,'fotos_altura_original_fotos');
				$v_tipo = listatoarray($arguments,'fotos_tipo_fotos');
				$v_tamanho_original = listatoarray($arguments,'fotos_tamanho_original_fotos');
				$v_url_temporario = listatoarray($arguments,'fotos_url_temporario_fotos');
				$v_ordem = listatoarray($arguments,'fotos_ordem_fotos');
				$fotos_excluir = explode("_",$arguments["lista_deleted_fotos"]);
				
				foreach($fotos_excluir as $v){
					if($v != '')
						$this->del_evento_foto(array(cobertura_id => $arguments["cobertura_id"],
													    foto_id => $v,
													    no_commit => 1));
				}
				
				$conn = CreateObject("portal._class.consulta.eventos");
				$qrC = $conn->get_cobertura_foto(array(cobertura_id => $arguments['cobertura_id']));
				
				// Desvincula as fotos do evento
				for($i=0;$i<count($qrC);$i++) {
					if(array_search($qrC[$i]['FOTO_ID'],$v_foto_id) === false) {
						$ret = $this->del_cobertura_foto(array(cobertura_id => $arguments["cobertura_id"],
													 	 	   foto_id => $qrC[$i]['FOTO_ID'],
													  		   no_commit => 1));
						if($ret['erro'] == "true")
							return $ret;
					}
				}
				
				for($i=0;$i<count($v_foto_id);$i++) {	
					if(!strlen(trim($v_foto_id[$i]))){
						$conn = CreateObject("portal._class.manipulacao.site");
						$ret = $conn->ins_foto(array(
												cod_portal		=> $_SESSION['cod_portal'],
												categoria_id	=> $v_categoria_id[$i],
												titulo			=> $v_titulo[$i],
												legenda			=> $v_legenda[$i],
												descricao		=> $v_descricao[$i],
												credito			=> $v_credito[$i],
												url_imagem		=> $v_url_imagem[$i],
												largura			=> $v_largura_original[$i],
												altura			=> $v_altura_original[$i],
												tipo			=> $v_tipo[$i],
												tamanho			=> $v_tamanho_original[$i],
												fotos_url		=> $arguments['fotos_url'],
												temporario		=> $v_url_temporario[$i],
												no_commit 		=> 1
												));
						if($ret['erro'] == 'true') 
							return 'ERRO: '.$ret;
						$v_url_imagem[$i] = $ret['url_imagem'];
						
						// cria vinculo
						$ret2 = $this->ins_cobertura_foto(array(
														cobertura_id  => $arguments['cobertura_id'],
														foto_id	  => $ret['foto_id'],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],																											
													    no_commit => 1));													
						
						if($ret2['erro'] == 'true') 						
							return $ret2;
							
					} else {
						$ret2 = $this->ins_cobertura_foto(array( 
														cobertura_id  => $arguments['cobertura_id'],
														foto_id	  => $v_foto_id[$i],
														ordem	  => $v_ordem[$i],
														titulo    => $v_titulo[$i],
														credito   => $v_credito[$i],
														legenda   => $v_legenda[$i],
														descricao => $v_descricao[$i],
														altura    => $v_altura_original[$i],
														largura   => $v_largura_original[$i],														
													    no_commit => 1));	
						if($ret2['erro'] == 'true') 
							return $ret2;									
					} 
				}
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cobertura alterada com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri Oct 31 10:29:34 UTC-0200 2008
		 * Exclui uma Cobertura
		 */
		function del_cobertura($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_cobertura.prc_del_cobertura(P_COBERTURA_ID   =>  :P_COBERTURA_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COBERTURA_ID',$arguments['cobertura_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Cobertura excluida com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		/*
		 * Criado em Fri Oct 31 10:10:17 UTC-0200 2008
		 * Vincula a Cobertura com suas Fotos
		 */
		function ins_cobertura_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_cobertura.prc_ins_cobertura_foto(P_COBERTURA_ID   =>  :P_COBERTURA_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID,';
			$sql .= '					   P_ORDEM	       =>  :P_ORDEM,';
			$sql .= '					   P_TITULO	       =>  :P_TITULO,';
			$sql .= '					   P_CREDITO	       =>  :P_CREDITO,';
			$sql .= '					   P_LEGENDA	       =>  :P_LEGENDA,';
			$sql .= '					   P_DESCRICAO	       =>  :P_DESCRICAO,';
			$sql .= '					   P_ALTURA	       =>  :P_ALTURA,';
			$sql .= '					   P_LARGURA	       =>  :P_LARGURA);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COBERTURA_ID',$arguments['cobertura_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
			oci_bind_by_name($stmt,':P_ORDEM',$arguments['ordem'],4000);
			oci_bind_by_name($stmt,':P_TITULO',$arguments['titulo'],4000);
			oci_bind_by_name($stmt,':P_CREDITO',$arguments['credito'],4000);
			oci_bind_by_name($stmt,':P_LEGENDA',$arguments['legenda'],4000);
			oci_bind_by_name($stmt,':P_DESCRICAO',$arguments['descricao'],4000);
			oci_bind_by_name($stmt,':P_ALTURA',$arguments['altura'],4000);
			oci_bind_by_name($stmt,':P_LARGURA',$arguments['largura'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
		
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vinculo realizado com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
		
		
		/*
		 * Criado em Fri Oct 31 10:11:11 UTC-0200 2008
		 * Desvincula uma Cobertura de suas Fotos
		 */
		function del_cobertura_foto($arguments=array()){
		
			if(!isset($arguments['no_commit']))
				$this-> start();
			$sql  = 'BEGIN';
			$sql .= '	baladas.pkg_cobertura.prc_del_cobertura_foto(P_COBERTURA_ID   =>  :P_COBERTURA_ID,';
			$sql .= '					   P_FOTO_ID	       =>  :P_FOTO_ID);';
			$sql .= 'END;';
		
			$stmt = oci_parse($this->conexao,$sql);
			oci_bind_by_name($stmt,':P_COBERTURA_ID',$arguments['cobertura_id'],4000);
			oci_bind_by_name($stmt,':P_FOTO_ID',$arguments['foto_id'],4000);
		
			$sucesso = (@oci_execute($stmt,OCI_DEFAULT));
			$_SESSION['last_error'] = oci_error($stmt);
		
			if($sucesso){
							
			}
		
			if($sucesso && (isset($arguments['no_commit']) || @$this->commit())){
			   $arguments["erro"] = "false";
			   $arguments["mensagem"] = "Vinculo excluido com sucesso!";
			}else{
			   $arguments["erro"] = "true";
			   $arguments["mensagem"] = $_SESSION['last_error'];
			   $this->rollback();
			}
			return $arguments;
		}
		
						

	}//fecha classe
	
	global $conexao_banco;
	$BaladaObj = new BaladaMan($conexao_banco);
	
}// fecha if

global $createdObject;
$createdObject = $BaladaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->toWddx(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx')));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>