<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $RadioConsultaObj;
if(!$RadioConsultaObj) {
	class RadioConsulta extends QueryCom {
		
		// retorna as musicas cadastradas
		function get_musica($arguments=array(),$resulttype='array') {
			
			$query = 
			'
				select musica_id,
					   cod_portal,
					   titulo,
					   artista,
					   album,
					   letra,
					   date_insert,
					   user_insert,
					   date_update,
					   user_update,
					   site
				from radio.v$musica
	  		  where 1=1	';
			  
			if(strlen($arguments['musica_id']))	
				$query .= " and musica_id = ".$arguments["musica_id"]." ";
			if(strlen($arguments['titulo']))	
				$query .= ' and upper(titulo) LIKE upper(\'%'.$arguments["titulo"].'%\') ';
			if(strlen($arguments['artista']))	
				$query .= ' and upper(artista) LIKE upper(\'%'.$arguments["artista"].'%\') ';
			if(strlen($arguments['album']))	
				$query .= ' and upper(album) LIKE upper(\'%'.$arguments["album"].'%\') ';
			if(strlen(trim($arguments['cadastro'])))
				$query .= ' and musica_id not in(select musica_id from radio.v$cd_musica)';
			
			$query .= ' order by artista,album,titulo asc';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		//retorna o Top Hit baseado pela, data ou pelo ID
		function get_top_hit($arguments=array(),$resulttype='array') {
			$query = 
			'
				select top_id,
				   cod_portal,
          		   to_char(data_inicio,\'DD/MM/YYYY\') as data_inicio,
				   concluido,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
				from radio.v$top_hits
				where 1=1
			';
			
			if(strlen($arguments['top_id']))	
				$query .= " and top_id = ".$arguments["top_id"]." ";

			if( (strlen($arguments['data_inicio'])) && (strlen($arguments['top_id'])) == 0 )
				$query .= " and trunc(to_date(data_inicio)) >= '".$arguments["data_inicio"]."' ";
			
			if(strlen($arguments['data_f']))	
				$query .= " and trunc(to_date(data_inicio)) <= '".$arguments["data_f"]."' ";

			$query .= " order by trunc(to_date(data_inicio)) desc";

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
		
		//retorna o id de um Top hit baseado na data
		function get_data_top_hit($arguments=array(),$resulttype='array') {
			$query = 
			'
				select top_id,
				   cod_portal,
          		   data_inicio,
				   concluido,
				   date_insert,
				   user_insert,
				   date_update,
				   user_update,
				   site
				from radio.v$top_hits
				where 1=1
			';
			if(strlen($arguments['data_cadastro']))	
				$query .= " and trunc(data_inicio) = '".$arguments["data_cadastro"]."' ";
			
			if(strlen($arguments['data_inicio']))	
				$query .= " and trunc(data_inicio) <= '".$arguments["data_inicio"]."' ";
			if(strlen($arguments['concluido']))
				$query .= " and concluido = ". $arguments['concluido'];
			
			$query .= " order by data_inicio desc";
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		//retorna o id das musicas cadastradas para um determinado ID
		function get_top_hit_musica($arguments=array(),$resulttype='array') {
			$query = 
				'select tm.musica_id,
				   tm.top_id,
				   tm.ordem,
				   tm.date_insert,
				   tm.user_insert,
				   tm.date_update,
				   tm.user_update,
				   tm.site,
				   m.titulo,
				   m.artista,
				   m.album
				  from radio.v$top_hits_musica tm
				 inner join radio.v$musica m
						 on m.musica_id = tm.musica_id
				';
			$query .= " and top_id = ".$arguments["top_id"]." ";
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}	
		
		/* Busca os CD's */
		function get_cd($arguments=array(),$resulttype='array'){
			$query = 
				' select c.cd_id,
					  c.artista,
					  c.album,
					  c.ano,
					  c.url_imagem,
					  c.recomendado,
					  c.genero,
					  (select count(*)
						 from radio.v$cd_musica cm 
						where c.cd_id = cm.cd_id) nro_musicas
				   from radio.v$cd c
				  where 1=1
				    and cod_portal = \''.$arguments['cod_portal'].'\'';
			
			if(strlen(trim($arguments['cd_id'])))
				$query .= ' and c.cd_id = '.$arguments['cd_id'];
			if(strlen(trim($arguments['artista'])))
				$query .= ' and artista like \'%'.$arguments['artista'].'%\'';
			if(strlen(trim($arguments['recomendado'])))
				$query .= ' and recomendado =' . $arguments['recomendado'];
			
			if(strlen(trim($arguments['ordem']))){
				switch($arguments['ordem']){
					case 'ARTISTA': $query .= ' order by c.artista';break;
					case 'GENERO': $query .= ' order by c.genero';break;
					case 'ANO': $query .= ' order by c.ano desc';break;
					case 'RANDOM': $query .= ' order by dbms_random.value';break;
				}
			}else	
				$query .= ' order by c.artista';
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		// Busca as msicas do CD
		function get_cd_musica($arguments=array(),$resulttype='array'){
			$query = 
				'select c.cd_id,
						   c.artista,
						   c.album,
						   c.ano,
						   c.descricao,
						   c.url_imagem,
						   c.genero,
						   c.ao_vivo,
						   c.gravadora,
						   c.recomendado,
						   cm.musica_cd_id,
						   cm.musica_id,
						   cm.ordem,
						   m.titulo,
						   m.artista,
						   m.album,
						   m.letra
					
					from radio.v$cd c
					 inner join radio.v$cd_musica cm on cm.cd_id = c.cd_id
					 inner join radio.v$musica m on cm.musica_id = m.musica_id
					 
					 where 1=1
					 and c.cod_portal = \''.$arguments['cod_portal'].'\'';
			
			if(strlen(trim($arguments['cd_id'])))
				$query .= ' and c.cd_id ='. $arguments['cd_id'];
			if(strlen(trim($arguments['musica_id'])))
				$query .= ' and cm.musica_id = '.$arguments['musica_id'];			
		
			$query .= ' order by c.artista,c.cd_id,cm.ordem';
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		//Busca os Vdeos da Msica
		function get_musica_video($arguments=array(),$resulttype='array'){

			$query = '  select mv.musica_video_id,
							   mv.musica_id,
							   mv.cod_video,
							   mv.legenda,
							   mv.credito,
							   mv.video_id,
							   mv.ordem,
							   mv.duracao,
							   mv.descricao,
							   m.cod_portal
						
						from radio.v$musica_video mv
						inner join radio.v$musica m on m.musica_id = mv.musica_id
						where 1=1
					 

					 and m.cod_portal = \''.$arguments['cod_portal'].'\'';
			
			if(strlen(trim($arguments['musica_id'])))
				$query .= ' and mv.musica_id = '.$arguments['musica_id'];			
		
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		
		
		/*
		 *  Busca os torpedos
		 */
		function get_torpedos($arguments=array(),$resulttype='array'){

			$query = 'select * 
						from(  select t.torpedo_id,
							   t.nome,
							   t.assunto,
							   t.mensagem,
							   t.bloqueado,
							   t.status,
							   t.cod_portal,
							   to_char(t.date_insert,\'DD/MM/YYYY\') as data_envio,
				               to_char(t.date_insert, \'HH24:MI:SS\') as hora,
							   row_number() over (order by t.date_insert desc) linha
						from radio.v$torpedo t
						where 1=1

					 and t.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['torpedo_id'])))
				$query .= ' and torpedo_id = '.$arguments['torpedo_id'];
			if(strlen(trim($arguments['bloqueado'])))
				$query .= ' and bloqueado = '.$arguments['bloqueado'];
			if(strlen(trim($arguments['status'])))
				$query .= ' and status = '.$arguments['status'];
				
			$query .= '
					order by date_insert desc)
				where 1=1 ';
				
			if(strlen(trim($arguments['offset'])))
				$query .= ' and linha > '.$arguments['offset'];
			if(strlen(trim($arguments['total'])))
				$query .= ' and linha <= '.($arguments['offset']+$arguments['total']);
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Soma os torpedos
		 */
		function get_soma_torpedos($arguments=array(),$resulttype='array'){

			$query = 'select count(*) as total
						
						from radio.v$torpedo t
						 where 1=1

					 and t.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['torpedo_id'])))
				$query .= ' and torpedo_id = '.$arguments['torpedo_id'];
			if(strlen(trim($arguments['bloqueado'])))
				$query .= ' and bloqueado = '.$arguments['bloqueado'];
			if(strlen(trim($arguments['status'])))
				$query .= ' and status = '.$arguments['status'];
		
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
	/*final das funes*/
	}
	global $conexao_banco;
	$RadioConsultaObj = new RadioConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $RadioConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>