<?php

include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $PublicidadeComObj;
if(!$PublicidadeComObj) {
	class PublicidadeCom extends QueryCom {
	
		/*
		 *  Busca Publicidades
		 */
		function get_publicidade( $arguments ){
			$query = 'select p.publicidade_id,
						   p.cod_portal,
						   p.titulo,
						   p.cod_tipo,
						   p.formato_id,
						   p.url_arquivo,
						   p.url_acesso,
						   p.url_fonte,
						   p.background_color,						   
						   c.criterio_id,
						   c.posicao_id,
						   to_Char(c.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_Char(c.data_termino,\'dd/mm/yyyy\') as data_termino,
						   c.limite_exibicao,
						   c.limite_clicks,
						   c.situacao_id,
						   c.exibicoes,
						   c.clicks,
						   pf.largura_base,
						   pf.altura_base,
						   pf.descricao
						
				   
				   
				  from publicitario.v$publicidade p
				   left join publicitario.v$publicidade_criterio c
					on c.publicidade_id = p.publicidade_id
				   inner join publicitario.v$publicidade_formato pf
				   	on p.formato_id = pf.formato_id
				   
				
			   where 1=1
				and p.cod_portal = \'' . $arguments['cod_portal'] . '\'';
			
			if(isset($arguments['publicidade_id']) && (strlen(trim($arguments['publicidade_id'])))){
			    $query .= ' and p.publicidade_id = ' . $arguments['publicidade_id'];
			}
			
			if(isset($arguments['titulo']) && (strlen(trim($arguments['titulo'])))){
				$query .= ' and upper(p.titulo) like upper(\'%' . $arguments['titulo'] . '%\')';
			}
			
			if(isset($aguments['data_inicio']) && (strlen(trim($arguments['data_inicio'])))){
				$query .= ' and c.data_inicio <= \'' . $arguments['data_inicio'] . '\'';
			}
			
			if(isset($arguments['data_termino']) && (strlen(trim($arguments['data_termino'])))){
				$query .= ' and c.data_termino >= \'' . $arguments['data_termino'] . '\'';
			}
			
			$query .= ' order by p.publicidade_id';
			//print($query);
			return $this->getResult($query);		
		}
		
		
		/*
		 *  Busca Critrios de Publicidades
		 */
		function get_publicidade_criterio( $arguments ){
			$query = 'select p.publicidade_id,
						   p.cod_portal,
						   p.titulo,
						   p.cod_tipo,
						   p.formato_id,
						   p.url_arquivo,
						   p.url_acesso,
						   p.url_fonte,
						   p.background_color,
						   c.criterio_id,
						   c.posicao_id,
						   to_Char(c.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_Char(c.data_termino,\'dd/mm/yyyy\') as data_termino,
						   c.limite_exibicao,
						   c.limite_clicks,
						   c.situacao_id,
						   c.exibicoes,
						   c.clicks,
						   h.horario_id,
						   h.dia_semana,
						   h.hora_inicio,
						   h.hora_termino


				  from publicitario.v$publicidade p
				   left join publicitario.v$publicidade_criterio c
					on c.publicidade_id = p.publicidade_id
				   left join publicitario.v$publicidade_criterio_horario h
					on c.criterio_id = h.criterio_id
				
			   where 1=1
				and p.cod_portal = \'' . $arguments['cod_portal'] . '\'';
			
			if(isset($arguments['publicidade_id']) && (strlen(trim($arguments['publicidade_id'])))){
			    $query .= ' and p.publicidade_id = ' . $arguments['publicidade_id'];
			}
			
			if(isset($arguments['criterio_id']) && (strlen(trim($arguments['criterio_id'])))){
				$query .= ' and c.criterio_id = ' . $arguments['criterio_id'];
			}
			
			
			$query .= ' order by c.criterio_id';
			

			return $this->getResult($query);		
		}
		
		
	
		/*
		 *  Busca os tipos de arquivo de publicidade
		 */
		function get_tipo($arguments){
			$query = 'select cod_tipo,
							 descricao
							 
					    from publicitario.v$publicidade_posicao
						
					   where 1=1';
					   
			return $this->getResult($query);		
		}
	
		

		/*
		 *  Busca as posies de publicidade
		 */
		function get_publicidade_posicao($arguments=array(),$resulttype='array') {		 	
			$query = 'select posicao_id,
						   cod_portal,
						   descricao,
						   largura,
						   altura
			  		from publicitario.v$publicidade_posicao ';
			$query .= ' where 1=1 ';
			
		    if((isset($arguments['descricao'])) && (strlen(trim($arguments['descricao'])))){
				$query .= ' and upper(descricao) like upper(\'%' . $arguments['descricao'] . '%\')';
			}
			
			if((isset($arguments['altura'])) && (strlen(trim($arguments['altura'])))){
				$query .= ' and altura = ' . $arguments['altura'];
			}
			
			if((isset($arguments['largura'])) && (strlen(trim($arguments['largura'])))){
				$query .= ' and largura = ' . $arguments['largura'];
			}
			
			if(strlen(trim($arguments['posicao_id']))){
				$query .= ' and posicao_id = ' . $arguments['posicao_id'];
			}
			
			$query .= ' and cod_portal like \'' . $arguments['cod_portal'] . '\'';
			
			$query .= ' order by descricao ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				

			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca os formatos de publicidade
		 */
		function get_publicidade_formato($arguments=array(),$resulttype='array') {
			$query = 'select formato_id,
						   descricao,
						   largura_base,
						   altura_base,
						   expansivel,
						   topo_expansivel,
						   esquerda_expansivel,
						   largura_expansivel,
						   altura_expansivel,						   
						   cod_portal
					  from publicitario.v$publicidade_formato';
 					    
			$query .= ' where 1=1 ';
			
		    if((isset($arguments['descricao'])) && (strlen(trim($arguments['descricao'])))){
				$query .= ' and upper(descricao) like upper(\'%' . $arguments['descricao'] . '%\')';
			}
			
			if(isset($arguments['formato_id'])){
			 	$query .= ' and formato_id = ' . $arguments['formato_id'];  
			}
			
			$query .= ' and cod_portal like \'' . $arguments['cod_portal'] . '\'';
			
			$query .= ' order by descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 * Busca os mime types das publicidades
		 */
		function get_cod_tipo($arguments) {			
			$query = 'select cod_tipo
						from publicitario.v$publicidade_tipo
						where instr(mime_types,\'' . $arguments['mime_types'] . '\') > 0';
			
			return $this->getResult($query);		
		}
		
		
		/*
		 *	Busca Publicidade disponvel para exibio
		 */
		function get_publicidade_exibicao( $arguments ){
			$query = 'select p.publicidade_id,
						   p.cod_portal,
						   p.titulo,
						   p.cod_tipo,
						   p.formato_id,
						   p.url_arquivo,
						   p.url_acesso,
						   p.url_fonte,
						   p.background_color,
						   c.criterio_id,
						   c.posicao_id,
						   to_Char(c.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_Char(c.data_termino,\'dd/mm/yyyy\') as data_termino,
						   c.limite_exibicao,
						   c.limite_clicks,
						   c.situacao_id,
						   c.exibicoes,
						   c.clicks,
						   h.horario_id,
						   h.dia_semana,
						   h.hora_inicio,
						   h.hora_termino,
						   pp.altura,
						   pp.largura,
						   pf.largura_base,
       					   pf.altura_base,
						   pf.expansivel,
						   pf.topo_expansivel,
						   pf.esquerda_expansivel,
						   pf.largura_expansivel,
						   pf.altura_expansivel,
						   p.arquivo_id,
						   p.arquivo_id_fonte,
						   a.md5


				  from publicitario.v$publicidade p
				   inner join publicitario.v$publicidade_criterio c
					on c.publicidade_id = p.publicidade_id
				   inner join publicitario.v$publicidade_criterio_horario h
					on c.criterio_id = h.criterio_id
				   inner join publicitario.v$publicidade_posicao pp
   					on c.posicao_id = pp.posicao_id
				   inner join publicitario.v$publicidade_formato pf
				    on p.formato_id =  pf.formato_id
				   inner join site.v$arquivo a
				           on a.arquivo_id = p.arquivo_id
				
			   where 1=1
				and p.cod_portal = \'' . $arguments['cod_portal'] . '\'';
				
			   
			   $query .= ' and h.dia_semana = ' . lsdateformat($arguments['data'],'w');
			   $query .= ' and \'' . lsdateformat($arguments['data'],'d/m/Y') . '\' between c.data_inicio and c.data_termino';
   			   $query .= ' and \'0 ' . lsdateformat($arguments['data'],'H:i:s') . '\' between h.hora_inicio and h.hora_termino';  
			   $query .= ' and c.posicao_id = ' . $arguments['posicao_id'];
			   
			   if(!$arguments['finalizado'])			   
			   	    $query .= ' and c.situacao_id = 2';
			   
			   $query .= ' order by dbms_random.random';

			   //print($query);
			   return $this->getResult($query);
		}
		
		
		/*
		 *	Busca Publicidade disponvel para exibio
		 */
		function get_publicidade_arquivos( $arguments=array() ){
			$query = 'select p.publicidade_id,
							   p.arquivo_id,
							   a.md5 as md5,
							   p.arquivo_id_fonte,
							   a2.md5 as md5_fonte
					  from publicitario.v$publicidade p
				   inner join site.v$arquivo a
						   on a.arquivo_id = p.arquivo_id
				   left join site.v$arquivo a2
						   on a2.arquivo_id = p.arquivo_id_fonte
			   where 1=1
				and p.publicidade_id = ' . $arguments['publicidade_id'] . '';
				//print($query);
			   return $this->getResult($query);
		}
		
		
		/*
		 *	Busca campanhas publicitrias
		 */
		function get_galeria_campanha( $arguments=array() ){

			$query = 'select gc.galeria_campanha_id,
							   gc.nome,
							   gc.tamanho,
							   gc.arquivo_id,
							   to_char(gc.data_exibicao, \'dd/mm/yyyy hh24:mi\') as data_exibicao,
							   to_char(gc.data_limite, \'dd/mm/yyyy hh24:mi\') as data_limite,
							   gc.tipo,
							   gc.cod_portal,
							   a.md5,
							   length(a.conteudo)/1000 as tamanho_arquivo
						  from publicitario.v$galeria_campanha gc
						inner join site.v$arquivo a on a.arquivo_id = gc.arquivo_id
			   where 1=1
				and gc.cod_portal = \'' . $arguments['cod_portal'] . '\'';

			if(strlen(trim($arguments['galeria_campanha_id'])))
				$query .= ' and gc.galeria_campanha_id = '.$arguments['galeria_campanha_id'];
			if(strlen(trim($arguments['nome'])))
				$query .= ' and gc.nome like \'%'.$arguments['nome'].'%\'';
			if(strlen(trim($arguments['tipo'])))
				$query .= ' and gc.tipo = '.$arguments['tipo'];
			if(strlen(trim($arguments['data'])))
				$query .= ' and data_exibicao <= \''.$arguments['data'].'\' and (data_limite is null or data_limite >= \''.$arguments['data'].'\')';
			//print($query);
			return $this->getResult($query);
		}
		
		
		/*
		 *	Busca formas de publicidade
		 */
		function get_forma( $arguments=array() ){

			$query = 'select forma_id,
							   cod_portal,
							   nome,
							   descricao,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from publicitario.v$forma f

			   where 1=1
				and f.cod_portal = \'' . $arguments['cod_portal'] . '\'';

			if(strlen(trim($arguments['forma_id'])))
				$query .= ' and f.forma_id = '.$arguments['forma_id'];
			if(strlen(trim($arguments['nome'])))
				$query .= ' and f.nome like \'%'.$arguments['nome'].'%\'';
				
			//print($query);
			return $this->getResult($query);
		}
		
		/*
		 *	Busca fotos das formas de publicidade
		 */
		function get_forma_foto( $arguments=array() ){

			$query = 'select forma_foto_id,
							   forma_id,
							   foto_id,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from publicitario.v$forma_foto f

			   where 1=1 ';
				
			if(strlen(trim($arguments['forma_foto_id'])))
				$query .= ' and f.forma_foto_id = '.$arguments['forma_foto_id'];
			if(strlen(trim($arguments['forma_id'])))
				$query .= ' and f.forma_id = '.$arguments['forma_id'];
			if(strlen(trim($arguments['nome'])))
				$query .= ' and f.nome like \'%'.$arguments['nome'].'%\'';
				
			//print($query);
			return $this->getResult($query);
		}
		
		
	}
	global $conexao_banco; 
	$PublicidadeComObj = new PublicidadeCom($conexao_banco);
}

global $createdObject;
$createdObject = $PublicidadeComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>