<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $ProdutoComObj;
if(!$ProdutoComObj) {
	class ProdutoCom extends QueryCom {
	
		/*
		 *  Busca as ultimas cotações do mercado
		 */
		function get_produto_cotacao($arguments=array(),$resulttype='array') {		 	
			$query = 'select   p.produto_id,
							   kss.pkg_string.fnc_string_clean(p.descricao) as descricao,
							   p.mercado,
							   p.unidade,
							   replace(nvl(round(c.venda,3),0),\'.\',\',\') as venda,
							   round(c.compra,3) as compra,
							   to_char(c.data, \'dd/mm/yyyy \') data_maior
						 from jornal.v$cotacao_produto p
						 inner join jornal.v$cotacao c  
								 on c.produto_id = p.produto_id                 
						 where situacao_id = 1
						 and c.venda is not null
						 and c.data in (select max(c2.data)
										from jornal.v$cotacao c2
									   where c2.produto_id = c.produto_id
									   )						 
						 and c.data > sysdate - 10';
		    if(strlen($arguments['num_linhas']))			  
  			   $query .= ' and rownum <= ' .$arguments['num_linhas'];
			else
			   $query .= ' and rownum <= 5';
						 
			$query .= ' and p.mercado = ' .$arguments['mercado'];
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				

			$query .= ' order by dbms_random.value';
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca as ultimas cotações do mercado para produto
		 */
		function get_cotacao_produto($arguments=array(),$resulttype='array') {		 	
			$query = ' select  cp.produto_id,
							   cp.descricao as produto,
							   cp.unidade,
							   cp.mercado,
							   cp.semente,
							   nvl(c.venda,0) venda,
							   nvl(c.compra,0) compra,
							   c.data,
							   c.venda_a_prazo,
							   c.venda_prazo
							from produto.v$cotacao_produto cp
							left join produto.v$cotacao c
							   on cp.produto_id = c.produto_id
						   where 1=1
						     and cp.cod_portal = \''.$arguments['cod_portal'].'\'
							 and cp.mercado in ('.$arguments['mercado'].')';
							 
			if(strlen(trim($arguments['semente'])))
				$query .= ' and cp.semente = '.$arguments['semente'];
							 
			$query .= '		and (c.cotacao_id = (select max(cotacao_id)
										from produto.v$cotacao c2
									   where c2.produto_id = c.produto_id
										 and trunc(c2.data) <= trunc(sysdate)) or c.cotacao_id is null)
						   order by cp.mercado, cp.semente, cp.descricao ';
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca informações do selo de um produto
		 */
		function get_selo($arguments=array(),$resulttype='array') {		 	
			$query = 'select   	s.selo_id,
         						s.nome, 
						        s.foto_id,
								s.texto,
								s.ordem,
								f.url_imagem
					  from produto.v$selo s
					  inner join site.v$foto f on f.foto_id = s.foto_id
					  where 1=1
					 and s.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['selo_id'])))
				$query .= ' and selo_id = '.$arguments['selo_id'];
					  
		    $query .= ' order by ordem';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
				
			//print($query);
		
			return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		 *   Busca os idiomas cadastrados para o portal
		 */
		 function get_idioma($arguments=array(),$resulttype='array'){
			 
		 	$query .= ' select  idioma_id,
								nome,
								url_bandeira,
								cod_portal,
								principal
						 from site.v$idioma
						where 1=1
					  and cod_portal = \''.$arguments['cod_portal'] .'\'';
					  
			if(strlen(trim($arguments['descricao'])))
				$query .= ' and descricao like \'%'.$arguments['descricao'].'%\'';
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' and idioma_id = '.$arguments['idioma_id'];
			if(strlen(trim($arguments['principal'])))	
				$query .= ' and principal = '.$arguments['principal'];
		 	if(strlen(trim($arguments['ordem']))){
				switch($arguments['ordem']){
					case 'NOME': $query .= ' order by nome asc';break;
					case 'DESCRICAO': $query .= ' order by descricao asc';break;
					case 'RANDOM': $query .= ' order by dbms_random';break;
					case 'PRINCIPAL': $query .= ' order by principal desc,nome';break;
				}	
		 	}
			
			//print($query);
		 	return $this->getResult($query,$resulttype);
		 }
		 
		 
		/*
		 *   Busca os produtos cadastrados para o portal
		 */
		 function get_produto($arguments=array(),$resulttype='array'){
		 	$query .= 'select produto_id,
							logo_id,
							logo_detalhes_id,
							institucional_id,
							cod_portal,
							ficha_id,
							documento_id,
							lancamento,
							destaque,
							p.categoria_id,
							s.md5 as md5_ficha,
							s1.md5 as md5_doc,
							ordem
							
						 from produto.v$produto p
						left join site.v$arquivo s on s.arquivo_id = p.ficha_id
						left join site.v$arquivo s1 on s1.arquivo_id = p.documento_id
						where 1=1
					  and p.cod_portal = \''.$arguments['cod_portal'] .'\'';
					  
			if(strlen(trim($arguments['produto_id'])))
				$query .= ' and produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['lancamento'])))
				$query .= ' and p.lancamento = '.$arguments['lancamento'];
			if(strlen(trim($arguments['destaque'])))
				$query .= ' and destaque = '.$arguments['destaque'];
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and p.categoria_id = '.$arguments['categoria_id'];
				
			//print($query);
		 	return $this->getResult($query,$resulttype);
		 }
		 
		 
		 /*
		 *   Busca os detalhes do produto referente ao idioma
		 */
		 function get_produto_idioma($arguments=array(),$resulttype='array'){
		 	$query .= ' select  pi.produto_idioma_id,
								pi.produto_id,
								pi.idioma_id, 	
								pi.nome,
								pi.descricao,
								pi.subtitulo,
								p.logo_id,
								p.logo_detalhes_id,
								p.institucional_id,
								p.categoria_id,
								p.destaque,
								p.lancamento,
								p.cod_portal,
								pi.instalacao,
								p.ficha_id,
								p.documento_id,
								p.ordem,
								nvl(pi.descricao,ci.texto) as produto_categoria
						 from produto.v$produto p
						inner join produto.v$produto_idioma pi on p.produto_id = pi.produto_id
						inner join site.v$idioma i on i.idioma_id = pi.idioma_id
						inner join produto.v$categoria_idioma ci on ci.categoria_id = p.categoria_id and ci.idioma_id = pi.idioma_id
						where 1=1
					  and p.cod_portal = \''.$arguments['cod_portal'] .'\'';
			if(strlen(trim($arguments['nome'])))
				$query .= ' and pi.nome like \'%'.$arguments['nome'].'%\'';
			if(strlen(trim($arguments['descricao'])))
				$query .= ' and pi.descricao like \'%'.$arguments['descricao'].'%\'';
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' and i.idioma_id = '.$arguments['idioma_id'];
			if(strlen(trim($arguments['produto_id'])))	
				$query .= ' and p.produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['principal'])))	
				$query .= ' and i.principal = '.$arguments['principal'];
			if(strlen(trim($arguments['lancamento'])))
				$query .= ' and p.lancamento = '.$arguments['lancamento'];
			if(strlen(trim($arguments['destaque'])))
				$query .= ' and destaque = '.$arguments['destaque'];
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and categoria_id in (select categoria_id
												   from produto.v$categoria
											 	  start with categoria_id = '.$arguments['categoria_id'].'
												 connect by prior categoria_id = categoria_pai_id)';
			if(strlen(trim($arguments['produtos_id'])))
				$query .= ' and pi.produto_id in ('.$arguments['produtos_id'].') ';
			
		 	if(strlen(trim($arguments['ordem']))){
				switch($arguments['ordem']){
					case 'NOME': $query .= ' order by pi.nome asc';break;
					case 'DESCRICAO': $query .= ' order by pi.descricao asc';break;
					case 'RANDOM': $query .= ' order by dbms_random.value';break;
					case 'ORDEM': $query .= ' order by p.ordem';break;
				}
		 	}
			
			//print($query);
		 	return $this->getResult($query,$resulttype);
		 }
		 
		 
		 /*
		 *   Busca os produtos cadastrados para o portal
		 */
		 function get_produto_atributo($arguments=array(),$resulttype='array'){

		 	$query .= ' select pa.produto_atributo_id,
							   pa.produto_id,
							   pa.atributo_id,
							   pa.valor,
							   pa.ordem';
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ', ai.nome ';
				
				$query .= '  from produto.v$produto_atributo pa';
				
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' inner join produto.v$atributo_idioma ai on ai.atributo_id = pa.atributo_id';
			$query .= '			where 1=1' ;
		
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' and ai.idioma_id='.$arguments['idioma_id'];
			if(strlen(trim($arguments['produto_id'])))
				$query .= ' and produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['atributo_id'])))
				$query .= ' and pa.atributo_id = '.$arguments['atributo_id'];
			if(strlen(trim($arguments['valor'])))
				$query .= ' and valor = '.$arguments['valor'];
			if(strlen(trim($arguments['garantia'])))
				$query .= ' and ai.nome = \'Garantias\'';

			if(strlen(trim($arguments['ordem'])))
				$query .= ' order by '.$arguments['ordem'];

				//print($query);
			return $this->getResult($query,$resulttype);
		 }
		 
		 /*
		 *  Busca atributos
		 */
		function get_atributo_idioma($arguments=array(),$resulttype='array') {		 	
			$query = 'select   a.atributo_id,
							   ai.idioma_id,
							   ai.nome
						
						from produto.v$atributo a
						 inner join produto.v$atributo_idioma ai on ai.atributo_id = a.atributo_id ';
			if(strlen(trim($arguments['principal'])))
				$query .= ' inner join site.v$idioma i on i.idioma_id = ai.idioma_id ';			 
			$query .= '			 where 1=1
					 and a.cod_portal = \''.$arguments['cod_portal'].'\'';
		
			if(strlen(trim($arguments['atributo_id'])))
				$query .= ' and a.atributo_id = '.$arguments['atributo_id'];
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' and ai.idioma_id = '.$arguments['idioma_id'];
			if(strlen(trim($arguments['principal'])))
				$query .= ' and i.principal = '. $arguments['principal'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
			$query .= ' order by ai.nome';		
			//print($query);
		
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca cores do produto
		 */
		function get_produto_cor($arguments=array(),$resulttype='array') {		 	
			$query = 'select pc.produto_cor_id,
							   pc.produto_id,
							   pc.cor_id,
							   pc.ordem,
							   c.foto_id,
							   c.foto_redimensionada
							  
						  from produto.v$produto_cor pc
						  inner join produto.v$cor c on c.cor_id = pc.cor_id
						 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['produto_id']))) 
				$query .= ' and produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['cor_id'])))
				$query .= ' and cor_id = '.$arguments['cor_id'];
			
			$query .= ' order by ordem';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca cores do produto
		 */
		function get_produto_cor_detalhes($arguments=array(),$resulttype='array') {		 	
			$query = 'select distinct c.cor_id,
						   pc.produto_cor_id,
						   ci.nome,
						   c.foto_id,
						   c.foto_redimensionada
					
					from produto.v$cor c
					inner join produto.v$produto_cor pc 
					        on c.cor_id = pc.cor_id
					inner join produto.v$cor_idioma ci 
					        on ci.cor_id = c.cor_id
					inner join site.v$idioma i 
					        on i.idioma_id = ci.idioma_id
					where 1=1
					  and cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['produto_id'])))
				$query .= ' and pc.produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['cor_id'])))
				$query .= ' and c.cor_id = '.$arguments['cor_id'];
			if(strlen(trim($arguments['idioma_id'])))
				$query .= ' and i.idioma_id = '.$arguments['idioma_id'];				
			if(strlen(trim($arguments['principal'])))
				$query .= ' and i.principal='.$arguments['principal'];

			$query .= ' order by ci.nome';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca logos dos produtos
		 */
		function get_produto_logo($arguments=array(),$resulttype='array') {
				$query .= 'select 	p.produto_id,
									p.logo_id
							
							from produto.v$produto p ';
				if($arguments['ordem'] == 'ALFABETICA')
					$query .= ' inner join produto.v$produto_idioma pi on pi.produto_id = p.produto_id';
				$query .= '	where 1=1
							 and p.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['produto_id'])))
					$query .= ' and p.produto_id = '.$arguments['produto_id'];
				if(strlen(trim($arguments['lancamento'])))	
					$query .= ' and p.lancamento = '.$arguments['lancamento'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and p.destaque = '.$arguments['destaque'];
				if(strlen(trim($arguments['ordem']))){
					switch($arguments['ordem']){
						case 'ALEATORIO':$query .= ' order by dbms_random.value';break;
						case 'CADASTRO':$query .= ' order by date_insert desc';break;
						case 'ALFABETICA':$query .= ' and pi.idioma_id = '.$arguments['idioma_id'].' order by pi.nome';break;
					}
				}
				
				//print($query);			
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca cores
		 */
		function get_cor_idioma($arguments=array(),$resulttype='array') {
				$query .= 'select c.cor_id,
								   c.foto_id,
								   c.cod_portal,
								   ci.idioma_id,
       							   ci.nome,
								   c.foto_redimensionada,
								   f.url_imagem
							
							from produto.v$cor c
							 inner join produto.v$cor_idioma ci on c.cor_id = ci.cor_id 
							 inner join site.v$foto f on f.foto_id = c.foto_id ';
			    if(strlen(trim($arguments['principal'])))
					$query .= ' inner join site.v$idioma i on i.idioma_id = ci.idioma_id';
				$query .= '	where 1=1
							 and c.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and ci.idioma_id = '.$arguments['idioma_id'];
				if(strlen(trim($arguments['cor_id'])))	
					$query .= ' and c.cor_id = '.$arguments['cor_id'];				
				if(strlen(trim($arguments['principal'])))
					$query .= ' and i.principal = '.$arguments['principal'];
				if(strlen(trim($arguments['nome'])))
					$query .= ' and upper(ci.nome) like upper(\'%'.$arguments['nome'].'%\')';
					
				$query .= ' order by ci.nome';
				//print($query);			
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca os selos do produto
		 */
		function get_produto_selo($arguments=array(),$resulttype='array') {		 	
			$query = 'select ps.produto_selo_id,
							   ps.produto_id,
							   ps.selo_id,
							   s.foto_id,
							   s.texto
							  
						  from produto.v$produto_selo ps
						  inner join produto.v$selo s on s.selo_id = ps.selo_id
						 where 1=1 ';

			if(strlen(trim($arguments['produto_id'])))
				$query .= ' and ps.produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['selo_id'])))
				$query .= ' and ps.selo_id = '.$arguments['selo_id'];
			
			$query .= ' order by s.ordem ';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
				
			//print($query);
		
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca categoria 
		 */
		function get_categoria($arguments=array(),$resulttype='array') {	
				$query .= 'select c.categoria_id,
								   c.cod_portal,
								   c.foto_id,
								   c.categoria_pai_id
							
							  from produto.v$categoria c
							where 1=1
				  		      and c.cod_portal = \''.$arguments['cod_portal'].'\'';

				if(strlen(trim($arguments['categoria_id'])))	
					$query .= ' and categoria_id = '.$arguments['categoria_id'];				

				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		 *  Busca categoria por idioma
		 */
		function get_categoria_idioma($arguments=array(),$resulttype='array') {	
				$query .= 'select c.categoria_id,
								   c.cod_portal,
								   c.foto_id,
								   ci.idioma_id,
								   ci.descricao,
								   ci.texto';
							if(strlen(trim($arguments['nro_filhos']))){
								$query .= ' ,(select count(*) 
												 from produto.v$categoria c2
												 inner join produto.v$categoria_idioma ci2 on c2.categoria_id = ci2.categoria_id
												 where 1 = 1
												   and c2.cod_portal = \''.$arguments['cod_portal'].'\'
												   and ci2.idioma_id = '.$arguments['idioma_id'].'	
												   and c2.categoria_pai_id = c.categoria_id) as filhos	';
							}
				$query .= '			
							from produto.v$categoria c
							inner join produto.v$categoria_idioma ci on c.categoria_id = ci.categoria_id';
				if(strlen(trim($arguments['principal'])))
					$query .= ' inner join site.v$idioma i on i.idioma_id = ci.idioma_id';
				$query .= '			where 1=1 
							 and c.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and idioma_id = '.$arguments['idioma_id'];
				if(strlen(trim($arguments['categoria_id'])))	
					$query .= ' and c.categoria_id = '.$arguments['categoria_id'];				
				if(strlen(trim($arguments['principal'])))
					$query .= ' and i.principal = 1';
				if(strlen(trim($arguments['raiz'])))
					$query .= ' and c.categoria_pai_id is null';
				if(strlen(trim($arguments['categoria_pai_id'])))
					$query .= ' and c.categoria_pai_id = '.$arguments['categoria_pai_id'];
				$query .= ' order by descricao';
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca o path da categoria por idioma
		 */
		function get_categoria_idioma_path($arguments=array(),$resulttype='array') {
				
				$query = 'select path,
								   categoria_id,
								   principal,
								   descricao,
								   categoria_pai_id';
				if(strlen(trim($arguments['possui_produto_simples'])))
					$query .= ' ,produtos_simples';
							
				$query .= '	from(select sys_connect_by_path(ci.descricao, \'->\') as path,
											   lpad(\' \', (4 * (level - 1)), \' \') || ci.descricao as lev_cat,
											   level,
											   c.categoria_id,
											   c.categoria_pai_id,
											   ci.descricao,
											   i.principal,
											   i.idioma_id,
											   c.cod_portal,';
				if(strlen(trim($arguments['possui_produto_simples']))){
					$query .= '	(select count(*)
									  from produto.v$produto_simples ps
									 where ps.categoria_id = c.categoria_id) as produtos_simples,';
				}
											   
											   
				$query .= '					   c.foto_id
											   
										  from produto.v$categoria c
										  inner join produto.v$categoria_idioma ci on ci.categoria_id = c.categoria_id
										  inner join site.v$idioma i on ci.idioma_id = i.idioma_id
										 start with c.categoria_pai_id is null
									   connect by c.categoria_pai_id = prior c.categoria_id
									   
									   order siblings by ordem,descricao)
								
							where 1 = 1
							 and cod_portal = \''.$arguments['cod_portal'].'\'';

				if(strlen(trim($arguments['categoria_id'])))	
					$query .= ' and categoria_id = '.$arguments['categoria_id'];
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and idioma_id = '.$arguments['idioma_id'];
				if(strlen(trim($arguments['principal'])))
					$query .= ' and principal = '.$arguments['principal'];	
				if(strlen(trim($arguments['possui_produto_simples'])))
					$query .= ' and produtos_simples > 0 ';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		 *  Busca fotos ambientadas do produto
		 */
		function get_produto_foto($arguments=array(),$resulttype='array') {	
				$query .= 'select pf.produto_foto_id,
						   pf.produto_id,
						   pf.foto_id,
						   f.url_imagem,
						   f.altura,
						   f.largura
					
						from produto.v$produto_foto pf
						inner join site.v$foto f on f.foto_id = pf.foto_id
					where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['produto_id'])))
					$query .= ' and produto_id = '.$arguments['produto_id'];
				if(strlen(trim($arguments['foto_id'])))
					$query .= ' and foto_id = '.$arguments['foto_id'];
					
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca Instalação do produto
		 */
		function get_instalacao($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select i.instalacao_id,
								   to_char(i.data_instalacao,\'dd/mm/yyyy hh24:mm:ss\') as data_instalacao,
       								to_char(i.data_exibicao,\'dd/mm/yyyy hh24:mm:ss\') as data_exibicao,
								   i.aprovada,
								   i.destaque,
								   ii.titulo,
								   ii.descricao,
								   (select count(ipr.produto_cor_id)
										  from produto.v$instalacao_produto ipr
										 where ipr.instalacao_id = i.instalacao_id
											and produto_cor_id = (select max(produto_cor_id) 
																	from produto.v$instalacao_produto
																	  where instalacao_id = i.instalacao_id)) as produtos,
									(select count(foto_id)
									  from produto.v$instalacao_foto if
									 where if.instalacao_id = i.instalacao_id) as fotos
							from produto.v$instalacao i
							inner join produto.v$instalacao_idioma ii on i.instalacao_id = ii.instalacao_id
							inner join site.v$idioma id on id.idioma_id = ii.idioma_id
							
							
							where 1=1
							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['instalacao_id'])))
					$query .= ' and i.instalacao_id = '.$arguments['instalacao_id'];
				if(strlen(trim($arguments['principal'])))
					$query .= ' and id.principal='.$arguments['principal'];
				if(strlen(trim($arguments['possui_foto'])))
					$query .= ' and i.fotos > 0';
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and i.destaque = '.$arguments['destaque'];
				if(strlen(trim($arguments['aprovada'])))
					$query .= ' and aprovada = '.$arguments['aprovada'];
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and ii.idioma_id = '.$arguments['idioma_id'];
				if(strlen(trim($arguments['categoria_id'])))
					$query .= ' and i.categoria_id in (select categoria_id
																from produto.v$categoria
															   start with categoria_id = '.$arguments['categoria_id'].'
															  connect by categoria_pai_id = prior categoria_id)';
				if(isset($arguments['data_exibicao'])){
					if(strlen(trim($arguments['data_exibicao'])))
						$query .= ' and data_exibicao <= \''.$arguments['data_exibicao'].'\'';
					else
						$query .= ' and data_exibicao <= sysdate';
				}
				
				if(strlen(trim($arguments['ordem'])))
					$query .= ' order by '.$arguments['ordem'];
				
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca dados da instalação
		 */
		function get_instalacao_detalhes($arguments=array(),$resulttype='array') {	
				$query .= 'select i.instalacao_id,
								   i.cod_portal,
								   i.data_instalacao,
								   i.data_exibicao,
								   i.destaque							
							
							from produto.v$instalacao i
							
							where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['instalacao_id'])))
					$query .= ' and ip.instalacao_id = '.$arguments['instalacao_id'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and i.destaque = '.$arguments['destaque'];
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca dados da instalação referente ao idioma
		 */
		function get_instalacao_idioma($arguments=array(),$resulttype='array') {	
				$query .= 'select i.instalacao_id,
								 i.idioma_id,
								 i.titulo,
								 i.descricao,								 
								 to_char(ins.data_instalacao,\'dd/mm/yyyy hh:mm:ss\') as data_instalacao,
								 to_char(ins.data_exibicao,\'dd/mm/yyyy hh:mm:ss\') as data_exibicao
						 
						 from produto.v$instalacao_idioma i
						 inner join site.v$idioma id on id.idioma_id = i.idioma_id
						 inner join produto.v$instalacao ins on ins.instalacao_id = i.instalacao_id
								where 1=1 ';
				if(strlen(trim($arguments['instalacao_id'])))
					$query .= ' and i.instalacao_id = '.$arguments['instalacao_id'];
				if(strlen(trim($arguments['principal'])))
					$query .= ' and id.principal='.$arguments['principal'];
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and id.idioma_id = '.$arguments['idioma_id'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and i.destaque = '.$arguments['destaque'];
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		
		
		/*
		 *  Busca produtos da instalação
		 */
		function get_instalacao_produtos($arguments=array(),$resulttype='array') {	
				$query .= 'select  i.instalacao_id,
								   i.cod_portal,
								   i.destaque,
								   to_char(i.data_instalacao,\'dd/mm/yyyy hh:mm:ss\') as data_instalacao,
								   to_char(i.data_exibicao,\'dd/mm/yyyy hh:mm:ss\') as data_exibicao,
								   ip.produto_cor_id,
								   pc.produto_id,
								   ci.nome';
							if(strlen(trim($arguments['todos_dados']))){
								$query .= ',
								   pi.nome as produto,								   
								   idi.titulo,
								   idi.descricao,
      							   c.foto_id,
								   p.logo_id';
						    }
				$query .= '			
							
							from produto.v$instalacao i
							inner join produto.v$instalacao_produto ip on ip.instalacao_id = i.instalacao_id
							inner join produto.v$produto_cor pc on pc.produto_cor_id = ip.produto_cor_id
							inner join produto.v$cor_idioma ci on ci.cor_id = pc.cor_id
							inner join site.v$idioma id on id.idioma_id = ci.idioma_id';
					if(strlen(trim($arguments['todos_dados']))){
						$query .= '	inner join produto.v$produto_idioma pi on pc.produto_id = pi.produto_id and pi.idioma_id = id.idioma_id
									inner join produto.v$instalacao_idioma idi on idi.instalacao_id = i.instalacao_id and idi.idioma_id = id.idioma_id
									inner join produto.v$cor c on c.cor_id = ci.cor_id
									inner join produto.v$produto p on p.produto_id = pc.produto_id ';
					}
					
				$query .= '
							where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['instalacao_id'])))
					$query .= ' and ip.instalacao_id = '.$arguments['instalacao_id'];
				if(strlen(trim($arguments['produto_cor_id'])))
					$query .= ' and ip.produto_cor_id ='.$arguments['produto_cor_id'];
				if(strlen(trim($arguments['principal'])))
					$query .= ' and id.principal='.$arguments['principal'];
				if(strlen(trim($arguments['idioma_id'])))
					$query .= ' and id.idioma_id='.$arguments['idioma_id'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and i.destaque = '.$arguments['destaque'];
				$query .= ' order by pc.produto_id';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca fotos da instalação
		 */
		function get_instalacao_foto($arguments=array(),$resulttype='array') {	
				$query .= 'select  if.ordem,
								   if.instalacao_id,
								   f.foto_id,
								   f.categoria_id,
								   f.largura,
								   f.altura,
								   f.largura as largura_original,
								   f.altura as altura_original,
								   f.tamanho,
								   f.tipo,
								   f.titulo,
								   f.legenda,
								   f.credito,
								   f.descricao,
								   f.url_imagem
						
						from produto.v$instalacao_foto if
						inner join site.v$foto f on f.foto_id = if.foto_id
							
							where 1=1

							 and f.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['instalacao_id'])))
					$query .= ' and if.instalacao_id = '.$arguments['instalacao_id'];
				if(strlen(trim($arguments['foto_id'])))
					$query .= ' and f.foto_id='.$arguments['foto_id'];
				if(strlen(trim($arguments['fotos_id'])))
					$query .= ' and f.foto_id in('.$arguments['fotos_id'].')';
				if(strlen(trim($arguments['ordem_foto'])))
					$query .= ' and if.ordem='.$arguments['ordem_foto'];

				if(strlen(trim($arguments['ordem'])))
					$query .= ' order by '.$arguments['ordem'];
				else
					$query .= ' order by if.ordem';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca revendedores
		 */
		function get_revendedor($arguments=array(),$resulttype='array') {

				$query .= 'select revendedor_id,
								   r.nome,
								   endereco,
								   bairro,
								   cep,
								   uf,
								   municipio,
								   complemento,
								   numero,
								   fone,
								   fax,
								   website,
								   email,
								   r.cod_portal,
								   r.pais_id,
								   p.nome as pais
								   
							  from produto.v$revendedor r
							 inner join produto.v$pais p on p.pais_id = r.pais_id
							
							where 1=1

							 and r.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['nome'])))
					$query .= ' and upper(r.nome) like upper(\'%'.$arguments['nome'].'%\')';
				if(strlen(trim($arguments['municipio']))){
					if(strlen(trim($arguments['limpar_string'])))
						$query .= ' and upper(kss.pkg_string.fnc_string_clean(r.municipio)) like upper(kss.pkg_string.fnc_string_clean(\'%'.$arguments['municipio'].'%\'))';
					else
						$query .= ' and upper(r.municipio) like upper(\'%'.$arguments['municipio'].'%\')';
				}
				if(strlen(trim($arguments['revendedor_id'])))
					$query .= ' and r.revendedor_id = '.$arguments['revendedor_id'];
				if(strlen(trim($arguments['municipio_id'])))
					$query .= ' and r.municipio_id = '.$arguments['municipio_id'];
				if(strlen(trim($arguments['pais_id'])))
					$query .= ' and r.pais_id = '.$arguments['pais_id'];
				if(strlen(trim($arguments['uf'])))
					$query .= ' and upper(r.uf)=upper(\''.$arguments['uf'].'\')';

				$query .= ' order by r.municipio';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca revendedores
		 */
		function get_pais($arguments=array(),$resulttype='array') {	
				$query .= 'select pais_id,
								   nome,
								   cod_portal,
								   foto_id,
								   (select count(revendedor_id)
									  from produto.v$revendedor
									 where UF is null
									 and pais_id = p.pais_id
									 ) as sem_uf,
								   (select count(revendedor_id)
									  from produto.v$revendedor
									 where pais_id = p.pais_id) as revendedores,
								   date_insert,
								   user_insert,
								   date_update,
								   user_update,
								   site
							  from produto.v$pais p
							 
							where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['pais_id'])))
					$query .= ' and pais_id = '.$arguments['pais_id'];

				$query .= ' order by nome';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca estados dos revendedores
		 */
		function get_revendedor_uf($arguments=array(),$resulttype='array') {	
				$query .= 'select cuf.nome_uf,r.uf
							  from produto.v$revendedor r
							 inner join cep.cep_ufs cuf on cuf.sigla_uf = r.uf
							where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['pais_id'])))
					$query .= ' and pais_id = '.$arguments['pais_id'];

				$query .= ' group by cuf.nome_uf,r.uf
							order by uf';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca cidades dos revendedores
		 */
		function get_revendedor_municipio($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select distinct (upper(kss.pkg_string.fnc_string_clean(municipio))) as municipio
							  from produto.v$revendedor

							where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['pais_id'])))
					$query .= ' and pais_id = '.$arguments['pais_id'];
				if(strlen(trim($arguments['uf'])) && $arguments['uf'] != 'undefined')
					$query .= ' and upper(uf)=upper(\''.$arguments['uf'].'\')';
				$query .= ' order by municipio';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca marcas
		 */
		function get_marca($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select marca_id,
								   nome,
								   foto_id,
								   ordem,
								   cod_portal,
								   date_insert,
								   user_insert,
								   date_update,
								   user_update,
								   site
							  from produto.v$marca
						where 1=1

							 and cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['marca_id'])))
					$query .= ' and marca_id = '.$arguments['marca_id'];
				if(strlen(trim($arguments['nome'])))
					$query .= ' and upper(nome) like upper(\''.$arguments['nome'].'\')';
				if(!strlen(trim($arguments['ordem'])))
					$query .= ' order by ordem, nome';
				else
					$query .= ' order by '.$arguments['ordem'];
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca produto simples
		 */
		function get_produto_simples($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select ps.produto_id,
								   ps.cod_portal,
								   ps.categoria_id,
								   ps.marca_id,
								   m.nome as marca,
								   ps.nome,
								   ps.cod_referencia,
								   ps.destaque,
								   ps.detalhes,
								   ps.informacoes,
								   ps.acessorio,
								   ps.date_insert,
								   ps.user_insert,
								   ps.date_update,
								   ps.user_update,
								   ps.site,
								   ci.descricao as categoria
							  from produto.v$produto_simples ps
							 inner join produto.v$categoria c on c.categoria_id = ps.categoria_id
							 inner join produto.v$categoria_idioma ci on ci.categoria_id = c.categoria_id
							 inner join produto.v$marca m on m.marca_id = ps.marca_id
						where 1=1

							 and ps.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['produto_id'])))
					$query .= ' and ps.produto_id = '.$arguments['produto_id'];
				if(strlen(trim($arguments['not_produto_id'])))
					$query .= ' and ps.produto_id <> '.$arguments['not_produto_id'];
				if(strlen(trim($arguments['categoria_id'])))
					$query .= ' and ps.categoria_id = '.$arguments['categoria_id'];
				if(strlen(trim($arguments['marca_id'])))
					$query .= ' and ps.marca_id = '.$arguments['marca_id'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and ps.destaque = '.$arguments['destaque'];
				if(strlen(trim($arguments['acessorio'])))
					$query .= ' and ps.acessorio = '.$arguments['acessorio'];
				if(strlen(trim($arguments['oferta']))){
					$query .= ' and (  select psv.oferta  
											 from produto.v$produto_simples_valor psv
											where psv.produto_id = ps.produto_id
											  and psv.data = (select min(data)
																from produto.v$produto_simples_valor psv2
															   where psv2.produto_id = psv.produto_id
																 and data <= sysdate)) = '.$arguments['oferta'];
				}
				if(strlen(trim($arguments['palavra_chave']))){
					$palavras = explode(" ",$arguments['palavra_chave']);
					
					$query .= ' and ( ';
						
					for($i=0; $i<count($palavras); $i++){
						if($i>0)
							$query .= ' or ';
							
						$query .= ' upper(kss.pkg_string.fnc_string_clean(ps.nome)) like upper(kss.pkg_string.fnc_string_clean(\'%'.$palavras[$i].'%\')) ';
					}
					
					$query .= ' ) ';					
				}
				
				if(strlen(trim($arguments['nome'])))
					$query .= ' and upper(ps.nome) like upper(\'%'.$arguments['nome'].'%\')';
				if(!strlen(trim($arguments['ordem'])))
					$query .= ' order by ps.nome';
				else
					$query .= ' order by '.$arguments['ordem'];
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca produto simples
		 */
		function get_produto_simples_foto($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select produto_foto_id,
								   produto_id,
								   foto_id,
								   ordem,
								   date_insert,
								   user_insert,
								   date_update,
								   user_update,
								   site
							  from produto.v$produto_simples_foto
						where 1=1 ';
				if(strlen(trim($arguments['produto_foto_id'])))
					$query .= ' and produto_foto_id = '.$arguments['produto_foto_id'];
				if(strlen(trim($arguments['produto_id'])))
					$query .= ' and produto_id = '.$arguments['produto_id'];
				if(strlen(trim($arguments['foto_id'])))
					$query .= ' and foto_id = '.$arguments['foto_id'];
				if(strlen(trim($arguments['ordem'])))
					$query .= ' and ordem = '.$arguments['ordem'];
				
				$query .= ' order by ordem';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca produto simples
		 */
		function get_produto_simples_valor($arguments=array(),$resulttype='array') {	
				//new dBug($arguments);
				$query .= 'select produto_valor_id,
								   produto_id,
								   valor,
								   oferta,
								   to_char(data,\'dd/mm/yyyy hh24:mm:ss\') as data,
								   forma_pagamento,
								   valor_final,
								   date_insert,
								   user_insert,
								   date_update,
								   user_update,
								   site
							  from produto.v$produto_simples_valor psv
						where 1=1 ';
				if(strlen(trim($arguments['produto_valor_id'])))
					$query .= ' and produto_valor_id = '.$arguments['produto_valor_id'];
				if(strlen(trim($arguments['produto_id'])))
					$query .= ' and produto_id = '.$arguments['produto_id'];
				if(strlen(trim($arguments['oferta'])))
					$query .= ' and oferta = '.$arguments['oferta'];
				if(strlen(trim($arguments['valor'])))
					$query .= ' and valor = '.$arguments['valor'];
				if(strlen(trim($arguments['data'])))
					$query .= ' and psv. data  <= \''.$arguments['data'].'\'';
				if(strlen(trim($arguments['data_exibicao'])))
					$query .= ' and psv.data  >= \''.$arguments['data_exibicao'].'\'';
				
				$query .= ' order by psv.data desc';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		 *  Busca informações do selo de um produto
		 */
		function get_marcas_categoria($arguments=array(),$resulttype='array') {		 	
			$query = 'select   m.nome,
							   m.marca_id,
							   ci.categoria_id,
							   ci.descricao,
							   count(*)
						from produto.v$categoria_idioma ci
						inner join produto.v$categoria c on c.categoria_id = ci.categoria_id and idioma_id = 11
						inner join produto.v$produto_simples p on p.categoria_id = c.categoria_id
						inner join produto.v$marca m on m.marca_id = p.marca_id
						
					   where 1=1
					 and p.cod_portal = \''.$arguments['cod_portal'].'\'';
					 
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and ci.categoria_id = '.$arguments['categoria_id'];
			if(strlen(trim($arguments['marca_id'])))
				$query .= ' and m.marca_id = '.$arguments['marca_id'];
					  
		    $query .= ' group by m.marca_id,m.nome,ci.categoria_id, ci.descricao, ci.categoria_id
						order by m.nome';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
				
				
			//print($query);
		
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca informações do selo de um produto
		 */
		function get_produto_acessorio_categoria($arguments=array(),$resulttype='array') {		 	
			$query = 'select count(*) total
						from produto.v$produto_simples ps
						
					   where 1=1
					 and ps.cod_portal = \''.$arguments['cod_portal'].'\'';
					 
			if(strlen(trim($arguments['produto_id'])))
				$query .= ' and ps.produto_id = '.$arguments['produto_id'];
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and ps.categoria_id = '.$arguments['categoria_id'];
					  
		
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca informações do selo de um produto
		 */
		function get_forma_pagamento($arguments=array(),$resulttype='array') {		 	
			$query = 'select forma_pagamento_id,
							   nome,
							   foto_id,
							   ordem,
							   cod_portal,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from produto.v$forma_pagamento
						
					   where 1=1
					 and cod_portal = \''.$arguments['cod_portal'].'\'';
					 
			if(strlen(trim($arguments['forma_pagamento_id'])))
				$query .= ' and forma_pagamento_id = '.$arguments['forma_pagamento_id'];
			if(strlen(trim($arguments['nome'])))
				$query .= ' and nome like \'%'.$arguments['nome'].'%\'';
					  
			$query .= ' order by ordem, nome ';
		
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
						
		 
	}
	global $conexao_banco; 
	$ProdutoComObj = new ProdutoCom($conexao_banco);
}

global $createdObject;
$createdObject = $ProdutoComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>