<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $PortalAjudaComObj;
if(!$PortalAjudaComObj) {
	class PortalAjudaCom extends QueryCom {
		/*
		*
		* Retorna os idiomas
		*/
		function get_idioma($arguments = array(), $resulttype = 'array') {
			$query = '  select i.idioma_id
							 , i.nome
							 , i.cod_portal
							 , i.principal
							 , i.url_bandeira
						  from site.v$idioma i
						 where i.cod_portal = \'' . $arguments['cod_portal'] . '\'';
						if(strlen(trim($arguments['idioma_id']))) {
							$query .= ' and i.idioma_id = ' . $arguments['idioma_id'];
						}
						if(strlen(trim($arguments['idioma_principal']))) {
							$query .= ' and i.principal = 1';
						}
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna os clientes
		*/
		function get_cliente($arguments = array(), $resulttype = 'array') {
			$query = '  select c.cliente_id
							 , c.cliente
							 , c.nome
							 , p.cliente as nome_pessoa
							 , c.cod_pessoa
							 , c.grupo_id
							 , c.date_insert
							 , c.user_insert
							 , c.date_update
							 , c.user_update
							 , c.site
						  from kmm.v$cliente c
						  left join kss.v$pessoa p
								 on p.cod_pessoa = c.cod_pessoa
					     order by c.cliente';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna os mdulos
		*/
		function get_modulo($arguments = array(), $resulttype = 'array') {
			$query = '  select m.modulo_id
							 , m.cod_modulo
							 , m.nome
							 , m.descricao
						  from kmm.v$modulo m
						 order by m.nome';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna as categorias de tpicos em modo de uma rvore
		*/
		function get_categoria_path($arguments = array(), $resulttype = 'array') {
			$query = '   select sys_connect_by_path(ci.descricao, \'->\') as path
							  , c.categoria_id
							  , c.categoria_id_pai
							  , c.cod_portal
							  , ci.descricao
							  , ci.texto
							  , ci.idioma_id
							  , i.nome as idioma
							  , case
								   when (select count(*)
										   from ajuda.v$categoria c2
										  where c2.categoria_id_pai = c.categoria_id) > 0 then 1
								   else 0
								end as possui_filhos
						   from ajuda.v$categoria c
						  inner join ajuda.v$categoria_idioma ci
								  on ci.categoria_id = c.categoria_id';
							if(strlen(trim($arguments['idioma_id']))) {
								$query .= ' and ci.idioma_id = ' . $arguments['idioma_id'];
							}
							if(strlen(trim($arguments['idioma_principal'])) && $arguments['idioma_principal'] == 1) {
								$query .= ' and ci.idioma_id = (select i.idioma_id
																  from site.v$idioma i
																 where i.principal = 1)';
							}
			  $query .= ' inner join site.v$idioma i
								  on i.idioma_id = ci.idioma_id
						  where c.cod_portal = \'' . $arguments['cod_portal'] . '\'';
						if(strlen(trim($arguments['cliente_id']))) {
							$query .= ' and ajuda.pkg_portal_ajuda.fnc_categoria_pertence_cliente(c.categoria_id, c.cod_portal, ' . $arguments['cliente_id'] . ') = 1';
						}
						if(strlen(trim($arguments['categoria_id_pai']))) {
							if($arguments['categoria_id_pai'] == 'null') {
								$query .= ' and c.categoria_id_pai is null';
							}
							else {
								$query .= ' and c.categoria_id_pai = ' . $arguments['categoria_id_pai'];
							}
						}
						
						if(strlen(trim($arguments['start_categoria_id_pai']))) {
							$query .= ' start with c.categoria_id_pai = ' . $arguments['categoria_id_pai'];
						}
						else {
							$query .= ' start with c.categoria_id_pai is null';
						}
			$query .= ' connect by prior c.categoria_id = c.categoria_id_pai
						  order siblings by ci.descricao';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna as categorias de tpicos
		*/
		function get_categoria($arguments = array(), $resulttype = 'array') {
			$query = '  select c.categoria_id
							 , c.categoria_id_pai
							 , c.cod_portal
							 , ci.descricao
							 , ci.texto
							 , ci.idioma_id
							 , i.nome as idioma
						  from ajuda.v$categoria c
						 inner join ajuda.v$categoria_idioma ci
						         on ci.categoria_id = c.categoria_id
						 inner join site.v$idioma i
								 on i.idioma_id = ci.idioma_id
					     where c.cod_portal = \'' . $arguments['cod_portal'] . '\'';
						if(strlen(trim($arguments['categoria_id']))) {
							$query .= ' and c.categoria_id = ' . $arguments['categoria_id'];
						}
						if(strlen(trim($arguments['idioma_id']))) {
							$query .= ' and ci.idioma_id = ' . $arguments['idioma_id'];
						}
			 $query .= ' order by c.categoria_id_pai, ci.descricao, ci.idioma_id';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna os mdulos de uma categoria
		*/
		function get_categoria_modulo($arguments = array(), $resulttype = 'array') {
			$query = '  select cm.controle_id
							 , cm.categoria_id
							 , cm.modulo_id
							 , m.nome as modulo
						  from ajuda.v$categoria_modulo cm
						 inner join kmm.v$modulo m
						 		 on m.modulo_id = cm.modulo_id
						 where cm.categoria_id = ' . $arguments['categoria_id'];
			 $query .= ' order by m.nome';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna os tpicos de uma categoria e de um cliente
		*/
		function get_categoria_topico($arguments = array(), $resulttype = 'array') {
			$query = '  select t.topico_id
							 , t.categoria_id
							 , t.reservado_usuario
							 , t.titulo
							 , t.idiomas
						  from (select t.topico_id
									 , t.categoria_id
									 , t.reservado_usuario
									 , ajuda.pkg_portal_ajuda.fnc_get_titulo_topico(t.topico_id, ' . $arguments['cliente_id'] . ') as titulo
             						 , ajuda.pkg_portal_ajuda.fnc_get_idiomas_topico(t.topico_id, ' . $arguments['cliente_id'] . ') as idiomas
								  from ajuda.v$topico t
								 where (t.categoria_id = ' . $arguments['categoria_id'];
					        $query .= ' or (' . $arguments['categoria_id'] . ' is null and t.categoria_id is null)
							           )
								   and t.topico_id in (select tv.topico_id
														 from ajuda.v$topico_versao tv
														where tv.cliente_id = ' . $arguments['cliente_id'];
											   $query .= ' or (' . $arguments['cliente_id'] . ' is null and tv.cliente_id is null))
							   ) t
						 order by t.titulo';
			
			return $this->getResult($query, $resulttype);
		}
		
		/*
		*
		* Retorna as verses de um tpico e de um cliente
		*/
		function get_topico_versao($arguments = array(), $resulttype = 'array') {
			$query = '  select tv.versao_id
							 , tv.topico_id
							 , tv.cliente_id
							 , tv.idioma_id
							 , tv.num_versao
							 , tv.descricao
						  from ajuda.v$topico_versao tv
						 where tv.topico_id = ' . $arguments['topico_id'];
			   $query .= ' and (tv.cliente_id = ' . $arguments['cliente_id'];
					$query .= ' or (' . $arguments['cliente_id'] . ' is null and tv.cliente_id is null)
							   )
						   and tv.idioma_id = ' . $arguments['idioma_id'];
			 $query .= ' order by tv.num_versao desc';
			
			return $this->getResult($query, $resulttype);
		}
		
	} // Fim da Classe
	
	global $conexao_banco;
	$PortalAjudaComObj = new PortalAjudaCom($conexao_banco);
} // Fim IF

global $createdObject;
$createdObject = $PortalAjudaComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	}
	catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>