<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $PortalComObj;
if(!$PortalComObj) {
	class PortalCom extends QueryCom {
	   
	    // retorna data e hora formatado
	    function get_data_hora(){
			$s = date("D");
			$m = date("n"); 
			$h = date("H"); 
			$min = date("i"); 
			$dia=date("d");
			$ano=date("Y");
			$semana = array("Sun" => "Domingo", "Mon" => "Segunda-Feira", "Tue" => "Ter&ccedil;a-Feira", "Wed" => "Quarta-Feira", "Thu" => "Quinta-Feira", "Fri" => "Sexta-Feira", "Sat" => "S&aacute;bado"); /* Dias da Semana. */ 
			$mes = array(1 =>"Janeiro", "Fevereiro", "Mar&ccedil;o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"); /* Meses */ 
			
			return "$semana[$s], $dia de $mes[$m]"; 
		}
	
		/* Busca os Grupos de Portais */
		function get_portal_grupo($arguments) {
			$query = 
			'select grupo_id,
				    descricao,
					cod_grupo_usuarios,
				    to_char(date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				    user_insert,
				    to_char(date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				    user_update,
				    site
			   from site.v$portal_grupo
			  where 1=1 ';
			if(strlen(trim($arguments["grupo_id"])))
				$query .= ' and grupo_id = '.$arguments["grupo_id"];
				
			$query .= ' order by descricao';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
	
		/* Busca um parametro do Portal */
		function get_portal_parametro($arguments) {
			$query = 
			'select valor
			   from site.v$portal_parametro
			  where 1=1 ';
			if(strlen(trim($arguments["cod_portal"])))
				$query .= ' and cod_portal = \''.$arguments["cod_portal"].'\'';
			if(strlen(trim($arguments["cod_parametro"])))
				$query .= ' and cod_parametro = \''.$arguments["cod_parametro"].'\'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		/* Busca os setores do Portal */
		function get_portal_setor($arguments=array(),$resulttype='array') {

			$query = 
			'select setor_id,
				    cod_portal,
				    cod_setor,
				    descricao,
				    padrao,
				    to_char(date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				    user_insert,
				    to_char(date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
		 		    user_update, 
				    site
 			   from site.v$portal_setor
			  where 1=1 ';
			if(strlen(trim($arguments["cod_portal"])))
				$query .= ' and cod_portal = \''.$arguments["cod_portal"].'\'';
			if(strlen(trim($arguments["cod_setor"])))
				$query .= ' and cod_setor = \''.$arguments["cod_setor"].'\'';
			if(strlen(trim($arguments["setor_id"])))
				$query .= ' and setor_id = '.$arguments["setor_id"].'';
			if(strlen(trim($arguments["padrao"])))
				$query .= ' and padrao = \''.$arguments["padrao"].'\'';
			$query .= ' order by padrao desc, descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);

			return $this->getResult($query,$resulttype);
		}

		/* Busca os Portais */
		function get_portal($arguments) {
			$query = 
			'select p.cod_portal,
					   p.grupo_id,
					   pg.descricao as grupo,
					   p.descricao,
					   p.http_host,
					   p.proprietario,
					   p.analytics_key,
					   p.meta_tags,
					   p.title,
					   p.keywords,
					   p.verify_vl,
					   espaco,	
					   meebo,				
					   setor_rss,	   
					   to_char(p.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   p.user_insert,
					   to_char(p.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   p.user_update,					   
					   p.site
				  from site.v$portal p
				  left join site.v$portal_grupo pg
				         on pg.grupo_id = p.grupo_id
  				 where 1=1 ';
			if(strlen(trim($arguments["cod_portal"])))
				$query .= ' and p.cod_portal = \''.$arguments["cod_portal"].'\'';
			if(strlen(trim($arguments["grupo_id"])))
				$query .= ' and p.grupo_id = '.$arguments["grupo_id"].'';
			$query .= ' order by p.descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				

			return $this->getResult($query);
		}
		
		function get_portal_espaco($arguments=array(),$resulttype='array'){
 			$query = 'select max(p.espaco) as espaco,
  						     nvl(sum((lengthb(a.conteudo)) / 1024) / 1024,0)  as espaco_utilizado
						   
					    from site.v$portal p
					    left join site.v$arquivo a on a.cod_portal = p.cod_portal	
						
					   where 1=1
					     and p.cod_portal = \''.$arguments['cod_portal'].'\'';
						 
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query,$resulttype);
		}
		
		/* Busca os Modulos de Portais */
		function get_modulo($arguments) {
			
			$query = 
			'select mo.modulo_id,
			   mo.descricao,
			   mo.date_insert,
			   mo.user_insert,
			   mo.date_update,
			   mo.user_update,
			   mo.site,
			   md.modulo_dependente_id,
			   (select descricao from site.v$modulo where modulo_id = md.modulo_dependente_id) as descricao_dependente
		    from site.v$modulo mo
			left join site.v$modulo_dependencia md
  			on mo.modulo_id = md.modulo_id
		    where 1=1';
			
			if(strlen($arguments["modulo_id"]))
				$query .= ' and mo.modulo_id = '.$arguments["modulo_id"];
			
			$query .= ' order by mo.descricao';
			
			return $this->getResult($query);
		}
		
		/* Busca os modulos do portal */
		function get_portal_modulo($arguments=array(),$resulttype='array') {
			$query = '
			select pm.cod_portal,
				   pm.modulo_id,
				   to_char(pm.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   pm.user_insert,
				   to_char(pm.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   pm.user_update,
				   pm.site
			  from site.v$portal_modulo pm
			 inner join site.v$modulo m
			         on m.modulo_id = pm.modulo_id
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and pm.cod_portal = \''.$arguments['cod_portal'].'\'';
			$query .= ' order by m.descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		

		/* Busca os layouts para o setor */
		function get_portal_setor_layout($arguments) {
			$query = 
			'select psl.setor_layout_id,
			        psl.setor_id,
				    to_char(psl.data_exibicao,\'dd/mm/yyyy hh24:mi:ss\') as data_exibicao,
				    psl.cod_setor,
					ps.descricao as setor,
					l.descricao,
					l.largura,
				    psl.layout_id,
					psl.concluido,
					psl.travado,
					case (select max(psl2.setor_layout_id) keep( dense_rank last order by psl2.data_exibicao )
						  from site.v$portal_setor_layout psl2
						 inner join site.v$portal_setor ps2
							on ps2.setor_id = psl2.setor_id
						 where 1 = 1
						   and psl2.data_exibicao < sysdate
						   and ps2.cod_setor = \''.$arguments["cod_setor"].'\'
						   and ps2.cod_portal = \''.$arguments["cod_portal"].'\')
					 when  psl.setor_layout_id then
					   1
					 else
					   0
				    end as em_exibicao,
			 	    to_char(psl.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				    psl.user_insert,
				    psl.user_insert as criador,
				    to_char(psl.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				    psl.user_update,
				    psl.site
			   from site.v$portal_setor_layout psl
			  inner join site.v$portal_setor ps
			          on ps.setor_id = psl.setor_id
		      inner join site.v$layout l
			          on l.layout_id = psl.layout_id
  			  where 1=1 ';
			if(strlen(trim($arguments["setor_id"])))
				$query .= ' and psl.setor_id = '.$arguments["setor_id"].'';
			if(strlen(trim($arguments["setor_layout_id"])))
				$query .= ' and psl.setor_layout_id = '.$arguments["setor_layout_id"].'';
			if(strlen(trim($arguments["data_exibicao"])))
				$query .= ' and psl.data_exibicao = \''.$arguments["data_exibicao"].'\'';
			if(strlen(trim($arguments["cod_setor"])))
				$query .= ' and ps.cod_setor = \''.$arguments["cod_setor"].'\'';
			if(strlen(trim($arguments["cod_portal"])))
				$query .= ' and ps.cod_portal = \''.$arguments["cod_portal"].'\'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			$query .= " order by psl.data_exibicao desc";
			
			//print($query);
			
			return $this->getResult($query);			
		}


		/* Busca o layout atual para o setor */
		function get_portal_setor_layout_atual($arguments) {
			$query = 
			'select ';
			if($this->dbtype == "oracle")
				$query .= '
					site.pkg_portal.fnc_get_setor_layout_atual(\''.$arguments['cod_portal'].'\',\''.$arguments['cod_setor'].'\', to_date(\''.$arguments['data'].'\',\'dd/mm/yyyy hh24:mi:ss\') ) as layout_id,
					s.cod_setor,
					(select largura
					   from site.v$layout l
					  where l.layout_id = site.pkg_portal.fnc_get_setor_layout_atual(\''.$arguments['cod_portal'].'\',\''.$arguments['cod_setor'].'\', to_date(\''.$arguments['data'].'\',\'dd/mm/yyyy hh24:mi:ss\') )) as largura
				';
			elseif($this->dbtype == "postgresql") {
				$query .= '
					site.pkg_portal_fnc_get_setor_layout_atual(\''.$arguments['cod_portal'].'\',\''.$arguments['cod_setor'].'\',\''.$arguments['data'].'\') as layout_id,
					s.cod_setor,
					(select largura
					   from site.v$layout l
					  where l.layout_id = site.pkg_portal_fnc_get_setor_layout_atual(\''.$arguments['cod_portal'].'\',\''.$arguments['cod_setor'].'\',\''.$arguments['data'].'\')) as largura
				';
			}
			$query .= '
			   from site.v$portal_setor s
			  where s.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if(strlen(trim($arguments['cod_setor']))) 
				$query .= 'and s.cod_setor = \''.$arguments['cod_setor'].'\' ';
			else
				$query .= ' and s.padrao = 1 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}


		/* Busca os dominios de um portal */
		function get_portal_dominio($arguments=array(),$resulttype='array') {
			$query = '
				select pd.dominio_id,
					   pd.cod_portal,
					   pd.dominio,
					   pd.google_maps_key,
					   to_char(pd.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   pd.user_insert,
					   to_char(pd.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   pd.user_update,
					   pd.site
				  from site.v$portal_dominio pd
				 where 1=1
			 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and pd.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['dominio'])))
				$query .= ' and pd.dominio = \''.$arguments['dominio'].'\'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
		    return $this->getResult($query,$resulttype);
		}

		/* Busca os valores de cache do portal */
		function get_portal_cache_build($arguments=array(),$resulttype='array') {
			$query = '
				select cod_portal, 
					   cod_tipo, 
					   build_sequence, 
					   to_char(build_date,\'dd/mm/yyyy hh24:mi:ss\') as build_date, 
					   date_insert, 
					   user_insert, 
					   date_update, 
					   user_update, 
					   site 
				  from site.v$portal_cache_build t
				 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= '   and t.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['cod_tipo'])))
				$query .= '   and t.cod_tipo = \''.$arguments['cod_tipo'].'\'';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		
   
	}
	global $conexao_banco;
	$PortalComObj = new PortalCom($conexao_banco);
}

global $createdObject;
$createdObject = $PortalComObj;


if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>