<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
global $NovelaConsultaObj;
if(!$NovelaConsultaObj) {
	class NovelaConsulta extends QueryCom {
		/* Busca as emissoras */
		function get_novela_emissora($arguments=array(),$resulttype='array') {
			$query = '
				select e.emissora_id,
					   e.cod_portal,
					   e.nome,
					   e.url_imagem					   
				  from jornal.v$novela_emissora e
				 where 1=1
				 and cod_portal = \'' . $arguments['cod_portal'] .'\'';
			
			if(isset($arguments['emissora_id']))
				$query .= ' and emissora_id = '.$arguments['emissora_id'];		
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}

		/* Busca as novelas */
		function get_novela($arguments=array(),$resulttype='array') {
			$query = '
				select n.novela_id,
					   n.cod_portal,
					   n.nome,
					   n.horario,
					   n.emissora_id,
					   n.ativa,
					   n.url_imagem,
					   to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   n.user_insert,
					   to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   n.user_update,
					   n.site
					  
				 from jornal.v$novela n
				 
				 where 1=1
				 and cod_portal = \'' . $arguments['cod_portal'] . '\'';		
			
			if(isset($arguments['emissora_id']))
				$query .= ' and emissora_id = ' . $arguments['emissora_id'];
			if(isset($arguments['novela_id']))
				$query .= ' and novela_id = ' .$arguments['novela_id'];
			if(isset($arguments['ativa']))
				$query .= ' and ativa = ' . $arguments['ativa'];	
			if(isset($arguments['ordem'])){
				switch($arguments['ordem']){
					case 0 : $query .= ' order by nome';break;
					case 1 : $query .= ' order by dbms_random.value';break;					
				}
			}
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}


		/* Busca os capitulos da novela */
		function get_novela_capitulo($arguments=array(),$resulttype='array') {
			$query = '
				select c.capitulo_id,
					   c.novela_id,
					   c.data,
					   c.texto,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site
				  from jornal.v$novela_capitulo c				  
				 where 1=1
			 ';
			if(isset($arguments['novela_id']))
				$query .= ' and novela_id = ' . $arguments['novela_id'];
			if(isset($arguments['capitulo_id']))
				$query .= ' and capitulo_id = ' . $arguments['capitulo_id'];
			if(isset($arguments['data']))
				$query .= ' and data >= \'' . $arguments['data'] . '\'';
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
				//print($query);
		    return $this->getResult($query,$resulttype);
		}  		
		
		
		// Busca as novelas e suas emissoras para exibio
		function get_novela_detalhes($arguments=array(),$resulttype='array') {
			$query = 'select n.novela_id,
							   n.nome as novela,
							   n.horario,
							   n.emissora_id,
							   n.ativa,
							   n.url_imagem as url_novela,
							   e.emissora_id,
							   e.nome emissora,
							   e.url_imagem as url_emissora
							   
							   from jornal.v$novela n
							   inner join jornal.v$novela_emissora e
								on n.emissora_id = e.emissora_id
								
							   where 1=1
							   and n.cod_portal = \'' . $arguments['cod_portal'] . '\'';
							   
					
					if(isset($arguments['ativa']))
				     	$query .= ' and ativa = 1';
					if(isset($arguments['novela_id']))
						$query .= ' and novela_id = ' . $arguments['novela_id'];
					if(isset($arguments['emissora_id']))
						$query .= ' and n.emissora_id = ' . $arguments['emissora_id'];
					if(isset($arguments['ordem'])){
						switch($arguments['ordem']){
							case 0 : $query .= ' order by e.nome';break;
							case 1 : $query .= ' order by dbms_random.value';break;
							case 2 : $query .= ' order by n.horario';break;
							case 3 : $query .= ' order by n.nome';break;
						}
					}
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/* Busca os capitulos da novela para exibicao*/
		function get_capitulos($arguments=array(),$resulttype='array') {
			$query = '
				select c.capitulo_id,
					   c.novela_id,
					   c.data,
					   c.texto,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site,
					   n.nome as novela,
					   n.horario,
					   e.emissora_id,
					   e.nome as emissora
				  from jornal.v$novela_capitulo c
				  inner join jornal.v$novela n
				   on n.novela_id = c.novela_id
				  inner join jornal.v$novela_emissora e
				   on n.emissora_id = e.emissora_id
				 where 1=1
			 ';
			if(isset($arguments['novela_id']))
				$query .= ' and n.novela_id = ' . $arguments['novela_id'];
			if(isset($arguments['capitulo_id']))
				$query .= ' and c.capitulo_id = ' . $arguments['capitulo_id'];
			if(strlen(trim($arguments['dia_anterior'])))
				$query .= ' and trunc(c.data) >= trunc(sysdate - '.$arguments['dia_anterior'].')';
			else{
				if(strlen(trim($arguments['data'])))
					$query .= ' and c.data >= \'' . $arguments['data'] . '\'';
			}
			if(isset($arguments['ordem'])){
				switch($arguments['ordem']){
					case 0 : $query .= ' order by nome';break;
					case 1 : $query .= ' order by dbms_random.value';break;
					case 2 : $query .= ' order by n.horario';break;
					case 3 : $query .= ' order by e.nome';break;
				}
			}
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			$query .= ' order by c.data';
			//print($query);
		    return $this->getResult($query,$resulttype);
		}  		
		
		
		
	}
	global $conexao_banco;
	$NovelaConsultaObj = new NovelaConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $NovelaConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>