<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $LayoutConsultaObj;
if(!$LayoutConsultaObj) {
	class LayoutConsulta extends QueryCom {
		/**
		 * Busca os Layouts
		 */
		function get_layout($arguments) {
			$query = 
			'select l.layout_id,
					l.descricao,
					to_char(l.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					l.user_insert,
					to_char(l.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					l.user_update
			   from site.v$layout l
			  where 1=1 ';
			if(strlen(trim($arguments["LAYOUT_ID"])))
				$query .= ' and l.layout_id = '.$arguments["LAYOUT_ID"];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		/**
		 * Busca a estrutura para o layout
		 */
		function get_layout_estrutura($arguments) {
			$query = 
			'	select ltc.layout_coluna_id,
					   lt.layout_tabela_id,
					   lt.largura as largura_tabela,
					   lt.layout_coluna_id_pai,
					   ltc.largura,
					   lt.colunas,
					   lt.configuracoes
				  from site.v$layout_tabela lt
				 inner join site.v$layout_tabela_coluna ltc
						 on ltc.layout_tabela_id = lt.layout_tabela_id
				 where 1=1 ';
			if(strlen(trim($arguments["layout_id"])))
				$query .= ' and layout_id = '.$arguments["layout_id"];
			if(strlen(trim($arguments["layout_tabela_id"])))
				$query .= ' and lt.layout_tabela_id = '.$arguments["layout_tabela_id"];
			$query .= ' order by lt.ordem, ltc.ordem';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		/**
		 * Busca as colunas de uma tabela do layout
		 */
		function get_layout_tabela_coluna($arguments) {
			$query = 
			'	select lc.layout_coluna_id,
					   lc.layout_tabela_id,
					   lc.coluna_id,
					   lc.largura,
					   lc.date_insert,
					   lc.user_insert,
					   lc.date_update,
					   lc.user_update
				  from site.v$layout_tabela_coluna lc
				 where 1=1 ';
			if(strlen(trim($arguments["LAYOUT_COLUNA_ID"])))
				$query .= ' and lc.layout_coluna_id = '.$arguments["LAYOUT_COLUNA_ID"];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		/**
		 * Busca os modelos de tabela
		 */
		function get_tabela_modelo($arguments) {
			$query = 
			'	select tm.tabela_id,
					   tm.descricao,
					   tm.colunas,
					   tm.largura, ';
			if($this->dbtype == "oracle") {
				$query .= '
					   (select kss.fnc_concat_all(kss.to_concat_expr(to_char(largura),\',\'))
						  from site.v$tabela_modelo_coluna tmc
						 where tmc.tabela_id = tm.tabela_id) as medidas, ';
			}
			if($this->dbtype == "postgresql") {
				$query .= '
					   (select array_to_string(array_accum(largura),\',\')
						  from site.v$tabela_modelo_coluna tmc
						 where tmc.tabela_id = tm.tabela_id) as medidas, ';
			}
			$query .= '
					   tm.date_insert,
					   tm.user_insert,
					   tm.date_update,
					   tm.user_update
				  from site.v$tabela_modelo tm
				 where 1=1 ';
			if(strlen(trim($arguments["LARGURA"])))
				$query .= ' 
					   and tm.largura = '.$arguments["LARGURA"];
			if($arguments["MAIS_QUE_1_COLUNA"])
				$query .= ' 
					   and tm.colunas > 1 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		/**
		 * Busca a tabela de objetos
		 */
		function get_objeto($arguments) {
			$query = 
			'	select o.objeto_id,
					   o.categoria_id,
					   oc.descricao categoria,
					   o.modulo_id,
					   o.titulo,
					   o.url_corpo,
					   o.url_icone,
					   o.possui_configuracao,
					   o.date_insert,
					   o.user_insert,
					   o.date_update,
					   o.user_update,
					   (select count(*)
					      from site.v$objeto_modulo om
						 where om.objeto_id = o.objeto_id) nro_modulos,
					   o.configuracoes_padrao
				  from site.v$objeto o
				 inner join site.v$objeto_categoria oc
				         on oc.categoria_id = o.categoria_id
				 where 1=1 ';
			if(strlen(trim($arguments["objeto_id"])))
				$query .= ' and o.objeto_id = '.$arguments["objeto_id"];
			if(strlen(trim($arguments["categoria_id"])))
				$query .= ' and o.categoria_id = '.$arguments["categoria_id"];
			$query .= ' order by oc.descricao, o.titulo ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			return $this->getResult($query);
		}
		
		
		/**
		 * Busca a tabela de objetos
		 */
		function get_objeto_ordenado($arguments) {
			$query = 
			'	select o.objeto_id,
					   o.categoria_id,
					   o.modulo_id,
					   o.titulo,
					   o.url_corpo,
					   o.url_icone,
					   o.possui_configuracao,
					   o.date_insert,
					   o.user_insert,
					   o.date_update,
					   o.user_update
				  from site.v$objeto o
				 where 1=1 ';
			if(strlen(trim($arguments["objeto_id"])))
				$query .= ' and o.objeto_id = '.$arguments["objeto_id"];
			if(strlen(trim($arguments["categoria_id"])))
				$query .= ' and o.categoria_id = '.$arguments["categoria_id"];
			$query .= ' order by o.titulo ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			return $this->getResult($query);
		}

		
		/**
		 * Busca a tabela de objetos
		 */
		function get_objeto_configuration($arguments=array()) {
			$qrLayoutObjeto = $this->get_layout_objeto($arguments);
			if(count($qrLayoutObjeto) == 1 ) {
				$result = array();
				if(strlen(trim($qrLayoutObjeto[0]['CONFIGURACOES'])))
					$configuration = new SimpleXMLElementExtended($qrLayoutObjeto[0]['CONFIGURACOES']);
				else {
					$qrObjeto = $this->get_objeto(array(objeto_id => $qrLayoutObjeto[0]['OBJETO_ID']));
					$configuration = new SimpleXMLElementExtended($qrObjeto[0]['CONFIGURACOES_PADRAO']);
				}
				foreach($configuration->children() as $key => $child) {
					$result[0][strtoupper($key)] = utf8_decode($child.'');
				}
				$result[0]['OBJETO_ID'] = $qrLayoutObjeto[0]['OBJETO_ID'];
				$result[0]['LAYOUT_OBJETO_ID'] = $qrLayoutObjeto[0]['LAYOUT_OBJETO_ID'];
				$result[0]['OBJETO_TITULO'] = $qrLayoutObjeto[0]['TITULO'];
				return $result;
			} else {
				return array();
			}
		}
		
		/**
		 * Busca a tabela de objetos para o portal
		 */
		function get_objeto_portal($arguments) {
			$query = 
			'	select o.objeto_id,
					   o.categoria_id,
					   oc.descricao categoria,
					   o.modulo_id,
					   o.titulo,
					   o.url_corpo,
					   o.url_icone,
					   o.possui_configuracao,
					   o.date_insert,
					   o.user_insert,
					   o.date_update,
					   o.user_update
				  from site.v$objeto o
				 inner join site.v$objeto_categoria oc
				         on oc.categoria_id = o.categoria_id
				 inner join site.v$objeto_modulo om
				         on om.objeto_id = o.objeto_id
	             inner join site.v$portal_modulo pm
				         on pm.modulo_id = om.modulo_id
				 where 1=1 
				   and pm.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if(strlen(trim($arguments["objeto_id"])))
				$query .= ' and o.objeto_id = '.$arguments["objeto_id"];
			$query .= ' order by oc.descricao, o.titulo ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		/**
		 * Busca os objetos do layout
		 */
		function get_layout_objeto($arguments) {
			$query =  
			'	select lo.layout_coluna_id, 
					   ltc.largura,
					   lo.ordem,
					   lo.objeto_id,
					   lo.layout_id,
					   o.titulo,
					   o.url_corpo,
					   o.possui_configuracao,
					   lo.layout_objeto_id,
					   lo.configuracoes
				  from site.v$layout_objeto lo
				 inner join site.v$objeto o
						 on o.objeto_id = lo.objeto_id
				  left join site.v$layout_tabela_coluna ltc
						 on ltc.layout_coluna_id = lo.layout_coluna_id
				  left join site.v$layout_tabela lt
						 on lt.layout_tabela_id = ltc.layout_tabela_id
				 where 1=1 ';
			if(strlen(trim($arguments["objeto_id"])))
				$query .= ' and o.objeto_id = '.$arguments["objeto_id"];
			if(strlen(trim($arguments["layout_objeto_id"])))
				$query .= ' and lo.layout_objeto_id = '.$arguments["layout_objeto_id"];
			if(strlen(trim($arguments["layout_id"])))
				$query .= ' and lo.layout_id = '.$arguments["layout_id"];
			$query .= ' and lo.layout_coluna_id is not null 
					order by lt.ordem,lo.ordem';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		/**
		 * Busca os objetos do layout
		 */
		function get_layout_objeto_estrutura($arguments) {
			$query =  
			'	select /*+ index(ltc idx_ltc_01) */ lo.layout_coluna_id,
					   lt.largura,
					   lo.ordem,
					   lo.objeto_id,
					   lo.layout_id,
					   o.titulo,
					   o.url_corpo,
					   o.possui_configuracao,
					   lo.layout_objeto_id,
					   lo.configuracoes,
					   lo.build_sequence,
					   lo.md5_cache,
					   o.cod_tipo_cache
				  from site.v$layout_objeto lo
				 inner join site.v$objeto o on o.objeto_id = lo.objeto_id
				 inner join (select layout_coluna_id,
									largura,
									layout_coluna_id_pai,
									ordem_tabela,
									ordem_coluna,
									nivel,
									rownum as ordem
							   from (select layout_coluna_id,
									 		largura,
											layout_coluna_id_pai,
											ordem_tabela,
											ordem_coluna,
											level as nivel
									  from (
											 select ltc.layout_coluna_id,
													ltc.largura,
													lt.layout_coluna_id_pai,
													lt.ordem as ordem_tabela,
													ltc.ordem as ordem_coluna
											   from site.v$layout_tabela_coluna ltc 
											  inner join site.v$layout_tabela lt 
													  on lt.layout_tabela_id = ltc.layout_tabela_id
											  where lt.layout_id = '.$arguments['layout_id'].' )
									  start with layout_coluna_id_pai is null
									 connect by prior layout_coluna_id = layout_coluna_id_pai
									 order siblings by ordem_tabela, ordem_coluna)) lt
						 on lt.layout_coluna_id = lo.layout_coluna_id
				 where 1 = 1
				   and lo.layout_id = '.$arguments['layout_id'].'
				   and lo.layout_coluna_id is not null
				 order by lt.ordem, lo.ordem';
			if($this->dbtype == "postgresql")
			$query =  
			'	select /*+ index(ltc idx_ltc_01) */ lo.layout_coluna_id,
					   lt.largura,
					   lo.ordem,
					   lo.objeto_id,
					   lo.layout_id,
					   o.titulo,
					   o.url_corpo,
					   o.possui_configuracao,
					   lo.layout_objeto_id,
					   lo.configuracoes
				  from site.v$layout_objeto lo
				 inner join site.v$objeto o on o.objeto_id = lo.objeto_id
				 inner join (select layout_coluna_id,
									largura,
									layout_coluna_id_pai,
									ordem_tabela,
									ordem_coluna
							   from (select ltc.layout_coluna_id,
											ltc.largura,
											lt.layout_coluna_id_pai,
											lt.ordem as ordem_tabela,
											ltc.ordem as ordem_coluna
									   from site.v$layout_tabela_coluna ltc 
									  inner join site.v$layout_tabela lt 
											  on lt.layout_tabela_id = ltc.layout_tabela_id
									  where lt.layout_id = '.$arguments['layout_id'].') a) lt
						 on lt.layout_coluna_id = lo.layout_coluna_id
				 where 1 = 1
				   and lo.layout_id = '.$arguments['layout_id'].'
				   and lo.layout_coluna_id is not null
				 order by lt.ordem_tabela, lt.ordem_coluna';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		/**
		 * Busca a estrutura de menus para o site
		 */
		function get_menu_item_estrutura($arguments) {

			$query = 
			'	select i.item_id,
					   i.menu_id,
					   i.tipo_id,
					   i.label,
					   i.ordem,
					   i.url,
					   i.target,
					   i.tipo_url,
					   i.administrativo,
					   i.setor_id,
					   s.cod_setor,
					   i.date_insert,
					   i.user_insert,
					   i.date_update,
					   i.user_update,
					   i.site,
					   i.item_pai_id,
					   (select count(*)
						 from site.v$menu_item mi
						where i.item_id = mi.item_pai_id)as filhos,
					   (select max(length(i2.label))
						  from site.v$menu_item i2
						 where i2.item_pai_id ';
			if(strlen(trim($arguments['raiz_null'])))
				$query .= ' is null';
			else
				$query .= ' = i.item_pai_id ';
				
			$query .= '
						   and i2.menu_id = i.menu_id ) as texto_maior
				  from site.v$menu_item i
				  left join site.v$portal_setor s
				         on s.setor_id = i.setor_id
				 where 1=1 ';
			if(strlen(trim($arguments['posicao_id'])))
				$query .= ' and i.menu_id = (select max(menu_id) keep (dense_rank first order by data_inicio)
										  from site.v$menu m
										 where m.posicao_id = '.$arguments['posicao_id'].'
										   and m.data_inicio <= sysdate )';
			if(strlen(trim($arguments['raiz_null'])))
				$query .= ' and i.item_pai_id is null';
			if(strlen(trim($arguments['item_pai_id'])))
				$query .= ' and i.item_pai_id = '.$arguments['item_pai_id'];
				
			$query .= ' order by i.item_pai_id nulls first, i.ordem ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
			return $this->getResult($query);
		}
		
		
		
		/**
		 * Busca a estrutura de menus para o site em forma de rvore
		 */
		function get_menu_item_estrutura_tree($arguments=array()) {
		
			$query .= ' select i.item_id,
							 i.menu_id,
							 i.tipo_id,
							 i.label,
							 i.ordem,
							 i.url,
							 i.target,
							 i.tipo_url,
							 i.administrativo,
							 i.setor_id,
							 s.cod_setor,
							 i.date_insert,
							 i.user_insert,
							 i.date_update,
							 i.user_update,
							 i.site,
							 i.item_pai_id,
							 level,
							 lpad(\' \',level,\'-\') ident,
										 connect_by_isleaf as filho,
										 (select count(*)
										 from site.v$menu_item i2
										 where i2.item_pai_id = i.item_id) as filhos
							 
					 from site.v$menu_item i
					 left join site.v$portal_setor s
					      on s.setor_id = i.setor_id
					 where 1=1 ';
					 
					 if(strlen($arguments['posicao_id'])) {
					 	$query .= ' and i.menu_id = (select max(menu_id) keep (dense_rank first order by data_inicio)
															   from site.v$menu m
															   where m.posicao_id = '.$arguments['posicao_id'].'
					 							               and m.data_inicio <= sysdate ) ';
					 }		
					 
					 if(strlen($arguments['item_id'])){
					 	$query .= ' and i.item_id = '.$arguments['item_id'];
					 }
					 
					 if(strlen($arguments['item_pai_id'])){
					 	$query .= ' and i.item_pai_id = '.$arguments['item_pai_id'];	
					 }			  
					
		  	$query .= 'start with i.item_pai_id is null
					  connect by prior i.item_id = i.item_pai_id
					  order siblings by decode(i.item_pai_id,null,to_char(i.item_id),i.label)';
		
		
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		
		}
		
		
		/* Busca as categorias de objeto */
		function get_objeto_categoria($arguments=array(),$resulttype='array') {
			$query = '
				select c.categoria_id,
					   lpad(\' \',level-1,\' \') ident,
					   c.categoria_pai_id,
					   c.descricao,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site
				  from site.v$objeto_categoria c
				 where 1=1
			 ';
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and c.categoria_id = '.$arguments['categoria_id'];
			$query .= ' start with c.categoria_pai_id is null
			           connect by c.categoria_pai_id = prior c.categoria_id 
					    order siblings by c.descricao';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		

		/* Busca as posies de menu */
		function get_menu_posicao($arguments=array(),$resulttype='array') {
			$query = '
				select p.posicao_id,
					   p.cod_portal,
					   p.descricao,
					   to_char(p.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   p.user_insert,
					   to_char(p.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   p.user_update,
					   p.site
				  from site.v$menu_posicao p
				 where 1=1
			 ';
			if(strlen(trim($arguments['posicao_id'])))
				$query .= ' and p.posicao_id = '.$arguments['posicao_id'].' ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and p.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca o menu */
		function get_menu($arguments=array(),$resulttype='array') {
			$query = '
				select m.menu_id,
					   m.posicao_id,
					   p.descricao as posicao,
					   to_char(m.data_inicio,\'dd/mm/yyyy hh24:mi:ss\') as data_inicio,
					   to_char(m.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   m.user_insert,
					   to_char(m.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   m.user_update,
					   m.site
				  from site.v$menu m
				 inner join site.v$menu_posicao p 
				         on p.posicao_id = m.posicao_id
				 where 1=1
			 ';
			if(strlen(trim($arguments['menu_id'])))
				$query .= ' and m.menu_id = '.$arguments['menu_id'].' ';
			if(strlen(trim($arguments['posicao_id'])))
				$query .= ' and m.posicao_id = '.$arguments['posicao_id'].' ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		

		/* Busca os itens de menu */
		function get_menu_item($arguments=array(),$resulttype='array') {
			$query = '
				select i.item_id,
					   i.menu_id,
					   i.tipo_id,
					   i.label,
					   i.ordem,
					   i.url,
					   i.target,
					   i.tipo_url,
					   i.administrativo,
					   i.setor_id,
					   i.date_insert,
					   i.user_insert,
					   i.date_update,
					   i.user_update,
					   i.site,
					   i.item_pai_id
				  from site.v$menu_item i
				 where 1=1
			 ';
			if(strlen(trim($arguments['menu_id'])))
				$query .= ' and i.menu_id = '.$arguments['menu_id'];
			if(strlen(trim($arguments['item_id'])))
				$query .= ' and i.item_id = '.$arguments['item_id'];
			$query .= ' order by i.item_id';
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca a arvore de elementos de um layout */
		function get_layout_tree($arguments=array(),$resulttype='array') {
			$query = '
				select tipo,
					   titulo,
					   id,
					   id_pai,
					   ordem,
					   level as nivel
				  from (select \'OBJETO\' as tipo,
							   o.titulo,
							   layout_objeto_id as id,
							   layout_coluna_id as id_pai,
							   ordem
						  from site.v$layout_objeto lo
						 inner join site.v$objeto o
								 on o.objeto_id = lo.objeto_id
						 where lo.ordem is not null
						   and lo.layout_id = '.$arguments['layout_id'].'
						union all
						select \'GRUPO\' as tipo,
							   \'Grupo \'||layout_tabela_id as titulo,
							   layout_tabela_id as id,
							   layout_coluna_id_pai as id_pai,
							   ordem
						  from site.v$layout_tabela lt
						 where lt.layout_id = '.$arguments['layout_id'].'
						union all
						select \'COLUNA\' as tipo,
							   \'Coluna \'||lc.ordem as titulo,
							   lc.layout_coluna_id as id,
							   lc.layout_tabela_id as id_pai,
							   lc.ordem
						  from site.v$layout_tabela_coluna lc
						 inner join site.v$layout_tabela lt
								 on lt.layout_tabela_id = lc.layout_tabela_id
						 where lt.layout_id = '.$arguments['layout_id'].') 
				 start with id_pai is null
				connect by nocycle prior id = id_pai
				 order siblings by ordem		
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}	

		/* Busca os modulos */
		function get_modulo($arguments=array(),$resulttype='array') {
			$query = '
				select modulo_id,
					   descricao,
					   to_char(date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   user_insert,
					   to_char(date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   user_update,
					   site
				  from site.v$modulo
					order by descricao
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os modulos do objeto */
		function get_objeto_modulo($arguments=array(),$resulttype='array') {
			$query = '
				select objeto_id,
					   modulo_id,
					   to_char(date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   user_insert,
					   to_char(date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   user_update,
					   site
				  from site.v$objeto_modulo
				 where 1=1
			 ';
			if(strlen(trim($arguments['objeto_id'])))
				$query .= ' and objeto_id = '.$arguments['objeto_id'];
			if(strlen(trim($arguments['modulo_id'])))
				$query .= ' and modulo_id = '.$arguments['modulo_id'];
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		

	}
	global $conexao_banco;
	$LayoutConsultaObj = new LayoutConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $LayoutConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}

?>