<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $JornalConsultaObj;
if(!$JornalConsultaObj) {
	class JornalConsulta extends QueryCom {
		function get_portal($arguments) {
			$query = 
			'select *
			   from jornal.v$portal
			  where 1=1 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			return $this->getResult($query);
		}
		
		function get_noticias_portal($arguments=array()){
			$query = 'select count(distinct noticia_id) as total
						from jornal.v$noticia n
						
						where 1=1
					and n.data_publicacao <= sysdate';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['grupo_portais'])))
				$query .= ' and cod_portal in ('.str_replace("\'","'",$arguments['grupo_portais']).')';
			//print($query);
			return $this->getResult($query);
		}
		
		function get_noticia_foto($arguments){
			if(!strlen(trim($arguments['offset'])))
				$arguments['offset'] = 0;
			$query = '
			select distinct noticia_id,
						   foto_id,
						   ordem,
						   titulo,
						   credito,
						   legenda,
						   descricao,
						   altura,
						   largura,
						   proporcao,
						   date_insert,
						   user_insert,
						   date_update,
						   user_update,
						   site,
						   data_exibicao,
						   url_imagem,
						   titulo_org,
						   categoria_id
			
			from (
			    select nf.noticia_id,
					   nf.foto_id,
					   nf.ordem,
					   nf.titulo,
					   nf.credito,
					   nf.legenda,
					   nf.descricao,
					   nf.altura,
					   nf.largura,
					   case when nvl(f.altura,0) = 0 then 0 else f.largura/f.altura end proporcao,
					   nf.date_insert,
					   nf.user_insert,
					   nf.date_update,
					   nf.user_update,
					   nf.site,
					   e.data_exibicao,
					   f.url_imagem,
					   f.titulo titulo_org,
                       f.categoria_id,
					   row_number() over (order by ns.ordem desc, nf.ordem) linha
					from jornal.v$noticia_foto nf
				   inner join jornal.v$noticia n on n.noticia_id = nf.noticia_id
				   inner join jornal.v$noticia_secao ns on ns.noticia_id = n.noticia_id
				   inner join jornal.v$secao s on s.secao_id = ns.secao_id
				   inner join jornal.v$edicao e on e.edicao_id = ns.edicao_id
				   inner join site.v$foto f
					   on f.foto_id = nf.foto_id
				   where 1=1       ';
			if(strlen(trim($arguments['noticia_id'])))
				$query .= ' and nf.noticia_id in ('.$arguments['noticia_id'].') ';
			
			switch($arguments['orderby']){
				case "random": 
					$query .= ' order by dbms_random.value  ';
					break;
				case "noticia":
					$query .= " order by e.data_exibicao desc";
					break;
				default: 
					$query .= ' order by nf.ordem  ';
					break;
			}
			
			$query .= '	) where 1=1 ';
			if(strlen(trim($arguments['offset'])))
				$query .= " and linha >= ".$arguments['offset']; 
			if(strlen(trim($arguments['nro_fotos'])))
				$query .= " and linha <= ".($arguments['offset']+$arguments['nro_fotos']);
			
			//print($query);
			return $this->getResult($query);		
		}
		
		
		function get_portal_noticia($arguments=array()){
			$query = 'select cod_portal
						from jornal.v$noticia t
						
						where 1=1 
						 and noticia_id = '.$arguments['noticia_id'].'';
			//print($query);
			return $this->getResult($query);
		}
		
		function get_noticia($arguments) {
			if(!isset($arguments['cod_portal']))
				$arguments['cod_portal'] = $_SESSION['cod_portal'];
			$query = 
			'select * from (
             select n.noticia_id, 
			 		n.texto,
			 		s.descricao as secao,
                    to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					to_char(n.data_publicacao,\'hh24:mi\') as hora_publicacao,
                    n.categoria,
                    n.titulo,
                    n.subtitulo,
                    n.fonte_id,
                    f.nome, 
                    f.nome as fonte,
                    f.link as fonte_link, 
                    to_char(f.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as data_insercao, 
                    n.autor,
                    to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
                    n.user_insert,
                    to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
                    n.user_update,
                    n.site,
					n.tags,
                    n.plantao,
					n.fotos,
					fo.url_imagem,
					n.foto_id,
                   decode(n.plantao,1,\'Sim\',\'No\') as plantao_descricao,
                   ns.secao_id
             from jornal.v$noticia n
             left join jornal.v$noticia_secao ns 
                    on ns.noticia_id = n.noticia_id
             left join jornal.v$secao s 
                    on s.secao_id = ns.secao_id
             left join jornal.v$fonte f 
                    on f.fonte_id = n.fonte_id
			 left join jornal.v$foto fo
			        on fo.foto_id = n.foto_id
           where 1=1 ';
		  	if(strlen(trim($arguments['noticia_id'])))
         		$query .= ' and n.noticia_id = '.$arguments['noticia_id'].' ';
		  	if(strlen(trim($arguments['secao_id'])))
         		$query .= ' and ns.secao_id = '.$arguments['secao_id'].' ';
			else if($arguments['todas'] == 0 && !strlen(trim($arguments['noticia_id'])))
            	;//$query .= ' and ns.secao_id <> 1 ';
			if(strlen(trim($arguments['data_inicial']))) 
             	$query .= ' and trunc(n.data_publicacao) >= \''.$arguments['data_inicial'].'\' ';
           	else if($arguments['todas'] == 0 and !strlen(trim($arguments['noticia_id'])))
             	;//$query .= ' and n.data_publicacao <= sysdate ';
           	if(strlen(trim($arguments['data_final'])))
	            $query .= ' and trunc(n.data_publicacao) <= \''.$arguments['data_final'].'\' ';
           	if(strlen(trim($arguments['autor'])))
             	$query .= ' and upper(n.autor) like upper(trim(\'%'.$arguments['autor'].'%\')) ';
           	if(strlen(trim($arguments['filtro'])))
				$query .= ' and contains(n.texto_consulta,kss.pkg_string.fnc_string_clean(upper(trim(\'%'.$arguments['filtro'].'%\'))),1) > 0 ';
		  	if(strlen(trim($arguments['plantao'])))
         		$query .= ' and n.plantao = 1';
           	if($arguments['com_fotos'] == 1) 
            	$query .= ' and exists(select \'x\'
										 from jornal.v$noticia_foto nf
										where nf.noticia_id = n.noticia_id) ';			
			$query .= " and upper(n.cod_portal) = upper('".$arguments["cod_portal"]."')";
           	$query .= ' order by n.data_publicacao desc
                    ) 
                   where 1=1 ';
            if(strlen(trim($arguments['num_noticias'])))
            	$query .= ' and rownum <= '.$arguments['num_noticias'].' ';
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
			return $this->getResult($query);				
		}
		
		function get_secao($arguments=array()) {
			$query = 
			'select s.secao_id,
				   s.descricao,
				   s.formato_id,
				   s.ativa,
			       s.secao_pai_id,
				   s.newsletter,
				   to_char(s.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   s.user_insert,
				   to_char(s.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   s.user_update,
				   s.site,
				   s.url_cabecalho,
				   f.url_corpo formato,
				   f.descricao formato_descricao
			  from jornal.v$secao s
			  left join jornal.v$formato f
			         on f.formato_id = s.formato_id
			 where 1=1 ';
			if(strlen(trim($arguments['secao_id'])))
				$query .= ' and s.secao_id = '.$arguments['secao_id'].' ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and s.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if(strlen(trim($arguments['newsletter'])))
				$query .= ' and s.newsletter = '.$arguments['newsletter'].'
			   				and s.secao_id not in (45,46) /* Para o newsletter os suplementos so tratados de forma diferente*/ ';
			if(strlen(trim($arguments['ativa'])))
               	$query .= ' and s.ativa in ('.$arguments['ativa'].') ';
			$query .= ' order by s.descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				

			return $this->getResult($query);				
		}
		
		function get_noticia_video($arguments=array()){
			$query = 
			'select fv.noticia_id,
				   fv.video_id,
				   v.cod_video,
				   v.duracao,
				   fv.ordem,
				   fv.titulo,
				   fv.legenda,
				   fv.descricao,
				   fv.credito,
				   to_char(fv.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   fv.user_insert,
				   to_char(fv.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   fv.user_update,
				   fv.site
			  from jornal.v$noticia_video fv
			 inner join site.v$video v
			         on v.video_id = fv.video_id
			 where 1=1 ';
			 if(strlen($arguments['noticia_id']))
			 	$query .= ' and fv.noticia_id in ('.$arguments["noticia_id"].') ';
		  return $this->getResult($query);
		}
		
		function get_foto_categoria_tree($arguments=array()){
			$query = 'select categoria_id,
					   categoria_pai_id,
					   descricao,
					   lpad(\'&nbsp;\',(level-1)*12,\'&nbsp;\') as identacao,
					   level 
					from jornal.v$foto_categoria t where 1=1 ';
		    
			$query .= " and upper(t.cod_portal) = upper('".str_replace('/','',$_SESSION["site"])."')";
					
		    $query .="   start with categoria_pai_id is null
				  connect by prior categoria_id = categoria_pai_id
				 order siblings by descricao ";
			
			return $this->getResult($query);
		}
		
		
		function get_formato($arguments=array()){
			$query = 'select formato_id,
					   categoria_id,
					   descricao,
					   url_preview,
					   url_corpo,
					   nro_fotos,
					   limite_fotos,
					   date_insert,
					   user_insert,
					   date_update,
					   user_update,
					   site
				  from jornal.v$formato	';
			 $query .= " where 1=1 ";
			 $query .= " and categoria_id = ".$arguments["categoria_id"];
			 $query .="	 order by descricao";
			
			return $this->getResult($query);
		
		}
		
		


		/* Busca as fontes */
		function get_fonte($arguments=array(),$resulttype='array') {
			$query = '
				select f.fonte_id,
						f.nome,
						f.link,
						to_char(f.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as data_insercao
				   from jornal.v$fonte f
				  where 1=1 
			 ';
			 if(strlen(trim($arguments['fonte_id'])))
             	$query .= ' and f.fonte_id = '.$arguments['fonte_id'].' ';
             if(strlen(trim($arguments['data_inicial']))) 
                $query .= ' and trunc(f.date_insert) >= \''.$arguments['data_inicial'].'\' ';
             if(strlen(trim($arguments['data_final'])))
               	$query .= ' and trunc(f.date_insert) <= \''.$arguments['data_final'].'\' ';
			 if(strlen(trim($arguments['nome'])))
			    $query .= ' and upper(f.nome) like upper(\'%' .$arguments['nome'].'%\')';
             
			 	$query .= " and f.cod_portal = '".$_SESSION["cod_portal"]."'";
			 
			 $query .= ' order by f.nome ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}

		/* Busca as noticias de uma secao */
		function get_noticia_secao($arguments=array(),$resulttype='array') {
			$query = '
			select * 
			  from (select n.noticia_id,
						   to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
						   n.titulo,
						   n.plantao,
						   n.cod_portal,
						   ns.ordem,
						   (select count(*)
							  from jornal.v$noticia_foto nf
							 where nf.noticia_id = n.noticia_id) nro_fotos
					  from jornal.v$noticia n
					 inner join jornal.v$noticia_secao ns
							 on ns.noticia_id = n.noticia_id
					 where 1=1
					 ';
					if(strlen(trim($arguments['secao_id'])))
						$query .= ' and ns.secao_id = '.$arguments['secao_id'];
					if(strlen(trim($arguments['edicao_id'])))
						$query .= ' and ns.edicao_id = '.$arguments['edicao_id'];
					if(strlen(trim($arguments['data_inicial'])))
						$query .= ' and trunc(n.data_publicacao) >= \''.$arguments['data_inicial'].'\'';
					if(strlen(trim($arguments['data_final'])))
						$query .= ' and trunc(n.data_publicacao) <= \''.$arguments['data_final'].'\'';
					if(strlen(trim($arguments['cod_portal'])))
						$query .= ' and n.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen(trim($arguments['filtro'])))
						$query .= ' and contains(n.texto_consulta,kss.pkg_string.fnc_string_clean(upper(trim(\''.$arguments['filtro'].'\'))),1) > 0 ';
						
					$query .= ' order by ns.ordem desc )
			  where 1=1 ';
					
					
			if(strlen(trim($arguments['com_foto'])))
				$query .= ' and nro_fotos > 0';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}		

		
		
		/* Busca as noticias para exibio */
		function get_noticia_exibicao($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			if(!strlen(trim($arguments['offset'])))
				$arguments['offset'] = 0;
			$query = '
				select * from (
				
				select ';
				if(strlen(trim($arguments['noticia_id_relacao'])))
					$query .= ' /*+ leading(n) */ ';
				
				$query .= '
						n.noticia_id,
					   to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(n.data_publicacao, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
					   to_char(n.data_publicacao,\'hh24:mi\') as hora_publicacao,
					   n.titulo,
					   n.subtitulo, ';
				if($arguments['sem_texto'] != 1)
					$query .= ' n.texto, ';
				$query .= ' s.descricao as secao,
					   n.autor,
					   to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   n.user_insert,
					   to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   n.user_update,
					   n.site,
					   n.categoria,
					   n.plantao,
					  /* n.texto_consulta, */
					   n.fonte_id,
					   n.cod_portal,
					   n.tags,
					   n.fotos,
					   n.foto_id,
					   ns.ordem,
					   e.data_exibicao, 
					   n.acessos,
					   fo.nome,
					   f.credito,
					   f.url_imagem,	';				 

			if(strlen(trim($arguments['plantao'])))
				$query .= '  row_number() over (order by n.data_publicacao desc) linha 
				';
			else
				$query .= '  row_number() over (order by e.data_exibicao desc, ns.ordem desc) linha 
				';			

			$query .= ' from jornal.v$noticia n
				 inner join jornal.v$noticia_secao ns
						 on ns.noticia_id = n.noticia_id
				 inner join jornal.v$secao s
				         on s.secao_id = ns.secao_id 
				 inner join jornal.v$edicao e
				         on e.edicao_id = ns.edicao_id
			      left join site.v$foto f
				         on f.foto_id = n.foto_id
				  left join jornal.v$fonte fo
				  		 on fo.fonte_id = n.fonte_id
						 
				 where 1=1 ';
				 if(strlen(trim($arguments['forca_secao_id'])))
				 	$query .= ' and secao_id = '.$arguments['secao_id'];

			$query .= ' and n.noticia_id in (select noticia_id
				                          from (select n.noticia_id,
										';
										if(strlen(trim($arguments['plantao'])))
											$query .= '  rank() over (order by n.data_publicacao desc) rank 
											';
										else
											$query .= '  rank() over (order by e.data_exibicao desc, ns.ordem desc) rank 
											';	
										$query .= '
											      from jornal.v$noticia n
												 inner join jornal.v$noticia_secao ns
														 on ns.noticia_id = n.noticia_id
												 inner join jornal.v$secao s
														 on s.secao_id = ns.secao_id
												 inner join jornal.v$edicao e				 
														 on e.edicao_id = ns.edicao_id
												 where e.concluida = 1 ';
											if(strlen(trim($arguments['cod_portal'])))
												$query .= ' and ns.cod_portal = \''.$arguments['cod_portal'].'\'';
											if(strlen(trim($arguments['grupo_portais'])))
												$query .= ' and ns.cod_portal in ('.str_replace("\'","'",$arguments['grupo_portais']).')';
											if(strlen(trim($arguments['data'])))
												$query .= ' and e.data_exibicao <= \''.$arguments['data'].'\'
															and n.data_publicacao <= \''.$arguments['data'].'\'';
											if(strlen(trim($arguments['secao_id'])))	   
												$query .= ' and ns.secao_id = '.$arguments['secao_id'];		
											if(strlen(trim($arguments['noticia_id'])))	   
												$query .= ' and n.noticia_id = '.$arguments['noticia_id'];		
											if(strlen(trim($arguments['plantao'])))
												$query .= ' and n.plantao = '.$arguments['plantao'];
											if(strlen(trim($arguments['data_inicial'])))
												$query .= ' and n.data_publicacao >= \''.$arguments['data_inicial'].'\'';
											if(strlen(trim($arguments['data_final'])))
												$query .= ' and n.data_publicacao <= \''.$arguments['data_final'].'\'';
											if(strlen(trim($arguments['autor'])))
												$query .= ' and upper(n.autor) like upper(trim(\'%'.$arguments['autor'].'%\'))';
											if(strlen(trim($arguments['secao_id_noticia'])))
												$query .= ' and ns.secao_id in (select secao_id
																				  from jornal.v$noticia_secao ns1
																				 where ns1.noticia_id = '.$arguments['secao_id_noticia'].') 
															and n.noticia_id <> '.$arguments['secao_id_noticia'];
											if(strlen(trim($arguments['filtro']))){
												if($arguments['somente_titulo'])
													$query .= ' and contains(n.titulo,\'\'||upper(trim(\''.$arguments['filtro'].'\'))||\'\',1) > 0 ';
												else
													$query .= ' and contains(n.texto_consulta,\'\'||kss.pkg_string.fnc_string_clean(upper(trim(\''.$arguments['filtro'].'\')))||\'\',1) > 0 ';
											}
											if(strlen(trim($arguments['relacao_noticias_id']))){
												$query .= ' and n.noticia_id in ('.$arguments['relacao_noticias_id'].')';
											}
											if(strlen(trim($arguments['noticia_id_relacao'])))
												$query .= ' and contains(tags,\'about(\'||(select nvl(tags,\'asojdaosid\')
																							   from jornal.v$noticia n1
																							  where n1.noticia_id = '.$arguments['noticia_id_relacao'].')||\')\',1) > 0 
															and n.noticia_id <> '.$arguments['noticia_id_relacao'];
											if($arguments['com_fotos'] == "1")
												$query .= ' and n.fotos > 0 ';
											if($arguments['ordenar'] == 'VIEWS')
												$query .= ' order by e.data_exibicao desc, n.acessos desc ';
											elseif(strlen(trim($arguments['plantao'])))
												$query .= ' order by n.data_publicacao desc ';
											else
												$query .= ' order by e.data_exibicao desc, ns.ordem desc ';	
											$query .= ' ) where 1=1 ';
										if(strlen(trim($arguments['offset'])))
											$query .= ' and rank >= '.$arguments['offset'];
										if(strlen(trim($arguments['nro_noticias'])))
											$query .= ' and rank <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);
									$query .= ') ' ;		
			
			$query .= ' ) 
			  where 1=1 ';
			  
			//$query .= ' order by data_publicacao desc, ordem desc';
			//new dBug($arguments);
			/*if(strlen(trim($arguments['offset'])))
				$query .= ' and linha >= '.$arguments['offset'];
			if(strlen(trim($arguments['nro_noticias'])))
				$query .= ' and linha <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);*/
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as noticias para exibio */
		function get_noticia_exibicao_old($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			if(!strlen(trim($arguments['offset'])))
				$arguments['offset'] = 0;
			$query = '
				select * from (
				
				select ';
				if(strlen(trim($arguments['noticia_id_relacao'])))
					$query .= ' /*+ leading(n) */ ';
				
				$query .= '
						n.noticia_id,
					   to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(n.data_publicacao, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
					   to_char(n.data_publicacao,\'hh24:mi\') as hora_publicacao,
					   n.titulo,
					   n.subtitulo, ';
				if($arguments['sem_texto'] != 1)
					$query .= ' n.texto, ';
				$query .= ' s.descricao as secao,
					   n.autor,
					   to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   n.user_insert,
					   to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   n.user_update,
					   n.site,
					   n.categoria,
					   n.plantao,
					  /* n.texto_consulta, */
					   n.fonte_id,
					   n.cod_portal,
					   n.tags,
					   n.fotos,
					   n.foto_id,
					   e.data_exibicao, 
					   n.acessos,
					   fo.nome,
					   f.credito,
					   f.url_imagem,	';				 

			if(strlen(trim($arguments['plantao'])))
				$query .= '  row_number() over (order by n.data_publicacao desc) linha 
				';
			else
				$query .= '  row_number() over (order by e.data_exibicao desc, ns.ordem desc) linha 
				';			

			$query .= ' from jornal.v$noticia n
				 inner join jornal.v$noticia_secao ns
						 on ns.noticia_id = n.noticia_id
				 inner join jornal.v$secao s
				         on s.secao_id = ns.secao_id
				 inner join jornal.v$edicao e				 
						 on e.edicao_id = ns.edicao_id				 
			      left join site.v$foto f
				         on f.foto_id = n.foto_id
				  left join jornal.v$fonte fo
				  		 on fo.fonte_id = n.fonte_id
						 
				 where 1=1 
				   and e.concluida = 1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ns.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['data'])))
				$query .= ' and e.data_exibicao <= \''.$arguments['data'].'\'
				            and n.data_publicacao <= \''.$arguments['data'].'\'';
			if(strlen(trim($arguments['secao_id'])))	   
				$query .= ' and ns.secao_id = '.$arguments['secao_id'];		
			if(strlen(trim($arguments['noticia_id'])))	   
				$query .= ' and n.noticia_id = '.$arguments['noticia_id'];		
			if(strlen(trim($arguments['plantao'])))
				$query .= ' and n.plantao = '.$arguments['plantao'];
			if(strlen(trim($arguments['data_inicial'])))
				$query .= ' and n.data_publicacao >= \''.$arguments['data_inicial'].'\'';
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and n.data_publicacao <= \''.$arguments['data_final'].'\'';
			if(strlen(trim($arguments['autor'])))
             	$query .= ' and upper(n.autor) like upper(trim(\'%'.$arguments['autor'].'%\'))';
			if(strlen(trim($arguments['secao_id_noticia'])))
             	$query .= ' and ns.secao_id in (select secao_id
				                                  from jornal.v$noticia_secao ns1
												 where ns1.noticia_id = '.$arguments['secao_id_noticia'].') 
							and n.noticia_id <> '.$arguments['secao_id_noticia'];
           	if(strlen(trim($arguments['filtro'])))
				$query .= ' and contains(n.texto_consulta,\'\'||kss.pkg_string.fnc_string_clean(upper(trim(\''.$arguments['filtro'].'\')))||\'\',1) > 0 ';
			if(strlen(trim($arguments['noticia_id_relacao'])))
				$query .= ' and contains(tags,\'about(\'||(select nvl(tags,\'asojdaosid\')
															   from jornal.v$noticia n1
															  where n1.noticia_id = '.$arguments['noticia_id_relacao'].')||\')\',1) > 0 
						    and n.noticia_id <> '.$arguments['noticia_id_relacao'];
			if($arguments['com_fotos'] == "1")
				$query .= ' and n.fotos > 0 ';
			if($arguments['ordenar'] == 'VIEWS')
				$query .= ' order by e.data_exibicao desc, n.acessos desc ';
			elseif(strlen(trim($arguments['plantao'])))
				$query .= ' order by n.data_publicacao desc ';
			else
				$query .= ' order by e.data_exibicao desc, ns.ordem desc ';			
			
			$query .= ' ) 
			  where 1=1 ';
			//new dBug($arguments);
			if(strlen(trim($arguments['offset'])))
				$query .= ' and linha >= '.$arguments['offset'];
			if(strlen(trim($arguments['nro_noticias'])))
				$query .= ' and linha <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as noticias do plantao */
		function get_noticia_plantao($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			if(!strlen(trim($arguments['offset'])))
				$arguments['offset'] = 0;
			$query = '
				select * from (
				
				select ';
				if(strlen(trim($arguments['noticia_id_relacao'])))
					$query .= ' /*+ leading(n) */ ';
				
				$query .= '
						n.noticia_id,
					   to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(n.data_publicacao, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
					   to_char(n.data_publicacao,\'hh24:mi\') as hora_publicacao,
					   n.titulo,
					   n.subtitulo, ';
				if($arguments['sem_texto'] != 1)
					$query .= ' n.texto, ';
				$query .= ' s.descricao as secao,
					   n.autor,
					   to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   n.user_insert,
					   to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   n.user_update,
					   n.site,
					   n.categoria,
					   n.plantao,
					  /* n.texto_consulta, */
					   n.fonte_id,
					   n.cod_portal,
					   n.tags,
					   n.fotos,
					   n.foto_id,
					   n.acessos,
					   fo.nome,
					   f.credito,
					   f.url_imagem,	';				 

			if(strlen(trim($arguments['plantao'])))
				$query .= '  row_number() over (order by n.data_publicacao desc) linha ';
			else
				$query .= '  row_number() over (order by e.data_exibicao desc, ns.ordem desc) linha ';			

			$query .= ' from jornal.v$noticia n
				 inner join jornal.v$noticia_secao ns
						 on ns.noticia_id = n.noticia_id
				 inner join jornal.v$secao s
				         on s.secao_id = ns.secao_id
			      left join site.v$foto f
				         on f.foto_id = n.foto_id
				  left join jornal.v$fonte fo
				  		 on fo.fonte_id = n.fonte_id
						 
				 where 1=1 /*
				   and e.concluida = 1 */ ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ns.cod_portal = \''.$arguments['cod_portal'].'\'';
			/*if(strlen(trim($arguments['data'])))
				$query .= ' and e.data_exibicao <= \''.$arguments['data'].'\'
				            and n.data_publicacao <= \''.$arguments['data'].'\'';*/
			if(strlen(trim($arguments['secao_id'])))	   
				$query .= ' and ns.secao_id = '.$arguments['secao_id'];		
			if(strlen(trim($arguments['noticia_id'])))	   
				$query .= ' and n.noticia_id = '.$arguments['noticia_id'];		
			if(strlen(trim($arguments['plantao'])))
				$query .= ' and n.plantao = '.$arguments['plantao'];
			if(strlen(trim($arguments['data_inicial'])))
				$query .= ' and n.data_publicacao >= \''.$arguments['data_inicial'].'\'';
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and n.data_publicacao <= \''.$arguments['data_final'].'\'';
			if(strlen(trim($arguments['autor'])))
             	$query .= ' and upper(n.autor) like upper(trim(\'%'.$arguments['autor'].'%\'))';
			if(strlen(trim($arguments['secao_id_noticia'])))
             	$query .= ' and ns.secao_id in (select secao_id
				                                  from jornal.v$noticia_secao ns1
												 where ns1.noticia_id = '.$arguments['secao_id_noticia'].') 
							and n.noticia_id <> '.$arguments['secao_id_noticia'];
           	if(strlen(trim($arguments['filtro'])))
				$query .= ' and contains(n.texto_consulta,\'%\'||kss.pkg_string.fnc_string_clean(upper(trim(\''.$arguments['filtro'].'\')))||\'%\',1) > 0 ';
			if(strlen(trim($arguments['noticia_id_relacao'])))
				$query .= ' and contains(tags,\'about(\'||(select nvl(tags,\'asojdaosid\')
															   from jornal.v$noticia n1
															  where n1.noticia_id = '.$arguments['noticia_id_relacao'].')||\')\',1) > 0 
						    and n.noticia_id <> '.$arguments['noticia_id_relacao'];
			if($arguments['com_fotos'] == "1")
				$query .= ' and n.fotos > 0 ';
				
				$query .= ' and n.noticia_id in (select a.noticia_id 
									from (select n2.noticia_id,
												 rank() over(order by data_publicacao) ra
											from jornal.v$noticia n2
										   inner join jornal.v$noticia_secao ns2
												   on ns2.noticia_id = n2.noticia_id
										   inner join jornal.v$edicao e2         
												   on e2.edicao_id = ns2.edicao_id         
										   where 1=1 
										     and e2.concluida = 1 ';
				if(strlen(trim($arguments['cod_portal'])))
					$query .= ' and n2.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['data'])))
					$query .= ' and e2.data_exibicao <= \''.$arguments['data'].'\'
								and n2.data_publicacao <= \''.$arguments['data'].'\'';
				if(strlen(trim($arguments['secao_id'])))	   
					$query .= ' and ns2.secao_id = '.$arguments['secao_id'];		
				if(strlen(trim($arguments['noticia_id'])))	   
					$query .= ' and n2.noticia_id = '.$arguments['noticia_id'];		
				if(strlen(trim($arguments['plantao'])))
					$query .= ' and n2.plantao = '.$arguments['plantao'];
				if(strlen(trim($arguments['data_inicial'])))
					$query .= ' and n2.data_publicacao >= \''.$arguments['data_inicial'].'\'';
				if(strlen(trim($arguments['data_final'])))
					$query .= ' and n2.data_publicacao <= \''.$arguments['data_final'].'\'';									   
				$query .= '					 )a 
								   where 1=1 ';
								   
				if(strlen(trim($arguments['offset'])))
					$query .= ' and a.ra >= '.$arguments['offset'];
				if(strlen(trim($arguments['nro_noticias'])))
					$query .= ' and a.ra <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);							   
				$query .= ' ) ';				   
				
			if($arguments['ordenar'] == 'VIEWS')
				$query .= ' order by e.data_exibicao desc, n.acessos desc ';
			elseif(strlen(trim($arguments['plantao'])))
				$query .= ' order by n.data_publicacao desc ';
			else
				$query .= ' order by e.data_exibicao desc, ns.ordem desc ';			
			
			$query .= ' ) 
			  where 1=1 ';
			//new dBug($arguments);
/*			if(strlen(trim($arguments['offset'])))
				$query .= ' and linha >= '.$arguments['offset'];
			if(strlen(trim($arguments['nro_noticias'])))
				$query .= ' and linha <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);*/
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca o texto da noticia */
		function get_noticia_texto($arguments=array(),$resulttype='array') {
			$query = '
				select n.noticia_id, ';
			if(strlen(trim($arguments['tamanho'])))
				$query .= ' substr(n.texto,0,'.$arguments['tamanho'].') as texto, ';
			else
				$query .= ' n.texto, ';
			$query .= ' 0
				  from jornal.v$noticia n
				 where 1=1
				 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and n.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['noticia_id'])))
				$query .= ' and n.noticia_id = '.$arguments['noticia_id'].'';
			$query .= ' order by n.noticia_id ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		
			//print($query);
		
		    return $this->getResult($query,$resulttype);
		}
		
		function get_soma_noticias_portal($arguments=array(),$resulttype='array'){
			$query .= 'select count(noticia_id) as total
			  			from jornal.v$noticia n
					where 1=1 and cod_portal=\''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['noticia_id'])))
				$query .= ' and n.noticia_id = '.$arguments['noticia_id'];
		
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_noticia_galeria($arguments=array(),$resulttype='array') {
			if(!strlen(trim($arguments['offset'])))
				$arguments['offset'] = 0;
			$query = '
				select * from (
				
				select n.noticia_id,
					   to_char(n.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(n.data_publicacao, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
					   to_char(n.data_publicacao,\'hh24:mi\') as hora_publicacao,
					   n.titulo,
					   n.subtitulo,
					   n.texto,
					   s.descricao as secao,
					   n.autor,
					   to_char(n.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   n.user_insert,
					   to_char(n.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   n.user_update,
					   n.site,
					   n.categoria,
					   n.plantao,
					  /* n.texto_consulta, */
					   n.fonte_id,
					   n.cod_portal,
					   n.tags,
					   n.fotos,
					   n.foto_id,
					   f.url_imagem,
					   nf.ordem,
					   row_number() over (order by e.data_exibicao desc, ns.ordem desc) linha
				  from jornal.v$noticia n
				 inner join jornal.v$noticia_secao ns
						 on ns.noticia_id = n.noticia_id
				 inner join jornal.v$secao s
				         on s.secao_id = ns.secao_id
				 inner join jornal.v$edicao e
						 on e.edicao_id = ns.edicao_id		
				 inner join jornal.v$noticia_foto nf
				 		 on nf.noticia_id = n.noticia_id		
			      left join site.v$foto f
				         on f.foto_id = n.foto_id
						 
				 where 1=1 
				   and e.concluida = 1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ns.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['data'])))
				$query .= ' and e.data_exibicao <= \''.$arguments['data'].'\'
				            and n.data_publicacao <= \''.$arguments['data'].'\'';
			if(strlen(trim($arguments['secao_id'])))	   
				$query .= ' and ns.secao_id = '.$arguments['secao_id'];		
			if(strlen(trim($arguments['data_inicial'])))
				$query .= ' and trunc(n.data_publicacao) >= \''.$arguments['data_inicial'].'\'';			
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and trunc(n.data_publicacao) <= \''.$arguments['data_final'].'\'';			
			if(strlen(trim($arguments['secao_id_noticia'])))
             	$query .= ' and ns.secao_id in (select secao_id
				                                  from jornal.v$noticia_secao ns1
												 where ns1.noticia_id = '.$arguments['secao_id_noticia'].') 
							and n.noticia_id <> '.$arguments['secao_id_noticia'];
           	if(strlen(trim($arguments['filtro'])))
				$query .= ' and contains(n.texto_consulta,\'%\'||kss.pkg_string.fnc_string_clean(upper(trim(\''.$arguments['filtro'].'\')))||\'%\',1) > 0 ';
			if(strlen(trim($arguments['noticia_id_relacao'])))
				$query .= ' and contains(tags,\'about(\'||(select nvl(tags,\'asojdaosid\')
															   from jornal.v$noticia n1
															  where n1.noticia_id = '.$arguments['noticia_id_relacao'].')||\')\',1) > 0 
						    and n.noticia_id <> '.$arguments['noticia_id_relacao'];
			if($arguments['com_fotos'] == "1")
				$query .= ' and exists (select 0
										  from jornal.v$noticia_foto nf
										 where noticia_id = n.noticia_id) ';
										 
			if(isset($arguments['ordem'])){
				switch($arguments['ordem']){
					case 'ORDEM' : $query .= ' order by nf.ordem';break;
					case 'CADASTRO' : $query .= ' order by date_insert desc'; break;
					case 'PUBLICACAO' : $query .= ' order by n.data_publicacao desc';break;
					default: $query .= ' order by dbms_random.value'; break;
				}
			}
			
			$query .= ' )
			  where 1=1 ';
			if(strlen(trim($arguments['offset'])))
				$query .= ' and linha >= '.$arguments['offset'];
			if(strlen(trim($arguments['nro_noticias'])))
				$query .= ' and linha <= '.(($arguments['offset']-1)+$arguments['nro_noticias']);
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as edies */
		function get_edicao($arguments=array(),$resulttype='array') {
			$query = '
				select e.edicao_id,
					   e.cod_edicao,
					   to_char(e.data_exibicao,\'dd/mm/yyyy hh24:mi:ss\') as data_exibicao,
					   e.concluida,
					   e.travada,
					   e.tipo_id,
					   et.descricao tipo,
					   to_char(e.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   e.user_insert,
					   to_char(e.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   e.user_update,
					   e.site,
					   e.url_capa,
					   e.cod_portal,
					   case when jornal.pkg_noticia.fnc_edicao_atual(e.cod_portal) = e.edicao_id then 1 else 0 end em_exibicao
				  from jornal.v$edicao e
				 inner join jornal.v$edicao_tipo et
						 on et.tipo_id = e.tipo_id
				 where 1=1
				 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and e.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['edicao_id'])))
				$query .= ' and e.edicao_id = '.$arguments['edicao_id'].'';
			$query .= ' order by e.data_exibicao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		
			//print($query);
		
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os tipos de edio */
		function get_edicao_tipo($arguments=array(),$resulttype='array') {
			$query = '
				select t.tipo_id,
					   t.descricao,
					   t.date_insert,
					   t.user_insert,
					   t.date_update,
					   t.user_update,
					   t.site
				  from jornal.v$edicao_tipo t
				 where 1=1
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as edies impressas */
		function get_edicao_impressa($arguments=array(),$resulttype='array') {
			$query = '
			select * from (
				select ei.edicao_impressa_id,
					   ei.cod_portal,
					   to_char(ei.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   ei.ano,
					   ei.cod_edicao,
					   ei.valor,
					   (select count(*)
					      from jornal.v$edicao_impressa_pagina ep
						 where ep.edicao_impressa_id = ei.edicao_impressa_id) as nro_paginas,
					   to_char(ei.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   ei.user_insert,
					   to_char(ei.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   ei.user_update,
					   ei.site,
					   row_number() over (order by ei.data_publicacao desc) linha
				  from jornal.v$edicao_impressa ei
				 where 1=1
			 ';
			if(strlen(trim($arguments['edicao_impressa_id'])))
				$query .= ' and ei.edicao_impressa_id = '.$arguments['edicao_impressa_id'].'';
			if(strlen(trim($arguments['cod_edicao'])))
				$query .= ' and ei.cod_edicao = \''.$arguments['cod_edicao'].'\'';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ei.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['data_inicial'])))
				$query .= ' and ei.data_publicacao >= \''.$arguments['data_inicial'].'\'';
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and ei.data_publicacao <= \''.$arguments['data_final'].'\'';
			$query .= ' order by ei.data_publicacao desc )
				where 1=1 ';
			if(strlen(trim($arguments['nro_edicoes'])))
				$query .= ' and linha <= '.$arguments['nro_edicoes'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as edies impressas */
		function get_impresso($arguments=array(),$resulttype='array') {
			$query = '
			select * from (
				select ei.impresso_id,
					   ei.cod_portal,
					   to_char(ei.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   ei.ano,
					   ei.cod_edicao,
					   ei.valor,
					   (select count(*)
					      from jornal.v$edicao_impressa_pagina ep
						 where ep.edicao_impressa_id = ei.impresso_id) as nro_paginas,
					   to_char(ei.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   ei.user_insert,
					   to_char(ei.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   ei.user_update,
					   ei.site,
					   row_number() over (order by ei.data_publicacao desc) linha
				  from jornal.v$impresso ei
				 where 1=1
			 ';
			if(strlen(trim($arguments['edicao_impressa_id'])))
				$query .= ' and ei.edicao_impressa_id = '.$arguments['edicao_impressa_id'].'';
			if(strlen(trim($arguments['cod_edicao'])))
				$query .= ' and ei.cod_edicao = \''.$arguments['cod_edicao'].'\'';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ei.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['data_inicial'])))
				$query .= ' and ei.data_publicacao >= \''.$arguments['data_inicial'].'\'';
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and ei.data_publicacao <= \''.$arguments['data_final'].'\'';
			$query .= ' order by ei.data_publicacao desc )
				where 1=1 ';
			if(strlen(trim($arguments['nro_edicoes'])))
				$query .= ' and linha <= '.$arguments['nro_edicoes'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os cadernos de uma edio impressa */
		function get_edicao_impressa_caderno($arguments=array(),$resulttype='array') {
			$query = '
				select ec.caderno_id,
					   ec.edicao_impressa_id,
					   ec.letra,
					   ec.descricao,
					   ec.total_paginas,
					   to_char(ec.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   ec.user_insert,
					   to_char(ec.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   ec.user_update,
					   ec.site
				  from jornal.v$edicao_impressa_caderno ec
				 where 1=1
			 ';
			if(strlen(trim($arguments['edicao_impressa_id'])))
				$query .= ' and ec.edicao_impressa_id = '.$arguments['edicao_impressa_id'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		   
			return $this->getResult($query,$resulttype);
		}
	
		/* Busca as paginas da edio  */
		function get_edicao_impressa_pagina($arguments=array(),$resulttype='array') {
			$query = '
				select p.pagina_id,
					   p.impresso_id,
					   p.url_imagem,
					   p.url_pdf,
					   to_char(p.date_insert, \'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   p.user_insert,
					   to_char(p.date_update, \'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   p.user_update,
					   p.site,
					   p.caderno_id,
					   c.descricao as caderno
				  from jornal.v$impresso_pagina p
				 inner join jornal.v$impresso_caderno c on c.caderno_id = p.caderno_id
				 where 1=1
			 ';
			if(strlen(trim($arguments['edicao_impressa_id'])))
				$query .= ' and p.impresso_id = '.$arguments['edicao_impressa_id'];
			if(strlen(trim($arguments['pagina_id'])))
				$query .= ' and p.pagina_id = '.$arguments['pagina_id'];


			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		  	//print($query."<br>");			
			return $this->getResult($query,$resulttype);
		}

		/* Busca pginas de um caderno da edio impressa */
		function get_edicao_impressa_pagina_xml($arguments=array(),$resulttype='array') {
			
			$query = '
				select i.impresso_id, 
					   i.data_publicacao,
					   i.cod_edicao||\' - \'|| to_char(data_publicacao,\'mm/yy\') as titulo_edicao,
					   ip.pagina_id, 
					   i.nome,
					   i.data_limite,
					   i.descricao,
					   ip.caderno_id, 
					   ip.num_pagina,
				 	   ip.url_imagem, 
					   ip.imagem_id,
					   ai.md5 as md5_imagem,
					   ip.url_pdf, 
					   ip.pdf_id,
					   ap.md5 as md5_pdf,
					   ip.largura, 
					   ip.altura,
					   ic.descricao as titulo_caderno
				  from jornal.v$impresso i
				 inner join jornal.v$impresso_pagina ip
						 on ip.impresso_id = i.impresso_id
			     inner join site.v$arquivo ai
				         on ai.arquivo_id = ip.imagem_id
				  left join site.v$arquivo ap
				         on ap.arquivo_id = ip.pdf_id
				 inner join jornal.v$impresso_caderno ic on ic.caderno_id = ip.caderno_id
				 where 1=1
			 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';

			if(!strlen(trim($arguments['data_publicacao'])) && !strlen(trim($arguments['impresso_id']))) {
				if(!strlen(trim($arguments['data']))){
				$query .= ' and i.data_publicacao = (select max(i2.data_publicacao) 
				                                       from jornal.v$impresso i2
													   where i2.data_publicacao <= sysdate
													     and i2.cod_portal = \''.$arguments['cod_portal'].'\')';
				}else
					$query .= ' and trunc(i.data_publicacao) <= sysdate' ;
			}

			if(strlen(trim($arguments['impresso_id']))) {
				$query .= ' and i.impresso_id = '.$arguments['impresso_id'];
				if(!strlen(trim($arguments['caderno_id'])) && !strlen(trim($arguments['no_caderno_id'])))
					$query .= ' and ip.caderno_id = (select min(caderno_id) keep(dense_rank first order by ordem)
					                                   from jornal.v$impresso_caderno ic
													  where ic.cod_portal = \''.$arguments['cod_portal'].'\')';
			}
			if(strlen(trim($arguments['not_impresso_id'])))
				$query = ' and i.impresso_id not in ('.$arguments['not_impresso_id'].') ';
			if(strlen(trim($arguments['num_pagina'])))
				$query .= ' and ip.num_pagina = '.$arguments['num_pagina'];
			if(strlen(trim($arguments['caderno_id'])))
				$query .= ' and ip.caderno_id = '.$arguments['caderno_id'];
			if(strlen(trim($arguments['data_publicacao']))){
				$query .= ' and trunc(i.data_publicacao) = \''.$arguments['data_publicacao'].'\'' ;				
				if(!strlen(trim($arguments['caderno_id'])))
					$query .= ' and ip.caderno_id = (select min(caderno_id) keep(dense_rank first order by ordem)
					                                   from jornal.v$impresso_caderno ic
													  where ic.cod_portal = \''.$arguments['cod_portal'].'\') ';
			}
			if(strlen(trim($arguments['primeira_pagina']))){
				$query .= '  and num_pagina = (select min(num_pagina)
                                                 from jornal.v$impresso_pagina ip2
                                           where ip2.impresso_id = ip.impresso_id) ';
			}
			
							
			$query .= ' order by i.data_publicacao desc,ip.num_pagina ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}		
		
		/* Busca cadernos de um edio impressa */
		function get_edicao_impressa_cadernos_xml($arguments=array(),$resulttype='array') {
			$query = '
				select distinct ic.caderno_id, ic.descricao, ic.ordem, i.impresso_id
				  from jornal.v$impresso i
				 inner join jornal.v$impresso_pagina ip
						 on ip.impresso_id = i.impresso_id
				 inner join jornal.v$impresso_caderno ic
				         on ic.caderno_id = ip.caderno_id
				 where 1=1
			 ';
			 if(strlen(trim($arguments['cod_portal'])))
			 	$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';
			 
			 if(!strlen(trim($arguments['data_publicacao'])) && !strlen(trim($arguments['impresso_id']))) {
				$query .= ' and i.data_publicacao = (select max(i2.data_publicacao) 
				                                       from jornal.v$impresso i2
													   where i2.data_publicacao <= sysdate
													     and i2.cod_portal = \''.$arguments['cod_portal'].'\')' ;
			
			}
			if(strlen(trim($arguments['impresso_id'])))
				$query .= ' and i.impresso_id = '.$arguments['impresso_id'];
			if(strlen(trim($arguments['data_publicacao'])))
				$query .= ' and trunc(i.data_publicacao) = \''.$arguments['data_publicacao'].'\'' ;				

			$query .= ' order by ic.ordem ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}	
		
		/* Busca cadernos de um edio impressa */
		function get_impresso_caderno_xml($arguments=array(),$resulttype='array') {
			$query = '
				select ip.impresso_id,
					   ip.caderno_id,
					   ic.descricao as titulo_caderno,
					   ip.num_pagina
					
					from jornal.v$impresso_pagina ip
					inner join jornal.v$impresso_caderno ic on ic.caderno_id = ip.caderno_id
					where 1=1
			 			 and ic.cod_portal = \''.$arguments['cod_portal'].'\'';
			 
			if(strlen(trim($arguments['impresso_id'])))
				$query .= ' and ip.impresso_id = '.$arguments['impresso_id'];
			if(strlen(trim($arguments['primeira_pagina']))){
				$query .= ' and num_pagina = (select min(num_pagina)
											    from jornal.v$impresso_pagina ip1
											   where ip1.caderno_id = ic.caderno_id)';
			}
			
			$query .= ' order by ic.descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}	
		
		
		/*
		*
		* Busca as noticias sem utilizar o ndice
		*/
		function get_noticia_busca_sem_indice($arguments=array()) {
		
			$query = 'select n.noticia_id,
							 n.titulo,
							 to_char(n.data_publicacao,\'dd/mm/yyyy\') as data_publicacao,
							 s.descricao as secao
						from jornal.v$noticia n
					   inner join jornal.v$noticia_secao ns on ns.noticia_id = n.noticia_id
					   inner join jornal.v$edicao e on e.edicao_id = ns.edicao_id
					   inner join jornal.v$secao s on s.secao_id = ns.secao_id
					   where 1=1
					      and cod_portal = \''.$arguments['cod_portal'].'\'';
						  
		    if(strlen(trim($arguments['data_inicial'])) && strlen(trim($arguments['data_final'])))
				$query .= ' and e.data_exibicao between \''.$arguments['data_inicial'].'\' and \''.$arguments['data_final'].'\'';
			if(!strlen(trim($arguments['data_inicial'])) && strlen(trim($arguments['data_final'])))
				$query .= ' and e.data_exibicao <= \''.$arguments['data_final'].'\'';
			if(strlen(trim($arguments['data_inicial'])) && !strlen(trim($arguments['data_final'])))
				$query .= ' and e.data_exibicao >= \''.$arguments['data_inicial'].'\'';
			if(strlen(trim($arguments['autor'])))
				$query .= ' and upper(n.autor) like upper(\'%'.$arguments['autor'].'%\')';
			if(strlen(trim($arguments['not_secao'])))
				$query .= ' and ns.secao_id <> '.$arguments['not_secao'];
			if(strlen(trim($arguments['texto']))){
				$palavras = explode(" ",$arguments['texto']);
				
				$query .= ' and ( ';
				for($i=0; $i<count($palavras); $i++){
					if($i>0)
						$query .= ' and ';
						
					$query .= ' upper(n.titulo) like upper(\'%'.$palavras[$i].'%\') ';
				}
				
				if(!strlen(trim($arguments['somente_titulo']))){
					$query .= ' or ';
					
					for($i=0; $i<count($palavras); $i++){
						if($i>0)
							$query .= ' and ';
							
						$query .= ' upper(n.texto) like upper(\'%'.$palavras[$i].'%\') ';
					}
				}
				
				$query .= ' ) ';
			}
			$query .= ' order by n.data_publicacao desc' ;

			//print($query);
			return $this->getResult($query);
		}
		
		
		
		/*
		*
		* Busca as fotos do banco de imagens
		*/
		function get_foto($arguments=array()) {
		
			$query = 'select ft.foto_id,
						   ft.categoria_id,
						   ft.largura,
						   ft.altura,
						   ft.titulo,
						   ft.legenda,
						   ft.credito,
						   ft.descricao,
						   ft.url_imagem,
						   ft.date_insert,
						   ft.user_insert,
						   ft.date_update,
						   ft.user_update,
						   ft.site,
						   ft.cod_portal,
						   ft.tamanho,
						   ft.tipo
					  from site.v$foto ft
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and ft.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['foto_id']))
					  	$query .= ' and ft.foto_id = '.$arguments['foto_id'];
			
			return $this->getResult($query);
		}
		
		function get_noticia_acesso($arguments=array()) {
			$query = ' select *
						from(  select  n.noticia_id,
									   n.titulo,
									   n.cod_portal,
									   n.acessos,
									   row_number() over (order by e.data_exibicao desc, n.acessos desc) as linha
								
								
								from jornal.v$edicao e 
								 inner join jornal.v$noticia_secao ns on ns.edicao_id = e.edicao_id
								 inner join jornal.v$noticia n on n.noticia_id = ns.noticia_id
								
								where 1=1';
				if(strlen($arguments['cod_portal']))
					$query .= ' and n.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen($arguments['grupo_portais']))
					$query .= ' and n.cod_portal in ('.str_replace("\'","'",$arguments['grupo_portais']).')';
				if(strlen($arguments['dias_exibicao']))
					$query .= ' and e.data_exibicao <= (sysdate-'.$arguments['dias_exibicao'].')';

				
			
			$query .= '    ) 
				where 1=1 ';
				if(strlen(trim($arguments['nro_noticias'])))
					$query .= ' and linha <= '.$arguments['nro_noticias'];
						
			//print($query);
			return $this->getResult($query);
		}
		
		
		function get_destaque($arguments=array()) {
			$query = ' select destaque_id,
							   titulo,
							   texto,
							   data_publicacao,
							   cod_portal,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from jornal.v$destaque d
						 where d.cod_portal = \''.$arguments['cod_portal'].'\'';
						 

				if(strlen(trim($arguments['destaque_id'])))
					$query .= ' and d.destaque_id = '.$arguments['destaque_id'];
				if(strlen(trim($arguments['titulo'])))
					$query .= ' and titulo like \'%'.$arguments['titulo'].'%\'';
				if(strlen(trim($arguments['data_publicacao'])))
					$query .= ' and data_publicacao = \'%'.$arguments['data_publicacao'].'%\'';
				if(strlen(trim($arguments['data'])))
					$query .= ' and data_publicacao < \''.$arguments['data'].'\'';
				
			$query .= ' order by data_publicacao desc';
						
			//print($query);
			return $this->getResult($query);
		}
					
	
	}
	global $conexao_banco;
	$JornalConsultaObj = new JornalConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $JornalConsultaObj;


if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>