<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $JogoComObj;
if(!$JogoComObj) {
	class JogoCom extends QueryCom {
	
		/*
		* Criado em Wed May 28 10:25:16 UTC-0200 2008
		* Retorna todas as categorias
		*/
		function get_categoria($arguments=array()){
		
			$query = 'select cat.cod_portal,
						   cat.categoria_id,
						   cat.cod_categoria,
						   cat.descricao,
						   cat.user_insert,
						   cat.date_insert,
						   cat.user_update,
						   cat.date_update,
						   cat.site
					  from jogos.v$categoria cat
					  where 1=1';
					  if(strlen($arguments['categoria_id']))
					  	$query .= ' and cat.categoria_id = '.$arguments['categoria_id'];
			 $query .= ' order by cat.categoria_id asc';
			
			return $this->getResult($query);
		}
	
	
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas os Jogos
		 */
		function get_jogo($arguments=array()){
									
			$query = 'select jg.cod_portal,
							 jg.jogo_id,
							 jg.cod_fornecedor,
							 jg.nome,
							 jg.descricao,
							 jg.icone_url,
							 jg.imagem_url,
							 jg.largura,
							 jg.altura,
							 jg.url,
							 jg.play_url,
							 jg.download_url,
							 jg.user_insert,
							 jg.date_insert,
							 jg.user_update,
							 jg.date_update,
							 jg.site
					  from jogos.v$jogo jg
					  inner join jogos.v$jogo_categoria jcat
					  on jg.jogo_id = jcat.jogo_id
					  inner join jogos.v$categoria cat
					  on cat.categoria_id = jcat.categoria_id            
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and jg.cod_portal = \''.$arguments['cod_portal'].'\'';					  
					  if(strlen($arguments['jogo_id']))
					  	$query .= ' and jg.jogo_id = '.$arguments['jogo_id'];
					  if(strlen($arguments['categoria_id']))
					  	$query .= ' and cat.categoria_id = '.$arguments['categoria_id'];
					  if(strlen($arguments['ordenar'])){
					  	if($arguments['ordenar'] == 1)
							$query .= ' order by jg.nome asc';
						if($arguments['ordenar'] == 2)
							$query .= ' order by dbms_random.random'; 
					  }else
					  	$query .= ' order by jg.jogo_id asc';	
					
										
		
			return $this->getResult($query);
		}
		
		
		/*
		 * 
		 * Retorna todas as caracteristicas do veculo
		 */
	    function get_veiculo_novo($arguments=array()){
			
			$query = 'select vn.veiculo_novo_id,
						   vn.veiculo_categoria_id,
						   vn.nome,
						   vn.texto_descricao,
						   vn.texto,
						   vn.url_link,
						   vn.url_imagem_principal,
						   vn.ordem,
						   vn.cod_portal,     
						   vn.user_insert,
						   vn.date_insert,
						   vn.user_update,
						   vn.date_update,
						   vn.site
					  from concessionaria.v$veiculo_novo vn
					  where 1=1 ';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and vn.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['veiculo_novo_id']))
					  	$query .= ' and vn.veiculo_novo_id = '.$arguments['veiculo_novo_id'];
					
			return $this->getResult($query);
		}
	
	
		/*
		 * 
		 * Retorna todas as caracteristicas do veculo
		 */
	    function get_veiculo_caracteristica($arguments=array()){
			
			$query = 'select vc.veiculo_caracteristica_id,
						   vc.veiculo_novo_id,
						   vc.titulo,
						   vc.texto,
						   vc.url_imagem_caracteristica,
						   vc.ordem,
						   vc.user_insert,
						   vc.date_insert,
						   vc.user_update,
						   vc.date_update,
						   vc.site
					from concessionaria.v$veiculo_caracteristica vc
					where 1=1 ';
					if(strlen($arguments['veiculo_caracteristica_id']))
						$query .= ' and vc.veiculo_caracteristica_id = '.$arguments['veiculo_caracteristica_id'];
					if(strlen($arguments['veiculo_novo_id']))
						$query .= ' and vc.veiculo_novo_id = '.$arguments['veiculo_novo_id'];
					
			return $this->getResult($query);
		}
		
		
		/*
		 * 
		 * Retorna todas as fotos do veculo
		 */
	    function get_veiculo_novo_foto($arguments=array()){
			
			$query = 'select vnf.foto_id,
						   vnf.veiculo_novo_id,
						   vnf.titulo,
						   vnf.ordem,
						   vnf.user_insert,
						   vnf.date_insert,
						   vnf.user_update,
						   vnf.date_update,
						   vnf.site,
						   ft.titulo,
						   ft.credito,
						   ft.url_imagem
					  from concessionaria.v$veiculo_novo_foto vnf
					  inner join site.v$foto ft
					  on ft.foto_id = vnf.foto_id
					  where 1=1 ';
					  if(strlen($arguments['veiculo_novo_id']))
						$query .= ' and vnf.veiculo_novo_id = '.$arguments['veiculo_novo_id'];
					  					
			return $this->getResult($query);
		}
		
		
		/*
		 * 
		 * Retorna todas as fotos do veculo
		 */
	    function get_veiculo_categoria($arguments=array()){
			
			$query = 'select vcat.veiculo_categoria_id,
						   vcat.titulo,
						   vcat.descricao,
						   vcat.ordem,
						   vcat.user_insert,
						   vcat.date_insert,
						   vcat.user_update,
						   vcat.date_update,
						   vcat.site
					  from concessionaria.v$veiculo_categoria vcat 
					  where 1=1 ';
					  if(strlen($arguments['veiculo_categoria_id']))
						$query .= ' and vcat.veiculo_categoria_id = '.$arguments['veiculo_categoria_id'];
					  					
			return $this->getResult($query);
		}
	
		
	
		/*
		 * 
		 * Retorna todas as categorias de email
		 */
		function get_email_categoria($arguments=array()) {
		
			$query = 'select ec.email_categoria_id,
						   ec.descricao,
						   ec.user_insert,
						   ec.date_insert,
						   ec.user_update,
						   ec.date_update,
						   ec.site,
						   ec.cod_portal
					  from concessionaria.v$email_categoria ec
					  where 1=1 ';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and ec.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['email_categoria_id']))
					  	$query .= ' and ec.email_categoria_id = '.$arguments['email_categoria_id'];
			
			return $this->getResult($query);
		
		}
		
		
		/*
		 * 
		 * Retorna toda a relao de emails da unidade
		 */
		function get_email_relacao($arguments=array()) {
		
			$query .= 'select er.email_categoria_id,
						   er.unidade_id,
						   er.email,
						   er.email_copia,
						   er.user_insert,
						   er.date_insert,
						   er.user_update,
						   er.date_update,
						   er.site,
						   ec.descricao,
						   ec.cod_portal
					 from concessionaria.v$email_relacao er
					 inner join concessionaria.v$email_categoria ec
					 on er.email_categoria_id = ec.email_categoria_id
					 where 1=1';
					 if(strlen($arguments['cod_portal']))
					 	$query .= ' and ec.cod_portal = \''.$arguments['cod_portal'].'\'';
					 if(strlen($arguments['email_categoria_id']))
					 	$query .= ' and er.email_categoria_id = '.$arguments['email_categoria_id'];
					 if(strlen($arguments['unidade_id']))
					 	$query .= ' and er.unidade_id = '.$arguments['unidade_id'];
					 
			return $this->getResult($query);
		
		}
		
	
	
	
	
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as categorias
		 */
		function get_blog_categorias($arguments=array()){
			$query = 'select ';
			
			if(strlen($arguments['exibir']) && $arguments['exibir'] == "colunas")
				$query .='distinct ';
				
			$query .= '   c.categoria_id,
						  c.categoria_pai_id,
						  c.descricao						  
					  from jornal.v$blog_categoria c ';
					  if(strlen($arguments['exibir']) && $arguments['exibir'] == "colunas")
					  	$query .= 'inner join jornal.v$blog b on c.categoria_id = b.categoria_id 
						           inner join jornal.v$blog_mensagem bm on b.blog_id = bm.blog_id ';
							
		    $query .= 'where 1=1 and c.cod_portal = \'' .$arguments["cod_portal"].'\'';					  
					  if(strlen($arguments['categoria_id']))
			 			$query .= ' and c.categoria_id = '.$arguments["categoria_id"].' ';
					  if(strlen($arguments['descricao']))
			 		  	$query .= ' and strtoupper(c.descricao) LIKE \'%'.strtoupper($arguments["descricao"]).'%\' ';					  
					  if(strlen($arguments['ordem_exibicao']) && $arguments['ordem_exibicao'] == "alfa")
					  	$query .= ' order by c.descricao asc';
					  if(strlen($arguments['ordem_exibicao']) && $arguments['ordem_exibicao'] == "random")
					  	$query .= ' order by dbms_random.random';				
					  
														
			return $this->getResult($query);
			
		}
		
		/* fim get_blog_categorias */
		
		
		/* Busca as categorias de Blogs */
		function get_blog_categoria($arguments=array(),$resulttype='array') {
			$query = '
					select bc.categoria_id,
						   bc.categoria_pai_id,
						   level,
						   lpad(\' \',level-1,\' \') ident,
						   sys_connect_by_path(descricao,\' / \') path,
						   bc.descricao,
						   bc.date_insert,
						   bc.user_insert,
						   bc.date_update,
						   bc.user_update,
						   bc.site,
						   bc.cod_portal
					  from jornal.v$blog_categoria bc
					 where bc.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and bc.categoria_id = '.$arguments['categoria_id'];
			$query .= '
					 start with bc.categoria_pai_id is null
					connect by prior bc.categoria_id = bc.categoria_pai_id
					 order siblings by bc.descricao
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as categorias
		 */
		function get_colunistas( $arguments=array() ){
			
		
			$query = 'select 
						  c.colunista_id,
						  c.nome,
						  c.situacao_id,
						  c.atividade,
						  c.historico_profissional,
						  c.url_imagem,
						  c.email,
						  c.cod_portal
					  from jornal.v$colunista c
					  where 1=1 and c.cod_portal = \''.$arguments["cod_portal"].'\'';
					  if(strlen($arguments['nome']))
			 		  	$query .= ' and strtoupper(c.nome) LIKE \''.strtoupper($arguments["nome"]).'%\' ';
					  if(strlen($arguments['email']))
			 		  	$query .= ' and upper(c.email) = \''.strtoupper($arguments["email"]).'\'';
					  if(strlen($arguments['colunista_id']))
			 		  	$query .= ' and c.colunista_id = ' . $arguments["colunista_id"];
						
					  $query .= ' order by c.nome asc';
		   		
			return $this->getResult($query);			
			
			
		}
		/* fim get_blog_categorias */
		
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todos os colunistas, para pgina de colunistas
		 */
		function get_colunistas_home($arguments=array()){		
		
							 
			 $query = 'select distinct
							  c.colunista_id,
							  c.nome,
							  c.situacao_id,
							  c.atividade,
							  c.historico_profissional,
							  c.url_imagem,
							  c.email,
							  c.cod_portal,
							  c.date_insert,
							  bc.categoria_id,
							  bc.descricao,
							  b.blog_id,
							  b.titulo,
							  b.ativo,
							  b.tipo,
							  bm.mensagem_id,
                			  bm.date_insert
						from jornal.v$colunista c
						inner join jornal.v$blog b
						on b.colunista_id = c.colunista_id
						inner join jornal.v$blog_categoria bc
						on bc.categoria_id = b.categoria_id
						inner join jornal.v$blog_mensagem bm
            			on bm.blog_id = b.blog_id
						where 1=1 
						and b.ativo = 1 
						and c.situacao_id = 1
						and bm.data_envio = (select max(bm2.data_envio)
						                        from jornal.v$blog_mensagem bm2
                                   where bm2.blog_id = bm.blog_id)
						and c.cod_portal = \''.$arguments["cod_portal"].'\'';
						if(strlen($arguments['nome']))
			 		  		$query .= ' and c.nome LIKE \''.$arguments["nome"].'%\' ';
					    if(strlen($arguments['colunista_id']))
			 		  		$query .= ' and c.colunista_id = ' . $arguments["colunista_id"] . ' and tipo=2';
						if(strlen($arguments['blog_id']))
			 		  		$query .= ' and b.blog_id = ' . $arguments["blog_id"];
						if(strlen($arguments['categoria_id']))
			 		  		$query .= ' and bc.categoria_id = '.$arguments["categoria_id"];
						if(strlen($arguments['tipo']) && ($arguments['tipo'] != "todos"))
							$query .= ' and b.tipo = '.$arguments['tipo'];
						if(strlen($arguments['exibir_categoria']) && $arguments['exibir_categoria'] != "todas"){					  		
								$query .= ' and bc.categoria_id = ' . $arguments['exibir_categoria'];							
					    } 
						if(strlen($arguments['ordem_exibicao'])){
							if($arguments['ordem_exibicao'] == "random"){															
								$query .= ' order by dbms_random.random';			
							}else{
								$query .= 'order by bm.mensagem_id desc';								
							}
						}
					    else{
							 $query .= ' order by bm.mensagem_id desc';							
					    }					
					   						
						
			return $this->getResult($query);
			
		}
		/* fim get_blog_categorias */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todos dos colunistas para o Objeto - BlogPrincipal
		 */
		function get_colunistas_principal($arguments=array()){		
			$query = 'select * from (select distinct
							  c.colunista_id,
							  c.nome,
							  c.situacao_id,
							  c.atividade,
							  c.historico_profissional,
							  c.url_imagem,
							  c.email,
							  c.cod_portal,
							  c.date_insert,
							  bc.categoria_id,
							  bc.descricao,
							  b.blog_id,
							  b.tipo
						from jornal.v$colunista c
						inner join jornal.v$blog b
						on b.colunista_id = c.colunista_id
						inner join jornal.v$blog_categoria bc
						on bc.categoria_id = b.categoria_id
						inner join jornal.v$blog_mensagem bm
            			on bm.blog_id = b.blog_id
						where 1=1 and b.ativo = 1 and c.cod_portal = \''.$arguments["cod_portal"].'\'';
						if(strlen($arguments['nome']))
			 		  		$query .= ' and c.nome LIKE \''.$arguments["nome"].'%\' ';
					    if(strlen($arguments['colunista_id']))
			 		  		$query .= ' and c.colunista_id = ' . $arguments["colunista_id"];
						if(strlen($arguments['blog_id']))
			 		  		$query .= ' and b.blog_id = ' . $arguments["blog_id"];
						if(strlen($arguments['categoria_id']))
			 		  		$query .= ' and bc.categoria_id = '.$arguments["categoria_id"];
						if(strlen($arguments['tipo']) && ($arguments['tipo'] != "todos") )
							$query .= ' and b.tipo = '.$arguments['tipo'];
						if(strlen($arguments['exibir_categoria']) && $arguments['exibir_categoria'] != "todas"){					  		
								$query .= ' and bc.categoria_id = ' . $arguments['exibir_categoria'];							
					    } 
						if(strlen($arguments['ordem_exibicao'])){
							if($arguments['ordem_exibicao'] == "random"){															
								$query .= ' order by dbms_random.random';										
							}else{
								$query .= 'order by c.date_insert desc';								
							}
						}

					    else{
							 $query .= 'order by c.date_insert desc';							
					    }
						
		   		$query .= ') where rownum between 0 and '.$arguments['num_exibicoes'];
										
									
			return $this->getResult($query);
		}
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as colunas/blogs
		 */
		function get_colunas( $arguments=array() ){
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.tipo
					  from jornal.v$blog b
					  where 1=1 and b.ativo = 1 and b.cod_portal = \''.$arguments["cod_portal"].'\'';
					  if(strlen($arguments['titulo']))
			 		  	$query .= ' and b.titulo LIKE \''.$arguments["titulo"].'%\' ';
					  if(strlen($arguments['blog_id']))
			 		  	$query .= ' and b.blog_id = ' . $arguments["blog_id"];
						
					  $query .= 'order by b.data_criacao asc';
			return $this->getResult($query);
			
		}
		/* fim get_blog_categorias */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as Mensagens do Blog
		 */
		function get_blog_mensagem( $arguments=array() ){
			$query = 'select
						  bm.mensagem_id,
						  bm.blog_id,
						  bm.titulo,
						  bm.data_envio,
						  bm.usuario,
						  bm.texto
					  from jornal.v$blog_mensagem bm
					  inner join jornal.v$blog b
            		  on b.blog_id = bm.blog_id
					  where 1=1 and b.ativo = 1 and bm.cod_portal = \''.$arguments["cod_portal"].'\'';
					  if(strlen($arguments['mensagem_id']))
					  	$query .= ' and bm.mensagem_id = '.$arguments["mensagem_id"];
					  if(strlen($arguments['blog_id']))
					  	$query .= ' and bm.blog_id = '.$arguments["blog_id"];
					  if(strlen($arguments['titulo']))
					  	$query .= ' and strtoupper(bm.titulo) LIKE \'%'.strtoupper($arguments["titulo"]).'%\' ';
					
					$query .= 'order by bm.data_envio desc'; 			 
			 
			 return $this->getResult($query); 
		}
		/* fim get_mensagem_blog */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as postagens - Objeto
		 */
		function get_postagens( $arguments=array() ){			
		
			$query = 'select * from (select 
									c.colunista_id,
									c.nome,
									c.situacao_id,
									c.atividade,
									c.historico_profissional,
									c.url_imagem,
									c.email,
									c.cod_portal,
									c.date_insert,
									bc.categoria_id,
									bc.descricao,
									b.blog_id,
									bm.mensagem_id,									
									bm.titulo,									
									to_char(bm.data_envio) as data_envio,
									to_date(bm.data_envio,\'DD/MM/YYYY HH24:MI:SS\') as data_envio_post,
									to_char(bm.data_envio, \'DD/MM/YYYY\') as data_envio_ex,
									bm.texto
									                
									from jornal.v$colunista c
								
									inner join jornal.v$blog b
									on b.colunista_id = c.colunista_id
								
									inner join jornal.v$blog_categoria bc
									on bc.categoria_id = b.categoria_id
								
								    inner join jornal.v$blog_mensagem bm
								    on bm.blog_id = b.blog_id
								
									where 1=1 
									and b.ativo = 1
									and c.cod_portal = \''.$arguments['cod_portal'].'\'';
									if(strlen($arguments['blog_id']))
								    	$query .=' and b.blog_id ='.$arguments['blog_id'];
									if(strlen($arguments['colunista_id']))
								    	$query .=' and b.colunista_id ='.$arguments['colunista_id'] . ' and tipo=2';
									if(strlen($arguments['mensagem_id']))
								    	$query .=' and bm.mensagem_id ='.$arguments['mensagem_id'];
									if(strlen($arguments['email']))
								    	$query .=' and c.email =\''.$arguments['email'].'\'';
											
			 	$query .= ' order by data_envio_post desc ) where rownum between ';
				if(strlen($arguments['inicio_resultados'])){
					$query .= print($arguments['inicio_resultados']);
				}else{
					$query .= ' 0';
				}
				$query .=  ' and ';
				if(strlen($arguments['fim_resultados'])){
					$query .= $arguments['fim_resultados']; 
				}else{
					$query .= ' 10000000';
				}					
				
				//print($query);							
				
			return $this->getResult($query);
		}
		/* fim get_postagens */
		
		
		/*
		*
		* Retorna o nmero de posts do colunista
		*/
		function get_numero_posts( $arguments=array() ){
		
		new dBug($arguments);
		
			$query = '
						select * from (
							select  c.colunista_id,
									c.nome,
									bm.texto,
									bm.titulo,
									to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									count(*) over(partition by c.colunista_id) n_posts,
									row_number() over(partition by c.colunista_id order by c.nome asc) number_row
							 from jornal.v$colunista c
							 inner join jornal.v$blog b on b.colunista_id = c.colunista_id
							 inner join jornal.v$blog_categoria bc on bc.categoria_id = b.categoria_id
							 inner join jornal.v$blog_mensagem bm on bm.blog_id = b.blog_id
							 where 1=1
							 and c.cod_portal = \''.$arguments['cod_portal'].'\'';
							
							 if(strlen($arguments['colunista_id'])){	  
							 	$query .= ' and c.colunista_id ='.$arguments['colunista_id'];								
							 }
							 
			$query .= ') posts where 1=1 order by posts.data_envio desc';
		
			return $this->getResult($query);
		}
		
		
		function get_posts_arquivo( $arguments=array() ){
		
					
			$query = 'select to_char(b.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
						  to_char(b.data_envio, \'MM\') as mes_num,              
						  count(*) as num_posts,
						  b.blog_id
						  from jornal.v$blog_mensagem b
						  left join jornal.v$blog bb on bb.blog_id = b.blog_id
						  left join jornal.v$colunista c on c.colunista_id = bb.colunista_id 
						  where 1 = 1 and c.cod_portal =\''.$arguments['cod_portal'].'\'';
							
						 if(strlen($arguments['colunista_id'])){	  
							$query .= ' and c.colunista_id ='.$arguments['colunista_id'];								
						 }
						 if(strlen($arguments['blog_id'])){	  
							$query .= ' and bb.blog_id ='.$arguments['blog_id'];								
						 }
					   
			$query.=' group by to_char(b.data_envio, \'Month\', \'nls_date_language=portuguese\'),
					 to_char(b.data_envio, \'MM\'), b.blog_id         
					 order by mes_num desc';
		
			return $this->getResult($query);
		}
		
		
		function get_posts_mes( $arguments=array() ){
			
			$query = 'select * from (select  c.colunista_id,
									  c.nome,
									  bm.mensagem_id,
									  bm.texto,
									  bm.titulo,
									  bm.blog_id,
									  to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									  count(*) over(partition by c.colunista_id) n_posts,
									  to_char(bm.data_envio, \'MM\') as mes_num,
									  to_char(bm.data_envio, \'YYYY\') as ano_num,									 
									  to_char(bm.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
									  row_number() over(partition by c.colunista_id order by c.nome asc) number_row
								   from jornal.v$colunista c
								   inner join jornal.v$blog b on b.colunista_id = c.colunista_id
								   inner join jornal.v$blog_categoria bc on bc.categoria_id = b.categoria_id
								   inner join jornal.v$blog_mensagem bm on bm.blog_id = b.blog_id
								   where 1=1';
								   if(strlen($arguments['cod_portal'])){
								   		$query .= ' and c.cod_portal = \''.$arguments['cod_portal'].'\'';
								   }								   								  
								   if(strlen($arguments['blog_id'])){
								   		$query .= ' and bm.blog_id ='.$arguments['blog_id'];
								   }
								   if(strlen($arguments['arquivo_mes'])){
								   		$query .= ' and to_char(bm.data_envio, \'MM\') = \''.$arguments['arquivo_mes'].'\''	;
								   }								   
			$query .= ' ) posts where 1=1 order by posts.data_envio desc';
					 
						
			return $this->getResult($query);
		}
		
		
		function get_posts_data( $arguments=array() ){
			
			$query = 'select * from (select  c.colunista_id,
									  c.nome,
									  bm.mensagem_id,
									  bm.texto,
									  bm.titulo,
									  to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									  count(*) over(partition by c.colunista_id) n_posts,
									  to_char(bm.data_envio, \'MM\') as mes_num,
									  to_char(bm.data_envio, \'YYYY\') as ano_num,
									  to_char(bm.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
									  row_number() over(partition by c.colunista_id order by c.nome asc) number_row
								   from jornal.v$colunista c
								   inner join jornal.v$blog b on b.colunista_id = c.colunista_id
								   inner join jornal.v$blog_categoria bc on bc.categoria_id = b.categoria_id
								   inner join jornal.v$blog_mensagem bm on bm.blog_id = b.blog_id
								   where 1=1';
								   if(strlen($arguments['cod_portal'])){
								   		$query .= ' and c.cod_portal = \''.$arguments['cod_portal'].'\'';
								   }								   								  
								   if(strlen($arguments['blog_id'])){
											$query .= ' and bm.blog_id ='.$arguments['blog_id'];
								   }
								   if(strlen($arguments['data'])){
								   		$query .= ' and to_char(bm.data_envio, \'dd/mm/YYYY\') = \''.$arguments['data'].'\''	;
								   }								   
			$query .= ' ) posts where 1=1 order by posts.data_envio desc';
			
			
			return $this->getResult($query);
		}
		
		
		/*
		* Retorna o cabecalho do BLog
		*/
		function get_cabecalho( $arguments=array() ){
		
			
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.cod_portal
					from jornal.v$blog b
					where 1 = 1
					and ativo = 1';
					if(strlen($arguments['cod_portal'])) 
						$query .= 'and b.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen($arguments['blog_id']))
						$query .= 'and b.blog_id = '.$arguments['blog_id'];
			
			return $this->getResult($query);
		}
		
		
		function get_comentarios( $arguments=array() ){
			
			$query = '';
			
			return $this->getResult($query);
			
		}
		
		
		
		
		/*
		* Retorna os Blogs/Colunas do Usuario
		*/
		function get_blogs( $arguments=array() ){
		
			
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.cod_portal,
						  b.tipo,
						  c.nome,
						  c.email,
						  c.historico_profissional,
						  c.url_imagem
					from jornal.v$blog b
					inner join jornal.v$colunista c
                    on c.colunista_id = b.colunista_id
					where 1 = 1
					and ativo = 1';
					if(strlen($arguments['cod_portal'])) 
						$query .= 'and b.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen($arguments['blog_id']))
						$query .= 'and b.blog_id = '.$arguments['blog_id'];
					if(strlen($arguments['email']))
						$query .= 'and upper(c.email) = \''.strtoupper($arguments['email']).'\'';
			
			return $this->getResult($query);
		}	
		
						
			
		
	}// fim classe
	
	global $conexao_banco;
	$JogoComObj = new JogoCom($conexao_banco);
}// fim if

global $createdObject;
$createdObject = $JogoComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>