<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $ImpressoConsultaObj;
if(!$ImpressoConsultaObj) {
	class ImpressoConsulta extends QueryCom {
		/* Busca os cadernos cadastrados */
		function get_impresso_caderno($arguments=array(),$resulttype='array') {
			$query = '
				select ic.caderno_id,
					   ic.cod_portal,
					   ic.descricao,
					   ic.prefixo,
					   ic.ordem,
					   to_char(ic.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   ic.user_insert,
					   to_char(ic.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   ic.user_update,
					   ic.site
				  from jornal.v$impresso_caderno ic
				 where 1=1
			 ';
			 			
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ic.cod_portal = \''.$arguments['cod_portal'].'\'';
		    			 
			if(strlen(trim($arguments['caderno_id'])))
				$query .= ' and ic.caderno_id = '.$arguments['caderno_id'];
			$query .= ' order by ic.ordem ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
					
				//print($query);	
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca as edies impressas */
		function get_impresso($arguments=array(),$resulttype='array') {

			$query = '
				select i.impresso_id,
					   i.cod_portal,
					   to_char(i.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(i.data_publicacao,\'dd/mm/yyyy\') as data_publicacao_exibicao,
					   i.nome,
					   i.ano,
					   i.cod_edicao,
					   i.valor,
					   i.principal,
					   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   i.user_insert,
					   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   i.user_update,
					   i.site
				  from jornal.v$impresso i
				 where 1=1
			 ';
			
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';
			
			if(!strlen(trim($arguments['data_publicacao']))) {
				if(!strlen(trim($arguments['caderno_id']))) {
					$query .= ' and i.data_publicacao = (select max(i2.data_publicacao) 
														   from jornal.v$impresso i2
														   where i2.cod_portal = \''.$arguments['cod_portal'].'\' and i2.data_publicacao <= sysdate' ;
				} else {
					$query .= ' and i.data_publicacao = (select max(i2.data_publicacao) 
														  from jornal.v$impresso_pagina ip
														 inner join jornal.v$impresso i2
														         on i2.impresso_id = ip.impresso_id
														 where ip.impresso_id = i.impresso_id
														   and ip.caderno_id = '.$arguments['caderno_id'].'
														   and i2.cod_portal = \''.$arguments['cod_portal'].'\' 
														   and i2.data_publicacao <= sysdate' ;
				}
				
				if(strlen(trim($arguments['impresso_id'])))
					$query .= ' and i2.impresso_id = '.$arguments['impresso_id'];
					
				$query .= ')';
				
				
			}else{
				$query .= ' and i.data_publicacao >= \''.$arguments['data_publicacao'] .'\'';
			}
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and data_publicacao <= \'' .$arguments['data_final']. '\'';
				
			if(strlen(trim($arguments['impresso_id'])))
				$query .= ' and i.impresso_id = '.$arguments['impresso_id'];
			
			if(strlen(trim($arguments['caderno_id'])))
				$query .= ' and exists (select 0
				                          from jornal.v$impresso_pagina ip
										 where ip.impresso_id = i.impresso_id
										   and ip.caderno_id = '.$arguments['caderno_id'].') ';
			$query .= ' order by i.data_publicacao desc ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);				
			
			//print($query."<br><br>");
			
		    return $this->getResult($query,$resulttype);
		}		
		
		
		/* Busca as edies impressas */
		function get_impresso_especifico($arguments=array(),$resulttype='array') {
			$query = '
				select i.impresso_id,
					   i.cod_portal,
					   to_char(i.data_publicacao,\'dd/mm/yyyy hh24:mi:ss\') as data_publicacao,
					   to_char(i.data_publicacao,\'dd/mm/yyyy\') as data_publicacao_exibicao,
					   i.ano,
					   i.nome,
					   i.cod_edicao,
					   i.valor,
					   i.descricao,
					   i.principal,
					   to_char(i.data_limite,\'dd/mm/yyyy hh24:mi:ss\') as data_limite,
					   i.descricao,
					   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   i.user_insert,
					   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   i.user_update,
					   i.site
				  from jornal.v$impresso i
				 where 1=1
			 ';				
			if(strlen(trim($arguments['impresso_id'])))
				$query .= ' and i.impresso_id = '.$arguments['impresso_id'];			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca as paginas do impresso */
		function get_impresso_pagina($arguments=array(),$resulttype='array') {
			$query = '
				select i.nome,
					   i.data_publicacao,
					   i.descricao,
					   ip.pagina_id,
					   ip.caderno_id,
					   ip.impresso_id,
					   ip.num_pagina,
					   ip.url_imagem,
					   ip.url_pdf,
					   to_char(ip.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   ip.user_insert,
					   to_char(ip.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   ip.user_update,
					   ip.site,
					   ic.descricao as caderno,
					   ip.altura,
					   ip.largura,
					   ip.imagem_id,
					   ai.md5 as md5_imagem,
					   ip.pdf_id,
					   ap.md5 as md5_pdf
				  from jornal.v$impresso_pagina ip
				 inner join jornal.v$impresso_caderno ic on ic.caderno_id = ip.caderno_id
				 inner join jornal.v$impresso i on ip.impresso_id = i.impresso_id
				  left join site.v$arquivo ai
				         on ai.arquivo_id = ip.imagem_id
				  left join site.v$arquivo ap
				         on ap.arquivo_id = ip.pdf_id
				 where 1=1
			 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and ic.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['pagina_id'])))
				$query .= ' and ip.pagina_id = '.$arguments['pagina_id'];
			if(strlen(trim($arguments['caderno_id'])))
				$query .= ' and ip.caderno_id = '.$arguments['caderno_id'];
			if(strlen(trim($arguments['impresso_id'])))
				$query .= ' and ip.impresso_id = '.$arguments['impresso_id'];
			if(strlen(trim($arguments['num_pagina'])))
				$query .= ' and ip.num_pagina = '.$arguments['num_pagina'];
			if(strlen(trim($arguments['principal'])))
				$query .= ' and i.principal = '.$arguments['principal'];
			if(strlen(trim($arguments['ordem'])))
				$query .= $arguments['ordem'];
			else
				$query .= ' order by i.data_publicacao desc,ip.caderno_id, ip.num_pagina ';
			
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    
			//print($query."<br>");
					
			return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca as panfletos */
		function get_panfleto($arguments=array(),$resulttype='array') {
			$query = '
				select panfleto_id,
					   nome,
					   to_char(data_exibicao, \'dd/mm/yyyy hh24:mi\') as data_exibicao,
					   to_char(data_limite, \'dd/mm/yyyy hh24:mi\') as data_limite,
					   capa_id,
					   verso_id,
					   cod_portal,
					   date_insert,
					   user_insert,
					   date_update,
					   user_update,
					   site
				  from impresso.v$panfleto

				 where 1=1
				   and cod_portal = \''.$arguments['cod_portal'].'\'';

			if(strlen(trim($arguments['panfleto_id'])))
				$query .= ' and panfleto_id = '.$arguments['panfleto_id'];
			if(strlen(trim($arguments['data'])))
				$query .= ' and data_exibicao <= \''.$arguments['data'].'\' and data_limite >= \''.$arguments['data'].'\'';
			if(strlen(trim($arguments['edicao_especial'])))
				$query .= ' and edicao_especial = '.$arguments['edicao_especial'];
		    
			$query .= ' order by ordem desc';
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 *  Busca cidades dos revendedores
		 */
		function get_informativo($arguments=array(),$resulttype='array') {	
				$query .= 'select i.informativo_id,
								   i.titulo,
								   i.texto,
								   i.capa_id,
								   i.arquivo_id,
								   i.cod_portal,
								   f.url_imagem
							  from impresso.v$informativo i
							inner join site.v$foto f on f.foto_id = i.capa_id

							where 1=1

							 and i.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['informativo_id'])))
					$query .= ' and informativo_id = '.$arguments['informativo_id'];
				if(strlen(trim($arguments['uf'])))
					$query .= ' and texto like \'%'.$arguments['texto'].'%\'';
				if(strlen(trim($arguments['ordem'])))
					$query .= ' order by '.$arguments['ordem'];
				else
					$query .= ' order by i.titulo';
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		
	}
	global $conexao_banco;
	$ImpressoConsultaObj = new ImpressoConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $ImpressoConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	eval("\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx');");
}
?>