<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $ImobiliarioComObj;
if(!$ImobiliarioComObj) {
	class ImobiliarioCom extends QueryCom {
		/* Busca as imobiliarias */
		function get_imobiliaria($arguments=array(),$resulttype='array') {
			$query = '		
				select i.imobiliaria_id,
					   i.nome,
					   i.site_url,
					   i.foto_id,
					   i.referencia_id,
					   i.proprietario,
					   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   i.user_insert,
					   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   i.user_update,
					   i.site
				  from imobiliario.v$imobiliaria i
				 where 1=1
			';
			if(strlen(trim($arguments['imobiliaria_id'])))
				$query .= ' and i.imobiliaria_id = '.$arguments['imobiliaria_id'];
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and i.imobiliaria_id in (select imobiliaria_id
				                                       from imobiliario.v$imobiliaria_usuario mu
													  where mu.usuario = \''.$arguments['usuario'].'\')' ;
			$query .= ' order by i.nome ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}

		/* Busca os tipos de vendada imobiliaria */
		function get_imobiliaria_tipo_venda($arguments=array(),$resulttype='array') {
			$query = '
				select itv.tipo_venda_id,
					   itv.imobiliaria_id,
					   tv.descricao tipo_venda,
					   itv.date_insert,
					   itv.user_insert,
					   itv.date_update,
					   itv.user_update,
					   itv.site
				  from imobiliario.v$imobiliaria_tipo_venda itv
				 inner join imobiliario.v$tipo_venda tv
						 on tv.tipo_venda_id = itv.tipo_venda_id
				 where 1=1
			';
			if(strlen(trim($arguments['imobiliaria_id'])))
				$query .= ' and itv.imobiliaria_id = '.$arguments['imobiliaria_id'];
			$query .= ' order by tv.descricao ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca os telefones da imobiliaria */
		function get_imobiliaria_telefone($arguments=array(),$resulttype='array') {
			$query = '		
				select telefone_id,
					   imobiliaria_id,
					   tipo_id,
					   ddd,
					   numero,
					   ramal,
					   contato,
					   to_char(date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   user_insert,
					   to_char(date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   user_update,
					   site
				  from imobiliario.v$imobiliaria_telefone
				 where 1=1 ';
			if(strlen(trim($arguments['imobiliaria_id'])))
				$query .= ' and imobiliaria_id = '.$arguments['imobiliaria_id'];
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}

		
		/* Busca na CG_REF_CODES */
		function get_cg_ref_codes($arguments=array(),$resulttype='array') {
			$query = '
			select dominio, 
				   id, 
				   rv_high_value, 
				   abreviacao, 
				   descricao
			  from imobiliario.v$cg_ref_codes
			 where 1=1 ';
			if(strlen(trim($arguments['dominio'])))
				$query .= ' and dominio = \''.$arguments['dominio'].'\' ';
			$query .= ' order by id ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}

		/* Busca na CG_REF_CODES */
		function get_imovel_tipo($arguments=array(),$resulttype='array') {
			$query = '
			select it.tipo_id,
				   it.cod_portal,
				   it.descricao,
				   (it.atributos).getClobVal() as atributos,
				   to_char(it.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   it.user_insert,
				   to_char(it.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   it.user_update,
				   it.site
			  from imobiliario.v$imovel_tipo it
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and it.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['tipo_id'])))
				$query .= ' and it.tipo_id = '.$arguments['tipo_id'].' ';
			$query .= ' order by it.descricao';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Desmembra o XML de atributos do tipo de imovel */
		function get_imovel_tipo_atributos($arguments=array()) {
			$xml = new SimpleXMLElementExtended(utf8_encode($arguments['atributos']));
			$result = array();
			foreach($xml->children() as $child) {
				array_push($result,array(
										COD_ATRIBUTO	=> utf8_decode($child->cod_atributo),
										DESCRICAO		=> utf8_decode($child->descricao),
										TIPO_DADO		=> utf8_decode($child->tipo_dado),
										TAMANHO			=> utf8_decode($child->tamanho),
										VALOR_PADRAO	=> utf8_decode($child->valor_padrao),
										OBRIGATORIO		=> utf8_decode($child->obrigatorio),
										VALORES			=> utf8_decode($child->valores),
										ORDEM			=> utf8_decode($child->ordem)
										));
									
			}
			return $result;
		}
		
		/* Busca as finalidades de imoveis */
		function get_imovel_finalidade($arguments=array(),$resulttype='array') {
			$query = '
			select f.finalidade_id,
				   f.descricao,
				   f.date_insert,
				   f.user_insert,
				   f.date_update,
				   f.user_update,
				   f.site
			  from imobiliario.v$imovel_finalidade f
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and f.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['finalidade_id'])))
				$query .= ' and f.finalidade_id = '.$arguments['finalidade_id'].' ';
			$query .= ' order by f.descricao';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os imoveis */
		function get_imovel($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			$query = '
			select i.imovel_id,
				   i.cod_portal,
				   i.tipo_id,
				   it.descricao as tipo,
				   i.finalidade_id,
				   if.descricao as finalidade,
				   i.titulo,
				   i.descricao,
				   i.area_construida,
				   i.area,
				   (i.atributos).getClobVal() as atributos,
				   i.referencia_id,
				   rf.latitude,
				   rf.longitude,
				   mun.municipio,
				   mun.uf_id as uf,
				   b.descricao as bairro,
				   i.observacoes,	
				   i.destaque,			   
				   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   i.user_insert,
				   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   i.user_update,
				   i.site,
				   ii.valor,
				   to_char(ii.data_inicio,\'dd/mm/yyyy\') as data_inicio,
				   to_char(ii.data_termino,\'dd/mm/yyyy\') as data_termino,
				   ii.tipo_venda_id
			  from imobiliario.v$imovel i
			 inner join imobiliario.v$imovel_tipo it
			         on it.tipo_id = i.tipo_id
			 inner join imobiliario.v$imovel_finalidade if
			         on if.finalidade_id = i.finalidade_id
			 inner join gis.v$referencia rf
			         on rf.referencia_id = i.referencia_id
			 inner join cep.municipio mun
			         on mun.municipio_id = rf.municipio_id
		     inner join gis.v$bairro b
			         on b.bairro_id = rf.bairro_id
			  inner join imobiliario.v$imovel_imobiliaria ii
					 on ii.imovel_id = i.imovel_id
					 
			 where 1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['imovel_id'])))
				$query .= ' and i.imovel_id = '.$arguments['imovel_id'].' ';
			if(strlen(trim($arguments['tipo_id'])))
					$query .= ' and i.tipo_id = ' . $arguments['tipo_id'];
			if(strlen(trim($arguments['imovel_id'])))
				$query .= ' and i.imovel_id = '.$arguments['imovel_id'].' ';
			if(strlen(trim($arguments['bairro_id'])))
				$query .= ' and bairro_id = ' . $arguments['bairro_id'];
			if(strlen(trim($arguments['municipio_id'])))
				$query .= ' and municipio_id = ' . $arguments['municipio_id'];
			if(strlen(trim($arguments['valor'])))
				$query .= ' and ii.valor <= ' . $arguments['valor'];
			if(strlen(trim($arguments['destaque'])))
				$query .= ' destaque = ' . $arguments['destaque'];
				
			$query .= ' order by i.titulo';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os imoveis para exibio */
		function get_imovel_exibicao($arguments=array(),$resulttype='array') {
			$query = '
				select * from (
					select i.imovel_id,
						   i.cod_portal,
						   i.tipo_id,
						   it.descricao as tipo,
						   i.finalidade_id,
						   if.descricao as finalidade,
						   i.titulo,
						   i.descricao,
						   i.area_construida,
						   i.area,
						   (i.atributos).getClobVal() as atributos,
						   i.referencia_id,
						   rf.latitude,
						   rf.longitude,
						   mun.municipio,
						   mun.uf_id as uf,
						   b.descricao as bairro,
						   i.observacoes,
						   i.destaque,
						   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
						   i.user_insert,
						   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
						   i.user_update,
						   ii.valor,
						   to_char(ii.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_char(ii.data_termino,\'dd/mm/yyyy\') as data_termino,
						   ii.tipo_venda_id,
						   i.site
					  from imobiliario.v$imovel i
					 inner join imobiliario.v$imovel_tipo it
							 on it.tipo_id = i.tipo_id
					 inner join imobiliario.v$imovel_finalidade if
							 on if.finalidade_id = i.finalidade_id
					 inner join gis.v$referencia rf
							 on rf.referencia_id = i.referencia_id
					 inner join cep.municipio mun
							 on mun.municipio_id = rf.municipio_id
					 inner join gis.v$bairro b
							 on b.bairro_id = rf.bairro_id
					 inner join imobiliario.v$imovel_imobiliaria ii
					  		 on ii.imovel_id = i.imovel_id
					 where 1=1 ';
				if(strlen(trim($arguments['cod_portal'])))
					$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['tipo_id'])))
					$query .= ' and i.tipo_id = ' . $arguments['tipo_id'];
				if(strlen(trim($arguments['imovel_id'])))
					$query .= ' and i.imovel_id = '.$arguments['imovel_id'].' ';
				if(strlen(trim($arguments['bairro_id'])))
					$query .= ' and bairro_id = ' . $arguments['bairro_id'];
				if(strlen(trim($aruments['municipio_id'])))
					$query .= ' and municipio_id = ' . $arguments['municipio_id'];
				if(strlen(trim($arguments['valor'])))
					$query .= ' and ii.valor >= ' . $arguments['valor'];
					
				if($arguments['aleatorio'] == 1)
					$query .= ' order by dbms_random.value ';

				else
					$query .= ' order by i.titulo';
			$query .= ') 
 			 where 1=1 ';
			if(strlen(trim($arguments['num_imoveis']))) {
				$query .= ' and rownum <= '.$arguments['num_imoveis'];
			}
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os imoveis para exibio */
		function get_imovel_aprovado($arguments=array(),$resulttype='array') {
			$query = '
				select * from (
					select i.imovel_id,
						   i.cod_portal,
						   i.tipo_id,
						   it.descricao as tipo,
						   i.finalidade_id,
						   if.descricao as finalidade,
						   i.titulo,
						   i.descricao,
						   i.area_construida,
						   i.area,
						   (i.atributos).getClobVal() as atributos,
						   i.referencia_id,
						   rf.latitude,
						   rf.longitude,
						   min(rf.latitude) over() as min_latitude,
						   max(rf.latitude) over() as max_latitude,
						   min(rf.longitude) over() as min_longitude,
						   max(rf.longitude) over() as max_longitude,
						   mun.municipio,
						   mun.uf_id as uf,
						   b.descricao as bairro,
						   i.observacoes,
						   to_char(i.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
						   i.user_insert,
						   to_char(i.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
						   i.user_update,
						   ii.valor,
						   to_char(ii.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_char(ii.data_termino,\'dd/mm/yyyy\') as data_termino,
						   ii.tipo_venda_id,
						   i.site';
				if(strlen(trim($arguments['aprovado']))){
					$query .= '
							,f.url_imagem,
							f.nome,
							ifi.financeira_id';
				}
				
				$query .=	'  from imobiliario.v$imovel i
					 inner join imobiliario.v$imovel_tipo it
							 on it.tipo_id = i.tipo_id
					 inner join imobiliario.v$imovel_finalidade if
							 on if.finalidade_id = i.finalidade_id
					 inner join gis.v$referencia rf
							 on rf.referencia_id = i.referencia_id
					 inner join cep.municipio mun
							 on mun.municipio_id = rf.municipio_id
					 inner join gis.v$bairro b
							 on b.bairro_id = rf.bairro_id
					 inner join imobiliario.v$imovel_imobiliaria ii
					  		 on ii.imovel_id = i.imovel_id';
			   if(strlen(trim($arguments['aprovado']))){
			   		$query .= '
					 inner join imobiliario.v$imovel_financeira ifi
					 		 on ifi.imovel_id = i.imovel_id
					 inner join imobiliario.v$financeira f
					 		 on f.financeira_id = ifi.financeira_id ';
				}							 
				$query .= ' where 1=1 ';
				if(strlen(trim($arguments['cod_portal'])))
					$query .= ' and i.cod_portal = \''.$arguments['cod_portal'].'\'';
				if(strlen(trim($arguments['tipo_id'])))
					$query .= ' and i.tipo_id = ' . $arguments['tipo_id'];
				if(strlen(trim($arguments['imovel_id'])))
					$query .= ' and i.imovel_id = '.$arguments['imovel_id'].' ';
				if(strlen(trim($arguments['bairro_id'])))
					$query .= ' and bairro_id = ' . $arguments['bairro_id'];
				if(strlen(trim($aruments['municipio_id'])))
					$query .= ' and municipio_id = ' . $arguments['municipio_id'];
				if(strlen(trim($arguments['valor'])))
					$query .= ' and ii.valor >= ' . $arguments['valor'];
				if(strlen(trim($arguments['destaque'])))
					$query .= ' and i.destaque = ' . $arguments['destaque'];
				if(strlen(trim($arguments['aprovado'])))
					$query .= ' and ifi.imovel_aprovacao_id = (select MAX(ifin.imovel_aprovacao_id)
												from imobiliario.v$imovel_financeira ifin
											   where imovel_id = i.imovel_id)';
					
				if($arguments['aleatorio'] == 1)
					$query .= ' order by dbms_random.value ';

				else
					$query .= ' order by i.titulo';
			$query .= ') 
 			 where 1=1 ';
			if(strlen(trim($arguments['num_imoveis'])))
				$query .= ' and rownum <= '.$arguments['num_imoveis'];			
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca os Grupos de Portais */
		function get_imovel_foto($arguments=array(),$resulttype='array') {			
			$query = '		
			select rf.imovel_id,
				   rf.foto_id,
				   f.url_imagem,
				   f.largura as largura_original,
				   f.altura as altura_original,
				   f.tipo,
				   f.tamanho as tamanho_original,
				   f.categoria_id,
				   rf.titulo,
				   rf.legenda,
				   rf.descricao,
				   rf.credito,
				   rf.largura,
				   rf.altura,
				   rf.ordem,
				   rf.date_insert,
				   rf.user_insert,
				   rf.date_update,
				   rf.user_update,
				   rf.site
			  from imobiliario.v$imovel_foto rf
			 inner join site.v$foto f
					 on f.foto_id = rf.foto_id
						 where 1=1 ';
			if(strlen(trim($arguments['imovel_id'])))
				$query .= ' and rf.imovel_id in ('.$arguments['imovel_id'].') ';
			$query .= ' order by rf.ordem ';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
					
		function get_imovel_video($arguments=array()){
			$query = 
			'select fv.imovel_id,
				   fv.video_id,
				   v.cod_video,
				   v.duracao,
				   fv.ordem,
				   fv.titulo,
				   fv.legenda,
				   fv.descricao,
				   fv.credito,
				   to_char(fv.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   fv.user_insert,
				   to_char(fv.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   fv.user_update,
				   fv.site
			  from imobiliario.v$imovel_video fv
			 inner join site.v$video v
			         on v.video_id = fv.video_id
			 where 1=1 ';
			 if(strlen($arguments['imovel_id']))
			 	$query .= ' and fv.imovel_id in ('.$arguments["imovel_id"].') ';
		  return $this->getResult($query);
		}
		
		function get_imoveis_cidades($arguments=array(),$resulttype='array'){
			$query = 
			'select distinct(m.municipio),m.municipio_id from gis.bairro b
					 inner join cep.municipio m
					  on b.municipio_id = m.municipio_id
			 where 1=1';
			 //print($query);
			 return $this->getResult($query,$resulttype);
		}
		
		function get_imoveis_bairros($arguments=array(),$resulttype='array'){			
			$query = '
			   select b.descricao,b.bairro_id
				from gis.bairro b
				where 1=1';

			if(strlen($arguments['municipio'])){
				$query .= ' and b.municipio_id = ' . $arguments['municipio'];
			}
			$query .= ' order by b.descricao';
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_imovel_imobiliaria($arguments=array(),$resulttype='array'){
				//new dbug($arguments);
				$query = '
					select i.imovel_imobiliaria_id,
						   i.imovel_id,
						   i.imobiliaria_id,
						   to_char(i.data_inicio,\'dd/mm/yyyy\') as data_inicio,
						   to_char(i.data_termino,\'dd/mm/yyyy\') as data_termino,
						   i.tipo_venda_id,
						   i.valor,
						   im.titulo,
						   tv.descricao
						   from imobiliario.v$imovel_imobiliaria i
						  inner join imobiliario.v$imovel im
						    on i.imovel_id = im.imovel_id
						  inner join imobiliario.v$tipo_venda tv
						  	on tv.tipo_venda_id = i.tipo_venda_id
						  where 1=1';
				if(isset($arguments['imovel_id']))
					$query .= ' and i.imovel_id = ' . $arguments['imovel_id'];
				if(isset($arguments['imobiliaria_id']))
					$query .= ' and i.imobiliaria_id = ' .$arguments['imobiliaria_id'];
				
				//print($query);
				return $this->getResult($query,$resulttype);
		}
		
		function get_imovel_favorito($arguments=array(),$resulttype='array'){
			$query .= '
						select i.imovel_id,
							   usuario_imovel_id,
							   usuario,       
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site,
							   i.referencia_id,
							   i.imovel_id,
							   r.latitude,
							   r.longitude,
							   min(r.latitude) over() as min_latitude,
							   max(r.latitude) over() as max_latitude,
							   min(r.longitude) over() as min_longitude,
							   max(r.longitude) over() as max_longitude
						  from imobiliario.v$imovel_favorito if
						   inner join imobiliario.v$imovel i on i.imovel_id = if.imovel_id
						   inner join gis.v$referencia r on i.referencia_id = r.referencia_id
						 where 1 = 1 ';
				if(isset($arguments['usuario']))
					$query .= ' and usuario = \''. $arguments['usuario'] . '\'';
				if(isset($arguments['imovel_id']))
					$query .= ' and imovel_id = ' . $arguments['imovel_id'];
					
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/* Seleciona as financeiras */
		function get_financeira($arguments=array(),$resulttype='array'){
			$query .= '
						select financeira_id,
							   nome,
							   url_imagem
						  from imobiliario.v$financeira
						 where 1=1
						and cod_portal = \'' . $arguments['cod_portal'] . '\'';
			  if(strlen(trim($arguments['financeira_id'])))
			  	$query .= ' and financeira_id = ' . $arguments['financeira_id'];
			  if(strlen(trim($arguments['nome'])))
			  	$query .= ' and nome like \'%' . $arguments['nome'] . '%\'';
			
			//print($query);			
			return $this->getResult($query,$resulttype);
		}
		
		/* Seleciona vinculos de imveis com financeiras */
		function get_imovel_financeira($arguments=array(),$resulttype='array'){
			$query .= '
						select  imovel_aprovacao_id,
								imovel_id,
								financeira_id
						  from imobiliario.v$imovel_financeira
						 where 1=1 ';
			if(strlen(trim($arguments['imovel_id'])))
			 	$query .= ' and imovel_id = ' . $arguments['imovel_id'];
			if(strlen(trim($arguments['financeira_id'])))
				$query .= ' and financeira_id = ' . $arguments['financeira_id'];
			
			return $this->getResult($query,$resulttype);
		}
		
		function get_financeiras_imovel($arguments=array(),$resulttype='array'){
			$query .= '
						select ifi.financeira_id,
							   ifi.imovel_id,
							   f.nome,
							   f.url_imagem
							   
					     from imobiliario.v$imovel_financeira ifi
						   inner join imobiliario.v$financeira f
						   	on f.financeira_id = ifi.financeira_id
						   inner join imobiliario.v$imovel i
						   	on i.imovel_id = ifi.imovel_id 
					    where 1=1 ';
				if(strlen(trim($arguments['imovel_id'])))
					$query .= ' and ifi.imovel_id = '.$arguments['imovel_id'];
				if(strlen(trim($arguments['financeira_id'])))
					$query .= ' and ifi.financeira_id = '.$arguments['financeira_id'];

			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_cidade_localizacao($arguments=array(),$resulttype='array'){
			$query .= ' select municipio,
							   municipio_id,
							   oper.pkg_coord_geografica.FNC_GRAUS2DECIMAIS(latitude) as latitude,
       						   oper.pkg_coord_geografica.FNC_GRAUS2DECIMAIS(longitude) as longitude	
						  from cep.municipio
						 where 1=1';
			if(strlen(trim($arguments['municipio']))) 
				$query .= ' and municipio like\'%'.$arguments['municipio'].'%\'';
				
			return $this->getResult($query,$resulttype);
		}
		
	}
	global $conexao_banco;
	$ImobiliarioComObj = new ImobiliarioCom($conexao_banco);
}

global $createdObject;
$createdObject = $ImobiliarioComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>