<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $MapaComObj;
if(!$MapaComObj) {
	class MapaCom extends QueryCom {
		/* Busca os Grupos de Portais */
		function get_referencia_tipo($arguments=array(),$resulttype='array') {
			$query = 
			'select tipo_id,
				    tipo_id_pai,
				    level,
				    lpad(\' \',level-1,\' \') ident,
				    descricao,
			 	    date_insert,
			 	    user_insert,
			 	    date_update,
			 	    user_update,
			 	    site
			   from gis.v$referencia_tipo
		      where 1=1 ';
			if(strlen(trim($arguments['tipo_id'])))
				$query .= ' and tipo_id in ('.$arguments[tipo_id].') ';
			$query .= ' start with tipo_id_pai is null 
			connect by tipo_id_pai = prior tipo_id ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os Grupos de Portais */
		function get_referencia($arguments=array(),$resulttype='array') {
			$query = '
			select r.referencia_id,
				   r.tipo_id,
				   rt.descricao as tipo,
				   r.nome,
				   r.descricao,
				   r.cep,
				   r.logradouro,
				   r.numero,
				   r.complemento,
				   r.bairro_id,
				   b.descricao as bairro,
				   r.municipio_id,
				   m.municipio,
				   r.uf,
				   r.latitude,
				   r.longitude,
				   r.situacao_id,
				   r.email_cadastro,
				   to_char(r.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   r.user_insert,
				   to_char(r.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   r.user_update,
				   r.site
			  from gis.v$referencia r
			 inner join gis.v$referencia_tipo rt
			         on rt.tipo_id = r.tipo_id
			 inner join gis.v$bairro b
			         on b.bairro_id = r.bairro_id 
			 inner join cep.municipio m
			         on m.municipio_id = r.municipio_id
			 where 1=1 ';
			if(strlen(trim($arguments['referencia_id'])))
				$query .= ' and r.referencia_id in ('.$arguments['referencia_id'].') ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and cod_portal = \''.$arguments['cod_portal'].'\'';
			$query .= ' order by rt.descricao,r.nome ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os Grupos de Portais */
		function get_referencia_foto($arguments=array(),$resulttype='array') {
			$query = '		
			select rf.referencia_id,
				   rf.foto_id,
				   f.url_imagem,
				   f.largura as largura_original,
				   f.altura as altura_original,
				   f.tipo,
				   f.tamanho as tamanho_original,
				   f.categoria_id,
				   rf.titulo,
				   rf.legenda,
				   rf.descricao,
				   rf.credito,
				   rf.largura,
				   rf.altura,
				   rf.ordem,
				   rf.date_insert,
				   rf.user_insert,
				   rf.date_update,
				   rf.user_update,
				   rf.site
			  from gis.v$referencia_foto rf
			 inner join site.v$foto f
					 on f.foto_id = rf.foto_id
						 where 1=1 ';
			if(strlen(trim($arguments['referencia_id'])))
				$query .= ' and rf.referencia_id in ('.$arguments['referencia_id'].') ';
			$query .= ' order by rf.ordem ';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca os Endereo */
		function get_endereco($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			$query = 'select m.municipio_id, log.cep8_log as cep,            
						   initcap(tit.abrev_tipo || \'.\' || \'  \' || log.nome_log) as logradouro,            
						   initcap(decode(loc.tipo_local, \'D\', \'Dist. \' || initcap(loc.nome_local),  
						   decode(loc.tipo_local,\'P\', \'Pov. \' || initcap(loc.nome_local) , 
						   initcap(bai.extenso_bai)))) as bairro,            
						   initcap(bai2.extenso_bai) as bairro2,            
						   m.municipio as local,            
						   uf.sigla_uf as uf, loc.cod_uf, 
						   loc.cod_municipio, loc.cod_distrito, loc.cod_dv
					  from cep.cep_log log
					 inner join cep.cep_tit tit
							 on log.chave_tipo = tit.chave_tipo
					 inner join cep.cep_bai bai
							 on log.chvbai1_log = bai.chave_bai
							and log.chave_local = bai.chave_local
					 inner join cep.cep_loc loc
							 on log.chave_local = loc.chave_local     
					 inner join cep.cep_ufs uf
							 on loc.sigla_uf = uf.sigla_uf     
					  left join cep.cep_bai bai2
							 on log.chvbai2_log = bai2.chave_bai
							and log.chave_local = bai2.chave_local
					 left join cep.municipio m
							 on loc.municipio_id = m.municipio_id 
					
					 where log.cep8_log = '.$arguments['cep'].'
											
					union          
												
					select m.municipio_id, decode(loc.sit_local,\'0\', loc.cep8_local, log.cep8_log)  as cep,             
						   decode(loc.sit_local,\'0\', \'No codificado - Preencha com seu logradouro\',  log.nome_log )  as logradouro,             
						   decode(loc.tipo_local, \'D\', \'DIST. \' || loc.nome_local,  decode(loc.tipo_local,\'P\', \'POV. \' || loc.nome_local , 
						   bai.extenso_bai)) as bairro,             
						   initcap(bai2.extenso_bai),             
						   m.municipio as local,             
						   uf.sigla_uf as uf, 
						   loc.cod_uf, 
						   loc.cod_municipio, 
						   loc.cod_distrito, 
						   loc.cod_dv
					  from cep.cep_loc loc
					 inner join cep.cep_ufs uf
							 on loc.sigla_uf = uf.sigla_uf       
					  left join cep.cep_loc loc2
							 on loc.subor_local =  loc2.chave_local
					  left join cep.cep_log log 
							 on loc.chave_local =  log.chave_local
					  left join cep.cep_bai bai 
							 on log.chvbai1_log  =  bai.chave_bai
							and log.chave_local = bai.chave_local
					  left join cep.cep_bai bai2
							 on log.chvbai2_log  =  bai2.chave_bai
							and log.chave_local = bai2.chave_local
					 left join cep.municipio m
							 on loc.municipio_id = m.municipio_id 
				   
					where loc.cep8_local = '.$arguments['cep'].'
												
					union    
					
					select m.municipio_id, esp.cep8_esp as cep,            
						   initcap(esp.nome_esp || esp.comple_esp) as logradouro,            
						   initcap(bai.extenso_bai) as bairro,            
						   m.municipio as local,            
						   initcap(bai.extenso_bai) as bairro,            
						   esp.uf_esp as uf, 
						   loc.cod_uf, 
						   loc.cod_municipio, 
						   loc.cod_distrito, 
						   loc.cod_dv
					  from cep.cep_loc loc
					 inner join cep.cep_esp esp
							 on esp.chave_local = loc.chave_local     
					 inner join cep.cep_bai bai
							 on esp.chave_bai = bai.chave_bai     
							and esp.chave_local = bai.chave_local
					 inner join cep.municipio m
							 on loc.municipio_id = m.municipio_id 
				   
					 where esp.cep8_esp = '.$arguments['cep'].'
					
					union    
					
					select m.municipio_id, 
						   agp.cep8_agp as cep,            
						   initcap(agp.nome_agp) as logradouro,            
						   initcap(bai.extenso_bai) as bairro,            
						   m.municipio as local,            
						   initcap(bai.extenso_bai) as bairro,            
						   agp.uf_agp as uf, 
						   loc.cod_uf, 
						   loc.cod_municipio, 
						   loc.cod_distrito, 
						   loc.cod_dv
					  from cep.cep_loc loc
					 inner join cep.cep_agp agp
							 on agp.chave_local = loc.chave_local     
					 inner join cep.cep_bai bai
							 on agp.chave_bai = bai.chave_bai     
							and agp.chave_local = bai.chave_local 
					 inner join cep.municipio m
							 on loc.municipio_id = m.municipio_id 
					 
					 where agp.cep8_agp = '.$arguments['cep'];
					 
				if($this->dbtype == "postgresql")
					$query = str_replace('v$','',$query);
				//print($query);
		    return $this->getResult($query,$resulttype);
		 }	
		 
		 /* Busca os Grupos de Portais */
		function get_paises($arguments=array(),$resulttype='array') {
			$query = '	select p.pais_id,
							   p.descricao
					      from cep.pais p
						 where 1=1 ';


			$query .= ' order by p.descricao ';

			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
		    return $this->getResult($query,$resulttype);
		}
		
		function get_pais_uf($arguments=array(),$resulttype='array') {
			$query = 'select distinct(UF_ID)

							from cep.municipio where pais_id ='.$arguments['pais_id'];
			
				//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_uf_municipio($arguments=array(),$resulttype='array') {
			$query = 'select MUNICIPIO,MUNICIPIO_ID, UF_ID
						from cep.municipio
						where 1=1 ';
			if(strlen(trim($arguments['uf_id'])))
				$query .= '	and uf_id = \''.$arguments['uf_id'].'\'';
			if(strlen(trim($arguments['municipio_id'])))
				$query .= ' and municipio_id = '.$arguments['municipio_id'];
				
				//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_uf($arguments=array(),$resulttype='array') {
			$query = 'select t.nome_uf as nome,
							 t.sigla_uf as sigla
				        from cep.cep_ufs t
						where 1=1 ';
			if(strlen(trim($arguments['uf'])))
				$query .= '	and sigla_uf = \''.$arguments['uf'].'\'';
				
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		 
		 
	}
	global $conexao_banco;
	$MapaComObj = new MapaCom($conexao_banco);
}

global $createdObject;
$createdObject = $MapaComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}

?>