<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $EventosConsultaObj;
if(!$EventosConsultaObj) {
	class EventosConsulta extends QueryCom {
		

		/*
		 *  Busca os eventos da agenda
		 */
		function get_agenda($arguments=array(),$resulttype='array'){

			$query = 'select agenda_id,
							   nome,
							   to_char(data_inicio,\'dd/mm/yyyy hh24:mi\') as data_inicio,
							   to_char(data_inicio,\'dd/mm/yyyy\') as data,
							   data_inicio as data_inicio_comp,
							   to_char(data_termino,\'dd/mm/yyyy hh24:mi\') as data_termino,							   
							   data_termino as data_termino_comp,
							   local,
							   a.categoria_id,
							   endereco,
							   detalhes,
							   foto_id,
							   ingresso,
							   ponto_venda,
							   bonus_id,
							   lista_vip,
							   data_inicio_lista,
							   data_termino_lista,
							   a.cod_portal,
							   site_local,
							   c.descricao as categoria,
							   informacoes
						  from eventos.v$agenda a
						 left join eventos.v$categoria c on c.categoria_id = a.categoria_id

						 where 1=1

					 and a.cod_portal = \''.$arguments['cod_portal'].'\'';
					 
					 
			if(strlen(trim($arguments['agenda_id'])))
				$query .= ' and agenda_id = '.$arguments['agenda_id'];
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and a.categoria_id = '.$arguments['categoria_id'];
			if(strlen(trim($arguments['lista_vip'])))
				$query .= ' and lista_vip = '.$arguments['lista_vip'];
			if(strlen(trim($arguments['bonus_id'])))
				$query .= ' and bonus_id is not null ';
			if(strlen(trim($arguments['not_agenda_id'])))
				$query .= ' and agenda_id <> '.$arguments['not_agenda_id'];
			if(strlen(trim($arguments['nome'])))
				$query .= ' and nome like \'%'.$arguments['nome'].'%\'';
			if(strlen(trim($arguments['data_inicio'])))
				$query .= ' and trunc(data_inicio) >= \''.$arguments['data_inicio'].'\'';
			if(strlen(trim($arguments['data_termino'])))
				$query .= ' and trunc(data_inicio) <= \''.$arguments['data_termino'].'\'';
			// Inserido o parâmetro "data_final" para poder consultar os eventos da agenda do portal Play Acoustic Bar
			if(strlen(trim($arguments['data_final'])))
				$query .= ' and ((trunc(data_termino) >= \''.$arguments['data_final'].'\') or (trunc(data_inicio) >= \''.$arguments['data_final'].'\'))';
			if(strlen(trim($arguments['ano'])))
				$query .= ' and to_char(data_inicio,\'yyyy\') = \''.$arguments['ano'].'\'';
			if(strlen(trim($arguments['mes'])))
				$query .= ' and to_char(data_inicio,\'mm\') = \''.$arguments['mes'].'\'';
			if(strlen(trim($arguments['dia'])))
				$query .= ' and to_char(data_inicio,\'dd\') = \''.$arguments['dia'].'\'';
			if(strlen(trim($arguments['ultimos'])))
				$query .= ' and data_inicio >= sysdate-'.$arguments['ultimos'];
			if(strlen(trim($arguments['order'])))
				$query .= ' order by data_inicio_comp ASC';
				
			if(strlen(trim($arguments['set_order'])))
				$query .= $arguments['set_order'];	
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/*
		 *  Busca os eventos da agenda
		 */
		function get_categoria($arguments=array(),$resulttype='array'){

			$query = 'select categoria_id,
							   descricao,
							   cod_portal,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from eventos.v$categoria c

						 where 1=1

					 and cod_portal = \''.$arguments['cod_portal'].'\'';
					 
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and categoria_id = '.$arguments['categoria_id'];
			if(strlen(trim($arguments['order'])))
				$query .= ' order by descricao';
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		 *  Busca os eventos da lista vip do usuario
		 */
		function get_usuario_agenda($arguments=array(),$resulttype='array'){

			$query = '	select a.agenda_id,
							   a.nome,
							   to_char(a.data_inicio,\'dd/mm/yyyy hh24:mi\') as data_inicio,
							   a.data_inicio as data_inicio_comp,
							   to_char(a.data_termino,\'dd/mm/yyyy hh24:mi\') as data_termino,                 
							   a.data_termino as data_termino_comp,
							   a.local,
							   a.endereco,
							   a.detalhes,
							   a.foto_id,
							   a.ingresso,
							   a.ponto_venda,
							   a.bonus_id,
							   a.lista_vip,
							   a.data_inicio_lista,
							   a.data_termino_lista,
							   a.cod_portal				
						
						
						from eventos.v$usuario_agenda ua
						inner join eventos.v$agenda a on a.agenda_id = ua.agenda_id';
			
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and usuario = \''.$arguments['usuario'].'\'';
			if(strlen(trim($arguments['agenda_id'])))
				$query .= ' and agenda_id = '.$arguments['agenda_id'];
			if(strlen(trim($arguments['data_inicio'])))
				$query .= ' and data_inicio >= \''.$arguments['data_inicio'].'\'';
			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		*
		* Retorna todos os Locais de Baladas
		*/
		function get_local($arguments=array(),$resulttype='array') {
		
			$query = 'select ba.local_id,
						   ba.cod_portal,
						   ba.nome,
						   ba.descricao,
						   ba.logotipo_id,
						   ba.ativo,
						   ba.date_insert,
						   ba.user_insert,
						   ba.date_update,
						   ba.user_update,
						   ba.site
					  from baladas.v$local ba
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and ba.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['local_id']))
					  	$query .= ' and ba.local_id = '.$arguments['local_id'];
				
				$query .= ' order by ba.date_insert desc';
			
			return $this->getResult($query,$resulttype);
		
		}
		
		
		function get_local_exibicao($arguments=array(),$resulttype='array') {
		
			$query .= 'select  ba.local_id,
						   ba.cod_portal,
						   ba.nome,
						   ba.descricao,
						   ba.logotipo_id,
						   ba.ativo,
						   ba.date_insert,
						   ba.user_insert,
						   ba.date_update,
						   ba.user_update,
						   ba.site,
						   co.date_insert              
						from baladas.v$local ba
						left join baladas.v$cobertura co
						on co.local_id = ba.local_id           
						where 1=1';
						if(strlen($arguments['cod_portal']))
					  		$query .= ' and ba.cod_portal = \''.$arguments['cod_portal'].'\'';	
						if(strlen($arguments['local_id']))
					  		$query .= ' and ba.local_id = '.$arguments['local_id'];					
						
				$query .= ' order by co.date_insert desc';
			
			return $this->getResult($query,$resulttype);
		
		}
		
		
		/*
		*
		* Retorna todas as fotos do Local
		*/
		function get_local_foto($arguments=array(),$resulttype='array') {
			
			$query = 'select lc.local_id,
						   lc.foto_id,
						   lc.ordem,
						   lc.titulo,
						   lc.credito,
						   lc.legenda,
						   lc.descricao,
						   lc.altura,
						   lc.largura,
						   lc.date_insert,
						   lc.user_insert,
						   lc.date_update,
						   lc.user_update,
						   lc.site
					  from baladas.v$local_foto lc
					  where 1=1';
					  if(strlen($arguments['local_id']))
					  	$query .= ' and lc.local_id = '.$arguments['local_id'];
			
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		*
		* Retorna todos os Eventos do Local
		*/		
		function get_evento($arguments=array(),$resulttype='array') {
			
			$query = 'select ev.evento_id,
						   ev.cod_portal,
						   ev.titulo,
						   ev.local_id,
						   ev.data_inicio,
						   to_char(ev.data_inicio, \'DD/MM/YYYY\') as data_inicio_exibicao,
						   ev.data_termino,
						   to_char(ev.data_termino, \'DD/MM/YYYY\') as data_termino_exibicao,
						   ev.exibir_ate,
						   to_char(ev.exibir_ate, \'DD/MM/YYYY\') as data_limite,
						   ev.descricao,
						   ev.logotipo_id,
						   ev.date_insert,
						   ev.user_insert,
						   ev.date_update,
						   ev.user_update,
						   ev.site
					  from baladas.v$evento ev
					  inner join baladas.v$local ba
            			on ba.local_id = ev.local_id
					  where 1=1
					      and cod_portal = \''.$arguments['cod_portal'].'\' ';
						  
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ev.evento_id = '.$arguments['evento_id'];
				      if(strlen($arguments['local_id']))
					  	$query .= ' and ba.local_id = '.$arguments['local_id'];
					  if(strlen($arguments['ordenar'])){
					  	if($arguments['ordenar'] == 'ultimo')
							$query .= ' order by ev.date_insert desc';
						if($arguments['ordenar'] == 'random')
							$query .= ' order by dbms_random.random';
						if($arguments['ordenar'] == 'alfa')
							$query .= ' order by ev.titulo asc';
						if($arguments['ordenar'] == 'termino')
							$query .= ' order by ev.data_termino asc';
					  } else {
					  	$query .= ' order by ev.date_insert desc';
					  }				 
				//print($query);
			return $this->getResult($query,$resulttype);
			
		}
		
		
		function get_evento_foto($arguments=array(),$resulttype='array') {
			
			$query = 'select ef.evento_id,
						   ef.foto_id,
						   ef.ordem,
						   ef.titulo,
						   ef.credito,
						   ef.legenda,
						   ef.descricao,
						   ef.altura,
						   ef.largura,
						   ef.date_insert,
						   ef.user_insert,
						   ef.date_update,
						   ef.user_update,
						   ef.site
					  from baladas.v$evento_foto ef
					  where 1=1';
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ef.evento_id = \''.$arguments['evento_id'].'\'';
			
			return $this->getResult($query,$resulttype);
			
		}
		
		/*
		*
		* Retorna todas as coberturas do Evento
		*/		
		function get_cobertura($arguments=array(),$resulttype='array') {
			
			$query = 'select co.cobertura_id,
						   co.cod_portal,
						   co.local_id,
						   co.evento_id,
						   co.data,
						   to_char(co.data, \'DD/MM/YYYY\') as data_exibicao,
						   co.logotipo_id,
						   co.date_insert,
						   co.user_insert,
						   co.date_update,
						   co.user_update,
						   co.site,
						   co.titulo,
						   co.descricao,
						   ev.evento_id,
						   ev.titulo as titulo_evento
					  from baladas.v$cobertura co
					  left join baladas.v$evento ev
            		  on ev.evento_id = co.evento_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and co.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['cobertura_id']))
					  	$query .= ' and co.cobertura_id = '.$arguments['cobertura_id'];
					  if(strlen($arguments['local_id']))
					  	$query .= ' and co.local_id = '.$arguments['local_id'];
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ev.evento_id = '.$arguments['evento_id'];	
						
			
					$query .= ' order by co.data desc';
			  //print($query);
			return $this->getResult($query,$resulttype);
			
		}
		
		
		/*
		*
		* Retorna todas as fotos da cobertura
		*/
		function get_cobertura_foto($arguments=array(),$resulttype='array') {
		
			$query = 'select cf.cobertura_id,
						   cf.foto_id,
						   cf.ordem,
						   cf.titulo,
						   cf.credito,
						   cf.legenda,
						   cf.descricao,
						   cf.altura,
						   cf.largura,
						   cf.date_insert,
						   cf.user_insert,
						   cf.date_update,
						   cf.user_update,
						   cf.site,
						   co.titulo as titulo_cobertura,
						   co.data
					  from baladas.v$cobertura_foto cf
					  inner join baladas.v$cobertura co
            		  on co.cobertura_id = cf.cobertura_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and co.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['cobertura_id']))
					  	$query .= ' and cf.cobertura_id = '.$arguments['cobertura_id'];
					  if(strlen(trim($arguments['primeira_foto']))){
					  	$query .= ' and ordem = (select min(c2.ordem)
												   from baladas.v$cobertura_foto c2
												  where c2.cobertura_id = co.cobertura_id) ';
					  }
				$query .= ' order by co.data desc,cf.ordem ';
				
				//print($query);
			return $this->getResult($query,$resulttype);
		
		}
		
		/*
		*
		* Retorna as coberturas para listagem da aplicação
		*/
		function get_cobertura_listagem($arguments=array(),$resulttype='array') {
			
			$query = 'select cb.cobertura_id,
						   cb.cod_portal,
						   cb.local_id,
						   cb.evento_id,
						   cb.data,
						   to_char(cb.data, \'DD/MM/YYYY\') as data_exibicao,
						   cb.logotipo_id,
						   cb.date_insert,
						   cb.user_insert,
						   cb.date_update,
						   cb.user_update,
						   cb.site,
						   cb.titulo as titulo_cobertura,
						   cb.descricao,						  
						   ev.titulo,
						   ev.data_inicio,
						   ev.data_termino,
						   ev.descricao as descricao_evento,
						   ev.logotipo_id as logotipo_evento      
					  from baladas.v$cobertura cb					  
					  left join baladas.v$evento ev
					  on ev.evento_id = cb.evento_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and cb.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['local_id']))
					  	$query .= 'and cb.local_id = '.$arguments['local_id'];
					  if(strlen(trim($arguments['mes'])))
					  	$query .= ' and to_char(cb.data,\'mm\') = \''.$arguments['mes'].'\'';
					  if(strlen(trim($arguments['ano'])))
					  	$query .= ' and to_char(cb.data,\'yyyy\') = \''.$arguments['ano'].'\'';
					  
			$query .= ' order by cb.date_insert desc';
			//print($query);
			return $this->getResult($query,$resulttype);
			
		}
		
		
		/*
		*
		* Retorna as coberturas por mes
		*/
		function get_coberturas_mes($arguments=array(),$resulttype='array') {
			
			$query = ' select distinct(to_char(c.data,\'yyyy/mm\')) as ano_mes

						 from baladas.v$cobertura c
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and c.cod_portal = \''.$arguments['cod_portal'].'\'';
					  
			$query .= ' order by ano_mes desc';
			
			return $this->getResult($query,$resulttype);
		}
		
		
		
		/*
		*
		* Retorna todas os balcoes de negocio
		*/
		function get_balcao_negocio($arguments=array(),$resulttype='array') {
			
			$query = 'select balcao_negocio_id,
							   num_inscricao,
							   nome,
							   email,
							   telefone,
							   celular,
							   cod_portal,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site,
							   estado,
							   cnpj_cpf,
							   rg,
							   logradouro,
							   bairro,
							   cidade,
							   cep,
							   forma_pagamento,
							   valor,
							   parcelas,
							   valor_parcela,
							   data_parcela
						  from eventos.v$balcao_negocio
					  where 1=1
					   and cod_portal = \''.$arguments['cod_portal'].'\'';
					   
					  if(strlen($arguments['balcao_negocio_id']))
					  	$query .= ' and balcao_negocio_id = '.$arguments['balcao_negocio_id'];
					  if(strlen($arguments['nome']))
					  	$query .= ' and upper(nome) like upper(\'%'.$arguments['nome'].'%\')';
					  if(strlen($arguments['email']))
					  	$query .= ' and upper(email) like upper(\'%'.$arguments['email'].'%\')';
					  if(strlen($arguments['cnpj_cpf']))
					  	$query .= ' and cnpj_cpf = \''.$arguments['cnpj_cpf'].'\'';
				      if(strlen($arguments['ordem']))
					  	$query .= ' order by '.$arguments['ordem'];
					  else
						$query .= ' order by nome';
				
				//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		/*
		*
		* Retorna todos os projetos
		*/
		function get_projeto($arguments=array(),$resulttype='array') {
			
			$query = 'select p.projeto_id,
							   p.titulo,
							   p.subtitulo,
							   p.descricao,
							   p.secao_id,
							   s.descricao as secao,
							   p.interno,
							   p.cod_portal,
							   p.date_insert,
							   p.user_insert,
							   p.date_update,
							   p.user_update,
							   p.site
						  from eventos.v$projeto p
						  left join jornal.v$secao s on s.secao_id = p.secao_id
					  where 1=1
					   and p.cod_portal = \''.$arguments['cod_portal'].'\'';
					   
					  if(strlen($arguments['projeto_id']))
					  	$query .= ' and p.projeto_id = '.$arguments['projeto_id'];
					  if(strlen($arguments['secao_id']))
					  	$query .= ' and p.secao_id = '.$arguments['secao_id'];
					  if(strlen($arguments['titulo']))
					  	$query .= ' and upper(p.titulo) like upper(\'%'.$arguments['titulo'].'%\')';
					  if(strlen($arguments['subtitulo']))
					  	$query .= ' and upper(p.subtitulo) like upper(\'%'.$arguments['subtitulo'].'%\')';
					  if(strlen($arguments['interno']))
					  	$query .= ' and p.interno = '.$arguments['interno'];
				      if(strlen($arguments['ordem']))
					  	$query .= ' order by '.$arguments['ordem'];
					  else
						$query .= ' order by p.titulo';
				
				//print($query);
			return $this->getResult($query,$resulttype);		
		}
		
		
		/*
		*
		* Retorna todas as fotos do projeto
		*/
		function get_projeto_foto($arguments=array(),$resulttype='array') {
			
			$query = 'select p.projeto_foto_id,
							   p.projeto_id,
							   p.foto_id,
							   p.ordem,
							   a.categoria_id,
							   p.date_insert,
							   p.user_insert,
							   p.date_update,
							   p.user_update,
							   p.site
						  from eventos.v$projeto_foto p
						  inner join site.v$arquivo a on a.arquivo_id = p.foto_id

					  where 1=1 ';
					   
					  if(strlen($arguments['projeto_id']))
					  	$query .= ' and p.projeto_id = '.$arguments['projeto_id'];
					  if(strlen($arguments['projeto_foto_id']))
					  	$query .= ' and p.projeto_foto_id = '.$arguments['projeto_foto_id'];

				      if(strlen($arguments['ordem']))
					  	$query .= ' order by '.$arguments['ordem'];
					  else
						$query .= ' order by p.ordem';
				
				//print($query);
			return $this->getResult($query,$resulttype);		
		}
		
		
	/*final das funções*/
	}
	global $conexao_banco;
	$EventosConsultaObj = new EventosConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $EventosConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>