<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
global $ComentarioConsultaObj;
if(!$ComentarioConsultaObj) {
	class ComentarioConsulta extends QueryCom {

		/* Busca os comentarios da noticia */
		function get_noticia_comentario($arguments=array(),$resulttype='array') {
			$query = '
				select c.comentario_id,
					   c.assunto,
					   c.texto,
					   c.nota_id,
					   to_char(c.data_insercao,\'dd/mm/yyyy hh24:mi:ss\') as data_insercao,
					   c.usuario_insercao,
					   u.nome as nome_usuario,
					   u.cidade||\'-\'||u.uf as cidade_usuario,					   
					   to_char(c.data_aprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_aprovacao,
					   c.usuario_aprovacao,
					   to_char(c.data_reprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_reprovacao,
					   c.usuario_reprovacao,
					   c.status,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site,
					   c.nome,
					   c.aprovado,
					   c.usuario_abusivo,
					   c.tipo_id,
					   c.texto_abusivo,
					   c.nome_abusivo,
					   n.titulo,
					   n.noticia_id,
					   n.data_publicacao
				  from jornal.v$comentario c
				 inner join jornal.v$noticia_comentario nc
						 on nc.comentario_id = c.comentario_id
				 inner join acesso.v$usuario u
				         on u.email = c.usuario_insercao
			     inner join jornal.v$noticia n
				 		 on n.noticia_id = nc.noticia_id
				 where 1=1 
				  and cod_portal = \'' .$arguments['cod_portal'] . '\'';
				 
			if(strlen(trim($arguments['status'])))
				$query .= ' and c.status = '.$arguments['status'];
			if(strlen(trim($arguments['noticia_id'])))
				$query .= ' and nc.noticia_id = '.$arguments['noticia_id'];
			if(strlen(trim($arguments['comentario_id'])))
				$query .= ' and c.comentario_id = ' . $arguments['comentario_id'];
			if(strlen(trim($arguments['tipo'])))
				$query .= ' and c.tipo_id = ' . $arguments['tipo'];
			if(strlen(trim($arguments['data_inicio'])))
				$query .= ' and trunc(data_insercao) >= \'' . $arguments['data_inicio'] . '\'';
			if(strlen(trim($arguments['data_termino'])))
				$query .= ' and trunc(data_insercao) <= \'' . $arguments['data_termino'] . '\'';
				
			$query .= ' and u.grupo_id = \''.$_SESSION['grupo_id'].'\'';
			if(strlen(trim($arguments['ordem'])))
				switch($arguments['ordem']){
					case 'NOTICIA': $query .= ' order by data_publicacao desc,titulo'; break;
					case 'DATA':	$query .= ' order by c.data_insercao desc';break;
					default: $query .= ' order by tipo,data'; break;
				}				
			else
				$query .= ' order by c.data_insercao desc ';
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		/* Busca os comentarios de noticias e de blogs */
		function get_comentarios_gerais($arguments=array(),$resulttype='array') {
			//new dBug($arguments);
			$query = '
				select c.comentario_id,       
					   c.texto,
					   c.assunto,
					   c.nota_id,
					   to_char(c.data_insercao, \'dd/mm/yyyy hh24:mi:ss\') as data_insercao,
					   c.usuario_insercao,
					   u.nome as nome_usuario,
					   u.cidade || \'-\' || u.uf as cidade_usuario,
					   to_char(c.data_aprovacao, \'dd/mm/yyyy hh24:mi:ss\') as data_aprovacao,
					   c.usuario_aprovacao,
					   to_char(c.data_reprovacao, \'dd/mm/yyyy hh24:mi:ss\') as data_reprovacao,
					   c.usuario_reprovacao,
					   c.status,
					   to_char(c.date_insert, \'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update, \'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site,
					   c.nome,
					   c.aprovado,
					   c.usuario_abusivo,
					   c.tipo_id,
					   c.texto_abusivo,
					   c.nome_abusivo,';
					   
					   switch($arguments['exibir']){
					   	  case 'BLOG': $query .= 'b.titulo || \' - \' || bm.titulo as titulo,
						  						  bm.data_envio,
												  bm.data_envio as data_publicacao,
					   							  b.blog_id,'; 
									   break;
						  case 'NOTICIAS': $query .= 'n.titulo,
						  							 n.data_publicacao,';
									   break;
						  default: $query .= 'nvl(n.titulo,b.titulo || \' - \' || bm.titulo) as titulo,
						  					  nvl(n.data_publicacao,bm.data_envio) as data_publicacao,
											  bm.data_envio as data_envio,
					   						  b.blog_id,';
									   break;
					   }
			$query .= 'n.noticia_id
					   
				    from jornal.v$comentario c
						 left join jornal.v$noticia_comentario nc on nc.comentario_id = c.comentario_id
						 left join acesso.v$usuario u on u.email = c.usuario_insercao
						 left join jornal.v$noticia n on n.noticia_id = nc.noticia_id ';
			if(($arguments['exibir'] == 'BLOG') || ($arguments['exibir'] == "AMBOS")){
				$query .= '
						 left join jornal.v$blog_mensagem_comentario bmc on bmc.comentario_id = c.comentario_id
						 left join jornal.v$blog_mensagem bm on bm.mensagem_id = bmc.mensagem_id
						 left join jornal.v$blog b on bm.blog_id = b.blog_id';
			}

			$query .= '

				where 1 = 1

				   and (';
			switch($arguments['exibir']){	   
				case 'NOTICIAS': $query .= ' n.cod_portal = \''.$arguments['cod_portal'].'\')';break;
				case 'BLOG': $query .=  ' b.cod_portal = \'' .$arguments['cod_portal'] .'\')';break;
				default: $query .= ' n.cod_portal = \''.$arguments['cod_portal'] . '\' or b.cod_portal = \'' .$arguments['cod_portal'] .'\')';break;
			}
			if(strlen(trim($arguments['status'])))
				$query .= ' and c.status = '.$arguments['status'];
			if(strlen(trim($arguments['noticia_id'])))
				$query .= ' and nc.noticia_id = '.$arguments['noticia_id'];
			if(strlen(trim($arguments['comentario_id'])))
				$query .= ' and c.comentario_id = ' . $arguments['comentario_id'];
			if(strlen(trim($arguments['tipo'])))
				$query .= ' and c.tipo_id = ' . $arguments['tipo'];
			if(strlen(trim($arguments['data_inicio'])))
				$query .= ' and trunc(data_insercao) >= \'' . $arguments['data_inicio'] . '\'';
			if(strlen(trim($arguments['data_termino'])))
				$query .= ' and trunc(data_insercao) <= \'' . $arguments['data_termino'] . '\'';
			if(strlen(trim($arguments['num_dias'])))
				$query .= ' and c.date_insert >= sysdate - '.$arguments['num_dias'];
			if(strlen(trim($arguments['ordem'])))
				switch($arguments['ordem']){
					case 'NOTICIA': $query .= ' order by data_publicacao desc,titulo'; break;
					case 'DATA':	$query .= ' order by c.data_insercao desc';break;
					default: $query .= ' order by tipo,data'; break;
				}				
			else
				$query .= ' order by c.data_insercao desc ';
				
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		function get_comentario_noticia($arguments=array(),$resulttype='array') {
			$query = 'select  nc.comentario_id,
								n.noticia_id,
								n.titulo,
								n.data_publicacao,
								n.subtitulo,
								n.texto,
								n.autor
								
						from jornal.v$noticia n
						inner join jornal.v$noticia_comentario nc
						 on nc.noticia_id = n.noticia_id
						
						where 1=1';
						
				if(isset($arguments['comentario_id']))
					$query .= ' and nc.comentario_id = ' . $arguments['comentario_id'];
				if(isset($arguments['noticia_id']))
					$query .= ' and n.noticia_id = ' . $arguments['noticia_id'];
			 //print($query);
			 return $this->getResult($query,$resulttype);
		}
		
		function get_noticias_com_comentarios($arguments=array(),$resulttype='array'){
			$query = 'select distinct n.titulo,
							   n.data_publicacao,
							   nc.noticia_id
									  
						from jornal.v$noticia n
						inner join jornal.v$noticia_comentario nc
						 on nc.noticia_id = n.noticia_id
						inner join jornal.v$comentario c
						 on c.comentario_id = nc.comentario_id
						
						where 1=1
							and n.cod_portal like upper(\''. $arguments['cod_portal'] . '\')';
							
				   if(isset($arguments['status']))
						$query .= ' and c.status = ' . $arguments['status'];
				   if(isset($arguments['tipo']))
						$query .= ' and c.tipo_id = ' . $arguments['tipo'];
				   if(isset($arguments['ordem'])){
				   		switch($arguments['ordem']){
							case 'NOTICIA': $query .= ' order by titulo';break;
							case 'DATA':    $query .= ' order by n.data_publicacao desc';break;
							case 'ALEATORIO': $query .= ' order by dbms_random.value';break;
						}
					}			
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		function get_blogs_com_comentarios($arguments=array(),$resulttype='array'){
			$query .= ' select distinct (mensagem_id),titulo, data_publicacao
							from(select bm.mensagem_id,bm.titulo, bm.data_envio as data_publicacao
 
								   from blog.v$blog_mensagem bm
								 inner join blog.v$blog_mensagem_comentario bmc on bmc.mensagem_id = bm.mensagem_id
								 inner join jornal.v$comentario c on bmc.comentario_id = c.comentario_id
								 
								  where 1=1
									  and cod_portal = \''.$arguments['cod_portal'].'\'';
						if(strlen(trim($arguments['blog_id'])))
							$query .= ' and blog_id = '.$arguments['blog_id'];		
						if(strlen(trim($arguments['mensagem_id'])))
							$query .= ' and bm.mensagem_id = '.$arguments['mensagem_id'];
						if(strlen(trim($arguments['status'])))
							$query .= ' and c.status = '.$arguments['status'];
						if(strlen(trim($arguments['tipo'])))
							$query .= ' and c.tipo_id = '.$arguments['tipo'];
						if(strlen(trim($arguments['num_dias'])))
							$query .= ' and date_insert = sysdate - '.$arguments['num_dias'];
						if(strlen(trim($arguments['ordem'])) && $arguments['ordem'] == 'DATA')
							$query .= ' order by c.date_insert desc';
						$query .= ')';
						//print($query);
						return $this->getResult($query,$resulttype);
		}
		
		
		
		/* Busca os comentarios do blog */
		function get_blog_comentario($arguments=array(),$resulttype='array') {			
			$query = '
				select c.comentario_id,
					   c.assunto,
					   c.texto,
					   c.nota_id,
					   to_char(c.data_insercao,\'dd/mm/yyyy hh24:mi:ss\') as data_insercao,
					   c.usuario_insercao,
					   u.nome as nome_usuario,
					   u.cidade||\'-\'||u.uf as cidade_usuario,					   
					   to_char(c.data_aprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_aprovacao,
					   c.usuario_aprovacao,
					   to_char(c.data_reprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_reprovacao,
					   c.usuario_reprovacao,
					   c.status,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site,
					   c.nome,
					   c.aprovado,
					   c.usuario_abusivo,
					   c.tipo_id,
					   c.texto_abusivo,
					   c.nome_abusivo,
					   b.titulo || \' - \' || bm.titulo as titulo
				  from jornal.v$comentario c
				 inner join jornal.v$blog_mensagem_comentario bc on bc.comentario_id = c.comentario_id
				 inner join acesso.v$usuario u on u.email = c.usuario_insercao';
			if(strlen(trim($arguments['grupo_id'])))
				$query .= ' and u.grupo_id = '.$arguments['grupo_id'];
			
			$query .= '
				 inner join jornal.v$blog_mensagem bm on bm.mensagem_id = bc.mensagem_id
 				 inner join jornal.v$blog b on b.blog_id = bm.blog_id
				 where 1=1				 	
				 ';
			   
			if(strlen(trim($arguments['status'])))
				$query .= ' and c.status = '.$arguments['status'];
			if(strlen(trim($arguments['mensagem_id'])))
				$query .= ' and bc.mensagem_id = '.$arguments['mensagem_id'];
			if(strlen(trim($arguments['tipo'])))
				$query .= ' and c.tipo_id = ' . $arguments['tipo'];
			if(strlen(trim($arguments['comentario_id'])))
				$query .= ' and c.comentario_id = '.$arguments['comentario_id'];
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['blog_id'])))
				$query .= ' and bm.blog_id = '.$arguments['blog_id'];
			
			$query .= ' order by c.data_insercao desc ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		
		
		/* Busca os comentarios do blog */
		function get_blog_comentario_novo($arguments=array(),$resulttype='array') {
			$query = '
				select c.comentario_id,
					   c.assunto,
					   c.texto,
					   c.nota_id,
					   to_char(c.data_insercao,\'dd/mm/yyyy hh24:mi:ss\') as data_insercao,
					   c.usuario_insercao,
					   u.nome as nome_usuario,
					   u.cidade||\'-\'||u.uf as cidade_usuario,					   
					   to_char(c.data_aprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_aprovacao,
					   c.usuario_aprovacao,
					   to_char(c.data_reprovacao,\'dd/mm/yyyy hh24:mi:ss\') as data_reprovacao,
					   c.usuario_reprovacao,
					   c.status,
					   to_char(c.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
					   c.user_insert,
					   to_char(c.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
					   c.user_update,
					   c.site,
					   c.nome,
					   c.aprovado,
					   c.usuario_abusivo,
					   c.tipo_id,
					   c.texto_abusivo,
					   c.nome_abusivo,
					   b.titulo || \' - \' || bm.titulo as titulo
				  from jornal.v$comentario c
				 inner join blog.v$blog_mensagem_comentario bc on bc.comentario_id = c.comentario_id
				 inner join acesso.v$usuario u on u.email = c.usuario_insercao';
			if(strlen(trim($arguments['grupo_id'])))
				$query .= ' and u.grupo_id = '.$arguments['grupo_id'];
			
			$query .= '
				 inner join blog.v$blog_mensagem bm on bm.mensagem_id = bc.mensagem_id
 				 inner join blog.v$blog b on b.blog_id = bm.blog_id
				 where 1=1				 	
				 ';
			   
			if(strlen(trim($arguments['status'])))
				$query .= ' and c.status = '.$arguments['status'];
			if(strlen(trim($arguments['not_status'])))
				$query .= ' and c.status <> '.$arguments['not_status'];
			if(strlen(trim($arguments['mensagem_id'])))
				$query .= ' and bc.mensagem_id = '.$arguments['mensagem_id'];
			if(strlen(trim($arguments['tipo'])))
				$query .= ' and c.tipo_id = ' . $arguments['tipo'];
			if(strlen(trim($arguments['comentario_id'])))
				$query .= ' and c.comentario_id = '.$arguments['comentario_id'];
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['blog_id'])))
				$query .= ' and bm.blog_id = '.$arguments['blog_id'];
			
			$query .= ' order by c.data_insercao desc ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}
		

		function get_num_blog_comentarios($arguments=array()){
		
			$query = '
				select 
					count(bc.comentario_id) as num_comentarios
				 from jornal.v$blog_mensagem_comentario bc
				 inner join jornal.v$comentario co
         		 on co.comentario_id = bc.comentario_id
				 where 1=1
				 and co.status = 2
				 
				';
		 	if(strlen($arguments['mensagem_id']))
				$query .= ' and bc.mensagem_id = '.$arguments['mensagem_id'];
				
			return $this->getResult($query);
		}		
		
		
		function get_mural_recados($arguments=array()){
			$query = ' 
						select  recado_id,
							    nome,
								recado,
								bloqueado,
								to_char(date_insert,\'dd/mm/yyyy hh24:mm\') as date_insert,
								cod_portal
					      from  jornal.v$mural_recados 
						 where  1=1 ';
			if(strlen(trim($arguments['cod_portal'])))
				$query .= ' and cod_portal = \'' . $arguments['cod_portal'] . '\'';
			if(strlen(trim($arguments['recado_id'])))
				$query .= ' and  recado_id = ' . $arguments['recado_id'];
			if(strlen(trim($arguments['bloqueado'])))
				$query .= ' and  bloqueado = ' .$arguments['bloqueado'];
			
			$query .= ' order by recado_id desc';
			//print($query);
			return $this->getResult($query);		
		}
		
		
		function get_comentario_avaliacao($arguments=array()){
			$query = ' select avaliacao_id,
							   comentario_id,
							   avaliacao,
							   descricao,
							   usuario,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from jornal.v$comentario_avaliacao
						 where  1=1 ';
			if(strlen(trim($arguments['comentario_id'])))
				$query .= ' and  comentario_id = ' . $arguments['comentario_id'];
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and  usuario = \'' . $arguments['usuario'] . '\'';
			if(strlen(trim($arguments['avaliacao'])))
				$query .= ' and  avaliacao = ' .$arguments['avaliacao'];

			//print($query);
			return $this->getResult($query);		
		}
		
		
		
		
	}
	global $conexao_banco;
	$ComentarioConsultaObj = new ComentarioConsulta($conexao_banco);
}

global $createdObject;
$createdObject = $ComentarioConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	eval("\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx');");
}
?>