<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");
global $CinemaComObj;
if(!$CinemaComObj) {
	class CinemaCom extends QueryCom {
		
		function get_cinema_sala($arguments=array(),$resulttype = 'array'){
			$query = 'select s.sala_id,
					   s.cinema_id,
					   s.descricao,
					   s.date_insert,
					   s.user_insert,
					   s.date_update,
					   s.user_update,
					   s.site
				  from cinema.v$cinema_sala s 
				 where 1=1				   
				   and s.cinema_id = '.$arguments["cinema_id"].'
				 order by descricao';
			
			return $this->getResult($query,$resulttype);
		}
		
		function get_cinema($arguments=array(),$resulttype = 'array'){
			$query = 
			'select c.cinema_id,
				   c.nome,
				   c.url_logotipo,
				   referencia_id,
				   situacao_id,
				   c.municipio_id,				  
				   c.date_insert,
				   c.user_insert,
				   c.date_update,
				   c.user_update,
				   c.site
			  from cinema.v$cinema c
			  
			 where 1=1 
			 
			 and cod_portal =\'' . $arguments['cod_portal'] . '\'';
			 if(strlen($arguments['cinema_id']))
			 	$query .= ' and c.cinema_id in ('.$arguments["cinema_id"].') ';
			 $query .= ' order by c.nome ';

		  return $this->getResult($query,$resulttype);
		}
		
		function get_filme($arguments=array()){
			$query = 
			'select f.filme_id,
				   f.cod_portal,
				   f.titulo,
				   f.titulo_original,
				   f.sinopse,
				   f.diretor,
				   f.elenco,
				   f.producao,
				   f.roteiro,
				   f.fotografia,
				   f.trilha_sonora,
				   f.duracao,
				   extract(day from duracao)*24*60+extract(hour from duracao)*60+extract(minute from duracao) as duracao_minutos,
				   f.ano,
				   f.pais,
				   f.categoria_id,
				   fc.descricao as categoria,
				   f.classificacao,
				   f.site_filme,
				   f.censura,
				   to_char(f.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   f.user_insert,
				   to_char(f.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   f.user_update,
				   f.site
			  from cinema.v$filme f
			 inner join cinema.v$filme_categoria fc
			         on fc.categoria_id = f.categoria_id
			 where 1=1 
			   and f.cod_portal = \'' . $arguments['cod_portal'] . '\'';
			 if(strlen($arguments['filme_id']))
			 	$query .= ' and f.filme_id in ('.$arguments["filme_id"].') ';
			 if(strlen($arguments['data_inicial']))
			 	$query .= ' and trunc(f.date_insert) >= \''.$arguments["data_inicial"].'\' ';
			 if(strlen($arguments['data_final']))
			 	$query .= ' and trunc(f.date_insert) <= \''.$arguments["data_final"].'\' ';
			 if(strlen($arguments['nome']))
			 	$query .= ' and kss.pkg_string.fnc_string_clean(upper(trim(f.titulo))) like kss.pkg_string.fnc_string_clean(upper(trim(\'%'.$arguments["nome"].'%\'))) ';
			 $query .= ' order by f.titulo ';
		
		  //print($query); 			 
		  return $this->getResult($query);
		}

		function get_filme_imagem($arguments=array()){
			$query = 
			'select fi.filme_id,
				   fi.foto_id,
				   f.url_imagem,
				   f.largura as largura_original,
				   f.altura as altura_original,
				   f.tipo,
				   f.tamanho as tamanho_original,
				   f.categoria_id,
				   fi.ordem,
				   fi.titulo,
				   fi.legenda,
				   fi.descricao,
				   fi.credito,
				   fi.largura,
				   fi.altura,
				   to_char(fi.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   fi.user_insert,
				   to_char(fi.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   fi.user_update,
				   fi.site
			  from cinema.v$filme_imagem fi
			 inner join site.v$foto f
					 on f.foto_id = fi.foto_id
			 where 1=1 ';
			 if(strlen($arguments['filme_id']))
			 	$query .= ' and fi.filme_id in ('.$arguments["filme_id"].') ';
		  return $this->getResult($query);
		}
			
		function get_filme_video($arguments=array()){
			$query = 
			'select fv.filme_id,
				   fv.video_id,
				   v.cod_video,
				   v.duracao,
				   fv.ordem,
				   fv.titulo,
				   fv.legenda,
				   fv.descricao,
				   fv.credito,
				   to_char(fv.date_insert,\'dd/mm/yyyy hh24:mi:ss\') as date_insert,
				   fv.user_insert,
				   to_char(fv.date_update,\'dd/mm/yyyy hh24:mi:ss\') as date_update,
				   fv.user_update,
				   fv.site
			  from cinema.v$filme_video fv
			 inner join site.v$video v
			         on v.video_id = fv.video_id
			 where 1=1 ';
			 if(strlen($arguments['filme_id']))
			 	$query .= ' and fv.filme_id in ('.$arguments["filme_id"].') ';
			 if(strlen($arguments['ordem']))
			 	$query .= ' order by ordem asc';
			//print($query);
		  return $this->getResult($query);
		}
		
		function get_filme_detalhes($arguments=array()){
			$query = 'select filme_id,
							   cod_portal,
							   upper(f.titulo) as titulo,
							   titulo_original,
							   sinopse,
							   diretor,
							   elenco,
							   producao,
							   roteiro,
							   fotografia,
							   trilha_sonora,
							   duracao,
							   ano,
							   pais,
							   f.categoria_id,
							   classificacao,
							   site_filme,
							   censura,
							   initCap(fc.descricao) as descricao,
							   st.url_imagem,
							   st.foto_id
						  from cinema.v$filme f
						  inner join cinema.v$filme_categoria fc
							on f.categoria_id = fc.categoria_id
						  left join cinema.v$filme_imagem fi
						    on f.filme_id = fi.filme_id
						  inner join site.v$foto st
						    on st.foto_id = fi.foto_id
						  
						   
						 where 1=1';
				 
				 if(isset($arguments['filme_id']))
				 	$query .= ' and f.filme_id  = ' . $arguments['filme_id'];
			     if(isset($arguments['ordem'])){
				 	$query .= ' and fi.ordem = (select MIN(ordem) from cinema.v$filme_imagem fi1
                                    where fi1.filme_id = f.filme_id)';
				 }
				 
				$query .= ' and cod_portal like \'' . $arguments['cod_portal'] .'\'';			
				//print($query);
				return $this->getResult($query);
		
		}
		
		function get_filme_horario($arguments=array()){			
			$query = 'select filme_id,
							 cod_portal,
							 upper(f.titulo) as titulo,
							 titulo_original,
							 sinopse,
							 diretor,
							 elenco,
							 producao,
							 roteiro,
							 fotografia,
							 trilha_sonora,
							 duracao,
							 ano,
							 pais,
							 f.categoria_id,
							 classificacao,
							 site_filme,
							 censura,
							 initCap(fc.descricao) as descricao,
							 st.url_imagem,
							 st.foto_id,
							 c.nome,
							 fh.data
							from cinema.v$filme f
							inner join cinema.v$filme_categoria fc
							on f.categoria_id = fc.categoria_id
							inner join cinema.v$filme_imagem fi
							on f.filme_id = fi.filme_id
							inner join site.v$foto st
							on st.foto_id = fi.foto_id
							inner join cinema.v$filme_horario fh
							on fh.filme_id = f.filme_id
							inner join cinema.v$cinema_sala cs
							on cs.sala_id = fh.sala_id
							inner join cinema.v$cinema c
							on c.cinema_id = cs.cinema_id
								   
					 where 1=1
            
					  and cod_portal = \'' .$arguments['cod_portal'] .'\'';
					  
			  if(isset($arguments['data']))
			  	$query .= ' and data >= \'' . $arguments['data'] . '\'';
			  if(isset($arguments['ordem'])){
			  	switch($arguments['ordem']){
					case 0 : $query .= ' order by dbms_random.value';break;
					case 1 : $query .= ' order by f.titulo';break;
					case 2 : $query .= ' order by c.nome';break;
				}
			  }
			
			//print($query);
			return $this->getResult($query);		
		}
		
		
		function get_horarios_listagem($arguments=array()){			
			$query = 'select distinct
						   cinema_id,
                		   nome,
						   sala_id,
						   sala,
						   filme_id,
						   filme,
						   kss.fnc_concat_all(kss.to_concat_expr(hora, \', \')) over(partition by sala_id,filme_id,dia_semana,legendado order by hora rows between unbounded preceding and unbounded following) hora,
						   dia_semana,
						   municipio,
						   data,
						   legendado as legenda,
						   decode(legendado,0,\'Dublado\',1,\'Legendado\') legendado
					from (select distinct sala_id,
										sala,
										filme_id,
										filme,
										hora,
										cinema_id,
										nome,
										municipio,
										kss.fnc_concat_all(kss.to_concat_expr(dia_semana,
																			  \',\')) over(partition by sala_id, filme_id, hora order by data rows between unbounded preceding and unbounded following) dia_semana,
										kss.fnc_concat_all(kss.to_concat_expr(data, \',\')) over(partition by sala_id, filme_id, hora order by data rows between unbounded preceding and unbounded following) data,
										legendado
					  from (select ch.horario_id,
								   ch.sala_id,
								   s.descricao sala,
								   ch.filme_id,
								   f.titulo filme,
								   c.cinema_id,
								   c.nome,
								   cm.municipio,
								   to_char(ch.data, \'hh24:mi\') hora,
								   case to_char(ch.data, \'D\')
									 when \'1\' then
									  	\'Dom\'
									 when \'2\' then
									  \'Seg\'
									 when \'3\' then
									  \'Ter\'
									 when \'4\' then
									  \'Qua\'
									 when \'5\' then
									  \'Qui\'
									 when \'6\' then
									  \'Sex\'
									 when \'7\' then
									  \'Sb\'
									 else
									  \'Erro\'
								   end dia_semana,
								   to_char(ch.data, \'dd/mm/yyyy\') data,
								   legendado
							  from cinema.v$cinema_sala s';
							  
						if(isset($arguments['exibicao'])){
							$query .= '  inner join cinema.v$cinema c on c.cinema_id = s.cinema_id   
							 			 inner join cinema.v$filme_horario ch on s.sala_id = ch.sala_id  
							 			 inner join cinema.v$filme f on f.filme_id = ch.filme_id 
										 inner join cep.municipio cm on cm.municipio_id = c.municipio_id';
										 
						
						}else{
							$query .= '	 left join cinema.v$cinema c on c.cinema_id = s.cinema_id   
							 			 left join cinema.v$filme_horario ch on s.sala_id = ch.sala_id  
							 			 left join cinema.v$filme f on f.filme_id = ch.filme_id 
										 inner join cep.municipio cm on cm.municipio_id = c.municipio_id';
						}
						
						if(isset($arguments['com_imagem']))
							$query .= ' inner join cinema.v$filme_imagem fi on f.filme_id = fi.filme_id';
							
						$query .= ' where 1 = 1 
								   and c.cod_portal like \'' . $arguments['cod_portal'] . '\'';
								 
						if( isset($arguments['titulo']))
							$query .= ' and upper(f.filme) like upper(%' . $arguments['titulo'] . '%)';
						if( isset($arguments['cinema_id']))
							$query .= ' and c.cinema_id = ' . $arguments['cinema_id'];
						if( isset($arguments['filme_id']))							
							$query .= ' and ch.filme_id = ' . $arguments['filme_id'];
						if( isset($arguments['data']))
							$query .= ' and ch.data >= \'' . $arguments['data'] . '\'';
						
						$query .= '	   order by hora,dia_semana))';
			
			if(isset($arguments['ordem'])){
				switch($arguments['ordem']){					
					case 1 : $query .= ' order by filme,cinema_id,sala';break;
					case 2 : $query .= ' order by dbms_random.value';break;
				}
			}else
				$query .= ' order by cinema_id, sala, filme';
				
			//print($query);
			return $this->getResult($query);
		}

		
	}
	global $conexao_banco;
	$CinemaComObj = new CinemaCom($conexao_banco);
}

global $createdObject;
$createdObject = $CinemaComObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>