<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $BlogConsultaObj;
if(!$BlogConsultaObj) {
	class BlogConsultaCom extends QueryCom {
	
	
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as categorias
		 */
		function get_blog_categorias($arguments=array()){
			//new dBug($arguments);
			$query = 'select ';
			
			if(strlen($arguments['exibir']) && $arguments['exibir'] == "colunas")
				$query .='distinct ';
				
			$query .= '   c.categoria_id,
						  c.categoria_pai_id,
						  c.descricao						  
					  from jornal.v$blog_categoria c ';
					  if(strlen($arguments['exibir']) && $arguments['exibir'] == "colunas")
					  	$query .= 'inner join jornal.v$blog b on c.categoria_id = b.categoria_id 
						           inner join jornal.v$blog_mensagem bm on b.blog_id = bm.blog_id ';
							
		    $query .= 'where 1=1 and c.cod_portal = \'' .$arguments["cod_portal"].'\'';
					  if(strlen($arguments['categoria_id']))
			 			$query .= ' and c.categoria_id = '.$arguments["categoria_id"].' ';
					  if(strlen($arguments['exclusiva']))
			 			$query .= ' and c.exclusiva = '.$arguments["exclusiva"].' ';
					  if(strlen($arguments['descricao']))
			 		  	$query .= ' and strtoupper(c.descricao) LIKE \'%'.strtoupper($arguments["descricao"]).'%\' ';
					  if(strlen($arguments['ordem_exibicao']) && $arguments['ordem_exibicao'] == "alfa")
					  	$query .= ' order by c.descricao asc';
					  if(strlen($arguments['ordem_exibicao']) && $arguments['ordem_exibicao'] == "random")
					  	$query .= ' order by dbms_random.random';
					  else
						$query .= ' order by c.descricao';								
			return $this->getResult($query);
			
		}
		
		/* fim get_blog_categorias */
		
		
		/* Busca as categorias de Blogs */
		function get_blog_categoria($arguments=array(),$resulttype='array') {
			$query = '
					select bc.categoria_id,
						   bc.categoria_pai_id,
						   level,
						   lpad(\' \',level-1,\' \') ident,
						   sys_connect_by_path(descricao,\' / \') path,
						   bc.descricao,
						   bc.date_insert,
						   bc.user_insert,
						   bc.date_update,
						   bc.user_update,
						   bc.site,
						   bc.cod_portal
					  from blog.v$blog_categoria bc
					 where bc.cod_portal = \''.$arguments['cod_portal'].'\' ';
			if(strlen(trim($arguments['categoria_id'])))
				$query .= ' and bc.categoria_id = '.$arguments['categoria_id'];
			 if(strlen($arguments['exclusiva']))
			 	$query .= ' and bc.exclusiva = '.$arguments["exclusiva"];
			$query .= '
					 start with bc.categoria_pai_id is null
					connect by prior bc.categoria_id = bc.categoria_pai_id
					 order siblings by bc.descricao
			 ';
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
				
			//print($query);
		    return $this->getResult($query,$resulttype);
		}		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as categorias
		 */
		function get_colunistas( $arguments=array() ){		
		
			$query = 'select 
						  c.colunista_id,
						  c.nome,
						  c.situacao_id,
						  c.atividade,
						  c.historico_profissional,
						  c.url_imagem,
						  c.email,
						  c.cod_portal,
						  c.foto_id,
						  c.colunista_externo,
						  c.foto_id as foto_colunista
					  from jornal.v$colunista c
					  where 1=1 and c.cod_portal = \''.$arguments["cod_portal"].'\'';
					  if(strlen($arguments['nome']))
			 		  	$query .= ' and strtoupper(c.nome) LIKE \''.strtoupper($arguments["nome"]).'%\' ';
					  if(strlen($arguments['email']))
			 		  	$query .= ' and upper(c.email) = \''.strtoupper($arguments["email"]).'\'';
					  if(strlen($arguments['colunista_id']))
			 		  	$query .= ' and c.colunista_id = ' . $arguments["colunista_id"];
					  if(strlen(trim($arguments['colunista_externo'])))
					  	$query .= ' and colunista_externo='.$arguments['colunista_externo'];
					  $query .= ' order by c.nome asc';
		   		
			//print($query);
			return $this->getResult($query);			
			
			
		}
		/* fim get_blog_categorias */
		
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todos os colunistas, para pgina de colunistas
		 */
		function get_colunistas_home($arguments=array()){		
		
							 
			 $query = 'select distinct
							  c.colunista_id,
							  nvl(b.titulo,c.nome) as nome,
							  c.situacao_id,
							  c.atividade,
							  c.historico_profissional,
							  c.url_imagem,
							  c.email,
							  c.cod_portal,
							  c.date_insert,
							  nvl(b.logo_id,c.foto_id) as foto_id,
							  bc.categoria_id,
							  bc.descricao,
							  b.blog_id,
							  b.titulo,
							  b.ativo,
							  b.tipo,
							  bm.mensagem_id,
                			  bm.date_insert
						from blog.v$colunista c
						inner join blog.v$blog b
						on b.colunista_id = c.colunista_id
						inner join blog.v$blog_categoria bc
						on bc.categoria_id = b.categoria_id
						inner join blog.v$blog_mensagem bm
            			on bm.blog_id = b.blog_id
						where 1=1 
						and b.ativo = 1 
						and c.situacao_id = 1
						and bm.data_envio = (select max(bm2.data_envio)
						                        from blog.v$blog_mensagem bm2
                                   			  where bm2.blog_id = bm.blog_id ';
						if(strlen(trim($arguments['data_exibicao'])))
							$query .= ' and bm2.data_exibicao <= \''.$arguments['data_exibicao'].'\'';
							$query .= '	)
						and c.cod_portal = \''.$arguments["cod_portal"].'\'';
						if(strlen($arguments['nome']))
			 		  		$query .= ' and c.nome LIKE \''.$arguments["nome"].'%\' ';
					    if(strlen($arguments['colunista_id']))
			 		  		$query .= ' and c.colunista_id = ' . $arguments["colunista_id"] . ' and tipo=2';
						if(strlen($arguments['blog_id']))
			 		  		$query .= ' and b.blog_id = ' . $arguments["blog_id"];
						if(strlen($arguments['categoria_id']))
			 		  		$query .= ' and bc.categoria_id = '.$arguments["categoria_id"];
						if(strlen($arguments['tipo']) && ($arguments['tipo'] != "todos"))
							$query .= ' and b.tipo = '.$arguments['tipo'];
						if(strlen($arguments['exibir_categoria']) && $arguments['exibir_categoria'] != "todas")
								$query .= ' and bc.categoria_id = ' . $arguments['exibir_categoria'];							
					    if(strlen(trim($arguments['indicado'])))
							$query .= ' and b.indicado = '.$arguments['indicado'];
						
						if(strlen($arguments['ordem_exibicao'])){
							if($arguments['ordem_exibicao'] == "random"){															
								$query .= ' order by dbms_random.random';			
							}else{
								$query .= ' order by bm.mensagem_id desc';								
							}
						}
					    else{
							 $query .= ' order by bm.mensagem_id desc';							
					    }					
					   						
					//print($query);	
			return $this->getResult($query);
			
		}
		/* fim get_blog_categorias */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todos dos colunistas para o Objeto - BlogPrincipal
		 */
		function get_colunistas_principal($arguments=array()){		
			$query = 'select * from (select distinct
							  c.colunista_id,
							  nvl(b.titulo,c.nome) as nome,
							  c.nome nome_colunista,
							  c.situacao_id,
							  c.atividade,
							  c.historico_profissional,
							  c.url_imagem,
							  c.email,
							  c.cod_portal,
							  c.date_insert,
							  b.exibir_email,
							  nvl(b.logo_id,c.foto_id) as foto_id,
							  b.logo_id,
                        	  c.foto_id as foto_colunista,
							  bc.categoria_id,
							  bc.descricao,
							  b.blog_id,
							  b.tipo,
							  b.indicado,
							  b.descricao as perfil_blog,
							  nvl(b.descricao,
								nvl(c.historico_profissional, c.atividade)) as atividade_blog,
							  nvl(b.descricao,
								nvl(c.atividade, c.historico_profissional)) as historico_blog
						from blog.v$colunista c
						inner join blog.v$blog b on b.colunista_id = c.colunista_id
						inner join blog.v$blog_categoria bc on bc.categoria_id = b.categoria_id';
				if(strlen(trim($arguments['somente_colunista'])))
					$query .= ' left ';
				else
					$query .= ' inner ';
				$query .= ' join blog.v$blog_mensagem bm on bm.blog_id = b.blog_id
						where 1=1 and b.ativo = 1 and c.cod_portal = \''.$arguments["cod_portal"].'\'';
						if(strlen($arguments['nome']))
			 		  		$query .= ' and c.nome LIKE \''.$arguments["nome"].'%\' ';
					    if(strlen($arguments['colunista_id']))
			 		  		$query .= ' and c.colunista_id = ' . $arguments["colunista_id"];
						if(strlen($arguments['blog_id']))
			 		  		$query .= ' and b.blog_id = ' . $arguments["blog_id"];
						if(strlen($arguments['categoria_id']))
			 		  		$query .= ' and bc.categoria_id = '.$arguments["categoria_id"];
						if(strlen($arguments['tipo']) && ($arguments['tipo'] != "todos") )
							$query .= ' and b.tipo = '.$arguments['tipo'];
						if(strlen(trim($arguments['indicado'])))
							$query .= ' and b.indicado = '.$arguments['indicado'];
						if(strlen($arguments['exibir_categoria']) && $arguments['exibir_categoria'] != "todas"){					  		
								$query .= ' and bc.categoria_id = ' . $arguments['exibir_categoria'];							
					    } 
						if(strlen($arguments['ordem_exibicao'])){
							if($arguments['ordem_exibicao'] == "random"){															
								$query .= ' order by dbms_random.random';										
							}else{
								$query .= ' order by c.date_insert desc';								
							}
						}
					    else{
							 $query .= ' order by c.date_insert desc';							
					    }
						
		   		$query .= ') where rownum between 0 and '.$arguments['num_exibicoes'];
										
				//print($query);					
			return $this->getResult($query);
		}
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as colunas/blogs
		 */
		function get_colunas( $arguments=array() ){
			$query = 'select  b.blog_id,
							  b.usuario,
							  c.email as responsavel,
							  b.titulo,
							  b.url_cabecalho,
							  b.data_criacao,
							  b.ativo,
							  b.categoria_id,
							  b.descricao,
							  b.colunista_id,
							  b.tipo,
							  b.cabecalho_id,
							  b.logo_id,
							  b.indicado,
							  b.exibir_email
						 from blog.v$blog b
						inner join blog.v$colunista c on c.colunista_id = b.colunista_id

						where 1=1 
						  and b.cod_portal = \''.$arguments["cod_portal"].'\'';
			if(strlen($arguments['ativo']))
				$query .= ' and b.ativo = ' . $arguments["ativo"];
			if(strlen($arguments['indicado']))
				$query .= ' and b.indicado = ' . $arguments["indicado"];
			if(strlen($arguments['tipo']))
				$query .= ' and b.tipo = ' . $arguments["tipo"];
			if(strlen($arguments['titulo']))
				$query .= ' and upper(b.titulo) like upper(\'%'.$arguments["titulo"].'%\') ';
			if(strlen($arguments['blog_id']))
				$query .= ' and b.blog_id = ' . $arguments["blog_id"];
			if(strlen($arguments['categoria_id']))
				$query .= ' and nvl(b.categoria_id,-1) = ' . $arguments["categoria_id"];
			if(strlen(trim($arguments['colunista_externo'])))
				$query .= ' and c.colunista_externo = '.$arguments['colunista_externo'];
			$query .= 'order by b.titulo asc';
			//print($query);
			return $this->getResult($query);
		}
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas os usuarios do blog
		 */
		function get_blog_usuario( $arguments=array() ){
			$query = '  select bu.blog_id,
								   bu.usuario,
								   bu.tipo,
								   bu.bloqueado,
								   u.apelido
							
							from blog.v$blog_usuario bu
							inner join acesso.v$usuario u on u.email = bu.usuario
						where 1=1  ';
			if(strlen($arguments['bloqueado']))
				$query .= ' and bu.bloqueado = ' . $arguments["bloqueado"];
			if(strlen($arguments['usuario']))
				$query .= ' and bu.usuario = \''.$arguments["usuario"].'\' ';
			if(strlen($arguments['blog_id']))
				$query .= ' and bu.blog_id = ' . $arguments["blog_id"];
			if(strlen(trim($arguments['grupo_id'])))
				$query .= ' and u.grupo_id = '.$arguments['grupo_id'];

			$query .= ' order by bu.tipo,bu.usuario asc';
			//print($query);
			return $this->getResult($query);
		}
		
		/* fim get_blog_categorias */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as Mensagens do Blog
		 */
		function get_blog_mensagem( $arguments=array() ){
			$query = 'select
						  bm.mensagem_id,
						  bm.blog_id,
						  bm.titulo,
						  bm.data_envio,
						  bm.usuario,
						  bm.texto,
						  bm.data_exibicao,
						  bm.em_avaliacao,
						  bm.bloqueada,
						  bm.aprovada,
						  bm.usuario_denuncia,
						  bm.nome_denuncia,
						  bm.texto_denuncia,
						  to_char(bm.data_exibicao,\'hh24:mi\') as hora_exibicao,
						  to_char(bm.data_exibicao,\'dd/mm/yyyy hh24:mi:ss\') as data_hora_exibicao,
						  (select avg(avaliacao)
							 from blog.v$mensagem_avaliacao ma
							where ma.mensagem_id = bm.mensagem_id) media_avaliacao
					  from blog.v$blog_mensagem bm
					  inner join blog.v$blog b
            		  on b.blog_id = bm.blog_id
					  where 1=1 and b.ativo = 1 and bm.cod_portal = \''.$arguments["cod_portal"].'\'';
					  if(strlen($arguments['mensagem_id']))
					  	$query .= ' and bm.mensagem_id = '.$arguments["mensagem_id"];
					  if(strlen($arguments['blog_id']))
					  	$query .= ' and bm.blog_id = '.$arguments["blog_id"];
					  if(strlen($arguments['em_avaliacao']))
					  	$query .= ' and bm.em_avaliacao = '.$arguments["em_avaliacao"];
					  if(strlen($arguments['bloqueada']))
					  	$query .= ' and bm.bloqueada = '.$arguments["bloqueada"];
					  if(strlen($arguments['aprovada']))
					  	$query .= ' and bm.aprovada = '.$arguments["aprovada"];
					  if(strlen(trim($arguments['mes'])))
					  	$query .= ' and to_char(data_exibicao,\'mm\') = '.$arguments['mes'];
					  if(strlen(trim($arguments['ano'])))
					  	$query .= ' and to_char(data_exibicao,\'yyyy\') = '.$arguments['ano'];
					  if(strlen($arguments['titulo']))
					  	$query .= ' and upper(bm.titulo) LIKE \'%'.strtoupper($arguments["titulo"]).'%\' ';
					
					$query .= ' order by bm.data_envio desc'; 			 
			 //print($query);
			 return $this->getResult($query); 
		}
		/* fim get_mensagem_blog */
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna as 
		 */
		function get_mensagem_avaliacao( $arguments=array() ){
			$query = 'select avaliacao_id,
							   mensagem_id,
							   usuario,
							   avaliacao,
							   descricao,
							   date_insert,
							   user_insert,
							   date_update,
							   user_update,
							   site
						  from blog.v$mensagem_avaliacao
						 where 1=1 ';
						 
					  if(strlen($arguments['mensagem_id']))
					  	$query .= ' and mensagem_id = '.$arguments["mensagem_id"];
					  if(strlen($arguments['avaliacao_id']))
					  	$query .= ' and avaliacao_id = '.$arguments["avaliacao_id"];
					  if(strlen($arguments['usuario']))
					  	$query .= ' and usuario = \''.$arguments["usuario"].'\'';
			 
			 //print($query);
			 return $this->getResult($query); 
		}
		/* fim get_mensagem_blog */
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as postagens - Objeto
		 */
		function get_postagens( $arguments=array() ){
			$query = 'select * from (select 
									c.colunista_id,
									c.nome,
									c.situacao_id,
									c.atividade,
									c.historico_profissional,
									c.url_imagem,
									c.email,
									c.cod_portal,
									bm.data_exibicao,
									to_char(bm.data_exibicao) as data_exibicao_completa,
									bm.date_insert,
									bc.categoria_id,
									bc.descricao,
									b.blog_id,';
					if(strlen(trim($arguments['usuario'])))
						$query .= '	bu.tipo,';
						
					$query .= '		b.titulo as blog_titulo,
									bm.mensagem_id,									
									bm.titulo,									
									to_char(bm.data_envio) as data_envio,
									to_date(bm.data_envio,\'DD/MM/YYYY HH24:MI:SS\') as data_envio_post,
									to_char(bm.data_envio, \'DD/MM/YYYY\') as data_envio_ex,
									bm.texto,
               						u.nome as usuario_insercao,
									u.email as email_insercao,
									(select max(c2.colunista_id)
									  from blog.v$colunista c2
									 where c2.email = bm.usuario) colunista_postagem';
									
					if(strlen(trim($arguments['total_comentarios']))){
						$query .= ' ,(select count(bmc.comentario_id)
										  from blog.v$blog_mensagem_comentario bmc
										 where bmc.mensagem_id = bm.mensagem_id) as total_comentarios ';
					}
					$query .= '				from blog.v$colunista c
								
									inner join blog.v$blog b on b.colunista_id = c.colunista_id
									inner join blog.v$blog_categoria bc on bc.categoria_id = b.categoria_id
								    inner join blog.v$blog_mensagem bm on bm.blog_id = b.blog_id
									inner join acesso.v$usuario u on u.email = bm.usuario';
					if(strlen(trim($arguments['grupo_id'])))
						$query .= ' and u.grupo_id ='.$arguments['grupo_id'];
					if(strlen(trim($arguments['usuario'])))
						$query .=  ' inner join blog.v$blog_usuario bu on bu.blog_id = b.blog_id and bu.usuario = \''.$arguments['usuario'].'\'';
					$query .= '	where 1=1 
									and b.ativo = 1
									and c.cod_portal = \''.$arguments['cod_portal'].'\'';
									if(strlen($arguments['blog_id']))
								    	$query .=' and b.blog_id = '.$arguments['blog_id'];
									if(strlen($arguments['colunista_id']))
								    	$query .=' and b.colunista_id = '.$arguments['colunista_id'] . ' and tipo=2';
									if(strlen($arguments['mensagem_id']))
								    	$query .=' and bm.mensagem_id = '.$arguments['mensagem_id'];
									if(strlen(trim($arguments['data_exibicao'])))
										$query .=' and bm.data_exibicao <= \''.$arguments['data_exibicao'].'\'';
									if(strlen($arguments['email']))
										$query .= ' and lower(c.email) = lower(\''.$arguments['email'].'\')';
											
			 	$query .= ' order by data_exibicao desc ) where rownum between ';
				if(strlen($arguments['inicio_resultados'])){
					$query .= print($arguments['inicio_resultados']);
				}else{
					$query .= ' 0';
				}
				$query .=  ' and ';
				if(strlen($arguments['fim_resultados'])){
					$query .= $arguments['fim_resultados']; 
				}else{
					$query .= ' 10000000';
				}					
				
				//print($query);							
				
			return $this->getResult($query);
		}
		/* fim get_postagens */
		
		
		
		
		
		/*
		*
		* Retorna o nmero de posts do colunista
		*/
		function get_numero_posts( $arguments=array() ){
		
				
			$query = '
						select * from (
							select  c.colunista_id,
									c.nome,
									bm.texto,
									bm.titulo,
									to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									count(*) over(partition by c.colunista_id) n_posts,
									row_number() over(partition by c.colunista_id order by c.nome asc) number_row
							 from jornal.v$colunista c
							 inner join jornal.v$blog b on b.colunista_id = c.colunista_id
							 inner join jornal.v$blog_categoria bc on bc.categoria_id = b.categoria_id
							 inner join jornal.v$blog_mensagem bm on bm.blog_id = b.blog_id
							 where 1=1
							 and c.cod_portal = \''.$arguments['cod_portal'].'\'';
							
							 if(strlen($arguments['colunista_id'])){	  
							 	$query .= ' and c.colunista_id ='.$arguments['colunista_id'];								
							 }
							 
			$query .= ') posts where 1=1 order by posts.data_envio desc';
		
			return $this->getResult($query);
		}
		
		
		function get_posts_arquivo( $arguments=array() ){
		
					
			$query = 'select to_char(b.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
						  to_char(b.data_envio, \'MM\') as mes_num,              
						  count(*) as num_posts,
						  b.blog_id
						  from jornal.v$blog_mensagem b
						  left join jornal.v$blog bb on bb.blog_id = b.blog_id
						  left join jornal.v$colunista c on c.colunista_id = bb.colunista_id 
						  where 1 = 1 and c.cod_portal =\''.$arguments['cod_portal'].'\'';
							
						 if(strlen($arguments['colunista_id'])){	  
							$query .= ' and c.colunista_id ='.$arguments['colunista_id'];								
						 }
						 if(strlen($arguments['blog_id'])){	  
							$query .= ' and bb.blog_id ='.$arguments['blog_id'];								
						 }
					   
			$query.=' group by to_char(b.data_envio, \'Month\', \'nls_date_language=portuguese\'),
					 to_char(b.data_envio, \'MM\'), b.blog_id         
					 order by mes_num desc';
		
			return $this->getResult($query);
		}
		
		
		function get_posts_mes( $arguments=array() ){
			
			$query = 'select * from (select  c.colunista_id,
									  c.nome,
									  bm.mensagem_id,
									  bm.texto,
									  bm.titulo,
									  bm.blog_id,
									  to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									  count(*) over(partition by c.colunista_id) n_posts,
									  to_char(bm.data_envio, \'MM\') as mes_num,
									  to_char(bm.data_envio, \'YYYY\') as ano_num,									 
									  to_char(bm.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
									  row_number() over(partition by c.colunista_id order by c.nome asc) number_row
								   from jornal.v$colunista c
								   inner join jornal.v$blog b on b.colunista_id = c.colunista_id
								   inner join jornal.v$blog_categoria bc on bc.categoria_id = b.categoria_id
								   inner join jornal.v$blog_mensagem bm on bm.blog_id = b.blog_id
								   where 1=1';
								   if(strlen($arguments['cod_portal'])){
								   		$query .= ' and c.cod_portal = \''.$arguments['cod_portal'].'\'';
								   }								   								  
								   if(strlen($arguments['blog_id'])){
								   		$query .= ' and bm.blog_id ='.$arguments['blog_id'];
								   }
								   if(strlen($arguments['arquivo_mes'])){
								   		$query .= ' and to_char(bm.data_envio, \'MM\') = \''.$arguments['arquivo_mes'].'\''	;
								   }								   
			$query .= ' ) posts where 1=1 order by posts.data_envio desc';
					 
						
			return $this->getResult($query);
		}
		
		/* Busca o nmero de postagens agrupado pelo mes e ano */
		function get_posts_mes_ano( $arguments=array() ){
			
			$query = 'select mes,
						     ano,
							 count(*) as postagens
					    from (select to_char(m.data_envio, \'mm\') as mes,
								     to_char(m.data_envio, \'yyyy\') as ano
								
							    from blog.v$blog_mensagem m
							   where 1=1 ';
								 
								 if(strlen($arguments['blog_id'])){
								   		$query .= ' and blog_id ='.$arguments['blog_id'];
								 }
			$query .= '
								 )
								 group by mes, ano
								 order by ano desc, mes desc';
  			  //print($query);	
			return $this->getResult($query);
		}
		
		
		
		
		
		function get_datas_post( $arguments=array() ){
			
			$query .= 'select distinct to_char(bm.data_exibicao,\'dd/mm/yyyy\') as data_exibicao
						 from blog.v$blog_mensagem bm
						where 1=1 
						  and cod_portal = \''.$_SESSION['cod_portal'].'\'';
			if(strlen(trim($arguments['mes'])))
				$query .= ' and to_char(data_exibicao,\'mm\') = '.$arguments['mes'];
			if(strlen(trim($arguments['ano'])))
				$query .= ' and to_char(data_exibicao,\'yyyy\') = '.$arguments['ano'];
			

			return $this->getResult($query);
		}
			
		
		function get_posts_data( $arguments=array() ){
			
			$query = 'select * from (select  c.colunista_id,
									  c.nome,
									  bm.mensagem_id,
									  bm.texto,
									  bm.titulo,
									  bm.data_exibicao,
									  to_char(bm.data_envio,\'dd/mm/yyyy\') as data_envio,
									  count(*) over(partition by c.colunista_id) n_posts,
									  to_char(bm.data_envio, \'MM\') as mes_num,
									  to_char(bm.data_envio, \'YYYY\') as ano_num,
									  to_char(bm.data_envio, \'Month\', \'nls_date_language=portuguese\') as mes_extenso,
									  row_number() over(partition by c.colunista_id order by c.nome asc) number_row
								   from blog.v$colunista c
								   inner join blog.v$blog b on b.colunista_id = c.colunista_id
								   inner join blog.v$blog_categoria bc on bc.categoria_id = b.categoria_id
								   inner join blog.v$blog_mensagem bm on bm.blog_id = b.blog_id
								   where 1=1';
								   if(strlen($arguments['cod_portal']))
								   		$query .= ' and c.cod_portal = \''.$arguments['cod_portal'].'\'';	  
								   if(strlen($arguments['blog_id']))
											$query .= ' and bm.blog_id ='.$arguments['blog_id'];
								   if(strlen($arguments['data']))
								   		$query .= ' and to_char(bm.data_envio, \'dd/mm/YYYY\') = \''.$arguments['data'].'\''	;
									if(strlen(trim($arguments['data_exibicao']))){
										$query .= ' and trunc(bm.data_exibicao) = \''.$arguments['data_exibicao'].'\'';
										$query .= ' and bm.data_exibicao <= sysdate ';
									}
								   
			$query .= ' ) posts where 1=1 order by posts.data_envio desc';
			
			//print($query);
			return $this->getResult($query);
		}
		
		
		/*
		* Retorna o cabecalho do BLog
		*/
		function get_cabecalho( $arguments=array() ){
		
			
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.cod_portal,
						  b.cabecalho_id
					from blog.v$blog b
					where 1 = 1
					and ativo = 1';
					if(strlen($arguments['cod_portal'])) 
						$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen($arguments['blog_id']))
						$query .= ' and b.blog_id = '.$arguments['blog_id'];
			//print($query);
			return $this->getResult($query);
		}
		
		
		function get_comentarios( $arguments=array() ){
			
			$query = '';
			
			return $this->getResult($query);
			
		}
		
		
		
		
		/*
		* Retorna os Blogs/Colunas do Usuario
		*/
		function get_blogs( $arguments=array() ){
		
			
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.cod_portal,
						  b.tipo,
						  b.exibir_email,
						  c.nome,
						  c.email,
						  c.historico_profissional,
						  c.url_imagem
					from jornal.v$blog b
					inner join jornal.v$colunista c
                    on c.colunista_id = b.colunista_id
					where 1 = 1
					and ativo = 1';
					if(strlen($arguments['cod_portal'])) 
						$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen($arguments['blog_id']))
						$query .= ' and b.blog_id = '.$arguments['blog_id'];
					if(strlen($arguments['email']))
						$query .= ' and upper(c.email) = \''.strtoupper($arguments['email']).'\'';
			
			//print($query);
			return $this->getResult($query);
		}	
		
		
		/*
		* Retorna os Blogs/Colunas do Usuario
		*/
		function get_blog( $arguments=array() ){
			$query = 'select 
						  b.blog_id,
						  b.usuario,
						  b.titulo,
						  b.url_cabecalho,
						  b.data_criacao,
						  b.ativo,
						  b.categoria_id,
						  b.descricao,
						  b.colunista_id,
						  b.cod_portal,
						  b.tipo,
						  b.logo_id,
						  b.cabecalho_id,
						  c.nome,
						  c.email,
						  c.historico_profissional,
						  c.url_imagem
					from blog.v$blog b
					inner join blog.v$colunista c
                    on c.colunista_id = b.colunista_id
					where 1 = 1
					and ativo = 1';
					if(strlen($arguments['cod_portal'])) 
						$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
					if(strlen($arguments['blog_id']))
						$query .= ' and b.blog_id = '.$arguments['blog_id'];
					if(strlen($arguments['email']))
						$query .= ' and upper(c.email) = \''.strtoupper($arguments['email']).'\'';
			
			//print($query);
			return $this->getResult($query);
		}
		
		
		/*
		* Retorna os Blogs/Colunas do Usuario
		*/
		function get_blog_usuario_acesso($arguments=array(),$resulttype='array'){
			$query = 'select bu.blog_id,
							   bu.usuario,
							   bu.tipo,
							   bu.bloqueado,
							   b.titulo,
							   (select max(bm.data_envio)
								  from blog.v$blog_mensagem bm
								 where bm.blog_id = bu.blog_id) as ultima_postagem,
							   (select count(bmc.comentario_id)       
									from jornal.v$blog_mensagem_comentario bmc
								   inner join jornal.v$blog_mensagem bm1 on bm1.mensagem_id =bmc.mensagem_id
										 where bm1.blog_id = b.blog_id) as comentarios,
							   (select count(b1.blog_id)
								  from blog.v$blog_mensagem b1
								 where blog_id = bu.blog_id) as postagens
						
						from blog.v$blog_usuario bu
						inner join blog.v$blog b on b.blog_id = bu.blog_id
						
						where 1=1
					  and b.cod_portal=\''.$arguments['cod_portal'].'\'';
			if(strlen(trim($arguments['blog_id'])))
				$query .= ' and bu.blog_id = '.$arguments['blog_id'];
			if(strlen(trim($arguments['usuario'])))
				$query .= ' and upper(bu.usuario) = upper(\''.$arguments['usuario'].'\')';
			if(strlen(trim($arguments['bloqueado'])))
				$query .= ' and bu.bloqueado='.$arguments['bloqueado'];
			
			$query .= ' order by bu.tipo,b.titulo';	
			//print($query);
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		 * Criado em Wed May 28 10:25:16 UTC-0200 2008
		 * Retorna todas as categorias
		 */
		function get_blog_acessos($arguments=array()){
			$query = 'select count(*) total				  
					  from jornal.v$blog_acesso c ';
		    $query .= 'where 1=1 ';					  
		  if(strlen($arguments['blog_id']))
			$query .= ' and c.blog_id = '.$arguments["blog_id"].' ';
			return $this->getResult($query);
			
		}
		
		
		/*
		*
		* Retorna os ltimos blogs com postagens
		*/
		function get_blog_plantao($arguments=array(),$resulttype='array'){
			
			$query .= 'select * from (
			
							 select  b.blog_id,
									 b.usuario,
									 b.titulo,
									 b.url_cabecalho,
									 b.data_criacao,
									 b.ativo,
									 b.date_insert,
									 b.user_insert,
									 b.date_update,
									 b.user_update,
									 b.site,
									 b.categoria_id,
									 b.descricao,
									 b.colunista_id,
									 b.cod_portal,
									 b.tipo,
									 bm.data_envio,
									 bm.texto,
									 bm.titulo as titulo_mensagem, 
									 row_number() over (order by bm.data_envio desc) linha
							from blog.v$blog b
							inner join blog.v$blog_mensagem bm
							on b.blog_id = bm.blog_id  
							where 1=1';
							if(strlen($arguments['tipo']))
								$query .= 'and b.tipo = '.$arguments['tipo'];							
							if(strlen($arguments['cod_portal']))
								$query .= ' and b.cod_portal = \''.$arguments['cod_portal'].'\'';
							if(strlen(trim($arguments['ativo'])))
								$query .= ' and b.ativo = '.$arguments['ativo'];
								
							$query .= ' and bm.mensagem_id = (select max(bm1.mensagem_id)
															    from blog.v$blog_mensagem bm1 
															   where bm1.blog_id = b.blog_id)
										and bm.data_exibicao <= sysdate
											order by bm.date_insert desc';
			
			$query .= ' ) blog where 1=1 and rownum <= '.$arguments['limite'];
			
			if($this->dbtype == "postgresql")
				$query = str_replace('v$','',$query);
			//print($query);
		    return $this->getResult($query,$resulttype);
			
		}
			
		
	}// fim classe
	
	global $conexao_banco;
	$BlogConsultaObj = new BlogConsultaCom($conexao_banco);
}// fim if

global $createdObject;
$createdObject = $BlogConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>