<?php
include_once($_SERVER['DOCUMENT_ROOT']."/_include/header.php");
include_once($_SERVER['DOCUMENT_ROOT']."/_class/funcoes/main.php");

global $BaladaConsultaObj;
if(!$BaladaConsultaObj) {
	class BaladaConsultaCom extends QueryCom {
	
		
		/*
		*
		* Retorna todos os Locais de Baladas
		*/
		function get_local($arguments=array(),$resulttype='array') {
		
			$query = 'select ba.local_id,
						   ba.cod_portal,
						   ba.nome,
						   ba.descricao,
						   ba.logotipo_id,
						   ba.ativo,
						   ba.date_insert,
						   ba.user_insert,
						   ba.date_update,
						   ba.user_update,
						   ba.site
					  from baladas.v$local ba
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and ba.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['local_id']))
					  	$query .= ' and ba.local_id = '.$arguments['local_id'];
				
				$query .= ' order by ba.date_insert desc';
			
			return $this->getResult($query,$resulttype);
		
		}
		
		
		function get_local_exibicao($arguments=array(),$resulttype='array') {
		
			$query .= 'select  ba.local_id,
						   ba.cod_portal,
						   ba.nome,
						   ba.descricao,
						   ba.logotipo_id,
						   ba.ativo,
						   ba.date_insert,
						   ba.user_insert,
						   ba.date_update,
						   ba.user_update,
						   ba.site,
						   co.date_insert              
						from baladas.v$local ba
						left join baladas.v$cobertura co
						on co.local_id = ba.local_id           
						where 1=1';
						if(strlen($arguments['cod_portal']))
					  		$query .= ' and ba.cod_portal = \''.$arguments['cod_portal'].'\'';	
						if(strlen($arguments['local_id']))
					  		$query .= ' and ba.local_id = '.$arguments['local_id'];					
						
				$query .= ' order by co.date_insert desc';
			
			return $this->getResult($query,$resulttype);
		
		}
		
		
		/*
		*
		* Retorna todas as fotos do Local
		*/
		function get_local_foto($arguments=array(),$resulttype='array') {
			
			$query = 'select lc.local_id,
						   lc.foto_id,
						   lc.ordem,
						   lc.titulo,
						   lc.credito,
						   lc.legenda,
						   lc.descricao,
						   lc.altura,
						   lc.largura,
						   lc.date_insert,
						   lc.user_insert,
						   lc.date_update,
						   lc.user_update,
						   lc.site
					  from baladas.v$local_foto lc
					  where 1=1';
					  if(strlen($arguments['local_id']))
					  	$query .= ' and lc.local_id = '.$arguments['local_id'];
			
			return $this->getResult($query,$resulttype);
		}
		
		
		/*
		*
		* Retorna todos os Eventos do Local
		*/		
		function get_evento($arguments=array(),$resulttype='array') {
			
			$query = 'select ev.evento_id,
						   ev.cod_portal,
						   ev.titulo,
						   ev.local_id,
						   ev.data_inicio,
						   to_char(ev.data_inicio, \'DD/MM/YYYY\') as data_inicio_exibicao,
						   ev.data_termino,
						   to_char(ev.data_termino, \'DD/MM/YYYY\') as data_termino_exibicao,
						   ev.exibir_ate,
						   to_char(ev.exibir_ate, \'DD/MM/YYYY\') as data_limite,
						   ev.descricao,
						   ev.logotipo_id,
						   ev.date_insert,
						   ev.user_insert,
						   ev.date_update,
						   ev.user_update,
						   ev.site
					  from baladas.v$evento ev
					  inner join baladas.v$local ba
            			on ba.local_id = ev.local_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and ev.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ev.evento_id = '.$arguments['evento_id'];
				      if(strlen($arguments['local_id']))
					  	$query .= ' and ba.local_id = '.$arguments['local_id'];
					  if(strlen($arguments['ordenar'])){
					  	if($arguments['ordenar'] == 'ultimo')
							$query .= ' order by ev.date_insert desc';
						if($arguments['ordenar'] == 'random')
							$query .= ' order by dbms_random.random';
						if($arguments['ordenar'] == 'alfa')
							$query .= ' order by ev.titulo asc';
						if($arguments['ordenar'] == 'termino')
							$query .= ' order by ev.data_termino asc';
					  } else {
					  	$query .= ' order by ev.date_insert desc';
					  }				 
				//print($query);
			return $this->getResult($query,$resulttype);
			
		}
		
		
		function get_evento_foto($arguments=array(),$resulttype='array') {
			
			$query = 'select ef.evento_id,
						   ef.foto_id,
						   ef.ordem,
						   ef.titulo,
						   ef.credito,
						   ef.legenda,
						   ef.descricao,
						   ef.altura,
						   ef.largura,
						   ef.date_insert,
						   ef.user_insert,
						   ef.date_update,
						   ef.user_update,
						   ef.site
					  from baladas.v$evento_foto ef
					  where 1=1';
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ef.evento_id = \''.$arguments['evento_id'].'\'';
			
			return $this->getResult($query,$resulttype);
			
		}
		
		/*
		*
		* Retorna todas as coberturas do Evento
		*/		
		function get_cobertura($arguments=array(),$resulttype='array') {
			
			$query = 'select co.cobertura_id,
						   co.cod_portal,
						   co.local_id,
						   co.evento_id,
						   co.data,
						   to_char(co.data, \'DD/MM/YYYY\') as data_exibicao,
						   co.logotipo_id,
						   co.date_insert,
						   co.user_insert,
						   co.date_update,
						   co.user_update,
						   co.site,
						   co.titulo,
						   co.descricao,
						   ev.evento_id,
						   ev.titulo as titulo_evento
					  from baladas.v$cobertura co
					  left join baladas.v$evento ev
            		  on ev.evento_id = co.evento_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and co.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['cobertura_id']))
					  	$query .= ' and co.cobertura_id = '.$arguments['cobertura_id'];
					  if(strlen($arguments['local_id']))
					  	$query .= ' and co.local_id = '.$arguments['local_id'];
					  if(strlen($arguments['evento_id']))
					  	$query .= ' and ev.evento_id = '.$arguments['evento_id'];	
						
			
					$query .= ' order by co.date_insert desc';
			
			return $this->getResult($query,$resulttype);
			
		}
		
		
		/*
		*
		* Retorna todas as fotos da cobertura
		*/
		function get_cobertura_foto($arguments=array(),$resulttype='array') {
		
			$query = 'select cf.cobertura_id,
						   cf.foto_id,
						   cf.ordem,
						   cf.titulo,
						   cf.credito,
						   cf.legenda,
						   cf.descricao,
						   cf.altura,
						   cf.largura,
						   cf.date_insert,
						   cf.user_insert,
						   cf.date_update,
						   cf.user_update,
						   cf.site,
						   co.titulo as titulo_cobertura
					  from baladas.v$cobertura_foto cf
					  inner join baladas.v$cobertura co
            		  on co.cobertura_id = cf.cobertura_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and co.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['cobertura_id']))
					  	$query .= ' and cf.cobertura_id = '.$arguments['cobertura_id'];
			
			return $this->getResult($query,$resulttype);
		
		}
		
		/*
		*
		* Retorna as coberturas para listagem da aplicao
		*/
		function get_cobertura_listagem($arguments=array(),$resulttype='array') {
			
			$query = 'select cb.cobertura_id,
						   cb.cod_portal,
						   cb.local_id,
						   cb.evento_id,
						   cb.data,
						   to_char(cb.data, \'DD/MM/YYYY\') as data_exibicao,
						   cb.logotipo_id,
						   cb.date_insert,
						   cb.user_insert,
						   cb.date_update,
						   cb.user_update,
						   cb.site,
						   cb.titulo as titulo_cobertura,
						   cb.descricao,						  
						   ev.titulo,
						   ev.data_inicio,
						   ev.data_termino,
						   ev.descricao as descricao_evento,
						   ev.logotipo_id as logotipo_evento      
					  from baladas.v$cobertura cb					  
					  left join baladas.v$evento ev
					  on ev.evento_id = cb.evento_id
					  where 1=1';
					  if(strlen($arguments['cod_portal']))
					  	$query .= ' and cb.cod_portal = \''.$arguments['cod_portal'].'\'';
					  if(strlen($arguments['local_id']))
					  	$query .= 'and cb.local_id = '.$arguments['local_id'];
					  
			$query .= ' order by cb.date_insert desc';
			
			return $this->getResult($query,$resulttype);
			
		}
			
		
	}// fim classe
	
	global $conexao_banco;
	$BaladaConsultaObj = new BaladaConsultaCom($conexao_banco);
}// fim if

global $createdObject;
$createdObject = $BaladaConsultaObj;

if(isset($_VARS["method"]) && strlen(trim($_VARS["method"]))) {
	try {
		eval("print(\$createdObject->".$_VARS["method"]."(\$_VARS,'wddx'));");
	} catch(Exception $e) {
		print($createdObject->toWddx($e));
	}
}
?>